// bs-magic.inc  -  object descriptions for bs-magic.pov

#declare VioletTex=                                                     //DarkOrchid
  texture { pigment { wrinkles color_map { [0.0 White] [0.7 Yellow] [1.0 Yellow] } scale 0.5 } }

#declare BlueTex=
  texture { pigment { wrinkles color_map { [0.0 White] [0.7 NeonBlue] [1.0 NeonBlue] } scale 0.5 } }

#declare RedTex=
 texture { pigment { wrinkles color_map { [0.0 White] [0.7 Red ] [1.0 Red] } scale 0.5 } }

#declare GreenTex=
 texture { pigment { wrinkles color_map { [0.0 White] [0.7 Green] [1.0 Green] } scale 0.5 } }

#declare cane_texture =
  texture {
    pigment {
      spiral1 3
      color_map { [0.0 White] [0.5 White] [0.9 Red] [1.0 Red] }
    }
    finish { ambient 0.2 diffuse 0.8 phong 0.9 phong_size 200 }
    scale <1.5, 1.5, 1.5>
    rotate x*90
  }

#declare cane2_texture =
  texture {
    pigment {
      spiral1 5
      color_map { [0.0 White] [1.0 Red] }
    }
    finish { ambient 0.2 diffuse 0.8 phong 0.9 phong_size 200 }
    scale <1.5, 1.5, 1.5>
    rotate x*90
  }

#declare cane3_texture =
  texture {
    pigment {
      spiral1 5
      color_map { [0.0 White] [0.4 White] [0.5 Green] [0.6 Yellow] [1.0 Green] }
    }
    finish { ambient 0.2 diffuse 0.8 phong 0.9 phong_size 200 }
    scale <1.5, 1.5, 1.5>
    rotate x*90
  }

#declare cookie1_texture =
  texture {
    pigment {
      spiral1 5
      color_map { [0.0 Tan] [1.0 Sepia] }
    }
    finish { crand 0.2 }
    scale 0.25
    rotate x*90
  }

#declare cookie2_texture =
  texture {
    pigment { DarkBrown }
    normal{
      quilted 0.4
      control0 1 control1 1
      scale 0.2
    }
    finish { crand 0.2 }
  }

#declare cookie3_texture =
  texture {
    pigment { DarkTan }
    normal{
      quilted 0.4
      control0 1 control1 1
      scale 0.2
    }
    finish { crand 0.2 }
  }

#declare cookie4_texture =
  texture {
    pigment { DarkWood }
    finish { crand 0.2 }
  }

#declare gumdrop = merge {
  cone { < 0, 0, 0 >, 0.8, < 0, 1.1, 0 >, 0.7 }
  sphere { < 0, 1.0, 0 >, 0.7 }
}

#declare yellow_gumdrop = object { gumdrop texture { pigment { Yellow } } }
#declare red_gumdrop = object { gumdrop texture { pigment { SpicyPink } } }
#declare blue_gumdrop = object { gumdrop texture { pigment { NeonBlue } } }
#declare green_gumdrop = object { gumdrop texture { pigment { LimeGreen } } }
#declare purple_gumdrop = object { gumdrop texture { pigment { Med_Purple } } }

#declare postholes = union {
  cylinder { < 0, -2.0, -0.5 > < 0, -2.0, 0.5 > 0.05 }
  cylinder { < 0, -1.8, -0.5 > < 0, -1.8, 0.5 > 0.05 }
  cylinder { < 0, -1.6, -0.5 > < 0, -1.6, 0.5 > 0.05 }
  cylinder { < 0, -1.4, -0.5 > < 0, -1.4, 0.5 > 0.05 }
  cylinder { < 0, -1.2, -0.5 > < 0, -1.2, 0.5 > 0.05 }
  cylinder { < 0, -1.0, -0.5 > < 0, -1.0, 0.5 > 0.05 }
  cylinder { < 0, -0.8, -0.5 > < 0, -0.8, 0.5 > 0.05 }
  cylinder { < 0, -0.6, -0.5 > < 0, -0.6, 0.5 > 0.05 }
  cylinder { < 0, -0.4, -0.5 > < 0, -0.4, 0.5 > 0.05 }
  cylinder { < 0, -0.2, -0.5 > < 0, -0.2, 0.5 > 0.05 }
  cylinder { < 0, 0.0, -0.5 > < 0, 0.0, 0.5 > 0.05 }
  cylinder { < 0, 0.2, -0.5 > < 0, 0.2, 0.5 > 0.05 }
  cylinder { < 0, 0.4, -0.5 > < 0, 0.4, 0.5 > 0.05 }
  cylinder { < 0, 0.6, -0.5 > < 0, 0.6, 0.5 > 0.05 }
  cylinder { < 0, 0.8, -0.5 > < 0, 0.8, 0.5 > 0.05 }
  cylinder { < 0, 1.0, -0.5 > < 0, 1.0, 0.5 > 0.05 }
  cylinder { < 0, 1.2, -0.5 > < 0, 1.2, 0.5 > 0.05 }
  cylinder { < 0, 1.4, -0.5 > < 0, 1.4, 0.5 > 0.05 }
  cylinder { < 0, 1.6, -0.5 > < 0, 1.6, 0.5 > 0.05 }
  cylinder { < 0, 1.8, -0.5 > < 0, 1.8, 0.5 > 0.05 }
  cylinder { < 0, 2.0, -0.5 > < 0, 2.0, 0.5 > 0.05 }
  cylinder { < 0, 2.2, -0.5 > < 0, 2.2, 0.5 > 0.05 }
  cylinder { < 0, 2.4, -0.5 > < 0, 2.4, 0.5 > 0.05 }
  cylinder { < 0, 2.6, -0.5 > < 0, 2.6, 0.5 > 0.05 }
  cylinder { < 0, 2.8, -0.5 > < 0, 2.8, 0.5 > 0.05 }
  cylinder { < 0, 3.0, -0.5 > < 0, 3.0, 0.5 > 0.05 }
  cylinder { < 0, 3.2, -0.5 > < 0, 3.2, 0.5 > 0.05 }
  cylinder { < 0, 3.4, -0.5 > < 0, 3.4, 0.5 > 0.05 }
  cylinder { < 0, 3.6, -0.5 > < 0, 3.6, 0.5 > 0.05 }
  cylinder { < 0, 3.8, -0.5 > < 0, 3.8, 0.5 > 0.05 }
  cylinder { < 0, 4.0, -0.5 > < 0, 4.0, 0.5 > 0.05 }
  cylinder { < 0, 4.2, -0.5 > < 0, 4.2, 0.5 > 0.05 }
  cylinder { < 0, 4.4, -0.5 > < 0, 4.4, 0.5 > 0.05 }
  cylinder { < 0, 4.6, -0.5 > < 0, 4.6, 0.5 > 0.05 }
  cylinder { < 0, 4.8, -0.5 > < 0, 4.8, 0.5 > 0.05 }
  cylinder { < 0, 5.0, -0.5 > < 0, 5.0, 0.5 > 0.05 }
  cylinder { < 0, 5.2, -0.5 > < 0, 5.2, 0.5 > 0.05 }
  cylinder { < 0, 5.4, -0.5 > < 0, 5.4, 0.5 > 0.05 }
  cylinder { < 0, 5.6, -0.5 > < 0, 5.6, 0.5 > 0.05 }
  cylinder { < 0, 5.8, -0.5 > < 0, 5.8, 0.5 > 0.05 }
  cylinder { < 0, 6.0, -0.5 > < 0, 6.0, 0.5 > 0.05 }
  cylinder { < 0, 6.2, -0.5 > < 0, 6.2, 0.5 > 0.05 }
  cylinder { < 0, 6.4, -0.5 > < 0, 6.4, 0.5 > 0.05 }
  cylinder { < 0, 6.6, -0.5 > < 0, 6.6, 0.5 > 0.05 }
  cylinder { < 0, 6.8, -0.5 > < 0, 6.8, 0.5 > 0.05 }
  cylinder { < 0, 7.0, -0.5 > < 0, 7.0, 0.5 > 0.05 }
  cylinder { < 0, 7.2, -0.5 > < 0, 7.2, 0.5 > 0.05 }
  cylinder { < 0, 7.4, -0.5 > < 0, 7.4, 0.5 > 0.05 }
  cylinder { < 0, 7.6, -0.5 > < 0, 7.6, 0.5 > 0.05 }
  cylinder { < 0, 7.8, -0.5 > < 0, 7.8, 0.5 > 0.05 }
  cylinder { < 0, 8.0, -0.5 > < 0, 8.0, 0.5 > 0.05 }
}

#declare post = union {
  difference {
    box { < -0.2, -2.2, -0.2 > < 0.2, 8.0, 0.2 > }
    object { postholes }
  }
  box { < -0.22, -2.2, -0.3 > < -0.18, 8.0, 0.2 > }
  box { <  0.18, -2.2, -0.3 > <  0.22, 8.0, 0.2 > }
  texture { pigment { DarkGreen } }
}

#declare NoParkingSign = union {
  superellipsoid
  {
    < 0.15,  // east-west exponent (0.0 ... 1.0)
    1.0 > // north-south exponent (0.0 ... 1.0)
    texture {
      pigment {
        image_map { tga "wichsign.tga" map_type 0 interpolate 2 }
        scale 2
        translate < 0.975, -1, 0 >
      }
    }
    scale < 1.5, 2, 0.1 >
    translate < 0, 7.75, -0.3 >
  }
  superellipsoid
  {
    < 0.15,  // east-west exponent (0.0 ... 1.0)
    1.0 > // north-south exponent (0.0 ... 1.0)
    texture { pigment { White } }
    scale < 1.5, 2, 0.1 >
    translate < 0, 7.75, -0.2 >
  }
  object { post }
}

#declare rooftiles = union {
         // row 1
  difference{
    cylinder { < -6.0, 2.0, 0.1 > < -6.0, 2.0, -0.1 > 0.5 }
    box { < -6.6, 0.5, 0.2 > < -6.0, 3.5, -0.2 > }
    texture { VioletTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.75 >
  }
  cylinder { < -5.0, 2.0, 0.1 > < -5.0, 2.0, -0.1 > 0.5 texture { RedTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.75 > }
  cylinder { < -4.0, 2.0, 0.1 > < -4.0, 2.0, -0.1 > 0.5 texture { BlueTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.75 > }
  cylinder { < -3.0, 2.0, 0.1 > < -3.0, 2.0, -0.1 > 0.5 texture { GreenTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.75 > }
  cylinder { < -2.0, 2.0, 0.1 > < -2.0, 2.0, -0.1 > 0.5 texture { VioletTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.75 > }
  cylinder { < -1.0, 2.0, 0.1 > < -1.0, 2.0, -0.1 > 0.5 texture { RedTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.75 > }
  cylinder { <  0.0, 2.0, 0.1 > <  0.0, 2.0, -0.1 > 0.5 texture { BlueTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.75 > }
  cylinder { <  1.0, 2.0, 0.1 > <  1.0, 2.0, -0.1 > 0.5 texture { GreenTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.75 > }
  cylinder { <  2.0, 2.0, 0.1 > <  2.0, 2.0, -0.1 > 0.5 texture { VioletTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.75 > }
  cylinder { <  3.0, 2.0, 0.1 > <  3.0, 2.0, -0.1 > 0.5 texture { RedTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.75 > }
  cylinder { <  4.0, 2.0, 0.1 > <  4.0, 2.0, -0.1 > 0.5 texture { BlueTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.75 > }
  cylinder { <  5.0, 2.0, 0.1 > <  5.0, 2.0, -0.1 > 0.5 texture { GreenTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.75 > }
  difference{
    cylinder { <  6.0, 2.0, 0.1 > <  6.0, 2.0, -0.1 > 0.5 }
    box { < 6.0, 0.5, 0.2 > < 6.6, 3.5, -0.2 > }
    texture { VioletTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.75 >
  }
        // row 2
  cylinder { < -5.5, 2.5, 0.1 > < -5.5, 2.5, -0.1 > 0.5 texture { GreenTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.85 > }
  cylinder { < -4.5, 2.5, 0.1 > < -4.5, 2.5, -0.1 > 0.5 texture { VioletTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.85 > }
  cylinder { < -3.5, 2.5, 0.1 > < -3.5, 2.5, -0.1 > 0.5 texture { RedTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.85 > }
  cylinder { < -2.5, 2.5, 0.1 > < -2.5, 2.5, -0.1 > 0.5 texture { BlueTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.85 > }
  cylinder { < -1.5, 2.5, 0.1 > < -1.5, 2.5, -0.1 > 0.5 texture { GreenTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.85 > }
  cylinder { < -0.5, 2.5, 0.1 > < -0.5, 2.5, -0.1 > 0.5 texture { VioletTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.85 > }
  cylinder { <  0.5, 2.5, 0.1 > <  0.5, 2.5, -0.1 > 0.5 texture { RedTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.85 > }
  cylinder { <  1.5, 2.5, 0.1 > <  1.5, 2.5, -0.1 > 0.5 texture { BlueTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.85 > }
  cylinder { <  2.5, 2.5, 0.1 > <  2.5, 2.5, -0.1 > 0.5 texture { GreenTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.85 > }
  cylinder { <  3.5, 2.5, 0.1 > <  3.5, 2.5, -0.1 > 0.5 texture { VioletTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.85 > }
  cylinder { <  4.5, 2.5, 0.1 > <  4.5, 2.5, -0.1 > 0.5 texture { RedTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.85 > }
  cylinder { <  5.5, 2.5, 0.1 > <  5.5, 2.5, -0.1 > 0.5 texture { BlueTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.85 > }
           // row 3
  difference{
    cylinder { < -6.0, 3.0, 0.1 > < -6.0, 3.0, -0.1 > 0.5 }
    box { < -6.6, 1.5, 0.2 > < -6.0, 4.5, -0.2 > }
    texture { RedTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.95 >
  }
  cylinder { < -5.0, 3.0, 0.1 > < -5.0, 3.0, -0.1 > 0.5 texture { BlueTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.95 > }
  cylinder { < -4.0, 3.0, 0.1 > < -4.0, 3.0, -0.1 > 0.5 texture { GreenTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.95 > }
  cylinder { < -3.0, 3.0, 0.1 > < -3.0, 3.0, -0.1 > 0.5 texture { VioletTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.95 > }
  cylinder { < -2.0, 3.0, 0.1 > < -2.0, 3.0, -0.1 > 0.5 texture { RedTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.95 > }
  cylinder { < -1.0, 3.0, 0.1 > < -1.0, 3.0, -0.1 > 0.5 texture { BlueTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.95 > }
  cylinder { <  0.0, 3.0, 0.1 > <  0.0, 3.0, -0.1 > 0.5 texture { GreenTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.95 > }
  cylinder { <  1.0, 3.0, 0.1 > <  1.0, 3.0, -0.1 > 0.5 texture { VioletTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.95 > }
  cylinder { <  2.0, 3.0, 0.1 > <  2.0, 3.0, -0.1 > 0.5 texture { RedTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.95 > }
  cylinder { <  3.0, 3.0, 0.1 > <  3.0, 3.0, -0.1 > 0.5 texture { BlueTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.95 > }
  cylinder { <  4.0, 3.0, 0.1 > <  4.0, 3.0, -0.1 > 0.5 texture { GreenTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.95 > }
  cylinder { <  5.0, 3.0, 0.1 > <  5.0, 3.0, -0.1 > 0.5 texture { VioletTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.95 > }
  difference{
    cylinder { <  6.0, 3.0, 0.1 > <  6.0, 3.0, -0.1 > 0.5 }
    box { < 6.0, 1.5, 0.2 > < 6.6, 4.5, -0.2 > }
    texture { RedTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -0.95 >
  }
        // row 4
  cylinder { < -5.5, 3.5, 0.1 > < -5.5, 3.5, -0.1 > 0.5 texture { VioletTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.05 > }
  cylinder { < -4.5, 3.5, 0.1 > < -4.5, 3.5, -0.1 > 0.5 texture { RedTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.05 > }
  cylinder { < -3.5, 3.5, 0.1 > < -3.5, 3.5, -0.1 > 0.5 texture { BlueTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.05 > }
  cylinder { < -2.5, 3.5, 0.1 > < -2.5, 3.5, -0.1 > 0.5 texture { GreenTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.05 > }
  cylinder { < -1.5, 3.5, 0.1 > < -1.5, 3.5, -0.1 > 0.5 texture { VioletTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.05 > }
  cylinder { < -0.5, 3.5, 0.1 > < -0.5, 3.5, -0.1 > 0.5 texture { RedTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.05 > }
  cylinder { <  0.5, 3.5, 0.1 > <  0.5, 3.5, -0.1 > 0.5 texture { BlueTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.05 > }
  cylinder { <  1.5, 3.5, 0.1 > <  1.5, 3.5, -0.1 > 0.5 texture { GreenTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.05 > }
  cylinder { <  2.5, 3.5, 0.1 > <  2.5, 3.5, -0.1 > 0.5 texture { VioletTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.05 > }
  cylinder { <  3.5, 3.5, 0.1 > <  3.5, 3.5, -0.1 > 0.5 texture { RedTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.05 > }
  cylinder { <  4.5, 3.5, 0.1 > <  4.5, 3.5, -0.1 > 0.5 texture { BlueTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.05 > }
  cylinder { <  5.5, 3.5, 0.1 > <  5.5, 3.5, -0.1 > 0.5 texture { GreenTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.05 > }
         // row 5
  difference{
    cylinder { < -6.0, 4.0, 0.1 > < -6.0, 4.0, -0.1 > 0.5 }
    box { < -6.6, 2.5, 0.2 > < -6.0, 5.5, -0.2 > }
    texture { BlueTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.15 >
  }
  cylinder { < -5.0, 4.0, 0.1 > < -5.0, 4.0, -0.1 > 0.5 texture { GreenTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.15 > }
  cylinder { < -4.0, 4.0, 0.1 > < -4.0, 4.0, -0.1 > 0.5 texture { VioletTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.15 > }
  cylinder { < -3.0, 4.0, 0.1 > < -3.0, 4.0, -0.1 > 0.5 texture { RedTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.15 > }
  cylinder { < -2.0, 4.0, 0.1 > < -2.0, 4.0, -0.1 > 0.5 texture { BlueTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.15 > }
  cylinder { < -1.0, 4.0, 0.1 > < -1.0, 4.0, -0.1 > 0.5 texture { GreenTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.15 > }
  cylinder { <  0.0, 4.0, 0.1 > <  0.0, 4.0, -0.1 > 0.5 texture { VioletTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.15 > }
  cylinder { <  1.0, 4.0, 0.1 > <  1.0, 4.0, -0.1 > 0.5 texture { RedTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.15 > }
  cylinder { <  2.0, 4.0, 0.1 > <  2.0, 4.0, -0.1 > 0.5 texture { BlueTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.15 > }
  cylinder { <  3.0, 4.0, 0.1 > <  3.0, 4.0, -0.1 > 0.5 texture { GreenTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.15 > }
  cylinder { <  4.0, 4.0, 0.1 > <  4.0, 4.0, -0.1 > 0.5 texture { VioletTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.15 > }
  cylinder { <  5.0, 4.0, 0.1 > <  5.0, 4.0, -0.1 > 0.5 texture { RedTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.15 > }
  difference{
    cylinder { <  6.0, 4.0, 0.1 > <  6.0, 4.0, -0.1 > 0.5 }
    box { < 6.0, 2.5, 0.2 > < 6.6, 5.5, -0.2 > }
    texture { BlueTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.15 >
  }
        // row 6
  cylinder { < -5.5, 4.5, 0.1 > < -5.5, 4.5, -0.1 > 0.5 texture { RedTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.25 > }
  cylinder { < -4.5, 4.5, 0.1 > < -4.5, 4.5, -0.1 > 0.5 texture { BlueTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.25 > }
  cylinder { < -3.5, 4.5, 0.1 > < -3.5, 4.5, -0.1 > 0.5 texture { GreenTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.25 > }
  cylinder { < -2.5, 4.5, 0.1 > < -2.5, 4.5, -0.1 > 0.5 texture { VioletTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.25 > }
  cylinder { < -1.5, 4.5, 0.1 > < -1.5, 4.5, -0.1 > 0.5 texture { RedTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.25 > }
  cylinder { < -0.5, 4.5, 0.1 > < -0.5, 4.5, -0.1 > 0.5 texture { BlueTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.25 > }
  cylinder { <  0.5, 4.5, 0.1 > <  0.5, 4.5, -0.1 > 0.5 texture { GreenTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.25 > }
  cylinder { <  1.5, 4.5, 0.1 > <  1.5, 4.5, -0.1 > 0.5 texture { VioletTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.25 > }
  cylinder { <  2.5, 4.5, 0.1 > <  2.5, 4.5, -0.1 > 0.5 texture { RedTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.25 > }
  cylinder { <  3.5, 4.5, 0.1 > <  3.5, 4.5, -0.1 > 0.5 texture { BlueTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.25 > }
  cylinder { <  4.5, 4.5, 0.1 > <  4.5, 4.5, -0.1 > 0.5 texture { GreenTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.25 > }
  cylinder { <  5.5, 4.5, 0.1 > <  5.5, 4.5, -0.1 > 0.5 texture { VioletTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.25 > }
           // row 7
  difference{
    cylinder { < -6.0, 5.0, 0.1 > < -6.0, 5.0, -0.1 > 0.5 }
    box { < -6.6, 3.5, 0.2 > < -6.0, 6.5, -0.2 > }
    texture { GreenTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.35 >
  }
  cylinder { < -5.0, 5.0, 0.1 > < -5.0, 5.0, -0.1 > 0.5 texture { VioletTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.35 > }
  cylinder { < -4.0, 5.0, 0.1 > < -4.0, 5.0, -0.1 > 0.5 texture { RedTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.35 > }
  cylinder { < -3.0, 5.0, 0.1 > < -3.0, 5.0, -0.1 > 0.5 texture { BlueTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.35 > }
  cylinder { < -2.0, 5.0, 0.1 > < -2.0, 5.0, -0.1 > 0.5 texture { GreenTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.35 > }
  cylinder { < -1.0, 5.0, 0.1 > < -1.0, 5.0, -0.1 > 0.5 texture { VioletTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.35 > }
  cylinder { <  0.0, 5.0, 0.1 > <  0.0, 5.0, -0.1 > 0.5 texture { RedTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.35 > }
  cylinder { <  1.0, 5.0, 0.1 > <  1.0, 5.0, -0.1 > 0.5 texture { BlueTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.35 > }
  cylinder { <  2.0, 5.0, 0.1 > <  2.0, 5.0, -0.1 > 0.5 texture { GreenTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.35 > }
  cylinder { <  3.0, 5.0, 0.1 > <  3.0, 5.0, -0.1 > 0.5 texture { VioletTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.35 > }
  cylinder { <  4.0, 5.0, 0.1 > <  4.0, 5.0, -0.1 > 0.5 texture { RedTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.35 > }
  cylinder { <  5.0, 5.0, 0.1 > <  5.0, 5.0, -0.1 > 0.5 texture { BlueTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.35 > }
  difference{
    cylinder { <  6.0, 5.0, 0.1 > <  6.0, 5.0, -0.1 > 0.5 }
    box { < 6.0, 3.5, 0.2 > < 6.6, 6.5, -0.2 > }
    texture { GreenTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.35 >
  }
        // row 8
  cylinder { < -5.5, 5.5, 0.1 > < -5.5, 5.5, -0.1 > 0.5 texture { BlueTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.45 > }
  cylinder { < -4.5, 5.5, 0.1 > < -4.5, 5.5, -0.1 > 0.5 texture { GreenTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.45 > }
  cylinder { < -3.5, 5.5, 0.1 > < -3.5, 5.5, -0.1 > 0.5 texture { VioletTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.45 > }
  cylinder { < -2.5, 5.5, 0.1 > < -2.5, 5.5, -0.1 > 0.5 texture { RedTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.45 > }
  cylinder { < -1.5, 5.5, 0.1 > < -1.5, 5.5, -0.1 > 0.5 texture { BlueTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.45 > }
  cylinder { < -0.5, 5.5, 0.1 > < -0.5, 5.5, -0.1 > 0.5 texture { GreenTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.45 > }
  cylinder { <  0.5, 5.5, 0.1 > <  0.5, 5.5, -0.1 > 0.5 texture { VioletTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.45 > }
  cylinder { <  1.5, 5.5, 0.1 > <  1.5, 5.5, -0.1 > 0.5 texture { RedTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.45 > }
  cylinder { <  2.5, 5.5, 0.1 > <  2.5, 5.5, -0.1 > 0.5 texture { BlueTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.45 > }
  cylinder { <  3.5, 5.5, 0.1 > <  3.5, 5.5, -0.1 > 0.5 texture { GreenTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.45 > }
  cylinder { <  4.5, 5.5, 0.1 > <  4.5, 5.5, -0.1 > 0.5 texture { VioletTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.45 > }
  cylinder { <  5.5, 5.5, 0.1 > <  5.5, 5.5, -0.1 > 0.5 texture { RedTex } finish { Phong_Glossy } rotate x*25 translate < 0, 0, -1.45 > }
}

#declare roofhalf = union {
  object { rooftiles translate < -5.95, 0.00, 0.00 > }
  object { rooftiles translate < -5.95, 3.55, 0.85 > }
  object { rooftiles translate <  5.95, 0.00, 0.00 > }
  object { rooftiles translate <  5.95, 3.55, 0.85 > }
}

#declare roof = union {
  object { roofhalf rotate < 25, 0, 0 > }
  object { roofhalf rotate < 25, 180, 0 > translate < 0, 0, 11 > }
}

#declare walltiles = union {
         // row 1
  difference{
    cylinder { < -6.0, 2.0, 0.1 > < -6.0, 2.0, -0.1 > 0.5 }
    box { < -6.6, 0.5, 0.2 > < -6.0, 3.5, -0.2 > }
    texture { cookie3_texture }
    rotate x*25 translate < 0, 0, -0.75 >
  }
  cylinder { < -5.0, 2.0, 0.1 > < -5.0, 2.0, -0.1 > 0.5 texture { cookie1_texture } rotate x*25 translate < 0, 0, -0.75 > }
  cylinder { < -4.0, 2.0, 0.1 > < -4.0, 2.0, -0.1 > 0.5 texture { cookie4_texture } rotate x*25 translate < 0, 0, -0.75 > }
  cylinder { < -3.0, 2.0, 0.1 > < -3.0, 2.0, -0.1 > 0.5 texture { cookie3_texture } rotate x*25 translate < 0, 0, -0.75 > }
  cylinder { < -2.0, 2.0, 0.1 > < -2.0, 2.0, -0.1 > 0.5 texture { cookie2_texture } rotate x*25 translate < 0, 0, -0.75 > }
  cylinder { < -1.0, 2.0, 0.1 > < -1.0, 2.0, -0.1 > 0.5 texture { cookie1_texture } rotate x*25 translate < 0, 0, -0.75 > }
  cylinder { <  0.0, 2.0, 0.1 > <  0.0, 2.0, -0.1 > 0.5 texture { cookie4_texture } rotate x*25 translate < 0, 0, -0.75 > }
  cylinder { <  1.0, 2.0, 0.1 > <  1.0, 2.0, -0.1 > 0.5 texture { cookie3_texture } rotate x*25 translate < 0, 0, -0.75 > }
  cylinder { <  2.0, 2.0, 0.1 > <  2.0, 2.0, -0.1 > 0.5 texture { cookie2_texture } rotate x*25 translate < 0, 0, -0.75 > }
  cylinder { <  3.0, 2.0, 0.1 > <  3.0, 2.0, -0.1 > 0.5 texture { cookie1_texture } rotate x*25 translate < 0, 0, -0.75 > }
  cylinder { <  4.0, 2.0, 0.1 > <  4.0, 2.0, -0.1 > 0.5 texture { cookie4_texture } rotate x*25 translate < 0, 0, -0.75 > }
  cylinder { <  5.0, 2.0, 0.1 > <  5.0, 2.0, -0.1 > 0.5 texture { cookie3_texture } rotate x*25 translate < 0, 0, -0.75 > }
  difference{
    cylinder { <  6.0, 2.0, 0.1 > <  6.0, 2.0, -0.1 > 0.5 }
    box { < 6.0, 0.5, 0.2 > < 6.6, 3.5, -0.2 > }
    texture { cookie4_texture }
    rotate x*25 translate < 0, 0, -0.75 >
  }
        // row 2
  cylinder { < -5.5, 2.5, 0.1 > < -5.5, 2.5, -0.1 > 0.5 texture { cookie2_texture } rotate x*25 translate < 0, 0, -0.85 > }
  cylinder { < -4.5, 2.5, 0.1 > < -4.5, 2.5, -0.1 > 0.5 texture { cookie1_texture } rotate x*25 translate < 0, 0, -0.85 > }
  cylinder { < -3.5, 2.5, 0.1 > < -3.5, 2.5, -0.1 > 0.5 texture { cookie4_texture } rotate x*25 translate < 0, 0, -0.85 > }
  cylinder { < -2.5, 2.5, 0.1 > < -2.5, 2.5, -0.1 > 0.5 texture { cookie3_texture } rotate x*25 translate < 0, 0, -0.85 > }
  cylinder { < -1.5, 2.5, 0.1 > < -1.5, 2.5, -0.1 > 0.5 texture { cookie1_texture } rotate x*25 translate < 0, 0, -0.85 > }
  cylinder { < -0.5, 2.5, 0.1 > < -0.5, 2.5, -0.1 > 0.5 texture { cookie2_texture } rotate x*25 translate < 0, 0, -0.85 > }
  cylinder { <  0.5, 2.5, 0.1 > <  0.5, 2.5, -0.1 > 0.5 texture { cookie3_texture } rotate x*25 translate < 0, 0, -0.85 > }
  cylinder { <  1.5, 2.5, 0.1 > <  1.5, 2.5, -0.1 > 0.5 texture { cookie1_texture } rotate x*25 translate < 0, 0, -0.85 > }
  cylinder { <  2.5, 2.5, 0.1 > <  2.5, 2.5, -0.1 > 0.5 texture { cookie4_texture } rotate x*25 translate < 0, 0, -0.85 > }
  cylinder { <  3.5, 2.5, 0.1 > <  3.5, 2.5, -0.1 > 0.5 texture { cookie3_texture } rotate x*25 translate < 0, 0, -0.85 > }
  cylinder { <  4.5, 2.5, 0.1 > <  4.5, 2.5, -0.1 > 0.5 texture { cookie4_texture } rotate x*25 translate < 0, 0, -0.85 > }
  cylinder { <  5.5, 2.5, 0.1 > <  5.5, 2.5, -0.1 > 0.5 texture { cookie2_texture } rotate x*25 translate < 0, 0, -0.85 > }
           // row 3
  difference{
    cylinder { < -6.0, 3.0, 0.1 > < -6.0, 3.0, -0.1 > 0.5 }
    box { < -6.6, 1.5, 0.2 > < -6.0, 4.5, -0.2 > }
    texture { cookie1_texture }
    rotate x*25 translate < 0, 0, -0.95 >
  }
  cylinder { < -5.0, 3.0, 0.1 > < -5.0, 3.0, -0.1 > 0.5 texture { cookie3_texture } rotate x*25 translate < 0, 0, -0.95 > }
  cylinder { < -4.0, 3.0, 0.1 > < -4.0, 3.0, -0.1 > 0.5 texture { cookie4_texture } rotate x*25 translate < 0, 0, -0.95 > }
  cylinder { < -3.0, 3.0, 0.1 > < -3.0, 3.0, -0.1 > 0.5 texture { cookie2_texture } rotate x*25 translate < 0, 0, -0.95 > }
  cylinder { < -2.0, 3.0, 0.1 > < -2.0, 3.0, -0.1 > 0.5 texture { cookie1_texture } rotate x*25 translate < 0, 0, -0.95 > }
  cylinder { < -1.0, 3.0, 0.1 > < -1.0, 3.0, -0.1 > 0.5 texture { cookie3_texture } rotate x*25 translate < 0, 0, -0.95 > }
  cylinder { <  0.0, 3.0, 0.1 > <  0.0, 3.0, -0.1 > 0.5 texture { cookie4_texture } rotate x*25 translate < 0, 0, -0.95 > }
  cylinder { <  1.0, 3.0, 0.1 > <  1.0, 3.0, -0.1 > 0.5 texture { cookie1_texture } rotate x*25 translate < 0, 0, -0.95 > }
  cylinder { <  2.0, 3.0, 0.1 > <  2.0, 3.0, -0.1 > 0.5 texture { cookie2_texture } rotate x*25 translate < 0, 0, -0.95 > }
  cylinder { <  3.0, 3.0, 0.1 > <  3.0, 3.0, -0.1 > 0.5 texture { cookie1_texture } rotate x*25 translate < 0, 0, -0.95 > }
  cylinder { <  4.0, 3.0, 0.1 > <  4.0, 3.0, -0.1 > 0.5 texture { cookie4_texture } rotate x*25 translate < 0, 0, -0.95 > }
  cylinder { <  5.0, 3.0, 0.1 > <  5.0, 3.0, -0.1 > 0.5 texture { cookie3_texture } rotate x*25 translate < 0, 0, -0.95 > }
  difference{
    cylinder { <  6.0, 3.0, 0.1 > <  6.0, 3.0, -0.1 > 0.5 }
    box { < 6.0, 1.5, 0.2 > < 6.6, 4.5, -0.2 > }
    texture { cookie2_texture }
    rotate x*25 translate < 0, 0, -0.95 >
  }
        // row 4
  cylinder { < -5.5, 3.5, 0.1 > < -5.5, 3.5, -0.1 > 0.5 texture { cookie1_texture } rotate x*25 translate < 0, 0, -1.05 > }
  cylinder { < -4.5, 3.5, 0.1 > < -4.5, 3.5, -0.1 > 0.5 texture { cookie2_texture } rotate x*25 translate < 0, 0, -1.05 > }
  cylinder { < -3.5, 3.5, 0.1 > < -3.5, 3.5, -0.1 > 0.5 texture { cookie3_texture } rotate x*25 translate < 0, 0, -1.05 > }
  cylinder { < -2.5, 3.5, 0.1 > < -2.5, 3.5, -0.1 > 0.5 texture { cookie4_texture } rotate x*25 translate < 0, 0, -1.05 > }
  cylinder { < -1.5, 3.5, 0.1 > < -1.5, 3.5, -0.1 > 0.5 texture { cookie1_texture } rotate x*25 translate < 0, 0, -1.05 > }
  cylinder { < -0.5, 3.5, 0.1 > < -0.5, 3.5, -0.1 > 0.5 texture { cookie3_texture } rotate x*25 translate < 0, 0, -1.05 > }
  cylinder { <  0.5, 3.5, 0.1 > <  0.5, 3.5, -0.1 > 0.5 texture { cookie1_texture } rotate x*25 translate < 0, 0, -1.05 > }
  cylinder { <  1.5, 3.5, 0.1 > <  1.5, 3.5, -0.1 > 0.5 texture { cookie2_texture } rotate x*25 translate < 0, 0, -1.05 > }
  cylinder { <  2.5, 3.5, 0.1 > <  2.5, 3.5, -0.1 > 0.5 texture { cookie1_texture } rotate x*25 translate < 0, 0, -1.05 > }
  cylinder { <  3.5, 3.5, 0.1 > <  3.5, 3.5, -0.1 > 0.5 texture { cookie3_texture } rotate x*25 translate < 0, 0, -1.05 > }
  cylinder { <  4.5, 3.5, 0.1 > <  4.5, 3.5, -0.1 > 0.5 texture { cookie4_texture } rotate x*25 translate < 0, 0, -1.05 > }
  cylinder { <  5.5, 3.5, 0.1 > <  5.5, 3.5, -0.1 > 0.5 texture { cookie1_texture } rotate x*25 translate < 0, 0, -1.05 > }
         // row 5
  difference{
    cylinder { < -6.0, 4.0, 0.1 > < -6.0, 4.0, -0.1 > 0.5 }
    box { < -6.6, 2.5, 0.2 > < -6.0, 5.5, -0.2 > }
    texture { cookie3_texture }
    rotate x*25 translate < 0, 0, -1.15 >
  }
  cylinder { < -5.0, 4.0, 0.1 > < -5.0, 4.0, -0.1 > 0.5 texture { cookie4_texture } rotate x*25 translate < 0, 0, -1.15 > }
  cylinder { < -4.0, 4.0, 0.1 > < -4.0, 4.0, -0.1 > 0.5 texture { cookie2_texture } rotate x*25 translate < 0, 0, -1.15 > }
  cylinder { < -3.0, 4.0, 0.1 > < -3.0, 4.0, -0.1 > 0.5 texture { cookie1_texture } rotate x*25 translate < 0, 0, -1.15 > }
  cylinder { < -2.0, 4.0, 0.1 > < -2.0, 4.0, -0.1 > 0.5 texture { cookie4_texture } rotate x*25 translate < 0, 0, -1.15 > }
  cylinder { < -1.0, 4.0, 0.1 > < -1.0, 4.0, -0.1 > 0.5 texture { cookie3_texture } rotate x*25 translate < 0, 0, -1.15 > }
  cylinder { <  0.0, 4.0, 0.1 > <  0.0, 4.0, -0.1 > 0.5 texture { cookie1_texture } rotate x*25 translate < 0, 0, -1.15 > }
  cylinder { <  1.0, 4.0, 0.1 > <  1.0, 4.0, -0.1 > 0.5 texture { cookie3_texture } rotate x*25 translate < 0, 0, -1.15 > }
  cylinder { <  2.0, 4.0, 0.1 > <  2.0, 4.0, -0.1 > 0.5 texture { cookie2_texture } rotate x*25 translate < 0, 0, -1.15 > }
  cylinder { <  3.0, 4.0, 0.1 > <  3.0, 4.0, -0.1 > 0.5 texture { cookie1_texture } rotate x*25 translate < 0, 0, -1.15 > }
  cylinder { <  4.0, 4.0, 0.1 > <  4.0, 4.0, -0.1 > 0.5 texture { cookie4_texture } rotate x*25 translate < 0, 0, -1.15 > }
  cylinder { <  5.0, 4.0, 0.1 > <  5.0, 4.0, -0.1 > 0.5 texture { cookie3_texture } rotate x*25 translate < 0, 0, -1.15 > }
  difference{
    cylinder { <  6.0, 4.0, 0.1 > <  6.0, 4.0, -0.1 > 0.5 }
    box { < 6.0, 2.5, 0.2 > < 6.6, 5.5, -0.2 > }
    texture { cookie1_texture }
    rotate x*25 translate < 0, 0, -1.15 >
  }
        // row 6
  cylinder { < -5.5, 4.5, 0.1 > < -5.5, 4.5, -0.1 > 0.5 texture { cookie3_texture } rotate x*25 translate < 0, 0, -1.25 > }
  cylinder { < -4.5, 4.5, 0.1 > < -4.5, 4.5, -0.1 > 0.5 texture { cookie4_texture } rotate x*25 translate < 0, 0, -1.25 > }
  cylinder { < -3.5, 4.5, 0.1 > < -3.5, 4.5, -0.1 > 0.5 texture { cookie1_texture } rotate x*25 translate < 0, 0, -1.25 > }
  cylinder { < -2.5, 4.5, 0.1 > < -2.5, 4.5, -0.1 > 0.5 texture { cookie2_texture } rotate x*25 translate < 0, 0, -1.25 > }
  cylinder { < -1.5, 4.5, 0.1 > < -1.5, 4.5, -0.1 > 0.5 texture { cookie1_texture } rotate x*25 translate < 0, 0, -1.25 > }
  cylinder { < -0.5, 4.5, 0.1 > < -0.5, 4.5, -0.1 > 0.5 texture { cookie4_texture } rotate x*25 translate < 0, 0, -1.25 > }
  cylinder { <  0.5, 4.5, 0.1 > <  0.5, 4.5, -0.1 > 0.5 texture { cookie3_texture } rotate x*25 translate < 0, 0, -1.25 > }
  cylinder { <  1.5, 4.5, 0.1 > <  1.5, 4.5, -0.1 > 0.5 texture { cookie2_texture } rotate x*25 translate < 0, 0, -1.25 > }
  cylinder { <  2.5, 4.5, 0.1 > <  2.5, 4.5, -0.1 > 0.5 texture { cookie1_texture } rotate x*25 translate < 0, 0, -1.25 > }
  cylinder { <  3.5, 4.5, 0.1 > <  3.5, 4.5, -0.1 > 0.5 texture { cookie2_texture } rotate x*25 translate < 0, 0, -1.25 > }
  cylinder { <  4.5, 4.5, 0.1 > <  4.5, 4.5, -0.1 > 0.5 texture { cookie4_texture } rotate x*25 translate < 0, 0, -1.25 > }
  cylinder { <  5.5, 4.5, 0.1 > <  5.5, 4.5, -0.1 > 0.5 texture { cookie3_texture } rotate x*25 translate < 0, 0, -1.25 > }
           // row 7
  difference{
    cylinder { < -6.0, 5.0, 0.1 > < -6.0, 5.0, -0.1 > 0.5 }
    box { < -6.6, 3.5, 0.2 > < -6.0, 6.5, -0.2 > }
    texture { cookie2_texture }
    rotate x*25 translate < 0, 0, -1.35 >
  }
  cylinder { < -5.0, 5.0, 0.1 > < -5.0, 5.0, -0.1 > 0.5 texture { cookie1_texture } rotate x*25 translate < 0, 0, -1.35 > }
  cylinder { < -4.0, 5.0, 0.1 > < -4.0, 5.0, -0.1 > 0.5 texture { cookie3_texture } rotate x*25 translate < 0, 0, -1.35 > }
  cylinder { < -3.0, 5.0, 0.1 > < -3.0, 5.0, -0.1 > 0.5 texture { cookie2_texture } rotate x*25 translate < 0, 0, -1.35 > }
  cylinder { < -2.0, 5.0, 0.1 > < -2.0, 5.0, -0.1 > 0.5 texture { cookie4_texture } rotate x*25 translate < 0, 0, -1.35 > }
  cylinder { < -1.0, 5.0, 0.1 > < -1.0, 5.0, -0.1 > 0.5 texture { cookie3_texture } rotate x*25 translate < 0, 0, -1.35 > }
  cylinder { <  0.0, 5.0, 0.1 > <  0.0, 5.0, -0.1 > 0.5 texture { cookie1_texture } rotate x*25 translate < 0, 0, -1.35 > }
  cylinder { <  1.0, 5.0, 0.1 > <  1.0, 5.0, -0.1 > 0.5 texture { cookie3_texture } rotate x*25 translate < 0, 0, -1.35 > }
  cylinder { <  2.0, 5.0, 0.1 > <  2.0, 5.0, -0.1 > 0.5 texture { cookie2_texture } rotate x*25 translate < 0, 0, -1.35 > }
  cylinder { <  3.0, 5.0, 0.1 > <  3.0, 5.0, -0.1 > 0.5 texture { cookie1_texture } rotate x*25 translate < 0, 0, -1.35 > }
  cylinder { <  4.0, 5.0, 0.1 > <  4.0, 5.0, -0.1 > 0.5 texture { cookie4_texture } rotate x*25 translate < 0, 0, -1.35 > }
  cylinder { <  5.0, 5.0, 0.1 > <  5.0, 5.0, -0.1 > 0.5 texture { cookie3_texture } rotate x*25 translate < 0, 0, -1.35 > }
  difference{
    cylinder { <  6.0, 5.0, 0.1 > <  6.0, 5.0, -0.1 > 0.5 }
    box { < 6.0, 3.5, 0.2 > < 6.6, 6.5, -0.2 > }
    texture { cookie4_texture }
    rotate x*25 translate < 0, 0, -1.35 >
  }
        // row 8
  cylinder { < -5.5, 5.5, 0.1 > < -5.5, 5.5, -0.1 > 0.5 texture { cookie1_texture } rotate x*25 translate < 0, 0, -1.45 > }
  cylinder { < -4.5, 5.5, 0.1 > < -4.5, 5.5, -0.1 > 0.5 texture { cookie2_texture } rotate x*25 translate < 0, 0, -1.45 > }
  cylinder { < -3.5, 5.5, 0.1 > < -3.5, 5.5, -0.1 > 0.5 texture { cookie3_texture } rotate x*25 translate < 0, 0, -1.45 > }
  cylinder { < -2.5, 5.5, 0.1 > < -2.5, 5.5, -0.1 > 0.5 texture { cookie4_texture } rotate x*25 translate < 0, 0, -1.45 > }
  cylinder { < -1.5, 5.5, 0.1 > < -1.5, 5.5, -0.1 > 0.5 texture { cookie1_texture } rotate x*25 translate < 0, 0, -1.45 > }
  cylinder { < -0.5, 5.5, 0.1 > < -0.5, 5.5, -0.1 > 0.5 texture { cookie2_texture } rotate x*25 translate < 0, 0, -1.45 > }
  cylinder { <  0.5, 5.5, 0.1 > <  0.5, 5.5, -0.1 > 0.5 texture { cookie3_texture } rotate x*25 translate < 0, 0, -1.45 > }
  cylinder { <  1.5, 5.5, 0.1 > <  1.5, 5.5, -0.1 > 0.5 texture { cookie1_texture } rotate x*25 translate < 0, 0, -1.45 > }
  cylinder { <  2.5, 5.5, 0.1 > <  2.5, 5.5, -0.1 > 0.5 texture { cookie3_texture } rotate x*25 translate < 0, 0, -1.45 > }
  cylinder { <  3.5, 5.5, 0.1 > <  3.5, 5.5, -0.1 > 0.5 texture { cookie2_texture } rotate x*25 translate < 0, 0, -1.45 > }
  cylinder { <  4.5, 5.5, 0.1 > <  4.5, 5.5, -0.1 > 0.5 texture { cookie3_texture } rotate x*25 translate < 0, 0, -1.45 > }
  cylinder { <  5.5, 5.5, 0.1 > <  5.5, 5.5, -0.1 > 0.5 texture { cookie4_texture } rotate x*25 translate < 0, 0, -1.45 > }
}

#declare hole_width = 0.35

#declare wall2 = difference {
  box { < -11.5, 1.2, 0 > < 11.5, 8.75, 0.85 > }
  union {
    cylinder { < -11.5, 1.2, 0.1 > < -11.5, 8.75, 0.1 > 0.125 }
    cone { < -9.625, 3.075, -0.1 >, hole_width, < -9.625, 3.075, 0.15 >, 0 }
    cone { < -9.625, 6.825, -0.1 >, hole_width, < -9.625, 6.825, 0.15 >, 0 }
    cone { < -5.875, 3.075, -0.1 >, hole_width, < -5.875, 3.075, 0.15 >, 0 }
    cone { < -5.875, 6.825, -0.1 >, hole_width, < -5.875, 6.825, 0.15 >, 0 }
    cylinder { < -4, 1.2, 0.1 > < -4, 8.75, 0.1 > 0.125 }
    cone { < -2.125, 3.075, -0.1 >, hole_width, < -2.125, 3.075, 0.15 >, 0 }
    cone { < -2.125, 6.825, -0.1 >, hole_width, < -2.125, 6.825, 0.15 >, 0 }
    cone { < 1.625, 3.075, -0.1 >, hole_width, < 1.625, 3.075, 0.15 >, 0 }
    cone { < 1.625, 6.825, -0.1 >, hole_width, < 1.625, 6.825, 0.15 >, 0 }
    cylinder { < 3.5, 1.2, 0.1 > < 3.5, 8.75, 0.1 > 0.125 }
    cone { < 5.375, 3.075, -0.1 >, hole_width, < 5.375, 3.075, 0.15 >, 0 }
    cone { < 5.375, 6.825, -0.1 >, hole_width, < 5.375, 6.825, 0.15 >, 0 }
    cone { < 9.125, 3.075, -0.1 >, hole_width, < 9.125, 3.075, 0.15 >, 0 }
    cone { < 9.125, 6.825, -0.1 >, hole_width, < 9.125, 6.825, 0.15 >, 0 }
    cylinder { < 11.5, 1.2, 0.1 > < 11.5, 8.75, 0.1 > 0.125 }
  }
  pigment { BakersChoc }
  normal { bumps 0.4 }
}

#declare wall = union {       // for wall2 - translate < x=-5.95 / x=5.95 >
  object { walltiles translate < -5.95, 0.00, 0.00 > }
  object { walltiles translate < -5.95, 3.55, 0.85 > }
  object { walltiles translate <  5.95, 0.00, 0.00 > }
  object { walltiles translate <  5.95, 3.55, 0.85 > }
  texture { pigment { BakersChoc //SemiSweetChoc  } }
 }}}

#declare OPENsign = merge {
  torus { 0.6, 0.08 scale < 0.8, 1, 1 > hollow }  // letter 'O'
  cylinder { < -0.05, 0, 0.6 >, < 0.05, 0, 0.6 >, 0.09 open texture { T_Chrome_1D } }
  torus { 0.05, 0.005 texture { T_Chrome_1D } translate < 0, 0, 0.75 > }
  torus { 0.06, 0.005 texture { T_Chrome_1D } rotate z*80 translate < 0, 0, 0.85 > }
  torus { 0.06, 0.005 texture { T_Chrome_1D } rotate z*-10 translate < 0, 0, 0.95 > }
  torus { 0.06, 0.005 texture { T_Chrome_1D } rotate z*80 translate < 0, 0, 1.05 > }
  torus { 0.06, 0.005 texture { T_Chrome_1D } rotate z*-10 translate < 0, 0, 1.15 > }
  merge {                     // letter 'P'
    cylinder { < -0.3, 0,  0.3 >, < 0.05, 0,  0.3 >, 0.08 hollow }
    cylinder { < -0.2, 0, -0.3 >, < 0.05, 0, -0.3 >, 0.08 hollow }
    cylinder { < -0.275, 0, -0.9 >, < -0.275, 0, 0.3 >, 0.08 hollow }
    sphere { < -0.275, 0, -0.9 > 0.08 hollow }
    sphere { < -0.275, 0, 0.3 > 0.08 hollow }
    intersection {
      torus { 0.3, 0.08 hollow }
      box { < 0, -1, -1 > < 1, 1, 1 > hollow }
    }
    translate < 1, 0, 0.3 >
  }
  merge {                       // letter 'E'
    cylinder { < 0, 0, 0.6 >, < 0.55, 0,  0.6 >, 0.08 hollow }
    sphere { < 0.55, 0, 0.6 > 0.08 hollow }
    cylinder { < 0, 0, 0 >, < 0.5, 0, 0 >, 0.08 hollow }
    sphere { < 0.5, 0, 0 > 0.08 hollow }
    cylinder { < 0, 0, -0.6 >, < 0.6, 0, -0.6 >, 0.08 hollow }
    sphere { < 0.6, 0, -0.6 > 0.08 hollow }
    cylinder { < 0, 0, -0.6 >, < 0, 0, 0.6 >, 0.08 hollow }
    sphere { < 0, 0, -0.6 > 0.08 hollow }
    sphere { < 0, 0, 0.6 > 0.08 hollow }
    translate < 1.55, 0, 0 >
  }
  cylinder { < 0, 0, 0.6 >, < 1.55, 0,  0.6 >, 0.05 hollow }    // connecting rod
  cylinder { < 2, 0, -0.6 >, < 2.5, 0,  -0.6 >, 0.05 hollow }   // connecting rod
  merge {                      // letter 'N'
    cylinder { < 0, 0, -0.6 >, < 0, 0, 0.6 >, 0.08 hollow }
    sphere { < 0, 0, -0.6 > 0.08 hollow }
    sphere { < 0, 0, 0.6 > 0.08 hollow }
    cylinder { < 0.6, 0, -0.6 >, < 0.6, 0, 0.6 >, 0.08 hollow }
    sphere { < 0.6, 0, -0.6 > 0.08 hollow }
    sphere { < 0.6, 0, 0.6 > 0.08 hollow }
    cylinder { < 0, 0, 0.6 >, < 0.6, 0, -0.6 >, 0.08 hollow }
    cylinder { < 0.6, 0, 0.4 >, < 0.6, 0, 0.5 >, 0.09 texture { T_Chrome_1D } }
    torus { 0.05, 0.005 texture { T_Chrome_1D } translate < 0.45, 0, 0.45 > }
    torus { 0.06, 0.005 texture { T_Chrome_1D } rotate z*80 translate < 0.45, 0, 0.55 > }
    torus { 0.06, 0.005 texture { T_Chrome_1D } rotate z*-10 translate < 0.45, 0, 0.65 > }
    torus { 0.06, 0.005 texture { T_Chrome_1D } rotate z*80 translate < 0.45, 0, 0.75 > }
    torus { 0.06, 0.005 texture { T_Chrome_1D } rotate z*-10 translate < 0.45, 0, 0.85 > }
    torus { 0.06, 0.005 texture { T_Chrome_1D } rotate z*80 translate < 0.45, 0, 0.95 > }
    torus { 0.06, 0.005 texture { T_Chrome_1D } rotate z*-10 translate < 0.45, 0, 1.05 > }
    torus { 0.06, 0.005 texture { T_Chrome_1D } rotate z*80 translate < 0.45, 0, 1.15 > }
    translate < 2.5, 0, 0 >
  }
  pigment { Clear }
  halo {
    emitting
    cylindrical_mapping
    poly
    max_value 3
    exponent 2
    turbulence 1
    color_map { [ 0 color rgbt < 1, 0.43, 0.78, -10 > ] [ 1 color rgbt < 1, 0.43, 0.78, -10 > ] } samples 10  // [ 1 color rgbt < 1, 0.11, 0.68, -5 > ] } samples 10
  }
  rotate < -90, 0, 0 >
  scale 0.5
}

#declare ShoppeDoor = union {
  // frame around door
//  cylinder { < -8.9, 0.1, 5.9 > < -8.9, 5.5, 5.9 > 0.1 texture { cane_texture scale 0.4 rotate z*90  } }
//  cylinder { < -8.95, 5.5, 5.9 > < -5.85, 5.5, 5.9 > 0.1 texture { cane_texture scale 0.4 rotate z*90 } }
//  cylinder { < -5.9, 0.1, 5.9 > < -5.9, 5.5, 5.9 > 0.1 texture { cane_texture scale 0.4 rotate z*90 } }
  box { < -9.2, 0.1, 5.8 > < -8.8, 5.5, 6.1 > texture { T_Wood12 } }
  box { < -9.2, 5.3, 5.8 > < -5.6, 5.7, 6.1 > texture { T_Wood12 } }
  box { < -5.6, 0.1, 5.8 > < -6.0, 5.5, 6.1 > texture { T_Wood12 } }
  object { red_gumdrop scale < 0.2, 0.2, 0.2 > rotate x*-90 translate <-9.0, 1.1, 6.0 > }
  object { yellow_gumdrop scale < 0.2, 0.2, 0.2 > rotate x*-90 translate <-9.0, 2.2, 6.0 > }
  object { blue_gumdrop scale < 0.2, 0.2, 0.2 > rotate x*-90 translate <-9.0, 3.3, 6.0 > }
  object { green_gumdrop scale < 0.2, 0.2, 0.2 > rotate x*-90 translate <-9.0, 4.4, 6.0 > }
  object { purple_gumdrop scale < 0.2, 0.2, 0.2 > rotate x*-90 translate <-9.0, 5.5, 6.0 > }
  object { red_gumdrop scale < 0.2, 0.2, 0.2 > rotate x*-90 translate <-5.8, 3.3, 6.0 > }
  object { yellow_gumdrop scale < 0.2, 0.2, 0.2 > rotate x*-90 translate <-5.8, 5.5, 6.0 > }
  object { blue_gumdrop scale < 0.2, 0.2, 0.2 > rotate x*-90 translate <-5.8, 2.2, 6.0 > }
  object { green_gumdrop scale < 0.2, 0.2, 0.2 > rotate x*-90 translate <-5.8, 1.1, 6.0 > }
  object { purple_gumdrop scale < 0.2, 0.2, 0.2 > rotate x*-90 translate <-5.8, 4.4, 6.0 > }
  object { yellow_gumdrop scale < 0.2, 0.2, 0.2 > rotate x*-90 translate <-7.93, 5.5, 6.0 > }
  object { green_gumdrop scale < 0.2, 0.2, 0.2 > rotate x*-90 translate <-6.87, 5.5, 6.0 > }
  // door
  box { < -8.78, 0.12, 5.9 > < -8.63, 5.2975, 6.05 > texture { T_Chrome_1Aa } } //left frame
  box { < -8.63, 5.12, 5.9 > < -6.02, 5.2975, 6.05 > texture { T_Chrome_1Aa } } //upper frame
  box { < -6.17, 0.12, 5.9 > < -6.02, 5.2975, 6.05 > texture { T_Chrome_1Aa } } //right frame
  box { < -8.63, 0.12, 5.9 > < -6.02, 0.27, 6.05 > texture { T_Chrome_1Aa } } //lower frame
  union {        // hand rail
    difference {
      box { < -8.67, 2.55, 5.7 > < -6.08, 2.70, 5.75 > texture { T_Chrome_1Aa } } // rail
      union {      // grip slots
        box { < -8.65, 2.575, 5.6 > < -6.10, 2.585, 5.72 > texture { T_Chrome_1A } }
        box { < -8.65, 2.605, 5.6 > < -6.10, 2.615, 5.72 > texture { T_Chrome_1A } }
        box { < -8.65, 2.635, 5.6 > < -6.10, 2.645, 5.72 > texture { T_Chrome_1A } }
        box { < -8.65, 2.665, 5.6 > < -6.10, 2.675, 5.72 > texture { T_Chrome_1A } }
      }
    }
    box { < -8.78, 2.60, 5.7 > < -8.74, 2.65, 5.95 > texture { T_Chrome_1Aa } } //left brace
    box { < -6.08, 2.60, 5.7 > < -6.02, 2.65, 5.95 > texture { T_Chrome_1Aa } } //right brace
  }
  difference {     // lock
    union {
      cylinder { < -6.095, 3.00, 5.8725 > < -6.095, 3.00, 5.95 > 0.05  texture { T_Brass_1B } }
      cylinder { < -6.095, 3.00, 5.87 > < -6.095, 3.00, 5.95 > 0.045 texture { T_Brass_2A } }
    }
    box { < -6.092, 2.98, 5.8 > < -6.098, 3.02, 5.94 > pigment { Black } } //texture { T_Chrome_1Aa } }
  }
  box { < -8.65, 0.2, 5.925 > < -6.15, 5.15, 6.025 > texture { T_Glass1 } hollow } //door glass
  light_source {  // neon OPEN sign
    0*x
    NeonPink
    fade_distance 2
    fade_power 5
    translate < -8.1, 4.6, 6.1 >    // outside the window: < -8.15, 4.6, 5.85 >
    looks_like { OPENsign }
  }
  polygon  // VISA/MS stickers ( Actually changed to CasterCard and WICCA )
  {
    5, // number of points
    <0, 0>, <0, 1>, <2, 1>, <2, 0>, <0, 0>
    pigment { image_map
      {
        gif "vmcd.gif"
        map_type 0       // 0=planar, 1=spherical, 2=cylindrical, 5=torus
        interpolate 2    // 0=none, 1=linear, 2=bilinear, 4=normalized distance
        filter 15 1.0      // N=all or color index # (0...N), V= value (0.0...1.0)
        once
      }
      scale < 1, 0.8, 1 >
    }
    scale < 0.65, 0.25, 1 >
    translate < -7.0, 2.85, 5.9 >
  }
}

/*
#declare BackWall = union {
object { wall2 scale < 0.5, 0.5, 0.75 > translate < -5.75, -1.25,  6.25 > }
object { wall2 scale < 0.5, 0.5, 0.75 > translate <  5.75, -1.25,  6.25 > }
object { wall2 scale < 0.5, 0.5, 0.75 > translate < -5.75, 2.5,  6.25 > }
object { wall2 scale < 0.5, 0.5, 0.75 > translate <  5.75, 2.5,  6.25 > }
}

#declare TestWall = difference {
    object { BackWall }
    union {
      box { < -9, -1, 5 > < -6, 5.5, 7 > pigment { BakersChoc } }   //door hole
      box { < -1, 2, 5 > < 9, 6, 7 > pigment { BakersChoc } }       //show window hole
    }
  }
*/

#declare FrontBack = union {  // for cookie-type wall each one should rotate < -20, 0, 0 >
                              // and change z-translation from 5.9 to 6.25
                              // for wall2, delete rotation, z-translation should be 5.9
object { wall scale < 0.5, 0.5, 0.75 > rotate x*-20 translate < -5.75, -1.25,  6.25 > }
object { wall scale < 0.5, 0.5, 0.75 > rotate x*-20 translate <  5.75, -1.25,  6.25 > }
object { wall scale < 0.5, 0.5, 0.75 > rotate x*-20 translate < -5.75, 2.5,  6.25 > }
object { wall scale < 0.5, 0.5, 0.75 > rotate x*-20 translate <  5.75, 2.5,  6.25 > }
}

#declare StoreFront = difference {
    object { FrontBack }
    union {
      box { < -9, -1, 5 > < -6, 5.5, 7 > pigment { BakersChoc } }   //door hole
      box { < -1, 2, 5 > < 9, 6, 7 > pigment { BakersChoc } }       //show window hole
    }
  }

#declare vial = union {
  union {
    lathe {
      linear_spline
      11  // control points
      <0.006296, 0.014123>, <0.073847, 0.010465>, <0.128297, 0.152884>, <0.183257, 0.271737>,
      <0.257853, 0.398203>, <0.324336, 0.451733>, <0.391605, 0.477353>, <0.502016, 0.489248>,
      <0.77903, 0.489185>, <0.777248, 0.77646>, <0.000289, 0.775083>
      rotate <90,0,90>
      rotate -90.0*x
      translate  3.55*y
    }
    lathe {
      linear_spline
      27  // control points
      <0.013102, 0.057769>, <0.152996, 0.058021>, <0.274358, 0.03798>, <0.403049, 0.008536>,
      <0.686405, 0.006467>, <0.768079, 0.02686>, <0.815722, 0.084348>, <0.836481, 0.196815>,
      <0.836141, 3.155102>, <0.796401, 3.193689>, <0.717332, 3.237434>, <0.660383, 3.302705>,
      <0.641514, 3.374057>, <0.631968, 3.439827>, <0.63561, 3.505269>, <0.683753, 3.571421>,
      <0.713795, 3.593642>, <0.754751, 3.616395>, <0.806483, 3.643233>, <0.790138, 3.797215>,
      <0.787917, 3.859727>, <0.745192, 3.892444>, <0.320936, 3.893115>, <0.255256, 3.863397>,
      <0.20884, 3.800454>, <0.16935, 3.620809>, <0.128807, 3.382854>
      rotate <90,0,90>
      rotate -90.0*x
    }
    hollow
  }
  cylinder { // Liquid
    <0,0,1>, <0,0,0>, 1
    texture { T_Orange_Glass }
    scale <0.7, 0.7, 2.5>
    rotate -90.0*x
    translate  0.2*y
  }
}

#declare bend = union {  // slight S-curve bend, lays flat along Z-axis
  object { sixteenth_bend2 rotate < 180, 180, 0 > translate < 1.95, 0, 0.45 > }
  object { sixteenth_bend2 rotate < 0, 0, 0 > translate < 0, 0, 0 > }
}

#declare broomhandle = union {
  object { bend }
  cylinder { <0.95,0,0.65>, <2,0,4>, 0.25 }
  cylinder { <0.975,0,-0.25>, <0,0,-4>, 0.25 }
  sphere { <0, 0, -4> 0.25 }
}

#declare straws = union {
  cylinder { <1,0,0>, <1,-0.3,4>, 0.025 rotate z*000 }
  cylinder { <1,0,0>, <1,-0.5,4>, 0.025 rotate z*005 }
  cylinder { <1,0,0>, <1,0.4,4>, 0.025 rotate z*010 }
  cylinder { <1,0,0>, <1,0.7,4>, 0.025 rotate z*015 }
  cylinder { <1,0,0>, <1,0.3,4>, 0.025 rotate z*020 }
  cylinder { <1,0,0>, <1,0.8,4>, 0.025 rotate z*025 }
  cylinder { <1,0,0>, <1,-0.5,4>, 0.025 rotate z*030 }
  cylinder { <1,0,0>, <1,0.6,4>, 0.025 rotate z*035 }
  cylinder { <1,0,0>, <1,-0.1,4>, 0.025 rotate z*040 }
  cylinder { <1,0,0>, <1,0.2,4>, 0.025 rotate z*045 }
  cylinder { <1,0,0>, <1,0.1,4>, 0.025 rotate z*050 }
  cylinder { <1,0,0>, <1,-0.2,4>, 0.025 rotate z*055 }
  cylinder { <1,0,0>, <1,-0.5,4>, 0.025 rotate z*060 }
  cylinder { <1,0,0>, <1,0.2,4>, 0.025 rotate z*065 }
  cylinder { <1,0,0>, <1,-0.9,4>, 0.025 rotate z*070 }
  cylinder { <1,0,0>, <1,0.5,4>, 0.025 rotate z*075 }
  cylinder { <1,0,0>, <1,0.6,4>, 0.025 rotate z*080 }
  cylinder { <1,0,0>, <1,-0.3,4>, 0.025 rotate z*085 }
  cylinder { <1,0,0>, <1,0.5,4>, 0.025 rotate z*090 }
  cylinder { <1,0,0>, <1,0.4,4>, 0.025 rotate z*095 }
  cylinder { <1,0,0>, <1,-0.6,4>, 0.025 rotate z*100 }
  cylinder { <1,0,0>, <1,0.3,4>, 0.025 rotate z*105 }
  cylinder { <1,0,0>, <1,0.2,4>, 0.025 rotate z*110 }
  cylinder { <1,0,0>, <1,-0.8,4>, 0.025 rotate z*115 }
  cylinder { <1,0,0>, <1,0.3,4>, 0.025 rotate z*120 }
  cylinder { <1,0,0>, <1,0.5,4>, 0.025 rotate z*125 }
  cylinder { <1,0,0>, <1,-0.4,4>, 0.025 rotate z*130 }
  cylinder { <1,0,0>, <1,-0.7,4>, 0.025 rotate z*135 }
  cylinder { <1,0,0>, <1,0.2,4>, 0.025 rotate z*140 }
  cylinder { <1,0,0>, <1,-0.3,4>, 0.025 rotate z*145 }
  cylinder { <1,0,0>, <1,0.7,4>, 0.025 rotate z*150 }
  cylinder { <1,0,0>, <1,0.5,4>, 0.025 rotate z*155 }
  cylinder { <1,0,0>, <1,-0.3,4>, 0.025 rotate z*160 }
  cylinder { <1,0,0>, <1,0.9,4>, 0.025 rotate z*165 }
  cylinder { <1,0,0>, <1,-0.2,4>, 0.025 rotate z*170 }
  cylinder { <1,0,0>, <1,-0.8,4>, 0.025 rotate z*175 }
  cylinder { <1,0,0>, <1,0.2,4>, 0.025 rotate z*180 }
  cylinder { <1,0,0>, <1,0.5,4>, 0.025 rotate z*185 }
  cylinder { <1,0,0>, <1,0.4,4>, 0.025 rotate z*190 }
  cylinder { <1,0,0>, <1,-0.1,4>, 0.025 rotate z*195 }
  cylinder { <1,0,0>, <1,0.5,4>, 0.025 rotate z*200 }
  cylinder { <1,0,0>, <1,0.4,4>, 0.025 rotate z*205 }
  cylinder { <1,0,0>, <1,-0.5,4>, 0.025 rotate z*210 }
  cylinder { <1,0,0>, <1,-0.4,4>, 0.025 rotate z*215 }
  cylinder { <1,0,0>, <1,0.7,4>, 0.025 rotate z*220 }
  cylinder { <1,0,0>, <1,0.4,4>, 0.025 rotate z*225 }
  cylinder { <1,0,0>, <1,0.6,4>, 0.025 rotate z*230 }
  cylinder { <1,0,0>, <1,-0.4,4>, 0.025 rotate z*235 }
  cylinder { <1,0,0>, <1,0.1,4>, 0.025 rotate z*240 }
  cylinder { <1,0,0>, <1,0.5,4>, 0.025 rotate z*245 }
  cylinder { <1,0,0>, <1,-0.4,4>, 0.025 rotate z*250 }
  cylinder { <1,0,0>, <1,0.4,4>, 0.025 rotate z*255 }
  cylinder { <1,0,0>, <1,0.8,4>, 0.025 rotate z*260 }
  cylinder { <1,0,0>, <1,0.4,4>, 0.025 rotate z*265 }
  cylinder { <1,0,0>, <1,-0.5,4>, 0.025 rotate z*270 }
  cylinder { <1,0,0>, <1,0.6,4>, 0.025 rotate z*275 }
  cylinder { <1,0,0>, <1,0.2,4>, 0.025 rotate z*280 }
  cylinder { <1,0,0>, <1,-0.5,4>, 0.025 rotate z*285 }
  cylinder { <1,0,0>, <1,0.4,4>, 0.025 rotate z*290 }
  cylinder { <1,0,0>, <1,0.8,4>, 0.025 rotate z*295 }
  cylinder { <1,0,0>, <1,0.1,4>, 0.025 rotate z*300 }
  cylinder { <1,0,0>, <1,-0.3,4>, 0.025 rotate z*305 }
  cylinder { <1,0,0>, <1,-0.7,4>, 0.025 rotate z*310 }
  cylinder { <1,0,0>, <1,-0.4,4>, 0.025 rotate z*315 }
  cylinder { <1,0,0>, <1,0.3,4>, 0.025 rotate z*320 }
  cylinder { <1,0,0>, <1,0.5,4>, 0.025 rotate z*325 }
  cylinder { <1,0,0>, <1,-0.5,4>, 0.025 rotate z*330 }
  cylinder { <1,0,0>, <1,0.4,4>, 0.025 rotate z*335 }
  cylinder { <1,0,0>, <1,0.4,4>, 0.025 rotate z*340 }
  cylinder { <1,0,0>, <1,-0.2,4>, 0.025 rotate z*345 }
  cylinder { <1,0,0>, <1,-0.5,4>, 0.025 rotate z*350 }
  cylinder { <1,0,0>, <1,0.1,4>, 0.025 rotate z*355 }
}

#declare broomstraw = union {
  torus { 1, 0.025 rotate z*000 }
  torus { 1, 0.025 rotate z*005 }
  torus { 1, 0.025 rotate z*010 }
  torus { 1, 0.025 rotate z*015 }
  torus { 1, 0.025 rotate z*020 }
  torus { 1, 0.025 rotate z*025 }
  torus { 1, 0.025 rotate z*030 }
  torus { 1, 0.025 rotate z*035 }
  torus { 1, 0.025 rotate z*040 }
  torus { 1, 0.025 rotate z*045 }
  torus { 1, 0.025 rotate z*050 }
  torus { 1, 0.025 rotate z*055 }
  torus { 1, 0.025 rotate z*060 }
  torus { 1, 0.025 rotate z*065 }
  torus { 1, 0.025 rotate z*070 }
  torus { 1, 0.025 rotate z*075 }
  torus { 1, 0.025 rotate z*080 }
  torus { 1, 0.025 rotate z*085 }
  torus { 1, 0.025 rotate z*090 }
  torus { 1, 0.025 rotate z*095 }
  torus { 1, 0.025 rotate z*100 }
  torus { 1, 0.025 rotate z*105 }
  torus { 1, 0.025 rotate z*110 }
  torus { 1, 0.025 rotate z*115 }
  torus { 1, 0.025 rotate z*120 }
  torus { 1, 0.025 rotate z*125 }
  torus { 1, 0.025 rotate z*130 }
  torus { 1, 0.025 rotate z*135 }
  torus { 1, 0.025 rotate z*140 }
  torus { 1, 0.025 rotate z*145 }
  torus { 1, 0.025 rotate z*150 }
  torus { 1, 0.025 rotate z*155 }
  torus { 1, 0.025 rotate z*160 }
  torus { 1, 0.025 rotate z*165 }
  torus { 1, 0.025 rotate z*170 }
  torus { 1, 0.025 rotate z*175 }
  torus { 1, 0.025 rotate z*180 }
  sphere { < 0, 0, 0 > 0.95 }
  object { straws }
  object { straws scale < 0.85, 0.85, 0.95 > rotate z*30 }
  object { straws scale < 1, 1, 0.9 > rotate z*-60 }
  object { straws scale < 0.75, 0.75, 1 > rotate z*45 }
  object { straws scale < 0.9, 0.9, 0.9 > rotate z*-75 }
  texture { pigment { Sienna } }
}

#declare broom1 = union {
  object { broomhandle texture { T_Wood34 rotate z*120 } rotate y*-20 translate < -0.5, 0, -5 > }
   //T_Wood7, 13, 34 - light medium light, medium
  object { broomstraw scale 0.75 }  //translate < 3, 6, 5 >
  cylinder { < 0, 0, 0.2 > < 0, 0, 0.25 > 0.8
    texture{ pigment{ gradient x
                      color_map{[0.0 Scarlet][0.5 Yellow][1.0 HuntersGreen]}
                      scale 0.24 } } }
  cylinder { < 0, 0, 0.275 > < 0, 0, 0.325 > 0.8
    texture{ pigment{ gradient x
                      color_map{[0.0 HuntersGreen][0.5 Scarlet][1.0 Yellow]}
                      scale 0.24 } } }
  cylinder { < 0, 0, 0.35 > < 0, 0, 0.4 > 0.8
    texture{ pigment{ gradient x
                      color_map{[0.0 Yellow][0.5 HuntersGreen][1.0 Scarlet]}
                      scale 0.24 } } }
}

#declare broom2 = union {
  object { broomhandle texture { T_Wood7 rotate z*120 } rotate y*-20 translate < -0.5, 0, -5 > }
   //T_Wood7, 13, 34 - light medium light, medium
  object { broomstraw scale 0.75 }  //translate < 3, 6, 5 >
  cylinder { < 0, 0, 0.2 > < 0, 0, 0.25 > 0.8
    texture{ pigment{ gradient x
                      color_map{[0.0 RichBlue][1.0 Coral]}
                      scale 0.24 } } }
  cylinder { < 0, 0, 0.275 > < 0, 0, 0.325 > 0.8
    texture{ pigment{ gradient x
                      color_map{[0.0 Coral][1.0 RichBlue]}
                      scale 0.24 } } }
  cylinder { < 0, 0, 0.35 > < 0, 0, 0.4 > 0.8
    texture{ pigment{ gradient x
                      color_map{[0.0 RichBlue][1.0 Coral]}
                      scale 0.24 } } }
}

#declare nut = union {
  sphere { < 0, 0, 0 >, 1 }
  intersection {
    box { < -1.25, -0.75, -1.25 >, < 1.25, 0.25, 1.25 > }
    box { < -1.25, -0.75, -1.25 >, < 1.25, 0.25, 1.25 > rotate < 0, 45, 0 > }
  }
  scale 0.075
  texture { T_Chrome_2A }
}

#declare fastening_plate = difference {
  union {
    cylinder { < 0, 0, 0 > < 0, 0, 0.1 > 0.5 }
    cone { <0, 0, 0.1>, 0.5, <0, 0, 0.2>, 0.25 }
  }
  union {
    cylinder { < 0, -0.35, 0.05 > < 0, -0.35, 0.5 > 0.06 }
    cylinder { < 0,  0.35, 0.05 > < 0,  0.35, 0.5 > 0.06 }
  }
}

#declare holder = union {
  difference {
    difference {
      cylinder { < 0, 0, 0 > < 0, 0, 0.35 > 0.35 }
      box { < -1, 0.25, -1 > < 1, 1, 1 > }
    }
    cylinder { < 0, 0, -0.5 > < 0, 0, 0.5 > 0.3 }
  }
  object { nut translate < 0, -0.2, 0.18 > }
}

#declare rack = union {
  object { quarter_bend rotate < 0, 45, 0 > translate < 10, 0, 0 > }
  object { quarter_bend rotate < 0, 135, 0 > }
  cylinder { < 0, 0, -1 > < 10, 0, -1 > torus_width }
  cylinder { < -1, 0, 0 > < -1, 0, 4 > torus_width }
  cylinder { < 11, 0, 0 > < 11, 0, 4 > torus_width }
  object { fastening_plate rotate x*180 translate < -1, 0, 4 > }
  object { fastening_plate rotate x*180 translate < 11, 0, 4 > }
  object { holder rotate x*200 translate < 1, -0.65, -1 > }
  object { holder rotate x*200 translate < 3, -0.65, -1 > }
  object { holder rotate x*200 translate < 5, -0.65, -1 > }
  object { holder rotate x*200 translate < 7, -0.65, -1 > }
  object { holder rotate x*200 translate < 9, -0.65, -1 > }
  box { < -0.75, -2, 3.5 > < 10.75, 0.5, 3.35 > rotate x*10 translate < 0, 1.5, 0 > }
  cylinder { < 2, -0.15, -1 > < 2, -1, 3 > 0.05 }
  cylinder { < 4, -0.15, -1 > < 4, -1, 3 > 0.05 }
  cylinder { < 6, -0.15, -1 > < 6, -1, 3 > 0.05 }
  cylinder { < 8, -0.15, -1 > < 8, -1, 3 > 0.05 }
  object { nut rotate z*90 translate < -1.3, 0, 3.35 > }
  object { nut rotate z*-90 translate < 11.3, 0, 3.35 > }
}

#declare parking_area = union {
  object { rack texture { T_Chrome_1B } scale 0.5 rotate <90,0,0> }
  object { broom1 scale 0.25 rotate x*90 translate < 0.35, -0.75, -0.3 > }
  object { broom2 scale 0.25 rotate <89, 120, 0 > translate < 3.55, -0.75, -0.3 > }
}

#declare sidewalk = union {
  union {
    box { < -20.9, -1, 1 > < -12, 0, 20 > }
    box { < -11.9, -1, 1 > < -7, 0, 20 > }
    box { < -6.9, -1, 1 > < -2, 0, 20 > }
    box { < -1.9, -1, 1 > < 3, 0, 20 > }
    box { < 3.1, -1, 1 > < 8, 0, 20 > }
    box { < 8.1, -1, 1 > < 13, 0, 20 > }
    box { < 13.1, -1, 1 > < 20, 0, 20 > }
    box { < -18, -1, 1 > < 18, -0.025, 20 > }
    texture { pigment { Wheat } finish { crand 0.1 } }
  }
  union {
    box { < -18, -1, 0 > < -12, 0, 0.95 > }
    box { < -11.9, -1, 0 > < -7, 0, 0.95 > }
    box { < -6.9, -1, 0 > < -2, 0, 0.95 > }
    box { < -1.9, -1, 0 > < 3, 0, 0.95 > }
    box { < 3.1, -1, 0 > < 8, 0, 0.95 > }
    box { < 8.1, -1, 0 > < 13, 0, 0.95 > }
    box { < 13.1, -1, 0 > < 18, 0, 0.95 > }
    box { < -18, -1, 0.1 > < 18, -0.025, 0.95 > }
    texture { pigment { Yellow } finish { crand 0.1 } }
  }
}

#declare mortar_bowl = union {
  cylinder { < 0, 0, 0 > < 0, 0.1, 0 > 0.25 }
  difference {
    difference {
      sphere { < 0, 0.5, 0 >, 0.5 }
      box { < -1, 0.5, -1 > < 1, 1, 1 > }
    }
    sphere { < 0, 0.5, 0 >, 0.4 }
  }
  torus { 0.45, 0.05 translate y*0.5 }
  texture { T_Stone17 scale 2 }
}

#declare pestle = union {
  sphere { < 0, 0, 0 >, 0.15 }
  sphere { < 0, 0.7, 0 >, 0.1 }
  cylinder { < 0, 0, 0 > < 0, 0.7, 0 > 0.075 }
  texture { T_Stone17 scale 2 }
}
#declare mortar_and_pestle = union {
  object { mortar_bowl }
  object { pestle rotate z*45 translate y*0.25 }
}

#declare pentagram = union {
  cylinder { < -1, 0, 0 > < 0, 2.45, 0 > 0.025 }
  cylinder { < 0, 2.45, 0 > < 1, 0, 0 > 0.025 }
  cylinder { < -1.35, 1.5, 0 > < 1.35, 1.5, 0 > 0.025 }
  cylinder { < -1.35, 1.5, 0 > < 1, 0, 0 > 0.025 }
  cylinder { < -1, 0, 0 > < 1.35, 1.5, 0 > 0.025 }
}

#declare amulet = union {
  object { pentagram pigment { Red } }
  torus { 1.5, 0.05 pigment { Yellow } rotate < 90, 0, 90 > translate y*1 }
  torus { 0.063, 0.015 pigment { Black } rotate z*75 translate < -0.065, 2.5, 0 > } // left knot
  torus { 0.063, 0.015 pigment { Black } rotate z*75 translate < -0.12, 2.5, 0 > } // left knot
  torus { 0.063, 0.015 pigment { Black } rotate z*105 translate <  0.065, 2.5, 0 > } // right knot
  torus { 0.063, 0.015 pigment { Black } rotate z*105 translate <  0.12, 2.5, 0 > } // right knot
  torus { 0.08, 0.015 pigment { Black } translate < 0, 2.585, 0 > } // upper knot
  torus { 0.063, 0.015 pigment { Black } translate < 0, 2.63, 0 > } // upper knot
  torus { 2.0, 0.05 pigment { Black } scale < 0.2, 1.5, 1 > rotate x*90 translate y*4.6 }
  cylinder { < 0, -2.025, 0 > < 0, -0.5, 0 > 0.015 pigment { Black } }
  sphere { < 0, -1.1, 0 > 0.1 pigment { Orchid } }
  sphere { < 0, -1.6, 0 > 0.1 pigment { ForestGreen } }
  sphere { < 0, -2.025, 0 > 0.1 pigment { Turquoise } }
  torus { 0.063, 0.015 pigment { Black } rotate z*90 translate y*-0.5 }
  cylinder { < -0.3, -2, 0 > < -0.3, -0.5, 0 > 0.015 pigment { Black } }
  sphere { < -0.3, -1.0, 0 > 0.1 pigment { Goldenrod } }
  sphere { < -0.3, -1.5, 0 > 0.1 pigment { MandarinOrange } }
  sphere { < -0.3, -2.0, 0 > 0.1 pigment { MediumOrchid } }
  torus { 0.063, 0.015 pigment { Black } rotate z*75 translate < -0.28, -0.475, 0 > }
  cylinder { < 0.3, -2, 0 > < 0.3, -0.5, 0 > 0.015 pigment { Black } }
  sphere { < 0.3, -1.0, 0 > 0.1 pigment { Coral } }
  sphere { < 0.3, -1.5, 0 > 0.1 pigment { RichBlue } }
  sphere { < 0.3, -2.0, 0 > 0.1 pigment { Red } }
  torus { 0.063, 0.015 pigment { Black } rotate z*105 translate < 0.28, -0.475, 0 > }
}

#declare cauldron = union {
  cylinder { < 0, 0, 0 > < 0, 0.1, 0 > 0.25 }
  difference {
    difference {
      sphere { < 0, 0.5, 0 >, 0.5 }
      box { < -1, 0.5, -1 > < 1, 1, 1 > }
    }
    sphere { < 0, 0.5, 0 >, 0.4 }
  }
  difference {
    sphere { < 0, 0, 0 > 0.5 }
    union {
      sphere { < 0, 0, 0 > 0.4 }
      torus { 0.6, 0.15 }
      box { < -0.5, 0.1, -0.5 > < 0.5, 0.5, 0.5 > }
      box { < -0.5, -0.1, -0.5 > < 0.5, -0.5, 0.5 > }
    }
    translate y*0.631
  }
  torus { 0.45, 0.05 translate y*0.5 }
  difference {
    torus { 0.475, 0.05 }
    box { < -0.5, -0.1, -0.5 > < 0.5, -0.05, 0.5 > }
    translate y*0.775
  }
  object { pentagram pigment { Red } scale < 0.075, 0.075, 1 > rotate x*-10 translate < 0, 0.325, -0.46 > }
  texture { T_Iron_1A }
}

#declare windowitems = union {
 object { vial texture { T_Vicksbottle_Glass } scale < 0.15, 0.225, 0.15 > translate < -0.1, 2,  6.3 > }
 object { vial texture { T_Vicksbottle_Glass } scale < 0.15, 0.225, 0.15 > translate < -0.1, 2,  6.65 > }
 object { vial texture { T_Vicksbottle_Glass } scale < 0.15, 0.225, 0.15 > translate < -0.1, 2,  7.0 > }
 object { vial texture { T_Vicksbottle_Glass } scale < 0.15, 0.225, 0.15 > translate < -0.1, 2,  7.35 > }
 object { vial texture { T_Dark_Green_Glass } scale < 0.15, 0.275, 0.15 > translate < 0.3, 2,  6.3 > }
 object { vial texture { T_Dark_Green_Glass } scale < 0.15, 0.275, 0.15 > translate < 0.3, 2,  6.65 > }
 object { vial texture { T_Dark_Green_Glass } scale < 0.15, 0.275, 0.15 > translate < 0.3, 2,  7.0 > }
 object { vial texture { T_Dark_Green_Glass } scale < 0.15, 0.275, 0.15 > translate < 0.3, 2,  7.35 > }
 object { vial texture { T_Beerbottle_Glass } scale < 0.15, 0.23, 0.15 > translate < 0.7, 2,  6.3 > }
 object { vial texture { T_Beerbottle_Glass } scale < 0.15, 0.23, 0.15 > translate < 0.7, 2,  6.65 > }
 object { vial texture { T_Beerbottle_Glass } scale < 0.15, 0.23, 0.15 > translate < 0.7, 2,  7.0 > }
 object { vial texture { T_Beerbottle_Glass } scale < 0.15, 0.23, 0.15 > translate < 0.7, 2,  7.35 > }
 object { vial texture { T_Orange_Glass } scale < 0.15, 0.25, 0.15 > translate < 1.1, 2,  6.3 > }
 object { vial texture { T_Orange_Glass } scale <0.15, 0.25, 0.15 > translate < 1.1, 2,  6.65 > }
 object { vial texture { T_Orange_Glass } scale <0.15, 0.25, 0.15 > translate < 1.1, 2,  7.0 > }
 object { vial texture { T_Orange_Glass } scale <0.15, 0.25, 0.15 > translate < 1.1, 2,  7.35 > }
 object { vial texture { T_Dark_Green_Glass } scale < 0.15, 0.18, 0.15 > translate < 1.5, 2,  6.3 > }
 object { vial texture { T_Dark_Green_Glass } scale < 0.15, 0.18, 0.15 > translate < 1.5, 2,  6.65 > }
 object { vial texture { T_Dark_Green_Glass } scale < 0.15, 0.18, 0.15 > translate < 1.5, 2,  7.0 > }
 object { vial texture { T_Dark_Green_Glass } scale < 0.15, 0.18, 0.15 > translate < 1.5, 2,  7.35 > }
 object { mortar_and_pestle scale 0.75 rotate y*10 translate < 5.75, 2, 7 > }
 object { mortar_and_pestle scale 0.75 rotate y*-70 translate < 7.25, 2, 7.2 > }
 object { cauldron scale 2 translate < 3.5, 2, 7.25 > }
 object { amulet scale 0.35 translate < 6.5, 3.65, 6.1 > }
}

#declare ShoppeWindow = union {
//  Frame around shoppe window
//  cylinder { < -0.9, 2.0, 5.9 > < -0.9, 6.0, 5.9 > 0.1 texture { cane_texture scale 0.4 rotate z*90 } } //left
//  cylinder { < -0.9, 5.9, 5.9 > <  8.9, 5.9, 5.9 > 0.1 texture { cane_texture scale 0.4 rotate z*90 } } //upper
//  cylinder { <  8.9, 2.0, 5.9 > <  8.9, 6.0, 5.9 > 0.1 texture { cane_texture scale 0.4 rotate z*90 } } //right
//  cylinder { < -0.9, 2.1, 5.9 > <  8.9, 2.1, 5.9 > 0.1 texture { cane_texture scale 0.4 rotate z*90 } } //lower
  box { < -1.2, 1.8, 5.8 > < -0.8, 6.0, 5.9 > texture { T_Wood12 rotate x*90 } } //left
  box { < -1.2, 5.8, 5.8 > <  9.2, 6.2, 5.9 > texture { T_Wood12 } } //upper
  box { <  8.8, 2.0, 5.8 > <  9.2, 6.2, 5.9 > texture { T_Wood12 rotate x*90 } } //right
  box { < -1.2, 1.8, 5.8 > <  9.2, 2.2, 5.9 > texture { T_Wood12 } } //lower
  object { red_gumdrop scale < 0.2, 0.2, 0.2 > rotate x*-90 translate <-1.0, 2.7, 6.0 > }
  object { green_gumdrop scale < 0.2, 0.2, 0.2 > rotate x*-90 translate <-1.0, 3.8, 6.0 > }
  object { yellow_gumdrop scale < 0.2, 0.2, 0.2 > rotate x*-90 translate <-1.0, 4.9, 6.0 > }
  object { purple_gumdrop scale < 0.2, 0.2, 0.2 > rotate x*-90 translate <-1.0, 6.0, 6.0 > }
  object { blue_gumdrop scale < 0.2, 0.2, 0.2 > rotate x*-90 translate <0.15, 6.0, 6.0 > }
  object { red_gumdrop scale < 0.2, 0.2, 0.2 > rotate x*-90 translate < 1.25, 6.0, 6.0 > }
  object { green_gumdrop scale < 0.2, 0.2, 0.2 > rotate x*-90 translate <2.35, 6.0, 6.0 > }
  object { yellow_gumdrop scale < 0.2, 0.2, 0.2 > rotate x*-90 translate <3.45, 6.0, 6.0 > }
  object { purple_gumdrop scale < 0.2, 0.2, 0.2 > rotate x*-90 translate <4.55, 6.0, 6.0 > }
  object { blue_gumdrop scale < 0.2, 0.2, 0.2 > rotate x*-90 translate <5.65, 6.0, 6.0 > }
  object { red_gumdrop scale < 0.2, 0.2, 0.2 > rotate x*-90 translate < 6.75, 6.0, 6.0 > }
  object { green_gumdrop scale < 0.2, 0.2, 0.2 > rotate x*-90 translate <7.85, 6.0, 6.0 > }
  object { yellow_gumdrop scale < 0.2, 0.2, 0.2 > rotate x*-90 translate <9.0, 6.0, 6.0 > }
  object { purple_gumdrop scale < 0.2, 0.2, 0.2 > rotate x*-90 translate <9.0, 4.9, 6.0 > }
  object { blue_gumdrop scale < 0.2, 0.2, 0.2 > rotate x*-90 translate <9.0, 3.8, 6.0 > }
  object { red_gumdrop scale < 0.2, 0.2, 0.2 > rotate x*-90 translate < 9.0, 2.7, 6.0 > }
  box { < -1.0, 2.0, 6.1 > <  9.0, 2.2, 8.2 > texture { T_Wood12 } } //shelf
  box { < -0.9, 2.1, 6.0 > < 8.9, 5.9, 6.01 > texture { T_Glass1 } hollow } //window pane
//  Shoppe floor
  box { < -11.0, -0.5, 6.0 > < 11.0, 0.1, 15.0 > texture { T_Wood12 } }
  object { windowitems translate y*0.2 }
  text
  {
    ttf          // font type (only TrueType format for now)
    //"c:\win\fonts\tt0211m_.ttf",    // Americana Text TT Font
    //translate < -0.3, 3.75, 5.65 >
    //scale 1.25

    //"c:\win\fonts\mtcorsva.ttf",    // Monotype Corsiva TT Font
    //translate < -0.3, 4.75, 5.65 >
    //scale 1

    "c:\win\fonts\gaeil1.ttf",      // Gaeilge TT Font
    //translate < -0.7, 8.25, 9.6 >
    //scale 0.625

    "Grimm's Magicke Shoppe",   // the string to create
    0.01,           // the extrusion depth
    0            // offset
    translate < -0.75, 8.25, 9.6 >
    scale 0.625
    texture { pigment { OrangeRed filter 0.5 } }
  }
}

#declare can1 = union {
  cylinder { < 0, 0, 0 > < 0, 1, 0 > 1 texture { T_Chrome_1A } }
  cylinder { < 0, 0.1, 0 > < 0, 0.9, 0 > 1.01
    pigment { image_map
      { gif "canlabl1.gif" map_type 2 interpolate 0 once }
      scale < 0.5, 1, 0.5 >
      translate < 0.75, 0, 0 >
    }
  }
}

#declare can2 = union {
  cylinder { < 0, 0, 0 > < 0, 1, 0 > 1 texture { T_Chrome_1A } }
  cylinder { < 0, 0.1, 0 > < 0, 0.9, 0 > 1.01
    pigment { image_map
      { gif "canlabl2.gif" map_type 2 interpolate 2 once }
      scale < 0.5, 1, 0.5 >
      translate < 0.75, 0, 0 >
    }
  }
}

#declare can3 = union {
  cylinder { < 0, 0, 0 > < 0, 1, 0 > 1 texture { T_Chrome_1A } }
  cylinder { < 0, 0.1, 0 > < 0, 0.9, 0 > 1.01
    pigment { image_map
      { gif "canlabl3.gif" map_type 2 interpolate 2 once }
      scale < 0.5, 1, 0.5 >
      translate < 0.75, 0, 0 >
    }
  }
}

#declare can4 = union {
  cylinder { < 0, 0, 0 > < 0, 1, 0 > 1 texture { T_Chrome_1A } }
  cylinder { < 0, 0.1, 0 > < 0, 0.9, 0 > 1.01
    pigment { image_map
     { gif "canlabl4.gif" map_type 2 interpolate 4 once }
      scale < 0.5, 1, 0.5 >
      translate < 0.75, 0, 0 >
    }
  }
}

#declare greenbox =
  box { < 0, 0, 0 > < 0.7, 1.1, 0.5 > pigment { image_map
      { gif "greenlbl.gif" map_type 0 interpolate 2 }
      scale < 0.95, 1.75, 1 >
      translate < -0.12, -0.5, 0 >
    }
  }

#declare redbox =
  box { < 0, 0, 0 > < 0.7, 1.1, 0.5 > pigment { image_map
      { gif "redlbl.gif" map_type 0 interpolate 2 }
      scale < 0.95, 1.75, 1 >
      translate < -0.12, -0.5, 0 >
    }
  }

#declare bluebox =
  box { < 0, 0, 0 > < 0.7, 1.1, 0.5 > pigment { image_map
      { gif "bluelbl.gif" map_type 0 interpolate 2 }
      scale < 0.95, 1.75, 1 >
      translate < -0.12, -0.5, 0 >
    }
  }

#declare yellowbox =
  box { < 0, 0, 0 > < 0.7, 1.1, 0.5 > pigment { image_map
      { gif "yellolbl.gif" map_type 0 interpolate 2 }
      scale < 0.95, 1.75, 1 >
      translate < -0.12, -0.5, 0 >
    }
  }

#declare shelf = union {
  box { < -3, 0.0, 2 > < 3, 2.7, 2.1 > } //back
  box { < -3, 0.7, 0 > < 3, 0.8, 2 > } //lower shelf
  box { < -3, 2.2, 0 > < 3, 2.3, 2 > } //upper shelf
  box { < -3, 0, 0 > < -3.1, 2.7, 2.1 > } //left end
  box { < 3, 0, 0 > < 3, 2.7, 2.1 > } //right end
}

#declare display1 = union {
  object { shelf }
  object { redbox translate < 2.0, 0.8, 0.5 > }
  object { redbox translate < 1.1, 0.8, 0.5 > }
  object { greenbox translate < 0.2, 0.8, 0.5 > }
  object { greenbox translate < -0.7, 0.8, 0.5 > }
  object { yellowbox translate < -1.6, 0.8, 0.5 > }
  object { yellowbox translate < -2.5, 0.8, 0.5 > }
  object { can1 scale < 0.25, 0.75, 0.25 > translate < 2.6, 2.3, 0.5 > }
  object { can1 scale < 0.25, 0.75, 0.25 > translate < 2.0, 2.3, 0.5 > }
  object { can2 scale < 0.25, 0.75, 0.25 > translate < 1.4, 2.3, 0.5 > }
  object { can2 scale < 0.25, 0.75, 0.25 > translate < 0.8, 2.3, 0.5 > }
  object { can3 scale < 0.25, 0.75, 0.25 > translate < 0.2, 2.3, 0.5 > }
  object { can3 scale < 0.25, 0.75, 0.25 > translate < -0.4, 2.3, 0.5 > }
  object { can4 scale < 0.25, 0.75, 0.25 > translate < -1.0, 2.3, 0.5 > }
  object { can4 scale < 0.25, 0.75, 0.25 > translate < -1.6, 2.3, 0.5 > }
  object { can4 scale < 0.25, 0.75, 0.25 > translate < -2.2, 2.3, 0.5 > }
  texture { T_Wood34 scale 0.15 }
}

#declare display2 = union {
  box { < -3, 0.0, 2 > < 3, 2.7, 2.1 > } //back
  box { < -3, 0.7, 0 > < 3, 0.8, 2 > } //lower shelf
  box { < -3, 2.2, 0 > < 3, 2.3, 2 > } //upper shelf
  box { < -3, 0, 0 > < -3.1, 2.7, 2.1 > } //left end
  box { < 3, 0, 0 > < 3, 2.7, 2.1 > } //right end
  object { redbox translate < 2.0, 2.3, 0.5 > }
  object { redbox translate < 1.1, 2.3, 0.5 > }
  object { greenbox translate < 0.2, 2.3, 0.5 > }
  object { greenbox translate < -0.7, 2.3, 0.5 > }
  object { yellowbox translate < -1.6, 2.3, 0.5 > }
  object { yellowbox translate < -2.5, 2.3, 0.5 > }
  object { bluebox translate < -2.8, 2.3, 0.5 > }
//  object { can1 scale < 0.25, 0.75, 0.25 > translate < 2.6, 2.3, 0.5 > }
//  object { can1 scale < 0.25, 0.75, 0.25 > translate < 2.0, 2.3, 0.5 > }
//  object { can2 scale < 0.25, 0.75, 0.25 > translate < 1.4, 2.3, 0.5 > }
//  object { can2 scale < 0.25, 0.75, 0.25 > translate < 0.8, 2.3, 0.5 > }
//  object { can3 scale < 0.25, 0.75, 0.25 > translate < 0.2, 2.3, 0.5 > }
//  object { can3 scale < 0.25, 0.75, 0.25 > translate < -0.4, 2.3, 0.5 > }
//  object { can4 scale < 0.25, 0.75, 0.25 > translate < -1.0, 2.3, 0.5 > }
//  object { can4 scale < 0.25, 0.75, 0.25 > translate < -1.6, 2.3, 0.5 > }
  texture { T_Wood34 scale 0.15 }
}

#declare display3 = union {
  box { < -3, 0.0, 2 > < 3, 2.7, 2.1 > } //back
  box { < -3, 0.7, 0 > < 3, 0.8, 2 > } //lower shelf
  box { < -3, 2.2, 0 > < 3, 2.3, 2 > } //upper shelf
  box { < -3, 0, 0 > < -3.1, 2.7, 2.1 > } //left end
  box { < 3, 0, 0 > < 3, 2.7, 2.1 > } //right end
//  object { redbox translate < 2.0, 0.8, 0.5 > }
//  object { redbox translate < 1.1, 0.8, 0.5 > }
//  object { greenbox translate < 0.2, 0.8, 0.5 > }
//  object { greenbox translate < -0.7, 0.8, 0.5 > }
//  object { yellowbox translate < -1.6, 0.8, 0.5 > }
//  object { yellowbox translate < -2.5, 0.8, 0.5 > }
  object { can4 scale < 0.25, 0.75, 0.25 > translate < 2.6, 2.3, 0.5 > }
  object { can4 scale < 0.25, 0.75, 0.25 > translate < 2.0, 2.3, 0.5 > }
  object { can3 scale < 0.25, 0.75, 0.25 > translate < 1.4, 2.3, 0.5 > }
  object { can3 scale < 0.25, 0.75, 0.25 > translate < 0.8, 2.3, 0.5 > }
  object { can2 scale < 0.25, 0.75, 0.25 > translate < 0.2, 2.3, 0.5 > }
  object { can2 scale < 0.25, 0.75, 0.25 > translate < -0.4, 2.3, 0.5 > }
  object { can1 scale < 0.25, 0.75, 0.25 > translate < -1.0, 2.3, 0.5 > }
  object { can1 scale < 0.25, 0.75, 0.25 > translate < -1.6, 2.3, 0.5 > }
  texture { T_Wood34 scale 0.15 }
}

#declare candy_cane =
  cylinder { < 0, 0, 0 > < 0, 6.95, 0 > 0.3
  texture { cane_texture } }

#declare cash_reg = union {
  box { < 0, 0, 0 > < 0.8, 0.25, 0.25 > }
  difference {
    box { < 0, -0.325, -0.05 > < 0.8, 0.2, 0.3 > }
    box { < 0.3, 0.05, -0.06 > < 0.7, 0.16, -0.04 > pigment { Black } }
  }
  box { < 0, -0.325, -0.05 > < 0.8, -0.1, 0.75 > }
  box { < 0, -0.15, 0.375 > < 0.8, 0, 0.7 > rotate x*22.5 translate < 0, 0.2, 0.075 > }
  cylinder { < 0, 0.2, 0 > < 0.8, 0.2, 0 > 0.05 }
  cylinder { < 0, 0.2, 0.25 > < 0.8, 0.2, 0.25 > 0.05 }
  cylinder { < 0, -0.11, 0.7 > < 0.8, -0.11, 0.7 > 0.05 }
  difference {
    box { < 0, 0, 0 > < 0.8, 0.15, 0.15 > }
    cylinder { < -0.1, 0.15, 0.15 > < 1.1, 0.15, 0.15 > 0.15 }
    translate < 0, 0.05, 0.3 >
  }
  pigment { White }
}

#declare check_out = union {
  object { shelf texture { T_Wood34 scale 0.15 } rotate y*180 }
  object { cash_reg scale 2.2 translate < -2.5, 3.5, -1.8 > }
}

#declare Shoppe = union {
  object { roof translate < 0, 5.5, 5 > }
  object { BackWall translate < 0, 0, 9 > }
//  object { FrontBack translate < 0, 0, 9 > }
  object { StoreFront }
//left wall  --  rotate < -20, 90, 0 >  for cookie wall
  object { wall2 scale < 0.5, 0.5, 0.75 > rotate < 0, -90, 0 > translate < -11.15, -1.25, 12.0 > }
  object { wall2 scale < 0.5, 0.5, 0.75 > rotate < 0, -90, 0 > translate < -11.15,  2.5,  12.0 > }
//right wall
  object { wall2 scale < 0.5, 0.5, 0.75 > rotate < 0, 90, 0 > translate < 11.15, -1.25, 12.0 > }
  object { wall2 scale < 0.5, 0.5, 0.75 > rotate < 0, 90, 0 > translate < 11.15,  2.5,  12.0 > }
  triangle { < -11.15, 6.8, 15.25 > < -11.15, 6.8, 5.5 > < -11.15, 12.80, 10.5 > pigment { BakersChoc } }
  triangle { <  11.15, 6.8, 15.25 > <  11.15, 6.8, 5.5 > <  11.15, 12.80, 10.5 > pigment { BakersChoc } }
  object { display1 translate < 2, 0, 9 > }
  object { display2 translate < 2, 0, 14 > }
  object { display3 rotate y*90 translate < 9, 0, 12 > }
  object { check_out rotate < 0, -90, 0 > translate < -9.5, 0, 12 > }
  object { candy_cane translate < 11.65, 0, 5.9 > }
  object { candy_cane translate < -11.65, 0, 5.9 > }
  object { ShoppeWindow }
  object { ShoppeDoor }
}
