
// Persistence of Vision Ray Tracer v3.1 for Windows Scene Description File
// File: bs-toad.pov
// Vers: 1
// Desc: Parking Violation?  Entry for IRTC July/August Competition - Theme: Magic
// Date: 08/31/97
// Auth: Bob Sewell
//

#version 3

#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "woods.inc"
#include "glass.inc"
#include "metals.inc"
#include "stones.inc"
#include "curves.inc"
#include "bs-magic.inc"
#include "frosting.inc"

global_settings
{
  assumed_gamma 1.0
}

// ----------  Lights, Camera...  ------------------------------

camera
{ location  < 0, 6.75, -20 >        // < 0, 6.75, -20 > final location?
  direction 1.5*z
  right     4/3*x
  angle 50
  look_at   < 0, 3.45,  7 > }      // < 0, 3.45, 7 > final look_at?

light_source // "Sun"
{ 0*x color red 1.0  green 1.0  blue 1.0 translate <-35, 40, -30> }

light_source // Shoppe's Interior Light
{ 0*x color red 0.3  green 0.3  blue 0.3 translate <-3, 12, 10> }

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.75  color SkyBlue]
      [1.00  color CornflowerBlue]
    }
    scale 2
    translate <-1, -1, -1>
  }
  pigment {
    bozo
    turbulence 0.6
    octaves 7
    omega .49876
    lambda 2.5432
    color_map {
      [0.0 color rgbf<.85, .85, .85, 0.1>]
      [0.4 color rgbf<.9, .9, .9, 0.1>]
      [0.7 color rgbf<1, 1, 1, 1>]
    }
    scale 6/10
    scale <1, 0.3, 0.3>
  }
  pigment {
    bozo
    turbulence 0.6
    octaves 8
    omega .5123
    lambda 2.56578
    color_map {
      [0.0 color rgbf<.375, .375, .375, 0.65>]
      [0.4 color rgbf<.45, .45, .45, 0.9>]
      [0.6 color rgbf<0.5, 0.5, 0.5, 1>]
    }
    scale 6/10
    scale <1, 0.3, 0.3>
  }
  rotate y*-90
}

plane { y, -0.5 pigment {color rgb <0.2,0.2,0.25>}}
plane { z, -50 pigment { Black } }

// -----------  Action!  -----------------------------

object { sidewalk }
object { Shoppe }
object { NoParkingSign scale 0.4 translate < 6.5, 0.25, -2.0 > }
object { parking_area translate < 0, 1.5, -2.2 > }

torus { 1, 1
  texture { cane3_texture scale 1.4 }
  scale < 0.4, 0.2, 0.4 >
  rotate x*-90
  translate <-3.5, 4.5, 5.8 >
}

torus { 1, 1
  texture { cane2_texture scale 3 }
  scale < 0.4, 0.2, 0.4 >
  rotate x*-90
  translate <-3.5, 2, 5.8 >
}

object { frosting scale < 0.825, 0.5, 0.5 > translate < 3.9, 2, 5.8 > }

object { icicles1
  texture {
    pigment { color rgb < 0.95, 0.95, 1 > }
    finish { ambient 0.2 diffuse 0.8 phong 1 }
  }
  scale < 0.85, 0.6, 0.65 >
  translate < -6.9, 6.8, 5.75 >
}

object { icicles1
  texture {
    pigment { color rgb < 0.95, 0.95, 1 > }
    finish { ambient 0.2 diffuse 0.8 phong 1 }
  }
  scale < 0.85, 0.55, 0.65 >
  translate < -3.5, 6.8, 5.75 >
}

object { icicles1
  texture {
    pigment { color rgb < 0.95, 0.95, 1 > }
    finish { ambient 0.2 diffuse 0.8 phong 1 }
  }
  scale < 0.85, 0.65, 0.65 >
  translate < 6.9, 6.8, 5.75 >
}

  polygon  // SALE sign in window
  {
    5, // number of points
    <0, 0>, <0, 1>, <2, 1>, <2, 0>, <0, 0>
    pigment { image_map
      {
        gif "sale.gif"
        map_type 0       // 0=planar, 1=spherical, 2=cylindrical, 5=torus
        interpolate 2    // 0=none, 1=linear, 2=bilinear, 4=normalized distance
        filter 15 1.0    // N=all or color index # (0...N), V= value (0.0...1.0)
        once
      }
      scale < 1, 1, 1 >
    }
    scale 1.75
    translate < 0, 3, 5.7 >
  }

#declare eyecup = union {
  difference {
    difference {
      sphere { < 0, 0.5, 0 >, 0.5 }
      box { < -1, 0.5, -1 > < 1, 1, 1 > }
    }
    sphere { < 0, 0.5, 0 >, 0.4 }
  }
  torus { 0.45, 0.05 translate y*0.5 }
}

#declare frog = union {
// head
  difference {
    sphere { <-2,0.5,0>, 0.7 }
    box { <-3,-1.5,-1>, <-1,0.5,1> pigment { Pink } }
    scale < 1.1, 1, 1 >
    rotate z*-10
    translate < 0.9, -0.95, 0 >
  }
  difference {
    sphere { <-2,0.5,0>, 0.7 }
    box { <-3,0.5,-1>, <-1,1.5,1> pigment { Pink } }
    scale < 1.1, 1, 1 >
    rotate z*30
    translate < 0.95, 0.65, 0 >
  }
  object { eyecup scale < 1, 1.25, 1 > rotate z*90 translate < -0.75, 1, -0.5 > }
  object { eyecup scale < 1, 1.25, 1 > rotate z*90 translate < -0.75, 1,  0.5 > }
  sphere { <0,0,0>, 0.45 pigment { White } translate < -1.25, 1, -0.5 > }
  sphere { <0,0,0>, 0.45 pigment { White } translate < -1.25, 1,  0.5 > }
  sphere { <0,0,0>, 0.15 pigment { Black } translate < -1.6, 1, -0.65 > }
  sphere { <0,0,0>, 0.15 pigment { Black } translate < -1.6, 1,  0.35 > }
// body
  sphere { <0,0,0>, 1 scale < 1.5, 1.1, 1 > rotate z*-25 }
// left rear leg
  sphere { <0,0,0>, 0.3 scale < 2.5, 1, 1 > rotate < 0, -30,  10 > translate < 0.50, -0.50, -1 > }
  sphere { <0,0,0>, 0.25 scale < 2.5, 1, 1 > rotate < 0, -30, -20 > translate < 0.55, -0.75, -1 > }
  sphere { <0,0,0>, 0.2 scale < 3.25, 0.8, 1 > rotate < 0, -30, 20 > translate < 0.5, -1.10, -1 > }
  sphere { <0,0,0>, 0.075 scale < 4.5, 0.8, 1 > rotate < 0, -70, 0 > translate < 0.1, -1.30, -1.5 > }
  sphere { <0,0,0>, 0.075 scale < 5.0, 0.8, 1 > rotate < 0, -50, 0 > translate < 0, -1.30, -1.4 > }
  sphere { <0,0,0>, 0.075 scale < 4.0, 0.8, 1 > rotate < 0, -20, 0 > translate < 0, -1.30, -1.25 > }
  sphere { <0,0,0>, 0.085 translate < 0.0075, -1.30, -1.75 > }
  sphere { <0,0,0>, 0.085 translate < -0.18, -1.30, -1.65 > }
  sphere { <0,0,0>, 0.085 translate < -0.21, -1.30, -1.325 > }
// right rear leg
  sphere { <0,0,0>, 0.3 scale < 2.5, 1, 1 > rotate < 0,  30,  10 > translate < 0.50, -0.50,  1 > }
  sphere { <0,0,0>, 0.25 scale < 2.5, 1, 1 > rotate < 0, 30, -20 > translate < 0.55, -0.75, 1 > }
  sphere { <0,0,0>, 0.2 scale < 3.25, 0.8, 1 > rotate < 0, 40, 20 > translate < 0.5, -1.10, 1.15 > }
  sphere { <0,0,0>, 0.075 scale < 4.5, 0.8, 1 > rotate < 0, 70, 0 > translate < 0.1, -1.30, 1.75 > }
  sphere { <0,0,0>, 0.075 scale < 5.0, 0.8, 1 > rotate < 0, 50, 0 > translate < 0, -1.30, 1.65 > }
  sphere { <0,0,0>, 0.075 scale < 4.0, 0.8, 1 > rotate < 0, 20, 0 > translate < 0, -1.30, 1.5 > }
  sphere { <0,0,0>, 0.085 translate < 0.0075, -1.30, 2.0 > }
  sphere { <0,0,0>, 0.085 translate < -0.18, -1.30, 1.9 > }
  sphere { <0,0,0>, 0.085 translate < -0.21, -1.30, 1.575 > }
// left front leg
  union {
  sphere { <0,0,0>, 0.2 scale < 3.25, 0.8, 1 > rotate < 0, -30, 20 > translate < 0.5, -1.10, -1 > }
  sphere { <0,0,0>, 0.075 scale < 4.5, 0.8, 1 > rotate < 0, -70, 0 > translate < 0.1, -1.30, -1.5 > }
  sphere { <0,0,0>, 0.075 scale < 5.0, 0.8, 1 > rotate < 0, -50, 0 > translate < 0, -1.30, -1.4 > }
  sphere { <0,0,0>, 0.075 scale < 4.0, 0.8, 1 > rotate < 0, -20, 0 > translate < 0, -1.30, -1.25 > }
  sphere { <0,0,0>, 0.085 translate < 0.0075, -1.30, -1.75 > }
  sphere { <0,0,0>, 0.085 translate < -0.18, -1.30, -1.65 > }
  sphere { <0,0,0>, 0.085 translate < -0.21, -1.30, -1.325 > }
  rotate < 0, 0, 30 >
  translate < -2, 0, 0 >
  }
// right front leg
  union {
  sphere { <0,0,0>, 0.2 scale < 3.25, 0.8, 1 > rotate < 0, 40, 20 > translate < 0.5, -1.10, 1.15 > }
  sphere { <0,0,0>, 0.075 scale < 4.5, 0.8, 1 > rotate < 0, 70, 0 > translate < 0.1, -1.30, 1.75 > }
  sphere { <0,0,0>, 0.075 scale < 5.0, 0.8, 1 > rotate < 0, 50, 0 > translate < 0, -1.30, 1.65 > }
  sphere { <0,0,0>, 0.075 scale < 4.0, 0.8, 1 > rotate < 0, 20, 0 > translate < 0, -1.30, 1.5 > }
  sphere { <0,0,0>, 0.085 translate < 0.0075, -1.30, 2.0 > }
  sphere { <0,0,0>, 0.085 translate < -0.18, -1.30, 1.9 > }
  sphere { <0,0,0>, 0.085 translate < -0.21, -1.30, 1.575 > }
  rotate < 0, 0, 30 >
  translate < -2, 0, 0 >
  }
}

object { frog
  scale 0.25
  texture { pigment { bumps color_map{[0.0 DarkOliveGreen][0.8 DarkOliveGreen][1.0 Yellow]} scale 0.15 }
    finish { ambient 0.2 diffuse 0.8 phong 1 } }
  rotate <0,-45,0>
  translate < -3, 0.375, 2.25 >
}
