#declare BookFinish =
finish {
	phong 1
	phong_size 60
	brilliance 2
}

#declare TopCover =
union {
	superellipsoid {
		<.05,.05>
		scale <.837,.02,1.35>
		translate <0,.01,0>
	}
	box {
		<-.827,-.0001,-1.3501>,<.8,.0201,1.3501>
	}
	texture {
		pigment { CoverPigment }
		finish { BookFinish }
	}
	translate <0,.8,0>
}

#declare BottomCover =
union {
	superellipsoid {
		<.05,.05>
		scale <.827,.02,1.35>
		translate <-0.01,.01,0>
	}
	box {
		<-.827,-.0001,-1.3501>,<.8,.0201,1.3501>
	}
	texture {
		pigment { CoverPigment }
	}
}

#declare Spine =
difference { //spine
	cylinder {
		<0,0,-1.35>, <0,0,1.35>, .4
	}
	box {
		<0,-.5,-1.45>, <.5,.5, 1.45>
	}

	texture {
		pigment { CoverPigment }
		finish { BookFinish }
	}
	texture { //coverart
		pigment {
			image_map {
				gif SpineArt
				interpolate 2
				once
				transmit 0,1
			}
		translate <-.5,-.5,0> rotate <0,0,-90> rotate <90,0,90>
		scale <1, .7, 2.6>
		translate <-0.01,0,0>
		}
		normal {	
			bump_map {
				gif SpineArt
				interpolate 2
				once
				bump_size 2
			}
		}
	}

	scale <.13,1.05,1>
	translate <-.827,.41,0>
}

#declare Pages =
box {
	<-.827, 0, -1.32>, <.8, .8, 1.32>
	texture { pigment { rgb <.95,.95,.92> } }
}

#declare ClosedBook =
union {
	object { TopCover }
	object { BottomCover }
	object { Spine }
	object { Pages }

	scale <1,.55,1>
}

