// Persistence of Vision Ray Tracer Scene Description File
// File: ants.pov
// Vers: 3.01 Watcom Win32
// Desc: Ants
// Date: August 15, 1997
// Auth: Sonya Roberts
// Note:

#declare AR=seed(42)

#declare Saucer=
object {
	lathe {
		cubic_spline
		9,
		<-.1,0>
		<0,0>
		<.5,0>
		<.5,.015>
		<.75,.1>
		<.725,.1>
		<.5,.025>
		<0,.025>
		<-.1,.025>
	}
	scale <.75,1,.75>
	pigment {
		image_map {
			gif "plate.gif"
		}
		rotate x*90
		translate <-.5,0,-.5>
		scale <1.1,1.1,1.1>
	}
	finish {
		ambient .15
		reflection .2
		phong .3
		phong_size 70
	}
}

#declare TeaCup=
object {
	union {
		difference {					// Body of Cup
			cylinder {<0,0,0>,<0,.5,0>,.225}
			cylinder {
				<0,0,0>,<0,.51,0>,.2
				pigment {color White}
				finish {
					ambient .15
					reflection .2
					phong .3
					phong_size 70
				}
			}
			pigment {
				image_map {
					gif "cup.gif"
					map_type 2
				}
				scale <.5,.5,.5>
			}
			finish {
				ambient .15
				reflection .2
				phong .3
				phong_size 70
			}
		}
		difference {					// Handle
			torus {
				.25,.04
				scale <.5,1,.75>
				rotate y*20
				rotate x*-90
				translate <.22,.25,0>
			}
			cylinder {<0,0,0>,<0,.5,0>,.225}
		}
		torus {.2125,.0125}				// Rim of Cup
		cylinder {					// Tea Inside Cup
			<0,0,0>,<0,.45,0>,.2
			pigment {color Sienna}
			finish {
				reflection .5
				phong .3
				phong_size 70
			}
		}
		pigment {color White}
		finish {
			ambient .15
			reflection .2
			phong .3
			phong_size 70
		}
	}
	scale <1.1,1.1,1.1>
	rotate y*25
	translate <0,.025,.05>
}

#declare SugarCube=
object {
	superellipsoid {<.2,.2>	translate <0,1,0>	scale <.05,.05,.05>}
	pigment {color White*1.25}
	finish {
		ambient .3
		crand .15
	}
}

#declare ALeg=
object {
	union {
		sphere {<0,0,0>,.01}
		cone {<0,0,0>,.01,<0,.02,-.015>,.005}
		sphere {<0,.02,-.015>,.005}
		cylinder {<0,.02,-.015>,<0,-.02,-.0175>,.005}
		sphere {<0,-.02,-.0175>,.005}
		cone {<0,-.02,-.0175>,.005,<0,-.03,-.02>,.002}
	}
	translate <0,0,-.0175>
}

#declare Ant=
object {
	union {
		sphere {					// Body
			<0,0,0>,.02
			scale <1.5,1,1>
		}
		sphere {					// Hind Segment
			<0,0,0>,.0225
			scale <1.75,1,1.1>
			translate <.05,0,0>
			pigment {color Coral}
		}
		sphere {					// Head
			<0,0,0>,.0195
			scale <1,.75,1>
			rotate z*-5
			translate <-.045,0,0>
			pigment {color Brown}
		}
		object {ALeg	rotate y*-40}
		object {ALeg}
		object {ALeg	rotate y*40}
		object {ALeg	rotate y*-140}
		object {ALeg	rotate y*180}
		object {ALeg	rotate y*140}
	}
	pigment {color Copper}
	finish {
		ambient .2
		phong .3
	}
	translate <0,.03,0>
}

// ---- Cube in Harness Being Lowered by Ants----
object {
	union {
		object {SugarCube}
		union {
			difference {
				superellipsoid {<.2,.2>	translate <0,1,0>	scale <.055,.055,.005>}
				superellipsoid {<.2,.2>	translate <0,1,0>	scale <.05,.05,.05>}
			}
			difference {
				superellipsoid {<.2,.2>	translate <0,1,0>	scale <.005,.055,.055>}
				superellipsoid {<.2,.2>	translate <0,1,0>	scale <.05,.05,.05>}
			}
			cylinder {<0,0,0>,<0,2,0>,.005}
			sphere {<0,2,0>,.005}
			cylinder {<0,2,0>,<-.2,2.03,0>,.005}
			sphere {<-.2,2.03,0>,.005}
			cylinder {<-.2,2.03,0>,<-.8,2.005,0>,.005}
			pigment {color MediumGoldenrod}
			finish {
				ambient .4
			}
		}
		object {Ant	rotate y*150	translate <-.25,2,-.025>}
		object {Ant	rotate y*-170	translate <-.35,2,.035>}
		object {Ant	rotate y*165	translate <-.45,2,-.03>}
		object {Ant	rotate y*-175	translate <-.55,2,.02>}
		object {Ant	rotate y*180	translate <-.65,2,0>}
	}
	translate <0,-2,0>
	translate <-5.25,3.25,-3.5>
}

// ---- Ants Stealing Sugar from Tea on Desk ----
union {
	object {Saucer}
	object {TeaCup}
	object {SugarCube	rotate y*30	translate <.05,.025,-.375>}
	object {SugarCube	rotate y*-10	translate <-.115,.025,-.35>}
	object {SugarCube	rotate y*-50	translate <.5,0,-.7>}
	object {Ant		rotate y*160	translate <.375,0,-.8>}
	object {Ant		rotate y*-40	translate <.75,0,-.65>}
	object {Ant		rotate y*-10	translate <.475,0,-.525>}
	rotate y*90
	translate <-6.25,3.25,-4.75>
}

// ---- Path of Rollers on Ground ----
object {
	union {
		union {
			#declare Z1=0
			#while (Z1<=3.75)
				cylinder {
					<-.075,.0025,0>,<.075,.0025,0>,.0025
					rotate y*(-20+(rand(AR)*40))
					translate <-.02+(rand(AR)*.04),0,Z1>
				}
				#declare Z1=Z1+.015
			#end
			pigment {color Wheat}
		}
		union {
			box {<-.07,0,-.07>,<.07,.02,.07>	texture {T_Wood3	scale <.5,.5,.5>}}
			object {SugarCube	rotate y*10	translate <0,.02,0>}
			rotate y*-5
			translate <.005,.005,.8>
		}
		object {Ant	rotate y*100	translate <-.1,0,.75>}
		object {Ant	rotate y*70	translate <.15,0,.625>}
		object {Ant	rotate y*110	translate <-.125,0,.9>}
		object {Ant	rotate y*80	translate <.175,0,.85>}
		object {Ant	rotate y*85	translate <0,0,.6>}
	}
	translate <-5,0,-3.75>
}

object {Ant	rotate y*(rand(AR)*360)	translate <-5.1,0,-4>}
object {Ant	rotate y*(rand(AR)*360)	translate <-4.85,0,-4.25>}
object {Ant	rotate y*(rand(AR)*360)	translate <-5,0,-3.81>}
