// Persistence of Vision Ray Tracer Scene Description File
// File: cohen.pov
// Vers: 3.02 Watcom Win32
// Desc: Cohen the Barbarian
// Date: August 16, 1997
// Auth: Sonya Roberts
// Note: Modifed starting from orang.pov

#declare CohenEye=
object {
	union {
		sphere {<0,0,0>,.075	scale <1.25,1,.95>	texture {T_Glass3}}
		difference {
			union {
				difference {
					sphere {<0,0,0>,.074}
					sphere {<0,0,0>,.0739}
					pigment {color White}
					finish {ambient .3}
				}
				difference {
					sphere {<0,0,0>,.07391}
					sphere {<0,0,0>,.072}
					pigment {color Blue}
				}
				sphere {<0,0,0>,.0721	pigment {color Black}}
				scale <1.25,1,.95>
			}
			sphere {<0,0,0>,.0725	scale <1,1,.75>	translate <0,0,-.075>}
		}
	}
	rotate x*5
}

#if (Detailed)
	#declare Beard=
	object {
		#declare HR=seed(6)
		#declare X1=-.2
		union {
			#while (X1<=.2)
				#debug str(X1,0,1)
				#debug " - "
				#declare Z1=-.1
				union {
					#while (Z1<=.2)
						#debug str(Z1,0,2)
						#debug " "
						union {
							#declare HStart=<0,0,0>
							#declare HSegment=1
							#while (HSegment<=5)
								#declare HFx=HStart.x+(-.03+(rand(HR)*.06))
								#declare HFy=HStart.y-(rand(HR)*.4)
								#declare HFz=HStart.z+(-.03+(rand(HR)*.06))
								#declare CLR=.75+(.05*HSegment)
								cylinder {
									HStart,<HFx,HFy,HFz>,.0075
									pigment {color rgb <CLR,CLR,CLR>}
									finish {ambient .4}
								}
								#declare HStart=<HFx,HFy,HFz>
								#declare HSegment=HSegment+1
							#end
							rotate x*(rand(HR)*10)
							rotate y*(rand(HR)*360)
							translate <X1,0,Z1>
						}
						#declare Z1=Z1+.05
					#end
				}
				#declare X1=X1+.05
				#debug "\n"
			#end
		}
		rotate x*10
	}

	#declare Eyebrow=
	object {
		#declare HR=seed(6)
		#declare X1=0
		union {
			#while (X1<=.2)
				#debug str(X1,0,1)
				#debug " - "
				#declare Z1=0
				union {
					#while (Z1<=.1)
						#debug str(Z1,0,2)
						#debug " "
						union {
							#declare HStart=<0,0,0>
							#declare HSegment=1
							#while (HSegment<=3)
								#declare HFx=HStart.x+(.01+(rand(HR)*(X1/3)))
								#declare HFy=HStart.y-(rand(HR)*.025)
								#declare HFz=HStart.z+(-.01+(rand(HR)*.02))
								#declare CLR=.7+(.1*HSegment)
								cylinder {
									HStart,<HFx,HFy,HFz>,.0075
									pigment {color rgb <CLR,CLR,CLR>}
									finish {ambient .15}
								}
								#declare HStart=<HFx,HFy,HFz>
								#declare HSegment=HSegment+1
							#end
							translate <X1,0,Z1>
						}
						#declare Z1=Z1+.05
					#end
				}
				#declare X1=X1+.05
				#debug "\n"
			#end
		}
	}
#end

#declare Loincloth=
object {
	blob {
		threshold .75
		cylinder {<0,0,0>,<0,.1,0>,1.5,1	scale <1.05,.5,1.35>	rotate z*-40	translate <-.65,0,0>}
		cylinder {<0,0,0>,<0,.1,0>,1.5,1	scale <1.05,.5,1.35>	rotate z*40	translate <.65,0,0>}
		sphere {<0,0,0>,.8,.75	scale <1,1.25,1.5>	translate <0,-.5,-.15>}
	}
	pigment {color DarkBrown}
	finish {phong .4	phong_size 75}
}

#declare FurTrim=
object {
	#declare CylRad=.5
	#declare CylLen=.25
	#declare HairLen=.3
	#declare HairComb=True
	#include "hairycyl.inc"
}

#declare RightBoot=
object {
	union {
		difference {
			blob {
				threshold .75
				sphere {<0,1.5,0>,1,.5	scale <1,1,1.25>}
				cylinder {<0,0,0>,<0,1.5,0>,1,1}
				cylinder {<0,.1,0>,<-.05,.1,-.5>,.6,1	scale <1,.75,1>}
				cylinder {<-.05,.1,-.5>,<0,.1,-1>,.55,1	scale <1,.5,1>}
				sphere {<0,.1,-1>,.4,.75}
				sturm
			}
			box {<-1,-.5,-2>,<1,0,1>}
			box {<-1,1.5,-2>,<1,2.25,1>}
			pigment {color DarkTan}
		}
		object {FurTrim	translate <0,1.35>}
	}
}

#declare LeftBoot=
object {
	union {
		difference {
			blob {
				threshold .75
				sphere {<0,1.5,0>,1,.5	scale <1,1,1.25>}
				cylinder {<0,0,0>,<0,1.5,0>,1,1}
				cylinder {<0,.1,0>,<.05,.1,-.5>,.6,1	scale <1,.75,1>}
				cylinder {<.05,.1,-.5>,<0,.1,-1>,.55,1	scale <1,.5,1>}
				sphere {<0,.1,-1>,.4,.75}
			}
			box {<-1,-.5,-2>,<1,0,1>}
			box {<-1,1.5,-2>,<1,2.25,1>}
		pigment {color DarkTan}
		}
		object {FurTrim	translate <0,1.35>}
	}
}

#declare CHandR=
object {
	blob {
		threshold .65
		sphere {<-.23,-.32,0>,.43,1	scale <1.95,1.05,.8>}	// Palm
		sphere {<.12,-.41,0>,.43,1	scale <1.95,1.075,.8>}
		sphere {<0,-.35,-.1>,.3,-1	scale <2,1,.5>}
		sphere {<-.23,-.63,0>,.45,.75	scale <1.78, 1.3,1>}	// Middle of hand
		sphere {<.19,-.63,0>,.45,.75	scale <1.78, 1.3,1>}
		sphere {<-.22,-.73,0>,.45,.85	scale <1.4, 1.25,1>}	// Heel of hand
		sphere {<.19,-.73,0>,.45,.85	scale <1.4, 1.25,1>}
		cylinder {<-.65,-.28,0>,<-.7,.28,-.075>,.26,1}		// Pinky Finger
		sphere {<-.7,.28,-.075>,.26,-.75}
		cylinder {<-.7,.28,-.075>,<-.75,.28,-.5>,.26,1}
		sphere {<-.75,.28,-.5>,.2,1}
		cylinder {<-.3,-.28,0>,<-.325,.44,-.075>,.26,1}		// Ring Finger
		sphere {<-.325,.44,-.075>,.26,-.75}
		cylinder {<-.325,.44,-.075>,<-.35,.44,-.7>,.26,1}
		sphere {<-.35,.44,-.7>,.2,1}
		cylinder {<.05,-.28,0>,<.05,.49,-.075>,.26,1}		// Middle Finger
		sphere {<.05,.49,-.075>,.26,-.75}
		cylinder {<.05,.49,-.075>,<.05,.49,-.8>,.26,1}
		sphere {<.05,.49,-.8>,.2,1}
		cylinder {<.4,-.4,0>,<.425,.512,-.075>,.26,1}		// Index Finger
		sphere {<.425,.512,-.075>,.26,-.75}
		cylinder {<.425,.512,-.075>,<.45,.512,-.7>,.26,1}
		sphere {<.45,.512,-.7>,.2,1}
		cylinder {<.41,-.95,0>,<.85,-.68,-.075>,.25,1}		// Thumb
		sphere {<.85,-.68,-.075>,.26,-.75}
		cylinder {<.85,-.68,-.075>,<1,-.3,-.3>,.25,1}
		sphere {<1,-.3,-.2>,.175,1}
	}
	pigment {color Flesh}
	scale <.4,.4,.4>
}

#declare CHandL=
object {
	blob {
		threshold .65
		sphere {<.23,-.32,0>,.43,1	scale <1.95,1.05,.8>}	// Palm
		sphere {<-.12,-.41,0>,.43,1	scale <1.95,1.075,.8>}
		sphere {<0,-.35,-.1>,.3,-1	scale <2,1,.5>}
		sphere {<.23,-.63,0>,.45,.75	scale <1.78, 1.3,1>}	// Middle of hand
		sphere {<-.19,-.63,0>,.45,.75	scale <1.78, 1.3,1>}
		sphere {<.22,-.73,0>,.45,.85	scale <1.4, 1.25,1>}	// Heel of hand
		sphere {<-.19,-.73,0>,.45,.85	scale <1.4, 1.25,1>}
		cylinder {<.65,-.28,0>,<.75,.28,-.075>,.26,1}		// Pinky Finger
		sphere {<.75,.28,-.075>,.26,-.75}
		cylinder {<.7,.28,-.075>,<.8,.28,-.5>,.26,1}
		sphere {<.8,.28,-.5>,.2,1}
		cylinder {<.3,-.28,0>,<.35,.44,-.075>,.26,1}		// Ring Finger
		sphere {<.35,.44,-.075>,.26,-.75}
		cylinder {<.35,.44,-.075>,<.45,.44,-.7>,.26,1}
		sphere {<.45,.44,-.7>,.2,1}
		cylinder {<0,-.28,0>,<0,.49,-.075>,.26,1}		// Middle Finger
		sphere {<0,.49,-.075>,.26,-.75}
		cylinder {<0,.49,-.075>,<.05,.49,-.8>,.26,1}
		sphere {<.05,.49,-.8>,.2,1}
		cylinder {<-.4,-.4,0>,<-.425,.512,-.075>,.26,1}		// Index Finger
		sphere {<-.425,.512,-.075>,.26,-.75}
		cylinder {<-.425,.512,-.075>,<-.45,.512,-.7>,.26,1}
		sphere {<-.45,.512,-.7>,.2,1}
		cylinder {<-.41,-.95,0>,<-.85,-.68,-.05>,.25,1}		// Thumb
		sphere {<-.85,-.68,-.05>,.26,-.75}
		cylinder {<-.85,-.68,-.05>,<-1,-.3,-.2>,.25,1}
		sphere {<-1,-.3,-.2>,.175,1}
	}
	pigment {color Flesh}
	scale <.4,.4,.4>
}

#declare Cane=
object {
	union {
		difference {
			cylinder {<0,-3,0>,<0,.75,0>,.1}
			torus {.1,.055	scale <1,3.5,1>	translate <0,.75,0>}
			texture {T_Wood11	scale <1,2,1>}
		}
		cylinder {<0,.725,.75>,<0,.825,-.5>,.1	texture {T_Wood11	scale <1,1,2>}}
	}
}

#declare Sword=
object {
	union {
		difference {
			union {
				cylinder {<0,-1.25,0>,<0,.5,0>,.1}
				sphere {<0,0,0>,.175	scale <1,3.5,1>	translate <0,-.2,0>}
				cylinder {<0,-.05,0>,<0,.05,0>,.15	scale <1,1,4>	translate <0,.5,0>}
				sphere {<0,-1.25,0>,.2}
			}
			sphere {<0,-1.35,0>,.15}
			texture {T_Gold_4E}
		}
		sphere {<0,-1.35,0>,.15	texture {Garnet}}
		difference {
			box {<-.1,0,-.2>,<.1,4,.2>}
			union {
				sphere {<0,0,-.2>,.21}
				sphere {<0,0,.2>,.21}
				scale <1,5,1>
				translate <0,4,0>
			}
			union {
				cylinder {<-.1,-.1,0>,<-.1,4.1,0>,.175}
				cylinder {<-.1,-.1,0>,<-.1,4.1,0>,.175}
				scale <1,1,1.5>
				translate <0,0,-.2>
				texture {T_Chrome_5D}
			}
			union {
				cylinder {<-.1,-.1,0>,<-.1,4.1,0>,.175}
				cylinder {<-.1,-.1,0>,<-.1,4.1,0>,.175}
				scale <1,1,1.5>
				translate <0,0,.2>
				texture {T_Chrome_5D}
			}
			union {
				box {<-.2,-1.5,-.21>,<0,.1,.21>	rotate z*-15}
				box {<.2,-1.5,-.21>,<0,.1,.21>	rotate z*15}
				translate <0,4,0>
			}
			translate <0,.5,0>
			texture {T_Chrome_1A}
		}
	}
}

object {
	union {
		blob {
			threshold .65
			sphere {<0,0,0>,.85,1	scale <1.2,1.75,1>	translate <0,.4,0>}	// Head
			sphere {<0,.65,.25>,.85,1}						// Back of Skull
			sphere {<0,.15,-.35>,.35,.5}						// Chin
			sphere {<0,0,-.5>,.35,.5}
			cylinder {<0,-.05,0>,<0,.05,0>,.325,1	scale <.75,.1,1>	rotate x*10	translate <0,.05,-.375>	pigment {color Scarlet}}	// Lips
			cylinder {<0,-.05,0>,<0,.05,0>,.325,1	scale <.75,.1,1>	rotate x*-15	translate <0,.05,-.375>	pigment {color Scarlet}}
			sphere {<0,0,0>,.25,-1	scale <1,.25,2>	translate <0,.05,-.5> pigment {color Scarlet}}		// Mouth
			cylinder {<0,.55,-.4>,<0,.3,-.55>,.1,1}		// Nose
			sphere {<0,0,0>,.1,1	scale <2,1.25,1>	translate <0,.3,-.55>}
			sphere {<0,0,0>,.16,-1	scale <1.75,1.25,.5>	rotate y*5	translate <-.15,.575,-.4>}	// Eye Sockets
			sphere {<0,0,0>,.16,-1	scale <1.75,1.25,.5>	rotate y*-5	translate <.15,.575,-.4>}
			sphere {<-.15,.575,-.35>,.075,-1}					// Holes for Eyeballs
			sphere {<.15,.575,-.35>,.075,-1}
			cylinder {<-.025,0,0>,<.025,0,0>,.2,1	scale <.25,1.5,.8>	rotate <10,-8,12>	translate <-.575,.5,.05>}	// Ears
			cylinder {<-.025,0,0>,<.025,0,0>,.2,1	scale <.25,1.5,.8>	rotate <10,8,-12>	translate <.575,.5,.05>}
			cylinder {<-1,-.75,.25>,<1,-.75,.25>,.5,1}				// Collarbone
			sphere {<-1,-.75,.25>,.6,1}						// Shoulders
			sphere {<1,-.75,.25>,.6,1}
			cylinder {<-1,-.75,.25>,<-1.75,-1.75,-1>,.4,1}				// Right Upper Arm
			cylinder {<-1.2,-.75,.25>,<-1.75,-1.75,-1>,.5,1}
			sphere {<-1.5,-1.25,-.5>,1,.5}
			sphere {<-1.75,-1.75,-1>,.5,-.75}
			cylinder {<-1.75,-1.75,-1>,<-2,-.5,-1.25>,.4,1}				// Right Lower Arm
			sphere {<-1.9,-1.5,-1.15>,.75,.5}
			cylinder {<1,-.75,.25>,<1.75,-1.75,1>,.4,1}				// Left Upper Arm
			cylinder {<1.2,-.75,.25>,<1.75,-1.75,1>,.5,1}
			sphere {<1.5,-1.25,-.5>,1,.5}
			sphere {<1.75,-1.75,1>,.5,-.75}
			cylinder {<1.75,-1.75,1>,<2,-2,-.5>,.4,1}				// Left Lower Arm
			sphere {<1.9,-1.85,.25>,.75,.5}
			cylinder {<0,0,0>,<0,0,.3>,.75,1	scale <.85,1.25,.35>	rotate x*18	translate <-.45,-1.45,-.25>}	// Chest
			cylinder {<0,0,0>,<0,0,.3>,.75,1	scale <.85,1.25,.35>	rotate x*18	translate <.45,-1.45,-.25>}
			cylinder {<-.45,-1.55,-.35>,<-.45,-1.55,-.45>,.075,1	pigment {color VeryDarkBrown}}		// Nipples
			cylinder {<.45,-1.55,-.35>,<.45,-1.55,-.45>,.075,1	pigment {color VeryDarkBrown}}
			cylinder {<-.45,-1.55,-.425>,<-.45,-1.55,-.4>,.125,.75	pigment {color DarkBrown}}
			cylinder {<.45,-1.55,-.425>,<.45,-1.55,-.4>,.125,.75	pigment {color DarkBrown}}
			cylinder {<0,0,0>,<0,0,.25>,1,1	scale <1,1,.5>	translate <0,-2.5,-.25>}			// Belly
			sphere {<0,0,0>,.075,-1	scale <1,1,3>	translate <0,-2.5,-.5>}	// Belly Button
			cylinder {<0,0,0>,<0,0,.5>,1.5,1	scale <1.5,1.25,.75>	translate <0,-1.5,.25>}		// Upper Back
			cylinder {<0,0,0>,<0,0,.35>,1.25,1	scale <.75,1,.5>	translate <0,-2.5,.25>}		// Lower Back
			sphere {<-.5,-3,.45>,1,1}						// Right Hip
			cylinder {<-.35,-3,.25>,<-1,-4.5,1>,.55,1}				// Right Thigh
			cylinder {<-.8,-3.25,.4>,<-1,-4.5,1>,.2,1}
			cylinder {<-1.05,-3,.25>,<-1,-4.5,1>,.45,1}
			sphere {<-.75,-4,.75>,1.2,.75}
			cylinder {<-1,-4.5,1>,<-1,-4.5,2.5>,.4,1}				// Right Lower Leg
			cylinder {<-1,-4.25,1.25>,<-1,-4.5,2.5>,.5,1}
			sphere {<0,0,0>,.75,.5	scale <.5,.5,1>	translate <-1,-4.25,1.5>}	// Right Calf
			sphere {<.5,-3,.45>,1,1}						// Left Hip
			cylinder {<.35,-3,.25>,<1,-4.5,-1>,.55,1}				// Left Thigh
			cylinder {<.8,-3.25,.4>,<1,-4.5,-1>,.2,1}
			cylinder {<1.05,-3,.25>,<1,-4.5,-1>,.45,1}
			sphere {<.75,-4,-.75>,1.2,.75}
			cylinder {<1,-4.5,-1>,<1,-6,-1>.4,1}					// Left Lower Leg
			cylinder {<1,-4.75,-1.25>,<1,-6,-1>.5,1}
			sphere {<0,0,0>,.75,.5	scale <.5,1,.5>	translate <1,-5,-1.25>}		// Left Calf
			sturm
			pigment {color NewTan}
		}
		object {CohenEye	translate <-.15,.575,-.35>}
		object {CohenEye	translate <.15,.575,-.35>}
		object {CHandR		rotate y*-60	rotate x*-20	translate <-1.95,-.1,-1.475>}
		object {Sword		rotate x*65	rotate y*20	translate <-1.75,-.09,-1.4>}
		object {CHandL		rotate y*105	rotate x*-90	rotate y*-15	translate <2.15,-1.95,-.95>}
		object {Cane		rotate z*-15	rotate x*-12	translate <2,-1.9,-1>}
		object {Loincloth	rotate y*8	translate <0,-2.75,.45>}
		object {RightBoot	rotate x*-80	translate <-1,-4.6,2.75>}
		object {LeftBoot			translate <1,-6.25,-1.1>}
		#if (Detailed)
			object {Beard		translate <0,.04,-.35>}
			object {Eyebrow		rotate z*15		translate <.075,.75,-.45>}
			object {Eyebrow		rotate z*(180-15)	translate <-.075,.75,-.45>}
		#end
	}
	translate <0,6.5,0>
	scale <.75,.75,.75>
	rotate y*-26
	translate <-3,0,3.5>
}
