// Persistence of Vision Ray Tracer Scene Description File
// File: discwrld.pov
// Vers: 3.01 Watcom Win32
// Desc: Discworld Scene (based on the books by Terry Pratchett)
// Date: August 13, 1997
// Auth: Sonya Roberts
// Note:

// ==== Standard Includes ====
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "shapes.inc"
#include "stones.inc"
#include "stones2.inc"
#include "woodmaps.inc"
#include "woods.inc"
#include "glass.inc"
#include "disc.inc"
#include "jewels.inc"

#declare True=1
#declare False=0

camera {
	location	<4,4.5,-15>
	up		<0,1,0>
	right		<1.33,0,0>
	look_at		<-2,4,0>
}

object {
	sphere {<0,0,0>,5000}
	hollow
	texture {
		pigment {
			gradient y
			color_map {
				[0	color LightBlue]
				[1.0	color NavyBlue]
			}
			scale <1,5000,1>
		}
	}
	texture {
		pigment {
			bozo
			turbulence 0.5
			octaves 3
			lambda 6.0
			color_map {
				[0.0 color rgbf <1, 1, 1, 1>]
				[0.8 color rgb <0.737, 0.788, 0.820>]
				[1.0 color rgb <1, 1, 1>]
			}
		}
		finish {
			ambient 1.0
			diffuse 0.0
		}
		scale <3000, 1500, 2000>
	}
}

#declare Detailed=True
#declare GoodLighting=True
#declare I_Room=True
#declare I_Luggage=True			// Travelling Baggage
#declare I_Orangutang=True		// Transformed Librarian
#declare I_DeathRat=True		// Assistant of Death (Rats, in charge of)
#declare I_Ants=True			// Mutant Intelligent Ants with Egyptian-Level Civilisation
#declare I_Escapee=True			// Horrible Thing from the Dungeon Dimension
#declare I_Cohen=True			// Cohen the Barbarian, Octogenarian Hero
#declare I_FlyBook=True			// The "Book of Going Forth Around Elevenish" Escapes
#declare I_Rincewind=True		// Rincewind the Wizzard
#declare I_Furnish=True
#if (I_Furnish)
	#declare I_Desk=True		// The Librarian's Desk
	#declare I_DontFeed=True	// "Don't Feed the Books" Sign
	#declare I_Enter=True		// "Enter At Your Own Risk" Sign
	#declare I_BookShelves=True	// Lots and lots of books
	#declare I_ExLibris=True	// Death's Bookplate as a Wall Decoration
#end

#if (GoodLighting)
	#declare X1=-15.8		// Library Lighting
	#while (X1<=16)
		#declare Z1=2
		#while (Z1<=50)
			light_source {
				<X1,11,Z1>
				#switch (Z1)
					case (2) color Gray15	#break
					case (25) color Gray10	#break
					case (48) color Gray5	#break
				#end
				fade_distance 15
				fade_power 1
			}
			#declare Z1=Z1+23
		#end
		#declare X1=X1+7.9
	#end
	light_source {			// Hallway Lights
		<-10,10,-7.5>,
		color Gray15
	}
	light_source {
		<5,10,-7.5>,
		color Gray25
		area_light <3,0,0>,<0,0,3>,2,2
		adaptive 1
	}
	light_source {
		<20,10,-7.5>,
		color Gray60
		area_light <3,0,0>,<0,0,3>,3,3
		adaptive 1
	}
	light_source {
		<50,100,-200>		// Sunlight
		color Wheat*.85
	}
     #else
     	light_source {			// Library Lighting
		<0,11,2>
		color Gray30
		fade_distance 15
		fade_power 1
	}
     	light_source {
		<0,11,25>
		color Gray20
		fade_distance 15
		fade_power 1
	}
	light_source {			// Hallway Lights
		<-10,10,-7.5>,
		color Gray15
	}
	light_source {
		<5,10,-7.5>,
		color Gray25
	}
	light_source {
		<20,10,-7.5>,
		color Gray60
	}
	light_source {
		<50,100,-200>		// Sunlight
		color Wheat*.85
	}
#end

#if (I_Room)		#include "library.pov"	#end
#if (I_Luggage)		#include "luggage.pov"	#end
#if (I_Orangutang)	#include "orang.pov"	#end
#if (I_DeathRat)	#include "deathrat.pov"	#end
#if (I_Ants)		#include "ants.pov"	#end
#if (I_Escapee)		#include "escapee.pov"	#end
#if (I_Cohen)		#include "cohen.pov"	#end
#if (I_FlyBook)		#include "fly_book.pov"	#end
#if (I_Rincewind)	#include "rincewnd.pov"	#end
#if (I_Furnish)		#include "furnish.pov"	#end

