// Persistence of Vision Ray Tracer Scene Description File
// File: luggage.pov
// Vers: 3.01 Watcom Win32
// Desc: The Luggage
// Date: August 13, 1997
// Auth: Sonya Roberts
// Note:

#declare BX=seed(17)

#declare Tooth=
object {
	blob {
		threshold .65
		cylinder {<0,0,0>,<0,.2,0>,.3,1	scale <1,.5,.9>}
		sphere {<-.08,.1,.06>,.075,1}
		sphere {<.08,.1,.06>,.075,1}
		sphere {<-.08,.1,-.06>,.075,1}
		sphere {<.08,.1,-.06>,.075,1}
		sphere {<0,.1,0>,.05,-1}
	}
}

#declare Drool=
object {
	blob {
		threshold .75
		sphere {<0,0,0>,.45,1	scale <1.25,.75,.35>	rotate x*30}
		sphere {<0,0,0>,.25,1	scale <.75,1.75>	translate <0,-.25,-.1>}
		sphere {<0,0,0>,.15,1	translate <-.1,-.5,-.125>}
		sphere {<0,0,0>,.1,1	translate <.05,-.8,-.05>}
		sphere {<.15,-.95,0>,.075,1}
		sphere {<-.125,-1,0>,.05,1}
	}
	texture {T_Glass4}
	translate <0,1.7,-2>
}

#declare Tongue=
object {
	union {
		blob {
			threshold .7
			sphere {<0,0,0>,.75,1	scale <1.8,1.25,.75>	translate <0,.75,0>}
			sphere {<0,0,0>,.75,1	scale <1.8,1.25,.75>	translate <0,1.2,-.5 >}
			sphere {<0,0,0>,.75,1	scale <1.5,1,1>		translate <0,1.5,-.75>}
			sphere {<0,0,0>,.75,1	scale <1.1,.75,1.25>	translate <0,1.75,-1>}
			sphere {<0,0,0>,.75,1	scale <.6,.5,1.5>	translate <0,2,-1.25>}
			sphere {<0,0,0>,.75,1	scale <.75,.5,1.25>	rotate x*-30	translate <0,1.75,-1.75>}
			sphere {<0,1,-1>,1.25,-1}
			scale <1.5,1,1>
			texture {TongueWood	scale <.5,.5,.5>}
		}
		object {Drool}
	}
}

#declare Leg=
object {
	blob {
		threshold .8
		sphere {<0,0,0>,.25,1}			// Hip
		cylinder {<0,0,0>,<0,-.5,-.25>,.25,1}	// Upper Leg
		sphere {<0,-.5,-.25>,.25,-.75}
		cylinder {<0,-.5,-.25>,<0,-1,0>,.25,1}	// Lower Leg
		cylinder {<0,-1,0>,<0,-1.25,-.6>,.2,.9}	// Foot
		cylinder {<0,-1,0>,<-.25,-1.25,-.5>,.2,.85}
		cylinder {<0,-1,0>,<.25,-1.25,-.5>,.2,.85}
	}
	scale <.5,.5,.5>
}

#declare Legs=
object {
	union {
		#declare X1=-1.25
		#while (X1<=1.25)
			union {
				#declare Z1=-.75
				#while (Z1<=.75)
					object {
						Leg
						rotate x*((45+(rand(BX)*10))*-Z1)
						rotate y*(-15+(rand(BX)*30))
						translate <X1,0,Z1>
					}
					#declare Z1=Z1+.25
				#end
			}
			#declare X1=X1+.25
		#end
	}
	pigment {color NewTan*1.25}
	finish {ambient .2}
}

//#declare Luggage=
object {
	union {
		difference {							// Trunk Bottom Portion
			box {<-1.5,0,-1>,<1.5,1.51,1>}
			box {<-1.55,1.5,-1.1>,<1.55,1.52,1.1>	texture {T_Wood19}}
			box {<-1.25,.05,-.75>,<1.25,1.55,.75>	texture {T_Wood14}}
		}
		#if (Detailed)
			union {							// Detailing on Sides of Bottom
				union {						// Brass Bands
					box {<-1,0,-1.05>,<-.75,1.5,-1>}
					box {<1,0,-1.05>,<.75,1.5,-1>}
					box {<-1,0,1.05>,<-.75,1.5,1>}
					box {<1,0,1.05>,<.75,1.5,1>}
					texture {T_Brass_2A}
				}
				difference {
					box {<-1.4,.1,-1.01>,<1.4,1.4,-1>}
					box {<-1.2,.3,-1.1>,<1.2,1.2,-.95>}
				}
				difference {
					box {<-1.4,.1,1.01>,<1.4,1.4,1>}
					box {<-1.2,.3,1.1>,<1.2,1.2,.95>}
				}
				difference {
					box {<-1.51,.1,-.9>,<-1.5,1.4,.9>}
					box {<-1.56,.3,-.7>,<-1.49,1.2,.7>}
				}
				difference {
					box {<1.51,.1,-.9>,<1.5,1.4,.9>}
					box {<1.56,.3,-.7>,<1.49,1.2,.7>}
				}
				texture {LegWood	rotate <rand(BX)*360,rand(BX)*360,rand(BX)*360>}
			}
		#end
		union {
			difference {							// Trunk Lid
				cylinder {<-1.5,0,0>,<1.5,0,0>,1}
				box {<-1.55,-1.1,-1.1>,<1.55,0,1.1>	texture {T_Wood19}}
				cylinder {<-1.25,0,0>,<1.25,0,0>,.75	texture {T_Wood14}}
			}
			#if (Detailed)
				difference {						// Brass Bands on Lid
					cylinder {<-1,0,0>,<1,0,0>,1.05}
					cylinder {<-1.1,0,0>,<1.1,0,0>,1}
					box {<-1.1,-1.1,-1.1>,<1.1,0,1.1>}
					cylinder {<-.75,0,0>,<.75,0,0>,1.06}
					texture {T_Brass_2A}
				}
				difference {						// Detailing on Top of Lid
					cylinder {<-1.4,0,0>,<1.4,0,0>,1.01}
					box {<-1.41,-1.1,-1.1>,<1.41,.1,1.1>}
					cylinder {<-1.41,0,0>,<1.41,0,0>,1}
					difference {
						cylinder {<-1.2,0,0>,<1.2,0,0>,1.06}
						box {<-1.41,-1.1,-1.1>,<1.41,.3,1.1>}
					}
					texture {LegWood	rotate <rand(BX)*360,rand(BX)*360,rand(BX)*360>}
				}
				difference {						// Detailing on Sides of Lid
					cylinder {<-1.51,0,0>,<1.51,0,0>,.9}
					box {<-1.56,-1,-1>,<1.56,.1,1>}
					cylinder {<-1.5,0,0>,<1.5,0,0>,1}
					difference {
						cylinder {<-1.56,0,0>,<1.56,0,0>,.7}
						box {<-1.57,-1,-1>,<1.57,.3,1>}
					}
					texture {LegWood	rotate <rand(BX)*360,rand(BX)*360,rand(BX)*360>}
				}
				union {							// "Eye" on Side of Trunk Lid
					difference {
						cylinder {<-1.505,0,0>,<-1.5,0,0>,.7}
						box {<-1.55,-.8,-.8>,<-1.45,.3,.8>}
						texture {ToothWood}
					}
					sphere {<0,0,0>,.2	scale <.1,1,1>	translate <-1.505,.5,0>	texture {T_Wood2}}
				}
				union {							// "Eye" on Side of Trunk Lid
					difference {
						cylinder {<1.505,0,0>,<1.5,0,0>,.7}
						box {<1.55,-.8,-.8>,<1.45,.3,.8>}
						texture {ToothWood}
					}
					sphere {<0,0,0>,.2	scale <.1,1,1>	translate <1.505,.5,0>	texture {T_Wood2}}
				}
			#end
			union {
				#declare X1=-1.25
				#while (X1<=1.25)
					object {
						Tooth
						rotate x*180
						rotate y*(-3+(rand(BX)*6))
						translate <X1,0,-.825>
						texture {ToothWood	rotate <rand(BX)*360,rand(BX)*360,rand(BX)*360>}
					}
					#declare X1=X1+.25
				#end
			}
			translate <0,0,-1>
			rotate x*30
			translate <0,1.5,1>
		}
		union {
			#declare X1=-1.25
			#while (X1<=1.25)
				object {
					Tooth
					translate <X1,1.5,-.825>
					rotate y*(-3+(rand(BX)*6))
					texture {ToothWood	rotate <rand(BX)*360,rand(BX)*360,rand(BX)*360>}
				}
				#declare X1=X1+.25
			#end
		}
		object {Tongue	rotate y*10	translate <0,0,.25>}
		object {Legs}
		rotate x*10
		rotate y*-50
		translate <4.25,1,-4.5>		// Position for Final Scene
//		translate <0,1,0>		// Position for Test render
		texture {SapientPearwood}
	}
}
