// Persistence of Vision Ray Tracer Scene Description File
// File: orang.pov
// Vers: 3.01 Watcom Win32
// Desc: The Librarian from Unseen University
// Date: August 13, 1997
// Auth: Sonya Roberts
// Note:

#declare Eye=
object {
	union {
		sphere {<0,0,0>,.075	scale <1.25,1,.95>	texture {T_Glass3}}
		difference {
			union {
				difference {
					sphere {<0,0,0>,.074}
					sphere {<0,0,0>,.0739}
					pigment {color White}
					finish {ambient .3}
				}
				difference {
					sphere {<0,0,0>,.07391}
					sphere {<0,0,0>,.072}
					pigment {color Copper}
				}
				sphere {<0,0,0>,.0721	pigment {color Black}}
				scale <1.25,1,.95>
			}
			sphere {<0,0,0>,.0725	scale <1,1,.75>	translate <0,0,-.075>}
		}
	}
	rotate x*5
}

#if (Detailed)
	#declare Hair=
	object {
		#declare HR=seed(5)
		#declare X1=1
		union {
			#while (X1<=230)
				#debug str(X1,0,1)
				#debug " - "
				#declare Y1=1
				union {
					#while (Y1<=26)
						#debug str(Y1,0,0)
						#debug " "
						#declare HPercent=.05+((abs(115-X1)/57.5)/(1+(Y1*.05)))
						#if (rand(HR)<=HPercent)
							union {
								#declare HStart=<0,0,0>
								#declare HSegment=1
								#while (HSegment<=5)
									#declare HFx=HStart.x-(rand(HR)*(.3/HSegment))
									#declare HFy=HStart.y-(rand(HR)*(.06*HSegment))
									#declare HFz=HStart.z+(-.05+(rand(HR)*.1))
									cylinder {
										HStart,<HFx,HFy,HFz>,.015
										pigment {color rgb <.89+(.022*HSegment),.47,.2-(.04*HSegment)>}
									}
									#declare HStart=<HFx,HFy,HFz>
									#declare HSegment=HSegment+1
								#end
								translate <-.4,-.5+(Y1*.032),0>
								rotate y*(-25+X1)
							}
						#end
						#declare Y1=Y1+1.5
					#end
				}
				#declare X1=X1+5
				#debug "\n"
			#end
		}
	}

	#declare Hairy=
	object {
		#declare HR=seed(6)
		#declare X1=1
		union {
			#while (X1<=230)
				#debug str(X1,0,1)
				#debug " - "
				#declare Y1=1
				union {
					#while (Y1<=26)
						#debug str(Y1,0,0)
						#debug " "
						#declare HPercent=.05+((abs(115-X1)/57.5)/(1+(Y1*.05)))
						#if (rand(HR)<=HPercent)
							union {
								#declare HStart=<0,0,0>
								#declare HSegment=1
								#while (HSegment<=5)
									#declare HFx=HStart.x-(rand(HR)*(.3/HSegment))
									#declare HFy=HStart.y-(rand(HR)*(.06*HSegment))
									#declare HFz=HStart.z+(-.05+(rand(HR)*.1))
									cylinder {
										HStart,<HFx,HFy,HFz>,.015
										pigment {color rgb <.89+(.022*HSegment),.47,.2-(.04*HSegment)>}
									}
									#declare HStart=<HFx,HFy,HFz>
									#declare HSegment=HSegment+1
								#end
								rotate z*((26-Y1)+((115/abs(115-X1))*2))
								rotate x*((115-X1)/1.5)
								translate <-.4,-.5+(Y1*.032),0>
								rotate y*(-25+X1)
							}
						#end
						#declare Y1=Y1+1.5
					#end
				}
				#declare X1=X1+5
				#debug "\n"
			#end
		}
	}
#end

#declare HandR=
object {
	blob {
		threshold .65
		sphere {<-.23,-.32,0>,.43,1	scale <1.95,1.05,.8>	pigment {color DarkBrown}}	// Palm
		sphere {<.12,-.41,0>,.43,1	scale <1.95,1.075,.8>	pigment {color DarkBrown}}
		sphere {<0,-.35,-.1>,.3,-1	scale <2,1,.5>}
		sphere {<-.23,-.63,0>,.45,.75	scale <1.78, 1.3,1>	pigment {color DarkBrown}}	// Middle of hand
		sphere {<.19,-.63,0>,.45,.75	scale <1.78, 1.3,1>	pigment {color DarkBrown}}
		sphere {<-.22,-.73,0>,.45,.85	scale <1.4, 1.25,1>	pigment {color DarkBrown}}	// Heel of hand
		sphere {<.19,-.73,0>,.45,.85	scale <1.4, 1.25,1>	pigment {color DarkBrown}}
		cylinder {<-.65,-.28,0>,<-.7,.28,-.075>,.26,1}						// Pinky Finger
		sphere {<-.7,.28,-.075>,.26,-.75}
		cylinder {<-.7,.28,-.075>,<-.75,.68,-.2>,.26,1}
		sphere {<-.75,.68,-.2>,.225,1				pigment {color DarkTan}}
		cylinder {<-.3,-.28,0>,<-.325,.44,-.075>,.26,1}						// Ring Finger
		sphere {<-.325,.44,-.075>,.26,-.75}
		cylinder {<-.325,.44,-.075>,<-.35,.9,-.2>,.26,1}
		sphere {<-.35,.9,-.2>,.225,1				pigment {color DarkTan}}
		cylinder {<.05,-.28,0>,<.05,.49,-.075>,.26,1}						// Middle Finger
		sphere {<.05,.49,-.075>,.26,-.75}
		cylinder {<.05,.49,-.075>,<.05,.95,-.2>,.26,1}
		sphere {<.05,.95,-.2>,.227,1				pigment {color DarkTan}}
		cylinder {<.4,-.4,0>,<.425,.512,-.075>,.26,1}						// Index Finger
		sphere {<.425,.512,-.075>,.26,-.75}
		cylinder {<.425,.512,-.075>,<.45, .85,-.2>,.26,1}
		sphere {<.45, .85,-.2>,.225,1				pigment {color DarkTan}}
		cylinder {<.41,-.95,0>,<.85,-.68,-.05>,.25,1}						// Thumb
		sphere {<.85,-.68,-.05>,.26,-.75}
		cylinder {<.85,-.68,-.05>,<1,-.3,-.2>,.25,1}
		sphere {<1,-.3,-.2>,.225,1				pigment {color DarkTan}}
		sphere {<0,0,0>,.25,1	scale <1,1.25,.5>	translate <0,-.75,.1> pigment {color Gold}}	// Wrist
		cylinder {<0,-.75,.1>,<.25,-2.5,.5>,.75,1		pigment {color Orange}}		// Forearm
	}
	pigment {color Flesh}
	scale <.5,.5,.5>
}

#declare HandL=
object {
	blob {
		threshold .65
		sphere {<.23,-.32,0>,.43,1	scale <1.95,1.05,.8>	pigment {color DarkBrown}}	// Palm
		sphere {<-.12,-.41,0>,.43,1	scale <1.95,1.075,.8>	pigment {color DarkBrown}}
		sphere {<0,-.35,-.1>,.3,-1	scale <2,1,.5>}
		sphere {<.23,-.63,0>,.45,.75	scale <1.78, 1.3,1>	pigment {color DarkBrown}}	// Middle of hand
		sphere {<-.19,-.63,0>,.45,.75	scale <1.78, 1.3,1>	pigment {color DarkBrown}}
		sphere {<.22,-.73,0>,.45,.85	scale <1.4, 1.25,1>	pigment {color DarkBrown}}	// Heel of hand
		sphere {<-.19,-.73,0>,.45,.85	scale <1.4, 1.25,1>	pigment {color DarkBrown}}
		cylinder {<.65,-.28,0>,<.7,.28,-.075>,.26,1}						// Pinky Finger
		sphere {<.7,.28,-.075>,.26,-.75}
		cylinder {<.7,.28,-.075>,<.75,.68,-.2>,.26,1}
		sphere {<.75,.68,-.2>,.225,1				pigment {color DarkTan}}
		cylinder {<.3,-.28,0>,<.325,.44,-.075>,.26,1}						// Ring Finger
		sphere {<.325,.44,-.075>,.26,-.75}
		cylinder {<.325,.44,-.075>,<.35,.9,-.2>,.26,1}
		sphere {<.35,.9,-.2>,.225,1				pigment {color DarkTan}}
		cylinder {<-.05,-.28,0>,<-.05,.49,-.075>,.26,1}						// Middle Finger
		sphere {<-.05,.49,-.075>,.26,-.75}
		cylinder {<-.05,.49,-.075>,<-.05,.95,-.2>,.26,1}
		sphere {<-.05,.95,-.2>,.227,1				pigment {color DarkTan}}
		cylinder {<-.4,-.4,0>,<-.425,.512,-.075>,.26,1}						// Index Finger
		sphere {<-.425,.512,-.075>,.26,-.75}
		cylinder {<-.425,.512,-.075>,<-.45, .85,-.2>,.26,1}
		sphere {<-.45, .85,-.2>,.225,1				pigment {color DarkTan}}
		cylinder {<-.41,-.95,0>,<-.85,-.68,-.05>,.25,1}						// Thumb
		sphere {<-.85,-.68,-.05>,.26,-.75}
		cylinder {<-.85,-.68,-.05>,<-1,-.3,-.2>,.25,1}
		sphere {<-1,-.3,-.2>,.225,1				pigment {color DarkTan}}
		sphere {<0,0,0>,.25,1	scale <1,1.25,.5>	translate <0,-.75,.1> pigment {color Gold}}	// Wrist
		cylinder {<0,-.75,.1>,<-.25,-2.5,.5>,.75,1		pigment {color Orange}}		// Forearm
	}
	pigment {color Flesh}
	scale <.5,.5,.5>
}

// ---- Assemble the Librarian ----
object {
	union {
		blob {
			threshold .65
			sphere {<0,0,0>,1,1	scale <1.2,1.75,1>							pigment {color DarkBrown}}	// Head
			sphere {<0,.25,.25>,.75,1									pigment {color VeryDarkBrown}}	// Back of Skull
			sphere {<0,-.5,.25>,.5,1									pigment {color DarkBrown}}	// Neck
			sphere {<0,-.75,.25>,.75,1									pigment {color DarkBrown}}	// Shoulders
			cylinder {<-1,-.75,.25>,<1,-.75,.25>,.5,1							pigment {color Orange}}
			sphere {<-1,-.75,.25>,.6,1									pigment {color Orange}}
			sphere {<1,-.75,.25>,.6,1									pigment {color Orange}}
			cylinder {<-1,-.75,.25>,<-1.75,-1.5,0>,.6,1							pigment {color Coral}}		// Right Arm
			cylinder {<1,-.75,.25>,<1.75,-1.5,0>,.6,1							pigment {color Coral}}		// Left Arm
			cylinder {<0,0,0>,<-.1,.1,-.15>,.75,1	scale <.75,1.2,.5>	rotate z*10	translate <-.5,-1.65,-.1>	pigment {color DarkBrown}}	// Chest
			cylinder {<0,0,0>,<.1,.1,-.15>,.75,1	scale <.75,1.2,.5>	rotate z*-10	translate <.5,-1.65,-.1>	pigment {color DarkBrown}}
			cylinder {<0,-2,-.1>,<0,-2,.1>,1,1	scale <1,1,.25>						pigment {color VeryDarkBrown}}	// Belly
			cylinder {<0,-1.5,.25>,<0,-1.5,.35>,1.5,1	scale <1.5,1,.5> 				pigment {color Orange}}		// Upper Back
			cylinder {<0,-2.5,.25>,<0,-2.5,.35>,1.25,1	scale <1,1,.5> 					pigment {color MandarinOrange}}	// Lower Back
			sphere {<-.7,-3,.25>,.85,1}													// Hips
			sphere {<.7,-3,.25>,.85,1}
			sphere {<0,-.25,-.5>,.5,1									pigment {color Tan}}		// Nose
			sphere {<0,0,0>,.125,1	scale <1.25,.55,1>	rotate z*-8	translate <-.075,-.05,-.65>	pigment {color Flesh}}		// Nostrils
			sphere {<0,0,0>,.125,1	scale <1.25,.55,1>	rotate z*8	translate <.075,-.05,-.65>	pigment {color Flesh}}
			cylinder {<0,0,-.6>,<0,0,-.3>,.15,.5								pigment {color Flesh}}
			sphere {<0,0,0>,.1,-1	scale <1.25,.55,4>	rotate z*-7	translate <-.075,-.05,-.7>	pigment {color Tan}}
			sphere {<0,0,0>,.1,-1	scale <1.25,.55,4>	rotate z*7	translate <.075,-.05,-.7>	pigment {color Tan}}
			sphere {<0,0,0>,.25,1	scale <.5,1.5,1>	rotate y*-20	translate <-.25,-.25,-.25>}					// Cheeks
			sphere {<0,0,0>,.25,1	scale <.5,1.5,1>	rotate y*20	translate <.25,-.25,-.25>}
			sphere {<0,0,0>,.15,-1	scale <1.5,1,.5>	rotate y*5	translate <-.15,.175,-.4>	pigment {color Tan}}		// Eyes
			sphere {<0,0,0>,.15,-1	scale <1.5,1,.5>	rotate y*-5	translate <.15,.175,-.4>	pigment {color Tan}}
			sphere {<-.165,.175,-.35>,.075,-1}
			sphere {<.165,.175,-.35>,.075,-1}
			cylinder {<0,0,0>,<0,.05,0>,.25,1	scale <1,.3,1>	rotate z*-10	translate <-.175,.325,-.25>	pigment {color Flesh}}	// Eyebrows
			cylinder {<0,0,0>,<0,.05,0>,.25,1	scale <1,.3,1>	rotate z*10	translate <.175,.325,-.25>	pigment {color Flesh}}
			cylinder {<0,-.025,0>,<0,.025,0>,.3,1	scale <1,.25,1>	rotate x*15	translate <0,-.3,-.6>	pigment {color Scarlet}}	// Lips
			cylinder {<0,-.025,0>,<0,.025,0>,.3,1	scale <1,.25,1>	rotate x*-25	translate <0,-.3,-.6>	pigment {color Scarlet}}
			cylinder {<-.025,0,0>,<.025,0,0>,.2,1	scale <.25,2,1>	rotate <10,-7,10>	translate <-.55,.1,.05>	pigment {color VeryDarkBrown}}	// Ears
			cylinder {<-.025,0,0>,<.025,0,0>,.2,1	scale <.25,2,1>	rotate <10,7,-10>	translate <.55,.1,.05>	pigment {color VeryDarkBrown}}
			sturm
			pigment {color DarkTan}
		}
		object {Eye	translate <-.165,.175,-.35>}
		object {Eye	translate <.165,.175,-.35>}
		object {HandR	rotate y*-30	rotate x*-45	translate <-2,-.75,-.75>}				// Visible Hand
		object {HandR	scale <1.25,1.25,1.25>	rotate y*-20	rotate x*-100	translate <-1,-4.25,-1>}	// Feet
		object {HandL	scale <1.25,1.25,1.25>	rotate y*15	rotate x*-105	translate <1,-4.3,-1.25>}
		#if (Detailed)
			object {Hair	translate <0,.1,0>}
			object {Hairy	scale <.5,1,.75>	rotate x*-60	rotate y*-90	translate <-1,-.75,0>}
			object {Hairy	scale <.5,1,.75>	rotate x*-60	rotate y*90	translate <1,-.75,0>}
		#end
	}
	rotate y*-65
//	translate <0,4.5,0>			// Location for "test" (turn off rotation in previous line too)
	translate <-9.25,4.5,-2.75>		// Location for final scene
}
