// Persistence of Vision Ray Tracer Include File
// File: pyr_cube.inc
// Vers: 3.01e Watcom Win32
// Desc: Creates a pyrimidal or "conical" type of cube
// Date: March 8, 1997
// Auth: Sonya Roberts
// Note: Bottom and top must be flat (i.e., parallel)
//       To use this fle, declare the four vectors
//       and then include the file.  This can be done
//       within an OBJECT{} or #DECLARE OBJECT{}
//       statement if you so wish.


// -- Define Defaults if Necessary
#ifndef (bflc)	#declare bflc = <-1,-1,-1>	#end	// Bottom Front Left Corner
#ifndef (bbrc)	#declare bbrc = <1,-1,1>	#end	// Bottom Back Right Corner
#ifndef (tflc)	#declare tflc = <-.5,1,-.5>	#end	// Top Front Left Corner
#ifndef (tbrc)	#declare tbrc = <.5,1,.5>	#end	// Top Back Right Corner

// -- Test Values
#if (bflc.y != bbrc.y)
	#fatal "The bottom of your cube is not flat.  The y-values of bflc and bbrc must be identical."
#end
#if (tflc.y != tbrc.y)
	#fatal "The top of your cube is not flat.  The y-values of tflc and tbrc must be identical."
#end

// -- define remaining corners based on these four
#declare bblc = <bflc.x, bflc.y, bbrc.z>	// Bottom Back Left Corner
#declare bfrc = <bbrc.x, bbrc.y, bflc.z>	// Bottom Front Right Corner
#declare tblc = <tflc.x, tflc.y, tbrc.z>	// Top Back Left Corner
#declare tfrc = <tbrc.x, tbrc.y, tflc.z>	// Top Front Right Corner

mesh {
	// TOP
	triangle {tflc, tfrc, tbrc}
	triangle {tbrc, tblc, tflc}
	
	// BOTTOM
	triangle {bflc, bfrc, bbrc}
	triangle {bbrc, bblc, bflc}

	// LEFT
	triangle {bflc, tflc, tblc}
	triangle {tblc, bblc, bflc}
	
	// RIGHT
	triangle {bfrc, tfrc, tbrc}
	triangle {tbrc, bbrc, bfrc}
	
	// FRONT
	triangle {bflc, bfrc, tfrc}
	triangle {tfrc, tflc, bflc}
	
	// BACK
	triangle {bblc, bbrc, tbrc}
	triangle {tbrc, tblc, bblc}
}
 