
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: FEMALE BODY
// Date: v1 07.06.97
// Auth: NB
/*

background{ color rgb <.9,.9,1>}

light_source {<-500,500,500>
color rgb <1,1,1>}

camera{ location<-60,0,0>*12
//camera{ location<0,0,-60>*12
//camera{ location<0,-60,0>*8
//camera{ location<-500,50,-300>*1.5
angle 5
look_at <0,10,0>}
//look_at <0,0,0>}

#declare SK_TEX =
texture{
   finish{
   diffuse .4
      ambient <1,.85,.7>*.7
      phong 0.2
      phong_size 20
   }
  normal {bumps .2 scale.005}
   pigment{color rgb <1,.85,.7>}
}
*/

// #declare SIDE = 1 // 1=left, -1=right, don't even try other values

#declare HR_02 = .65
#declare HS_02 = 3
#declare HD_02 = HS_02*pow((1-pow(HR_02,2)),2)
#declare LB_01 = 11
#declare LAX_01 = 7
#declare LAX_02 = 2
#declare LAZ_01 = 2
#declare LB_02 = 10.7

//#declare ZCENT = 3.05

#declare ZARM01 = -.82
#declare YARM01 = 11
#declare XARM01 = 0
// #declare AAX_01 = 2
// #declare AAZ_01 = 5
#declare AB_01 = 6.5
#declare AB_02 = 5.8
// #declare AAZ_02 = 20
// #declare AAY_02 = 15

// #declare LJX_01 = 0
// #declare LJZ_01 = -30
// #declare LJZ_02 = 40
// #declare LJZ_03 = 20

//difference{

blob{ threshold HD_02
//leg
   cylinder{<0,0,0><0,LB_01*-1,0>,1.4,HS_02
      rotate x*(LAX_01*SIDE)*-1
      rotate y*0*SIDE
      rotate z*LAZ_01
   rotate z*LJZ_01 rotate x*LJX_01}

   cylinder{<0,0,0><0,LB_02*-1,0>,1.1,HS_02
      rotate x*(LAX_02*SIDE)*-1
   rotate z*LJZ_02
      translate <LB_01*cos(radians(LAX_01))*sin(radians(LAZ_01))*SIDE,
                 (LB_01*cos(radians(LAX_01))*cos(radians(LAZ_01))*SIDE)*-1,
                 LB_01*sin(radians(LAX_01))>*SIDE
   rotate z*LJZ_01 rotate x*LJX_01}

   sphere{0,1,HS_02 scale <1/HR_02,1.6/HR_02,1/HR_02>
      rotate <5*SIDE,0*SIDE,15>
   rotate z*LJZ_02
      translate x*-.5
      translate <LB_01*cos(radians(LAX_01))*sin(radians(LAZ_01))*SIDE,
                 (LB_01*cos(radians(LAX_01))*cos(radians(LAZ_01))*SIDE)*-1,
                 LB_01*sin(radians(LAX_01))>*SIDE
   rotate z*LJZ_01 rotate x*LJX_01}

   sphere{0,1,HS_02 scale <2/HR_02,5.2/HR_02,2.0/HR_02>
      rotate <(LAX_01*SIDE)*-1.2,0*SIDE,LAZ_01*4>
      translate <-0.4,LB_01/-2.3,0.8*SIDE>
   rotate z*LJZ_01 rotate x*LJX_01}

   sphere{0,1,HS_02 scale <1.2/HR_02,4.5/HR_02,1.2/HR_02>
      rotate <0*SIDE,0*SIDE,-5>
      translate <0,LB_01/-2,1.3*SIDE>
   rotate z*LJZ_01 rotate x*LJX_01}

   sphere{0,1,HS_02*.8 scale <1.4/HR_02,2.8/HR_02,1.5/HR_02>
      rotate <0*SIDE,0*SIDE,8>
      translate <.5,LB_02/-2.9,0*SIDE>
   rotate z*LJZ_02
      translate <LB_01*cos(radians(LAX_01))*sin(radians(LAZ_01))*SIDE,
                 (LB_01*cos(radians(LAX_01))*cos(radians(LAZ_01))*SIDE)*-1,
                 LB_01*sin(radians(LAX_01))>*SIDE
   rotate z*LJZ_01 rotate x*LJX_01}

   sphere{0,1,HS_02*.9
      scale <.6/HR_02,2.2/HR_02,.6/HR_02>
      rotate <(LAX_02*SIDE)*-1,0*SIDE,-4>
      translate <0.5,LB_02/-1.6,0*SIDE>
   rotate z*LJZ_02
      translate <LB_01*cos(radians(LAX_01))*sin(radians(LAZ_01))*SIDE,
                 (LB_01*cos(radians(LAX_01))*cos(radians(LAZ_01))*SIDE)*-1,
                 LB_01*sin(radians(LAX_01))>*SIDE
   rotate z*LJZ_01 rotate x*LJX_01}

//*
   sphere{0,1,HS_02
      scale <1.6/HR_02,3/HR_02,2.2/HR_02>
      rotate <5*SIDE,-5*SIDE,28>
      translate <.5,-.2,1.2*SIDE>
   rotate z*LJZ_01/1.2}

   sphere{0,1,HS_02
      scale <.9/HR_02,1/HR_02,1/HR_02>
      translate y*-1.5
      rotate <5*SIDE,-5*SIDE,28>
      translate <.5,-.2,1.2*SIDE>
   rotate z*LJZ_01/1.2}
//*
   sphere{0,1,HS_02 scale <.6/HR_02,.5/HR_02,.5/HR_02>
      rotate z*-80
      translate x*.5
      rotate y*-10*SIDE
      translate <0,LB_02*cos(radians(LAX_02))*-1,LB_02*sin(radians(LAX_02))*SIDE>
   rotate z*LJZ_02
      translate <LB_01*cos(radians(LAX_01))*sin(radians(LAZ_01))*SIDE,
                 (LB_01*cos(radians(LAX_01))*cos(radians(LAZ_01))*SIDE)*-1,
                 LB_01*sin(radians(LAX_01))>*SIDE
   rotate z*LJZ_01 rotate x*LJX_01}

   sphere{0,1,HS_02 scale <2.4/HR_02,1/HR_02,.8/HR_02>
      translate x*-1.6
      rotate z*30
      rotate y*-10*SIDE
   rotate z*LJZ_03
      translate <0,LB_02*cos(radians(LAX_02))*-1,LB_02*sin(radians(LAX_02))*SIDE>
   rotate z*LJZ_02
      translate <LB_01*cos(radians(LAX_01))*sin(radians(LAZ_01))*SIDE,
                 (LB_01*cos(radians(LAX_01))*cos(radians(LAZ_01))*SIDE)*-1,
                 LB_01*sin(radians(LAX_01))>*SIDE
   rotate z*LJZ_01 rotate x*LJX_01}

   sphere{0,1,-5 scale <5/HR_02,.7/HR_02,5/HR_02>
      rotate y*-10*SIDE
   rotate z*LJZ_03
      translate <0,LB_02*cos(radians(LAX_02))*-1.15,(LB_02*sin(radians(LAX_02))*SIDE)*1.15>
   rotate z*LJZ_02
      translate <LB_01*cos(radians(LAX_01))*sin(radians(LAZ_01))*SIDE,
                 (LB_01*cos(radians(LAX_01))*cos(radians(LAZ_01))*SIDE)*-1,
                 LB_01*sin(radians(LAX_01))>*SIDE
   rotate z*LJZ_01 rotate x*LJX_01}

   sphere{0,1,HS_02
      scale <.8/HR_02,.3/HR_02,.95/HR_02>
      rotate y*-15*SIDE
      translate <-2.1,0,.2*SIDE>
      rotate y*-10*SIDE
   rotate z*LJZ_03
      translate <0,LB_02*cos(radians(LAX_02))*-1.05,LB_02*sin(radians(LAX_02))*1.05*SIDE>
   rotate z*LJZ_02
      translate <LB_01*cos(radians(LAX_01))*sin(radians(LAZ_01))*SIDE,
                 (LB_01*cos(radians(LAX_01))*cos(radians(LAZ_01))*SIDE)*-1,
                 LB_01*sin(radians(LAX_01))>*SIDE
   rotate z*LJZ_01 rotate x*LJX_01}

   sphere{0,1,HS_02
      scale <.55/HR_02,.2/HR_02,.32/HR_02>
      rotate y*-5*SIDE
      translate <-3.1,0,.7*SIDE>
      rotate y*-10*SIDE
   rotate z*LJZ_03
      translate <0,LB_02*cos(radians(LAX_02))*-1.05,LB_02*sin(radians(LAX_02))*1.05*SIDE>
   rotate z*LJZ_02
      translate <LB_01*cos(radians(LAX_01))*sin(radians(LAZ_01))*SIDE,
                 (LB_01*cos(radians(LAX_01))*cos(radians(LAZ_01))*SIDE)*-1,
                 LB_01*sin(radians(LAX_01))>*SIDE
   rotate z*LJZ_01 rotate x*LJX_01}

   sphere{0,1,HS_02
      scale <.6/HR_02,.2/HR_02,.2/HR_02>
      translate <-3.1,0,.35*SIDE>
      rotate y*-10*SIDE
   rotate z*LJZ_03
      translate <0,LB_02*cos(radians(LAX_02))*-1.05,LB_02*sin(radians(LAX_02))*1.05*SIDE>
   rotate z*LJZ_02
      translate <LB_01*cos(radians(LAX_01))*sin(radians(LAZ_01))*SIDE,
                 (LB_01*cos(radians(LAX_01))*cos(radians(LAZ_01))*SIDE)*-1,
                 LB_01*sin(radians(LAX_01))>*SIDE
   rotate z*LJZ_01 rotate x*LJX_01}

   sphere{0,1,HS_02
      scale <.55/HR_02,.18/HR_02,.18/HR_02>
      translate <-3.0,0,.05*SIDE>
      rotate y*-10*SIDE
   rotate z*LJZ_03
      translate <0,LB_02*cos(radians(LAX_02))*-1.05,LB_02*sin(radians(LAX_02))*1.05*SIDE>
   rotate z*LJZ_02
      translate <LB_01*cos(radians(LAX_01))*sin(radians(LAZ_01))*SIDE,
                 (LB_01*cos(radians(LAX_01))*cos(radians(LAZ_01))*SIDE)*-1,
                 LB_01*sin(radians(LAX_01))>*SIDE
   rotate z*LJZ_01 rotate x*LJX_01}

   sphere{0,1,HS_02
      scale <.55/HR_02,.18/HR_02,.18/HR_02>
      translate <-2.85,0,-.25*SIDE>
      rotate y*-10*SIDE
   rotate z*LJZ_03
      translate <0,LB_02*cos(radians(LAX_02))*-1.05,LB_02*sin(radians(LAX_02))*1.05*SIDE>
   rotate z*LJZ_02
      translate <LB_01*cos(radians(LAX_01))*sin(radians(LAZ_01))*SIDE,
                 (LB_01*cos(radians(LAX_01))*cos(radians(LAZ_01))*SIDE)*-1,
                 LB_01*sin(radians(LAX_01))>*SIDE
   rotate z*LJZ_01 rotate x*LJX_01}

   sphere{0,1,HS_02
      scale <.53/HR_02,.17/HR_02,.17/HR_02>
      rotate y*3*SIDE
      translate <-2.7,0,-.55*SIDE>
      rotate y*-10*SIDE
   rotate z*LJZ_03
      translate <0,LB_02*cos(radians(LAX_02))*-1.05,LB_02*sin(radians(LAX_02))*1.05*SIDE>
   rotate z*LJZ_02
      translate <LB_01*cos(radians(LAX_01))*sin(radians(LAZ_01))*SIDE,
                 (LB_01*cos(radians(LAX_01))*cos(radians(LAZ_01))*SIDE)*-1,
                 LB_01*sin(radians(LAX_01))>*SIDE
   rotate z*LJZ_01 rotate x*LJX_01}
//

cylinder{<0,0,0><0,LB_01*1.2,0>,1,HS_02
     translate z*ZCENT
     rotate z*-5}

sphere{0,1,HS_02
     scale <1.2/HR_02,2.4/HR_02,1.5/HR_02>
     translate <-.5,.5,ZCENT>
     rotate z*15}

sphere{0,1,HS_02
     scale <2.2/HR_02,2.5/HR_02,3/HR_02>
     translate <-.28,1.4,ZCENT>
     rotate z*15}

sphere{0,1,-5
     scale <.3/HR_02,.22/HR_02,.17/HR_02>
     rotate z*-5
     translate <-2.7,1.6,ZCENT>}

cylinder{<0,0,0><0,10,0>,1,HS_02
     scale <1.2/HR_02,1,2.2/HR_02>
     translate <-.7,2,ZCENT>
     rotate z*-5}

cylinder{<0,0,0><0,.6,0>,1,HS_02
     scale <2.3/HR_02,3.2/HR_02,2.3/HR_02>
     rotate <-15*SIDE,0*SIDE,-12>
     translate <-.8,6.4,ZCENT/1.6>}

cylinder{<0,0,0><0,.4,0>,1,HS_02
     scale <1.2/HR_02,3.4/HR_02,2.3/HR_02>
     rotate <15*SIDE,0*SIDE,-12>
     translate <-.6,7.5,(3.05+(3.05-3.05/1.6))*SIDE>}

 sphere{0,1,-.6
     scale <.5/HR_02,.8/HR_02,2/HR_02>
     rotate <0*SIDE,0*SIDE,0>
     translate <-3.5,4,ZCENT>}

/*
sphere{0,1,HS_02
     scale <1.7/HR_02,1.0/HR_02,1.3/HR_02>
     rotate <-15*SIDE,-25*SIDE,35>
     translate <-2.5,8.3,ZCENT/3>}

sphere{0,1,HS_02
     scale <1.0/HR_02,1.0/HR_02,1.2/HR_02>
     translate x*-.5
     rotate <-15*SIDE,-25*SIDE,35>
     translate <-2.5,8.3,ZCENT/3>}

sphere{0,1,HS_02
     scale <.3/HR_02,.3/HR_02,.3/HR_02>
     translate x*-1.6
     rotate <-10*SIDE,-15*SIDE,-5>
     translate <-2.5,8.3,ZCENT/3>}
*/
cylinder{<0,0,-1.15*SIDE><0,0,0>,1,HS_02
     scale <.5/HR_02,.4/HR_02,1/HR_02>
     rotate <5*SIDE,-15*SIDE,0>
     translate <-.8,11.8,2.05*SIDE>}

sphere{0,1,HS_02
     scale <.95/HR_02,2.9/HR_02,2.5/HR_02>
     rotate <0*SIDE,0*SIDE,-20>
     translate <-1,10.2,ZCENT>}

cylinder{<0,0,-.7*SIDE><0,0,0>,1,HS_02*.8
     scale <.4/HR_02,1.5/HR_02,.6/HR_02>
     rotate x*-25*SIDE
     rotate y*25*SIDE
     translate <1.5,9.5,.85*SIDE>}

// neck
cylinder{<0,.5,0><0,0,0>,1,HS_02
     scale <.9/HR_02,1/HR_02,.8/HR_02>*1.415
     rotate z*7
     translate <.3,13,ZCENT>}

sphere{0,1,HS_02
     scale <1/HR_02,1/HR_02,2.5/HR_02>
     rotate x*-5*SIDE
     translate <.4,12.5,ZCENT>}

// ARM: internal part

   sphere{0,1,HS_02
          scale <1.5/HR_02,1.4/HR_02,1.8/HR_02>
          rotate x*-10*SIDE
          translate <XARM01,YARM01,ZARM01*SIDE>}

   cylinder{<0,0,0><0,AB_01/-2,0>,1.2,HS_02
          scale <1.3,1,1.1>
          rotate <AAX_01*SIDE,0*SIDE,AAZ_01*-1>
          translate <XARM01,YARM01-.3,(ZARM01-1.2)*SIDE>}

sturm
translate y*10
translate z*ZCENT*-1
texture{SK_TEX}
}
//box{<-10,30,5*SIDE><10,-3,0.0000001*SIDE>}
//texture{SK_TEX}
//}

// ARM: external part

blob{ threshold HD_02
   cylinder{<0,0,0><0,AB_01*-1,0>,1.2,HS_02
          scale <1.2,1,1>
          rotate <AAX_01*SIDE,0*SIDE,AAZ_01*-1>
          translate <XARM01,YARM01-.31,(ZARM01-1.2)*SIDE>}

   sphere{0,1,HS_02
          scale <1.2/HR_02,AB_01/1.8*HR_02,1/HR_02>
          rotate z*2
          translate <-.2,(AB_01/2-.1)*-1,0>
          rotate <AAX_01*SIDE,0*SIDE,AAZ_01*-1>
          translate <XARM01,YARM01-.31,(ZARM01-1.2)*SIDE>}


   sphere{0,1,HS_02
          scale <.65/HR_02,.6/HR_02,.7/HR_02>
          translate x*.2
          translate <AB_01*cos(radians(AAX_01))*sin(radians(AAZ_01*-1)),
                     AB_01*cos(radians(AAX_01))*cos(radians(AAZ_01*-1))*-1-.4,
                     AB_01*sin(radians(AAX_01))*-1*SIDE>
          translate <XARM01,YARM01-.3,(ZARM01-1.2)*SIDE>}

   cylinder{<0,0,0><0,AB_02*-1,0>,1,HS_02
          scale <1.1,1,.9>*.95
          rotate y*AAY_02*-1*SIDE
          rotate z*AAZ_02*-1
          translate <AB_01*cos(radians(AAX_01))*sin(radians(AAZ_01*-1)),
                     AB_01*cos(radians(AAX_01))*cos(radians(AAZ_01*-1))*-1-.4,
                     AB_01*sin(radians(AAX_01))*-1*SIDE>
          translate <XARM01,YARM01-.3,(ZARM01-1.2)*SIDE>}

   sphere{0,1,HS_02
          scale <1/HR_02,AB_02/1.5*HR_02,.95/HR_02>
          rotate y*AAY_02*-1*SIDE
          translate y*AB_02/-3
          rotate z*AAZ_02*-1
          translate <AB_01*cos(radians(AAX_01))*sin(radians(AAZ_01*-1)),
                     AB_01*cos(radians(AAX_01))*cos(radians(AAZ_01*-1))*-1-.4,
                     AB_01*sin(radians(AAX_01))*-1*SIDE>
          translate <XARM01,YARM01-.3,(ZARM01-1.2)*SIDE>}
sturm
translate y*10
translate z*ZCENT*-1
texture{SK_TEX}
}

#declare W_RING01=
torus{1.1,.1 scale <1,2,1> rotate z*-10 translate y*AB_02*-.97
   scale <1.1,1,.9>*.95
   rotate y*AAY_02*-1*SIDE
   rotate z*AAZ_02*-1
   translate <AB_01*cos(radians(AAX_01))*sin(radians(AAZ_01*-1)),
              AB_01*cos(radians(AAX_01))*cos(radians(AAZ_01*-1))*-1-.4,
              AB_01*sin(radians(AAX_01))*-1*SIDE>
   translate <XARM01,YARM01-.3,(ZARM01-1.2)*SIDE>
translate y*10
translate z*ZCENT*-1
texture{T_Chrome_4D}
}
#declare W_R01=W_R00*SIDE
#if(W_R01=1)
   object{W_RING01}
#else
#end

#include "h01.inc"
object{HAND
    rotate z*90
    scale 1/(2*1.2999999999)*H_R01*.95

    translate y*AB_02*-1.1
    rotate y*AAY_02*-1*SIDE
    rotate z*AAZ_02*-1
    translate <AB_01*cos(radians(AAX_01))*sin(radians(AAZ_01*-1)),
               AB_01*cos(radians(AAX_01))*cos(radians(AAZ_01*-1))*-1-.4,
               AB_01*sin(radians(AAX_01))*-1*SIDE>
    translate <XARM01,YARM01-.3,(ZARM01-1.2)*SIDE>
    translate y*10
    translate z*ZCENT*-1
texture{SK_TEX}
}

