//#declare ONLY_BODY = 1
//#declare ONLY_HEAD = 1
//#declare NO_BACKGROUND = 1
//#declare NO_MOUNTAIN = 1
//#declare NO_DRAGON = 1

default {
    finish { ambient 0.05 }
}

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "consts.inc"
#include "metals.inc"
#include "woods.inc"
//#include "gemstone.inc"

global_settings {
        adc_bailout 8/255
        max_trace_level 8
}

// POV really hates drawing small things.  The objects in this scene are
// too small for it (the bicubic patches disappear), so we scale everything
// up (including cameras and lights) by this amount.
#declare POV_BODGE = 50

#declare WholeCloth =
    texture {
	pigment {
	    bozo
	    color_map {
	     [ 0 rgb <0.2,0.4,0.9> ]
	     [ 1 rgb <0.3,0.5,1.0> ]
	    }
	    scale <0.3,0.1,0.1>
	}
	normal {
	    crackle 0.1
	    turbulence 0.1
	    scale 0.2
	}
    }

#declare Cloth =
    texture {
	bozo
	turbulence 0.4
	texture_map {
	 [ 0 WholeCloth ]
	 [ 0.8 WholeCloth ]
	 [ 0.83 pigment { color Clear } ]
	 [ 1.0 pigment { color Clear } ]
	}
	translate x*3 // Find a good bit
    }

#declare Snow =
    texture {
	pigment { rgb <1,1,1.05> }
	finish {
	    ambient 0.3
	    diffuse 1
	}
    }

#declare Ice =
    texture {
	//pigment { rgb <1,1,1.05> }
	pigment { rgbf <1,1,1.06,0.9> }
	finish {
	    specular 0.8
	    phong 1
	    phong_size 300
	    roughness 0.05
	    ambient 0
	    diffuse 0
	    refraction 1  
	    reflection 0.1
	    ior 1.4
	}
    }

#declare SnowAndIce =
    texture {
	bozo
	turbulence 0.4
	texture_map {
	    [ 0 Ice ]
	    [ 0.75 Ice ]
	    [ 0.8 Snow ]
	    [ 1.0 Snow ]
	}
	scale <0.1,2,0.1>
    }

#declare SomeSnow =
    texture {
	pigment {
	    bozo
	    turbulence 0.4
	    color_map {
		[ 0 color Clear ]
		[ 0.65 color Clear ]
		[ 0.7 color rgb <1,1,1.05> ]
		[ 1.0 color rgb <1,1,1.05> ]
	    }
	}
	finish {
	    ambient 0.3
	    diffuse 1
	}
	translate x*20 // find a good bit
	scale 0.1
    }

#declare Limestone =
	texture {
		pigment {
			granite
			color_map{
				[0.0, 0.1 colour rgb<0.00,0.0,0.0>
				          colour rgb<0.48,0.5,0.5>]
				[0.1, 0.8 colour rgb<0.48,0.5,0.5>
				          colour rgb<0.58,0.6,0.6>]
				[0.8, 1.0 colour rgb<0.58,0.6,0.6>
				          colour rgb<0.68,0.7,0.7>]
			}
			quick_color rgb<0.58,0.6,0.6>
		}
		scale 0.5
	}
	texture {
		pigment {
			marble
			turbulence 1.7
			color_map {
				[0.0, 0.03
				color White filter 0.3
				color White filter 1.0]
				[0.03, 1.00
				color White filter 1.0
				color White filter 1.0]
			}
			frequency 0.5
			quick_color rgb<0.58,0.6,0.6>
		}
		finish {
		    specular 0.5 roughness 0.07
		}
		scale 1.3
		rotate z*99
	}

#declare UpperMountainTexture =
    texture {
	Limestone
	scale 0.2
    }

#declare MountainTexture =
    texture {
	Limestone
	scale 0.2
    }

#declare PathTexture =
    texture {
	Snow
    }

/*
    texture {
	pigment {
	    granite
	    color_map {
		[ 0 color <231,183,104>/255 ]
		[ 1 color <231,183,104>/300 ]
	    }
	    scale 0.002
	}
	normal { crackle 0.1 turbulence 0.2 scale 0.002 }
	finish { Dull }
    }
    texture {
	SomeSnow
    }
*/


#declare Leather =
    texture {
	pigment {
	    marble
	    turbulence 0.1
	    colour_map {
	      [0 rgb<0.75,0.35,0>]
	      [0.5 rgb<0.75,0.35,0>]
	      [1 rgb<0.75,0.35,0>/2]
	    }
	}
	normal {
	    crackle 0.06
	    scallop_wave
	    //triangle_wave
	    scale 0.08
	}
	finish { Shiny }
    }

#declare SADDLE_STRAP_TEXTURE =
    texture {
	Leather
	pigment { rgb<0.75,0.35,0>*0.8 }
    }

#declare SANDLE_TEXTURE = texture { SADDLE_STRAP_TEXTURE }

#declare Saddle =
    blob {
	threshold 0.5
	sphere { <-0.8,0,0>, 1.3, 1 }
	sphere { <+0.8,0,0>, 1.3, 1 }
	sphere { <-1.2,0,0>, 1.0, -1 }
	sphere { <+1.2,0,0>, 1.0, -1 }
	sphere { <-0.9,0,0>, 0.5, -1 }
	sphere { <+0.9,0,0>, 0.5, -1 }
	cylinder { <-2,0,0>, <2,0,0>, 0.4, -1 }
	sphere { <0,-2,0>, 2.2, -7 scale <1,1.3,1.1> }

	texture { Leather }

	scale <1.5,1.5,2.0>
	translate <0,-0.45,0>
    }

#declare SK_TEX =
    texture{
        finish{ diffuse 0.8 }
        normal {
	    marble 0.1 scale 0.9 turbulence 1
	}
        pigment{color rgb <0.90,.84,.73>}
    }

#declare E_R00 = 0
#declare E_R01 = 0
#declare W_R00 = 0
#declare W_R01 = 0


#declare Staff =
    union {
	cylinder {
	    <-0.6,0,0> <1,0,0> 0.013
	    texture {
		T_Wood19
		normal {
		    bumps 0.4
		}
		scale 0.1
		rotate y*92
	    }
	}
	#declare NPRONG=3
	#while (NPRONG)
	    intersection {
		cylinder {
		    <0,0,0>
		    <0.16,0,0>,0.005
		}
		plane {
		    x,0
		    rotate z*-70
		    translate <0.155,0,0>
		}
		texture {
		    T_Wood19
		    normal {
			bumps 0.4
		    }
		    scale 0.07
		    rotate y*92
		}
		rotate z*20
		rotate x*(NPRONG*120+60)
		translate <0.904,0,0>
	    }
	    #declare NPRONG=NPRONG-1
	#end
	union {
	    sphere {
		<0,0,0>, 0.05
		texture {
		    pigment { color White }
		    finish { ambient 0.7 }
		}
	    }
	    sphere {
		<0,0,0>, 1
		pigment { color rgbt <1,1,1,1> }
		hollow
		halo {
		    emitting
		    linear
		    spherical_mapping
		    turbulence 0.1
		    omega 0.39
		    color_map {
			[ 0.0 rgbt <1,1,1,1> ]
			[ 0.5 rgbt <1,1,0.6,0> ]
			[ 1.0 rgbt <1,1,1,1> ]
		    }
		}
		scale 0.2
	    }
	    union {
	    #declare N=8
	    #while (N>0)
		torus {
		    1, 0.20
		    scale 0.2+N/10
		    rotate z*85
		    translate x*(0.3+N*0.45+N*N*0.057)
		}
		#declare N=N-1
	    #end
		scale 0.21
		texture {
		    pigment { colour rgbt<0.9,0.9,1.0,0.95> }
		    finish { ambient 0.7 }
		}
		rotate z*122
		rotate x*-60
	    }
	    translate <1.06,0,0>
	}
/* Doesn't suit.
	object {
	    Gemstone
	    texture { RubyTexture finish { ambient 0.6 /* glow */ } }
	    //texture { EmeraldTexture }
	    scale 0.1
	    rotate z*-90
	    rotate x*6 // Find a nice angle on the facets
	    translate <1.07,0,0>
	}
*/
    }

#declare Rider =
    union {
	#declare SIDE = -1 // 1=left, -1=right
	#declare ZCENT = 3.05*SIDE
	#include "head02.inc"
	union{
	    object{
		HEAD02f
	        translate<(.3+1.8*sin(radians(7)))*-1,1.5+1.8*cos(radians(7)),0>
	        scale 1.415
		translate<.3,23,0>
	    }

	    //right
	    //leg
	    #declare LJX_01 = -50
	    #declare LJZ_01 = -40
	    #declare LJZ_02 = 100
	    #declare LJZ_03 = 20
	    #declare DJZ_11 = LJZ_01
	    //arm
	    #declare AAX_01 = 10
	    #declare AAZ_01 = 100
	    #declare AAZ_02 = 110
	    #declare AAY_02 = 20//-45
	    //hand
	    //ball of the thumb/thumb
	       #declare H_A01X = 3*SIDE     //adjustable
	       #declare H_A01Z = -32        //adjustable
	    //thumb
	       #declare H_A11Y = 10*SIDE    //"joint 1", adjustable
	       #declare H_A21Y = 10*SIDE    //"joint 2", adjustable
	       #declare H_A21Z = 15         //"joint 2", adjustable
	    //forefinger
	       #declare H_A02Y = 0*SIDE    //"joint 1", adjustable
	       #declare H_A12Y = 0*SIDE    //"joint 2", adjustable
	       #declare H_A22Y = 10*SIDE    //"joint 3", adjustable
	    //middle finger
	       #declare H_A03Y = 30*SIDE    //"joint 1", adjustable
	       #declare H_A13Y = 86*SIDE    //"joint 2", adjustable
	       #declare H_A23Y = 98*SIDE    //"joint 3", adjustable
	    //4th finger
	       #declare H_A04Y = 60*SIDE    //"joint 1", adjustable
	       #declare H_A14Y = 90*SIDE    //"joint 2", adjustable
	       #declare H_A24Y = 120*SIDE    //"joint 3", adjustable
	    //little finger
	       #declare H_A05Y = 85*SIDE    //"joint 1", adjustable
	       #declare H_A15Y = 120*SIDE    //"joint 2", adjustable
	       #declare H_A25Y = 130*SIDE    //"joint 3", adjustable

	    #include "body009.inc"
	    #include "sandle009.inc"

	    //left
	    #declare SIDE = 1 // 1=left, -1=right
	    #declare ZCENT = 3.05*SIDE
	    //LEG
	    #declare LJX_01 = 50
	    #declare LJZ_01 = -40
	    #declare LJZ_02 = 100
	    #declare LJZ_03 = 20
	    #declare DJZ_01 = LJZ_01
	    //arm
	    #declare AAX_01 = 9
	    #declare AAZ_01 = -30
	    #declare AAZ_02 = +90//75
	    #declare AAY_02 = -38 //5
	    //hand
	    //ball of the thumb/thumb
	       #declare H_A01X = 3*SIDE     //adjustable
	       #declare H_A01Z = -40        //adjustable
	    //thumb
	       #declare H_A11Y = 10*SIDE    //"joint 1", adjustable
	       #declare H_A21Y = 10*SIDE    //"joint 2", adjustable
	       #declare H_A21Z = 20         //"joint 2", adjustable
	    //forefinger
	       #declare H_A02Y = 32*SIDE    //"joint 1", adjustable
	       #declare H_A12Y = 93*SIDE    //"joint 2", adjustable
	       #declare H_A22Y = 104*SIDE    //"joint 3", adjustable
	    //middle finger
	       #declare H_A03Y = 34*SIDE    //"joint 1", adjustable
	       #declare H_A13Y = 101*SIDE    //"joint 2", adjustable
	       #declare H_A23Y = 107*SIDE    //"joint 3", adjustable
	    //4th finger
	       #declare H_A04Y = 34*SIDE    //"joint 1", adjustable
	       #declare H_A14Y = 108*SIDE    //"joint 2", adjustable
	       #declare H_A24Y = 112*SIDE    //"joint 3", adjustable
	    //little finger
	       #declare H_A05Y = 35*SIDE    //"joint 1", adjustable
	       #declare H_A15Y = 106*SIDE    //"joint 2", adjustable
	       #declare H_A25Y = 110*SIDE    //"joint 3", adjustable

	    #include "body009.inc"
	    #include "sandle009.inc"
	}

	union {
#include "cloak.inc"
	    //rotate y*-90
	    rotate y*20
	    rotate x*10
	    scale <3,3,3>
	    translate <-5,5.0,-3.5>
	    //texture { pigment { colour Green } }
	    texture { Cloth }
	}

	union {
#include "cape.inc"
	    rotate y*-90
	    rotate z*-90
	    scale <3,-3,3>
	    translate <11.5,24.0,-10>
	    texture { Cloth }
	}

	union {
	    sphere {
		<0,0,0>,0.6
		texture { pigment { Red } finish { ambient 0.5 } }
	    }
	    sphere {
		<0,0,0>,1
		scale <0.5,1,1>
		texture { Gold_Metal }
	    }
	    rotate z*-30
	    translate <-2,22,0>
	}
	object {
	    Staff
	    rotate z*180
	    translate x*0.2
	    scale 30
	    //rotate z*-35.54
	    //translate <-7.0,20,5.5>
	    rotate z*-36
	    rotate y*52
	    rotate x*-1
	    translate <-13,24.6,5.5>
	}
	scale 0.13
	translate <0.27,-0.9,0>
    }

//#ifndef (ONLY_BODY)
#declare SADDLE = // +/-1 in X and Z extents, Y=0 is top-of-carrier
    union {
	object { Saddle }
	object { Rider }
    }
//#end

#ifndef (ONLY_RIDER)
#ifndef (NO_DRAGON)
#include "dragon.inc"
#end
#end



light_source {
    <-300, 1200, -1500>
    color rgb<1,1,1>
    area_light x*40,y*40,5,5
    adaptive 1
    jitter
    scale POV_BODGE
}

#declare Distance =
	camera {
		direction z*2
		location  <0, 2, -5>
		look_at   <0, 0, 0>
	}

#declare AtFaceFromSide =
	camera {
		direction z*1.2
		location  <-0.014, +0.22, -0.29>
		look_at   <-0.19, 0.18, -0.2>
	}

#declare AtFaceFromFront =
	camera {
		direction z*1.2
		location  <-0.22, +0.22, -0.33>
		look_at   <-0.15, 0.20, -0.20>
	}

#declare FromAboveSaddle =
	camera {
		direction z*4
		location  <-0.06, +1.22, -0.10>
		look_at   <-0.05, 0.20, -0.10>
	}

#declare AtRider =
	camera {
		direction z*2.0
		location  <-0.0, +0.22, -0.33>
		look_at   <-0.05, 0.195, -0.20>
	}

#declare AtRiderRightHand =
	camera {
		direction z*16.0
		location  <-0.0, +0.22, -0.33>
		look_at   <-0.072, 0.209, -0.20>
	}

#declare AtRiderLeftHand =
	camera {
		direction z*10.0
		location  <-0.0, +0.22, -0.33>
		look_at   <-0.05, 0.195, -0.20>
	}

#declare AtRiderSandal =
	camera {
		direction z*10.0
		location  <-0.0, +0.22, -0.33>
		look_at   <-0.041, 0.170, -0.20>
	}

#declare AtRiderHead =
	camera {
		direction z*10.0
		location  <-0.0, +0.22, -0.33>
		look_at   <-0.055, 0.2143, -0.20>
	}

#declare AtStaff =
	camera {
		direction z*4.0
		location  <-0.0, +0.22, -0.33>
		look_at   <-0.09, 0.22, -0.20>
	}

#declare AtHeadOfStaff =
	camera {
		direction z*8.0
		location  <-0.0, +0.22, -0.73>
		look_at   <-0.146, 0.236, -0.20>
	}

#declare AtRiderFace =
	camera {
		direction z*150.0
		location  <-1.0,  0.22, -1.0>
		look_at   <-0.055, 0.208, -0.007>
	}

#declare AtRiderFromFront =
	camera {
		direction z*2
		location  <-0.2, +0.32, -0.4>
		look_at   <-0.045, 0.10, 0.10>
	}

#declare AtSaddle =
	camera {
		direction z*5
		location  <-0.0, +0.22, -0.33>
		look_at   <-0.045, 0.195, -0.20>
	}

#declare AtSaddleFromBack =
	camera {
		direction z*3
		location  <-0.0, +0.22, 0.5>
		look_at   <-0.05, 0.19, -0.20>
	}

#declare FromAbove =
	camera {
		direction z*1.5
		location  <0, 1, 0>
		look_at   <0, 0, 0>
	}

#declare GodsEyeView =
	camera {
		direction z
		//location  <0, 80, 30>
		//look_at   <0, 0, 30>
		location  <-5, 10, 0>
		look_at   <-5, 0, 0>
	}

#declare FromAboveHead =
	camera {
		direction z*1.5
		location  <-0.15, +0.42, -0.2>
		look_at  <-0.15, +0.0, -0.19>
	}

#declare AtHindLeg =
	camera {
		direction z*5.0
		location  <-0.10, +0.2, -0.50>
		look_at   <0.08, 0.02, 0>
	}

#declare AtHindLegAligned =
	camera {
		direction z*2.0
		location  <0.10, +0.2, -0.50>
		look_at   <0.08, 0.05, 0>
	}

#declare AtFrontLegAligned =
	camera {
		direction z*4.0
		location  <-0.10, +0.2, -0.50>
		look_at   <-0.08, 0.03, 0>
	}




#declare Aesthetic =
	camera {
		direction z*1.0
		//location  <0, -0.10, -0.35>
		location  <-0.10, +0.2, -0.50>
		look_at   <-0.03, 0.08, 0>
		//look_at   <0, 0, 0>
	}
/* 
cone {
    <-0.10, +0.2, -0.50>,0.1
    <-0.03, 0.08, 0>,0
    scale POV_BODGE
    pigment { color Yellow }
}
*/

#declare AtCave =
	camera {
		direction z*1.0
		//location  <0, -0.10, -0.35>
		location  <-0.10, +0.2, -0.50>
		look_at   <-0.03, 0.08, 0>
		//look_at   <0, 0, 0>
		rotate y*20
	}


camera { FromAboveHead scale POV_BODGE }
camera { AtFaceFromFront scale POV_BODGE }
camera { AtFaceFromSide scale POV_BODGE }
camera { Distance scale POV_BODGE }
camera { AtSaddle scale POV_BODGE }
camera { AtSaddleFromBack scale POV_BODGE }
camera { AtRiderSandal scale POV_BODGE }
camera { AtHindLeg scale POV_BODGE }
camera { AtRiderHead scale POV_BODGE }
camera { AtRiderFace scale POV_BODGE }
camera { AtHindLegAligned scale POV_BODGE }
camera { AtFrontLegAligned scale POV_BODGE }
camera { AtStaff scale POV_BODGE }
//camera { GodsEyeView scale POV_BODGE } #declare GOD = 1
camera { AtCave scale POV_BODGE }
camera { AtHeadOfStaff scale POV_BODGE }
camera { FromAboveSaddle scale POV_BODGE }
camera { AtRiderFromFront scale POV_BODGE }
camera { FromAbove scale POV_BODGE }
camera { AtRider scale POV_BODGE }
camera { AtRiderRightHand scale POV_BODGE }
camera { AtRiderLeftHand scale POV_BODGE }
camera { Aesthetic scale POV_BODGE }

#ifdef (GOD)
cone {
    <0,0,0>, 1
    <0,0,10>, 0
    pigment { colour Red }
    scale POV_BODGE
}
#else

#ifndef (NO_DRAGON)
object {
	Dragon

	rotate z*8
	rotate y*-29
	scale 0.07 * POV_BODGE
}
#end

#end

#ifndef (NO_MOUNTAIN)
difference {
    union {
	height_field {
	    ppm "mountainb.ppm"
	    smooth
	    rotate y*-90
	    scale <1,16,1> // undo scale-down
	    scale <1,4,1>
	}
	box {
	    <0,-1,0><1.5,4,0.5>
	}
	box {
	    <-0.45,-1,-2><1.5,4,0>
	}
	texture {
	    material_map {
		gif "mountcol.gif"
		texture { UpperMountainTexture }
		texture { PathTexture }
		texture { MountainTexture }
	    }
	    rotate x*90
	    rotate y*-90
	}
	rotate y*-30
	translate <-0.1,-2.0,0>
    }
    blob {
	threshold 1
	sphere {
	    <0,0,0>,
	    0.17
	    1.5
	    scale <0.1,1,0.9>*1.9
	    rotate z*-5
	    rotate y*-12
	    translate <-0.58,0.14,0>
	    rotate y*10
	}
	sphere {
	    <0,0,0>,
	    0.17
	    1.5
	    scale <0.1,1,1>*2.7
	    rotate z*-5
	    rotate y*-12
	    translate <-0.58,0.03,0>
	    rotate y*10
	}
	cylinder {
	    <0,0,0>,
	    <20,0,0>,
	    0.17
	    2.5
	    scale <0.1,0.8,0.7>*3.0
	    translate <-0.55,0.07,0>
	    rotate y*4
	}
    }

    texture { Limestone scale 0.3 translate (x+y)*20 rotate x*90}
    translate <1,0,0>
    rotate y*-29
    scale POV_BODGE
}
#end

#ifdef (NO_BACKGROUND)
background {
    color rgb<0.5,0.5,0.5>
}
#else
height_field {
    //ppm "landscape.ppm"
    tga "land.tga"
    texture {
	pigment {
	    image_map {
		ppm "landcol.ppm"
		interpolate 2
	    }
	    rotate x*90
	}
    }
    //smooth
    rotate y*85
    translate <0,0,1>
    translate <-0.5,0,-0.1>
    //scale <100,15,100>
    scale <80,40,80>
    translate <0,-4.9,0>
    //texture { pigment { rgb<0.2,0.2,0.2> } }
    //texture { pigment { rgb<1,1,1> } }
    scale POV_BODGE
}

#ifdef (GOD)
#else
fog {
    color rgb<0.69,0.7,1>
    fog_type 1
    distance 35 * POV_BODGE
    //fog_offset 20 * POV_BODGE
    //fog_alt 0.1 * POV_BODGE
    turbulence 1
    turb_depth 2 * POV_BODGE
}
#end

#end
