/*-----------------------------------------------
  "This strange engine"


  1 unit = 1 cm
-----------------------------------------------*/

//-----------------------------------------------
#ifdef (SCENE_FILE)     // This file is included into another scene
  #declare STRANGE_ENGINE_INCLUDED = 1
#else                   // This is the main scene file
  #declare SCENE_FILE = 1
  #declare HQ = 1
#end

//-----------------------------------------------
#include "colors.inc"

#include "blood_creature.pov"
//-----------------------------------------------
#ifndef (STRANGE_ENGINE_INCLUDED)
  #declare FrontLocation = <0, 80, -180>
  #declare FrontLookAt = <-20, 63, 0>

  #declare MeterLocation = <30, 55, -75>
  #declare MeterLookAt = <30, 50, -45>

  #declare TestLocation = <60, 55, 145>
  #declare TestLookAt = <0, 50, 0>

  camera {
    location FrontLocation
    look_at FrontLookAt
  }

  light_source {
    <-500, 1000, 0>
    White
  }
  light_source {
    <100, 1000, -1500>
    White
  }

  background { Black }
#end       // (STRANGE_ENGINE_INCLUDED)

//-----------------------------------------------
#declare TRedMetal = texture {
  pigment {
    color <0.5, 0.2, 0>
  }
  finish {
    ambient 0.3
    phong 1
    metallic
#ifdef (HQ)
    reflection 0.2
#end
  }
#ifdef (HQ)
  normal {
    bumps 0.1
    scale <0.05, 0.05, 0.05>
  }
#end
}

#declare TWhiteMeters = texture {
  pigment {
    color <1, 1, 1>
  }
  finish {
    ambient 0.4
    phong 1
  }
#ifdef (HQ)
  normal {
    bumps 0.1
    scale <0.05, 0.05, 0.05>
  }
#end
}

//-----------------------------------------------
#declare NitBand = union {
  cylinder {
    <-3, 0, 0>
    <3, 0, 0>, 42
  }
  torus {
    40, 2
    rotate 90*z
    translate -3*x
  }
  torus {
    40, 2
    rotate 90*z
    translate 3*x
  }
#declare i = 0
#while (i < 12)
  sphere {
    <0, 0, 0>, 3.5
    scale <1, 0.7, 1>
    translate 41*y
    rotate i*360/12*x
  }
#declare i = i + 1
#end
}

//-----------------------------------------------
#declare Lock = union {
  torus {
    39, 1
    rotate 90*z
  }
  cylinder {
    <-1, 0, 0>
    <-2.5, 0, 0>, 40
  }
#declare i = 0
#while (i < 12)
  sphere {
    <0, 0, 0>, 2.5
    scale <0.7, 1, 1>
    translate <-2, 35, 0>
    rotate i*360/12*x
  }
#declare i = i + 1
#end
}

//-----------------------------------------------
#declare LitetLock = union {
  difference {
    cylinder {
      <0, 0, -44>
      <0, 0, -45>, 24
    }
    cylinder {
      <0, 0, -40>
      <0, 0, -50>, 18
    }
  }
#declare i = 0
#while (i < 8)
  sphere {
    <0, 0, 0>, 2.6
    scale <1, 1, 0.5>
    translate <0, 21, -44.5>
    rotate (i+0.5)*360/8*z
  }
#declare i = i + 1
#end
}

//-----------------------------------------------
#declare PipTopp = difference {
  cylinder {
    <0, 0, 0>
    <0, 99, 0>, 10
  }
  cylinder {
    <0, -1, 0>
    <0, 100, 0>, 8.5
  }
  box {
    <-50, 0, -50>
    <50, 50, 50>
    rotate -55*x
    translate 45*y
  }
}
//-----------------------------------------------
#declare PipeSmoke = sphere {
  <0, 0, 0>, 1
  pigment { Clear }
  halo {
    emitting
    spherical_mapping
    linear
    turbulence 1.6
    color_map {
      [0.0   color rgbt <1, 1, 1, 1>]
      [1.0   color rgbt <0.5, 0.5, 0.5, -1>]
    }
    samples 10
    scale 0.5
  }
  hollow
  scale <7, 40, 7>
}
//-----------------------------------------------
#declare PipBotten = difference {
  union {
    intersection {
      cylinder {
        <0, -100, 0>
        <0, 99, 0>, 10
      }
      cylinder {
        <0, 0, 30>
        <0, 0, -30>, 10
      }
    }
    cylinder {
      <0, 0, 0>
      <0, 0, -30>, 10
    }
  }
  cylinder {
    <-58, 0, 0>
    <58, 0, 0>, 40
  }
}
//-----------------------------------------------
// Rtt placerad frn brjan
//
#declare Pipor = union {
  union {
    object {
      PipTopp
      translate 40*y
    }
    object {
      PipBotten
    }
    cylinder {
      <0, 0, 0>
      <0, 40, 0>, 10
    }
    translate <-50, -20, 0>
  }
  union {
    object {
      PipTopp
      translate 55*y
    }
    object {
      PipBotten
    }
    cylinder {
      <0, 0, 0>
      <0, 55, 0>, 10
    }
    translate <-30, -20, 0>
  }
  union {
    object {
      PipTopp
      translate 70*y
    }
    object {
      PipBotten
    }
    cylinder {
      <0, 0, 0>
      <0, 70, 0>, 10
    }
    translate <-10, -20, 0>
  }
  union {
    object {
      PipTopp
      translate 70*y
    }
    object {
      PipBotten
    }
    cylinder {
      <0, 0, 0>
      <0, 70, 0>, 10
    }
    translate <10, -20, 0>
  }
  union {
    object {
      PipTopp
      translate 55*y
    }
    object {
      PipBotten
    }
    cylinder {
      <0, 0, 0>
      <0, 55, 0>, 10
    }
    translate <30, -20, 0>
  }
  union {
    object {
      PipTopp
      translate 40*y
    }
    object {
      PipBotten
    }
    cylinder {
      <0, 0, 0>
      <0, 40, 0>, 10
    }
    translate <50, -20, 0>
  }

  translate <0, 0, 55>
}
//-----------------------------------------------
// <0, 0, 0> i mitten p infstningen
//
#declare SidoPipa = union {
  cylinder {
    <0, 0, 0>
    <-7, 0, 0>, 11.5
  }
  torus {
    10, 1.5
    rotate 90*z
    translate -7*x
  }
  cylinder {
    <0, 0, 0>
    <-5.5, 0, 0>, 12
  }
#declare i = 0
#while (i < 16)
  cylinder {
    <0, 11.8, 0>
    <-5.5, 11.8, 0>, 1
    rotate (360*i/16)*x
  }
#declare i = i + 1
#end
  cylinder {
    <-4, 0, 0>
    <-18, 0, 0>, 10
  }
  cylinder {
    <-10, 0, 0>
    <-22, 0, 0>, 8
  }
  cylinder {
    <-20, 0, 0>
    <-36, 0, 0>, 6
  }
  cylinder {
    <-20, 0, 0>
    <-37, 0, 0>, 5
  }
  torus {
    5, 1
    rotate 90*z
    translate -36*x
  }

  cylinder {
    <-30, 0, 0>
    <-30, 11, 0>, 6
  }
  box {
    <-30, 1, -5>
    <-36.5, 10, 5>
  }
  box {
    <-30, 4, -0.5>
    <-20, 8, 0.5>
  }

  difference {  // Pipan
    union {
      cylinder {
        <-30, 10, 0>
        <-30, 70, 0>, 7
      }
      cylinder {
        <-30, 69, 0>
        <-30, 70, 0>, 12
      }
#declare i = 0
#while (i < 4)
      box {
        <0, 0, -0.5>
        <-5, -40, 0.5>
        rotate -4.5*z
        translate (7+3)*x
        rotate (5 + 90*i)*y
        translate <-30, 69, 0>
      }
#declare i = i + 1
#end
    }
    cylinder {
      <-30, 10, 0>
      <-30, 80, 0>, 6
    }
    torus {
      7, 0.3
      translate <-30, 18, 0>
    }
    torus {
      7, 0.3
      translate <-30, 22, 0>
    }
    torus {
      7, 0.3
      translate <-30, 26, 0>
    }
  }
}

//-----------------------------------------------
#declare Fot = union {
  intersection {
    difference {
      box {
        <-1.5, -30, -27>
        <1.5, -50, 27>
      }
      cylinder {
        <-2, 0, 0>
        <2, 0, 0>, 40
      }
    }
    cylinder {
      <-3, 35, 0>
      <3, 35, 0>, 80
    }
  }
  difference {
    box {
      <-1.5, -30, -40>
      <1.5, -50, 40>
    }
    box {
      <-2, -45, -35-3>
      <2, -10, -50>
    }
    box {
      <-2, -45, 35+3>
      <2, -10, 50>
    }

    cylinder {
      <-3, -45+3, -35-3>
      <3, -45+3, -35-3>, 3
    }
    cylinder {
      <-3, -45+3, 35+3>
      <3, -45+3, 35+3>, 3
    }

    box {
      <-2, 0, 0>
      <2, 20, -30>
      rotate 30*x
      translate <0, -43, -35>
    }
    box {
      <-2, 0, 0>
      <2, 20, 30>
      rotate -30*x
      translate <0, -43, 35>
    }

    box {
      <-2, 0, 0>
      <2, 40, 30>
      rotate 35*x
      translate <0, -50, -32>
    }
    box {
      <-2, 0, 0>
      <2, 40, -30>
      rotate -35*x
      translate <0, -50, 32>
    }
  }
}

//-----------------------------------------------
// <0, 0, 0> i nden p axeln
//
#declare Ratt = union {
  intersection {      // Mutter
    box {
      <-2.5, -6, 3>
      <2.5, 6, 1>
    }
    box {
      <-2.5, -6, 3>
      <2.5, 6, 1.001>
      rotate 60*z
    }
    box {
      <-2.5, -6, 3>
      <2.5, 6, 1.002>
      rotate 120*z
    }
  }
  cylinder {
    <0, 0, 1.5>
    <0, 0, 0.5>, 1.2
  }

  blob {
    threshold 1.5
#declare i = 0
#while (i < 6)
    sphere {
      <11, 0, -0.5>, 6, 2
      rotate (360*i/6)*z
    }
    sphere {
      <10, 0, -0.5>, 5, 1
      rotate (360*(i+0.25)/6)*z
    }
    sphere {
      <10, 0, -0.5>, 5, 1
      rotate (360*(i+0.5)/6)*z
    }
    sphere {
      <10, 0, -0.5>, 5, 1
      rotate (360*(i+0.75)/6)*z
    }
#declare i = i + 1
#end
  }

  difference {
    intersection {
      difference {
        sphere {
          <0, 0, -7>, 7+4
        }
        sphere {
          <0, 0, -7>, 7+3
        }
      }
      cylinder {
        <0, 0, -5>
        <0, 0, 5>, 8.5
      }
    }
#declare j = 0
#while (j < 8)
#declare i = 0
#while (i < 8)
    cylinder {
      <6.1, 0, 6>
      <6.1, 0, -6>, 1.2
      rotate (20+80*(i)/8 + j*120)*z
    }
#declare i = i + 1
#end
#declare j = j + 1
#end
  }

  cylinder {
    <0, 0, 4>
    <0, 0, 10>, 1.5
  }
  translate -10*z
}
//-----------------------------------------------
// <0, 0, 0> i nden p rret
//
#declare RattFaste = union {
  cylinder {
    <-5, 0, 0>
    <0, 0, 0>, 3
  }
  intersection {
    torus {
      10, 3
    }
    box {
      <0, -4, 0>
      <-14, 4, 14>
    }
    translate <-5, 0, -10>
  }
  cylinder {
    <-15, 0, -10>
    <-15, 0, -8>, 3.5
  }
  cylinder {
    <-5, 0, -20>
    <0, 0, -20>, 3
  }
  cylinder {
    <-5, 0, -20>
    <-3, 0, -20>, 3.5
  }

  difference {
    box {
      <-20, -5, -10>
      <-5, 5, -25>
    }
    cylinder {
      <-12, 0, -23>
      <-12, 0, -32>, 2.5
    }
  }
  torus {
    2.25, 0.25
    rotate 90*x
    translate <-12, 0, -24.75>
  }
  torus {
    1.75, 0.25
    rotate 90*x
    translate <-12, 0, -24.75>
  }
  object {
    Ratt
    translate <-12, 0, -24>
  }
}

//-----------------------------------------------
// <0, 0, 0> centrum av baksidan p strsta mtaren
#declare Maetare = union {
  union {
    difference {
      cylinder {
        <0, 0, 0>
        <0, 0, -4>, 5
      }
      cylinder {
        <0, 0, -1>
        <0, 0, -5>, 4.75
      }
      texture { TRedMetal }
    }
    cylinder {
      <0, 0, 0>
      <0, 0, 10>, 0.5
      texture { TRedMetal }
    }
// Urtavla
    cylinder {
      <0, 0, -1>
      <0, 0, -3.5>, 4.95
      texture { TWhiteMeters }
    }
#ifdef (HQ)
    union {
      cylinder {
        <0, 0, -3.5>
        <0, 0, -3.8>, 0.25
      }
      box {
        <-0.075, -0.7, -3.7>
        <0.075, 3.5, -3.8>
        rotate -33*z
      }

      difference {
        cylinder {
          <0, 0, -3.5>
          <0, 0, -3.55>, 4.4
        }
        cylinder {
          <0, 0, -3.4>
          <0, 0, -3.8>, 4.25
        }
      }

      text {
        ttf "timrom.ttf"
        "XII", 1, 0
        translate <-0.65, 3.4, -3.55>
      }
      text {
        ttf "timrom.ttf"
        "I", 1, 0
        translate <1.6, 2.7, -3.55>
      }
      text {
        ttf "timrom.ttf"
        "II", 1, 0
        translate <2.7, 1.4, -3.55>
      }
      text {
        ttf "timrom.ttf"
        "III", 1, 0
        translate <3.1, -0.25, -3.55>
      }
      text {
        ttf "timrom.ttf"
        "IV", 1, 0
        translate <2.6, -1.8, -3.55>
      }
      text {
        ttf "timrom.ttf"
        "V", 1, 0
        translate <1.5, -3.2, -3.55>
      }
      text {
        ttf "timrom.ttf"
        "VI", 1, 0
        translate <-0.55, -4, -3.55>
      }
      text {
        ttf "timrom.ttf"
        "VII", 1, 0
        translate <-2.6, -3, -3.55>
      }
      text {
        ttf "timrom.ttf"
        "VIII", 1, 0
        translate <-3.7, -1.7, -3.55>
      }
      text {
        ttf "timrom.ttf"
        "IX", 1, 0
        translate <-4, -0.25, -3.55>
      }
      text {
        ttf "timrom.ttf"
        "X", 1, 0
        translate <-3.6, 1.4, -3.55>
      }
      text {
        ttf "timrom.ttf"
        "XI", 1, 0
        translate <-2.5, 2.7, -3.55>
      }
      pigment { Black }
    }
#end
  }

// vre mtaren
  union {
    difference {
      cylinder {
        <0, 0, 0>
        <0, 0, -4>, 3.5
      }
      cylinder {
        <0, 0, -1>
        <0, 0, -5>, 3.25
      }
      texture { TRedMetal }
    }
    cylinder {
      <0, 0, 0>
      <0, 0, 10>, 0.5
      texture { TRedMetal }
    }
// Urtavla
    cylinder {
      <0, 0, -1>
      <0, 0, -3.5>, 3.45
      texture { TWhiteMeters }
    }
    union {
      cylinder {
        <0, 0, -3.5>
        <0, 0, -3.8>, 0.2
      }
      box {
        <-0.05, -0.5, -3.7>
        <0.05, 2.5, -3.8>
        rotate -122*z
      }
#declare i = 0
#while (i < 12)
      text {
        ttf "timrom.ttf"
        "999", 1, 0
        scale 0.5
        translate <-0.45+2.1*cos(i*2*3.14/12), -0.25+2.1*sin(i*2*3.14/12), -3.55>
      }
#declare i = i + 1
#end
      pigment { Black }
    }
    translate 9*y
  }

// Undre mtaren
  union {
    difference {
      cylinder {
        <0, 0, 0>
        <0, 0, -4>, 3
      }
      cylinder {
        <0, 0, -1>
        <0, 0, -5>, 2.75
      }
      texture { TRedMetal }
    }
    cylinder {
      <0, 0, 0>
      <0, 0, 10>, 0.5
      texture { TRedMetal }
    }
// Urtavla
    cylinder {
      <0, 0, -1>
      <0, 0, -3.5>, 2.95
      texture { TWhiteMeters }
    }
    union {
      cylinder {
        <0, 0, -3.5>
        <0, 0, -3.8>, 0.2
      }
      box {
        <-0.05, -0.5, -3.7>
        <0.05, 2.5, -3.8>
        rotate -77*z
      }
#declare i = 0
#while (i < 12)
      text {
        ttf "timrom.ttf"
        "666", 1, 0
        scale 0.4
        translate <-0.45+1.8*cos(i*2*3.14/12), -0.25+1.8*sin(i*2*3.14/12), -3.55>
      }
#declare i = i + 1
#end
      pigment { Black }
    }
    translate -8.5*y
  }
}

//-----------------------------------------------
#declare Insida = difference {
  cylinder {
    <-58, 0, 0>
    <58, 0, 0>, 38.995
  }
  cylinder {      // Ihlig huvudkropp
    <-50, 0, 0>
    <50, 0, 0>, 38.99
  }
  cylinder {      // Hl framt
    <0, 0, 0>
    <0, 0, -50>, 20
  }
  pigment { color <1, 1, 0> }
  finish {
    ambient 0.3
    phong 1
  }
}
//-----------------------------------------------
#declare StrangeEngine = union {
  union {
    difference {
      union {
        cylinder {
          <-58, 0, 0>
          <58, 0, 0>, 40
        }
        cylinder {
          <0, 0, -10>
          <0, 0, -45>, 23
        }
      }
      cylinder {      // Ihlig huvudkropp
        <-50, 0, 0>
        <50, 0, 0>, 39
      }
      cylinder {      // Hl framt
        <0, 0, 0>
        <0, 0, -50>, 19
      }
    }

    cylinder {        // Tjockare bitar
      <-32, 0, 0>
      <-45, 0, 0>, 41
    }
    cylinder {
      <32, 0, 0>
      <45, 0, 0>, 41
    }

    object {
      Pipor
    }
    object {
      SidoPipa
      translate <-60, 20, 0>
    }

    object {
      NitBand
      translate -50*x
    }
    object {
      NitBand
      translate 50*x
    }
    object {
      LitetLock
    }
    object {
      Lock
      translate -58*x
    }
    object {
      Lock
      rotate 180*z
      translate 58*x
    }

    object {
      Fot
      translate -43*x
    }
    object {
      Fot
      translate 43*x
    }
    object {
      RattFaste
      translate <-60, -10, -10>
    }

    texture { TRedMetal }
  }

  union {
    object {
      Insida
    }
    object {
      Maetare
      translate <32, 0, -45>
    }

  }
#ifdef (HQ)
  object {
    PipeSmoke
    translate <-30-60, 70+20, 0>
  }
#end

  light_source {
    <0, 0, -15>
    color <1, 1, 0>
  }
  light_source {
    <0, 0, 10>
    color <1, 1, 0>
  }
  object {
    BloodBlobs
    translate <0, -15, -5>
  }
  translate 50*y
}
//-----------------------------------------------
//-----------------------------------------------
#ifndef (STRANGE_ENGINE_INCLUDED)
object {
  StrangeEngine
}
#end
//-----------------------------------------------
