// Persistence of Vision Raytracer
// Dcor

#ifndef (MAIN_POV)
#include "common.inc"
#end

/******************************************************************************
   A faire:
   Maps pour la table
******************************************************************************/



/******************************************************************************

        textures

******************************************************************************/

#declare Decor_TBois1_=
   texture { pigment { P_WoodGrain1A color_map { M_Wood18A }}}
   texture { pigment { P_WoodGrain1B color_map { M_Wood18B }}}

#declare Decor_TBois1=
    texture{
        pigment {
            P_WoodGrain3A
            color_map { M_Orangewood }
            scale 20
            rotate x*85
        }
    }


/******************************************************************************

        objets

******************************************************************************/

#declare Decor_Lampe0=object{
   sphere{0*x, 1 hollow}
   texture {
      pigment { color Yellow*.7}
      finish { ambient .1 diffuse 0.5 }
      }
   scale 1.5
   no_shadow
   }

#declare Decor_Lampe1=object{
   sphere{0*x, 1 hollow}
   texture {
      pigment { color Clear }
      finish { ambient 0 diffuse 0 }
      halo{
         emitting spherical_mapping
         poly exponent 2 max_value 1
         color_map{
            [0.0 color rgbt<.8, .8, .2, 0.8>]
            [0.8 color rgbt<1, 1, .8, .2>]
            [1.0 color rgbt<1, 1, .8,  -.6>]
            }
         samples 10 jitter 0.3
         scale 1
         }
      }
   scale 2.5
   }

#declare Decor_Billo=union{
   union{//B
      object {Decor_Lampe1 translate <0, 0, 0>}
      object {Decor_Lampe1 translate <5, 0, 0>}
      object {Decor_Lampe1 translate <10, 0, 0>}
      object {Decor_Lampe1 translate <15, 1, 0>}
      object {Decor_Lampe1 translate <17, 4, 0>}
      object {Decor_Lampe1 translate <15, 7, 0>}
      object {Decor_Lampe1 translate <10, 10, 0>}
      object {Decor_Lampe1 translate <5, 10, 0>}
      object {Decor_Lampe1 translate <0, 10, 0>}
      object {Decor_Lampe1 translate <15, 13, 0>}
      object {Decor_Lampe1 translate <17, 16, 0>}
      object {Decor_Lampe1 translate <15, 19, 0>}
      object {Decor_Lampe1 translate <10, 20, 0>}
      object {Decor_Lampe1 translate <5, 20, 0>}
      object {Decor_Lampe1 translate <0, 5, 0>}
      object {Decor_Lampe1 translate <0, 15, 0>}
      object {Decor_Lampe1 translate <0, 20, 0>}
      }
   union{//I
      object {Decor_Lampe1 translate <0, 0, 0>}
      object {Decor_Lampe1 translate <0, 5, 0>}
      object {Decor_Lampe1 translate <0, 10, 0>}
      object {Decor_Lampe1 translate <0, 15, 0>}
      object {Decor_Lampe1 translate <0, 20, 0>}
      translate 30*x
      }
   union{//L
      object {Decor_Lampe1 translate <15, 0, 0>}
      object {Decor_Lampe1 translate <10, 0, 0>}
      object {Decor_Lampe1 translate <5, 0, 0>}
      object {Decor_Lampe1 translate <0, 0, 0>}
      object {Decor_Lampe1 translate <0, 5, 0>}
      object {Decor_Lampe1 translate <0, 10, 0>}
      object {Decor_Lampe1 translate <0, 15, 0>}
      object {Decor_Lampe1 translate <0, 20, 0>}
      translate 40*x
      }
   union{//L
      object {Decor_Lampe1 translate <15, 0, 0>}
      object {Decor_Lampe1 translate <10, 0, 0>}
      object {Decor_Lampe1 translate <5, 0, 0>}
      object {Decor_Lampe1 translate <0, 0, 0>}
      object {Decor_Lampe1 translate <0, 5, 0>}
      object {Decor_Lampe1 translate <0, 10, 0>}
      object {Decor_Lampe1 translate <0, 15, 0>}
      object {Decor_Lampe1 translate <0, 20, 0>}
      translate 70*x
      }
   union{//G
      object {Decor_Lampe1 translate <15, 18, 0>}
      object {Decor_Lampe1 translate <10, 20, 0>}
      object {Decor_Lampe1 translate <5, 20, 0>}
      object {Decor_Lampe1 translate <0, 15, 0>}
      object {Decor_Lampe1 translate <0, 10, 0>}
      object {Decor_Lampe1 translate <0, 5, 0>}
      object {Decor_Lampe1 translate <5, 0, 0>}
      object {Decor_Lampe1 translate <10, 0, 0>}
      object {Decor_Lampe1 translate <13, 5, 0>}
      object {Decor_Lampe1 translate <10, 10, 0>}
      translate <15, -35, 0>
      }
   union{//A
      object {Decor_Lampe1 translate <0, 0, 0>}
      object {Decor_Lampe1 translate <0, 5, 0>}
      object {Decor_Lampe1 translate <0, 10, 0>}
      object {Decor_Lampe1 translate <0, 15, 0>}
      object {Decor_Lampe1 translate <5, 20, 0>}
      object {Decor_Lampe1 translate <10, 20, 0>}
      object {Decor_Lampe1 translate <15, 0, 0>}
      object {Decor_Lampe1 translate <15, 5, 0>}
      object {Decor_Lampe1 translate <15, 10, 0>}
      object {Decor_Lampe1 translate <15, 15, 0>}
      object {Decor_Lampe1 translate <5, 10, 0>}
      object {Decor_Lampe1 translate <10, 10, 0>}
      translate <40, -35, 0>
      }
   union{//T
      object {Decor_Lampe1 translate <10, 20, 0>}
      object {Decor_Lampe1 translate <10, 15, 0>}
      object {Decor_Lampe1 translate <10, 10, 0>}
      object {Decor_Lampe1 translate <10, 5, 0>}
      object {Decor_Lampe1 translate <10, 0, 0>}
      object {Decor_Lampe1 translate <0, 20, 0>}
      object {Decor_Lampe1 translate <5, 20, 0>}
      object {Decor_Lampe1 translate <15, 20, 0>}
      object {Decor_Lampe1 translate <20, 20, 0>}
      translate <65, -35, 0>
      }
   }

#declare Decor_Table1=object{
   box{< -40, 45, -30> <40, 50, 30>}
   texture{
      pigment {
         image_map {
            png "etoiles.png"
            map_type 0 //plan
            //once
            interpolate 2
            }
         }
      scale 20 rotate -90*x translate 5.5*z
      }
   }

#declare Decor_Table2=object{
   box{< -40.001, 45.001, -30.001> <40.001, 49.999, 30.001>}
   texture{
      pigment {
         image_map {
            png "etoiles.png"
            map_type 0 //plan
            //once
            interpolate 2
            }
         translate <0, .7, 0>
         }
      scale 20 rotate 0*x
      }
   }

#declare Decor_Table3=object{
   difference{
      torus {15, .25}
      box {<-.25, -1, 0> <.25, 1, 20>}
      }
   texture {T_Chrome_5E}
   }

#declare Decor_Table4=object{
   union{
      intersection{
         torus {5, .7 rotate -90*z}
         box {<-2, 0, 0>, <2, 6, 6>}
         translate <0, -5, -5>
         }
      cylinder {-100*y, -5*y, .7}
      }
   texture {T_Chrome_3A}
   }

#declare Decor_Table=union{
   object {Decor_Table1}
   object {Decor_Table2}
   object {Decor_Table3 rotate 45*y translate <-25, 50.25, 15>}
   object {Decor_Table3 rotate 35*y translate <-28, 50.75, 20>}
   object {Decor_Table4 rotate 45*z translate <-38, 45, 29>}
   }

#declare Decor_Sol=object{
   plane {y, 0}
   texture {
      brick texture {pigment {Black}} texture {Decor_TBois1}
      brick_size <200, 15, 10>
      mortar 1
      rotate 90*x rotate 90*y
      translate <47137, 68803, 57142>
      //turbulence .1
      }
   }

#declare Decor_Fond=object{
   union {
      difference {
         //plane {z, 0}
         box{<-1000, -1, -50> <1000, 400, 0>}
         #declare Decor_X=-1000
         #while (Decor_X < 1000)
            #declare Decor_DX=40
            cylinder {-y, 1000*y, 1 scale <Decor_DX*3/4/2, 1, 10> translate Decor_X*x}
            #declare Decor_X = Decor_X + Decor_DX
            #end
         }
      #declare Decor_Seed=seed(1)
      #declare Decor_X=-1000+40/2
      #while (Decor_X < 1000)
         #declare Decor_DX=40
         cylinder {-y, 400*y, 1 scale <Decor_DX*(.25+.5*rand(Decor_Seed))/2, 1, 10> translate Decor_X*x}
         #declare Decor_X = Decor_X + Decor_DX
         #end
      }
   texture {
      pigment{Red}
      }
   }

#declare Decor_Cintres=object {
   union {
      cylinder {<-1000, 405, 10> <1000, 405, 10>, 3}
      cylinder {<-1000, 405, -10> <1000, 405, -10>, 3}
      cylinder {<-1000, 425, 0> <1000, 425, 0>, 3}
      cylinder {<-350, 405, 10> <-350, 525, 10>, 2}
      cylinder {<-450, 405, 10> <-450, 525, 10>, 2}
      cylinder {<-550, 405, 10> <-550, 525, 10>, 2}
      }
   texture {T_Chrome_3E}
   }

#declare Decor_Proj1=object {
   sphere {0, 1 scale <3, 20, 20>}
   texture {
      pigment {
         wood color_map {
            [0.0 Magenta]
            [0.8 Magenta*0.8]
            [1.0 Magenta*0.2]
            }
         scale 5
         rotate 90*y
         }
      finish {ambient 1}
      }
   no_shadow
   }

#declare Decor_Proj2=object {
   union {
      cylinder {-30*x, 30*x, 25}
      difference {
         box {<-2, -35, -27> <2, 5, 27>}
         box {<-3, -30, -25> <3, 6, 25>}
         }
      intersection {
         cylinder {-30*x, 30*x, 26}
         union {
            box {<-30, -.3, -30> <28, .3, 30> translate 10*y}
            box {<-30, -.3, -30> <28, .3, 30> translate 7*y}
            box {<-30, -.3, -30> <28, .3, 30> translate 4*y}
            box {<-30, -.3, -30> <28, .3, 30> translate 1*y}
            box {<-30, -.3, -30> <28, .3, 30> translate -2*y}
            box {<-30, -.3, -30> <28, .3, 30> translate -5*y}
            box {<-30, -.3, -30> <28, .3, 30> translate -8*y}
            box {<-30, -.3, -30> <28, .3, 30> translate -11*y}
            }
         }
      box {<0, -.2, -25> <20, .2, 25> rotate -45*z translate <30, 25, 0>}
      box {<0, -.2, -25> <20, .2, 25> rotate -65*z translate <30, -25, 0>}
      box {<0, -25, -.2> <20, 25, .2> rotate -45*y translate <30, 0, 25>}
      box {<0, -25, -.2> <20, 25, .2> rotate  65*y translate <30, 0, -25>}
      }
   texture {
      pigment {Gray60}
      finish {Dull}
      }
   }

#declare Decor_Projbis=object {
   union {
      cylinder {-30*x, 30*x, 25}
      difference {
         box {<-2, -35, -27> <2, 5, 27>}
         box {<-3, -30, -25> <3, 6, 25>}
         }
      intersection {
         cylinder {-30*x, 30*x, 26}
         union {
            box {<-30, -.3, -30> <28, .3, 30> translate 10*y}
            box {<-30, -.3, -30> <28, .3, 30> translate 7*y}
            box {<-30, -.3, -30> <28, .3, 30> translate 4*y}
            box {<-30, -.3, -30> <28, .3, 30> translate 1*y}
            box {<-30, -.3, -30> <28, .3, 30> translate -2*y}
            box {<-30, -.3, -30> <28, .3, 30> translate -5*y}
            box {<-30, -.3, -30> <28, .3, 30> translate -8*y}
            box {<-30, -.3, -30> <28, .3, 30> translate -11*y}
            }
         }
      box {<0, -.2, -25> <20, .2, 25> rotate -45*z translate <30, 25, 0>}
      box {<0, -.2, -25> <20, .2, 25> rotate -65*z translate <30, -25, 0>}
      box {<0, -25, -.2> <20, 25, .2> rotate -45*y translate <30, 0, 25>}
      box {<0, -25, -.2> <20, 25, .2> rotate  65*y translate <30, 0, -25>}
      }
   texture {
      pigment {Gray10}
      finish {Dull}
      }
   }

#declare Decor_Proj=union{
   object {Decor_Proj1 translate 30*x}
   object {Decor_Proj2}
   }

#declare Decor=union{
   object {Decor_Fond translate -500*z}
   object {Decor_Cintres translate -500*z}
   object {Decor_Proj rotate -45*z rotate -105*y translate <-520, 450, -480>}
   object {Decor_Projbis rotate -45*z rotate -85*y translate <-300, 450, -480>}
   object {Decor_Billo scale 3 translate <-140, 300, -480>}
   object {Decor_Sol}
   object {Decor_Table translate 20*x}
   }

/******************************************************************************

        Rendu "autoporteur"

******************************************************************************/

#ifndef (MAIN_POV)
#declare Cam_Scale=150
camera {
   orthographic
   location -130 * z
   up        y*Cam_Scale
   right     -4/3 * x*Cam_Scale
   direction z // Vue globale
   rotate 180 * y
}
object{ light_source{<-200, 370, 295> color White*.8}}
object{ light_source{<200, 370, 295> color White*.6}}
//object {box {<-1000, -1000, -1> <1000, 0, 1>} pigment {Red} finish {ambient 1}}
//object {box {<-1000, -1000, -1000> <1000, 1000, -999>} pigment {checker color Red color White} finish {ambient 1}}
object {Decor scale 1 rotate 15*x rotate 30*y}
#end
