// Persistence of Vision Raytracer
// Lapin en cours de transformation

#ifndef (MAIN_POV)
#include "common.inc"
#end

/******************************************************************************
   A faire:
   Position des pattes
******************************************************************************/



/******************************************************************************

        textures

******************************************************************************/

#declare Lapin_FCameleon=finish{
   specular 0.5
   roughness 0.15
   diffuse 0.6 //default 0.6, test 0.4
   }

#declare Lapin_TCameleon=texture{
   pigment {
      bozo color_map{
         [0 color Red]
         [.166 color Yellow]
         [.333 color Green]
         [.500 color Cyan]
         [.667 color Blue]
         [.833 color Magenta]
         [1 color Red]
         }
      turbulence 1
      scale 5
      }
   normal {
      crackle
      turbulence .1
      bump_size 1//2
      scale .5//1
      }
   finish{
      Lapin_FCameleon
      }
   }

#declare Lapin_TCameleon2=texture{
   pigment {
      radial color_map{
         [0 color Red]
         [.166 color Yellow]
         [.333 color Green]
         [.500 color Cyan]
         [.667 color Blue]
         [.833 color Magenta]
         [1 color Red]
         }
      turbulence 10
      rotate 90*x
      }
   finish{
      Lapin_FCameleon
      }
   }

#declare Lapin_TCameleon3=texture{
   pigment {Black}
   normal {
      crackle
      bump_size 3
      scale 1
      }
   finish{
      Lapin_FCameleon
      }
   }

#declare Lapin_TCameleon4=texture{
   pigment {
      image_map {
         png "logo.png"
         map_type 0 //plan
         once
         interpolate 2
         }
      }
   normal {
      crackle
      bump_size 3
      scale 1
      }
   finish{
      Lapin_FCameleon diffuse 0.1 ambient 0.0
      }
   }

#declare Lapin_FPeluche=finish{
   ambient 0.5
   diffuse 0.2//0.3
   phong 0
   specular 0
   crand 0.25//0.25
   }

#declare Lapin_CYeux=color rgb <.35, .5, 1>*0.8

#declare Lapin_TYeux=texture{
   pigment {
      gradient x color_map{
         [0.00 color White]
         [0.70 color White]
         [0.70 color Lapin_CYeux]
         [0.90 color Lapin_CYeux]
         [0.90 color Black]
         [1.00 color Black]
         }
      rotate -15*z rotate 25*y
      }
   finish {Shiny}
   }

/******************************************************************************

        objets

******************************************************************************/

#declare Lapin_SPrism=prism {
  conic_sweep // or conic_sweep for tapering to a point
  linear_spline // linear_spline | quadratic_spline | cubic_spline
  0,        // height 1
  1,        // height 2
  5,          // number of points
  < 1.0, 1.0>, < 1.5, -1.0>, < -1.5, -1.0>, < -1.0,  1.0>, < 1.0,  1.0>
  rotate 90*y rotate 90*z
  translate 1*x
}

#declare Lapin_Cam1=object{
   union {
      intersection {
         object {Lapin_SPrism scale <10, 2, 2> rotate 15*z}
         box {<0, -20, -20> <3, 20, 20>}
         }
      intersection {
         object {Lapin_SPrism scale <10, -2, 2> rotate -15*z}
         box {<3, -20, -20> <7, 20, 20>}
         translate 1.4*y
         }
      intersection {
         object {Lapin_SPrism scale <100, .2, .5> rotate 75*z}
         box {<7, -200, -200> <11, 200, 200>}
         translate -26.5*y
         }
      }
   texture {
      gradient -x texture_map {
         [0.00 Lapin_TCameleon scale .6/20]
         [0.45 Lapin_TCameleon scale .6/20]
         [0.55 pigment {White} finish {Lapin_FPeluche} scale 1/20]
         [1.00 pigment {White} finish {Lapin_FPeluche} scale 1/20]
         }
      scale 20 translate 11*x
      }
   }

#declare Lapin_Cam2=object {
   union{
      cone {0, .8, -3*z, .6}
      sphere {0, 1}
      cone {0, 1, 3*x, .5}
      union {
         sphere {0, .6}
         cone {0, .5, 6*x, .3}
         union {
            cone {0, .3, x, 1.5}
            sphere {<1, 1.5, 0> 0.3 rotate 0*x}
            sphere {<1, 1.5, 0> 0.3 rotate 72*x}
            sphere {<1, 1.5, 0> 0.3 rotate 144*x}
            sphere {<1, 1.5, 0> 0.3 rotate -72*x}
            sphere {<1, 1.5, 0> 0.3 rotate -144*x}
            cone {0, .1 <1, 1.5, 0> 0.2 rotate 0*x}
            cone {0, .1 <1, 1.5, 0> 0.2 rotate 72*x}
            cone {0, .1 <1, 1.5, 0> 0.2 rotate 144*x}
            cone {0, .1 <1, 1.5, 0> 0.2 rotate -72*x}
            cone {0, .1 <1, 1.5, 0> 0.2 rotate -144*x}
            rotate -20*z
            translate 6*x
            }
         rotate -120*z translate 3*x
         }
      }
   texture {Lapin_TCameleon translate 210*z}
   }

#declare Lapin_Cam3=object {
   union{
      cone {0, .8, -3*z, .6}
      sphere {0, 1}
      cone {0, 1, 3*x, .5}
      union {
         sphere {0, .6}
         cone {0, .5, 6*x, .3}
         union {
            cone {0, .3, x, 1.5}
            sphere {<1, 1.5, 0> 0.3 rotate 0*x}
            sphere {<1, 1.5, 0> 0.3 rotate 72*x}
            sphere {<1, 1.5, 0> 0.3 rotate 144*x}
            sphere {<1, 1.5, 0> 0.3 rotate -72*x}
            sphere {<1, 1.5, 0> 0.3 rotate -144*x}
            cone {0, .1 <1, 1.5, 0> 0.2 rotate 0*x}
            cone {0, .1 <1, 1.5, 0> 0.2 rotate 72*x}
            cone {0, .1 <1, 1.5, 0> 0.2 rotate 144*x}
            cone {0, .1 <1, 1.5, 0> 0.2 rotate -72*x}
            cone {0, .1 <1, 1.5, 0> 0.2 rotate -144*x}
            rotate 60*z
            translate 6*x
            }
         rotate -120*z translate 3*x
         }
      }
   texture {Lapin_TCameleon translate 7157}
   }

#declare Lapin_Cam4=object {
   union {
      cylinder {-z, z, 1}
      difference {
         cylinder {-z, z, 5.5}
         cylinder {-z*1.1, z*1.1, 5}
         }
      cylinder {0, 5*x, .5 rotate 0*z}
      cylinder {0, 5*x, .5 rotate 60*z}
      cylinder {0, 5*x, .5 rotate 120*z}
      cylinder {0, 5*x, .5 rotate 180*z}
      cylinder {0, 5*x, .5 rotate 240*z}
      cylinder {0, 5*x, .5 rotate 300*z}
      }
   texture {Lapin_TCameleon2}
   }

#declare Lapin_Cam5=object {
   torus {6.5, 1}
   rotate 90*x
   texture {Lapin_TCameleon3}
   }

#declare Lapin_Cam6=object {
   cone {0, 0, 5*z, 1 scale <1, .2, 1>}
   texture {T_Brass_4B}
   }

#declare Lapin_Cam7=object {
   box {<0, 0, -.001>, <1, 1, .001>}
   texture {Lapin_TCameleon4}
   scale <3, 4, 1>
   }

#declare Lapin_Cam=union{
   object {Lapin_Cam1}
   object {Lapin_Cam2 scale <-.5, .5, .5> rotate -50*z translate <4, 0, 3.5>}
   object {Lapin_Cam3 scale <-.5, .5, -.5> rotate 30*z translate <4, 0, -3.5>}
   object {Lapin_Cam4 scale <.2, .3, .2>*1.5 rotate 30*z translate <4, -3, 0>}
   object {Lapin_Cam5 scale <.2, .3, .4>*1.4 rotate 30*z translate <4, -3, 0>}
   object {Lapin_Cam6 scale <1, 1, 2>*.5 translate <2, -2.2, 0>}
   object {Lapin_Cam6 scale <1, 1, -2>*.5 translate <5.3, -2.9, 0>}
   //object {Lapin_Cam7 rotate -15*z translate <10, 10.5, 0>}
   }

#declare Lapin_Sourire=.05

#declare Lapin_Lap1=object{
   union{
      intersection {
         sphere {0, 1 scale <4, 3, 3> translate -3*x}
         plane {x, 0}
         }
      union{
         sphere {0, 1.5 scale <1, 1, 1>}
         cone {0, 1.5, 3*x, 1.2}
         union {
            sphere {0, 1.2}
            cone {0, 1.2, 1*x, 1.2}
            sphere {1*x, 1.2}
            rotate -50*z translate 3*x
            }
         rotate -120*z translate <-3.5, -1, 2.0>
         }
      union{
         sphere {0, 1.5 scale <1, 1, 1>}
         cone {0, 1.5, 3*x, 1.2}
         union {
            sphere {0, 1.2}
            cone {0, 1.2, 1*x, 1.2}
            sphere {1*x, 1.2}
            rotate -50*z translate 3*x
            }
         rotate -120*z translate <-5, -1, -2.5>
         }
      difference {
         sphere {0, 1 scale <3, 2, 2>}
         sphere {0, 1 scale <3, 2, 2>*.99}
         union{
            box {<0, -Lapin_Sourire, -10> <1.5, Lapin_Sourire, 10> }
            union {
               cylinder {-10*z, 10*z, Lapin_Sourire}
               box {<0, -Lapin_Sourire, -10> <.5, Lapin_Sourire, 10> }
               union{
                  cylinder {-10*z, 10*z, Lapin_Sourire}
                  box {<0, -Lapin_Sourire, -10> <.5, Lapin_Sourire, 10> }
                  union{
                     cylinder {-10*z, 10*z, Lapin_Sourire}
                     box {<0, -Lapin_Sourire, -10> <.4, Lapin_Sourire, 10> }
                     rotate 120*z translate .5*x
                     }
                  rotate -120*z translate .5*x
                  }
               rotate 90*z translate 1.5*x
               }
            rotate -15*z
            scale <1, 1, 1> translate <-3, -1, 0>
            }
         translate <-6, 2, 0>
         }
      }
   texture {
      gradient -x texture_map {
         [0.00 Lapin_TCameleon scale .6/20]
         [0.45 Lapin_TCameleon scale .6/20]
         [0.55 pigment {White} finish {Lapin_FPeluche} scale 1/20]
         [1.00 pigment {White} finish {Lapin_FPeluche} scale 1/20]
         }
      scale 20 translate 10*x
      }
   }
#declare Lapin_Lap3=object{
   union{
      intersection{
         difference{
            sphere {0, 1 scale <1.5, 3, .6>}
            sphere {0, 1 scale <1.5, 3, .6> scale 0.8}
            }
         box {<-2, -4, -1> <2, 4, 0>}
         }
      intersection{
         torus {1, .5 rotate 90*x scale <1, 2, 1>}
         box {<-3, -4, 0><3, 4, 2>}
         }
      difference {
         sphere {0, 1 scale <1.5, 3, .6> scale 0.9}
         box {<-3, -4, 0><3, 4, 2>}
         sphere {0, 1 scale <.5, 1, .3>}
         }
      }
   pigment{White}
   finish {Lapin_FPeluche}
   }

#declare Lapin_Oeil=object {
   sphere {0, 1}
   texture {Lapin_TYeux}
   scale <1, .7, .5> rotate -30*z
   }

#declare Lapin_Nez=object {
   sphere {0, 1}
   pigment {Pink}
   scale <.3, .5, .5> rotate -30*z
   }

#declare Lapin_Lap5=object { //Intrieur de la tte pour dessin bouche.
   sphere {0, 1 scale <3, 2, 2>*.99}
   pigment {Red}
   translate <-6, 2, 0>
   }

#declare Lapin_Lap=union{
   object{Lapin_Lap1}
   object{Lapin_Oeil translate <-7.5, 2.5, 1.4>}
   object{Lapin_Oeil scale <1, 1, -1> translate <-7.5, 2.5, -1.4>}
   object{Lapin_Lap3 rotate -90*y translate <-6.5, 5.5, -1.6>}
   object{Lapin_Lap3 clipped_by {plane {y, 0 rotate 30*x}} rotate -80*y rotate 15*z translate <-6.5, 5.5, 1.6>}
   object{Lapin_Lap3 clipped_by {plane {-y, 0 rotate -30*x}} rotate 60*x rotate -80*y rotate 15*z translate <-6.5, 5.5, 1.6>}
   object{Lapin_Nez translate <-8.8, 2.5, 0>}
   object{Lapin_Lap5}
   }

#declare Lapin=union{
   object {Lapin_Cam}
   object {Lapin_Lap translate 1*x}
   //object {light_source {<5, 5, 0> color Green shadowless atmosphere on}}
   rotate 5*z
   translate 5.5*y
   }

/******************************************************************************

        Rendu "autoporteur"

******************************************************************************/

#ifndef (MAIN_POV)
camera {
   orthographic
   location -30 * z
   up        y*50
   right     -4/3 * x*50
   direction z // Vue globale
   rotate 180 * y
}
object{ light_source{<-200, 370, 295> color White*.8}}
object{ light_source{<200, 370, 295> color White*.6}}
//object {box {<-1000, -1000, -1> <1000, 0, 1>} pigment {Red} finish {ambient 1}}
//object {box {<-1000, -1000, -1000> <1000, 1000, -999>} pigment {checker color Red color White} finish {ambient 1}}
object {Lapin scale 2 rotate 0*x rotate -10*y}
#end
