#include "colors.inc"
#include "mestex.inc"
#include "fracmag.inc"

#declare v1=<8000,100,2500>

camera {location v1    
	ultra_wide_angle
	angle 160
	look_at <0,150,5000> }

//======================================================================
//      PLANTS
//======================================================================
object {GrpPlante1 scale 10 translate <7700,0,2700>}
object {GrpPlante1 scale 10 translate <7800,0,2700>}

//======================================================================
//      BUBBLES
//======================================================================
#declare Bubulle=
sphere {<0,0,0>,5 pigment {White transmit.9} 
finish {phong 0.3 phong_size 120 reflection 0 irid {.5 thickness 10 turbulence .01} }}
#declare r1=seed(0)
#declare boucle=1
#while (boucle < 40)
object {Bubulle scale rand(r1)*4 translate <7500+rand(r1)*50,70+rand(r1)*250,2500+rand(r1)*50>}
#declare boucle=boucle+1
#end
#declare boucle=1
#while (boucle < 40)
object {Bubulle scale rand(r1)*4 translate <5500+rand(r1)*50,70+rand(r1)*250,3500+rand(r1)*50>}
#declare boucle=boucle+1
#end
#declare boucle=1
#while (boucle < 80)
object {Bubulle scale 2+rand(r1)*4 translate <5500+rand(r1)*50,200+rand(r1)*250,3500+rand(r1)*50>}
#declare boucle=boucle+1
#end

//======================================================================
//      MISCELLANEOUS (MONSTER, PLANETS,...)
//======================================================================
object {Bebete scale 10 translate <7000,100,3500>}
object {Bebete rotate y*90  scale 10 translate <6500,150,3400>}
object {Bebete rotate y*180 scale 10 translate <6800,100,3300>}

sphere {<-1000,2700,6000>,400 pigment {DarkGreen transmit .4} finish {ior 1.5 refraction 1 phong .9}}
sphere {<-1000,2000,11500>,300 pigment {White}}
disc {<-1000,2000,11500>,<-.5,1,-.5>,850,450 pigment {White}}

//======================================================================
//      LITTLE TOWER IN THE BACK
//======================================================================
object {Base5 scale 10 pigment {White} translate <.100*10000,.462*1500,.206*10000>}

//======================================================================
//      HUT
//======================================================================
object {Cnit translate <7500,0,2500>}
object {Cnit translate <4500,0,1500>}
object {Cnit translate <5500,0,3500>}
object {Cnit translate <7000,0,6500>}

//======================================================================
//      FRACTAL OBJECT
//======================================================================
object {MachinFract scale 10 translate <7500,0,2500>}
object {MachinFract scale 10 translate <4500,0,1500>}
object {MachinFract scale 10 translate <5500,0,3500>}
object {MachinFract scale 10 translate <7000,0,6500>}

//======================================================================
//      ENVIRONNEMENT (FOG, MOUNTAIN, WATER,...)
//======================================================================
fog {color White filter .7 distance 10000}
plane {y,1 pigment {rgb <.9,.9,1>/2} 
finish {reflection .8} normal {ripples .4 scale 5}
}
height_field {gif "frac3.gif" scale <10000,1500,10000> pigment {White}}

//======================================================================
//      LIGHT SOURCES
//======================================================================
light_source {<10000,30000,10000> White*1}
light_source {<8000,100,2500> White*1}

