#declare ShrubT = texture {
   pigment {
      granite
      color_map {
         [0.4  color rgbt 1 ]
         [0.4  color rgb <.1,.4,0>]
         [0.5  color rgb <.1,.4,0>]
         [0.545 color rgbt 1 ]
         [0.545 color rgb <1,0,0>]
         [0.555 color rgb <1,0,0>]
         [0.555 color rgbt 1 ]
         [0.6  color rgb <.4,.5,.1>]
         [0.7  color rgb <.4,.5,.1>]
         [0.7  color rgbt 1]
      }
   }
   scale .5
}

#declare BlobBase = blob {
   threshold .75
   sphere { <0,0,0>, 1, 3 }
   sphere { <0,0.5,0>, 1, 8 }
   sphere { <0,1.5,0>, 1, 4 }
   sphere { <-.4,0.3,-.6>, 1, 3 }
   sphere { <0.6,0.9,0.1>, 1, 2 }
   sphere { <-.8,0.7,0.6>, 1, 2 }
   texture {ShrubT}
}

#declare Blob1 = blob {
   threshold .75
   sphere { <0.6,0.8,-.6>, 1, 3 }
   sphere { <-.9,0.4,.8>, 1, 2 }
   sphere { <0.8,1.0,0.6>, 1, 2 }
   scale <1,.5,1>
   texture {ShrubT}
}

#declare Blob2 = blob {
   threshold .75
   sphere { <1.2,0.3,-.6>, 1, 3 }
   sphere { <-.5,0.9,-.8>, 1, 2 }
   sphere { <-.8,0.5,-1.2>, 1, 2 }
   sphere { <0.2,0.0,-.1>, 1, 1 }
   scale <1,.5,1>
   texture {ShrubT}
}

#declare Blob3 = blob {
   threshold .75
   sphere { <1.2,0.6,-.6>, 1, 1 }
   sphere { <-.5,0.4,-.8>, 1, 2 }
   sphere { <-.8,1.0,-1.2>, 1, 2 }
   scale <.5,1,.5>
   texture {ShrubT}
}

#declare R = seed(25)

#declare Loop = 1

#while (Loop < NShrubs)
   #declare Bush = union {
      sphere { <0,1,0>, .6  scale <1,.75,1> texture {ShrubT} }
      object { BlobBase rotate y*(rand(R)*360) }

      #declare Num = rand(R)
      #if (Num > .66)
         object { Blob1 rotate y*(rand(R)*360) }
      #else
         #if (Num > .33)
            object { Blob2 rotate y*(rand(R)*360) }
         #else
            object { Blob3 rotate y*(rand(R)*360) }
         #end
      #end
   }

   #declare zpos = rand(R) * SDepth
   #declare xpos = rand(R) * (20 + (zpos*.75))

   object {
      Bush
      scale <1.75,0.75 - (rand(R)/5),1.75>
      rotate <0,rand(R)*360,0>
      translate <xpos-10,0,zpos>
   }

   #declare Loop = Loop + 1
#end
