#debug "<-FLAME.INC->\n"

// Piriform object obtained from POV-Ray v3.01 package
#declare Piriform =
 quartic 
  {< 4,   0,   0,   -4,  0,   0,   0,   0,   0,  0,
     0,   0,   0,    0,  0,   0,   0,   0,   0,  0,
     0,   0,   0,    0,  0,   1,   0,   0,   0,  0,
     0,   0,   1,    0,  0>
     sturm
  }

#declare FlameHalo =
  halo {
    linear
    planar_mapping
    emitting
    color_map {
    [0.00 color rgbt<2.100 1.6569 0.241   1>]
    [0.50 color rgbt<1.500 1.2763 0.117  -1>]
    [1.00 color rgbt<2.500 1.5888 0.245   1>]
             }
  turbulence .35
  samples 12
}

#declare Flame=
union {
object {
  Piriform
  pigment { rgbt 1 }
  halo { FlameHalo }
  no_shadow
  hollow
  rotate z*-90
  scale <.575,3,1>
  translate <0,1,0>
  }

// Wick
cylinder { <0,-5,0>, <0,-1.6,0>, .075
  pigment { rgb .2 }
  finish { roughness 1 crand .1 }
  }
}
 
//---------------------------------------------------------------------------
// The Spell -- Copyright (C) 1997, Gautam N. Lad.  All Rights Reserved.
//
// NOTE:  If YOU wish to use this image/file for ANY purpose, you MUST first
//        contact me at my e-mail address to notify me.
//        Visit my website to find software/graphics/links, etc. at:
//        http://www.interlog.com/~gautam
//---------------------------------------------------------------------------

