#debug "\n<-GNLSPELL.INC->"
// ************************************************************************
// Textures
// ************************************************************************
#declare TableTex =
texture {
  pigment { wood
	color_map
	{
  [0.100 color rgbf<0.527 0.314 0.086 0.000>]
  [0.200 color rgbf<0.495 0.287 0.083 0.000>]
  [0.300 color rgbf<0.462 0.261 0.079 0.000>]
  [0.400 color rgbf<0.429 0.235 0.075 0.000>]
  [0.500 color rgbf<0.396 0.208 0.072 0.000>]
  [0.600 color rgbf<0.364 0.182 0.068 0.000>]
  [0.700 color rgbf<0.331 0.155 0.065 0.000>]
  [0.800 color rgbf<0.298 0.129 0.061 0.000>]
  [0.900 color rgbf<0.265 0.103 0.057 0.000>]
  [1.000 color rgbf<0.233 0.076 0.054 0.000>]
	}
  turbulence .2
  scale<1.5,.15,.15>
  rotate x*90
  }
  finish { crand .2 roughness 1 diffuse .45 }
}

#declare ArmTex =
texture {
 pigment { color rgb<.475 .475 .4751> }
 normal { bumps .425 scale .375
  normal_map {
    [0.0 bumps    .38 scale .33 turbulence .33]
    [0.5 granite  .48 scale .28]
    [1.0 bozo     .18 scale .17]
             }
        }
 finish { roughness .7 crand .07 phong .88 phong_size 250 }
}

#declare CrystalBallTex =
texture {
  pigment { color rgbf<1,1,1,.92> }
  finish { phong 1 phong_size 350 reflection .55 ior 1.7
           roughness .1 refraction .9 ambient .35 diffuse .338
           caustics 1 }
}

#declare WallTex =
texture {
	pigment { bozo
	color_map
	{
	[0.125 color rgbf<0.211 0.211 0.232 0.000>]
	[0.250 color rgbf<0.222 0.222 0.244 0.000>]
	[0.375 color rgbf<0.233 0.233 0.257 0.000>]
	[0.500 color rgbf<0.244 0.244 0.269 0.000>]
	[0.625 color rgbf<0.256 0.256 0.281 0.000>]
	[0.750 color rgbf<0.267 0.267 0.293 0.000>]
	[0.875 color rgbf<0.278 0.278 0.306 0.000>]
	[1.000 color rgbf<0.289 0.289 0.318 0.000>]
	}
	turbulence 0.536
  scale 0.25
	}
  normal {
    bump_map { tga "WALLBUMP.TGA" bump_size 8.8 }
    scale 7.75 turbulence .211
         }
  finish { phong .185 ambient .18 diffuse .58 }
}

// ************************************************************************
// Crystal Ball
// ************************************************************************
#declare Arm=
blob {
   threshold 0.6
 component 1, 0.319176, <1.18987, 0.278481, 0>
 component 1, 0.34646, <1.30675, -0.126582, 0>
 component 1, 0.439383, <1.15485, -0.49789, 0>
 component 1, 0.639656, <0.7, -1, 0>
 component 1, 0.405325, <0.834177, -0.582278, 0>

  texture { ArmTex }
}

#declare CrystalBall=
union {
sphere { 0, 1.11  texture { CrystalBallTex }   }

#declare C=0
#while (C < 6)
  object { Arm rotate y*(72*C) }
  #declare C=C+1
#end
}

// ************************************************************************
// Table
// ************************************************************************
#declare C=0
#declare S=seed(34)
#declare Table =
union {
  #while(C < 10)
    box { <-25,0,-1.5>,<25,.5,1.5>
          texture { TableTex
                    #declare T=rand(S)/2.5
                    pigment { turbulence T}
                    translate x*rand(S)*10
                  }
          translate<0,0,-6+(3.11*C)>
        }
  #declare C=C+1
#end
}

#declare ShelfBoard =
box { <-15,5.8,15>,<15,6.75,21>
  texture { TableTex pigment { turbulence .017 translate x*(.36) } }
}

#declare ShelfSupport=
prism {
linear_spline
linear_sweep
0,
1.75,
4,
<0,0>,<5,0>,<5,5>,<0,0>
 texture { TableTex }
 rotate <90,-90,0>
}

#declare Shelf=
union {
object { ShelfBoard }
object { ShelfSupport translate <-10,6.7,16> }
object { ShelfSupport translate < 10,6.7,16> }
translate <0,1.5,0>
}

//---------------------------------------------------------------------------
// The Spell -- Copyright (C) 1997, Gautam N. Lad.  All Rights Reserved.
//
// NOTE:  If YOU wish to use this image/file for ANY purpose, you MUST first
//        contact me at my e-mail address to notify me.
//        Visit my website to find software/graphics/links, etc. at:
//        http://www.interlog.com/~gautam
//---------------------------------------------------------------------------

