#debug "\n<-WAND.INC->\n"
#declare RedGlass=
texture {
  pigment { color rgbf<1,.3,.3,.98> }
  finish { phong 1 phong_size 350 reflection .6 ior 1.1
          roughness .03 refraction .88 ambient .475 diffuse .538
          caustics 1 }
}

#declare WandTex = texture {
  pigment { rgb .45 }           
  normal { bumps .25 scale .1 }
  finish { roughness 1 crand .11 phong 1 phong_size 280 }
}

#declare C=0
#declare WandClaw=
union {
#while(C<150)
  sphere { <0,-1.25,0>, .4-(C/400) rotate z*C }
  #declare C=C+1
#end
texture { WandTex }
}

#declare Claws=
union {
#declare C=0
#while(C<3)
  object { WandClaw rotate y*(120*C) }
  #declare C=C+1
#end
sphere { 0, 1.225 texture { RedGlass } }
}

#declare C=0
#declare S=seed(8124)
#declare Handle=
blob {
  threshold .6
  #declare R=0
  #declare NR=0
  #declare C=0
  #while(C < 30)
    #declare R = rand(S)
    #declare NR = (NR + R)
      sphere { <R/5,3-(NR/2),0>, .75-(R/6), 1.25 }
      #declare C=C+1
  #end
texture { WandTex }
}

#declare Wand=
union {
  object { Claws translate y*3 }
  object { Handle }
}

//---------------------------------------------------------------------------
// The Spell -- Copyright (C) 1997, Gautam N. Lad.  All Rights Reserved.
//
// NOTE:  If YOU wish to use this image/file for ANY purpose, you MUST first
//        contact me at my e-mail address to notify me.
//        Visit my website to find software/graphics/links, etc. at:
//        http://www.interlog.com/~gautam
//---------------------------------------------------------------------------

