// Fichero de POVRAY 3 por:
// POVRAY 3 file by:
//  Guillermo S. Romero

// E-mail:     famrom@ran.es
// Snail-mail: P.O.Box 35099-28080 Madrid (Espaa)

// Este fichero contiene:
//  Texturas de ladrillos.
//--
// This file contains:
//  Brick textures.

// ** IMPORTANT ** Wrong use can cause errors, I decline ALL responsability.
// INCLUDE FLAGS
//  Swap_Colors : Use preset combination of T_Mortar & T_Brick
//  T_Brick     : Texture for brick zones
//  T_Mortar    : Texture for mortar zones
// For multiple "include"s of this file use multiple flags, think about this
//  condition as arguments required by functions.

#ifndef (Swap_Colors)
    #declare Swap_Colors = 0
    #warning "'Swap_Colors' not set, please declare it, meanwhile using set #0\n"
#end

#switch (Swap_Colors)
#case (-1)
    // Use externally defined textures, pigments, normals...
#break
#case (0) // Default, constrasting colors
    #declare T_Brick =
        texture { pigment { White } }
    #declare T_Mortar =
        texture { pigment { Black } }
#break
#case (1) // Plain grays, dull
    #declare T_Brick =
        texture {
            pigment { Gray60 }
            normal { bumps .5 scale .25 }
            finish { phong .25 phong_size 10 }
        }
    #declare T_Mortar =
        texture {
            pigment { Gray40 }
            normal { granite .5 scale .1 }
        }
#break
#case (2)
    #declare T_Brick =
        texture {
            pigment {
                bozo
                color_map {
                    [ .2 MediumGoldenrod ]
                    [ .8 Goldenrod ]
                }
            }
            normal { wrinkles .5 scale .25 }
            finish { phong .25 phong_size 20 }
        }
    #declare T_Mortar =
        texture {
            pigment { Gray60 }
            normal { agate .5 scale .25 }
        }
#break
#case (3)
    #declare T_Brick =
        texture {
            T_Stone8
            normal { granite .25 }
            scale .5
        }
    #declare T_Mortar =
        texture {
            pigment { Gray80 }
            normal { bumps .25 scale .1 }
        }
#break
#case (4)
    #declare T_Brick =
        texture { T_Stone44 }
    #declare T_Mortar =
        texture {
            pigment { Gray20 }
            normal { agate .5 scale .25 }
        }
#break
#case (5)
    #declare T_Brick =
        texture { T_Stone44 }
    #declare T_Mortar =
        texture {
            pigment { Gray05 }
            normal { agate .5 scale .25 }
        }
#break
#case (6)
    #declare T_Brick =
        texture {
            pigment {
                bozo
                color_map {
                    [ .2 Gray40 ]
                    [ .8 Gray60 ]
                }
            }
            normal { wrinkles 1 scale .25 }
            finish { phong .25 phong_size 20 }
        }
    #declare T_Mortar =
        texture { // Short grass or moss
            pigment {
                bozo
                turbulence 1
                color_map {
                    [ 0  rgb <.1, .4, .1> ]
                    [ .5 ForestGreen ]
                    [ 1  rgb <.03, .7, .08> ]
                }
                scale .5
            }
            normal {
                crackle .5
                scale .01
            }
        }
#break
/*
#case ()
    #declare T_Brick =
        texture {}
    #declare T_Mortar =
        texture {}
#break
*/
#end

/****************************************************************************/
// --- Patterns:
//      1: random brick
//      2: crackle
//      3: perfect brick
//      4: crackle (forced normal)
//      5: as 2 but border (brick / mortar) is diffuse
//      6: as 4 but border (brick / mortar) is diffuse


#declare T_GRBrick1 =
    texture {
        brick texture { T_Mortar }, texture { T_Brick }
        brick_size <1, .5, 1> mortar .1
        turbulence .2
        octaves 2 lambda 1 omega .25
    }

#declare T_GRBrick2 =
    texture {
        crackle
        texture_map {
            [ .1 T_Mortar ]
            [ .1 T_Brick ]
        }
        turbulence .3
        octaves 2 lambda 1 omega .5
        scale <.75, .375, .75>
    }

#declare T_GRBrick3 =
    texture {
        brick texture { T_Mortar }, texture { T_Brick }
        brick_size <1, .5, 1> mortar .1
    }

#declare T_GRBrick4 =
    texture {
        crackle
        texture_map {
            [ .1 T_Mortar ]
            [ .1 T_Brick
                 normal { crackle 1 turbulence .25 }
            ]
        }
        scale <.8, .4, .8>
    }

#declare T_GRBrick5 =
    texture {
        crackle
        texture_map {
            [ .05 T_Mortar ]
            [ .15 T_Brick ]
        }
        turbulence .3
        octaves 2 lambda 1 omega .5
        scale <.75, .375, .75>
    }

#declare T_GRBrick6 =
    texture {
        crackle
        texture_map {
            [ .05 T_Mortar ]
            [ .15 T_Brick
                  normal { crackle 1 turbulence .25 }
            ]
        }
        scale <.8, .4, .8>
    }

/****************************************************************************/
// --- Fixed textures start here

#declare SwampMud1 = rgb <.55, .12, .04>
#declare SwampMud2 = rgb <.52, .09, .01>
#declare DryMud1 = rgb <.9, .49, .34>
#declare DryMud2 = rgb <.8, .39, .24>

/****************************************************************************/

#declare P_GRSwampMud =
    pigment {
        bozo
        turbulence .5
        color_map {
            [ .1 SwampMud1 ]
            [ .9 SwampMud2 ]
        }
        scale .25
    }

#declare P_GRDryMud =
    pigment {
        bozo
        turbulence .5
        color_map {
            [ .1 DryMud1 ]
            [ .9 DryMud2 ]
        }
        scale .25
    }

/****************************************************************************/

#declare T_GRSwampAdobe =
    texture {
        pigment {
            brick
            pigment { P_GRSwampMud scale -1 }, pigment { P_GRSwampMud }
            brick_size <.3, .1, .15> mortar .02
            turbulence .1
            octaves 2 lambda 1 omega .25
        }
        normal {
            brick .25
            brick_size <.3, .1, .15> mortar .02
            turbulence .1
            octaves 2 lambda 1 omega .25
        }
        finish {
            specular .5
            roughness .02
        }
    }

#declare T_GRDryAdobe =
    texture {
        pigment {
            brick
            pigment { P_GRDryMud scale -1 }, pigment { P_GRDryMud }
            brick_size <.3, .1, .15> mortar .02
            turbulence .1
            octaves 2 lambda 1 omega .25
        }
        normal {
            brick .25
            brick_size <.3, .1, .15> mortar .02
            turbulence .1
            octaves 2 lambda 1 omega .25
        }
        finish {
            specular .125
            roughness .1
        }
    }


// (C) Guillermo Sanz Romero
// Todos los derechos reservados.
// Si deseas utilizar la totalidad o parte de este fichero puedes hacerlo
//  mientras no sea con fines lucrativos.
// En caso de usarlo para publicidad, recopilaciones de software, inclusin
//  en revistas o alguna otra actividad que suponga una transaccin
//  remunerada (con cualquier tipo de bien, por lo que los trueques y los
//  premios de los concursos tambin quedan incluidos), debes ponerte en
//  contacto utilizando las direcciones de la cabezera para poder acordar las
//  condiciones que te permitan hacer dicho uso de los datos contenidos en
//  este fichero o los generados a partir de l, tanto descripciones de
//  imagenes como las imagenes en si, en cualquier formato y/o medio de
//  almacenamiento.
//--
// All rights reserved.
// If you want to use this file in is enterity or only parts of it you can do
//  it while it is a non-profitable purpose.
// In case of using it for advertisment, software recopilations, bunddling it
//  with magazines or another profitable transaction (any sort of profit, so
//  exchange and prizes won in contests are included), you must get in touch
//  with me through the addresses given above to reach an agreement about the
//  conditions to use the data here contained (this file) or build from it,
//  both new image descriptions and images, whatever the format and/or the
//  storage way.

// No dudes en escribirme si tienes alguna pregunta, tanto sobre la clusula
//  arriba expuesta como sobre el fichero de datos que describe las imgenes
//  y las imgenes en si.
// P.D.: los precios son razonables y el dinero esta destinado bsicamente
//  a mejorar mi ordenador y poder seguir creando ms imagenes.
//--
// Do not doubt to write me if you has any question, about the clausule 
//  written above or the descriptions and the images.
// P.S.: prices are reasonable and money is basically to improve my computer
//  so I can keep making more pictures.

// NOTA IMPORTANTE
//  Este es un extracto de la licencia completa (LICENSE.GSR), lee dicho
//  fichero para conocer todas las condiciones y clusulas.
//--
// IMPORTANT NOTE
//  This is an extract of the complete license (LICENSE.GSR), read that file
//  to know all the conditions and clausules.
