//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 1 lights, 5 textures and 19 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5b.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 07/26/1997    (26.07.1997)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray exports for POV-Ray.
//





global_settings {
  adc_bailout 0.003922
  ambient_light <0.153,0.153,0.153>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camera01
  location  <-44.805, -24.707, 14.437>
  direction <0.0,     0.0,  7.2582>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <0.000, 0.000, 0.750>
}

//    Other cameras are commented out.
/*
camera {  //  Camera SpotCam001
  location  <-9.277, -16.048, 22.811> // Attached to Spot1
  direction <0.0,     0.0,  1.7441>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <-7.687, -13.304, 18.945> // Following Spot1
}

*/

// *******  L I G H T S *******
light_source {   // Spotlight Spot1
  <-9.277, -16.048, 22.811>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <-7.687, -13.304, 18.945>
    falloff   16.0  // outer radius (in deg)
      radius    13.0  // inner radius
}


// ********  TEXTURES  *******
//

#include "hattrick.inc"



// ********  REFERENCED OBJECTS  *******

#declare CardWheel1 = object {
  superellipsoid { // CardWheel1
    <1.0, 6.5>
    rotate -90.0*y
    translate  <2.0, 2.5, 0.0>
  }
}
#declare CornerNull = union {
  object { // CardWheel4->CardWheel1
    CardWheel1
    translate  -5.0*y
  }
  object { // CardWheel3->CardWheel1
    CardWheel1
    translate  <-4.0, -5.0, 0.0>
  }
  object { // CardWheel2->CardWheel1
    CardWheel1
    translate  -4.0*x
  }
  object { CardWheel1 }
  texture {
    Cardtex
  }
}
#declare PlayingCard = difference {
  box { // CardBody
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cardtex
      scale 2.0
  translate <-1.000000, -1.000000, 0.000000>
    }
    scale <2.0, 2.510843, 0.01>
  }
  object { CornerNull }
  scale 0.5
  rotate <42.885895, -27.753668, -63.372223>
  translate  <-3.943493, 0.718327, 1.712667>
}
#declare PlayingCard1 = object {
  object { // PlayingCard1->PlayingCard
    PlayingCard
    rotate <0.0, 49.496933, -127.946976>
    translate  <-0.418493, -2.439587, -4.087844>
  }
}




// ********  OBJECTS  *******



#declare HatComp6 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0050 u_steps 3 v_steps 3,
      <-5.903546, -6.000000, 1.414657>, <-4.903546, -6.000000, 0.739480>, <-4.000000, -6.000000, -0.027469>, <-3.000000, -6.000000, -0.769290>, 
      <-5.903546, -5.000000, 1.414657>, <-4.903546, -5.000000, 0.739480>, <-4.000000, -5.000000, -0.027469>, <-3.000000, -5.000000, -0.431702>, 
      <-5.903546, -4.000000, 1.414657>, <-4.903546, -4.000000, 0.739480>, <-4.000000, -4.000000, -0.027469>, <-3.000000, -4.000000, -0.201648>, 
      <-5.903546, -3.000000, 1.414657>, <-4.903546, -3.000000, 0.739480>, <-4.000000, -3.000000, -0.027469>, <-3.000000, -3.000000, -0.107691>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0050 u_steps 3 v_steps 3,
      <-5.903546, -3.000000, 1.414657>, <-4.903546, -3.000000, 0.739480>, <-4.000000, -3.000000, -0.027469>, <-3.000000, -3.000000, -0.107691>, 
      <-5.903546, -2.000000, 1.414657>, <-4.903546, -2.000000, 0.739480>, <-4.000000, -2.000000, -0.027469>, <-3.000000, -2.000000, -0.013735>, 
      <-5.903546, -1.000000, 1.414657>, <-4.903546, -1.000000, 0.739480>, <-4.000000, -1.000000, -0.027469>, <-3.000000, -1.000000, -0.013735>, 
      <-5.903546, 0.000000, 1.414657>, <-4.903546, 0.000000, 0.739480>, <-4.000000, 0.000000, -0.027469>, <-3.000000, 0.000000, -0.013735>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0050 u_steps 3 v_steps 3,
      <-5.903546, 0.000000, 1.414657>, <-4.903546, 0.000000, 0.739480>, <-4.000000, 0.000000, -0.027469>, <-3.000000, 0.000000, -0.013735>, 
      <-5.903546, 1.000000, 1.414657>, <-4.903546, 1.000000, 0.739480>, <-4.000000, 1.000000, -0.027469>, <-3.000000, 1.000000, -0.013735>, 
      <-5.903546, 2.000000, 1.414657>, <-4.903546, 2.000000, 0.739480>, <-4.000000, 2.000000, -0.027469>, <-3.000000, 2.000000, -0.013735>, 
      <-5.903546, 3.000000, 1.414657>, <-4.903546, 3.000000, 0.739480>, <-4.000000, 3.000000, -0.027469>, <-3.000000, 3.000000, -0.099029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0050 u_steps 3 v_steps 3,
      <-5.903546, 3.000000, 1.414657>, <-4.903546, 3.000000, 0.739480>, <-4.000000, 3.000000, -0.027469>, <-3.000000, 3.000000, -0.099029>, 
      <-5.903546, 4.000000, 1.414657>, <-4.903546, 4.000000, 0.739480>, <-4.000000, 4.000000, -0.027469>, <-3.000000, 4.000000, -0.201648>, 
      <-5.903546, 5.000000, 1.414657>, <-4.903546, 5.000000, 0.739480>, <-4.000000, 5.000000, -0.027469>, <-3.000000, 5.000000, -0.431702>, 
      <-5.903546, 6.000000, 1.414657>, <-4.903546, 6.000000, 0.739480>, <-4.000000, 6.000000, -0.027469>, <-3.000000, 6.000000, -0.769290>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0050 u_steps 3 v_steps 3,
      <-3.000000, -6.000000, -0.769290>, <-2.000000, -6.000000, -1.511111>, <-1.000000, -6.000000, -1.511111>, <0.000000, -6.000000, -1.511111>, 
      <-3.000000, -5.000000, -0.431702>, <-2.000000, -5.000000, -0.835934>, <-1.000000, -5.000000, -0.835934>, <0.000000, -5.000000, -0.835934>, 
      <-3.000000, -4.000000, -0.201648>, <-2.000000, -4.000000, -0.375827>, <-1.000000, -4.000000, -0.375827>, <0.000000, -4.000000, -0.375827>, 
      <-3.000000, -3.000000, -0.107691>, <-2.000000, -3.000000, -0.187913>, <-1.000000, -3.000000, -0.187913>, <0.000000, -3.000000, -0.187913>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0050 u_steps 3 v_steps 3,
      <-3.000000, -3.000000, -0.107691>, <-2.000000, -3.000000, -0.187913>, <-1.000000, -3.000000, -0.187913>, <0.000000, -3.000000, -0.187913>, 
      <-3.000000, -2.000000, -0.013735>, <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, 
      <-3.000000, -1.000000, -0.013735>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.000000, 0.000000, -0.013735>, <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0050 u_steps 3 v_steps 3,
      <-3.000000, 0.000000, -0.013735>, <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, 
      <-3.000000, 1.000000, -0.013735>, <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, 
      <-3.000000, 2.000000, -0.013735>, <-2.000000, 2.000000, 0.000000>, <-1.000000, 2.000000, 0.000000>, <0.000000, 2.000000, 0.000000>, 
      <-3.000000, 3.000000, -0.099029>, <-2.000000, 3.000000, -0.187913>, <-1.000000, 3.000000, -0.187913>, <0.000000, 3.000000, -0.170589>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0050 u_steps 3 v_steps 3,
      <-3.000000, 3.000000, -0.099029>, <-2.000000, 3.000000, -0.187913>, <-1.000000, 3.000000, -0.187913>, <0.000000, 3.000000, -0.170589>, 
      <-3.000000, 4.000000, -0.201648>, <-2.000000, 4.000000, -0.375827>, <-1.000000, 4.000000, -0.375827>, <0.000000, 4.000000, -0.375827>, 
      <-3.000000, 5.000000, -0.431702>, <-2.000000, 5.000000, -0.835934>, <-1.000000, 5.000000, -0.835934>, <0.000000, 5.000000, -0.835934>, 
      <-3.000000, 6.000000, -0.769290>, <-2.000000, 6.000000, -1.511111>, <-1.000000, 6.000000, -1.511111>, <0.000000, 6.000000, -1.511111>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0050 u_steps 3 v_steps 3,
      <0.000000, -6.000000, -1.511111>, <1.000000, -6.000000, -1.511111>, <2.000000, -6.000000, -1.511111>, <3.000000, -6.000000, -0.769290>, 
      <0.000000, -5.000000, -0.835934>, <1.000000, -5.000000, -0.835934>, <2.000000, -5.000000, -0.835934>, <3.000000, -5.000000, -0.431702>, 
      <0.000000, -4.000000, -0.375827>, <1.000000, -4.000000, -0.375827>, <2.000000, -4.000000, -0.375827>, <3.000000, -4.000000, -0.201648>, 
      <0.000000, -3.000000, -0.187913>, <1.000000, -3.000000, -0.187913>, <2.000000, -3.000000, -0.187913>, <3.000000, -3.000000, -0.107691>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0050 u_steps 3 v_steps 3,
      <0.000000, -3.000000, -0.187913>, <1.000000, -3.000000, -0.187913>, <2.000000, -3.000000, -0.187913>, <3.000000, -3.000000, -0.107691>, 
      <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, <2.000000, -2.000000, 0.000000>, <3.000000, -2.000000, -0.013735>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.000000, -1.000000, -0.013735>, 
      <0.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <2.000000, 0.000000, 0.000000>, <3.000000, 0.000000, -0.013735>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0050 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <2.000000, 0.000000, 0.000000>, <3.000000, 0.000000, -0.013735>, 
      <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>, <2.000000, 1.000000, 0.000000>, <3.000000, 1.000000, -0.013735>, 
      <0.000000, 2.000000, 0.000000>, <1.000000, 2.000000, 0.000000>, <2.000000, 2.000000, 0.000000>, <3.000000, 2.000000, -0.013735>, 
      <0.000000, 3.000000, -0.170589>, <1.000000, 3.000000, -0.187913>, <2.000000, 3.000000, -0.187913>, <3.000000, 3.000000, -0.099029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0050 u_steps 3 v_steps 3,
      <0.000000, 3.000000, -0.170589>, <1.000000, 3.000000, -0.187913>, <2.000000, 3.000000, -0.187913>, <3.000000, 3.000000, -0.099029>, 
      <0.000000, 4.000000, -0.375827>, <1.000000, 4.000000, -0.375827>, <2.000000, 4.000000, -0.375827>, <3.000000, 4.000000, -0.201648>, 
      <0.000000, 5.000000, -0.835934>, <1.000000, 5.000000, -0.835934>, <2.000000, 5.000000, -0.835934>, <3.000000, 5.000000, -0.431702>, 
      <0.000000, 6.000000, -1.511111>, <1.000000, 6.000000, -1.511111>, <2.000000, 6.000000, -1.511111>, <3.000000, 6.000000, -0.769290>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0050 u_steps 3 v_steps 3,
      <3.000000, -6.000000, -0.769290>, <4.000000, -6.000000, -0.027469>, <5.096454, -6.000000, 0.739480>, <6.096454, -6.000000, 1.414657>, 
      <3.000000, -5.000000, -0.431702>, <4.000000, -5.000000, -0.027469>, <5.096454, -5.000000, 0.739480>, <6.096454, -5.000000, 1.414657>, 
      <3.000000, -4.000000, -0.201648>, <4.000000, -4.000000, -0.027469>, <5.096454, -4.000000, 0.739480>, <6.096454, -4.000000, 1.414657>, 
      <3.000000, -3.000000, -0.107691>, <4.000000, -3.000000, -0.027469>, <5.096454, -3.000000, 0.739480>, <6.096454, -3.000000, 1.414657>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0050 u_steps 3 v_steps 3,
      <3.000000, -3.000000, -0.107691>, <4.000000, -3.000000, -0.027469>, <5.096454, -3.000000, 0.739480>, <6.096454, -3.000000, 1.414657>, 
      <3.000000, -2.000000, -0.013735>, <4.000000, -2.000000, -0.027469>, <5.096454, -2.000000, 0.739480>, <6.096454, -2.000000, 1.414657>, 
      <3.000000, -1.000000, -0.013735>, <4.000000, -1.000000, -0.027469>, <5.096454, -1.000000, 0.739480>, <6.096454, -1.000000, 1.414657>, 
      <3.000000, 0.000000, -0.013735>, <4.000000, 0.000000, -0.027469>, <5.096454, 0.000000, 0.739480>, <6.096454, 0.000000, 1.414657>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0050 u_steps 3 v_steps 3,
      <3.000000, 0.000000, -0.013735>, <4.000000, 0.000000, -0.027469>, <5.096454, 0.000000, 0.739480>, <6.096454, 0.000000, 1.414657>, 
      <3.000000, 1.000000, -0.013735>, <4.000000, 1.000000, -0.027469>, <5.096454, 1.000000, 0.739480>, <6.096454, 1.000000, 1.414657>, 
      <3.000000, 2.000000, -0.013735>, <4.000000, 2.000000, -0.027469>, <5.096454, 2.000000, 0.739480>, <6.096454, 2.000000, 1.414657>, 
      <3.000000, 3.000000, -0.099029>, <4.000000, 3.000000, -0.027469>, <5.096454, 3.000000, 0.739480>, <6.096454, 3.000000, 1.414657>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0050 u_steps 3 v_steps 3,
      <3.000000, 3.000000, -0.099029>, <4.000000, 3.000000, -0.027469>, <5.096454, 3.000000, 0.739480>, <6.096454, 3.000000, 1.414657>, 
      <3.000000, 4.000000, -0.201648>, <4.000000, 4.000000, -0.027469>, <5.096454, 4.000000, 0.739480>, <6.096454, 4.000000, 1.414657>, 
      <3.000000, 5.000000, -0.431702>, <4.000000, 5.000000, -0.027469>, <5.096454, 5.000000, 0.739480>, <6.096454, 5.000000, 1.414657>, 
      <3.000000, 6.000000, -0.769290>, <4.000000, 6.000000, -0.027469>, <5.096454, 6.000000, 0.739480>, <6.096454, 6.000000, 1.414657>
    }
  }
}
#declare HatComp4 = difference {
  box { // HatComp1
    <-1, -1, -1>, <1, 1, 1>
    scale <6.466022, 6.466022, 2.5>
  }
  cylinder { // HatComp2
    <0,0,1>, <0,0,0>, 1 
    scale <5.5, 4.5, 5.0>
    translate  -2.5*z
  }
}
#declare HatComp5 = union {
  object { HatComp4 }
  cylinder { // HatComp3
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 5.0>
    translate  -2.5*z
  }
}
#declare HatBrim = difference {
  object { HatComp6 }
  object { HatComp5 }
}
#declare HatInner = difference {
  cylinder { // HatCyl
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 4.0>
    rotate <-180.0, 0.0, -180.0>
    translate  <0.0, 0.0, 5.2>
  }
  sphere { // HatSph
    <0,0,0>,1
    scale 3.0
  }
  rotate <-180.0, 0.0, -180.0>
  translate  <0.0, 0.0, 1.2>
}
#declare MagicHat = union {
  object { HatBrim }
  object { HatInner }
  texture {
    TopHatTex
  }
  rotate <180.0, 0.0, 180.0>
  translate  1.2*z
}
#declare MagicWand = union {
  cylinder { // WandComp2
    <0,0,1>, <0,0,0>, 1 
    texture {
      BlackWandTex
    }
    scale <0.076923, 0.076923, 5.0>
    rotate 90.0*x
  }
  cylinder { // WandComp1
    <0,0,1>, <0,0,0>, 1 
    texture {
      WhiteWandTex
    }
    scale <0.076923, 0.076923, 1.0>
    rotate 90.0*x
    translate  1.0*y
  }
  scale 2.0
  rotate <6.191636, 4.584212, -111.324547>
  translate  <-4.149096, -1.334231, 1.272427>
}
union { // MainCSG
  plane { // Plane001
    z,0
    texture {
      PlaneWoodTex
    }
  }
  object { PlayingCard }
  object { MagicHat }
  object { MagicWand }
  object { PlayingCard1 }
  object { // PlayingCard2->PlayingCard1
    PlayingCard1
    rotate <0.78861, -0.614913, -12.004231>
    translate  <-0.55679, -0.186443, 0.057444>
  }
  object { // PlayingCard3->PlayingCard1
    PlayingCard1
    rotate <1.577403, -1.229709, -24.01693>
    translate  <-1.170986, -0.448848, 0.113631>
  }
  object { // PlayingCard4->PlayingCard1
    PlayingCard1
    rotate <2.366558, -1.844272, -36.038097>
    translate  <-1.854444, -0.771891, 0.168551>
  }
}


