
// Persistence of Vision Ray Tracer Scene Description File
// File: WizardPatch.inc
// Vers: 3
// Desc: A model of a wizard's robe with arms outstretched, using bicubic patches
// Date: July 1997
// Auth: Ian Bosley

#ifdef(View_POV_Include_Stack)
#debug "Including WizardPatch.inc\n"
#end

/*
// File generated by sPatch, Copyright 1996-1997 by Mike Clifton
background { color rgb <0, 0, 0> }

camera {
	location <1.51, 2.96, -3.10>
	look_at <-0.04, -0.15, 0.01>
}

light_source { < 0, 100, -200 > color rgb <1, 1, 1> }
light_source { < 200, 10, 0 > color rgb <0.4, 0.5, 0.4> }
light_source { < -50, 10, 200 > color rgb <0.4, 0.25, 0.25> }
*/

#declare _WizardsRobe =
texture {
  pigment {color DarkBrown}
  normal { granite 0.1 scale 0.1 }
  finish { ambient 0.4 diffuse 0.9 }
}

#declare WizardRobe = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0625, 0.0102, 0.0557> <-0.0513, 0.0104, 0.0606> <-0.0363, 0.0107, 0.0670> <-0.0251, 0.0109, 0.0719>
		<-0.0424, 0.0106, 0.0838> <-0.0312, 0.0108, 0.0886> <-0.0603, 0.0107, 0.0580> <-0.0491, 0.0109, 0.0628>
		<-0.0877, 0.0162, 0.1543> <-0.0727, 0.0163, 0.1607> <-0.0538, 0.0080, 0.1433> <-0.0376, 0.0080, 0.1451>
		<-0.0913, -0.0168, 0.1636> <-0.0764, -0.0167, 0.1701> <-0.0546, -0.0168, 0.1499> <-0.0384, -0.0168, 0.1516>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0625, 0.0102, 0.0557> <-0.0676, 0.0105, 0.0504> <-0.0745, 0.0109, 0.0433> <-0.0797, 0.0112, 0.0380>
		<-0.0783, 0.0099, 0.0335> <-0.0835, 0.0102, 0.0282> <-0.0978, 0.0099, 0.0749> <-0.1030, 0.0102, 0.0696>
		<-0.1224, 0.0090, 0.1082> <-0.1388, 0.0089, 0.0979> <-0.1657, 0.0192, 0.1084> <-0.1791, 0.0195, 0.0945>
		<-0.1273, -0.0174, 0.1132> <-0.1437, -0.0175, 0.1030> <-0.1772, -0.0177, 0.1152> <-0.1907, -0.0174, 0.1013>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0625, 0.0102, 0.0557> <-0.0783, 0.0099, 0.0335> <-0.1224, 0.0090, 0.1082> <-0.1273, -0.0174, 0.1132>
		<-0.0625, 0.0102, 0.0557> <-0.0583, 0.0103, 0.0616> <-0.1067, 0.0091, 0.1180> <-0.1116, -0.0173, 0.1231>
		<-0.0625, 0.0102, 0.0557> <-0.0583, 0.0103, 0.0616> <-0.1047, 0.0161, 0.1469> <-0.1084, -0.0169, 0.1563>
		<-0.0625, 0.0102, 0.0557> <-0.0424, 0.0106, 0.0838> <-0.0877, 0.0162, 0.1543> <-0.0913, -0.0168, 0.1636>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0251, 0.0109, 0.0719> <-0.0131, 0.0107, 0.0697> <0.0029, 0.0104, 0.0669> <0.0149, 0.0102, 0.0648>
		<0.0087, 0.0109, 0.0846> <0.0207, 0.0107, 0.0824> <-0.0229, 0.0107, 0.0680> <-0.0109, 0.0105, 0.0659>
		<0.0242, 0.0176, 0.1658> <0.0392, 0.0175, 0.1632> <0.0394, 0.0078, 0.1362> <0.0531, 0.0076, 0.1295>
		<0.0275, -0.0168, 0.1764> <0.0425, -0.0169, 0.1738> <0.0431, -0.0172, 0.1416> <0.0568, -0.0174, 0.1349>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0251, 0.0109, 0.0719> <0.0087, 0.0109, 0.0846> <0.0242, 0.0176, 0.1658> <0.0275, -0.0168, 0.1764>
		<-0.0251, 0.0109, 0.0719> <-0.0153, 0.0109, 0.0755> <0.0034, 0.0177, 0.1695> <0.0067, -0.0166, 0.1801>
		<-0.0251, 0.0109, 0.0719> <-0.0153, 0.0109, 0.0755> <-0.0166, 0.0080, 0.1473> <-0.0174, -0.0168, 0.1539>
		<-0.0251, 0.0109, 0.0719> <-0.0491, 0.0109, 0.0628> <-0.0376, 0.0080, 0.1451> <-0.0384, -0.0168, 0.1516>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0149, 0.0102, 0.0648> <0.0245, 0.0099, 0.0564> <0.0374, 0.0096, 0.0451> <0.0470, 0.0093, 0.0366>
		<0.0526, 0.0098, 0.0633> <0.0622, 0.0095, 0.0548> <0.0160, 0.0094, 0.0643> <0.0256, 0.0091, 0.0558>
		<0.1072, 0.0174, 0.1244> <0.1222, 0.0173, 0.1112> <0.1156, 0.0090, 0.0820> <0.1250, 0.0090, 0.0644>
		<0.1169, -0.0181, 0.1325> <0.1319, -0.0183, 0.1192> <0.1237, -0.0183, 0.0854> <0.1331, -0.0183, 0.0677>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0149, 0.0102, 0.0648> <0.0526, 0.0098, 0.0633> <0.1072, 0.0174, 0.1244> <0.1169, -0.0181, 0.1325>
		<0.0149, 0.0102, 0.0648> <0.0267, 0.0101, 0.0643> <0.0937, 0.0176, 0.1363> <0.1034, -0.0179, 0.1444>
		<0.0149, 0.0102, 0.0648> <0.0267, 0.0101, 0.0643> <0.0693, 0.0073, 0.1216> <0.0730, -0.0177, 0.1269>
		<0.0149, 0.0102, 0.0648> <-0.0109, 0.0105, 0.0659> <0.0531, 0.0076, 0.1295> <0.0568, -0.0174, 0.1349>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0470, 0.0093, 0.0366> <0.0483, 0.0096, 0.0250> <0.0500, 0.0100, 0.0095> <0.0513, 0.0103, -0.0021>
		<0.0747, 0.0095, 0.0117> <0.0760, 0.0098, 0.0000> <0.0402, 0.0096, 0.0375> <0.0415, 0.0099, 0.0259>
		<0.1550, 0.0168, 0.0351> <0.1572, 0.0170, 0.0156> <0.1360, 0.0107, -0.0032> <0.1346, 0.0109, -0.0228>
		<0.1682, -0.0180, 0.0361> <0.1704, -0.0178, 0.0166> <0.1447, -0.0176, -0.0048> <0.1434, -0.0173, -0.0244>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0470, 0.0093, 0.0366> <0.0747, 0.0095, 0.0117> <0.1550, 0.0168, 0.0351> <0.1682, -0.0180, 0.0361>
		<0.0470, 0.0093, 0.0366> <0.0533, 0.0093, 0.0309> <0.1534, 0.0167, 0.0492> <0.1667, -0.0182, 0.0502>
		<0.0470, 0.0093, 0.0366> <0.0533, 0.0093, 0.0309> <0.1317, 0.0090, 0.0518> <0.1398, -0.0183, 0.0552>
		<0.0470, 0.0093, 0.0366> <0.0256, 0.0091, 0.0558> <0.1250, 0.0090, 0.0644> <0.1331, -0.0183, 0.0677>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0513, 0.0103, -0.0021> <0.0461, 0.0105, -0.0102> <0.0393, 0.0107, -0.0210> <0.0341, 0.0109, -0.0290>
		<0.0645, 0.0108, -0.0399> <0.0593, 0.0110, -0.0480> <0.0582, 0.0108, 0.0002> <0.0531, 0.0110, -0.0078>
		<0.1470, 0.0204, -0.0672> <0.1374, 0.0206, -0.0823> <0.1112, 0.0103, -0.0738> <0.0957, 0.0103, -0.0828>
		<0.1606, -0.0167, -0.0739> <0.1510, -0.0165, -0.0891> <0.1181, -0.0167, -0.0795> <0.1025, -0.0167, -0.0885>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0513, 0.0103, -0.0021> <0.0645, 0.0108, -0.0399> <0.1470, 0.0204, -0.0672> <0.1606, -0.0167, -0.0739>
		<0.0513, 0.0103, -0.0021> <0.0547, 0.0104, -0.0120> <0.1555, 0.0203, -0.0539> <0.1691, -0.0168, -0.0606>
		<0.0513, 0.0103, -0.0021> <0.0547, 0.0104, -0.0120> <0.1335, 0.0111, -0.0385> <0.1423, -0.0172, -0.0401>
		<0.0513, 0.0103, -0.0021> <0.0415, 0.0099, 0.0259> <0.1346, 0.0109, -0.0228> <0.1434, -0.0173, -0.0244>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0341, 0.0109, -0.0290> <0.0225, 0.0107, -0.0330> <0.0070, 0.0104, -0.0382> <-0.0046, 0.0102, -0.0421>
		<0.0125, 0.0109, -0.0532> <0.0009, 0.0107, -0.0571> <0.0272, 0.0106, -0.0232> <0.0156, 0.0104, -0.0272>
		<0.0619, 0.0138, -0.1186> <0.0456, 0.0136, -0.1241> <0.0253, 0.0071, -0.1088> <0.0087, 0.0069, -0.1136>
		<0.0674, -0.0168, -0.1279> <0.0510, -0.0169, -0.1334> <0.0270, -0.0172, -0.1149> <0.0105, -0.0174, -0.1196>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0341, 0.0109, -0.0290> <0.0125, 0.0109, -0.0532> <0.0619, 0.0138, -0.1186> <0.0674, -0.0168, -0.1279>
		<0.0341, 0.0109, -0.0290> <0.0315, 0.0109, -0.0320> <0.0769, 0.0139, -0.1136> <0.0824, -0.0166, -0.1228>
		<0.0341, 0.0109, -0.0290> <0.0315, 0.0109, -0.0320> <0.0820, 0.0103, -0.0908> <0.0888, -0.0167, -0.0964>
		<0.0341, 0.0109, -0.0290> <0.0531, 0.0110, -0.0078> <0.0957, 0.0103, -0.0828> <0.1025, -0.0167, -0.0885>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0046, 0.0102, -0.0421> <-0.0171, 0.0099, -0.0420> <-0.0338, 0.0096, -0.0418> <-0.0463, 0.0093, -0.0416>
		<-0.0351, 0.0098, -0.0648> <-0.0477, 0.0095, -0.0646> <-0.0063, 0.0094, -0.0387> <-0.0188, 0.0091, -0.0385>
		<-0.0422, 0.0182, -0.1480> <-0.0606, 0.0180, -0.1477> <-0.0681, 0.0083, -0.1179> <-0.0855, 0.0083, -0.1120>
		<-0.0434, -0.0181, -0.1596> <-0.0618, -0.0182, -0.1593> <-0.0714, -0.0183, -0.1242> <-0.0888, -0.0183, -0.1184>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0046, 0.0102, -0.0421> <-0.0351, 0.0098, -0.0648> <-0.0422, 0.0182, -0.1480> <-0.0434, -0.0181, -0.1596>
		<-0.0046, 0.0102, -0.0421> <-0.0150, 0.0101, -0.0498> <-0.0221, 0.0183, -0.1482> <-0.0233, -0.0179, -0.1598>
		<-0.0046, 0.0102, -0.0421> <-0.0150, 0.0101, -0.0498> <-0.0107, 0.0066, -0.1191> <-0.0089, -0.0177, -0.1252>
		<-0.0046, 0.0102, -0.0421> <0.0156, 0.0104, -0.0272> <0.0087, 0.0069, -0.1136> <0.0105, -0.0174, -0.1196>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0463, 0.0093, -0.0416> <-0.0577, 0.0096, -0.0328> <-0.0729, 0.0100, -0.0210> <-0.0843, 0.0103, -0.0121>
		<-0.0861, 0.0095, -0.0461> <-0.0975, 0.0098, -0.0372> <-0.0559, 0.0097, -0.0476> <-0.0673, 0.0100, -0.0388>
		<-0.1372, 0.0196, -0.1153> <-0.1569, 0.0198, -0.1000> <-0.1595, 0.0127, -0.0667> <-0.1710, 0.0129, -0.0446>
		<-0.1472, -0.0180, -0.1250> <-0.1669, -0.0178, -0.1097> <-0.1678, -0.0175, -0.0704> <-0.1793, -0.0173, -0.0482>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0463, 0.0093, -0.0416> <-0.0861, 0.0095, -0.0461> <-0.1372, 0.0196, -0.1153> <-0.1472, -0.0180, -0.1250>
		<-0.0463, 0.0093, -0.0416> <-0.0587, 0.0094, -0.0430> <-0.1232, 0.0194, -0.1261> <-0.1332, -0.0182, -0.1358>
		<-0.0463, 0.0093, -0.0416> <-0.0587, 0.0094, -0.0430> <-0.1022, 0.0084, -0.1065> <-0.1055, -0.0183, -0.1129>
		<-0.0463, 0.0093, -0.0416> <-0.0188, 0.0091, -0.0385> <-0.0855, 0.0083, -0.1120> <-0.0888, -0.0183, -0.1184>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0843, 0.0103, -0.0121> <-0.0829, 0.0105, 0.0029> <-0.0811, 0.0109, 0.0230> <-0.0797, 0.0112, 0.0380>
		<-0.1073, 0.0106, 0.0241> <-0.1059, 0.0109, 0.0391> <-0.0636, 0.0116, -0.0009> <-0.0622, 0.0119, 0.0142>
		<-0.2061, 0.0234, 0.0178> <-0.2040, 0.0235, 0.0402> <-0.1680, 0.0121, 0.0479> <-0.1602, 0.0119, 0.0691>
		<-0.2214, -0.0167, 0.0180> <-0.2193, -0.0165, 0.0404> <-0.1761, -0.0163, 0.0499> <-0.1683, -0.0165, 0.0710>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0843, 0.0103, -0.0121> <-0.1073, 0.0106, 0.0241> <-0.2061, 0.0234, 0.0178> <-0.2214, -0.0167, 0.0180>
		<-0.0843, 0.0103, -0.0121> <-0.0903, 0.0104, -0.0026> <-0.2082, 0.0232, -0.0056> <-0.2235, -0.0169, -0.0054>
		<-0.0843, 0.0103, -0.0121> <-0.0903, 0.0104, -0.0026> <-0.1818, 0.0131, -0.0237> <-0.1901, -0.0171, -0.0273>
		<-0.0843, 0.0103, -0.0121> <-0.0673, 0.0100, -0.0388> <-0.1710, 0.0129, -0.0446> <-0.1793, -0.0173, -0.0482>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0797, 0.0112, 0.0380> <-0.0622, 0.0119, 0.0142> <-0.1602, 0.0119, 0.0691> <-0.1683, -0.0165, 0.0710>
		<-0.0797, 0.0112, 0.0380> <-0.0854, 0.0109, 0.0458> <-0.1563, 0.0118, 0.0797> <-0.1644, -0.0165, 0.0816>
		<-0.0797, 0.0112, 0.0380> <-0.0854, 0.0109, 0.0458> <-0.1870, 0.0197, 0.0864> <-0.1985, -0.0172, 0.0932>
		<-0.0797, 0.0112, 0.0380> <-0.1030, 0.0102, 0.0696> <-0.1791, 0.0195, 0.0945> <-0.1907, -0.0174, 0.1013>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1273, -0.0174, 0.1132> <-0.1437, -0.0175, 0.1030> <-0.1772, -0.0177, 0.1152> <-0.1907, -0.0174, 0.1013>
		<-0.1990, -0.4020, 0.1874> <-0.2153, -0.4021, 0.1772> <-0.2959, -0.3976, 0.1854> <-0.3093, -0.3973, 0.1715>
		<-0.2790, -0.9217, 0.2748> <-0.3287, -0.9219, 0.2487> <-0.4053, -0.9182, 0.2923> <-0.4409, -0.9180, 0.2488>
		<-0.3096, -1.3170, 0.3118> <-0.3593, -1.3171, 0.2857> <-0.4591, -1.3173, 0.3268> <-0.4947, -1.3170, 0.2833>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1273, -0.0174, 0.1132> <-0.1990, -0.4020, 0.1874> <-0.2790, -0.9217, 0.2748> <-0.3096, -1.3170, 0.3118>
		<-0.1116, -0.0173, 0.1231> <-0.1832, -0.4019, 0.1973> <-0.2373, -0.9216, 0.2967> <-0.2680, -1.3169, 0.3337>
		<-0.1084, -0.0169, 0.1563> <-0.1509, -0.3992, 0.2649> <-0.2336, -0.9202, 0.3640> <-0.2527, -1.3164, 0.4131>
		<-0.0913, -0.0168, 0.1636> <-0.1338, -0.3991, 0.2723> <-0.1908, -0.9200, 0.3836> <-0.2100, -1.3163, 0.4328>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0913, -0.0168, 0.1636> <-0.1338, -0.3991, 0.2723> <-0.1908, -0.9200, 0.3836> <-0.2100, -1.3163, 0.4328>
		<-0.0764, -0.0167, 0.1701> <-0.1189, -0.3990, 0.2788> <-0.1524, -0.9199, 0.4013> <-0.1715, -1.3161, 0.4505>
		<-0.0546, -0.0168, 0.1499> <-0.0674, -0.4017, 0.2516> <-0.1077, -0.9211, 0.3655> <-0.1110, -1.3163, 0.4159>
		<-0.0384, -0.0168, 0.1516> <-0.0512, -0.4017, 0.2533> <-0.0659, -0.9211, 0.3722> <-0.0692, -1.3163, 0.4225>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0384, -0.0168, 0.1516> <-0.0512, -0.4017, 0.2533> <-0.0659, -0.9211, 0.3722> <-0.0692, -1.3163, 0.4225>
		<-0.0174, -0.0168, 0.1539> <-0.0302, -0.4017, 0.2556> <-0.0118, -0.9211, 0.3808> <-0.0151, -1.3163, 0.4311>
		<0.0067, -0.0166, 0.1801> <0.0436, -0.3982, 0.2982> <0.0345, -0.9193, 0.4396> <0.0502, -1.3161, 0.4963>
		<0.0275, -0.0168, 0.1764> <0.0644, -0.3984, 0.2945> <0.0875, -0.9194, 0.4260> <0.1032, -1.3163, 0.4826>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0275, -0.0168, 0.1764> <0.0644, -0.3984, 0.2945> <0.0875, -0.9194, 0.4260> <0.1032, -1.3163, 0.4826>
		<0.0425, -0.0169, 0.1738> <0.0794, -0.3985, 0.2919> <0.1378, -0.9196, 0.4131> <0.1535, -1.3164, 0.4697>
		<0.0431, -0.0172, 0.1416> <0.1009, -0.4022, 0.2242> <0.1344, -0.9220, 0.3308> <0.1661, -1.3168, 0.3698>
		<0.0568, -0.0174, 0.1349> <0.1146, -0.4024, 0.2175> <0.1823, -0.9223, 0.3107> <0.2139, -1.3171, 0.3496>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0568, -0.0174, 0.1349> <0.1146, -0.4024, 0.2175> <0.1823, -0.9223, 0.3107> <0.2139, -1.3171, 0.3496>
		<0.0730, -0.0177, 0.1269> <0.1307, -0.4027, 0.2095> <0.2277, -0.9225, 0.2916> <0.2593, -1.3173, 0.3305>
		<0.1034, -0.0179, 0.1444> <0.2072, -0.3985, 0.2310> <0.2852, -0.9194, 0.3503> <0.3360, -1.3176, 0.3943>
		<0.1169, -0.0181, 0.1325> <0.2207, -0.3986, 0.2191> <0.3265, -0.9196, 0.3233> <0.3772, -1.3178, 0.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1169, -0.0181, 0.1325> <0.2207, -0.3986, 0.2191> <0.3265, -0.9196, 0.3233> <0.3772, -1.3178, 0.3673>
		<0.1319, -0.0183, 0.1192> <0.2357, -0.3988, 0.2059> <0.3710, -0.9198, 0.2941> <0.4217, -1.3180, 0.3381>
		<0.1237, -0.0183, 0.0854> <0.2373, -0.4017, 0.1330> <0.3529, -0.9208, 0.2211> <0.4128, -1.3181, 0.2471>
		<0.1331, -0.0183, 0.0677> <0.2467, -0.4017, 0.1154> <0.3802, -0.9208, 0.1755> <0.4401, -1.3181, 0.2015>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1331, -0.0183, 0.0677> <0.2467, -0.4017, 0.1154> <0.3802, -0.9208, 0.1755> <0.4401, -1.3181, 0.2015>
		<0.1398, -0.0183, 0.0552> <0.2534, -0.4017, 0.1029> <0.4060, -0.9208, 0.1323> <0.4660, -1.3181, 0.1583>
		<0.1667, -0.0182, 0.0502> <0.3112, -0.3982, 0.0615> <0.4725, -0.9183, 0.1190> <0.5475, -1.3180, 0.1263>
		<0.1682, -0.0180, 0.0361> <0.3127, -0.3980, 0.0474> <0.4766, -0.9181, 0.0689> <0.5516, -1.3178, 0.0761>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1682, -0.0180, 0.0361> <0.3127, -0.3980, 0.0474> <0.4766, -0.9181, 0.0689> <0.5516, -1.3178, 0.0761>
		<0.1704, -0.0178, 0.0166> <0.3149, -0.3978, 0.0279> <0.4809, -0.9179, 0.0164> <0.5558, -1.3175, 0.0236>
		<0.1447, -0.0176, -0.0048> <0.2635, -0.4008, -0.0259> <0.4031, -0.9203, -0.0139> <0.4650, -1.3172, -0.0226>
		<0.1434, -0.0173, -0.0244> <0.2621, -0.4006, -0.0455> <0.4008, -0.9201, -0.0665> <0.4627, -1.3170, -0.0752>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1434, -0.0173, -0.0244> <0.2621, -0.4006, -0.0455> <0.4008, -0.9201, -0.0665> <0.4627, -1.3170, -0.0752>
		<0.1423, -0.0172, -0.0401> <0.2611, -0.4004, -0.0612> <0.3984, -0.9198, -0.1217> <0.4602, -1.3167, -0.1304>
		<0.1691, -0.0168, -0.0606> <0.3078, -0.3954, -0.1295> <0.4835, -0.9154, -0.1600> <0.5578, -1.3164, -0.1921>
		<0.1606, -0.0167, -0.0739> <0.2994, -0.3953, -0.1428> <0.4631, -0.9152, -0.2113> <0.5374, -1.3162, -0.2434>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1606, -0.0167, -0.0739> <0.2994, -0.3953, -0.1428> <0.4631, -0.9152, -0.2113> <0.5374, -1.3162, -0.2434>
		<0.1510, -0.0165, -0.0891> <0.2897, -0.3952, -0.1579> <0.4433, -0.9150, -0.2613> <0.5176, -1.3160, -0.2934>
		<0.1181, -0.0167, -0.0795> <0.2152, -0.3999, -0.1600> <0.3607, -0.9185, -0.2349> <0.4142, -1.3162, -0.2769>
		<0.1025, -0.0167, -0.0885> <0.1996, -0.3999, -0.1690> <0.3168, -0.9185, -0.2658> <0.3702, -1.3162, -0.3078>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1025, -0.0167, -0.0885> <0.1996, -0.3999, -0.1690> <0.3168, -0.9185, -0.2658> <0.3702, -1.3162, -0.3078>
		<0.0888, -0.0167, -0.0964> <0.1859, -0.3999, -0.1769> <0.2781, -0.9185, -0.2931> <0.3315, -1.3162, -0.3351>
		<0.0824, -0.0166, -0.1228> <0.1506, -0.3987, -0.2384> <0.2756, -0.9175, -0.3621> <0.3174, -1.3161, -0.4201>
		<0.0674, -0.0168, -0.1279> <0.1356, -0.3988, -0.2435> <0.2295, -0.9177, -0.3727> <0.2713, -1.3163, -0.4308>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0674, -0.0168, -0.1279> <0.1356, -0.3988, -0.2435> <0.2295, -0.9177, -0.3727> <0.2713, -1.3163, -0.4308>
		<0.0510, -0.0169, -0.1334> <0.1193, -0.3989, -0.2490> <0.1744, -0.9179, -0.3854> <0.2162, -1.3164, -0.4434>
		<0.0270, -0.0172, -0.1149> <0.0552, -0.4025, -0.2106> <0.1302, -0.9220, -0.3188> <0.1485, -1.3168, -0.3655>
		<0.0105, -0.0174, -0.1196> <0.0386, -0.4027, -0.2153> <0.0741, -0.9223, -0.3251> <0.0924, -1.3171, -0.3718>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0105, -0.0174, -0.1196> <0.0386, -0.4027, -0.2153> <0.0741, -0.9223, -0.3251> <0.0924, -1.3171, -0.3718>
		<-0.0089, -0.0177, -0.1252> <0.0193, -0.4029, -0.2208> <0.0233, -0.9226, -0.3308> <0.0416, -1.3173, -0.3775>
		<-0.0233, -0.0179, -0.1598> <-0.0361, -0.3993, -0.2818> <-0.0007, -0.9210, -0.4125> <0.0020, -1.3177, -0.4688>
		<-0.0434, -0.0181, -0.1596> <-0.0562, -0.3995, -0.2815> <-0.0518, -0.9211, -0.4105> <-0.0490, -1.3178, -0.4668>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0434, -0.0181, -0.1596> <-0.0562, -0.3995, -0.2815> <-0.0518, -0.9211, -0.4105> <-0.0490, -1.3178, -0.4668>
		<-0.0618, -0.0182, -0.1593> <-0.0746, -0.3997, -0.2813> <-0.1097, -0.9213, -0.4083> <-0.1069, -1.3180, -0.4646>
		<-0.0714, -0.0183, -0.1242> <-0.1188, -0.4029, -0.2165> <-0.1338, -0.9228, -0.3290> <-0.1536, -1.3181, -0.3734>
		<-0.0888, -0.0183, -0.1184> <-0.1362, -0.4029, -0.2107> <-0.1901, -0.9228, -0.3155> <-0.2100, -1.3181, -0.3600>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0888, -0.0183, -0.1184> <-0.1362, -0.4029, -0.2107> <-0.1901, -0.9228, -0.3155> <-0.2100, -1.3181, -0.3600>
		<-0.1055, -0.0183, -0.1129> <-0.1529, -0.4028, -0.2051> <-0.2458, -0.9228, -0.3023> <-0.2656, -1.3181, -0.3467>
		<-0.1332, -0.0182, -0.1358> <-0.2342, -0.3977, -0.2335> <-0.3091, -0.9187, -0.3707> <-0.3544, -1.3180, -0.4189>
		<-0.1472, -0.0180, -0.1250> <-0.2481, -0.3975, -0.2227> <-0.3540, -0.9185, -0.3352> <-0.3993, -1.3178, -0.3835>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1472, -0.0180, -0.1250> <-0.2481, -0.3975, -0.2227> <-0.3540, -0.9185, -0.3352> <-0.3993, -1.3178, -0.3835>
		<-0.1669, -0.0178, -0.1097> <-0.2678, -0.3973, -0.2074> <-0.4051, -0.9183, -0.2949> <-0.4505, -1.3175, -0.3431>
		<-0.1678, -0.0175, -0.0704> <-0.2728, -0.4006, -0.1165> <-0.3724, -0.9207, -0.2067> <-0.4187, -1.3172, -0.2300>
		<-0.1793, -0.0173, -0.0482> <-0.2843, -0.4004, -0.0944> <-0.4019, -0.9205, -0.1486> <-0.4483, -1.3170, -0.1720>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1793, -0.0173, -0.0482> <-0.2843, -0.4004, -0.0944> <-0.4019, -0.9205, -0.1486> <-0.4483, -1.3170, -0.1720>
		<-0.1901, -0.0171, -0.0273> <-0.2952, -0.4002, -0.0735> <-0.4318, -0.9202, -0.0900> <-0.4781, -1.3167, -0.1133>
		<-0.2235, -0.0169, -0.0054> <-0.3683, -0.3955, -0.0036> <-0.5226, -0.9165, -0.0657> <-0.5892, -1.3164, -0.0715>
		<-0.2214, -0.0167, 0.0180> <-0.3662, -0.3954, 0.0198> <-0.5250, -0.9163, 0.0001> <-0.5915, -1.3162, -0.0058>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2214, -0.0167, 0.0180> <-0.3662, -0.3954, 0.0198> <-0.5250, -0.9163, 0.0001> <-0.5915, -1.3162, -0.0058>
		<-0.2193, -0.0165, 0.0404> <-0.3641, -0.3952, 0.0422> <-0.5270, -0.9161, 0.0568> <-0.5936, -1.3160, 0.0510>
		<-0.1761, -0.0163, 0.0499> <-0.2858, -0.3999, 0.0763> <-0.4250, -0.9194, 0.0669> <-0.4771, -1.3158, 0.0756>
		<-0.1683, -0.0165, 0.0710> <-0.2780, -0.4001, 0.0974> <-0.4070, -0.9195, 0.1207> <-0.4591, -1.3159, 0.1294>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1683, -0.0165, 0.0710> <-0.2780, -0.4001, 0.0974> <-0.4070, -0.9195, 0.1207> <-0.4591, -1.3159, 0.1294>
		<-0.1644, -0.0165, 0.0816> <-0.2741, -0.4002, 0.1080> <-0.3919, -0.9197, 0.1657> <-0.4440, -1.3160, 0.1743>
		<-0.1985, -0.0172, 0.0932> <-0.3172, -0.3971, 0.1634> <-0.4710, -0.9177, 0.2122> <-0.5247, -1.3168, 0.2467>
		<-0.1907, -0.0174, 0.1013> <-0.3093, -0.3973, 0.1715> <-0.4409, -0.9180, 0.2488> <-0.4947, -1.3170, 0.2833>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2292, -1.3305, 0.2361> <-0.2533, -1.3264, 0.2588> <-0.3122, -1.3502, 0.3149> <-0.3096, -1.3170, 0.3118>
		<-0.2663, -1.3306, 0.2166> <-0.2905, -1.3266, 0.2393> <-0.3619, -1.3503, 0.2888> <-0.3593, -1.3171, 0.2857>
		<-0.3409, -1.3307, 0.2473> <-0.3790, -1.3267, 0.2678> <-0.4649, -1.3603, 0.3305> <-0.4591, -1.3173, 0.3268>
		<-0.3675, -1.3305, 0.2148> <-0.4056, -1.3264, 0.2354> <-0.5005, -1.3600, 0.2870> <-0.4947, -1.3170, 0.2833>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2292, -1.3305, 0.2361> <-0.1980, -1.3304, 0.2524> <-0.1866, -1.3299, 0.3118> <-0.1547, -1.3297, 0.3265>
		<-0.2533, -1.3264, 0.2588> <-0.2222, -1.3263, 0.2751> <-0.2032, -1.3258, 0.3437> <-0.1713, -1.3257, 0.3584>
		<-0.3122, -1.3502, 0.3149> <-0.2705, -1.3500, 0.3368> <-0.2544, -1.3522, 0.4176> <-0.2117, -1.3521, 0.4372>
		<-0.3096, -1.3170, 0.3118> <-0.2680, -1.3169, 0.3337> <-0.2527, -1.3164, 0.4131> <-0.2100, -1.3163, 0.4328>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1547, -1.3297, 0.3265> <-0.1259, -1.3296, 0.3398> <-0.0807, -1.3297, 0.3139> <-0.0495, -1.3297, 0.3189>
		<-0.1713, -1.3257, 0.3584> <-0.1425, -1.3256, 0.3717> <-0.0866, -1.3257, 0.3450> <-0.0554, -1.3257, 0.3499>
		<-0.2117, -1.3521, 0.4372> <-0.1732, -1.3520, 0.4550> <-0.1113, -1.3479, 0.4199> <-0.0695, -1.3479, 0.4265>
		<-0.2100, -1.3163, 0.4328> <-0.1715, -1.3161, 0.4505> <-0.1110, -1.3163, 0.4159> <-0.0692, -1.3163, 0.4225>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0495, -1.3297, 0.3189> <-0.0090, -1.3297, 0.3253> <0.0398, -1.3296, 0.3740> <0.0794, -1.3297, 0.3638>
		<-0.0554, -1.3257, 0.3499> <-0.0149, -1.3257, 0.3564> <0.0469, -1.3255, 0.4096> <0.0866, -1.3257, 0.3994>
		<-0.0695, -1.3479, 0.4265> <-0.0154, -1.3479, 0.4352> <0.0516, -1.3523, 0.5014> <0.1047, -1.3525, 0.4878>
		<-0.0692, -1.3163, 0.4225> <-0.0151, -1.3163, 0.4311> <0.0502, -1.3161, 0.4963> <0.1032, -1.3163, 0.4826>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0794, -1.3297, 0.3638> <0.1170, -1.3299, 0.3541> <0.1264, -1.3303, 0.2794> <0.1622, -1.3305, 0.2644>
		<0.0866, -1.3257, 0.3994> <0.1241, -1.3258, 0.3898> <0.1419, -1.3262, 0.3050> <0.1777, -1.3265, 0.2900>
		<0.1047, -1.3525, 0.4878> <0.1549, -1.3526, 0.4748> <0.1685, -1.3467, 0.3727> <0.2163, -1.3470, 0.3526>
		<0.1032, -1.3163, 0.4826> <0.1535, -1.3164, 0.4697> <0.1661, -1.3168, 0.3698> <0.2139, -1.3171, 0.3496>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1622, -1.3305, 0.2644> <0.1961, -1.3308, 0.2501> <0.2534, -1.3311, 0.2977> <0.2842, -1.3313, 0.2776>
		<0.1777, -1.3265, 0.2900> <0.2116, -1.3267, 0.2757> <0.2813, -1.3271, 0.3246> <0.3121, -1.3273, 0.3045>
		<0.2163, -1.3470, 0.3526> <0.2617, -1.3473, 0.3335> <0.3409, -1.3561, 0.3985> <0.3821, -1.3563, 0.3715>
		<0.2139, -1.3171, 0.3496> <0.2593, -1.3173, 0.3305> <0.3360, -1.3176, 0.3943> <0.3772, -1.3178, 0.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2842, -1.3313, 0.2776> <0.3175, -1.3315, 0.2558> <0.3108, -1.3316, 0.1878> <0.3313, -1.3316, 0.1537>
		<0.3121, -1.3273, 0.3045> <0.3454, -1.3275, 0.2827> <0.3435, -1.3276, 0.2021> <0.3639, -1.3275, 0.1680>
		<0.3821, -1.3563, 0.3715> <0.4266, -1.3565, 0.3424> <0.4181, -1.3536, 0.2495> <0.4455, -1.3535, 0.2038>
		<0.3772, -1.3178, 0.3673> <0.4217, -1.3180, 0.3381> <0.4128, -1.3181, 0.2471> <0.4401, -1.3181, 0.2015>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3313, -1.3316, 0.1537> <0.3506, -1.3316, 0.1214> <0.4115, -1.3314, 0.0974> <0.4146, -1.3312, 0.0599>
		<0.3639, -1.3275, 0.1680> <0.3833, -1.3275, 0.1357> <0.4526, -1.3274, 0.1023> <0.4557, -1.3272, 0.0648>
		<0.4455, -1.3535, 0.2038> <0.4713, -1.3535, 0.1606> <0.5551, -1.3588, 0.1270> <0.5592, -1.3586, 0.0768>
		<0.4401, -1.3181, 0.2015> <0.4660, -1.3181, 0.1583> <0.5475, -1.3180, 0.1263> <0.5516, -1.3178, 0.0761>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.4146, -1.3312, 0.0599> <0.4178, -1.3310, 0.0207> <0.3499, -1.3307, -0.0139> <0.3481, -1.3304, -0.0532>
		<0.4557, -1.3272, 0.0648> <0.4589, -1.3270, 0.0256> <0.3842, -1.3266, -0.0205> <0.3825, -1.3264, -0.0598>
		<0.5592, -1.3586, 0.0768> <0.5635, -1.3584, 0.0244> <0.4704, -1.3520, -0.0234> <0.4681, -1.3518, -0.0759>
		<0.5516, -1.3178, 0.0761> <0.5558, -1.3175, 0.0236> <0.4650, -1.3172, -0.0226> <0.4627, -1.3170, -0.0752>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3481, -1.3304, -0.0532> <0.3463, -1.3301, -0.0944> <0.4192, -1.3298, -0.1406> <0.4040, -1.3296, -0.1789>
		<0.3825, -1.3264, -0.0598> <0.3807, -1.3261, -0.1010> <0.4593, -1.3258, -0.1599> <0.4440, -1.3256, -0.1983>
		<0.4681, -1.3518, -0.0759> <0.4657, -1.3515, -0.1311> <0.5659, -1.3601, -0.1956> <0.5455, -1.3600, -0.2469>
		<0.4627, -1.3170, -0.0752> <0.4602, -1.3167, -0.1304> <0.5578, -1.3164, -0.1921> <0.5374, -1.3162, -0.2434>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.4040, -1.3296, -0.1789> <0.3891, -1.3295, -0.2162> <0.3119, -1.3296, -0.2039> <0.2790, -1.3296, -0.2270>
		<0.4440, -1.3256, -0.1983> <0.4292, -1.3254, -0.2356> <0.3392, -1.3256, -0.2281> <0.3064, -1.3256, -0.2513>
		<0.5455, -1.3600, -0.2469> <0.5257, -1.3598, -0.2969> <0.4191, -1.3524, -0.2807> <0.3751, -1.3524, -0.3116>
		<0.5374, -1.3162, -0.2434> <0.5176, -1.3160, -0.2934> <0.4142, -1.3162, -0.2769> <0.3702, -1.3162, -0.3078>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2790, -1.3296, -0.2270> <0.2501, -1.3297, -0.2474> <0.2395, -1.3296, -0.3110> <0.2050, -1.3297, -0.3189>
		<0.3064, -1.3256, -0.2513> <0.2774, -1.3256, -0.2716> <0.2594, -1.3255, -0.3445> <0.2249, -1.3257, -0.3525>
		<0.3751, -1.3524, -0.3116> <0.3364, -1.3524, -0.3389> <0.3214, -1.3547, -0.4257> <0.2753, -1.3548, -0.4364>
		<0.3702, -1.3162, -0.3078> <0.3315, -1.3162, -0.3351> <0.3174, -1.3161, -0.4201> <0.2713, -1.3163, -0.4308>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2050, -1.3297, -0.3189> <0.1639, -1.3299, -0.3284> <0.1133, -1.3303, -0.2702> <0.0713, -1.3305, -0.2749>
		<0.2249, -1.3257, -0.3525> <0.1837, -1.3259, -0.3620> <0.1196, -1.3262, -0.2992> <0.0777, -1.3265, -0.3040>
		<0.2753, -1.3548, -0.4364> <0.2202, -1.3550, -0.4490> <0.1499, -1.3466, -0.3690> <0.0938, -1.3469, -0.3753>
		<0.2713, -1.3163, -0.4308> <0.2162, -1.3164, -0.4434> <0.1485, -1.3168, -0.3655> <0.0924, -1.3171, -0.3718>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0713, -1.3305, -0.2749> <0.0334, -1.3308, -0.2792> <0.0038, -1.3311, -0.3474> <-0.0344, -1.3313, -0.3459>
		<0.0777, -1.3265, -0.3040> <0.0397, -1.3267, -0.3082> <-0.0006, -1.3271, -0.3837> <-0.0388, -1.3273, -0.3822>
		<0.0938, -1.3469, -0.3753> <0.0430, -1.3471, -0.3810> <0.0023, -1.3541, -0.4740> <-0.0488, -1.3542, -0.4720>
		<0.0924, -1.3171, -0.3718> <0.0416, -1.3173, -0.3775> <0.0020, -1.3177, -0.4688> <-0.0490, -1.3178, -0.4668>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0344, -1.3313, -0.3459> <-0.0777, -1.3315, -0.3442> <-0.1125, -1.3316, -0.2761> <-0.1547, -1.3316, -0.2661>
		<-0.0388, -1.3273, -0.3822> <-0.0821, -1.3275, -0.3805> <-0.1291, -1.3276, -0.3043> <-0.1713, -1.3275, -0.2942>
		<-0.0488, -1.3542, -0.4720> <-0.1067, -1.3544, -0.4697> <-0.1552, -1.3508, -0.3771> <-0.2116, -1.3508, -0.3637>
		<-0.0490, -1.3178, -0.4668> <-0.1069, -1.3180, -0.4646> <-0.1536, -1.3181, -0.3734> <-0.2100, -1.3181, -0.3600>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1547, -1.3316, -0.2661> <-0.1963, -1.3316, -0.2561> <-0.2626, -1.3314, -0.3101> <-0.2962, -1.3312, -0.2836>
		<-0.1713, -1.3275, -0.2942> <-0.2129, -1.3275, -0.2843> <-0.2936, -1.3274, -0.3401> <-0.3272, -1.3272, -0.3136>
		<-0.2116, -1.3508, -0.3637> <-0.2673, -1.3508, -0.3504> <-0.3592, -1.3606, -0.4241> <-0.4042, -1.3604, -0.3886>
		<-0.2100, -1.3181, -0.3600> <-0.2656, -1.3181, -0.3467> <-0.3544, -1.3180, -0.4189> <-0.3993, -1.3178, -0.3835>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2962, -1.3312, -0.2836> <-0.3344, -1.3310, -0.2535> <-0.3107, -1.3307, -0.1689> <-0.3328, -1.3304, -0.1255>
		<-0.3272, -1.3272, -0.3136> <-0.3654, -1.3269, -0.2834> <-0.3454, -1.3266, -0.1828> <-0.3674, -1.3264, -0.1394>
		<-0.4042, -1.3604, -0.3886> <-0.4553, -1.3602, -0.3483> <-0.4231, -1.3544, -0.2322> <-0.4526, -1.3542, -0.1742>
		<-0.3993, -1.3178, -0.3835> <-0.4505, -1.3175, -0.3431> <-0.4187, -1.3172, -0.2300> <-0.4483, -1.3170, -0.1720>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3328, -1.3304, -0.1255> <-0.3551, -1.3302, -0.0817> <-0.4381, -1.3299, -0.0504> <-0.4399, -1.3296, -0.0013>
		<-0.3674, -1.3264, -0.1394> <-0.3897, -1.3261, -0.0956> <-0.4836, -1.3258, -0.0518> <-0.4854, -1.3256, -0.0026>
		<-0.4526, -1.3542, -0.1742> <-0.4825, -1.3540, -0.1155> <-0.5967, -1.3615, -0.0722> <-0.5990, -1.3613, -0.0064>
		<-0.4483, -1.3170, -0.1720> <-0.4781, -1.3167, -0.1133> <-0.5892, -1.3164, -0.0715> <-0.5915, -1.3162, -0.0058>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.4399, -1.3296, -0.0013> <-0.4414, -1.3295, 0.0411> <-0.3544, -1.3292, 0.0595> <-0.3409, -1.3294, 0.0998>
		<-0.4854, -1.3256, -0.0026> <-0.4869, -1.3254, 0.0398> <-0.3898, -1.3252, 0.0684> <-0.3763, -1.3253, 0.1087>
		<-0.5990, -1.3613, -0.0064> <-0.6011, -1.3611, 0.0503> <-0.4819, -1.3522, 0.0764> <-0.4639, -1.3524, 0.1302>
		<-0.5915, -1.3162, -0.0058> <-0.5936, -1.3160, 0.0510> <-0.4771, -1.3158, 0.0756> <-0.4591, -1.3159, 0.1294>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3409, -1.3294, 0.0998> <-0.3296, -1.3295, 0.1334> <-0.3899, -1.3302, 0.1874> <-0.3675, -1.3305, 0.2148>
		<-0.3763, -1.3253, 0.1087> <-0.3651, -1.3255, 0.1422> <-0.4281, -1.3262, 0.2080> <-0.4056, -1.3264, 0.2354>
		<-0.4639, -1.3524, 0.1302> <-0.4488, -1.3525, 0.1751> <-0.5305, -1.3598, 0.2504> <-0.5005, -1.3600, 0.2870>
		<-0.4591, -1.3159, 0.1294> <-0.4440, -1.3160, 0.1743> <-0.5247, -1.3168, 0.2467> <-0.4947, -1.3170, 0.2833>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2040, 0.3789, 0.2226> <-0.2635, 0.3613, 0.2032> <-0.2714, 0.2740, 0.1316> <-0.2919, 0.2440, 0.0776>
		<-0.1828, 0.2687, 0.2195> <-0.2422, 0.2511, 0.2001> <-0.2601, 0.2050, 0.1321> <-0.2806, 0.1750, 0.0782>
		<-0.1391, 0.1257, 0.1881> <-0.1768, 0.1256, 0.1771> <-0.2316, 0.0835, 0.1240> <-0.2502, 0.0833, 0.0895>
		<-0.1023, 0.0256, 0.1532> <-0.1399, 0.0255, 0.1422> <-0.1934, 0.0254, 0.1169> <-0.2121, 0.0252, 0.0825>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2040, 0.3789, 0.2226> <-0.2167, 0.4446, 0.2244> <-0.2284, 0.5409, 0.2044> <-0.2120, 0.5954, 0.1690>
		<-0.2635, 0.3613, 0.2032> <-0.2761, 0.4270, 0.2050> <-0.2684, 0.5432, 0.1962> <-0.2520, 0.5976, 0.1608>
		<-0.2714, 0.2740, 0.1316> <-0.2897, 0.3858, 0.1307> <-0.3351, 0.5145, 0.1193> <-0.2910, 0.6188, 0.1139>
		<-0.2919, 0.2440, 0.0776> <-0.3102, 0.3559, 0.0767> <-0.3537, 0.5172, 0.0830> <-0.3096, 0.6215, 0.0776>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2040, 0.3789, 0.2226> <-0.1028, 0.4087, 0.2557> <0.0617, 0.4112, 0.2516> <0.1645, 0.3789, 0.2269>
		<-0.2167, 0.4446, 0.2244> <-0.1155, 0.4745, 0.2575> <0.0734, 0.4771, 0.2531> <0.1762, 0.4448, 0.2284>
		<-0.2284, 0.5409, 0.2044> <-0.1203, 0.5349, 0.2266> <0.0734, 0.5395, 0.2192> <0.1832, 0.5438, 0.2067>
		<-0.2120, 0.5954, 0.1690> <-0.1039, 0.5893, 0.1913> <0.0467, 0.5911, 0.1859> <0.1564, 0.5954, 0.1734>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2040, 0.3789, 0.2226> <-0.1828, 0.2687, 0.2195> <-0.1391, 0.1257, 0.1881> <-0.1023, 0.0256, 0.1532>
		<-0.1028, 0.4087, 0.2557> <-0.0816, 0.2986, 0.2526> <-0.0937, 0.1258, 0.2013> <-0.0568, 0.0257, 0.1665>
		<0.0617, 0.4112, 0.2516> <0.0420, 0.3003, 0.2491> <0.0454, 0.1265, 0.2058> <0.0091, 0.0257, 0.1708>
		<0.1645, 0.3789, 0.2269> <0.1448, 0.2679, 0.2244> <0.0916, 0.1264, 0.1955> <0.0553, 0.0256, 0.1604>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1645, 0.3789, 0.2269> <0.1448, 0.2679, 0.2244> <0.0916, 0.1264, 0.1955> <0.0553, 0.0256, 0.1604>
		<0.2153, 0.3628, 0.2147> <0.1956, 0.2519, 0.2122> <0.1287, 0.1263, 0.1872> <0.0925, 0.0255, 0.1521>
		<0.2096, 0.2676, 0.1669> <0.2030, 0.1995, 0.1639> <0.1748, 0.0844, 0.1424> <0.1437, 0.0254, 0.1264>
		<0.2242, 0.2440, 0.1197> <0.2175, 0.1758, 0.1167> <0.1945, 0.0842, 0.1098> <0.1634, 0.0252, 0.0938>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1645, 0.3789, 0.2269> <0.2153, 0.3628, 0.2147> <0.2096, 0.2676, 0.1669> <0.2242, 0.2440, 0.1197>
		<0.1762, 0.4448, 0.2284> <0.2270, 0.4287, 0.2162> <0.2204, 0.3775, 0.1717> <0.2350, 0.3539, 0.1246>
		<0.1832, 0.5438, 0.2067> <0.2087, 0.5448, 0.2038> <0.2597, 0.5124, 0.1587> <0.2694, 0.5141, 0.1350>
		<0.1564, 0.5954, 0.1734> <0.1819, 0.5964, 0.1705> <0.2113, 0.6105, 0.1435> <0.2210, 0.6123, 0.1197>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2242, 0.2440, 0.1197> <0.2374, 0.2226, 0.0770> <0.2604, 0.2213, -0.0011> <0.2481, 0.2430, -0.0440>
		<0.2350, 0.3539, 0.1246> <0.2482, 0.3324, 0.0818> <0.2724, 0.3311, -0.0005> <0.2600, 0.3528, -0.0434>
		<0.2694, 0.5141, 0.1350> <0.2880, 0.5175, 0.0891> <0.3214, 0.5172, -0.0075> <0.2983, 0.5149, -0.0514>
		<0.2210, 0.6123, 0.1197> <0.2396, 0.6156, 0.0739> <0.2680, 0.6136, -0.0001> <0.2448, 0.6113, -0.0440>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2242, 0.2440, 0.1197> <0.2175, 0.1758, 0.1167> <0.1945, 0.0842, 0.1098> <0.1634, 0.0252, 0.0938>
		<0.2374, 0.2226, 0.0770> <0.2307, 0.1544, 0.0740> <0.2165, 0.0839, 0.0735> <0.1854, 0.0249, 0.0575>
		<0.2604, 0.2213, -0.0011> <0.2529, 0.1530, -0.0014> <0.2211, 0.0839, -0.0074> <0.1866, 0.0246, -0.0046>
		<0.2481, 0.2430, -0.0440> <0.2406, 0.1747, -0.0443> <0.2153, 0.0835, -0.0494> <0.1808, 0.0242, -0.0467>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2481, 0.2430, -0.0440> <0.2406, 0.1747, -0.0443> <0.2153, 0.0835, -0.0494> <0.1808, 0.0242, -0.0467>
		<0.2337, 0.2683, -0.0939> <0.2263, 0.2000, -0.0942> <0.2121, 0.0833, -0.0722> <0.1776, 0.0239, -0.0695>
		<0.1998, 0.3541, -0.1250> <0.2074, 0.2479, -0.1227> <0.1720, 0.1265, -0.1137> <0.1535, 0.0234, -0.0944>
		<0.1491, 0.3764, -0.1417> <0.1567, 0.2702, -0.1395> <0.1538, 0.1263, -0.1279> <0.1354, 0.0231, -0.1086>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2481, 0.2430, -0.0440> <0.2337, 0.2683, -0.0939> <0.1998, 0.3541, -0.1250> <0.1491, 0.3764, -0.1417>
		<0.2600, 0.3528, -0.0434> <0.2457, 0.3781, -0.0934> <0.1948, 0.4230, -0.1264> <0.1442, 0.4453, -0.1432>
		<0.2983, 0.5149, -0.0514> <0.2746, 0.5124, -0.0963> <0.1705, 0.5465, -0.1434> <0.1202, 0.5420, -0.1496>
		<0.2448, 0.6113, -0.0440> <0.2211, 0.6088, -0.0889> <0.1444, 0.6037, -0.1146> <0.0941, 0.5992, -0.1208>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1491, 0.3764, -0.1417> <0.0957, 0.3999, -0.1594> <0.0069, 0.3761, -0.1432> <-0.0541, 0.3760, -0.1438>
		<0.1442, 0.4453, -0.1432> <0.0908, 0.4688, -0.1608> <-0.0180, 0.4387, -0.1393> <-0.0790, 0.4386, -0.1400>
		<0.1202, 0.5420, -0.1496> <0.0495, 0.5357, -0.1584> <-0.0445, 0.5232, -0.1161> <-0.1151, 0.5165, -0.1074>
		<0.0941, 0.5992, -0.1208> <0.0235, 0.5929, -0.1296> <-0.0707, 0.5834, -0.1005> <-0.1413, 0.5767, -0.0918>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1491, 0.3764, -0.1417> <0.1567, 0.2702, -0.1395> <0.1538, 0.1263, -0.1279> <0.1354, 0.0231, -0.1086>
		<0.0957, 0.3999, -0.1594> <0.1033, 0.2937, -0.1571> <0.1399, 0.1261, -0.1388> <0.1215, 0.0229, -0.1194>
		<0.0069, 0.3761, -0.1432> <0.0488, 0.2709, -0.1497> <0.0663, 0.1308, -0.1384> <0.0961, 0.0228, -0.1208>
		<-0.0541, 0.3760, -0.1438> <-0.0122, 0.2708, -0.1503> <0.0494, 0.1307, -0.1436> <0.0793, 0.0227, -0.1260>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0541, 0.3760, -0.1438> <-0.0298, 0.3782, -0.1444> <0.0053, 0.3833, -0.1341> <0.0267, 0.3833, -0.1458>
		<-0.0790, 0.4386, -0.1400> <-0.0548, 0.4408, -0.1405> <-0.0173, 0.4456, -0.1309> <0.0041, 0.4456, -0.1425>
		<-0.1151, 0.5165, -0.1074> <-0.0938, 0.5165, -0.1095> <-0.0624, 0.5187, -0.1108> <-0.0410, 0.5187, -0.1129>
		<-0.1413, 0.5767, -0.0918> <-0.1199, 0.5767, -0.0939> <-0.0915, 0.5767, -0.0967> <-0.0701, 0.5767, -0.0988>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0541, 0.3760, -0.1438> <-0.0790, 0.4386, -0.1400> <-0.1151, 0.5165, -0.1074> <-0.1413, 0.5767, -0.0918>
		<-0.0298, 0.3782, -0.1444> <-0.0548, 0.4408, -0.1405> <-0.0938, 0.5165, -0.1095> <-0.1199, 0.5767, -0.0939>
		<0.0053, 0.3833, -0.1341> <-0.0173, 0.4456, -0.1309> <-0.0624, 0.5187, -0.1108> <-0.0915, 0.5767, -0.0967>
		<0.0267, 0.3833, -0.1458> <0.0041, 0.4456, -0.1425> <-0.0410, 0.5187, -0.1129> <-0.0701, 0.5767, -0.0988>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0541, 0.3760, -0.1438> <-0.0122, 0.2708, -0.1503> <0.0494, 0.1307, -0.1436> <0.0793, 0.0227, -0.1260>
		<-0.0298, 0.3782, -0.1444> <0.0120, 0.2730, -0.1509> <0.0651, 0.1307, -0.1441> <0.0949, 0.0227, -0.1265>
		<0.0053, 0.3833, -0.1341> <0.0438, 0.2775, -0.1396> <0.1014, 0.1329, -0.1386> <0.1173, 0.0227, -0.1207>
		<0.0267, 0.3833, -0.1458> <0.0652, 0.2775, -0.1512> <0.1154, 0.1329, -0.1454> <0.1313, 0.0227, -0.1275>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0267, 0.3833, -0.1458> <0.0652, 0.2775, -0.1512> <0.1154, 0.1329, -0.1454> <0.1313, 0.0227, -0.1275>
		<0.0370, 0.3833, -0.1513> <0.0755, 0.2775, -0.1568> <0.1213, 0.1329, -0.1483> <0.1372, 0.0227, -0.1304>
		<0.0115, 0.3768, -0.1695> <0.0490, 0.2709, -0.1790> <0.1093, 0.1309, -0.1681> <0.1319, 0.0227, -0.1460>
		<0.0006, 0.3760, -0.1737> <0.0381, 0.2701, -0.1832> <0.1033, 0.1309, -0.1708> <0.1259, 0.0227, -0.1487>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0267, 0.3833, -0.1458> <0.0370, 0.3833, -0.1513> <0.0115, 0.3768, -0.1695> <0.0006, 0.3760, -0.1737>
		<0.0267, 0.3833, -0.1458> <0.0143, 0.4456, -0.1481> <-0.0110, 0.4404, -0.1638> <-0.0218, 0.4395, -0.1679>
		<0.0267, 0.3833, -0.1458> <0.0143, 0.4456, -0.1481> <-0.0198, 0.4585, -0.1353> <-0.0489, 0.5165, -0.1212>
		<0.0267, 0.3833, -0.1458> <0.0041, 0.4456, -0.1425> <-0.0410, 0.5187, -0.1129> <-0.0701, 0.5767, -0.0988>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0006, 0.3760, -0.1737> <0.0381, 0.2701, -0.1832> <0.1033, 0.1309, -0.1708> <0.1259, 0.0227, -0.1487>
		<-0.0194, 0.3744, -0.1813> <0.0181, 0.2686, -0.1908> <0.0876, 0.1309, -0.1779> <0.1102, 0.0227, -0.1558>
		<-0.0490, 0.3760, -0.1853> <-0.0087, 0.2698, -0.1975> <0.0536, 0.1297, -0.1809> <0.0860, 0.0227, -0.1577>
		<-0.0703, 0.3760, -0.1828> <-0.0301, 0.2698, -0.1951> <0.0365, 0.1297, -0.1789> <0.0688, 0.0227, -0.1557>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0006, 0.3760, -0.1737> <-0.0194, 0.3744, -0.1813> <-0.0490, 0.3760, -0.1853> <-0.0703, 0.3760, -0.1828>
		<-0.0218, 0.4395, -0.1679> <-0.0418, 0.4380, -0.1756> <-0.0735, 0.4405, -0.1778> <-0.0948, 0.4405, -0.1754>
		<-0.0489, 0.5165, -0.1212> <-0.0702, 0.5165, -0.1192> <-0.0986, 0.5165, -0.1212> <-0.1200, 0.5165, -0.1191>
		<-0.0701, 0.5767, -0.0988> <-0.0915, 0.5767, -0.0967> <-0.1199, 0.5767, -0.0939> <-0.1413, 0.5767, -0.0918>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0006, 0.3760, -0.1737> <-0.0218, 0.4395, -0.1679> <-0.0489, 0.5165, -0.1212> <-0.0701, 0.5767, -0.0988>
		<-0.0194, 0.3744, -0.1813> <-0.0418, 0.4380, -0.1756> <-0.0702, 0.5165, -0.1192> <-0.0915, 0.5767, -0.0967>
		<-0.0490, 0.3760, -0.1853> <-0.0735, 0.4405, -0.1778> <-0.0986, 0.5165, -0.1212> <-0.1199, 0.5767, -0.0939>
		<-0.0703, 0.3760, -0.1828> <-0.0948, 0.4405, -0.1754> <-0.1200, 0.5165, -0.1191> <-0.1413, 0.5767, -0.0918>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0703, 0.3760, -0.1828> <-0.0815, 0.3760, -0.1815> <-0.0903, 0.3759, -0.1624> <-0.1016, 0.3760, -0.1619>
		<-0.0948, 0.4405, -0.1754> <-0.1060, 0.4405, -0.1741> <-0.1190, 0.4410, -0.1547> <-0.1303, 0.4410, -0.1542>
		<-0.1200, 0.5165, -0.1191> <-0.1364, 0.5165, -0.1138> <-0.1512, 0.5165, -0.1058> <-0.1675, 0.5165, -0.1005>
		<-0.1413, 0.5767, -0.0918> <-0.1577, 0.5767, -0.0865> <-0.1795, 0.5767, -0.0794> <-0.1958, 0.5767, -0.0742>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0703, 0.3760, -0.1828> <-0.0301, 0.2698, -0.1951> <0.0365, 0.1297, -0.1789> <0.0688, 0.0227, -0.1557>
		<-0.0815, 0.3760, -0.1815> <-0.0413, 0.2698, -0.1938> <0.0288, 0.1297, -0.1781> <0.0612, 0.0227, -0.1548>
		<-0.0903, 0.3759, -0.1624> <-0.0440, 0.2710, -0.1748> <0.0186, 0.1298, -0.1603> <0.0564, 0.0226, -0.1402>
		<-0.1016, 0.3760, -0.1619> <-0.0553, 0.2710, -0.1743> <0.0109, 0.1298, -0.1599> <0.0487, 0.0227, -0.1398>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1016, 0.3760, -0.1619> <-0.0553, 0.2710, -0.1743> <0.0109, 0.1298, -0.1599> <0.0487, 0.0227, -0.1398>
		<-0.1138, 0.3760, -0.1614> <-0.0675, 0.2711, -0.1738> <0.0028, 0.1299, -0.1595> <0.0405, 0.0228, -0.1394>
		<-0.1268, 0.3763, -0.1843> <-0.0837, 0.2686, -0.1997> <-0.0103, 0.1293, -0.1762> <0.0333, 0.0231, -0.1535>
		<-0.1381, 0.3764, -0.1798> <-0.0951, 0.2687, -0.1953> <-0.0184, 0.1293, -0.1760> <0.0252, 0.0231, -0.1534>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1016, 0.3760, -0.1619> <-0.1138, 0.3760, -0.1614> <-0.1268, 0.3763, -0.1843> <-0.1381, 0.3764, -0.1798>
		<-0.1016, 0.3760, -0.1619> <-0.1425, 0.4411, -0.1537> <-0.1525, 0.4409, -0.1751> <-0.1639, 0.4409, -0.1706>
		<-0.1016, 0.3760, -0.1619> <-0.1425, 0.4411, -0.1537> <-0.1502, 0.4564, -0.1322> <-0.1785, 0.5166, -0.1059>
		<-0.1016, 0.3760, -0.1619> <-0.1303, 0.4410, -0.1542> <-0.1675, 0.5165, -0.1005> <-0.1958, 0.5767, -0.0742>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1381, 0.3764, -0.1798> <-0.1649, 0.3765, -0.1692> <-0.1944, 0.3912, -0.1358> <-0.2120, 0.3764, -0.1183>
		<-0.1639, 0.4409, -0.1706> <-0.1907, 0.4410, -0.1600> <-0.2092, 0.4511, -0.1311> <-0.2268, 0.4363, -0.1137>
		<-0.1785, 0.5166, -0.1059> <-0.1959, 0.5167, -0.1120> <-0.2484, 0.5185, -0.1303> <-0.2646, 0.5231, -0.1229>
		<-0.1958, 0.5767, -0.0742> <-0.2132, 0.5768, -0.0802> <-0.2375, 0.5724, -0.1019> <-0.2537, 0.5770, -0.0945>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1381, 0.3764, -0.1798> <-0.0951, 0.2687, -0.1953> <-0.0184, 0.1293, -0.1760> <0.0252, 0.0231, -0.1534>
		<-0.1649, 0.3765, -0.1692> <-0.1219, 0.2688, -0.1847> <-0.0612, 0.1294, -0.1754> <-0.0176, 0.0233, -0.1528>
		<-0.1944, 0.3912, -0.1358> <-0.1680, 0.2848, -0.1440> <-0.1140, 0.1260, -0.1598> <-0.0763, 0.0230, -0.1522>
		<-0.2120, 0.3764, -0.1183> <-0.1856, 0.2700, -0.1265> <-0.1541, 0.1261, -0.1449> <-0.1164, 0.0231, -0.1374>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2120, 0.3764, -0.1183> <-0.1856, 0.2700, -0.1265> <-0.1541, 0.1261, -0.1449> <-0.1164, 0.0231, -0.1374>
		<-0.2458, 0.3480, -0.0847> <-0.2194, 0.2416, -0.0929> <-0.1898, 0.1263, -0.1317> <-0.1522, 0.0233, -0.1241>
		<-0.2791, 0.2724, -0.0656> <-0.2683, 0.2027, -0.0705> <-0.2429, 0.0827, -0.0922> <-0.2041, 0.0238, -0.0976>
		<-0.2969, 0.2430, -0.0220> <-0.2861, 0.1733, -0.0269> <-0.2581, 0.0830, -0.0572> <-0.2194, 0.0242, -0.0626>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2120, 0.3764, -0.1183> <-0.2458, 0.3480, -0.0847> <-0.2791, 0.2724, -0.0656> <-0.2969, 0.2430, -0.0220>
		<-0.2268, 0.4363, -0.1137> <-0.2607, 0.4079, -0.0800> <-0.2958, 0.3809, -0.0581> <-0.3136, 0.3514, -0.0145>
		<-0.2646, 0.5231, -0.1229> <-0.2903, 0.5305, -0.1112> <-0.3370, 0.4991, -0.0599> <-0.3458, 0.5061, -0.0330>
		<-0.2537, 0.5770, -0.0945> <-0.2794, 0.5844, -0.0827> <-0.3010, 0.6025, -0.0489> <-0.3097, 0.6094, -0.0220>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2969, 0.2430, -0.0220> <-0.2861, 0.1733, -0.0269> <-0.2581, 0.0830, -0.0572> <-0.2194, 0.0242, -0.0626>
		<-0.3065, 0.2271, 0.0015> <-0.2957, 0.1574, -0.0034> <-0.2755, 0.0834, -0.0173> <-0.2367, 0.0245, -0.0227>
		<-0.3013, 0.2302, 0.0528> <-0.2900, 0.1612, 0.0534> <-0.2710, 0.0830, 0.0512> <-0.2328, 0.0249, 0.0442>
		<-0.2919, 0.2440, 0.0776> <-0.2806, 0.1750, 0.0782> <-0.2502, 0.0833, 0.0895> <-0.2121, 0.0252, 0.0825>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2969, 0.2430, -0.0220> <-0.3065, 0.2271, 0.0015> <-0.3013, 0.2302, 0.0528> <-0.2919, 0.2440, 0.0776>
		<-0.3136, 0.3514, -0.0145> <-0.3232, 0.3356, 0.0090> <-0.3196, 0.3421, 0.0519> <-0.3102, 0.3559, 0.0767>
		<-0.3458, 0.5061, -0.0330> <-0.3548, 0.5133, -0.0052> <-0.3674, 0.5192, 0.0562> <-0.3537, 0.5172, 0.0830>
		<-0.3097, 0.6094, -0.0220> <-0.3188, 0.6166, 0.0058> <-0.3232, 0.6235, 0.0509> <-0.3096, 0.6215, 0.0776>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0289, 0.6401, 0.0581> <-0.0181, 0.6378, 0.0580> <-0.0807, 0.6346, 0.0579> <-0.1277, 0.6323, 0.0578>
		<-0.0113, 0.6296, 0.0915> <-0.0582, 0.6272, 0.0914> <-0.0497, 0.6263, 0.0870> <-0.0966, 0.6240, 0.0869>
		<0.1351, 0.6364, 0.1468> <0.0254, 0.6321, 0.1593> <-0.0933, 0.6245, 0.1683> <-0.2014, 0.6306, 0.1461>
		<0.1564, 0.5954, 0.1734> <0.0467, 0.5911, 0.1859> <-0.1039, 0.5893, 0.1913> <-0.2120, 0.5954, 0.1690>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0289, 0.6401, 0.0581> <0.0750, 0.6522, 0.0198> <0.1942, 0.6665, 0.1113> <0.2210, 0.6123, 0.1197>
		<0.0303, 0.6371, 0.0364> <0.0763, 0.6492, -0.0019> <0.2129, 0.6699, 0.0654> <0.2396, 0.6156, 0.0739>
		<0.0321, 0.6330, 0.0075> <0.0892, 0.6376, 0.0366> <0.2369, 0.6697, 0.0042> <0.2680, 0.6136, -0.0001>
		<0.0334, 0.6300, -0.0142> <0.0906, 0.6345, 0.0149> <0.2137, 0.6674, -0.0396> <0.2448, 0.6113, -0.0440>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0289, 0.6401, 0.0581> <-0.0113, 0.6296, 0.0915> <0.1351, 0.6364, 0.1468> <0.1564, 0.5954, 0.1734>
		<0.0289, 0.6401, 0.0581> <0.0348, 0.6417, 0.0532> <0.1606, 0.6374, 0.1439> <0.1819, 0.5964, 0.1705>
		<0.0289, 0.6401, 0.0581> <0.0348, 0.6417, 0.0532> <0.1846, 0.6648, 0.1350> <0.2113, 0.6105, 0.1435>
		<0.0289, 0.6401, 0.0581> <0.0750, 0.6522, 0.0198> <0.1942, 0.6665, 0.1113> <0.2210, 0.6123, 0.1197>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0334, 0.6300, -0.0142> <-0.0003, 0.6273, -0.0314> <0.0798, 0.6306, -0.1051> <0.0941, 0.5992, -0.1208>
		<-0.0013, 0.6281, -0.0211> <-0.0350, 0.6254, -0.0383> <0.0091, 0.6243, -0.1138> <0.0235, 0.5929, -0.1296>
		<-0.0476, 0.6255, -0.0304> <-0.0754, 0.6255, -0.0276> <-0.0429, 0.5834, -0.1033> <-0.0707, 0.5834, -0.1005>
		<-0.0824, 0.6236, -0.0373> <-0.1101, 0.6236, -0.0346> <-0.1136, 0.5767, -0.0946> <-0.1413, 0.5767, -0.0918>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0334, 0.6300, -0.0142> <0.0906, 0.6345, 0.0149> <0.2137, 0.6674, -0.0396> <0.2448, 0.6113, -0.0440>
		<0.0334, 0.6300, -0.0142> <0.0569, 0.6318, -0.0023> <0.1900, 0.6649, -0.0846> <0.2211, 0.6088, -0.0889>
		<0.0334, 0.6300, -0.0142> <0.0569, 0.6318, -0.0023> <0.1301, 0.6351, -0.0988> <0.1444, 0.6037, -0.1146>
		<0.0334, 0.6300, -0.0142> <-0.0003, 0.6273, -0.0314> <0.0798, 0.6306, -0.1051> <0.0941, 0.5992, -0.1208>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0824, 0.6236, -0.0373> <-0.1101, 0.6236, -0.0346> <-0.1136, 0.5767, -0.0946> <-0.1413, 0.5767, -0.0918>
		<-0.0824, 0.6236, -0.0373> <-0.1308, 0.6236, -0.0325> <-0.1368, 0.5767, -0.0923> <-0.1646, 0.5767, -0.0895>
		<-0.0824, 0.6236, -0.0373> <-0.1308, 0.6236, -0.0325> <-0.1083, 0.6236, -0.0396> <-0.1290, 0.6236, -0.0375>
		<-0.0824, 0.6236, -0.0373> <-0.1030, 0.6236, -0.0352> <-0.1306, 0.6236, -0.0324> <-0.1512, 0.6236, -0.0303>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0824, 0.6236, -0.0373> <-0.1101, 0.6236, -0.0346> <-0.1136, 0.5767, -0.0946> <-0.1413, 0.5767, -0.0918>
		<-0.0824, 0.6236, -0.0373> <-0.0868, 0.6236, -0.0368> <-0.0922, 0.5767, -0.0967> <-0.1199, 0.5767, -0.0939>
		<-0.0824, 0.6236, -0.0373> <-0.0868, 0.6236, -0.0368> <-0.0951, 0.5908, -0.0782> <-0.0915, 0.5767, -0.0967>
		<-0.0824, 0.6236, -0.0373> <-0.0590, 0.6236, -0.0396> <-0.0738, 0.5908, -0.0803> <-0.0701, 0.5767, -0.0988>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0824, 0.6236, -0.0373> <-0.0590, 0.6236, -0.0396> <-0.0738, 0.5908, -0.0803> <-0.0701, 0.5767, -0.0988>
		<-0.0824, 0.6236, -0.0373> <-0.0868, 0.6236, -0.0368> <-0.0951, 0.5908, -0.0782> <-0.0915, 0.5767, -0.0967>
		<-0.0824, 0.6236, -0.0373> <-0.0868, 0.6236, -0.0368> <-0.0922, 0.5767, -0.0967> <-0.1199, 0.5767, -0.0939>
		<-0.0824, 0.6236, -0.0373> <-0.1101, 0.6236, -0.0346> <-0.1136, 0.5767, -0.0946> <-0.1413, 0.5767, -0.0918>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1512, 0.6236, -0.0303> <-0.1735, 0.6236, -0.0231> <-0.1824, 0.5908, -0.0610> <-0.1958, 0.5767, -0.0742>
		<-0.1535, 0.6282, -0.0152> <-0.1758, 0.6282, -0.0080> <-0.1998, 0.5909, -0.0671> <-0.2132, 0.5768, -0.0802>
		<-0.1566, 0.6342, 0.0050> <-0.1287, 0.6181, -0.0311> <-0.2290, 0.6144, -0.0797> <-0.2375, 0.5724, -0.1019>
		<-0.1589, 0.6388, 0.0201> <-0.1310, 0.6227, -0.0160> <-0.2452, 0.6191, -0.0723> <-0.2537, 0.5770, -0.0945>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1512, 0.6236, -0.0303> <-0.1290, 0.6236, -0.0375> <-0.1646, 0.5767, -0.0895> <-0.1413, 0.5767, -0.0918>
		<-0.1512, 0.6236, -0.0303> <-0.1513, 0.6236, -0.0303> <-0.1809, 0.5767, -0.0842> <-0.1577, 0.5767, -0.0865>
		<-0.1512, 0.6236, -0.0303> <-0.1513, 0.6236, -0.0303> <-0.1661, 0.5908, -0.0663> <-0.1795, 0.5767, -0.0794>
		<-0.1512, 0.6236, -0.0303> <-0.1735, 0.6236, -0.0231> <-0.1824, 0.5908, -0.0610> <-0.1958, 0.5767, -0.0742>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1589, 0.6388, 0.0201> <-0.1864, 0.6548, 0.0557> <-0.2941, 0.6543, -0.0173> <-0.3097, 0.6094, -0.0220>
		<-0.1495, 0.6368, 0.0314> <-0.1771, 0.6528, 0.0671> <-0.3031, 0.6615, 0.0106> <-0.3188, 0.6166, 0.0058>
		<-0.1370, 0.6342, 0.0465> <-0.1764, 0.6448, 0.0096> <-0.3018, 0.6740, 0.0483> <-0.3232, 0.6235, 0.0509>
		<-0.1277, 0.6323, 0.0578> <-0.1670, 0.6428, 0.0209> <-0.2882, 0.6721, 0.0751> <-0.3096, 0.6215, 0.0776>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1589, 0.6388, 0.0201> <-0.1310, 0.6227, -0.0160> <-0.2452, 0.6191, -0.0723> <-0.2537, 0.5770, -0.0945>
		<-0.1589, 0.6388, 0.0201> <-0.1586, 0.6386, 0.0197> <-0.2709, 0.6265, -0.0606> <-0.2794, 0.5844, -0.0827>
		<-0.1589, 0.6388, 0.0201> <-0.1586, 0.6386, 0.0197> <-0.2853, 0.6474, -0.0442> <-0.3010, 0.6025, -0.0489>
		<-0.1589, 0.6388, 0.0201> <-0.1864, 0.6548, 0.0557> <-0.2941, 0.6543, -0.0173> <-0.3097, 0.6094, -0.0220>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1277, 0.6323, 0.0578> <-0.1670, 0.6428, 0.0209> <-0.2882, 0.6721, 0.0751> <-0.3096, 0.6215, 0.0776>
		<-0.1277, 0.6323, 0.0578> <-0.1360, 0.6345, 0.0500> <-0.2696, 0.6694, 0.1114> <-0.2910, 0.6188, 0.1139>
		<-0.1277, 0.6323, 0.0578> <-0.1360, 0.6345, 0.0500> <-0.2414, 0.6328, 0.1379> <-0.2520, 0.5976, 0.1608>
		<-0.1277, 0.6323, 0.0578> <-0.0966, 0.6240, 0.0869> <-0.2014, 0.6306, 0.1461> <-0.2120, 0.5954, 0.1690>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0685, 0.0112, 0.0945> <-0.0786, 0.0155, 0.1121> <-0.0954, 0.0071, 0.1467> <-0.1023, 0.0256, 0.1532>
		<-0.0925, 0.0111, 0.0875> <-0.1027, 0.0155, 0.1051> <-0.1330, 0.0070, 0.1358> <-0.1399, 0.0255, 0.1422>
		<-0.1267, 0.0110, 0.0713> <-0.1487, 0.0153, 0.0812> <-0.1800, 0.0050, 0.1144> <-0.1934, 0.0254, 0.1169>
		<-0.1387, 0.0108, 0.0493> <-0.1607, 0.0151, 0.0592> <-0.1987, 0.0048, 0.0800> <-0.2121, 0.0252, 0.0825>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0685, 0.0112, 0.0945> <-0.0395, 0.0113, 0.1029> <0.0027, 0.0113, 0.1057> <0.0322, 0.0112, 0.0991>
		<-0.0786, 0.0155, 0.1121> <-0.0496, 0.0156, 0.1206> <0.0096, 0.0156, 0.1241> <0.0391, 0.0155, 0.1175>
		<-0.0954, 0.0071, 0.1467> <-0.0500, 0.0071, 0.1600> <0.0026, 0.0077, 0.1645> <0.0488, 0.0076, 0.1542>
		<-0.1023, 0.0256, 0.1532> <-0.0568, 0.0257, 0.1665> <0.0091, 0.0257, 0.1708> <0.0553, 0.0256, 0.1604>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0322, 0.0112, 0.0991> <0.0559, 0.0111, 0.0938> <0.0886, 0.0110, 0.0774> <0.1012, 0.0108, 0.0565>
		<0.0391, 0.0155, 0.1175> <0.0629, 0.0155, 0.1122> <0.1073, 0.0153, 0.0885> <0.1199, 0.0151, 0.0677>
		<0.0488, 0.0076, 0.1542> <0.0860, 0.0075, 0.1459> <0.1336, 0.0063, 0.1212> <0.1534, 0.0061, 0.0887>
		<0.0553, 0.0256, 0.1604> <0.0925, 0.0255, 0.1521> <0.1437, 0.0254, 0.1264> <0.1634, 0.0252, 0.0938>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1012, 0.0108, 0.0565> <0.1153, 0.0105, 0.0333> <0.1161, 0.0102, -0.0064> <0.1123, 0.0097, -0.0333>
		<0.1199, 0.0151, 0.0677> <0.1340, 0.0148, 0.0445> <0.1366, 0.0145, -0.0104> <0.1329, 0.0141, -0.0373>
		<0.1534, 0.0061, 0.0887> <0.1754, 0.0059, 0.0523> <0.1759, 0.0061, -0.0038> <0.1700, 0.0057, -0.0459>
		<0.1634, 0.0252, 0.0938> <0.1854, 0.0249, 0.0575> <0.1866, 0.0246, -0.0046> <0.1808, 0.0242, -0.0467>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1123, 0.0097, -0.0333> <0.1103, 0.0095, -0.0478> <0.0949, 0.0090, -0.0637> <0.0833, 0.0087, -0.0728>
		<0.1329, 0.0141, -0.0373> <0.1309, 0.0138, -0.0519> <0.1105, 0.0133, -0.0745> <0.0989, 0.0130, -0.0835>
		<0.1700, 0.0057, -0.0459> <0.1669, 0.0055, -0.0687> <0.1501, 0.0046, -0.0909> <0.1320, 0.0043, -0.1050>
		<0.1808, 0.0242, -0.0467> <0.1776, 0.0239, -0.0695> <0.1535, 0.0234, -0.0944> <0.1354, 0.0231, -0.1086>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0833, 0.0087, -0.0728> <0.0745, 0.0085, -0.0797> <0.0582, 0.0084, -0.0806> <0.0475, 0.0083, -0.0839>
		<0.0989, 0.0130, -0.0835> <0.0901, 0.0128, -0.0905> <0.0678, 0.0128, -0.0932> <0.0570, 0.0126, -0.0966>
		<0.1320, 0.0043, -0.1050> <0.1181, 0.0041, -0.1159> <0.1004, 0.0072, -0.1183> <0.0836, 0.0071, -0.1235>
		<0.1354, 0.0231, -0.1086> <0.1215, 0.0229, -0.1194> <0.0961, 0.0228, -0.1208> <0.0793, 0.0227, -0.1260>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0475, 0.0083, -0.0839> <0.0575, 0.0083, -0.0842> <0.0718, 0.0083, -0.0805> <0.0807, 0.0083, -0.0849>
		<0.0570, 0.0126, -0.0966> <0.0670, 0.0126, -0.0969> <0.0869, 0.0126, -0.0933> <0.0959, 0.0126, -0.0977>
		<0.0836, 0.0071, -0.1235> <0.0992, 0.0071, -0.1239> <0.1201, 0.0029, -0.1175> <0.1342, 0.0029, -0.1243>
		<0.0793, 0.0227, -0.1260> <0.0949, 0.0227, -0.1265> <0.1173, 0.0227, -0.1207> <0.1313, 0.0227, -0.1275>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0807, 0.0083, -0.0849> <0.0845, 0.0083, -0.0867> <0.0811, 0.0083, -0.0967> <0.0773, 0.0083, -0.0984>
		<0.0959, 0.0126, -0.0977> <0.0997, 0.0126, -0.0995> <0.0957, 0.0126, -0.1118> <0.0919, 0.0126, -0.1135>
		<0.1342, 0.0029, -0.1243> <0.1401, 0.0029, -0.1272> <0.1362, 0.0022, -0.1418> <0.1302, 0.0022, -0.1445>
		<0.1313, 0.0227, -0.1275> <0.1372, 0.0227, -0.1304> <0.1319, 0.0227, -0.1460> <0.1259, 0.0227, -0.1487>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0773, 0.0083, -0.0984> <0.0672, 0.0083, -0.1030> <0.0518, 0.0083, -0.1041> <0.0408, 0.0083, -0.1029>
		<0.0919, 0.0126, -0.1135> <0.0818, 0.0126, -0.1180> <0.0602, 0.0126, -0.1200> <0.0492, 0.0126, -0.1187>
		<0.1302, 0.0022, -0.1445> <0.1145, 0.0022, -0.1516> <0.0912, 0.0054, -0.1539> <0.0741, 0.0054, -0.1519>
		<0.1259, 0.0227, -0.1487> <0.1102, 0.0227, -0.1558> <0.0860, 0.0227, -0.1577> <0.0688, 0.0227, -0.1557>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0408, 0.0083, -0.1029> <0.0359, 0.0083, -0.1023> <0.0329, 0.0082, -0.0930> <0.0279, 0.0083, -0.0927>
		<0.0492, 0.0126, -0.1187> <0.0443, 0.0126, -0.1182> <0.0391, 0.0126, -0.1071> <0.0342, 0.0126, -0.1068>
		<0.0741, 0.0054, -0.1519> <0.0664, 0.0054, -0.1510> <0.0616, 0.0078, -0.1374> <0.0539, 0.0078, -0.1370>
		<0.0688, 0.0227, -0.1557> <0.0612, 0.0227, -0.1548> <0.0564, 0.0226, -0.1402> <0.0487, 0.0227, -0.1398>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0279, 0.0083, -0.0927> <0.0227, 0.0084, -0.0925> <0.0181, 0.0087, -0.1015> <0.0129, 0.0087, -0.1014>
		<0.0342, 0.0126, -0.1068> <0.0290, 0.0127, -0.1066> <0.0218, 0.0130, -0.1171> <0.0166, 0.0130, -0.1170>
		<0.0539, 0.0078, -0.1370> <0.0458, 0.0079, -0.1366> <0.0395, 0.0081, -0.1503> <0.0314, 0.0081, -0.1502>
		<0.0487, 0.0227, -0.1398> <0.0405, 0.0228, -0.1394> <0.0333, 0.0231, -0.1535> <0.0252, 0.0231, -0.1534>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0129, 0.0087, -0.1014> <-0.0144, 0.0088, -0.1010> <-0.0519, 0.0086, -0.1007> <-0.0775, 0.0087, -0.0912>
		<0.0166, 0.0130, -0.1170> <-0.0107, 0.0132, -0.1166> <-0.0636, 0.0129, -0.1145> <-0.0892, 0.0130, -0.1050>
		<0.0314, 0.0081, -0.1502> <-0.0114, 0.0082, -0.1496> <-0.0699, 0.0055, -0.1509> <-0.1100, 0.0057, -0.1361>
		<0.0252, 0.0231, -0.1534> <-0.0176, 0.0233, -0.1528> <-0.0763, 0.0230, -0.1522> <-0.1164, 0.0231, -0.1374>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0775, 0.0087, -0.0912> <-0.1004, 0.0089, -0.0827> <-0.1336, 0.0094, -0.0658> <-0.1433, 0.0097, -0.0434>
		<-0.0892, 0.0130, -0.1050> <-0.1121, 0.0132, -0.0965> <-0.1564, 0.0137, -0.0715> <-0.1661, 0.0141, -0.0492>
		<-0.1100, 0.0057, -0.1361> <-0.1458, 0.0059, -0.1228> <-0.1910, 0.0039, -0.0994> <-0.2062, 0.0042, -0.0644>
		<-0.1164, 0.0231, -0.1374> <-0.1522, 0.0233, -0.1241> <-0.2041, 0.0238, -0.0976> <-0.2194, 0.0242, -0.0626>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1433, 0.0097, -0.0434> <-0.1544, 0.0101, -0.0179> <-0.1519, 0.0105, 0.0248> <-0.1387, 0.0108, 0.0493>
		<-0.1661, 0.0141, -0.0492> <-0.1772, 0.0144, -0.0236> <-0.1740, 0.0148, 0.0348> <-0.1607, 0.0151, 0.0592>
		<-0.2062, 0.0042, -0.0644> <-0.2236, 0.0046, -0.0245> <-0.2194, 0.0045, 0.0417> <-0.1987, 0.0048, 0.0800>
		<-0.2194, 0.0242, -0.0626> <-0.2367, 0.0245, -0.0227> <-0.2328, 0.0249, 0.0442> <-0.2121, 0.0252, 0.0825>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.5029, 0.5284, 0.1356> <0.5016, 0.4317, 0.1356> <0.4934, 0.3184, 0.0959> <0.4957, 0.3184, -0.0007>
		<0.5145, 0.5291, 0.1371> <0.5131, 0.4325, 0.1371> <0.5191, 0.3102, 0.0959> <0.5214, 0.3102, -0.0007>
		<0.5266, 0.5450, 0.1355> <0.5357, 0.4270, 0.1355> <0.5510, 0.2912, 0.1175> <0.5538, 0.2912, -0.0007>
		<0.5382, 0.5445, 0.1356> <0.5473, 0.4265, 0.1356> <0.5700, 0.2721, 0.1175> <0.5728, 0.2721, -0.0007>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.5029, 0.5284, 0.1356> <0.4523, 0.5249, 0.1291> <0.3846, 0.5317, 0.1195> <0.3344, 0.5304, 0.1094>
		<0.5016, 0.4317, 0.1356> <0.4510, 0.4282, 0.1291> <0.3872, 0.4484, 0.1195> <0.3370, 0.4472, 0.1094>
		<0.4934, 0.3184, 0.0959> <0.4493, 0.3324, 0.0959> <0.3880, 0.3484, 0.0825> <0.3418, 0.3451, 0.0825>
		<0.4957, 0.3184, -0.0007> <0.4516, 0.3325, -0.0007> <0.3899, 0.3484, -0.0007> <0.3438, 0.3451, -0.0007>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.5029, 0.5284, 0.1356> <0.5145, 0.5291, 0.1371> <0.5266, 0.5450, 0.1355> <0.5382, 0.5445, 0.1356>
		<0.5042, 0.6209, 0.1356> <0.5157, 0.6217, 0.1371> <0.5194, 0.6372, 0.1355> <0.5311, 0.6368, 0.1356>
		<0.4991, 0.7255, 0.0918> <0.5104, 0.7284, 0.0918> <0.5235, 0.7374, 0.0918> <0.5343, 0.7417, 0.0918>
		<0.5012, 0.7256, -0.0007> <0.5125, 0.7284, -0.0007> <0.5257, 0.7374, -0.0007> <0.5365, 0.7417, -0.0007>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.5029, 0.5284, 0.1356> <0.5042, 0.6209, 0.1356> <0.4991, 0.7255, 0.0918> <0.5012, 0.7256, -0.0007>
		<0.4523, 0.5249, 0.1291> <0.4536, 0.6174, 0.1291> <0.4491, 0.7127, 0.0918> <0.4513, 0.7128, -0.0007>
		<0.3846, 0.5317, 0.1195> <0.3823, 0.6064, 0.1195> <0.3805, 0.7052, 0.0740> <0.3823, 0.7052, -0.0007>
		<0.3344, 0.5304, 0.1094> <0.3321, 0.6051, 0.1094> <0.3313, 0.6896, 0.0740> <0.3331, 0.6897, -0.0007>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.5012, 0.7256, -0.0007> <0.5125, 0.7284, -0.0007> <0.5257, 0.7374, -0.0007> <0.5365, 0.7417, -0.0007>
		<0.5034, 0.7256, -0.0933> <0.5147, 0.7285, -0.0933> <0.5279, 0.7375, -0.0933> <0.5387, 0.7418, -0.0933>
		<0.5106, 0.6210, -0.1371> <0.5221, 0.6218, -0.1386> <0.5258, 0.6374, -0.1369> <0.5375, 0.6369, -0.1371>
		<0.5093, 0.5285, -0.1371> <0.5208, 0.5293, -0.1386> <0.5330, 0.5451, -0.1369> <0.5446, 0.5447, -0.1371>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.5012, 0.7256, -0.0007> <0.5034, 0.7256, -0.0933> <0.5106, 0.6210, -0.1371> <0.5093, 0.5285, -0.1371>
		<0.4513, 0.7128, -0.0007> <0.4534, 0.7128, -0.0933> <0.4596, 0.6175, -0.1306> <0.4583, 0.5250, -0.1306>
		<0.3823, 0.7052, -0.0007> <0.3840, 0.7053, -0.0754> <0.3878, 0.6065, -0.1209> <0.3901, 0.5318, -0.1209>
		<0.3331, 0.6897, -0.0007> <0.3348, 0.6897, -0.0754> <0.3373, 0.6052, -0.1109> <0.3396, 0.5306, -0.1109>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.5093, 0.5285, -0.1371> <0.5208, 0.5293, -0.1386> <0.5330, 0.5451, -0.1369> <0.5446, 0.5447, -0.1371>
		<0.5080, 0.4317, -0.1371> <0.5195, 0.4325, -0.1386> <0.5421, 0.4274, -0.1369> <0.5537, 0.4269, -0.1371>
		<0.4980, 0.3185, -0.0975> <0.5237, 0.3103, -0.0975> <0.5565, 0.2913, -0.1188> <0.5756, 0.2722, -0.1188>
		<0.4957, 0.3184, -0.0007> <0.5214, 0.3102, -0.0007> <0.5538, 0.2912, -0.0007> <0.5728, 0.2721, -0.0007>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.5093, 0.5285, -0.1371> <0.5080, 0.4317, -0.1371> <0.4980, 0.3185, -0.0975> <0.4957, 0.3184, -0.0007>
		<0.4583, 0.5250, -0.1306> <0.4570, 0.4282, -0.1306> <0.4539, 0.3325, -0.0975> <0.4516, 0.3325, -0.0007>
		<0.3901, 0.5318, -0.1209> <0.3927, 0.4486, -0.1209> <0.3919, 0.3485, -0.0840> <0.3899, 0.3484, -0.0007>
		<0.3396, 0.5306, -0.1109> <0.3422, 0.4474, -0.1109> <0.3457, 0.3452, -0.0840> <0.3438, 0.3451, -0.0007>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.5382, 0.5445, 0.1356> <0.5473, 0.4265, 0.1356> <0.5700, 0.2721, 0.1175> <0.5728, 0.2721, -0.0007>
		<0.6223, 0.5411, 0.1363> <0.6314, 0.4232, 0.1363> <0.6505, 0.1914, 0.1175> <0.6533, 0.1915, -0.0007>
		<0.7335, 0.5251, 0.1396> <0.7363, 0.3146, 0.1396> <0.7303, 0.0614, 0.2097> <0.7380, 0.0616, -0.0007>
		<0.8171, 0.5158, 0.1382> <0.8199, 0.3052, 0.1382> <0.8175, -0.0120, 0.2097> <0.8252, -0.0118, -0.0007>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.5382, 0.5445, 0.1356> <0.6223, 0.5411, 0.1363> <0.7335, 0.5251, 0.1396> <0.8171, 0.5158, 0.1382>
		<0.5311, 0.6368, 0.1356> <0.6151, 0.6334, 0.1363> <0.7317, 0.6647, 0.1396> <0.8153, 0.6554, 0.1382>
		<0.5343, 0.7417, 0.0918> <0.6174, 0.7747, 0.0918> <0.7216, 0.8306, 0.1388> <0.8089, 0.8497, 0.1388>
		<0.5365, 0.7417, -0.0007> <0.6195, 0.7747, -0.0007> <0.7267, 0.8307, -0.0007> <0.8140, 0.8498, -0.0007>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.5365, 0.7417, -0.0007> <0.6195, 0.7747, -0.0007> <0.7267, 0.8307, -0.0007> <0.8140, 0.8498, -0.0007>
		<0.5387, 0.7418, -0.0933> <0.6217, 0.7748, -0.0933> <0.7319, 0.8309, -0.1411> <0.8191, 0.8500, -0.1411>
		<0.5375, 0.6369, -0.1371> <0.6227, 0.6336, -0.1392> <0.7408, 0.6658, -0.1448> <0.8256, 0.6564, -0.1448>
		<0.5446, 0.5447, -0.1371> <0.6298, 0.5413, -0.1392> <0.7427, 0.5253, -0.1448> <0.8275, 0.5160, -0.1448>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.5446, 0.5447, -0.1371> <0.6298, 0.5413, -0.1392> <0.7427, 0.5253, -0.1448> <0.8275, 0.5160, -0.1448>
		<0.5537, 0.4269, -0.1371> <0.6389, 0.4236, -0.1392> <0.7454, 0.3142, -0.1448> <0.8302, 0.3049, -0.1448>
		<0.5756, 0.2722, -0.1188> <0.6561, 0.1915, -0.1188> <0.7457, 0.0618, -0.2117> <0.8329, -0.0116, -0.2118>
		<0.5728, 0.2721, -0.0007> <0.6533, 0.1915, -0.0007> <0.7380, 0.0616, -0.0007> <0.8252, -0.0118, -0.0007>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2090, 0.5211, 0.0765> <0.2158, 0.4303, 0.0765> <0.2309, 0.2995, 0.0902> <0.2330, 0.2996, -0.0007>
		<0.2466, 0.5239, 0.0863> <0.2534, 0.4331, 0.0863> <0.2641, 0.3132, 0.0902> <0.2662, 0.3132, -0.0007>
		<0.2962, 0.5295, 0.1017> <0.2988, 0.4463, 0.1017> <0.3060, 0.3425, 0.0825> <0.3079, 0.3426, -0.0007>
		<0.3344, 0.5304, 0.1094> <0.3370, 0.4472, 0.1094> <0.3418, 0.3451, 0.0825> <0.3438, 0.3451, -0.0007>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2090, 0.5211, 0.0765> <0.2466, 0.5239, 0.0863> <0.2962, 0.5295, 0.1017> <0.3344, 0.5304, 0.1094>
		<0.2051, 0.5733, 0.0765> <0.2427, 0.5761, 0.0863> <0.2939, 0.6042, 0.1017> <0.3321, 0.6051, 0.1094>
		<0.2068, 0.6327, 0.0516> <0.2443, 0.6498, 0.0516> <0.2920, 0.6772, 0.0740> <0.3313, 0.6896, 0.0740>
		<0.2081, 0.6327, -0.0007> <0.2456, 0.6498, -0.0007> <0.2938, 0.6772, -0.0007> <0.3331, 0.6897, -0.0007>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2081, 0.6327, -0.0007> <0.2456, 0.6498, -0.0007> <0.2938, 0.6772, -0.0007> <0.3331, 0.6897, -0.0007>
		<0.2093, 0.6328, -0.0531> <0.2468, 0.6498, -0.0531> <0.2955, 0.6773, -0.0754> <0.3348, 0.6897, -0.0754>
		<0.2087, 0.5734, -0.0780> <0.2468, 0.5762, -0.0878> <0.2986, 0.6043, -0.1032> <0.3373, 0.6052, -0.1109>
		<0.2126, 0.5212, -0.0780> <0.2507, 0.5240, -0.0878> <0.3009, 0.5296, -0.1032> <0.3396, 0.5306, -0.1109>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2126, 0.5212, -0.0780> <0.2507, 0.5240, -0.0878> <0.3009, 0.5296, -0.1032> <0.3396, 0.5306, -0.1109>
		<0.2194, 0.4305, -0.0780> <0.2575, 0.4333, -0.0878> <0.3035, 0.4464, -0.1032> <0.3422, 0.4474, -0.1109>
		<0.2351, 0.2996, -0.0916> <0.2684, 0.3133, -0.0916> <0.3099, 0.3426, -0.0840> <0.3457, 0.3452, -0.0840>
		<0.2330, 0.2996, -0.0007> <0.2662, 0.3132, -0.0007> <0.3079, 0.3426, -0.0007> <0.3438, 0.3451, -0.0007>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.8171, 0.5158, 0.1382> <0.8199, 0.3052, 0.1382> <0.8175, -0.0120, 0.2097> <0.8252, -0.0118, -0.0007>
		<0.8242, 0.5150, 0.1381> <0.8270, 0.3044, 0.1381> <0.8308, -0.0232, 0.2097> <0.8385, -0.0230, -0.0008>
		<0.8463, 0.5111, 0.1314> <0.8484, 0.3233, 0.1314> <0.8488, 0.0283, 0.1868> <0.8560, 0.0285, -0.0008>
		<0.8392, 0.5109, 0.1308> <0.8413, 0.3231, 0.1308> <0.8385, 0.0424, 0.1868> <0.8458, 0.0426, -0.0008>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.8171, 0.5158, 0.1382> <0.8242, 0.5150, 0.1381> <0.8463, 0.5111, 0.1314> <0.8392, 0.5109, 0.1308>
		<0.8153, 0.6554, 0.1382> <0.8224, 0.6546, 0.1381> <0.8448, 0.6363, 0.1314> <0.8377, 0.6361, 0.1308>
		<0.8089, 0.8497, 0.1388> <0.8231, 0.8528, 0.1388> <0.8450, 0.8140, 0.1243> <0.8322, 0.8073, 0.1243>
		<0.8140, 0.8498, -0.0007> <0.8282, 0.8529, -0.0008> <0.8498, 0.8141, -0.0008> <0.8370, 0.8074, -0.0008>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.8140, 0.8498, -0.0007> <0.8282, 0.8529, -0.0008> <0.8498, 0.8141, -0.0008> <0.8370, 0.8074, -0.0008>
		<0.8191, 0.8500, -0.1411> <0.8333, 0.8530, -0.1411> <0.8547, 0.8142, -0.1267> <0.8418, 0.8076, -0.1267>
		<0.8256, 0.6564, -0.1448> <0.8328, 0.6556, -0.1448> <0.8552, 0.6373, -0.1379> <0.8481, 0.6371, -0.1372>
		<0.8275, 0.5160, -0.1448> <0.8346, 0.5152, -0.1448> <0.8566, 0.5113, -0.1379> <0.8495, 0.5111, -0.1372>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.8275, 0.5160, -0.1448> <0.8346, 0.5152, -0.1448> <0.8566, 0.5113, -0.1379> <0.8495, 0.5111, -0.1372>
		<0.8302, 0.3049, -0.1448> <0.8373, 0.3041, -0.1448> <0.8588, 0.3230, -0.1379> <0.8517, 0.3228, -0.1372>
		<0.8329, -0.0116, -0.2118> <0.8462, -0.0228, -0.2118> <0.8633, 0.0287, -0.1890> <0.8530, 0.0427, -0.1890>
		<0.8252, -0.0118, -0.0007> <0.8385, -0.0230, -0.0008> <0.8560, 0.0285, -0.0008> <0.8458, 0.0426, -0.0008>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.5704, 0.5086, 0.1154> <0.6510, 0.5093, 0.1200> <0.7588, 0.5086, 0.1233> <0.8392, 0.5109, 0.1308>
		<0.5774, 0.4001, 0.1154> <0.6580, 0.4007, 0.1200> <0.7609, 0.3208, 0.1233> <0.8413, 0.3231, 0.1308>
		<0.6243, 0.2584, 0.1078> <0.6895, 0.1936, 0.1078> <0.7844, 0.1167, 0.1867> <0.8385, 0.0424, 0.1868>
		<0.6285, 0.2585, -0.0010> <0.6937, 0.1937, -0.0009> <0.7917, 0.1169, -0.0009> <0.8458, 0.0426, -0.0008>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.5704, 0.5086, 0.1154> <0.5639, 0.6080, 0.1154> <0.5936, 0.7371, 0.0985> <0.5975, 0.7372, -0.0010>
		<0.6510, 0.5093, 0.1200> <0.6446, 0.6086, 0.1200> <0.6655, 0.7582, 0.0986> <0.6693, 0.7583, -0.0009>
		<0.7588, 0.5086, 0.1233> <0.7573, 0.6338, 0.1233> <0.7657, 0.7728, 0.1242> <0.7705, 0.7729, -0.0009>
		<0.8392, 0.5109, 0.1308> <0.8377, 0.6361, 0.1308> <0.8322, 0.8073, 0.1243> <0.8370, 0.8074, -0.0008>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.5975, 0.7372, -0.0010> <0.6013, 0.7373, -0.1008> <0.5731, 0.6086, -0.1216> <0.5795, 0.5089, -0.1216>
		<0.6693, 0.7583, -0.0009> <0.6732, 0.7584, -0.1007> <0.6541, 0.6092, -0.1263> <0.6605, 0.5095, -0.1263>
		<0.7705, 0.7729, -0.0009> <0.7754, 0.7730, -0.1268> <0.7673, 0.6348, -0.1296> <0.7688, 0.5088, -0.1296>
		<0.8370, 0.8074, -0.0008> <0.8418, 0.8076, -0.1267> <0.8481, 0.6371, -0.1372> <0.8495, 0.5111, -0.1372>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.5795, 0.5089, -0.1216> <0.5866, 0.4002, -0.1216> <0.6327, 0.2586, -0.1098> <0.6285, 0.2585, -0.0010>
		<0.6605, 0.5095, -0.1263> <0.6676, 0.4009, -0.1263> <0.6979, 0.1938, -0.1097> <0.6937, 0.1937, -0.0009>
		<0.7688, 0.5088, -0.1296> <0.7709, 0.3205, -0.1296> <0.7989, 0.1170, -0.1891> <0.7917, 0.1169, -0.0009>
		<0.8495, 0.5111, -0.1372> <0.8517, 0.3228, -0.1372> <0.8530, 0.0427, -0.1890> <0.8458, 0.0426, -0.0008>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5847, 0.5216, 0.1356> <-0.5834, 0.4250, 0.1356> <-0.5752, 0.3116, 0.0959> <-0.5775, 0.3117, -0.0007>
		<-0.5962, 0.5224, 0.1371> <-0.5949, 0.4258, 0.1371> <-0.6009, 0.3034, 0.0959> <-0.6032, 0.3035, -0.0007>
		<-0.6084, 0.5382, 0.1355> <-0.6175, 0.4203, 0.1355> <-0.6328, 0.2844, 0.1175> <-0.6356, 0.2845, -0.0007>
		<-0.6200, 0.5378, 0.1356> <-0.6291, 0.4198, 0.1356> <-0.6518, 0.2653, 0.1175> <-0.6546, 0.2654, -0.0007>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5847, 0.5216, 0.1356> <-0.5341, 0.5181, 0.1291> <-0.4664, 0.5249, 0.1195> <-0.4162, 0.5237, 0.1094>
		<-0.5834, 0.4250, 0.1356> <-0.5328, 0.4215, 0.1291> <-0.4690, 0.4417, 0.1195> <-0.4188, 0.4405, 0.1094>
		<-0.5752, 0.3116, 0.0959> <-0.5311, 0.3257, 0.0959> <-0.4698, 0.3413, 0.0825> <-0.4236, 0.3383, 0.0825>
		<-0.5775, 0.3117, -0.0007> <-0.5334, 0.3257, -0.0007> <-0.4718, 0.3413, -0.0007> <-0.4256, 0.3384, -0.0007>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5847, 0.5216, 0.1356> <-0.5962, 0.5224, 0.1371> <-0.6084, 0.5382, 0.1355> <-0.6200, 0.5378, 0.1356>
		<-0.5860, 0.6141, 0.1356> <-0.5975, 0.6149, 0.1371> <-0.6012, 0.6305, 0.1355> <-0.6129, 0.6300, 0.1356>
		<-0.5809, 0.7188, 0.0918> <-0.5921, 0.7216, 0.0918> <-0.6053, 0.7306, 0.0918> <-0.6161, 0.7349, 0.0918>
		<-0.5830, 0.7188, -0.0007> <-0.5943, 0.7217, -0.0007> <-0.6075, 0.7307, -0.0007> <-0.6183, 0.7350, -0.0007>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5847, 0.5216, 0.1356> <-0.5860, 0.6141, 0.1356> <-0.5809, 0.7188, 0.0918> <-0.5830, 0.7188, -0.0007>
		<-0.5341, 0.5181, 0.1291> <-0.5354, 0.6106, 0.1291> <-0.5309, 0.7060, 0.0918> <-0.5331, 0.7060, -0.0007>
		<-0.4664, 0.5249, 0.1195> <-0.4641, 0.5996, 0.1195> <-0.4623, 0.6985, 0.0740> <-0.4641, 0.6985, -0.0007>
		<-0.4162, 0.5237, 0.1094> <-0.4139, 0.5984, 0.1094> <-0.4131, 0.6829, 0.0740> <-0.4149, 0.6829, -0.0007>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5830, 0.7188, -0.0007> <-0.5943, 0.7217, -0.0007> <-0.6075, 0.7307, -0.0007> <-0.6183, 0.7350, -0.0007>
		<-0.5852, 0.7189, -0.0933> <-0.5965, 0.7218, -0.0933> <-0.6097, 0.7307, -0.0933> <-0.6205, 0.7350, -0.0933>
		<-0.5924, 0.6143, -0.1371> <-0.6039, 0.6151, -0.1386> <-0.6076, 0.6307, -0.1369> <-0.6193, 0.6302, -0.1371>
		<-0.5911, 0.5218, -0.1371> <-0.6026, 0.5226, -0.1386> <-0.6148, 0.5384, -0.1369> <-0.6264, 0.5379, -0.1371>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5830, 0.7188, -0.0007> <-0.5852, 0.7189, -0.0933> <-0.5924, 0.6143, -0.1371> <-0.5911, 0.5218, -0.1371>
		<-0.5331, 0.7060, -0.0007> <-0.5352, 0.7061, -0.0933> <-0.5414, 0.6108, -0.1306> <-0.5401, 0.5183, -0.1306>
		<-0.4641, 0.6985, -0.0007> <-0.4658, 0.6985, -0.0754> <-0.4696, 0.5998, -0.1209> <-0.4719, 0.5251, -0.1209>
		<-0.4149, 0.6829, -0.0007> <-0.4166, 0.6830, -0.0754> <-0.4191, 0.5985, -0.1109> <-0.4214, 0.5238, -0.1109>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5911, 0.5218, -0.1371> <-0.6026, 0.5226, -0.1386> <-0.6148, 0.5384, -0.1369> <-0.6264, 0.5379, -0.1371>
		<-0.5898, 0.4250, -0.1371> <-0.6013, 0.4258, -0.1386> <-0.6239, 0.4206, -0.1369> <-0.6355, 0.4202, -0.1371>
		<-0.5798, 0.3117, -0.0975> <-0.6055, 0.3035, -0.0975> <-0.6383, 0.2846, -0.1188> <-0.6574, 0.2655, -0.1188>
		<-0.5775, 0.3117, -0.0007> <-0.6032, 0.3035, -0.0007> <-0.6356, 0.2845, -0.0007> <-0.6546, 0.2654, -0.0007>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5911, 0.5218, -0.1371> <-0.5898, 0.4250, -0.1371> <-0.5798, 0.3117, -0.0975> <-0.5775, 0.3117, -0.0007>
		<-0.5401, 0.5183, -0.1306> <-0.5388, 0.4215, -0.1306> <-0.5357, 0.3258, -0.0975> <-0.5334, 0.3257, -0.0007>
		<-0.4719, 0.5251, -0.1209> <-0.4745, 0.4419, -0.1209> <-0.4737, 0.3414, -0.0840> <-0.4718, 0.3413, -0.0007>
		<-0.4214, 0.5238, -0.1109> <-0.4240, 0.4406, -0.1109> <-0.4275, 0.3384, -0.0840> <-0.4256, 0.3384, -0.0007>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6200, 0.5378, 0.1356> <-0.6291, 0.4198, 0.1356> <-0.6518, 0.2653, 0.1175> <-0.6546, 0.2654, -0.0007>
		<-0.7041, 0.5344, 0.1363> <-0.7132, 0.4164, 0.1363> <-0.7323, 0.1847, 0.1175> <-0.7351, 0.1847, -0.0007>
		<-0.8153, 0.5184, 0.1396> <-0.8181, 0.3078, 0.1396> <-0.8121, 0.0547, 0.2097> <-0.8198, 0.0549, -0.0007>
		<-0.8989, 0.5090, 0.1382> <-0.9017, 0.2985, 0.1382> <-0.8993, -0.0187, 0.2097> <-0.9070, -0.0185, -0.0007>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6200, 0.5378, 0.1356> <-0.7041, 0.5344, 0.1363> <-0.8153, 0.5184, 0.1396> <-0.8989, 0.5090, 0.1382>
		<-0.6129, 0.6300, 0.1356> <-0.6969, 0.6267, 0.1363> <-0.8135, 0.6580, 0.1396> <-0.8971, 0.6487, 0.1382>
		<-0.6161, 0.7349, 0.0918> <-0.6992, 0.7679, 0.0918> <-0.8034, 0.8239, 0.1388> <-0.8907, 0.8430, 0.1388>
		<-0.6183, 0.7350, -0.0007> <-0.7013, 0.7680, -0.0007> <-0.8085, 0.8240, -0.0007> <-0.8958, 0.8431, -0.0007>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6183, 0.7350, -0.0007> <-0.7013, 0.7680, -0.0007> <-0.8085, 0.8240, -0.0007> <-0.8958, 0.8431, -0.0007>
		<-0.6205, 0.7350, -0.0933> <-0.7035, 0.7680, -0.0933> <-0.8137, 0.8241, -0.1411> <-0.9009, 0.8432, -0.1411>
		<-0.6193, 0.6302, -0.1371> <-0.7045, 0.6268, -0.1392> <-0.8226, 0.6590, -0.1448> <-0.9074, 0.6497, -0.1448>
		<-0.6264, 0.5379, -0.1371> <-0.7116, 0.5346, -0.1392> <-0.8245, 0.5186, -0.1448> <-0.9093, 0.5093, -0.1448>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6264, 0.5379, -0.1371> <-0.7116, 0.5346, -0.1392> <-0.8245, 0.5186, -0.1448> <-0.9093, 0.5093, -0.1448>
		<-0.6355, 0.4202, -0.1371> <-0.7207, 0.4168, -0.1392> <-0.8272, 0.3075, -0.1448> <-0.9120, 0.2982, -0.1448>
		<-0.6574, 0.2655, -0.1188> <-0.7379, 0.1848, -0.1188> <-0.8275, 0.0550, -0.2117> <-0.9147, -0.0183, -0.2118>
		<-0.6546, 0.2654, -0.0007> <-0.7351, 0.1847, -0.0007> <-0.8198, 0.0549, -0.0007> <-0.9070, -0.0185, -0.0007>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2908, 0.5143, 0.0765> <-0.2888, 0.4238, 0.0765> <-0.2803, 0.2928, 0.0898> <-0.2825, 0.2928, -0.0007>
		<-0.3284, 0.5171, 0.0863> <-0.3264, 0.4266, 0.0863> <-0.3233, 0.3065, 0.0898> <-0.3254, 0.3065, -0.0007>
		<-0.3780, 0.5228, 0.1017> <-0.3806, 0.4395, 0.1017> <-0.3787, 0.3355, 0.0825> <-0.3806, 0.3355, -0.0007>
		<-0.4162, 0.5237, 0.1094> <-0.4188, 0.4405, 0.1094> <-0.4236, 0.3383, 0.0825> <-0.4256, 0.3384, -0.0007>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2908, 0.5143, 0.0765> <-0.3284, 0.5171, 0.0863> <-0.3780, 0.5228, 0.1017> <-0.4162, 0.5237, 0.1094>
		<-0.2920, 0.5667, 0.0765> <-0.3296, 0.5695, 0.0863> <-0.3757, 0.5974, 0.1017> <-0.4139, 0.5984, 0.1094>
		<-0.2886, 0.6260, 0.0516> <-0.3261, 0.6430, 0.0516> <-0.3738, 0.6704, 0.0740> <-0.4131, 0.6829, 0.0740>
		<-0.2899, 0.6260, -0.0007> <-0.3274, 0.6431, -0.0007> <-0.3756, 0.6705, -0.0007> <-0.4149, 0.6829, -0.0007>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2899, 0.6260, -0.0007> <-0.3274, 0.6431, -0.0007> <-0.3756, 0.6705, -0.0007> <-0.4149, 0.6829, -0.0007>
		<-0.2911, 0.6260, -0.0531> <-0.3286, 0.6431, -0.0531> <-0.3773, 0.6705, -0.0754> <-0.4166, 0.6830, -0.0754>
		<-0.2956, 0.5668, -0.0780> <-0.3337, 0.5696, -0.0878> <-0.3804, 0.5976, -0.1032> <-0.4191, 0.5985, -0.1109>
		<-0.2944, 0.5144, -0.0780> <-0.3325, 0.5172, -0.0878> <-0.3827, 0.5229, -0.1032> <-0.4214, 0.5238, -0.1109>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2944, 0.5144, -0.0780> <-0.3325, 0.5172, -0.0878> <-0.3827, 0.5229, -0.1032> <-0.4214, 0.5238, -0.1109>
		<-0.2924, 0.4238, -0.0780> <-0.3305, 0.4266, -0.0878> <-0.3853, 0.4397, -0.1032> <-0.4240, 0.4406, -0.1109>
		<-0.2846, 0.2929, -0.0914> <-0.3275, 0.3066, -0.0914> <-0.3826, 0.3356, -0.0840> <-0.4275, 0.3384, -0.0840>
		<-0.2825, 0.2928, -0.0007> <-0.3254, 0.3065, -0.0007> <-0.3806, 0.3355, -0.0007> <-0.4256, 0.3384, -0.0007>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8989, 0.5090, 0.1382> <-0.9017, 0.2985, 0.1382> <-0.8993, -0.0187, 0.2097> <-0.9070, -0.0185, -0.0007>
		<-0.9060, 0.5082, 0.1381> <-0.9087, 0.2977, 0.1381> <-0.9126, -0.0299, 0.2097> <-0.9203, -0.0297, -0.0008>
		<-0.9281, 0.5043, 0.1314> <-0.9302, 0.3166, 0.1314> <-0.9306, 0.0216, 0.1868> <-0.9378, 0.0217, -0.0008>
		<-0.9210, 0.5041, 0.1308> <-0.9231, 0.3164, 0.1308> <-0.9203, 0.0356, 0.1868> <-0.9276, 0.0358, -0.0008>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8989, 0.5090, 0.1382> <-0.9060, 0.5082, 0.1381> <-0.9281, 0.5043, 0.1314> <-0.9210, 0.5041, 0.1308>
		<-0.8971, 0.6487, 0.1382> <-0.9042, 0.6479, 0.1381> <-0.9266, 0.6296, 0.1314> <-0.9195, 0.6294, 0.1308>
		<-0.8907, 0.8430, 0.1388> <-0.9049, 0.8461, 0.1388> <-0.9268, 0.8073, 0.1243> <-0.9140, 0.8006, 0.1243>
		<-0.8958, 0.8431, -0.0007> <-0.9099, 0.8462, -0.0008> <-0.9316, 0.8074, -0.0008> <-0.9188, 0.8007, -0.0008>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8958, 0.8431, -0.0007> <-0.9099, 0.8462, -0.0008> <-0.9316, 0.8074, -0.0008> <-0.9188, 0.8007, -0.0008>
		<-0.9009, 0.8432, -0.1411> <-0.9151, 0.8463, -0.1411> <-0.9365, 0.8075, -0.1267> <-0.9236, 0.8008, -0.1267>
		<-0.9074, 0.6497, -0.1448> <-0.9146, 0.6489, -0.1448> <-0.9370, 0.6306, -0.1379> <-0.9299, 0.6304, -0.1372>
		<-0.9093, 0.5093, -0.1448> <-0.9164, 0.5085, -0.1448> <-0.9384, 0.5046, -0.1379> <-0.9313, 0.5044, -0.1372>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.9093, 0.5093, -0.1448> <-0.9164, 0.5085, -0.1448> <-0.9384, 0.5046, -0.1379> <-0.9313, 0.5044, -0.1372>
		<-0.9120, 0.2982, -0.1448> <-0.9191, 0.2974, -0.1448> <-0.9406, 0.3163, -0.1379> <-0.9335, 0.3161, -0.1372>
		<-0.9147, -0.0183, -0.2118> <-0.9280, -0.0295, -0.2118> <-0.9451, 0.0219, -0.1890> <-0.9348, 0.0360, -0.1890>
		<-0.9070, -0.0185, -0.0007> <-0.9203, -0.0297, -0.0008> <-0.9378, 0.0217, -0.0008> <-0.9276, 0.0358, -0.0008>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6522, 0.5019, 0.1154> <-0.7328, 0.5026, 0.1200> <-0.8406, 0.5018, 0.1233> <-0.9210, 0.5041, 0.1308>
		<-0.6592, 0.3933, 0.1154> <-0.7398, 0.3940, 0.1200> <-0.8427, 0.3141, 0.1233> <-0.9231, 0.3164, 0.1308>
		<-0.7061, 0.2517, 0.1078> <-0.7713, 0.1869, 0.1078> <-0.8662, 0.1099, 0.1867> <-0.9203, 0.0356, 0.1868>
		<-0.7103, 0.2518, -0.0010> <-0.7755, 0.1870, -0.0009> <-0.8735, 0.1101, -0.0009> <-0.9276, 0.0358, -0.0008>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6522, 0.5019, 0.1154> <-0.6457, 0.6012, 0.1154> <-0.6754, 0.7304, 0.0985> <-0.6792, 0.7305, -0.0010>
		<-0.7328, 0.5026, 0.1200> <-0.7264, 0.6019, 0.1200> <-0.7473, 0.7515, 0.0986> <-0.7511, 0.7515, -0.0009>
		<-0.8406, 0.5018, 0.1233> <-0.8391, 0.6270, 0.1233> <-0.8475, 0.7660, 0.1242> <-0.8523, 0.7662, -0.0009>
		<-0.9210, 0.5041, 0.1308> <-0.9195, 0.6294, 0.1308> <-0.9140, 0.8006, 0.1243> <-0.9188, 0.8007, -0.0008>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6792, 0.7305, -0.0010> <-0.6831, 0.7306, -0.1008> <-0.6549, 0.6018, -0.1216> <-0.6613, 0.5021, -0.1216>
		<-0.7511, 0.7515, -0.0009> <-0.7550, 0.7516, -0.1007> <-0.7359, 0.6025, -0.1263> <-0.7423, 0.5028, -0.1263>
		<-0.8523, 0.7662, -0.0009> <-0.8572, 0.7663, -0.1268> <-0.8491, 0.6280, -0.1296> <-0.8506, 0.5021, -0.1296>
		<-0.9188, 0.8007, -0.0008> <-0.9236, 0.8008, -0.1267> <-0.9299, 0.6304, -0.1372> <-0.9313, 0.5044, -0.1372>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6613, 0.5021, -0.1216> <-0.6684, 0.3934, -0.1216> <-0.7145, 0.2519, -0.1098> <-0.7103, 0.2518, -0.0010>
		<-0.7423, 0.5028, -0.1263> <-0.7494, 0.3941, -0.1263> <-0.7797, 0.1871, -0.1097> <-0.7755, 0.1870, -0.0009>
		<-0.8506, 0.5021, -0.1296> <-0.8527, 0.3137, -0.1296> <-0.8807, 0.1103, -0.1891> <-0.8735, 0.1101, -0.0009>
		<-0.9313, 0.5044, -0.1372> <-0.9335, 0.3161, -0.1372> <-0.9348, 0.0360, -0.1890> <-0.9276, 0.0358, -0.0008>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0742, 0.9836, -0.1394> <-0.1219, 0.9408, -0.1262> <-0.1361, 0.8497, -0.0982> <-0.1705, 0.7965, -0.0819>
		<-0.0772, 1.0052, -0.0980> <-0.1250, 0.9624, -0.0848> <-0.1437, 0.8574, -0.0720> <-0.1781, 0.8042, -0.0557>
		<-0.0788, 1.0461, -0.0356> <-0.1305, 0.9976, -0.0356> <-0.1463, 0.8803, -0.0194> <-0.1835, 0.8201, -0.0194>
		<-0.0786, 1.0316, 0.0089> <-0.1303, 0.9831, 0.0089> <-0.1456, 0.8799, 0.0089> <-0.1829, 0.8197, 0.0089>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0742, 0.9836, -0.1394> <-0.0733, 0.9775, -0.1513> <-0.0678, 0.9461, -0.1724> <-0.0663, 0.9443, -0.1592>
		<-0.1219, 0.9408, -0.1262> <-0.1211, 0.9347, -0.1381> <-0.1085, 0.9096, -0.1612> <-0.1070, 0.9078, -0.1480>
		<-0.1361, 0.8497, -0.0982> <-0.1331, 0.8467, -0.1087> <-0.1249, 0.8305, -0.1338> <-0.1191, 0.8302, -0.1241>
		<-0.1705, 0.7965, -0.0819> <-0.1675, 0.7935, -0.0924> <-0.1542, 0.7852, -0.1199> <-0.1484, 0.7849, -0.1102>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0742, 0.9836, -0.1394> <-0.0772, 1.0052, -0.0980> <-0.0788, 1.0461, -0.0356> <-0.0786, 1.0316, 0.0089>
		<-0.0498, 1.0055, -0.1461> <-0.0528, 1.0271, -0.1047> <-0.0524, 1.0709, -0.0356> <-0.0522, 1.0564, 0.0089>
		<0.0138, 1.0058, -0.1462> <0.0172, 1.0272, -0.1048> <0.0170, 1.0712, -0.0355> <0.0167, 1.0567, 0.0089>
		<0.0374, 0.9830, -0.1392> <0.0407, 1.0045, -0.0978> <0.0425, 1.0454, -0.0355> <0.0422, 1.0309, 0.0089>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0742, 0.9836, -0.1394> <-0.0498, 1.0055, -0.1461> <0.0138, 1.0058, -0.1462> <0.0374, 0.9830, -0.1392>
		<-0.0733, 0.9775, -0.1513> <-0.0489, 0.9994, -0.1580> <0.0129, 0.9996, -0.1581> <0.0364, 0.9768, -0.1511>
		<-0.0678, 0.9461, -0.1724> <-0.0470, 0.9647, -0.1781> <0.0104, 0.9649, -0.1782> <0.0304, 0.9456, -0.1722>
		<-0.0663, 0.9443, -0.1592> <-0.0455, 0.9630, -0.1649> <0.0086, 0.9631, -0.1650> <0.0287, 0.9438, -0.1590>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0374, 0.9830, -0.1392> <0.0849, 0.9371, -0.1251> <0.0956, 0.8424, -0.0960> <0.1299, 0.7867, -0.0789>
		<0.0364, 0.9768, -0.1511> <0.0840, 0.9310, -0.1370> <0.0924, 0.8395, -0.1065> <0.1267, 0.7838, -0.0894>
		<0.0304, 0.9456, -0.1722> <0.0709, 0.9065, -0.1602> <0.0844, 0.8239, -0.1318> <0.1136, 0.7765, -0.1172>
		<0.0287, 0.9438, -0.1590> <0.0692, 0.9047, -0.1470> <0.0783, 0.8240, -0.1222> <0.1075, 0.7766, -0.1077>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0374, 0.9830, -0.1392> <0.0407, 1.0045, -0.0978> <0.0425, 1.0454, -0.0355> <0.0422, 1.0309, 0.0089>
		<0.0849, 0.9371, -0.1251> <0.0883, 0.9586, -0.0837> <0.0940, 0.9934, -0.0355> <0.0937, 0.9789, 0.0089>
		<0.0956, 0.8424, -0.0960> <0.1031, 0.8493, -0.0706> <0.1059, 0.8717, -0.0185> <0.1052, 0.8716, 0.0089>
		<0.1299, 0.7867, -0.0789> <0.1375, 0.7937, -0.0535> <0.1430, 0.8087, -0.0185> <0.1424, 0.8086, 0.0089>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1299, 0.7867, -0.0789> <0.1375, 0.7937, -0.0535> <0.1430, 0.8087, -0.0185> <0.1424, 0.8086, 0.0089>
		<0.1495, 0.7549, -0.0691> <0.1571, 0.7619, -0.0437> <0.1643, 0.7727, -0.0185> <0.1636, 0.7726, 0.0089>
		<0.2070, 0.7307, -0.0617> <0.2167, 0.7318, -0.0453> <0.2269, 0.7424, -0.0099> <0.2259, 0.7451, 0.0089>
		<0.2153, 0.6947, -0.0506> <0.2249, 0.6958, -0.0343> <0.2358, 0.7016, -0.0099> <0.2349, 0.7043, 0.0089>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1299, 0.7867, -0.0789> <0.1495, 0.7549, -0.0691> <0.2070, 0.7307, -0.0617> <0.2153, 0.6947, -0.0506>
		<0.1267, 0.7838, -0.0894> <0.1463, 0.7521, -0.0796> <0.1997, 0.7299, -0.0741> <0.2079, 0.6938, -0.0631>
		<0.1136, 0.7765, -0.1172> <0.1303, 0.7494, -0.1089> <0.1852, 0.7247, -0.0999> <0.1922, 0.6939, -0.0905>
		<0.1075, 0.7766, -0.1077> <0.1242, 0.7495, -0.0993> <0.1732, 0.7289, -0.0930> <0.1802, 0.6982, -0.0836>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2153, 0.6947, -0.0506> <0.2205, 0.6719, -0.0436> <0.1890, 0.6368, -0.0328> <0.1649, 0.6337, -0.0319>
		<0.2079, 0.6938, -0.0631> <0.2131, 0.6711, -0.0561> <0.1822, 0.6385, -0.0450> <0.1580, 0.6354, -0.0441>
		<0.1922, 0.6939, -0.0905> <0.1967, 0.6745, -0.0845> <0.1687, 0.6409, -0.0724> <0.1482, 0.6383, -0.0716>
		<0.1802, 0.6982, -0.0836> <0.1847, 0.6788, -0.0776> <0.1579, 0.6489, -0.0684> <0.1373, 0.6462, -0.0676>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2153, 0.6947, -0.0506> <0.2249, 0.6958, -0.0343> <0.2358, 0.7016, -0.0099> <0.2349, 0.7043, 0.0089>
		<0.2205, 0.6719, -0.0436> <0.2301, 0.6730, -0.0273> <0.2415, 0.6758, -0.0099> <0.2405, 0.6785, 0.0089>
		<0.1890, 0.6368, -0.0328> <0.1954, 0.6352, -0.0215> <0.2072, 0.6346, -0.0035> <0.2064, 0.6387, 0.0089>
		<0.1649, 0.6337, -0.0319> <0.1712, 0.6321, -0.0206> <0.1810, 0.6311, -0.0035> <0.1803, 0.6352, 0.0089>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1649, 0.6337, -0.0319> <0.1712, 0.6321, -0.0206> <0.1810, 0.6311, -0.0035> <0.1803, 0.6352, 0.0089>
		<0.0520, 0.6193, -0.0275> <0.0584, 0.6177, -0.0161> <0.0588, 0.6148, -0.0035> <0.0581, 0.6189, 0.0089>
		<-0.1022, 0.6220, -0.0283> <-0.1090, 0.6206, -0.0165> <-0.1097, 0.6179, -0.0042> <-0.1089, 0.6219, 0.0089>
		<-0.2145, 0.6398, -0.0338> <-0.2213, 0.6384, -0.0219> <-0.2313, 0.6381, -0.0042> <-0.2305, 0.6422, 0.0089>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1649, 0.6337, -0.0319> <0.0520, 0.6193, -0.0275> <-0.1022, 0.6220, -0.0283> <-0.2145, 0.6398, -0.0338>
		<0.1580, 0.6354, -0.0441> <0.0452, 0.6211, -0.0396> <-0.0953, 0.6234, -0.0405> <-0.2075, 0.6413, -0.0460>
		<0.1482, 0.6383, -0.0716> <0.0521, 0.6260, -0.0679> <-0.1013, 0.6287, -0.0689> <-0.1970, 0.6439, -0.0736>
		<0.1373, 0.6462, -0.0676> <0.0412, 0.6340, -0.0639> <-0.0902, 0.6362, -0.0646> <-0.1858, 0.6514, -0.0692>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2145, 0.6398, -0.0338> <-0.2372, 0.6434, -0.0349> <-0.2632, 0.6795, -0.0460> <-0.2573, 0.7008, -0.0525>
		<-0.2075, 0.6413, -0.0460> <-0.2303, 0.6449, -0.0471> <-0.2560, 0.6785, -0.0584> <-0.2501, 0.6998, -0.0649>
		<-0.1970, 0.6439, -0.0736> <-0.2163, 0.6470, -0.0745> <-0.2392, 0.6814, -0.0868> <-0.2341, 0.6995, -0.0923>
		<-0.1858, 0.6514, -0.0692> <-0.2052, 0.6545, -0.0702> <-0.2273, 0.6853, -0.0796> <-0.2223, 0.7034, -0.0852>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2145, 0.6398, -0.0338> <-0.2213, 0.6384, -0.0219> <-0.2313, 0.6381, -0.0042> <-0.2305, 0.6422, 0.0089>
		<-0.2372, 0.6434, -0.0349> <-0.2440, 0.6420, -0.0231> <-0.2559, 0.6422, -0.0042> <-0.2551, 0.6462, 0.0089>
		<-0.2632, 0.6795, -0.0460> <-0.2730, 0.6809, -0.0291> <-0.2843, 0.6846, -0.0105> <-0.2833, 0.6871, 0.0089>
		<-0.2573, 0.7008, -0.0525> <-0.2670, 0.7022, -0.0356> <-0.2778, 0.7087, -0.0105> <-0.2768, 0.7112, 0.0089>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2573, 0.7008, -0.0525> <-0.2670, 0.7022, -0.0356> <-0.2778, 0.7087, -0.0105> <-0.2768, 0.7112, 0.0089>
		<-0.2470, 0.7375, -0.0638> <-0.2567, 0.7389, -0.0469> <-0.2666, 0.7503, -0.0105> <-0.2656, 0.7528, 0.0089>
		<-0.1914, 0.7642, -0.0720> <-0.1990, 0.7719, -0.0457> <-0.2062, 0.7835, -0.0194> <-0.2055, 0.7831, 0.0089>
		<-0.1705, 0.7965, -0.0819> <-0.1781, 0.8042, -0.0557> <-0.1835, 0.8201, -0.0194> <-0.1829, 0.8197, 0.0089>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2573, 0.7008, -0.0525> <-0.2470, 0.7375, -0.0638> <-0.1914, 0.7642, -0.0720> <-0.1705, 0.7965, -0.0819>
		<-0.2501, 0.6998, -0.0649> <-0.2398, 0.7365, -0.0762> <-0.1884, 0.7612, -0.0825> <-0.1675, 0.7935, -0.0924>
		<-0.2341, 0.6995, -0.0923> <-0.2253, 0.7307, -0.1019> <-0.1720, 0.7576, -0.1115> <-0.1542, 0.7852, -0.1199>
		<-0.2223, 0.7034, -0.0852> <-0.2135, 0.7346, -0.0948> <-0.1662, 0.7574, -0.1018> <-0.1484, 0.7849, -0.1102>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0598, 0.9668, -0.0123> <-0.0967, 0.9251, -0.0118> <-0.1034, 0.8438, -0.0145> <-0.1301, 0.7949, -0.0149>
		<-0.0618, 0.9601, -0.0564> <-0.0987, 0.9183, -0.0559> <-0.1089, 0.8408, -0.0431> <-0.1356, 0.7919, -0.0435>
		<-0.0614, 0.9385, -0.1152> <-0.1020, 0.9020, -0.1040> <-0.1039, 0.8296, -0.0991> <-0.1332, 0.7843, -0.0852>
		<-0.0663, 0.9443, -0.1592> <-0.1070, 0.9078, -0.1480> <-0.1191, 0.8302, -0.1241> <-0.1484, 0.7849, -0.1102>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0598, 0.9668, -0.0123> <-0.0618, 0.9601, -0.0564> <-0.0614, 0.9385, -0.1152> <-0.0663, 0.9443, -0.1592>
		<-0.0436, 0.9851, -0.0125> <-0.0456, 0.9784, -0.0565> <-0.0406, 0.9571, -0.1210> <-0.0455, 0.9630, -0.1649>
		<0.0059, 0.9851, -0.0164> <0.0081, 0.9784, -0.0591> <0.0031, 0.9573, -0.1224> <0.0086, 0.9631, -0.1650>
		<0.0215, 0.9663, -0.0167> <0.0237, 0.9596, -0.0594> <0.0232, 0.9380, -0.1165> <0.0287, 0.9438, -0.1590>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0215, 0.9663, -0.0167> <0.0237, 0.9596, -0.0594> <0.0232, 0.9380, -0.1165> <0.0287, 0.9438, -0.1590>
		<0.0582, 0.9222, -0.0173> <0.0603, 0.9154, -0.0600> <0.0637, 0.8989, -0.1045> <0.0692, 0.9047, -0.1470>
		<0.0625, 0.8383, -0.0154> <0.0680, 0.8350, -0.0432> <0.0629, 0.8242, -0.0981> <0.0783, 0.8240, -0.1222>
		<0.0890, 0.7874, -0.0148> <0.0945, 0.7842, -0.0427> <0.0921, 0.7768, -0.0836> <0.1075, 0.7766, -0.1077>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0890, 0.7874, -0.0148> <0.0945, 0.7842, -0.0427> <0.0921, 0.7768, -0.0836> <0.1075, 0.7766, -0.1077>
		<0.1020, 0.7625, -0.0145> <0.1075, 0.7592, -0.0424> <0.1088, 0.7498, -0.0752> <0.1242, 0.7495, -0.0993>
		<0.1452, 0.7447, -0.0143> <0.1539, 0.7390, -0.0352> <0.1538, 0.7357, -0.0819> <0.1732, 0.7289, -0.0930>
		<0.1512, 0.7172, -0.0139> <0.1599, 0.7115, -0.0348> <0.1609, 0.7050, -0.0725> <0.1802, 0.6982, -0.0836>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1512, 0.7172, -0.0139> <0.1599, 0.7115, -0.0348> <0.1609, 0.7050, -0.0725> <0.1802, 0.6982, -0.0836>
		<0.1550, 0.6998, -0.0137> <0.1637, 0.6941, -0.0346> <0.1653, 0.6856, -0.0665> <0.1847, 0.6788, -0.0776>
		<0.1321, 0.6731, -0.0134> <0.1390, 0.6657, -0.0297> <0.1431, 0.6597, -0.0630> <0.1579, 0.6489, -0.0684>
		<0.1145, 0.6707, -0.0133> <0.1213, 0.6634, -0.0296> <0.1225, 0.6571, -0.0622> <0.1373, 0.6462, -0.0676>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1145, 0.6707, -0.0133> <0.1213, 0.6634, -0.0296> <0.1225, 0.6571, -0.0622> <0.1373, 0.6462, -0.0676>
		<0.0322, 0.6597, -0.0132> <0.0391, 0.6524, -0.0295> <0.0264, 0.6448, -0.0584> <0.0412, 0.6340, -0.0639>
		<-0.0803, 0.6618, -0.0132> <-0.0874, 0.6546, -0.0300> <-0.0748, 0.6467, -0.0586> <-0.0902, 0.6362, -0.0646>
		<-0.1621, 0.6754, -0.0134> <-0.1692, 0.6682, -0.0302> <-0.1704, 0.6619, -0.0632> <-0.1858, 0.6514, -0.0692>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1621, 0.6754, -0.0134> <-0.1692, 0.6682, -0.0302> <-0.1704, 0.6619, -0.0632> <-0.1858, 0.6514, -0.0692>
		<-0.1787, 0.6781, -0.0134> <-0.1858, 0.6710, -0.0302> <-0.1898, 0.6650, -0.0642> <-0.2052, 0.6545, -0.0702>
		<-0.1976, 0.7057, -0.0138> <-0.2063, 0.7001, -0.0351> <-0.2078, 0.6917, -0.0678> <-0.2273, 0.6853, -0.0796>
		<-0.1933, 0.7219, -0.0140> <-0.2020, 0.7163, -0.0353> <-0.2027, 0.7098, -0.0734> <-0.2223, 0.7034, -0.0852>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1933, 0.7219, -0.0140> <-0.2020, 0.7163, -0.0353> <-0.2027, 0.7098, -0.0734> <-0.2223, 0.7034, -0.0852>
		<-0.1858, 0.7499, -0.0143> <-0.1945, 0.7443, -0.0357> <-0.1939, 0.7411, -0.0830> <-0.2135, 0.7346, -0.0948>
		<-0.1439, 0.7695, -0.0151> <-0.1494, 0.7665, -0.0437> <-0.1511, 0.7568, -0.0767> <-0.1662, 0.7574, -0.1018>
		<-0.1301, 0.7949, -0.0149> <-0.1356, 0.7919, -0.0435> <-0.1332, 0.7843, -0.0852> <-0.1484, 0.7849, -0.1102>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0786, 1.0316, 0.0089> <-0.1303, 0.9831, 0.0089> <-0.1456, 0.8799, 0.0089> <-0.1829, 0.8197, 0.0089>
		<-0.0782, 1.0057, 0.0882> <-0.1299, 0.9572, 0.0882> <-0.1446, 0.8793, 0.0531> <-0.1819, 0.8190, 0.0531>
		<-0.0865, 0.9358, 0.1916> <-0.1237, 0.9229, 0.1773> <-0.1608, 0.8400, 0.1440> <-0.1899, 0.8169, 0.1247>
		<-0.0723, 0.8631, 0.2299> <-0.1095, 0.8502, 0.2156> <-0.1361, 0.8164, 0.1719> <-0.1652, 0.7932, 0.1526>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0786, 1.0316, 0.0089> <-0.0782, 1.0057, 0.0882> <-0.0865, 0.9358, 0.1916> <-0.0723, 0.8631, 0.2299>
		<-0.0522, 1.0564, 0.0089> <-0.0518, 1.0305, 0.0882> <-0.0579, 0.9457, 0.2027> <-0.0436, 0.8730, 0.2410>
		<0.0167, 1.0567, 0.0089> <0.0163, 1.0308, 0.0881> <0.0123, 0.9469, 0.2021> <0.0073, 0.8736, 0.2413>
		<0.0422, 1.0309, 0.0089> <0.0418, 1.0051, 0.0881> <0.0404, 0.9359, 0.1905> <0.0353, 0.8626, 0.2297>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0422, 1.0309, 0.0089> <0.0418, 1.0051, 0.0881> <0.0404, 0.9359, 0.1905> <0.0353, 0.8626, 0.2297>
		<0.0937, 0.9789, 0.0089> <0.0933, 0.9531, 0.0881> <0.0776, 0.9213, 0.1751> <0.0725, 0.8480, 0.2143>
		<0.1052, 0.8716, 0.0089> <0.1042, 0.8714, 0.0517> <0.1141, 0.8342, 0.1384> <0.0955, 0.8103, 0.1686>
		<0.1424, 0.8086, 0.0089> <0.1414, 0.8084, 0.0517> <0.1431, 0.8098, 0.1183> <0.1245, 0.7859, 0.1486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1424, 0.8086, 0.0089> <0.1414, 0.8084, 0.0517> <0.1431, 0.8098, 0.1183> <0.1245, 0.7859, 0.1486>
		<0.1636, 0.7726, 0.0089> <0.1626, 0.7724, 0.0517> <0.1660, 0.7904, 0.1024> <0.1474, 0.7665, 0.1326>
		<0.2259, 0.7451, 0.0089> <0.2243, 0.7497, 0.0404> <0.2216, 0.7530, 0.1059> <0.1982, 0.7465, 0.1266>
		<0.2349, 0.7043, 0.0089> <0.2332, 0.7088, 0.0404> <0.2302, 0.7242, 0.0898> <0.2068, 0.7178, 0.1105>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2349, 0.7043, 0.0089> <0.2332, 0.7088, 0.0404> <0.2302, 0.7242, 0.0898> <0.2068, 0.7178, 0.1105>
		<0.2405, 0.6785, 0.0089> <0.2388, 0.6830, 0.0404> <0.2355, 0.7063, 0.0798> <0.2122, 0.6998, 0.1005>
		<0.2064, 0.6387, 0.0089> <0.2050, 0.6470, 0.0339> <0.1964, 0.6739, 0.0664> <0.1794, 0.6747, 0.0865>
		<0.1803, 0.6352, 0.0089> <0.1789, 0.6435, 0.0339> <0.1753, 0.6718, 0.0652> <0.1582, 0.6726, 0.0853>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1803, 0.6352, 0.0089> <0.1789, 0.6435, 0.0339> <0.1753, 0.6718, 0.0652> <0.1582, 0.6726, 0.0853>
		<0.0581, 0.6189, 0.0089> <0.0567, 0.6272, 0.0339> <0.0662, 0.6611, 0.0593> <0.0491, 0.6619, 0.0793>
		<-0.1089, 0.6219, 0.0089> <-0.1075, 0.6298, 0.0345> <-0.1198, 0.6636, 0.0636> <-0.0989, 0.6639, 0.0804>
		<-0.2305, 0.6422, 0.0089> <-0.2291, 0.6500, 0.0345> <-0.2285, 0.6769, 0.0710> <-0.2076, 0.6772, 0.0878>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2305, 0.6422, 0.0089> <-0.2291, 0.6500, 0.0345> <-0.2285, 0.6769, 0.0710> <-0.2076, 0.6772, 0.0878>
		<-0.2551, 0.6462, 0.0089> <-0.2537, 0.6541, 0.0345> <-0.2481, 0.6793, 0.0724> <-0.2272, 0.6796, 0.0892>
		<-0.2833, 0.6871, 0.0089> <-0.2816, 0.6913, 0.0411> <-0.2813, 0.7122, 0.0861> <-0.2548, 0.7058, 0.1038>
		<-0.2768, 0.7112, 0.0089> <-0.2752, 0.7154, 0.0411> <-0.2753, 0.7287, 0.0953> <-0.2488, 0.7223, 0.1130>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2768, 0.7112, 0.0089> <-0.2752, 0.7154, 0.0411> <-0.2753, 0.7287, 0.0953> <-0.2488, 0.7223, 0.1130>
		<-0.2656, 0.7528, 0.0089> <-0.2640, 0.7570, 0.0411> <-0.2647, 0.7578, 0.1116> <-0.2382, 0.7514, 0.1293>
		<-0.2055, 0.7831, 0.0089> <-0.2045, 0.7824, 0.0531> <-0.2142, 0.7975, 0.1087> <-0.1894, 0.7738, 0.1365>
		<-0.1829, 0.8197, 0.0089> <-0.1819, 0.8190, 0.0531> <-0.1899, 0.8169, 0.1247> <-0.1652, 0.7932, 0.1526>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0723, 0.8631, 0.2299> <-0.1095, 0.8502, 0.2156> <-0.1361, 0.8164, 0.1719> <-0.1652, 0.7932, 0.1526>
		<-0.0723, 0.8631, 0.2299> <-0.0979, 0.7909, 0.2469> <-0.0983, 0.7801, 0.2145> <-0.1273, 0.7569, 0.1952>
		<-0.0723, 0.8631, 0.2299> <-0.0979, 0.7909, 0.2469> <-0.0726, 0.7560, 0.1992> <-0.0520, 0.6914, 0.1935>
		<-0.0723, 0.8631, 0.2299> <-0.0607, 0.8037, 0.2612> <-0.0242, 0.7123, 0.2167> <-0.0035, 0.6477, 0.2111>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0723, 0.8631, 0.2299> <-0.0607, 0.8037, 0.2612> <-0.0242, 0.7123, 0.2167> <-0.0035, 0.6477, 0.2111>
		<-0.0436, 0.8730, 0.2410> <-0.0320, 0.8137, 0.2722> <-0.0184, 0.7117, 0.2179> <0.0022, 0.6471, 0.2122>
		<0.0073, 0.8736, 0.2413> <0.0033, 0.8160, 0.2721> <0.0158, 0.7114, 0.2182> <0.0099, 0.6463, 0.2138>
		<0.0353, 0.8626, 0.2297> <0.0313, 0.8050, 0.2605> <0.0215, 0.7108, 0.2193> <0.0156, 0.6457, 0.2149>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0723, 0.8631, 0.2299> <-0.0607, 0.8037, 0.2612> <-0.0242, 0.7123, 0.2167> <-0.0035, 0.6477, 0.2111>
		<-0.0436, 0.8730, 0.2410> <-0.0320, 0.8137, 0.2722> <-0.0184, 0.7117, 0.2179> <0.0022, 0.6471, 0.2122>
		<0.0073, 0.8736, 0.2413> <0.0033, 0.8160, 0.2721> <0.0158, 0.7114, 0.2182> <0.0099, 0.6463, 0.2138>
		<0.0353, 0.8626, 0.2297> <0.0313, 0.8050, 0.2605> <0.0215, 0.7108, 0.2193> <0.0156, 0.6457, 0.2149>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0353, 0.8626, 0.2297> <0.0313, 0.8050, 0.2605> <0.0215, 0.7108, 0.2193> <0.0156, 0.6457, 0.2149>
		<0.0353, 0.8626, 0.2297> <0.0686, 0.7904, 0.2451> <0.0542, 0.7529, 0.1994> <0.0483, 0.6878, 0.1950>
		<0.0353, 0.8626, 0.2297> <0.0686, 0.7904, 0.2451> <0.0708, 0.7786, 0.2088> <0.0997, 0.7542, 0.1887>
		<0.0353, 0.8626, 0.2297> <0.0725, 0.8480, 0.2143> <0.0955, 0.8103, 0.1686> <0.1245, 0.7859, 0.1486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1245, 0.7859, 0.1486> <0.0997, 0.7542, 0.1887> <0.0483, 0.6878, 0.1950> <0.0156, 0.6457, 0.2149>
		<0.1474, 0.7665, 0.1326> <0.1227, 0.7348, 0.1727> <0.0481, 0.6871, 0.1915> <0.0155, 0.6450, 0.2115>
		<0.1982, 0.7465, 0.1266> <0.1486, 0.7328, 0.1705> <0.0728, 0.6664, 0.1790> <0.0153, 0.6441, 0.2069>
		<0.2068, 0.7178, 0.1105> <0.1572, 0.7040, 0.1544> <0.0727, 0.6657, 0.1755> <0.0152, 0.6434, 0.2034>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2068, 0.7178, 0.1105> <0.1572, 0.7040, 0.1544> <0.0727, 0.6657, 0.1755> <0.0152, 0.6434, 0.2034>
		<0.2068, 0.7178, 0.1105> <0.1626, 0.6860, 0.1444> <0.1156, 0.6745, 0.1401> <0.0581, 0.6522, 0.1680>
		<0.2068, 0.7178, 0.1105> <0.1626, 0.6860, 0.1444> <0.1429, 0.6765, 0.1294> <0.1218, 0.6744, 0.1282>
		<0.2068, 0.7178, 0.1105> <0.2122, 0.6998, 0.1005> <0.1794, 0.6747, 0.0865> <0.1582, 0.6726, 0.0853>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1582, 0.6726, 0.0853> <0.1218, 0.6744, 0.1282> <0.0581, 0.6522, 0.1680> <0.0152, 0.6434, 0.2034>
		<0.0491, 0.6619, 0.0793> <0.0127, 0.6638, 0.1223> <0.0524, 0.6527, 0.1643> <0.0095, 0.6440, 0.1998>
		<-0.0989, 0.6639, 0.0804> <-0.0450, 0.6646, 0.1238> <-0.0592, 0.6543, 0.1639> <0.0019, 0.6447, 0.1949>
		<-0.2076, 0.6772, 0.0878> <-0.1536, 0.6779, 0.1312> <-0.0649, 0.6548, 0.1602> <-0.0038, 0.6452, 0.1912>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1582, 0.6726, 0.0853> <0.1218, 0.6744, 0.1282> <0.0581, 0.6522, 0.1680> <0.0152, 0.6434, 0.2034>
		<0.0491, 0.6619, 0.0793> <0.0127, 0.6638, 0.1223> <0.0524, 0.6527, 0.1643> <0.0095, 0.6440, 0.1998>
		<-0.0989, 0.6639, 0.0804> <-0.0450, 0.6646, 0.1238> <-0.0592, 0.6543, 0.1639> <0.0019, 0.6447, 0.1949>
		<-0.2076, 0.6772, 0.0878> <-0.1536, 0.6779, 0.1312> <-0.0649, 0.6548, 0.1602> <-0.0038, 0.6452, 0.1912>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2076, 0.6772, 0.0878> <-0.1536, 0.6779, 0.1312> <-0.0649, 0.6548, 0.1602> <-0.0038, 0.6452, 0.1912>
		<-0.2076, 0.6772, 0.0878> <-0.1733, 0.6803, 0.1326> <-0.1384, 0.6779, 0.1368> <-0.0773, 0.6684, 0.1678>
		<-0.2076, 0.6772, 0.0878> <-0.1733, 0.6803, 0.1326> <-0.1892, 0.6899, 0.1477> <-0.1831, 0.7064, 0.1569>
		<-0.2076, 0.6772, 0.0878> <-0.2272, 0.6796, 0.0892> <-0.2548, 0.7058, 0.1038> <-0.2488, 0.7223, 0.1130>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2488, 0.7223, 0.1130> <-0.1831, 0.7064, 0.1569> <-0.0773, 0.6684, 0.1678> <-0.0038, 0.6452, 0.1912>
		<-0.2382, 0.7514, 0.1293> <-0.1725, 0.7355, 0.1731> <-0.0772, 0.6691, 0.1737> <-0.0037, 0.6460, 0.1972>
		<-0.1894, 0.7738, 0.1365> <-0.1516, 0.7376, 0.1792> <-0.0521, 0.6906, 0.1876> <-0.0036, 0.6470, 0.2051>
		<-0.1652, 0.7932, 0.1526> <-0.1273, 0.7569, 0.1952> <-0.0520, 0.6914, 0.1935> <-0.0035, 0.6477, 0.2111>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0156, 0.6457, 0.2149> <0.0099, 0.6463, 0.2138> <0.0022, 0.6471, 0.2122> <-0.0035, 0.6477, 0.2111>
		<0.0155, 0.6450, 0.2115> <0.0098, 0.6456, 0.2103> <0.0021, 0.6464, 0.2063> <-0.0036, 0.6470, 0.2051>
		<0.0153, 0.6441, 0.2069> <0.0096, 0.6447, 0.2032> <0.0020, 0.6454, 0.2008> <-0.0037, 0.6460, 0.1972>
		<0.0152, 0.6434, 0.2034> <0.0095, 0.6440, 0.1998> <0.0019, 0.6447, 0.1949> <-0.0038, 0.6452, 0.1912>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0156, 0.6457, 0.2149> <0.0099, 0.6463, 0.2138> <0.0022, 0.6471, 0.2122> <-0.0035, 0.6477, 0.2111>
		<0.0155, 0.6450, 0.2115> <0.0098, 0.6456, 0.2103> <0.0021, 0.6464, 0.2063> <-0.0036, 0.6470, 0.2051>
		<0.0153, 0.6441, 0.2069> <0.0096, 0.6447, 0.2032> <0.0020, 0.6454, 0.2008> <-0.0037, 0.6460, 0.1972>
		<0.0152, 0.6434, 0.2034> <0.0095, 0.6440, 0.1998> <0.0019, 0.6447, 0.1949> <-0.0038, 0.6452, 0.1912>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0156, 0.6457, 0.2149> <0.0099, 0.6463, 0.2138> <0.0022, 0.6471, 0.2122> <-0.0035, 0.6477, 0.2111>
		<0.0155, 0.6450, 0.2115> <0.0098, 0.6456, 0.2103> <0.0021, 0.6464, 0.2063> <-0.0036, 0.6470, 0.2051>
		<0.0153, 0.6441, 0.2069> <0.0096, 0.6447, 0.2032> <0.0020, 0.6454, 0.2008> <-0.0037, 0.6460, 0.1972>
		<0.0152, 0.6434, 0.2034> <0.0095, 0.6440, 0.1998> <0.0019, 0.6447, 0.1949> <-0.0038, 0.6452, 0.1912>
	}
}
