#include "colors.inc"
#include "textures.inc"
#include "skies.inc"

// separate my text from the other texts in the window
#debug "\n"

global_settings
{
  max_trace_level 30
  radiosity
  {
    distance_maximum 1000
  }
}

#declare Do_Area_Lights = on
#declare Do_Lens        = on
#declare Do_Star        = off
#declare Do_Sun         = on
#declare Do_Sun_2       = off
#declare Do_Ambient  		= on
#declare Do_Mountain 		= on
#declare Do_Water    		= on
#declare Do_Real_Water  = on
#declare Do_Sky      		= on
#declare Do_Clouds   		= off
#declare Do_Fog      		= on
#declare Do_Boat     		= on
#declare Do_Moon        = off
#declare Do_Tree        = on
#declare Do_Pier        = on
#declare Do_Bridge      = on
#declare Do_Wizard      = on
#declare Do_Pyrotechs   = on
#declare Do_FlyingMtns  = on

#declare num_points      = 32
#declare arc_radius      = 30
#declare point_to_find   = 24 + clock * 32

#include "ring.inc"

/* Default View */
#declare camera_location = arc_point + 2 * y
#declare camera_look_at  = <0,5,0>
/**/

/* Looking from the pier
#declare camera_location = <0,1,0>
#declare camera_location = camera_location - z * 1.5
#declare camera_location = camera_location * 0.8
#declare camera_location = vrotate( camera_location, -y * 50 )
#declare camera_location = camera_location + <-7.5,0,-7.5>
#declare camera_look_at  = <0,2,-2>
*/

/* Looking from the bridge
#declare camera_location = <-7,1.5,-8>
#declare camera_look_at  = <-5,0,1>
*/

/* Zoom on Wizard
#declare camera_location = <0,25*0.65+0.5,-5>
#declare camera_look_at  = <0,25*0.64+0.5,0>
*/

#declare sun_location    = <0,10000,0>
#declare sun_rot_x       = <80,0,0>
#declare sun_rot_y       = <0,-15,0>

#declare sun2_location   = <0,10000,0>
#declare sun2_rot_x      = <70,0,0>
#declare sun2_rot_y      = <0,15,0>

#declare light_source_transform =
  transform
  {
    rotate  sun_rot_x
    rotate  sun_rot_y
  }

#if ( Do_Lens )

  #debug "Parsing sun's lens effect.\n"

	#declare effect_type     = "SUN"
	#declare effect_location = sun_location
	#declare effect_location = vrotate( effect_location, sun_rot_x )
	#declare effect_location = vrotate( effect_location, sun_rot_y )
  #declare options_only    = true

	#include "lens.inc"

  #declare effect_brightness = 1.5

  #include "lnsefcts.inc"

  #declare suncolor = source_colour * 2

#else

  #declare suncolor = rgb <1,1,1>

#end

#if ( Do_Star )

  #debug "Parsing star's lens effect.\n"

  #declare effect_type     = "SUN"
  #declare effect_location = sun2_location
	#declare effect_location = vrotate( effect_location, sun2_rot_x )
	#declare effect_location = vrotate( effect_location, sun2_rot_y )
  #declare options_only    = true

  #include "lens.inc"

  #declare effect_scale    = 0.3
  #declare effect_colour   = <1,1,3>

  #include "lnsefcts.inc"

  #declare sun2color = source_colour * effect_scale

#else

  #declare sun2color = rgb <0.5,0.5,1.0>

#end

camera
{
  location camera_location
  look_at  camera_look_at
}

#if ( Do_Sun )

  #debug "Parsing sun.\n"

  light_source
  {
    sun_location
    color suncolor

    #if ( Do_Area_Lights )

      area_light x*100,y*100,4,4

    #end

    jitter
    transform light_source_transform
  }

#end

#if ( Do_Sun_2 )

  #debug "Parsing star.\n"

  light_source
  {
    sun2_location
    color sun2color

    #if ( Do_Area_Lights )

      area_light x*100,y*100,4,4

    #end

    jitter
    rotate sun2_rot_x
    rotate sun2_rot_y
  }

#end

#if ( Do_Ambient )

  #debug "Parsing ambient light source.\n"

  light_source
  {
    camera_location
    color Gray50
    shadowless
  }

#end

#if ( Do_Mountain | Do_FlyingMtns  )

  #debug "Parsing mountains.\n"

  #declare Mountain =
    height_field
    {
      tga "m.tga"
      smooth
      translate <-0.5,-0.35,-0.5>
    }

  #declare GrassyTexture =
    texture
    {
      pigment
      {
        bozo
        turbulence 1.0
        omega 0.25
        color_map
        {
          [ 0.0 color rgb <0.4,1.0,0.4> ]
          [ 0.3 color rgb <0.0,1.0,0.0> ]
          [ 0.5 color rgbf 1 ]
          [ 0.8 color rgb <0.4,1.0,0.4> ]
          [ 1.0 color rgb <0.7,1.0,0.7> ]
        }
        scale 0.3
      }
      normal { wrinkles 1.0 turbulence 0.5 scale 0.05 }
      finish { ambient 0.1 diffuse 0.6 }
    }

  #declare LayeredRockTexture =
    texture
    {
      pigment
      {
        bozo
        turbulence 0.7
        omega 0.2
        color_map
        {
          [ 0.00 color rgb <0.8,0.8,0.6> ]
          [ 0.30 color rgb <0.4,0.4,0.4> ]
          [ 0.50 color rgb <0.2,0.2,0.2> ]
          [ 0.70 color rgb <0.6,0.6,0.6> ]
          [ 1.00 color rgb <0.8,0.8,0.6> ]
        }
        scale 0.05
      }
      normal
      {
        crackle 1.0 turbulence 0.5 scale 0.03
        bump_size 5
      }
      finish { ambient 0.1 diffuse 0.7 }
    }

  #declare MountainTexture =
    texture { LayeredRockTexture }
    texture { GrassyTexture }

  #if ( Do_Mountain )

    #debug " - Building mountains.\n"

    object
    {
      Mountain
      texture { MountainTexture }
      scale <45,25,20>
    }

  #end

  #if ( Do_FlyingMtns )

    #debug " - Building flying mountains.\n"

    #declare FlyingMountain =
      intersection
      {
        object { Mountain }
        height_field
        {
          tga "under.tga"
          smooth
          translate <-0.5,0.2,-0.5>
          scale <1,-0.5,1>
        }
      }

    object
    {
      FlyingMountain
      texture { MountainTexture }
      scale <25,25,25>
      rotate y*45
      translate <50,25,70>
    }

    object
    {
      FlyingMountain
      texture { MountainTexture rotate y*180 }
      scale <30,15,40>
      rotate y*180
      translate <-70,70,130>
    }

  #end

#end

#if ( Do_Water )

  #debug "Parsing water.\n"

  #declare WaterTexture =
    texture
    {
      #if ( Do_Real_Water )

        pigment
        {
          bozo
          turbulence 1.0
          color_map
          {
            [ 0.00 color rgbf <0.0,0.1,1.0,0.0> ]
            [ 0.35 color rgbf <0.3,0.4,1.0,1.0> ]
            [ 0.55 color rgbf <0.3,0.4,1.0,1.0> ]
            [ 1.00 color rgbf <0.0,0.1,1.0,0.0> ]
          }
        }
        normal
        {
          average
          normal_map
          {
            [ 0.5 crackle 1.0 turbulence 0.3 ]
            [ 1.0 onion   0.2 turbulence 0.5 scale 2 sine_wave ]
          }
        }
        finish
        {
          ambient    0.1
          diffuse    0.8
          reflection 0.5
          specular   1.0
          roughness  0.001
          refraction on
          ior        1.5
        }

      #else

        pigment { rgb 1 }
        finish  { ambient 1.0 }

      #end
    }

  plane
  {
    y, 0
    texture { WaterTexture }
    scale 0.2
  }

  plane
  {
    y, -0.35
    texture { pigment { color Blue } }
    scale <45,25,20>
  }

#end

#if ( Do_Sky )

  #debug "Parsing sky.\n"

  sky_sphere
  {
    pigment
    {
      /*
      gradient y
      color_map
      {
        [ 0.0 color rgb <0.2,0.2,1.0> ]
        [ 0.2 color rgb <0.3,0.3,1.0> ]
        [ 0.4 color rgb <0.4,0.4,1.0> ]
        [ 0.6 color rgb <0.6,0.6,1.0> ]
        [ 0.8 color rgb <0.6,0.6,1.0> ]
        [ 0.9 color rgb <0.7,0.7,0.9> ]
        [ 0.99 color rgb <0.8,0.8,0.8> ]
        [ 1.0 color rgb <1.0,1.0,0.5> ]
      }
      */
      color rgb <0.5,0.7,1.0>
      transform light_source_transform
    }
  }

#end

#if ( Do_Clouds )

  #debug "Parsing clouds.\n"

  sphere
  {
    0, 5000
    scale <1,0.6,1>
    no_shadow
    hollow
    texture
    {
      pigment
      {
        leopard
        turbulence 1.0
        omega 0.25
        color_map
        {
          [0.00 rgbt <1,1,1,0.4>]
          [0.30 rgbt <1,0.3,0.3,0.6>]
          [0.60 rgbf 1 ]
          [1.00 rgbf 1 ]
        }
        triangle_wave
      }
      finish
      {
        ambient 0.8
      }
      scale 1000
    }
  }

#end

#if ( Do_Fog )

  #debug "Parsing ambient fog.\n"

  fog
  {
    fog_type   1
    distance 100
    color    rgbft <1,1,1,0.3,0.5>
    turbulence 0.7
  }

#end

#if ( Do_Boat )

  #debug "Parsing boat.\n"

  #include "boathull.inc"

  #declare Boat =
    union
    {
      object { BoatHull texture { pigment { DMFWood2 } scale 0.5 } }
      cylinder { 0, 4*y, 0.01 texture { Chrome_Metal } }
      triangle { <0,4,0>, <0,1,0>, <3,1,0> texture { pigment { color Red } } }
    }

  object
  {
    Boat
    scale 0.5
    rotate -y*45
    translate <7,-0.2,-10>
  }

#end

#if ( Do_Moon )

  #debug "Parsing moon.\n"

  #declare Moon =
  	sphere
    {
    	0, 1000
      texture
      {
      	pigment
        {
          leopard
          turbulence 0.2
          color_map
          {
          	[ 0	color rgbf <1,1,1,0.99> ]
          	[ 1 color rgbf <0.5,0.5,0.5,0.5> ]
          }
          scale 250
        }
        normal { crackle 1.0 scale 100 bump_size 3 }
        finish
        {
        	diffuse 1.0
          ambient 0.0
        }
      }
    }

  object
  {
    Moon
    translate <0,5000,10000>
  }

#end

#if ( Do_Tree )

  #debug "Parsing tree.\n"

  object
  {
    #declare BaseLen=2
    #include "trees.inc"
//    cone { 0,0,9*y,3 pigment { color Red } }
    scale <0.1,0.1,0.1>
    translate <-9,0.9,-6.5>
  }

#end

#if ( Do_Pier )

  #debug "Parsing pier.\n"

  #declare PierColumn = cylinder { -3*y,0.6*y,0.1 texture { pigment { DMFWood1 } scale 0.3 } }

  #declare Pier =
    union
    {
      object { PierColumn translate <-0.5,0,0> }
      object { PierColumn translate < 0.5,0,0> }
      object { PierColumn translate <-0.5,0,1> }
      object { PierColumn translate < 0.5,0,1> }
      object { PierColumn translate <-0.5,0,2> }
      object { PierColumn translate < 0.5,0,2> }
      box    { <-0.5,0.2,0>,<0.5,0.1,3> texture { pigment { DMFWood1 } scale 0.3 } }
    }

  object
  {
    Pier
    translate -z*2
    scale 0.8
    rotate -y*50
    translate <-7.5,0,-7.5>
  }

#end

#if ( Do_Bridge )

  #debug "Parsing bridge.\n"

  #declare BridgeRail =
    difference
    {
      cylinder { z*0.1, -z*0.1, 1.1 }
      cylinder { z*0.2, -z*0.2, 0.8 }
      plane    { y, 0 }
      scale <1.5,1,1>
    }

  #declare BridgeBase =
    difference
    {
      cylinder { z*0.4, -z*0.4, 1.0 }
      cylinder { z*0.6, -z*0.6, 0.9 }
      plane    { y, 0 }
      scale <1.5,1,1>
    }

  #declare Bridge =
    union
    {
      object { BridgeBase }
      object { BridgeRail translate  z*0.4 }
      object { BridgeRail translate -z*0.5 }
    }

  #declare BridgeTexture =
    texture
    {
      pigment { color White }
      normal  { crackle 1.0 turbulence 0.2 scale 0.3 }
      finish  { diffuse 0.6 specular 0.3 roughness 0.5 }
    }

  object
  {
    Bridge
    texture { BridgeTexture }
    translate <1.5,0,0>
    scale <1.5,0.8,0.8>
    rotate -y*60
    translate <-7,0,-6>
  }

#end

#if ( Do_Wizard )

  #debug "Parsing wizard.\n"

  #include "wizard.inc"

  object
  {
    Wizard
    scale 1.5
    //cone { 0,0,3*y,1 pigment { color Red } }
    translate y*25*0.65 + y*0.4
  }

#end

#if ( Do_Pyrotechs )

  #debug "Parsing pyrotechnics.\n"
  #debug " - "

  #declare dust_start  = <0,25*0.65+2,0>
  #declare dust_object = box { 1,-1 scale 0.02 }
  #declare dust_finish = finish { ambient 1.0 diffuse 1.0 }
  #declare dust_seed   = seed( 100 )
  #declare num_points  = 40
  #declare num_loops   =  4
  #declare gravity     = <0,-9.8,0>
  #declare init_radius =  0
  #declare initial_vel = <0,1,0>
  #declare radius_grow =  0.065
  #declare time_speed  =  2
  #declare max_specks  = 200
  #declare min_specks  = 100
  #declare hose_radius = 0.01
  #declare hose_grow   = 0.005
  #declare minr        = 0.0
  #declare ming        = 0.0
  #declare minb        = 0.0
  #declare maxr        = 0.4
  #declare maxg        = 0.4
  #declare maxb        = 0.4
  #declare grayscale   = true

  #declare maxgray = ( maxr + maxg + maxb ) / 3
  #declare mingray = ( minr + ming + minb ) / 3

  #declare point_to_find = 1
  #declare arc_radius    = init_radius

  #declare last_speck  = dust_start
  #declare last_radius = hose_radius

  #declare count_inc   = 10
  #declare count_to    = int( num_points * num_loops / count_inc )

  union
  {

    #while ( point_to_find < num_points * num_loops )

      #if ( mod( point_to_find, count_inc ) = 0 )

        #debug concat( str( count_to - int( point_to_find / count_inc ), 0, 0 ), "." )

      #end

      #declare time = point_to_find / ( num_points * num_loops ) * time_speed

      #include "ring.inc"
      #declare arc_point = arc_point + dust_start
      #declare fall_dist = 0.5 * gravity * time * time + initial_vel * time
      #declare arc_point = arc_point + fall_dist
      #declare arc_radius = arc_radius + radius_grow

      #declare num_specks = rand( dust_seed) * ( max_specks - min_specks ) + min_specks
      #declare num_specks = num_specks * time

      #declare distances = arc_point - last_speck

      #declare new_radius = last_radius + hose_grow

  //    cone
  //    {
  //      last_speck, last_radius,
  //      arc_point, new_radius
  //    }

      #declare speck_count = 0
      #while ( speck_count < num_specks )

        #declare _x = rand( dust_seed ) * 3 * time
        #declare _y = rand( dust_seed ) * 3 * time
        #declare _z = rand( dust_seed ) * 3 * time

        #declare speck_spot = arc_point + <_x,_y,_z> * distances

        #if ( grayscale )

          #declare speck_rgb = rand( dust_seed ) * ( maxgray - mingray ) + mingray

          #declare speck_color = color rgb < speck_rgb, speck_rgb, speck_rgb >

        #else

          #declare _r = rand( dust_seed ) * ( maxr - minr ) + minr
          #declare _g = rand( dust_seed ) * ( maxg - ming ) + ming
          #declare _b = rand( dust_seed ) * ( maxb - minb ) + minb

          #declare speck_color = color rgb < _r, _g, _b >

        #end

        object
        {
          dust_object
          translate speck_spot
          texture
          {
            pigment { color speck_color }
            finish  { dust_finish }
          }
        }

        #declare speck_count = speck_count + 1

      #end

      #declare last_speck    = arc_point
      #declare last_radius   = new_radius
      #declare point_to_find = point_to_find + 1

    #end

    #debug "\n"

  } // end union

#end

#debug "\nFinished with parse.  Preparing to render scene.\n\n"

