//-------------------------------
// WIZARD.INC
//-------------------------------

#include "cape.inc"

#declare Height = 1
#declare Gender = 1

#declare Head_Rotation = transform { rotate -x*30 }

#declare R_Arm_Rotation = transform { rotate y*90 rotate z*135 rotate x*10}
  #declare R_Elbow_Rotation = transform { rotate -x*45 }

#declare L_Arm_Rotation = transform { rotate -y*90 rotate -z*135 rotate x*70  }
  #declare L_Elbow_Rotation = transform { rotate -x*45 }

#declare R_Leg_Rotation = transform { rotate z*10 }

#declare L_Leg_Rotation = transform { rotate -z*10 }

#include "person.inc"

#declare WizardHat =
  union
  {
    disc { 0, y, 0.15 }
    cone { 0, 0.075, 0.2*y, 0 }
    transform Head_Rotation
    rotate -x*15
  }

#declare CapeTexture =
  texture
  {
    pigment
    {
      granite
      turbulence 0.5
      color_map
      {
        [0 color Blue  ]
        [1 color White ]
      }
    }
    normal
    {
      quilted 0.2
      scale 0.01
      rotate z*60
    }
    finish
    {
      diffuse   0.7
      ambient   0.0
      specular  0.5
      roughness 0.05
    }
  }

#declare Wizard =
  union
  {
    object { Person }
    object
    {
      Cape
      scale <-0.5,0.7,-0.5>
      translate <0,-0.4,-0.1>
      texture { CapeTexture }
    }
//    object
//    {
//      WizardHat
//      translate <0,0.45,-0.05>
//      texture { CapeTexture }
//    }
  }

