camera {
  location <0,32,-100>
  direction <0,0,1>
  up <0,1,0>
  right <1.25,0,0>
  look_at <0,2,0>
}

fog {
  distance 200
  color rgbt<0.5,0.5,0.5,0.54>
  fog_type 2
  fog_offset -8
  fog_alt 12
  turbulence 0.125
  turb_depth 0.25
}

light_source { <500,1000,-750> color rgb<0.22,0.22,0.22> shadowless }
light_source { <-2100,1000,10000> color rgb<0.8,0.8,0.8> }

sphere { <-2100,1000,10000>, 600
  pigment {
    bozo color_map {
      [0 color rgb<1,1,1>]
      [1 color rgb<0.6,0.6,0.6>]
    }
    turbulence 3
    scale 1000
  }
  finish { ambient 0.5 diffuse 0.5 }
  no_shadow
}

#include "arm.inc"

object { Arm rotate -90*x scale <1,1,-1> translate -28*y scale 0.11 rotate 90*y
  rotate <25,0,-20> scale 0.9 translate -40*z
  pigment { rgb<1,0.6,0.4> }
}

#include "sword.inc"

object { Sword rotate <25,0,-20> scale 0.9 translate -40*z }

object {
  SwordOutline
  pigment {
    crackle color_map {
      [0 color rgbt<0.8,0.6,1,0.6>]
      [0.036 color rgbt<0.3,0.1,0.5,1>]
    }
    turbulence 1
    scale 5
  }
  finish { ambient 1 diffuse 0 }
  no_shadow
  rotate <25,0,-20> scale 0.9 translate -40*z
}

plane { <0,1,0>, -15
  pigment { rgb<0.1,0.3,0.5> }
  normal { ripples 0.3 scale 3000 frequency 1000 }
  finish { reflection 0.4 phong 0.6 phong_size 180 }
}

#declare Ripples0 =
texture {
  pigment { rgbt<0.1,0.3,0.5,0.15> }
  normal { wood 0.3 frequency 36.5 scallop_wave }
  finish { reflection 0.4 phong 0.6 phong_size 180 }
}

#declare Ripples1 =
texture {
  pigment { rgbt<0.1,0.3,0.5,0.15> }
  normal { wood 0.3 frequency 22.5 scallop_wave }
  finish { reflection 0.4 phong 0.6 phong_size 180 }
}

#declare Ripples2 =
texture {
  pigment { rgbt<0.1,0.3,0.5,0.15> }
  normal { wood 0.3 frequency 12.5 scallop_wave }
  finish { reflection 0.4 phong 0.6 phong_size 180 }
}

#declare Clear =
texture {
  pigment { rgbt<0.1,0.3,0.5,1> }
}

disc { <0,-14.999,0>, <0,1,0>, 25
  texture {
    wood texture_map {
      [0 Ripples1]
      [0.75 Ripples0]
      [1 Clear] 
    }
    scale 50
    rotate 90*x
  }
  no_shadow
  translate <-7.6,0,-32.4>
  hollow
}

sphere { <0,0,0>, 100000
  pigment {
    leopard color_map {
      [0 color rgbt<1,1,1,1>]
      [0.88 color rgbt<1,1,1,1>]
      [0.92 color rgbt<1,1,1,0>]
    }
    scale 5
    turbulence 0.25
  }
  finish { ambient 1 diffuse 0 }
  hollow
  rotate 60*y
}

sphere { <0,0,0>, 8000
  pigment {
    bozo color_map {
      [0 color rgbt<0.2,0.2,0.2,1>]
      [0.5 color rgbt<0.2,0.2,0.2,1>]
      [1 color rgbt<0.2,0.2,0.2,0.4>]
    }
    turbulence 1.8
    scale <4000,1600,4000>
  }
  finish { ambient 1 diffuse 0 }
  no_shadow
  hollow
  rotate 30*y
}

blob {
  threshold 0.1
  #declare Count = 0
  #declare S = seed(69)
  #while (Count < 24)
    #declare Num = (24 - Count*Count*Count/(23*23))*6
    #declare Count2 = 0
    #declare R = seed(42)
    #while (Count2 < Num)
      #declare PosX = (rand(S)-0.5)*0.314/(Num/72) + 2.35619449019*(Count*Count*Count*Count*Count)/(23*23*23*23*23)
      sphere { <3+6*PosX, 6*sin(PosX) - 5,0>, 0.3 + (24-Count)/16, 1 rotate (360*rand(R) + 2*rand(S))*y }
      #declare Count2 = Count2 + 1
    #end
    #declare Count = Count + 1
  #end
  pigment { rgbt<0.1,0.3,0.5,1> }
  finish {
    refraction 1
    ior 1.333
    reflection 0.4
    phong 0.6
    phong_size 180
    caustics 1
  }
  translate <-7.6,-10,-32.4>
}

#declare Count = 0
#while (Count < 4)
  #declare Radius = rand(S)*6 + 6
  disc { <0,0,0>, <0,1,0>, Radius
    texture {
      wood texture_map {
        [0 Ripples2]
        [0.75 Ripples1]
        [1 Clear]
      }
      scale Radius*2
      rotate 90*x
    }
    translate <23.8495559215,-14.998 + 0.0005*Count,0>
    rotate 360*rand(R)*y
    translate <-7.6,0,-32.4>
    no_shadow
    hollow
  }
  #declare Count = Count+1
#end

height_field { tga "coast.tga"
  pigment {
    granite color_map {
      [0 color rgb<0.6,0.4,0.1>]
      [0.2 color rgb<0.4,0.2,0>]
      [0.4 color rgb<0.3,0,0>]
      [0.6 color rgb<0.2,0.2,0.2>]
      [0.8 color rgb<0.4,0.3,0.15>]
      [1 color rgb<0.6,0.4,0.1>]
    }
    turbulence 0.5
    scale 0.05
  }
  translate -0.5*x
  scale <2000,500,5000>
  translate <200,-20,500>
}
