camera {
  location <-20,6,-50>
//  location <0,320,800>
  direction <0,0,1.1>
//0.6>
  up <0,1,0>
  right <1.33,0,0>
  look_at <0,22,0>
//  look_at <0,0,1200>
}

//plane { <0,1,0>, 150 pigment { checker color rgbt<1,1,1,1> color rgbt<1,1,1,0.6> scale 200 } }

/* neato rainbow around sun */
rainbow {
  angle 14
  width 6
  distance 1000000
  direction <-0.036,0.45,1>
  color_map {
    [0 color rgbt<1,0,1,1>]
    [0.143 color rgbt<1,0,1,0.9>]
    [0.286 color rgbt<0,0,1,0.9>]
    [0.4 color rgbt<0,1,1,0.9>]
    [0.468 color rgbt<0,1,1,0.9>]
    [0.541 color rgbt<0,0.7,0,0.9>]
    [0.7 color rgbt<1,1,0,0.9>]
    [0.8 color rgbt<1,0.7,0,0.9>]
    [0.9 color rgbt<1,0,0,0.9>]
    [1 color rgbt<1,0,0,1>]
  }
}

/* mild directional ambient lighting... */
light_source { <-50,100,-200> color rgb<0.25,0.25,0.25> }

#include "sword.inc"

/* Excalibur */
object { Sword scale <1,-1,1> translate 52*y rotate 15*x translate 3*y}

/* magical lightning outline around blade of sword */
object {
  SwordOutline
  pigment {
    crackle color_map {
      [0 color rgbt<0.4,0.6,1,0>]
      [0.05 color rgbt<0,0.25,0.5,1>]
    }
    turbulence 1
    scale 5
  }
  finish { ambient 1 diffuse 0 }
  scale <1,-1,1> translate 52*y rotate 15*x translate 3*y
  no_shadow
}

/* mountains in back */
height_field {
  tga "land.tga"
  water_level 0.08
  translate <-0.5,-0.08,0>
  scale <6000,2700,6000>
  texture {
    pigment {
      agate color_map {
        [0 color rgb<0.5,0.3,0.2>]
        [1 color rgb<0.45,0.25,0.15>]
      }
      turbulence 5
      scale 1200
    }
    finish { ambient 0.2 diffuse 0.8 }
  }
  texture {
    // this part hides the base of the mountain, blending it with the forest
    pigment {
      gradient y color_map {
        [0 color rgb<0,0.1,0>]
        [0.1 color rgb<0,0.1,0>]
        [0.1 color rgbt<1,1,1,1>]
      }
      scale 3000
    }
  }
  translate -1200*z
}

/* sun (and corresponding light source) */
sphere { <-36000,450000,1000000>, 80000 pigment { color rgb<1,0.9,0.6> } finish { ambient 1 } no_shadow }
light_source { <-36000,450000,1000000> color rgb<1,0.96,0.72> }

/* the sunrise horizon */
sphere { <0,0,0>, 5000000
  pigment {
    gradient y color_map {
      [0 color rgb<1,0.4,0.6>]
      [0.4 color rgb<0,0.3,0.5>]
      [0.64 color rgb<0,0,0.2>]
      [1 color rgb<0,0,0.2>]
    }
    turbulence 0.1
    scale 5000001
    rotate -12*x
  }
  finish { ambient 1 diffuse 0 }
  hollow
}

/* clouds around... */
sphere { <0,0,0>, 500000
  pigment {
    bozo color_map {
      [0 color rgbt<1,1,1,1>]
      [0.3 color rgbt<1,1,1,1>]
      [1 color rgbt<1,1,1,0.6>]
    }
    turbulence 2
    scale <150000,60000,150000>
  }
  finish { ambient 1 diffuse 0 }
  hollow
}

/* clouds above... */
plane { <0,1,0>, 460000
  pigment {
    bozo color_map {
      [0 color rgbt<1,1,1,1>]
      [0.4 color rgbt<1,1,1,1>]
      [1 color rgbt<1,1,1,0.4>]
    }
    turbulence 1
    scale <90000,120000,120000>
  }
  finish { ambient 1 diffuse 0 }
  hollow
}

/* the stone where the sword is stuck */
sphere { <0,0,0>, 20
  scale <1,0.75,1>
  translate -6*y
  pigment {
    agate color_map {
      [0 color rgb<0.4,0.4,0.4>]
      [1 color rgb<0.5,0.5,0.5>]
    }
    turbulence 0.3
    scale 10
  }
  normal {
    bumps 0.64 scale 0.12
  }
  translate <4,0,8>
}

/* ground */
plane { <0,1,0>, -13
  pigment {
    agate color_map {
      [0 color rgb<0.6,0.5,0.4>]
      [1 color rgb<0.5,0.4,0.3>]
    }
    turbulence 1
    scale 100
  }
  normal { bumps 0.4 scale 0.5 }
}

#include "tree.inc"

union {
#declare R = seed(69)
#declare CountZ = 0
#while (CountZ < 16)
  #declare CountX = 0
  #while (CountX < 20)
    #declare Num = rand(R)*4
    #if (Num <= 1)
      object { Tree1 rotate (rand(R)-0.5)*30*y scale 80 translate 27*y translate <-1600+CountX*150+rand(R)*20,0,350+CountZ*150+rand(R)*20> }
    #else
    #if (Num <= 2)
      object { Tree2 rotate (rand(R)-0.5)*30*y scale 80 translate 27*y translate <-1600+CountX*150+rand(R)*20,0,350+CountZ*150+rand(R)*20> }
    #else
    #if (Num <= 3)
      object { Tree3 rotate (rand(R)-0.5)*30*y scale 80 translate 27*y translate <-1600+CountX*150+rand(R)*20,0,350+CountZ*150+rand(R)*20> }
    #else
      object { Tree4 rotate (rand(R)-0.5)*30*y scale 80 translate 27*y translate <-1600+CountX*150+rand(R)*20,0,350+CountZ*150+rand(R)*20> }
    #end
    #end
    #end
    #declare CountX = CountX + 1
  #end
  #declare CountZ = CountZ + 1
#end
  rotate 22*y
}
