//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 2 lights, 17 textures and 46 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5b.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 08/21/1997    (21.08.1997)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray exports for POV-Ray.
//





global_settings {
  adc_bailout 0.003922
  ambient_light <0.835, 0.708, 0.408>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.100,0.100,0.150> }

camera {  //  Camera StdCam
  location  <-6.068, -34.134, 6.187>
  direction <0.0,     0.0,  1.4739>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.00000, 0.0,  0.0>
  look_at   <1.051, -0.460, 2.924>
}

// *******  L I G H T S *******

/*light_source {
  <-10.000, 43.900, 15>
  color rgb <0.835, 0.708, 0.408>
  fade_distance  .5
  fade_power 2
}*/

// ********  TEXTURES  *******
//

#include "lead.inc"



// ********  REFERENCED OBJECTS  *******

#declare TableLeg = object {
  cone { // TableLeg
    <0,0,0>, 1.0, <0,0,1>, 2.0
    scale <1.0, 1.0, 20.0>
    translate  <17.0, 7.0, -21.0>
  }
}
//
// Include file contains 'Shaft'
//
#include "lead.in1"
#declare Shaft = object {
  Shaft_Raw
}
//
// Include file contains 'Cup'
//
#include "lead.in2"
#declare Cup = object {
  Cup_Raw
  translate  1.0*z
}
#declare CandleBase = union {
  object { Shaft }
  object { Cup }
  texture {
    CopperTex
  }
}
#declare Flame = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.064717, -0.005299, 0.003974>, <-0.064717, -0.074671, 0.005299>, <-0.069373, -0.077963, 0.005299>, <-0.002649, -0.077963, 0.006623>,
      <-0.276659, 0.037090, 0.118460>, <-0.276659, -0.093216, 0.118460>, <-0.170045, -0.199830, 0.118460>, <-0.039739, -0.199830, 0.118460>,
      <-0.276659, 0.037090, 0.236920>, <-0.276659, -0.093216, 0.236920>, <-0.170045, -0.199830, 0.236920>, <-0.039739, -0.199830, 0.236920>,
      <-0.204378, -0.006499, 0.344310>, <-0.206453, -0.111761, 0.351406>, <-0.099839, -0.218375, 0.351406>, <-0.001890, -0.214767, 0.340457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.002649, -0.077963, 0.006623>, <0.064074, -0.077963, 0.007948>, <0.062068, -0.074671, 0.010597>, <0.062068, -0.005299, 0.009272>,
      <-0.039739, -0.199830, 0.118460>, <0.090567, -0.199830, 0.118460>, <0.197181, -0.093216, 0.118460>, <0.197181, 0.037090, 0.118460>,
      <-0.039739, -0.199830, 0.236920>, <0.090567, -0.199830, 0.236920>, <0.197181, -0.093216, 0.236920>, <0.197181, 0.037090, 0.236920>,
      <-0.001890, -0.214767, 0.340457>, <0.097190, -0.218375, 0.343459>, <0.203804, -0.111761, 0.343459>, <0.200599, -0.006499, 0.336604>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.062068, -0.005299, 0.009272>, <0.062068, 0.064074, 0.007948>, <0.064074, 0.072665, 0.005299>, <-0.002649, 0.072665, 0.003974>,
      <0.197181, 0.037090, 0.118460>, <0.197181, 0.167396, 0.118460>, <0.090567, 0.274010, 0.118460>, <-0.039739, 0.274010, 0.118460>,
      <0.197181, 0.037090, 0.236920>, <0.197181, 0.167396, 0.236920>, <0.090567, 0.274010, 0.236920>, <-0.039739, 0.274010, 0.236920>,
      <0.200599, -0.006499, 0.336604>, <0.203804, 0.097190, 0.343459>, <0.097190, 0.203804, 0.343459>, <-0.001890, 0.201769, 0.340457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.002649, 0.072665, 0.003974>, <-0.069373, 0.072665, 0.002649>, <-0.064717, 0.064074, 0.002649>, <-0.064717, -0.005299, 0.003974>,
      <-0.039739, 0.274010, 0.118460>, <-0.170045, 0.274010, 0.118460>, <-0.276659, 0.167396, 0.118460>, <-0.276659, 0.037090, 0.118460>,
      <-0.039739, 0.274010, 0.236920>, <-0.170045, 0.274010, 0.236920>, <-0.276659, 0.167396, 0.236920>, <-0.276659, 0.037090, 0.236920>,
      <-0.001890, 0.201769, 0.340457>, <-0.099839, 0.203804, 0.351406>, <-0.206453, 0.097190, 0.351406>, <-0.204378, -0.006499, 0.344310>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.204378, -0.006499, 0.344310>, <-0.206453, -0.111761, 0.351406>, <-0.099839, -0.218375, 0.351406>, <-0.001890, -0.214767, 0.340457>,
      <-0.136248, -0.051661, 0.465893>, <-0.136248, -0.130306, 0.465893>, <-0.029633, -0.236920, 0.465893>, <0.037090, -0.236920, 0.457945>,
      <-0.136248, -0.056960, 0.548587>, <-0.136248, -0.061425, 0.549912>, <-0.029633, -0.186584, 0.549912>, <0.037090, -0.186584, 0.541964>,
      <0.041254, -0.035765, 0.713410>, <0.041254, -0.037581, 0.713410>, <0.041897, -0.038224, 0.721358>, <0.042388, -0.038224, 0.722682>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.001890, -0.214767, 0.340457>, <0.097190, -0.218375, 0.343459>, <0.203804, -0.111761, 0.343459>, <0.200599, -0.006499, 0.336604>,
      <0.037090, -0.236920, 0.457945>, <0.103813, -0.236920, 0.449997>, <0.210427, -0.130306, 0.449997>, <0.210427, -0.051661, 0.449997>,
      <0.037090, -0.186584, 0.541964>, <0.103813, -0.186584, 0.534016>, <0.210427, -0.061425, 0.534016>, <0.210427, -0.056960, 0.532692>,
      <0.042388, -0.038224, 0.722682>, <0.042880, -0.038224, 0.724007>, <0.040873, -0.037581, 0.721358>, <0.040873, -0.035765, 0.721358>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.200599, -0.006499, 0.336604>, <0.203804, 0.097190, 0.343459>, <0.097190, 0.203804, 0.343459>, <-0.001890, 0.201769, 0.340457>,
      <0.210427, -0.051661, 0.449997>, <0.210427, 0.026984, 0.449997>, <0.103813, 0.133598, 0.449997>, <0.037090, 0.133598, 0.457945>,
      <0.210427, -0.056960, 0.532692>, <0.210427, -0.052494, 0.531367>, <0.103813, 0.054120, 0.531367>, <0.037090, 0.054120, 0.539315>,
      <0.040873, -0.035765, 0.721358>, <0.040873, -0.033949, 0.721358>, <0.042880, -0.028008, 0.716059>, <0.042388, -0.028008, 0.714735>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.001890, 0.201769, 0.340457>, <-0.099839, 0.203804, 0.351406>, <-0.206453, 0.097190, 0.351406>, <-0.204378, -0.006499, 0.344310>,
      <0.037090, 0.133598, 0.457945>, <-0.029633, 0.133598, 0.465893>, <-0.136248, 0.026984, 0.465893>, <-0.136248, -0.051661, 0.465893>,
      <0.037090, 0.054120, 0.539315>, <-0.029633, 0.054120, 0.547263>, <-0.136248, -0.052494, 0.547263>, <-0.136248, -0.056960, 0.548587>,
      <0.042388, -0.028008, 0.714735>, <0.041897, -0.028008, 0.713410>, <0.041254, -0.033949, 0.713410>, <0.041254, -0.035765, 0.713410>
    }
  }
  texture {
    FlameTex
  }
  translate  <0.052406, 0.0, 2.80374>
}
#declare Wick = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.045903, 0.000000, 0.000000>, <-0.045903, -0.045903, 0.000000>, <0.045903, -0.045903, 0.000000>, <0.045903, 0.000000, 0.000000>,
      <-0.068688, 0.070108, 0.144387>, <-0.068688, 0.024205, 0.144387>, <0.023118, 0.024205, 0.144387>, <0.023118, 0.070108, 0.144387>,
      <-0.068688, 0.082377, 0.194128>, <-0.068688, 0.036474, 0.194128>, <0.023118, 0.036474, 0.194128>, <0.023118, 0.082377, 0.194128>,
      <-0.038486, 0.034005, 0.260296>, <-0.038892, -0.012601, 0.276293>, <0.052914, -0.012601, 0.276293>, <0.049222, 0.034005, 0.260296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045903, 0.000000, 0.000000>, <0.045903, 0.045903, 0.000000>, <-0.045903, 0.045903, 0.000000>, <-0.045903, 0.000000, 0.000000>,
      <0.023118, 0.070108, 0.144387>, <0.023118, 0.116011, 0.144387>, <-0.068688, 0.116011, 0.144387>, <-0.068688, 0.070108, 0.144387>,
      <0.023118, 0.082377, 0.194128>, <0.023118, 0.128280, 0.194128>, <-0.068688, 0.128280, 0.194128>, <-0.068688, 0.082377, 0.194128>,
      <0.049222, 0.034005, 0.260296>, <0.052914, 0.079204, 0.276293>, <-0.038892, 0.079204, 0.276293>, <-0.038486, 0.034005, 0.260296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.038486, 0.034005, 0.260296>, <-0.038892, -0.012601, 0.276293>, <0.052914, -0.012601, 0.276293>, <0.049222, 0.034005, 0.260296>,
      <-0.009096, -0.015774, 0.358459>, <-0.009096, -0.061677, 0.358459>, <0.082710, -0.061677, 0.358459>, <0.082710, -0.015774, 0.358459>,
      <-0.007223, -0.041756, 0.350604>, <-0.007223, -0.078208, 0.350604>, <0.065681, -0.078208, 0.350604>, <0.065681, -0.041756, 0.350604>,
      <0.015046, -0.043843, 0.418637>, <0.015046, -0.060114, 0.417941>, <0.044803, -0.060114, 0.417941>, <0.044803, -0.043843, 0.418637>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.049222, 0.034005, 0.260296>, <0.052914, 0.079204, 0.276293>, <-0.038892, 0.079204, 0.276293>, <-0.038486, 0.034005, 0.260296>,
      <0.082710, -0.015774, 0.358459>, <0.082710, 0.030129, 0.358459>, <-0.009096, 0.030129, 0.358459>, <-0.009096, -0.015774, 0.358459>,
      <0.065681, -0.041756, 0.350604>, <0.065681, -0.005303, 0.350604>, <-0.007223, -0.005303, 0.350604>, <-0.007223, -0.041756, 0.350604>,
      <0.044803, -0.043843, 0.418637>, <0.044803, -0.027573, 0.419333>, <0.015046, -0.027573, 0.419333>, <0.015046, -0.043843, 0.418637>
    }
  }
  texture {
    WickTex
  }
  translate  <0.0, 0.026203, 2.436896>
}
#declare Candle = union {
  superellipsoid { // Candlestick
    <1.0, 0.1>
    texture {
      WaxTex
    }
    scale <0.49, 0.49, 1.0>
    translate  1.5*z
  }
  object { CandleBase }
  object { Flame }
  object { Wick }
  translate  <-6.178663, -9.094436, 0.0>
}
#declare Candle1 = object {
  object { // Candle1->Candle
    Candle
    translate  <12.149056, -0.069423, 0.0>
  }
}
#declare Candle2 = object {
  object { // Candle2->Candle1
    Candle1
    translate  <-16.036753, 11.732517, 0.0>
  }
}
#declare Candle3 = object {
  object { // Candle3->Candle2
    Candle2
    translate  <20.202144, 0.069423, 0.0>
  }
}
#declare Halo1 = object {
  torus { // Halo1
    1.5, 0.5  rotate -x*90
    scale <1.0, 1.4, 1.2>
    rotate -90.0*y
    translate  <-1.768535, 0.0, 0.416126>
  }
}


#declare WinEdge = union {
  cylinder { // Arch2
    <0,0,1>, <0,0,0>, 1
    scale <3.0, 2.0, 12.0>
    rotate -90.0*x
    translate  <0.0, -6.0, 5.0>
  }
  box { // Win2
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 6.0, 7.0>
    translate  -2.0*z
  }
  scale <1.4, 1.0, 1.1>
}




#declare Ring = object {
  torus { // Ring
    4.0, 0.5  rotate -x*90
    translate  4.0*z
  }
}
#declare Leg = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.496838, -0.001628, 3.948864>, <4.501460, -0.253790, 3.947059>, <3.992390, -0.253790, 3.961734>, <3.992406, -0.001628, 3.962441>,
      <4.667470, -0.001628, -0.090520>, <4.668176, -0.253790, -0.090531>, <4.205148, -0.253790, -0.446091>, <4.204442, -0.001628, -0.446079>,
      <8.028766, -0.001628, -0.063247>, <8.029417, -0.253790, -0.062973>, <8.214359, -0.253790, -0.537752>, <8.213708, -0.001628, -0.538026>,
      <9.023630, -0.003266, 0.873387>, <9.024201, -0.253790, 0.873778>, <9.333296, -0.253790, 0.406395>, <9.332725, -0.003266, 0.406004>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.992406, -0.001628, 3.962441>, <3.992423, 0.250533, 3.963147>, <4.492216, 0.250533, 3.950669>, <4.496838, -0.001628, 3.948864>,
      <4.204442, -0.001628, -0.446079>, <4.203736, 0.250533, -0.446068>, <4.666763, 0.250533, -0.090509>, <4.667470, -0.001628, -0.090520>,
      <8.213708, -0.001628, -0.538026>, <8.213057, 0.250533, -0.538300>, <8.028114, 0.250533, -0.063521>, <8.028766, -0.001628, -0.063247>,
      <9.332725, -0.003266, 0.406004>, <9.332153, 0.250533, 0.405613>, <9.023058, 0.250533, 0.872996>, <9.023630, -0.003266, 0.873387>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <9.023630, -0.003266, 0.873387>, <9.024201, -0.253790, 0.873778>, <9.333296, -0.253790, 0.406395>, <9.332725, -0.003266, 0.406004>,
      <10.018494, -0.001628, 1.810021>, <10.018985, -0.253790, 1.810528>, <10.452233, -0.253790, 1.350542>, <10.451742, -0.001628, 1.350034>,
      <10.342904, -0.001628, 3.117124>, <10.343266, -0.253790, 3.117730>, <10.773757, -0.253790, 2.845158>, <10.773395, -0.001628, 2.844551>,
      <9.685087, -0.003266, 5.275865>, <9.685123, -0.253790, 5.276491>, <10.135525, -0.253790, 5.238214>, <10.135489, -0.003266, 5.237588>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <9.332725, -0.003266, 0.406004>, <9.332153, 0.250533, 0.405613>, <9.023058, 0.250533, 0.872996>, <9.023630, -0.003266, 0.873387>,
      <10.451742, -0.001628, 1.350034>, <10.451250, 0.250533, 1.349526>, <10.018002, 0.250533, 1.809513>, <10.018494, -0.001628, 1.810021>,
      <10.773395, -0.001628, 2.844551>, <10.773033, 0.250533, 2.843944>, <10.342542, 0.250533, 3.116517>, <10.342904, -0.001628, 3.117124>,
      <10.135489, -0.003266, 5.237588>, <10.135453, 0.250533, 5.236962>, <9.685051, 0.250533, 5.275239>, <9.685087, -0.003266, 5.275865>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <9.685087, -0.003266, 5.275865>, <9.685123, -0.253790, 5.276491>, <10.135525, -0.253790, 5.238214>, <10.135489, -0.003266, 5.237588>,
      <9.027269, -0.001628, 7.434606>, <9.026980, -0.253790, 7.435251>, <9.497294, -0.253790, 7.631269>, <9.497583, -0.001628, 7.630624>,
      <7.708032, -0.001628, 9.580386>, <7.707743, -0.253790, 9.581031>, <8.178057, -0.253790, 9.777049>, <8.178346, -0.001628, 9.776405>,
      <5.726737, -0.003266, 14.072584>, <5.726448, -0.253790, 14.073229>, <6.196762, -0.253790, 14.269247>, <6.197051, -0.003266, 14.268603>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <10.135489, -0.003266, 5.237588>, <10.135453, 0.250533, 5.236962>, <9.685051, 0.250533, 5.275239>, <9.685087, -0.003266, 5.275865>,
      <9.497583, -0.001628, 7.630624>, <9.497872, 0.250533, 7.629980>, <9.027559, 0.250533, 7.433961>, <9.027269, -0.001628, 7.434606>,
      <8.178346, -0.001628, 9.776405>, <8.178635, 0.250533, 9.775760>, <7.708322, 0.250533, 9.579742>, <7.708032, -0.001628, 9.580386>,
      <6.197051, -0.003266, 14.268603>, <6.197340, 0.250533, 14.267958>, <5.727027, 0.250533, 14.071940>, <5.726737, -0.003266, 14.072584>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <5.726737, -0.003266, 14.072584>, <5.726448, -0.253790, 14.073229>, <6.196762, -0.253790, 14.269247>, <6.197051, -0.003266, 14.268603>,
      <3.745443, -0.001628, 18.564782>, <3.745153, -0.253790, 18.565427>, <4.215467, -0.253790, 18.761445>, <4.215756, -0.001628, 18.760801>,
      <3.994405, -0.001628, 20.482473>, <3.994405, -0.253790, 20.483180>, <4.503747, -0.253790, 20.469463>, <4.503747, -0.001628, 20.468756>,
      <3.994405, -0.001628, 40.010798>, <3.994405, -0.253790, 40.011504>, <4.503747, -0.253790, 39.997787>, <4.503747, -0.001628, 39.997081>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.197051, -0.003266, 14.268603>, <6.197340, 0.250533, 14.267958>, <5.727027, 0.250533, 14.071940>, <5.726737, -0.003266, 14.072584>,
      <4.215756, -0.001628, 18.760801>, <4.216045, 0.250533, 18.760156>, <3.745732, 0.250533, 18.564138>, <3.745443, -0.001628, 18.564782>,
      <4.503747, -0.001628, 20.468756>, <4.503747, 0.250533, 20.468050>, <3.994405, 0.250533, 20.481767>, <3.994405, -0.001628, 20.482473>,
      <4.503747, -0.001628, 39.997081>, <4.503747, 0.250533, 39.996374>, <3.994405, 0.250533, 40.010091>, <3.994405, -0.001628, 40.010798>
    }
  }
}




// ********  OBJECTS  *******

box { // Floor
  <-1, -1, -1>, <1, 1, 1>
  texture {
    FloorTex
  }
  scale <100.0, 55.0, 1.0>
  translate  -22.0*z
}


#declare WorkTable = union {
  object { // TableLeg3->TableLeg
    TableLeg
    translate  <-34.0, -13.0, 0.0>
  }
  object { // TableLeg2->TableLeg
    TableLeg
    translate  -34.0*x
  }
  object { // TableLeg1->TableLeg
    TableLeg
    translate  -13.0*y
  }
  object { TableLeg }
  superellipsoid { // TableTop
    <0.1, 0.1>
    scale <21.0, 10.0, 0.5>
    translate  -0.5*z
  }
  texture {
    Parquet_Wood
  }
}
#declare Halos = union {
  object { // Halo2->Halo1
    Halo1
    rotate 0.0*y
    translate  3.773622*x
  }
  object { Halo1 }
  texture {
    MagicTex
  }
  hollow
}
#declare Star = union {
  box { // chalk5
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 0.1, 0.01>
    rotate -72.0*z
    translate  <3.040434, 0.376777, 0.01>
  }
  box { // chalk4
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 0.1, 0.01>
    rotate -108.0*z
    translate  <-3.087719, 0.421053, 0.01>
  }
  box { // chalk3
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 0.1, 0.01>
    rotate 180.0*z
    translate  <0.0, 2.666667, 0.01>
  }
  box { // chalk2
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 0.1, 0.01>
    rotate -144.0*z
    translate  <1.964912, -3.22807, 0.01>
  }
  box { // chalk1
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 0.1, 0.01>
    rotate -36.0*z
    translate  <-1.964912, -3.22807, 0.01>
  }
  texture {
    ChalkTex
  }
}
union { // TableSetting
  object { WorkTable }
  object { // Candle4->Candle3
    Candle3
    translate  <-10.135784, 6.664625, 0.0>
  }
  object { Candle3 }
  object { Candle2 }
  object { Candle1 }
  cylinder { // ChalkStick
    <0,0,1>, <0,0,0>, 1
    texture {
      pigment { color <1,1,1> }
    }
    scale <0.2, 0.2, 3.0>
    rotate <-45.0, -90.0, 0.0>
    translate  <-7.6, -6.3, 0.2>
  }
 // object { Halos }
 sphere { 0, 4
    texture {
      MagicTex
    }
    hollow
  }
  object { Star }
  superellipsoid { // Lead
    <0.1, 0.1>
    texture {
      BarTex
    }
    hollow
    scale <4.0, 1.0, 0.5>
    translate  0.5*z
  }
  object { Candle }
}


#declare WinCutout = union {
  cylinder { // Arch1
    <0,0,1>, <0,0,0>, 1
    scale <3.0, 2.0, 12.0>
    rotate -90.0*x
    translate  <0.0, -6.0, 5.5>
  }
  box { // Win1
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 6.0, 7.0>
    translate  -1.0*z
  }
  texture {
    DiffTex
  }
  scale <1.0, 1.1, 1.0>
  translate  -1.0*z
}
#declare Window = difference {
  object { WinEdge }
  object { WinCutout }
  texture {
    WindowTex
  }
  translate  <19.4, 59.700001, 11.3>
}
#declare TowerWall = difference {
  box { // Wall
    <-1, -1, -1>, <1, 1, 1>
    texture {
      WallTex
    }
    scale <100.0, 50.0, 1.0>
    rotate <-90.0, 0.0, 0.0>
    translate  <0.0, 55.0, 29.0>
  }
  object { // WinEdge1->WinEdge
    WinEdge
    texture {
      DiffTex
    }
    scale <1.0, 0.3, 1.0>
    rotate <0.0, 0.0, 0.0>
    translate  <19.4, 55.0, 11.3>
  }
}
union { // Tower
  object { Window }
  object { TowerWall }
}



#declare Finger = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.748203, -0.029217, 0.009256>, <-0.748203, -0.314240, 0.009256>, <-0.328618, -0.764240, 0.004674>, <-0.016037, -0.778433, 0.002337>,
      <-0.716498, -0.057604, 0.195730>, <-0.716498, -0.342627, 0.195730>, <-0.328618, -0.792627, 0.458650>, <-0.016037, -0.792627, 0.546289>,
      <-0.778618, -0.057604, 1.297072>, <-0.778618, -0.342627, 1.297072>, <-0.328618, -0.792627, 1.297072>, <-0.016037, -0.792627, 1.282465>,
      <-0.651257, -0.057604, 2.312651>, <-0.651257, -0.342627, 2.312651>, <-0.031447, -0.769585, 2.005837>, <0.165021, -0.769585, 1.955917>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.016037, -0.778433, 0.002337>, <0.296544, -0.792627, 0.000000>, <0.746544, -0.342627, 0.000000>, <0.746544, -0.057604, 0.000000>,
      <-0.016037, -0.792627, 0.546289>, <0.296544, -0.792627, 0.633929>, <0.746544, -0.342627, 0.633929>, <0.746544, -0.057604, 0.633929>,
      <-0.016037, -0.792627, 1.282465>, <0.296544, -0.792627, 1.267859>, <0.746544, -0.342627, 1.267859>, <0.746544, -0.057604, 1.267859>,
      <0.165021, -0.769585, 1.955917>, <0.361489, -0.769585, 1.905997>, <0.742366, -0.342627, 1.792761>, <0.742366, -0.057604, 1.792761>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.746544, -0.057604, 0.000000>, <0.746544, 0.227420, 0.000000>, <0.296544, 0.677420, 0.000000>, <-0.016037, 0.691613, 0.002337>,
      <0.746544, -0.057604, 0.633929>, <0.746544, 0.227420, 0.633929>, <0.296544, 0.677420, 0.633929>, <-0.016037, 0.677420, 0.546289>,
      <0.746544, -0.057604, 1.267859>, <0.746544, 0.227420, 1.267859>, <0.296544, 0.677420, 1.267859>, <-0.016037, 0.677420, 1.282465>,
      <0.742366, -0.057604, 1.792761>, <0.742366, 0.227420, 1.792761>, <0.351212, 0.654378, 1.895618>, <0.119260, 0.654378, 1.988119>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.016037, 0.691613, 0.002337>, <-0.328618, 0.705807, 0.004674>, <-0.748203, 0.255807, 0.009256>, <-0.748203, -0.029217, 0.009256>,
      <-0.016037, 0.677420, 0.546289>, <-0.328618, 0.677420, 0.458650>, <-0.716498, 0.227420, 0.195730>, <-0.716498, -0.057604, 0.195730>,
      <-0.016037, 0.677420, 1.282465>, <-0.328618, 0.677420, 1.297072>, <-0.778618, 0.227420, 1.297072>, <-0.778618, -0.057604, 1.297072>,
      <0.119260, 0.654378, 1.988119>, <-0.112692, 0.654378, 2.080619>, <-0.651257, 0.227420, 2.312651>, <-0.651257, -0.057604, 2.312651>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.651257, -0.057604, 2.312651>, <-0.651257, -0.342627, 2.312651>, <-0.031447, -0.769585, 2.005837>, <0.165021, -0.769585, 1.955917>,
      <-0.523896, -0.057604, 3.328230>, <-0.523896, -0.342627, 3.328230>, <0.265724, -0.746544, 2.714603>, <0.346079, -0.746544, 2.629369>,
      <-0.047523, -0.057604, 3.454710>, <-0.047523, -0.342627, 3.454710>, <0.068567, -0.746544, 3.016033>, <0.254597, -0.746544, 2.842560>,
      <0.866540, -0.057604, 3.662984>, <0.852347, -0.342627, 3.662984>, <1.066448, -0.769585, 3.419872>, <1.186990, -0.769585, 3.246438>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.165021, -0.769585, 1.955917>, <0.361489, -0.769585, 1.905997>, <0.742366, -0.342627, 1.792761>, <0.742366, -0.057604, 1.792761>,
      <0.346079, -0.746544, 2.629369>, <0.426434, -0.746544, 2.544135>, <0.738187, -0.342627, 2.317663>, <0.738187, -0.057604, 2.317663>,
      <0.254597, -0.746544, 2.842560>, <0.440626, -0.746544, 2.669086>, <0.638750, -0.342627, 2.338591>, <0.638750, -0.057604, 2.338591>,
      <1.186990, -0.769585, 3.246438>, <1.307532, -0.769585, 3.073004>, <1.610326, -0.342627, 2.527349>, <1.610326, -0.057604, 2.527349>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.742366, -0.057604, 1.792761>, <0.742366, 0.227420, 1.792761>, <0.351212, 0.654378, 1.895618>, <0.119260, 0.654378, 1.988119>,
      <0.738187, -0.057604, 2.317663>, <0.738187, 0.227420, 2.317663>, <0.405879, 0.631337, 2.523377>, <0.254556, 0.631337, 2.693772>,
      <0.638750, -0.057604, 2.338591>, <0.638750, 0.227420, 2.338591>, <0.413583, 0.631337, 2.658038>, <0.227553, 0.631337, 2.831512>,
      <1.610326, -0.057604, 2.527349>, <1.610326, 0.227420, 2.527349>, <1.294010, 0.654378, 3.067480>, <1.173468, 0.654378, 3.240914>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.119260, 0.654378, 1.988119>, <-0.112692, 0.654378, 2.080619>, <-0.651257, 0.227420, 2.312651>, <-0.651257, -0.057604, 2.312651>,
      <0.254556, 0.631337, 2.693772>, <0.103234, 0.631337, 2.864167>, <-0.523896, 0.227420, 3.328230>, <-0.523896, -0.057604, 3.328230>,
      <0.227553, 0.631337, 2.831512>, <0.041523, 0.631337, 3.004986>, <-0.047523, 0.227420, 3.454710>, <-0.047523, -0.057604, 3.454710>,
      <1.173468, 0.654378, 3.240914>, <1.052926, 0.654378, 3.414348>, <0.852347, 0.227420, 3.662984>, <0.866540, -0.057604, 3.662984>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.866540, -0.057604, 3.662984>, <0.852347, -0.342627, 3.662984>, <1.066448, -0.769585, 3.419872>, <1.186990, -0.769585, 3.246438>,
      <1.752216, -0.057604, 3.871259>, <1.752216, -0.342627, 3.871259>, <2.064329, -0.792627, 3.823710>, <2.119383, -0.792627, 3.650316>,
      <3.211004, -0.057604, 3.588745>, <3.211004, -0.342627, 3.588745>, <2.971534, -0.723503, 3.206636>, <2.853636, -0.723503, 3.068084>,
      <3.352814, -0.057604, 3.500708>, <3.352814, -0.342627, 3.500708>, <3.113343, -0.723503, 3.118600>, <2.995446, -0.723503, 2.980048>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.186990, -0.769585, 3.246438>, <1.307532, -0.769585, 3.073004>, <1.610326, -0.342627, 2.527349>, <1.610326, -0.057604, 2.527349>,
      <2.119383, -0.792627, 3.650316>, <2.174438, -0.792627, 3.476922>, <2.581903, -0.342627, 2.716107>, <2.581903, -0.057604, 2.716107>,
      <2.853636, -0.723503, 3.068084>, <2.735739, -0.723503, 2.929532>, <2.539947, -0.342627, 2.657960>, <2.539947, -0.057604, 2.657960>,
      <2.995446, -0.723503, 2.980048>, <2.877549, -0.723503, 2.841496>, <2.648069, -0.342627, 2.523197>, <2.648069, -0.057604, 2.523197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.610326, -0.057604, 2.527349>, <1.610326, 0.227420, 2.527349>, <1.294010, 0.654378, 3.067480>, <1.173468, 0.654378, 3.240914>,
      <2.581903, -0.057604, 2.716107>, <2.581903, 0.227420, 2.716107>, <2.174438, 0.677420, 3.476922>, <2.119383, 0.677420, 3.650316>,
      <2.539947, -0.057604, 2.657960>, <2.539947, 0.227420, 2.657960>, <2.712042, 0.608295, 2.946617>, <2.829940, 0.608295, 3.085169>,
      <2.648069, -0.057604, 2.523197>, <2.648069, 0.227420, 2.523197>, <2.853852, 0.608295, 2.858580>, <2.971749, 0.608295, 2.997132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.173468, 0.654378, 3.240914>, <1.052926, 0.654378, 3.414348>, <0.852347, 0.227420, 3.662984>, <0.866540, -0.057604, 3.662984>,
      <2.119383, 0.677420, 3.650316>, <2.064329, 0.677420, 3.823710>, <1.752216, 0.227420, 3.871259>, <1.752216, -0.057604, 3.871259>,
      <2.829940, 0.608295, 3.085169>, <2.947837, 0.608295, 3.223720>, <3.211004, 0.227420, 3.588745>, <3.211004, -0.057604, 3.588745>,
      <2.971749, 0.608295, 2.997132>, <3.089647, 0.608295, 3.135684>, <3.352814, 0.227420, 3.500708>, <3.352814, -0.057604, 3.500708>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.352814, -0.057604, 3.500708>, <3.352814, -0.342627, 3.500708>, <3.113343, -0.723503, 3.118600>, <2.995446, -0.723503, 2.980048>,
      <3.494624, -0.057604, 3.412672>, <3.494624, -0.342627, 3.412672>, <3.255153, -0.723503, 3.030563>, <3.137256, -0.723503, 2.892011>,
      <5.251302, -0.126728, 2.117774>, <5.251302, -0.411751, 2.117774>, <4.988135, -0.861751, 1.752750>, <4.870237, -0.861751, 1.614198>,
      <5.030220, -0.023041, 1.851085>, <5.042068, -0.020047, 1.842543>, <5.018198, -0.055300, 1.759481>, <5.038535, -0.055300, 1.762713>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.995446, -0.723503, 2.980048>, <2.877549, -0.723503, 2.841496>, <2.648069, -0.342627, 2.523197>, <2.648069, -0.057604, 2.523197>,
      <3.137256, -0.723503, 2.892011>, <3.019359, -0.723503, 2.753459>, <2.756191, -0.342627, 2.388435>, <2.756191, -0.057604, 2.388435>,
      <4.870237, -0.861751, 1.614198>, <4.752340, -0.861751, 1.475646>, <4.489173, -0.411751, 1.110622>, <4.489173, -0.126728, 1.110622>,
      <5.038535, -0.055300, 1.762713>, <5.058873, -0.055300, 1.765945>, <5.051731, -0.020047, 1.756039>, <5.039882, -0.023041, 1.764581>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.648069, -0.057604, 2.523197>, <2.648069, 0.227420, 2.523197>, <2.853852, 0.608295, 2.858580>, <2.971749, 0.608295, 2.997132>,
      <2.756191, -0.057604, 2.388435>, <2.756191, 0.227420, 2.388435>, <2.995662, 0.608295, 2.770544>, <3.113559, 0.608295, 2.909096>,
      <4.489173, -0.126728, 1.110622>, <4.489173, 0.158295, 1.110622>, <4.752340, 0.608295, 1.475646>, <4.870237, 0.608295, 1.614198>,
      <5.039882, -0.023041, 1.764581>, <5.028034, -0.026036, 1.773124>, <5.058873, -0.013824, 1.765945>, <5.038535, -0.013824, 1.762713>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.971749, 0.608295, 2.997132>, <3.089647, 0.608295, 3.135684>, <3.352814, 0.227420, 3.500708>, <3.352814, -0.057604, 3.500708>,
      <3.113559, 0.608295, 2.909096>, <3.231457, 0.608295, 3.047648>, <3.494624, 0.227420, 3.412672>, <3.494624, -0.057604, 3.412672>,
      <4.870237, 0.608295, 1.614198>, <4.988135, 0.608295, 1.752750>, <5.251302, 0.158295, 2.117774>, <5.251302, -0.126728, 2.117774>,
      <5.038535, -0.013824, 1.762713>, <5.018198, -0.013824, 1.759481>, <5.018371, -0.026036, 1.859627>, <5.030220, -0.023041, 1.851085>
    }
  }
  rotate <37.434074, 12.864235, 74.983635>
  translate  <-0.7, -4.25, -0.8>
}
#declare Thumb = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.169688, 0.125034, -0.659818>, <-1.303653, -0.460690, 0.030517>, <-1.175168, -1.178619, 0.061034>, <-0.625168, -1.437617, 0.045775>,
      <-1.160757, -0.062517, 0.457637>, <-1.160757, -0.460690, 0.457637>, <-1.032272, -1.196481, 0.457637>, <-0.625168, -1.196481, 0.427120>,
      <-1.214343, -0.062517, 0.838982>, <-1.214343, -0.460690, 0.838982>, <-0.550000, -0.910690, 0.854240>, <-0.294722, -0.910690, 0.838982>,
      <-1.125034, -0.062517, 1.234787>, <-1.125034, -0.416035, 1.218742>, <-0.567862, -0.866035, 1.226372>, <-0.276860, -0.866035, 1.227004>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.625168, -1.437617, 0.045775>, <-0.075168, -1.696615, 0.030517>, <0.374832, -1.246615, 0.030517>, <0.535590, -0.607306, 0.015258>,
      <-0.625168, -1.196481, 0.427120>, <-0.218063, -1.196481, 0.396603>, <0.553452, -0.460690, 0.396603>, <0.553452, -0.062517, 0.396603>,
      <-0.294722, -0.910690, 0.838982>, <-0.039444, -0.910690, 0.823723>, <0.410556, -0.460690, 0.823723>, <0.410556, -0.062517, 0.823723>,
      <-0.276860, -0.866035, 1.227004>, <0.014142, -0.866035, 1.195855>, <0.464142, -0.416035, 1.195855>, <0.464142, -0.062517, 1.211593>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.535590, -0.607306, 0.015258>, <0.696347, 0.032004, 0.000000>, <0.246347, 0.571314, -1.380670>, <-0.169688, 0.866035, -1.365412>,
      <0.553452, -0.062517, 0.396603>, <0.553452, 0.335657, 0.396603>, <0.103452, 0.785657, -0.968809>, <-0.303653, 0.785657, -0.938292>,
      <0.410556, -0.062517, 0.823723>, <0.410556, 0.335657, 0.823723>, <-0.039444, 0.785657, 0.823723>, <-0.294722, 0.785657, 0.838982>,
      <0.464142, -0.062517, 1.211593>, <0.464142, 0.291002, 1.195855>, <0.014142, 0.741002, 1.195855>, <-0.276860, 0.741002, 1.227004>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.169688, 0.866035, -1.365412>, <-0.585724, 1.160757, -1.350154>, <-1.035724, 0.710757, -1.350154>, <-1.169688, 0.125034, -0.659818>,
      <-0.303653, 0.785657, -0.938292>, <-0.710757, 0.785657, -0.907775>, <-1.160757, 0.335657, 0.457637>, <-1.160757, -0.062517, 0.457637>,
      <-0.294722, 0.785657, 0.838982>, <-0.550000, 0.785657, 0.854240>, <-1.214343, 0.335657, 0.838982>, <-1.214343, -0.062517, 0.838982>,
      <-0.276860, 0.741002, 1.227004>, <-0.567862, 0.741002, 1.226372>, <-1.125034, 0.291002, 1.218742>, <-1.125034, -0.062517, 1.234787>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.125034, -0.062517, 1.234787>, <-1.125034, -0.416035, 1.218742>, <-0.567862, -0.866035, 1.226372>, <-0.276860, -0.866035, 1.227004>,
      <-1.035724, -0.062517, 1.598503>, <-1.035724, -0.371381, 1.598503>, <-0.585724, -0.821381, 1.598503>, <-0.258998, -0.821381, 1.583245>,
      <-1.017862, -0.062517, 1.766231>, <-1.017862, -0.371381, 1.766231>, <-0.567862, -0.821381, 1.766231>, <-0.375101, -0.821381, 1.766231>,
      <-1.044655, -0.062517, 1.947271>, <-1.044655, -0.398174, 1.926329>, <-0.657172, -0.848174, 1.926329>, <-0.401894, -0.848174, 1.927815>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.276860, -0.866035, 1.227004>, <0.014142, -0.866035, 1.195855>, <0.464142, -0.416035, 1.195855>, <0.464142, -0.062517, 1.211593>,
      <-0.258998, -0.821381, 1.583245>, <0.067728, -0.821381, 1.567987>, <0.517728, -0.371381, 1.567987>, <0.517728, -0.062517, 1.567987>,
      <-0.375101, -0.821381, 1.766231>, <-0.182339, -0.821381, 1.766231>, <0.178351, -0.371381, 1.766231>, <0.178351, -0.062517, 1.766231>,
      <-0.401894, -0.848174, 1.927815>, <-0.146615, -0.848174, 1.888183>, <0.258730, -0.398174, 1.888183>, <0.258730, -0.062517, 1.908359>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.464142, -0.062517, 1.211593>, <0.464142, 0.291002, 1.195855>, <0.014142, 0.741002, 1.195855>, <-0.276860, 0.741002, 1.227004>,
      <0.517728, -0.062517, 1.567987>, <0.517728, 0.246347, 1.567987>, <0.067728, 0.696347, 1.567987>, <-0.258998, 0.696347, 1.583245>,
      <0.178351, -0.062517, 1.766231>, <0.178351, 0.246347, 1.766231>, <-0.182339, 0.696347, 1.766231>, <-0.375101, 0.696347, 1.766231>,
      <0.258730, -0.062517, 1.908359>, <0.258730, 0.273140, 1.888183>, <-0.146615, 0.723140, 1.888183>, <-0.401894, 0.723140, 1.927815>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.276860, 0.741002, 1.227004>, <-0.567862, 0.741002, 1.226372>, <-1.125034, 0.291002, 1.218742>, <-1.125034, -0.062517, 1.234787>,
      <-0.258998, 0.696347, 1.583245>, <-0.585724, 0.696347, 1.598503>, <-1.035724, 0.246347, 1.598503>, <-1.035724, -0.062517, 1.598503>,
      <-0.375101, 0.696347, 1.766231>, <-0.567862, 0.696347, 1.766231>, <-1.017862, 0.246347, 1.766231>, <-1.017862, -0.062517, 1.766231>,
      <-0.401894, 0.723140, 1.927815>, <-0.657172, 0.723140, 1.926329>, <-1.044655, 0.273140, 1.926329>, <-1.044655, -0.062517, 1.947271>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.044655, -0.062517, 1.947271>, <-1.044655, -0.398174, 1.926329>, <-0.657172, -0.848174, 1.926329>, <-0.401894, -0.848174, 1.927815>,
      <-1.071448, -0.062517, 2.086428>, <-1.071448, -0.424966, 2.086428>, <-0.746481, -0.874966, 2.086428>, <-0.428686, -0.874966, 2.048282>,
      <-1.053586, -0.062517, 3.386443>, <-1.053586, -0.460690, 3.386443>, <-0.728619, -0.910690, 3.386443>, <-0.357239, -0.910690, 3.386443>,
      <-0.660623, 0.008931, 3.630139>, <-0.660623, -0.014142, 3.844080>, <-0.728619, -0.303385, 3.767788>, <-0.696615, -0.303385, 3.760159>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.401894, -0.848174, 1.927815>, <-0.146615, -0.848174, 1.888183>, <0.258730, -0.398174, 1.888183>, <0.258730, -0.062517, 1.908359>,
      <-0.428686, -0.874966, 2.048282>, <-0.110892, -0.874966, 2.010136>, <0.339108, -0.424966, 2.010136>, <0.339108, -0.062517, 2.010136>,
      <-0.357239, -0.910690, 3.386443>, <0.014142, -0.910690, 3.386443>, <0.321246, -0.460690, 3.386443>, <0.321246, -0.062517, 3.386443>,
      <-0.696615, -0.303385, 3.760159>, <-0.664612, -0.303385, 3.752530>, <-0.750470, -0.014142, 3.798305>, <-0.750470, 0.008931, 3.790676>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.258730, -0.062517, 1.908359>, <0.258730, 0.273140, 1.888183>, <-0.146615, 0.723140, 1.888183>, <-0.401894, 0.723140, 1.927815>,
      <0.339108, -0.062517, 2.010136>, <0.339108, 0.299933, 2.010136>, <-0.110892, 0.749933, 2.010136>, <-0.428686, 0.749933, 2.048282>,
      <0.321246, -0.062517, 3.386443>, <0.321246, 0.335657, 3.386443>, <0.014142, 0.785657, 3.386443>, <-0.357239, 0.785657, 3.386443>,
      <-0.750470, 0.008931, 3.790676>, <-0.750470, 0.032004, 3.783046>, <-0.664612, 0.267661, 3.722013>, <-0.696615, 0.267661, 3.729642>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.401894, 0.723140, 1.927815>, <-0.657172, 0.723140, 1.926329>, <-1.044655, 0.273140, 1.926329>, <-1.044655, -0.062517, 1.947271>,
      <-0.428686, 0.749933, 2.048282>, <-0.746481, 0.749933, 2.086428>, <-1.071448, 0.299933, 2.086428>, <-1.071448, -0.062517, 2.086428>,
      <-0.357239, 0.785657, 3.386443>, <-0.728619, 0.785657, 3.386443>, <-1.053586, 0.335657, 3.386443>, <-1.053586, -0.062517, 3.386443>,
      <-0.696615, 0.267661, 3.729642>, <-0.728619, 0.267661, 3.737271>, <-0.660623, 0.032004, 3.416199>, <-0.660623, 0.008931, 3.630139>
    }
  }
  translate  <-0.953914, -0.992554, -1.464958>
}
union { // Hand
  object { Finger }
  object { Thumb }
  texture {
    SkinTex
  }
  scale 0.387271
  rotate <152.430756, 34.952831, -77.729149>
  translate  <6.392886, -3.508502, 5.931544>
}


union { // Sleeve
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.662731, -0.109183, 4.926558>, <-2.603833, -2.933620, 4.926558>, <2.551226, -0.630316, 5.008314>, <2.532742, 0.018484, 5.008314>,
      <-2.035714, -0.109183, 2.000000>, <-1.976816, -2.933620, 2.000000>, <1.924209, -0.630316, 2.036968>, <1.905725, 0.018484, 2.036968>,
      <-2.035714, -0.109183, 4.000000>, <-1.976816, -2.933620, 4.000000>, <1.924209, -0.630316, 4.036968>, <1.905725, 0.018484, 4.036968>,
      <-2.035714, -0.109183, 6.000000>, <-1.976816, -2.933620, 6.000000>, <1.924209, -0.630316, 6.036968>, <1.905725, 0.018484, 6.036968>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.532742, 0.018484, 5.008314>, <2.514258, 0.667285, 5.008314>, <-2.721628, 2.715255, 4.926558>, <-2.662731, -0.109183, 4.926558>,
      <1.905725, 0.018484, 2.036968>, <1.887241, 0.667285, 2.036968>, <-2.094612, 2.715255, 2.000000>, <-2.035714, -0.109183, 2.000000>,
      <1.905725, 0.018484, 4.036968>, <1.887241, 0.667285, 4.036968>, <-2.094612, 2.715255, 4.000000>, <-2.035714, -0.109183, 4.000000>,
      <1.905725, 0.018484, 6.036968>, <1.887241, 0.667285, 6.036968>, <-2.094612, 2.715255, 6.000000>, <-2.035714, -0.109183, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.035714, -0.109183, 6.000000>, <-1.976816, -2.933620, 6.000000>, <1.924209, -0.630316, 6.036968>, <1.905725, 0.018484, 6.036968>,
      <-2.035714, -0.109183, 8.000000>, <-1.976816, -2.933620, 8.000000>, <1.924209, -0.630316, 8.036968>, <1.905725, 0.018484, 8.036968>,
      <-2.035714, -0.109183, 10.000000>, <-1.976816, -2.933620, 10.000000>, <1.924209, -0.630316, 10.036968>, <1.905725, 0.018484, 10.036968>,
      <-2.035714, -0.109183, 12.000000>, <-1.976816, -2.933620, 12.000000>, <1.924209, -0.630316, 12.036968>, <1.905725, 0.018484, 12.036968>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.905725, 0.018484, 6.036968>, <1.887241, 0.667285, 6.036968>, <-2.094612, 2.715255, 6.000000>, <-2.035714, -0.109183, 6.000000>,
      <1.905725, 0.018484, 8.036968>, <1.887241, 0.667285, 8.036968>, <-2.094612, 2.715255, 8.000000>, <-2.035714, -0.109183, 8.000000>,
      <1.905725, 0.018484, 10.036968>, <1.887241, 0.667285, 10.036968>, <-2.094612, 2.715255, 10.000000>, <-2.035714, -0.109183, 10.000000>,
      <1.905725, 0.018484, 12.036968>, <1.887241, 0.667285, 12.036968>, <-2.094612, 2.715255, 12.000000>, <-2.035714, -0.109183, 12.000000>
    }
  }
  texture {
    SleeveTex
  }
  rotate <-63.948906, 58.665939, -117.194733>
  translate  <5.25, -1.3, 4.6>
}


union { // Wand
  cylinder { // WandShaft
    <0,0,1>, <0,0,0>, 1
    texture {
      WandShaftTex
    }
    scale <0.3, 0.3, 10.0>
    translate  2.3*z
  }
  superellipsoid { // GEM
    <2.0, 2.0>
    texture {
      GemTex
    }
    scale 0.75
    translate  1.734954*z
  }
  rotate <51.0, 38.0, 38.0>
  translate  <-0.433601, 0.4642, 0.805924>
}


//
// Include file contains 'Bowl'
//
#include "lead.in3"
#declare Bowl = object {
  Bowl_Raw
  translate  40.5*z
}
#declare Flame1 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.064717, -0.005299, 0.003974>, <-0.064717, -0.074671, 0.005299>, <-0.069373, -0.077963, 0.005299>, <-0.002649, -0.077963, 0.006623>,
      <-0.276659, 0.037090, 0.118460>, <-0.276659, -0.093216, 0.118460>, <-0.170045, -0.199830, 0.118460>, <-0.039739, -0.199830, 0.118460>,
      <-0.276659, 0.037090, 0.236920>, <-0.276659, -0.093216, 0.236920>, <-0.170045, -0.199830, 0.236920>, <-0.039739, -0.199830, 0.236920>,
      <-0.204378, -0.006499, 0.344310>, <-0.206453, -0.111761, 0.351406>, <-0.099839, -0.218375, 0.351406>, <-0.001890, -0.214767, 0.340457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.002649, -0.077963, 0.006623>, <0.064074, -0.077963, 0.007948>, <0.062068, -0.074671, 0.010597>, <0.062068, -0.005299, 0.009272>,
      <-0.039739, -0.199830, 0.118460>, <0.090567, -0.199830, 0.118460>, <0.197181, -0.093216, 0.118460>, <0.197181, 0.037090, 0.118460>,
      <-0.039739, -0.199830, 0.236920>, <0.090567, -0.199830, 0.236920>, <0.197181, -0.093216, 0.236920>, <0.197181, 0.037090, 0.236920>,
      <-0.001890, -0.214767, 0.340457>, <0.097190, -0.218375, 0.343459>, <0.203804, -0.111761, 0.343459>, <0.200599, -0.006499, 0.336604>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.062068, -0.005299, 0.009272>, <0.062068, 0.064074, 0.007948>, <0.064074, 0.072665, 0.005299>, <-0.002649, 0.072665, 0.003974>,
      <0.197181, 0.037090, 0.118460>, <0.197181, 0.167396, 0.118460>, <0.090567, 0.274010, 0.118460>, <-0.039739, 0.274010, 0.118460>,
      <0.197181, 0.037090, 0.236920>, <0.197181, 0.167396, 0.236920>, <0.090567, 0.274010, 0.236920>, <-0.039739, 0.274010, 0.236920>,
      <0.200599, -0.006499, 0.336604>, <0.203804, 0.097190, 0.343459>, <0.097190, 0.203804, 0.343459>, <-0.001890, 0.201769, 0.340457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.002649, 0.072665, 0.003974>, <-0.069373, 0.072665, 0.002649>, <-0.064717, 0.064074, 0.002649>, <-0.064717, -0.005299, 0.003974>,
      <-0.039739, 0.274010, 0.118460>, <-0.170045, 0.274010, 0.118460>, <-0.276659, 0.167396, 0.118460>, <-0.276659, 0.037090, 0.118460>,
      <-0.039739, 0.274010, 0.236920>, <-0.170045, 0.274010, 0.236920>, <-0.276659, 0.167396, 0.236920>, <-0.276659, 0.037090, 0.236920>,
      <-0.001890, 0.201769, 0.340457>, <-0.099839, 0.203804, 0.351406>, <-0.206453, 0.097190, 0.351406>, <-0.204378, -0.006499, 0.344310>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.204378, -0.006499, 0.344310>, <-0.206453, -0.111761, 0.351406>, <-0.099839, -0.218375, 0.351406>, <-0.001890, -0.214767, 0.340457>,
      <-0.136248, -0.051661, 0.465893>, <-0.136248, -0.130306, 0.465893>, <-0.029633, -0.236920, 0.465893>, <0.037090, -0.236920, 0.457945>,
      <-0.136248, -0.056960, 0.548587>, <-0.136248, -0.061425, 0.549912>, <-0.029633, -0.186584, 0.549912>, <0.037090, -0.186584, 0.541964>,
      <0.041254, -0.035765, 0.713410>, <0.041254, -0.037581, 0.713410>, <0.041897, -0.038224, 0.721358>, <0.042388, -0.038224, 0.722682>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.001890, -0.214767, 0.340457>, <0.097190, -0.218375, 0.343459>, <0.203804, -0.111761, 0.343459>, <0.200599, -0.006499, 0.336604>,
      <0.037090, -0.236920, 0.457945>, <0.103813, -0.236920, 0.449997>, <0.210427, -0.130306, 0.449997>, <0.210427, -0.051661, 0.449997>,
      <0.037090, -0.186584, 0.541964>, <0.103813, -0.186584, 0.534016>, <0.210427, -0.061425, 0.534016>, <0.210427, -0.056960, 0.532692>,
      <0.042388, -0.038224, 0.722682>, <0.042880, -0.038224, 0.724007>, <0.040873, -0.037581, 0.721358>, <0.040873, -0.035765, 0.721358>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.200599, -0.006499, 0.336604>, <0.203804, 0.097190, 0.343459>, <0.097190, 0.203804, 0.343459>, <-0.001890, 0.201769, 0.340457>,
      <0.210427, -0.051661, 0.449997>, <0.210427, 0.026984, 0.449997>, <0.103813, 0.133598, 0.449997>, <0.037090, 0.133598, 0.457945>,
      <0.210427, -0.056960, 0.532692>, <0.210427, -0.052494, 0.531367>, <0.103813, 0.054120, 0.531367>, <0.037090, 0.054120, 0.539315>,
      <0.040873, -0.035765, 0.721358>, <0.040873, -0.033949, 0.721358>, <0.042880, -0.028008, 0.716059>, <0.042388, -0.028008, 0.714735>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.001890, 0.201769, 0.340457>, <-0.099839, 0.203804, 0.351406>, <-0.206453, 0.097190, 0.351406>, <-0.204378, -0.006499, 0.344310>,
      <0.037090, 0.133598, 0.457945>, <-0.029633, 0.133598, 0.465893>, <-0.136248, 0.026984, 0.465893>, <-0.136248, -0.051661, 0.465893>,
      <0.037090, 0.054120, 0.539315>, <-0.029633, 0.054120, 0.547263>, <-0.136248, -0.052494, 0.547263>, <-0.136248, -0.056960, 0.548587>,
      <0.042388, -0.028008, 0.714735>, <0.041897, -0.028008, 0.713410>, <0.041254, -0.033949, 0.713410>, <0.041254, -0.035765, 0.713410>
    }
  }
  texture {
    FlameTex
  }
  scale 28.653408
  rotate <0.0, 0.0, 0.0>
  translate  <0.604179, -0.213981, 41.098806>
}
union { // OpenFlameLamp
  object { Bowl }
  object { // Ring2->Ring
    Ring
    translate  36.0*z
  }
  object { // Ring1->Ring
    Ring
    translate  18.0*z
  }
  object { Ring }
  object { // Leg2->Leg
    Leg
    rotate 120.0*z
  }
  object { // Leg1->Leg
    Leg
    rotate -120.0*z
  }
  object { Leg }
  object { Flame1 }
  texture {
    CopperTex
  }
  scale 0.7
  translate  <-10.0, 45.0, -21.0>
}


#include "lead.in4"
object {   // Skull
  Skull_Raw
  texture {
    SkullTex
  }
  rotate <-13.649733, 6.279672, -20.752312>
  translate  <17.2, 5.95, 4.35>
}

#declare Light001 = light_source {
  <-10.000, 44.5, 18>
  color rgb <0.835, 0.708, 0.408>
  area_light <10, 0, 0>, <0, 10, 0>, 4, 4
  adaptive 2
  jitter
  looks_like { Flame1 }
  fade_distance  25.0
  fade_power 2.0
}

object { Light001 }

object { // Light2->Light001
  Light001
  rotate <-1.0, -1.0, -90.0>
  translate  <-58.850001, -34.600001, -0.1>
}



