// Trunk variables

#declare TrunkBendingAngle = val(substr(Memory,1,11))
#declare Memory = substr(Memory,12,strlen(Memory)-11)
#declare TrunkNarrowing = val(substr(Memory,1,11))
#declare Memory = substr(Memory,12,strlen(Memory)-11)
#declare TrunkUnitLength = val(substr(Memory,1,11))
#declare Memory = substr(Memory,12,strlen(Memory)-11)
#declare TrunkRotation = val(substr(Memory,1,11))
#declare Memory = substr(Memory,12,strlen(Memory)-11)

#declare CountTrunk = 0
#declare TrunkX = 0
#declare TrunkY = 0

// CREATING Tree
#declare Tree = union {


 // Creating the Trunk
 #while (CountTrunk < TrunkPrecision)
  cone {
   <TrunkX,TrunkY,0>,TrunkBase*(1-CountTrunk*TrunkNarrowing)
   <TrunkX+TrunkUnitLength*sin((CountTrunk+1)*pi/180*TrunkBendingAngle),TrunkY+TrunkUnitLength*cos((CountTrunk+1)*pi/180*TrunkBendingAngle),0>,
   TrunkBase*(1-(CountTrunk+1)*TrunkNarrowing)
   #if (TrunkTextureOwn)
    texture { BarkTexture
     rotate <0,0,-CountTrunk*TrunkBendingAngle>
    }
   #end
  }
  sphere { <TrunkX,TrunkY,0>,TrunkBase*(1-CountTrunk*TrunkNarrowing)
   #if (TrunkTextureOwn)
    texture { BarkTexture
     rotate <0,0,-CountTrunk*TrunkBendingAngle>
    }
   #end
  }
  #declare TrunkX = TrunkX + TrunkUnitLength*sin((CountTrunk+1)*pi/180*TrunkBendingAngle)
  #declare TrunkY = TrunkY + TrunkUnitLength*cos((CountTrunk+1)*pi/180*TrunkBendingAngle)
  #declare CountTrunk = CountTrunk + 1
 #end
 sphere { <TrunkX,TrunkY,0>,TrunkBase*(1-TrunkNarrowing*TrunkPrecision)
  #if (TrunkTextureOwn)
   texture { BarkTexture
    rotate <0,0,-TrunkPrecision*TrunkBendingAngle>
   }
  #end
 }
 // Ended Trunk


 // Creating the Limbs
 #declare LimbsN = val(substr(Memory,1,11))
 #declare Memory = substr(Memory,12,strlen(Memory)-11)
 #declare CountLimbs = 0
 #while (CountLimbs < LimbsN)
  // Creating Limb
  // These variables changes from limb to limb
  #declare LimbLength = val(substr(Memory,1,11))
  #declare Memory = substr(Memory,12,strlen(Memory)-11)
  #declare LimbBase = val(substr(Memory,1,11))
  #declare Memory = substr(Memory,12,strlen(Memory)-11)
  #declare LimbNarrowing = val(substr(Memory,1,11))
  #declare Memory = substr(Memory,12,strlen(Memory)-11)
  #declare LimbHeight = val(substr(Memory,1,11))
  #declare Memory = substr(Memory,12,strlen(Memory)-11)
  #declare LimbRotZ = val(substr(Memory,1,11))
  #declare Memory = substr(Memory,12,strlen(Memory)-11)
  #declare LimbRotY = val(substr(Memory,1,11))
  #declare Memory = substr(Memory,12,strlen(Memory)-11)
  #declare LimbBending = val(substr(Memory,1,11))
  #declare Memory = substr(Memory,12,strlen(Memory)-11)
  #declare CountLimb = 0
  #declare LimbX = 0
  #declare LimbY = 0
  union {
   #while (CountLimb < LimbsPrecision)
    #if (LimbsVisible)
     cone {
      <LimbX,LimbY,0>,LimbBase*(1-CountLimb*LimbNarrowing)
      <LimbX+LimbLength*sin((CountLimb+1)*pi/180*LimbBending),LimbY+LimbLength*cos((CountLimb+1)*pi/180*LimbBending),0>,
      LimbBase*(1-(CountLimb+1)*LimbNarrowing)
      #if (LimbsTextureOwn)
       texture { BarkTexture
        rotate <0,0,-CountLimb*LimbBending>
       }
      #end
     }
     sphere { <LimbX,LimbY,0>,LimbBase*(1-CountLimb*LimbNarrowing)
      #if (LimbsTextureOwn)
       texture { BarkTexture
        rotate <0,0,-CountLimb*LimbBending>
       }
      #end
     }
    #end
    #declare LimbX = LimbX + LimbLength*sin((CountLimb+1)*pi/180*LimbBending)
    #declare LimbY = LimbY + LimbLength*cos((CountLimb+1)*pi/180*LimbBending)
    #declare CountLimb = CountLimb + 1
   #end
   #if (LimbsVisible)
    sphere { <LimbX,LimbY,0>,LimbBase*(1-LimbNarrowing*LimbsPrecision)
     #if (LimbsTextureOwn)
      texture { BarkTexture
       rotate <0,0,-LimbsPrecision*LimbBending>
      }
     #end
    }
   #end
   // Ended Limb


   // Creating Boughs
   #declare BoughsN = val(substr(Memory,1,11))
   #declare Memory = substr(Memory,12,strlen(Memory)-11)
   #declare CountBoughs = 0
   #while (CountBoughs < BoughsN)
    // Creating Bough
    // These variables changes from bough to bough
    #declare BoughLength = val(substr(Memory,1,11))
    #declare Memory = substr(Memory,12,strlen(Memory)-11)
    #declare BoughBase = val(substr(Memory,1,11))
    #declare Memory = substr(Memory,12,strlen(Memory)-11)
    #declare BoughNarrowing = val(substr(Memory,1,11))
    #declare Memory = substr(Memory,12,strlen(Memory)-11)
    #declare BoughHeight = val(substr(Memory,1,11))
    #declare Memory = substr(Memory,12,strlen(Memory)-11)
    #declare BoughRotZ = val(substr(Memory,1,11))
    #declare Memory = substr(Memory,12,strlen(Memory)-11)
    #declare BoughRotY = val(substr(Memory,1,11))
    #declare Memory = substr(Memory,12,strlen(Memory)-11)
    #declare BoughBending = val(substr(Memory,1,11))
    #declare Memory = substr(Memory,12,strlen(Memory)-11)
    #declare CountBough = 0
    #declare BoughX = 0
    #declare BoughY = 0
    union {
     #while (CountBough < BoughsPrecision)
      #if (BoughsVisible)
       cone {
        <BoughX,BoughY,0>,BoughBase*(1-CountBough*BoughNarrowing)
        <BoughX+BoughLength*sin((CountBough+1)*pi/180*BoughBending),BoughY+BoughLength*cos((CountBough+1)*pi/180*BoughBending),0>,
        BoughBase*(1-(CountBough+1)*BoughNarrowing)
        #if (BoughsTextureOwn)
         texture { BarkTexture
          rotate <0,0,-CountBough*BoughBending>
         }
        #end
       }
       sphere { <BoughX,BoughY,0>,BoughBase*(1-CountBough*BoughNarrowing)
        #if (BoughsTextureOwn)
         texture { BarkTexture
          rotate <0,0,-CountBough*BoughBending>
         }
        #end
       }
      #end
      #declare BoughX = BoughX + BoughLength*sin((CountBough+1)*pi/180*BoughBending)
      #declare BoughY = BoughY + BoughLength*cos((CountBough+1)*pi/180*BoughBending)
      #declare CountBough = CountBough + 1
     #end
     #if (BoughsVisible)
      sphere { <BoughX,BoughY,0>,BoughBase*(1-BoughNarrowing*BoughsPrecision)
       #if (BoughsTextureOwn)
        texture { BarkTexture
         rotate <0,0,-BoughsPrecision*BoughBending>
        }
       #end
      }
     #end
     // Ended Bough


     // Creating Branches
     #declare BranchesN = val(substr(Memory,1,11))
     #declare Memory = substr(Memory,12,strlen(Memory)-11)
     #declare CountBranches = 0
     #while (CountBranches < BranchesN)
      // Creating Branch
      // These variables changes from branch to branch
      #declare BranchLength = val(substr(Memory,1,11))
      #declare Memory = substr(Memory,12,strlen(Memory)-11)
      #declare BranchBase = val(substr(Memory,1,11))
      #declare Memory = substr(Memory,12,strlen(Memory)-11)
      #declare BranchNarrowing = val(substr(Memory,1,11))
      #declare Memory = substr(Memory,12,strlen(Memory)-11)
      #declare BranchHeight = val(substr(Memory,1,11))
      #declare Memory = substr(Memory,12,strlen(Memory)-11)
      #declare BranchRotZ = val(substr(Memory,1,11))
      #declare Memory = substr(Memory,12,strlen(Memory)-11)
      #declare BranchRotY = val(substr(Memory,1,11))
      #declare Memory = substr(Memory,12,strlen(Memory)-11)
      #declare BranchBending = val(substr(Memory,1,11))
      #declare Memory = substr(Memory,12,strlen(Memory)-11)
      #declare CountBranch = 0
      #declare BranchX = 0
      #declare BranchY = 0
      union {
       #while (CountBranch < BranchesPrecision)
        #if (BranchesVisible)
         cone {
          <BranchX,BranchY,0>,BranchBase*(1-CountBranch*BranchNarrowing)
          <BranchX+BranchLength*sin((CountBranch+1)*pi/180*BranchBending),BranchY+BranchLength*cos((CountBranch+1)*pi/180*BranchBending),0>,
          BranchBase*(1-(CountBranch+1)*BranchNarrowing)
          #if (BranchesTextureOwn)
           texture { BarkTexture
            rotate <0,0,-CountBranch*BranchBending>
           }
          #end
         }
         sphere { <BranchX,BranchY,0>,BranchBase*(1-CountBranch*BranchNarrowing)
          #if (BranchesTextureOwn)
           texture { BarkTexture
            rotate <0,0,-CountBranch*BranchBending>
           }
          #end
         }
        #end
        #declare BranchX = BranchX + BranchLength*sin((CountBranch+1)*pi/180*BranchBending)
        #declare BranchY = BranchY + BranchLength*cos((CountBranch+1)*pi/180*BranchBending)
        #declare CountBranch = CountBranch + 1
       #end
       #if (BranchesVisible)
        sphere { <BranchX,BranchY,0>,BranchBase*(1-BranchNarrowing*BranchesPrecision)
         #if (BranchesTextureOwn)
          texture { BarkTexture
           rotate <0,0,-BranchesPrecision*BranchBending>
          }
         #end
        }
       #end
       // Ended Branch


       // Creating Twigs
       #declare TwigsN = val(substr(Memory,1,11))
       #declare Memory = substr(Memory,12,strlen(Memory)-11)
       #declare CountTwigs = 0
       #while (CountTwigs < TwigsN)
        // Creating Twig
        // These variables changes from twig to twig
        #declare TwigLength = val(substr(Memory,1,11))
        #declare Memory = substr(Memory,12,strlen(Memory)-11)
        #declare TwigBase = val(substr(Memory,1,11))
        #declare Memory = substr(Memory,12,strlen(Memory)-11)
        #declare TwigNarrowing = val(substr(Memory,1,11))
        #declare Memory = substr(Memory,12,strlen(Memory)-11)
        #declare TwigHeight = val(substr(Memory,1,11))
        #declare Memory = substr(Memory,12,strlen(Memory)-11)
        #declare TwigRotZ = val(substr(Memory,1,11))
        #declare Memory = substr(Memory,12,strlen(Memory)-11)
        #declare TwigRotY = val(substr(Memory,1,11))
        #declare Memory = substr(Memory,12,strlen(Memory)-11)
        #declare TwigBending = val(substr(Memory,1,11))
        #declare Memory = substr(Memory,12,strlen(Memory)-11)
        #declare CountTwig = 0
        #declare TwigX = 0
        #declare TwigY = 0
        union {
         #while (CountTwig < TwigsPrecision)
          #if (TwigsVisible)
           cone {
            <TwigX,TwigY,0>,TwigBase*(1-CountTwig*TwigNarrowing)
            <TwigX+TwigLength*sin((CountTwig+1)*pi/180*TwigBending),TwigY+TwigLength*cos((CountTwig+1)*pi/180*TwigBending),0>,
            TwigBase*(1-(CountTwig+1)*TwigNarrowing)
            #if (TwigsTextureOwn)
             texture { BarkTexture
              rotate <0,0,-CountTwig*TwigBending>
             }
            #end
           }
           sphere { <TwigX,TwigY,0>,TwigBase*(1-CountTwig*TwigNarrowing)
            #if (TwigsTextureOwn)
             texture { BarkTexture
              rotate <0,0,-CountTwig*TwigBending>
             }
            #end
           }
          #end
          #declare TwigX = TwigX + TwigLength*sin((CountTwig+1)*pi/180*TwigBending)
          #declare TwigY = TwigY + TwigLength*cos((CountTwig+1)*pi/180*TwigBending)
          #declare CountTwig = CountTwig + 1
         #end
         #if (TwigsVisible)
          sphere { <TwigX,TwigY,0>,TwigBase*(1-TwigNarrowing*TwigsPrecision)
          #if (TwigsTextureOwn)
           texture { BarkTexture
            rotate <0,0,-TwigsPrecision*TwigBending>
           }
          #end
          }
         #end
         // OBJECT INSERTION
         //
         #if (TwigsLeavesVisible)
          object { Leaf
           translate <TwigX,TwigY,0>
          }
         #end
         // Ended Twig


         // Translation info of ONE twig
         #if (TwigsAntiRotation)
          rotate <0,0,1>*(-90+TwigRotZ-(-90+BranchRotZ))
         #else
          rotate <0,0,1>*(-90+TwigRotZ-BranchBending*BranchesPrecision)
         #end
         #if (TwigsAntiRotation)
          rotate <0,0,-90+BranchRotZ>
         #else
          rotate <0,0,BranchBending*BranchesPrecision>
         #end
          rotate <0,1,0>*TwigRotY
         #if (TwigsAntiRotation)
          rotate <0,0,-(-90+BranchRotZ)>
         #else
          rotate <0,0,-BranchBending*BranchesPrecision>
         #end
         #if (CountTwigs < TwigsOnTop)
          #declare TwighX = BranchX
          #declare TwighY = BranchY
         #else
          #declare CountTwigh = 0
          #declare TwighX = 0
          #declare TwighY = 0
          #while (CountTwigh*BranchLength < TwigHeight)
           #declare TwighX = TwighX + BranchLength*sin((CountTwigh+1)*pi/180*BranchBending)
           #declare TwighY = TwighY + BranchLength*cos((CountTwigh+1)*pi/180*BranchBending)
           #declare CountTwigh = CountTwigh + 1
          #end
         #end
         translate <TwighX,TwighY,0>
        }
        // Ended Twig moving
        #declare CountTwigs = CountTwigs + 1
       #end
       // Ended Twigs


       // Translation info of ONE branch
       #if (BranchesAntiRotation)
        rotate <0,0,1>*(-90+BranchRotZ-(-90+BoughRotZ))
       #else
        rotate <0,0,1>*(-90+BranchRotZ-BoughBending*BoughsPrecision)
       #end
       #if (BranchesAntiRotation)
        rotate <0,0,-90+BoughRotZ>
       #else
        rotate <0,0,BoughBending*BoughsPrecision>
       #end
        rotate <0,1,0>*BranchRotY
       #if (BranchesAntiRotation)
        rotate <0,0,-(-90+BoughRotZ)>
       #else
        rotate <0,0,-BoughBending*BoughsPrecision>
       #end
       #if (CountBranches < BranchesOnTop)
        #declare BranchhX = BoughX
        #declare BranchhY = BoughY
       #else
        #declare CountBranchh = 0
        #declare BranchhX = 0
        #declare BranchhY = 0
        #while (CountBranchh*BoughLength < BranchHeight)
         #declare BranchhX = BranchhX + BoughLength*sin((CountBranchh+1)*pi/180*BoughBending)
         #declare BranchhY = BranchhY + BoughLength*cos((CountBranchh+1)*pi/180*BoughBending)
         #declare CountBranchh = CountBranchh + 1
        #end
       #end
       translate <BranchhX,BranchhY,0>
      }
      // Ended Branch moving
      #declare CountBranches = CountBranches + 1
     #end
     // Ended Branches


     // Translation info of ONE bough
     #if (BoughsAntiRotation)
      rotate <0,0,1>*(-90+BoughRotZ-(-90+LimbRotZ))
     #else
      rotate <0,0,1>*(-90+BoughRotZ-LimbBending*LimbsPrecision)
     #end
     #if (BoughsAntiRotation)
      rotate <0,0,-90+LimbRotZ>
     #else
      rotate <0,0,LimbBending*LimbsPrecision>
     #end
      rotate <0,1,0>*BoughRotY
     #if (BoughsAntiRotation)
      rotate <0,0,-(-90+LimbRotZ)>
     #else
      rotate <0,0,-LimbBending*LimbsPrecision>
     #end
     #if (CountBoughs < BoughsOnTop)
      #declare BoughhX = LimbX
      #declare BoughhY = LimbY
     #else
      #declare CountBoughh = 0
      #declare BoughhX = 0
      #declare BoughhY = 0
      #while (CountBoughh*LimbLength < BoughHeight)
       #declare BoughhX = BoughhX + LimbLength*sin((CountBoughh+1)*pi/180*LimbBending)
       #declare BoughhY = BoughhY + LimbLength*cos((CountBoughh+1)*pi/180*LimbBending)
       #declare CountBoughh = CountBoughh + 1
      #end
     #end
     translate <BoughhX,BoughhY,0>
    }
    // Ended Bough moving
    #declare CountBoughs = CountBoughs + 1
   #end
   // Ended Boughs


   // Translation info of ONE limb
   #if (LimbsAntiRotation)
    rotate <0,0,1>*(-90+LimbRotZ-TrunkRotation)
   #else
    rotate <0,0,1>*(-90+LimbRotZ+TrunkBendingAngle*TrunkPrecision)
   #end
   #if (LimbsAntiRotation)
    rotate <0,0,TrunkRotation>
   #else
    rotate <0,0,-TrunkBendingAngle*TrunkPrecision>
   #end
    rotate <0,1,0>*LimbRotY
   #if (LimbsAntiRotation)
    rotate <0,0,-TrunkRotation>
   #else
    rotate <0,0,-TrunkBendingAngle*TrunkPrecision>
   #end
   #if (CountLimbs < LimbsOnTop)
    #declare LimbhX = TrunkX
    #declare LimbhY = TrunkY
   #else
    #declare CountLimbh = 0
    #declare LimbhX = 0
    #declare LimbhY = 0
    #while (CountLimbh*TrunkUnitLength < LimbHeight)
     #declare LimbhX = LimbhX + TrunkUnitLength*sin((CountLimbh+1)*pi/180*TrunkBendingAngle)
     #declare LimbhY = LimbhY + TrunkUnitLength*cos((CountLimbh+1)*pi/180*TrunkBendingAngle)
     #declare CountLimbh = CountLimbh + 1
    #end
   #end
   translate <LimbhX,LimbhY,0>
  }
  #declare CountLimbs = CountLimbs + 1
 #end
 // Ended Limbs


 texture { BarkTexture }
 rotate <0,0,TrunkRotation>
 rotate <0,0,0>
}
// ENDED Tree




