
// Persistence of Vision Ray Tracer Scene Description File
// File: mag_rflx.pov
// Vers: 3
// Date: July 1997
// Auth: Matthias Opitz

//*******************************************************************************************
// includes and global settings
//*******************************************************************************************

#include "colors.inc"
#include "textures.inc"
#include "specialtex.inc"
#include "lightsource.inc"

 global_settings {
    adc_bailout 0.0039
    max_trace_level 21
  }

//*******************************************************************************************
// camera 
//*******************************************************************************************


  camera {
     location <0.2, 1.43, -0.85>
     look_at <0,1.24,0>
     angle 35
     }


// this camera for ashtray view
/*camera {
       location <0, 1.3, -0.4>
       look_at <0.03,1.19,-0.18>
       angle 50
       }*/

//*******************************************************************************************
// background
//*******************************************************************************************


background { color Black }




//*******************************************************************************************
// the scene
//*******************************************************************************************

// the mirrors for perpetual reflection

    box {
    <-2,0,2>,  // Near lower left corner
    <2,3.5,2.2>   // Far upper right corner
    texture {
    pigment { Silver }
      finish { reflection 1.0 ambient 0 diffuse 0  }}}

        box {
    <-2,0,-2>,  // Near lower left corner
    <2,3.5,-2.2>   // Far upper right corner
    texture {
    pigment { Silver }
      finish { reflection 1.0 ambient 0 diffuse 0  }}}

       box {
    <-2,0,-2>,  // Near lower left corner
    <-2.2,3.5,2>   // Far upper right corner
    texture {
    pigment { Silver }
      finish { reflection 1.0 ambient 0 diffuse 0  }}}

        box {
    <2,0,-2>,  // Near lower left corner
    <2.2,3.5,2>   // Far upper right corner
    texture {
    pigment { Silver }
      finish { reflection 1.0 ambient 0 diffuse 0  }}}




#declare Tisch = object {
union {


 cylinder {  //Fu
    <0,0,0>,     // Center of one end
    <0,0.04,0>,     // Center of other end
    0.2            // Radius
    //open           // Remove end caps

    texture { Special }
  }

   cylinder {  //senkrechter Zylinder
    <0,0.04,0>,     // Center of one end
    <0,1.12,0>,     // Center of other end
    0.045            // Radius
    //open           // Remove end caps

    texture { Special }
  }

   cylinder {  //Tischplatte 1
    <0,1.12,0>,     // Center of one end
    <0,1.158,0>,     // Center of other end
    0.3           // Radius
    //open           // Remove end caps

    texture { Special } }

      cylinder {  //Tischplatte 2
    <0,1.158,0>,     // Center of one end
    <0,1.16,0>,     // Center of other end
    0.3           // Radius
    //open           // Remove end caps

    texture { table } }


 //********* glass with red drink *************

  union {
    cylinder {  //Glasboden
    <0,0,0>,     // Center of one end
    <0,0.01,0>,     // Center of other end
    0.035            // Radius
    //open           // Remove end caps
    texture { Glass3 }
    translate <0,1.16,0>
  }
   difference {
   cylinder {  //Glas
    <0,0,0>,     // Center of one end
    <0,0.15,0>,     // Center of other end
    0.035            // Radius
    //open           // Remove end caps
    texture { GlassX }}

   cylinder {  //Glas
    <0,-0.01,0>,     // Center of one end
    <0,0.16,0>,     // Center of other end
    0.0325            // Radius
    //open           // Remove end caps
    texture { GlassX }}
    translate <0,1.17,0>
  }

    cylinder {  //Strohhalm
    <0,0,0>,     // Center of one end
    <0,0.19,0>,     // Center of other end
    0.0035          // Radius
    open           // Remove end caps
    texture {
     pigment {
      gradient x
      colour_map {
         [ 0.6     color rgbf <1,1,1, 0.2> ]
         [ 0.6     color rgbf <0,0,1, 0.2> ]
      }
      } scale 0.00272 }
    rotate <20,0,0>
    translate <0,1.17,-0.027>
  }

  cylinder {  //Getrnk
    <0,0,0>,     // Center of one end
    <0,0.12,0>,     // Center of other end
    0.032            // Radius
    //open           // Remove end caps
    texture { pigment { color rgbf <0.7,0.015,0.22,0.6> }
     finish  {
        ambient 0.6
        diffuse 0.1
        reflection 0.15
        refraction on
        ior 1.25
        specular 0.8
        roughness 0.0003
        phong 1
        phong_size 400
        caustics 2
     } }
    translate <0,1.17,0>
  }


box  // Eiswuerfel 1
{
  <0,0,0>  // one corner position <X1 Y1 Z1>
  <0.025,0.025,0.025>  // other corner position <X2 Y2 Z2>
  texture { Ice }
  rotate <10,5,0>
  translate <0, 1.27, 0> }

box  // Eiswuerfel 2
{
  <0,0,0>  // one corner position <X1 Y1 Z1>
  <0.025,0.025,0.025>  // other corner position <X2 Y2 Z2>
  texture { Ice }
  rotate <10,0,5>
  translate <0.01, 1.275, -0.01> }

  rotate <0,-90,0>
  translate <-0.15,0, -0.13>
  }

//********* glass with brown drink *************

   union {
    cylinder {  //Glasboden
    <0,0,0>,     // Center of one end
    <0,0.01,0>,     // Center of other end
    0.035            // Radius
    //open           // Remove end caps
    texture { Glass3 }
    translate <0,1.16,0>
  }

   difference {
   cylinder {  //Glas
    <0,0,0>,     // Center of one end
    <0,0.15,0>,     // Center of other end
    0.035            // Radius
    //open           // Remove end caps
    texture { GlassX }}

   cylinder {  //Glas
    <0,-0.01,0>,     // Center of one end
    <0,0.16,0>,     // Center of other end
    0.0325            // Radius
    //open           // Remove end caps
    texture { GlassX }}
    translate <0,1.17,0>
  }


    cylinder {  //Strohhalm
    <0,0,0>,     // Center of one end
    <0,0.19,0>,     // Center of other end
    0.0035          // Radius
    open           // Remove end caps
    texture {
     pigment {
      gradient x
      colour_map {
         [ 0.6     color rgbf <1,1,1,0.2> ]
         [ 0.6     color rgbf <1,0,0,0.2> ]
      }
      } scale 0.00272 }
     rotate <20,0,0>
    translate <0,1.17,-0.027>
  }

  cylinder {  //Getrnk
    <0,0,0>,     // Center of one end
    <0,0.12,0>,     // Center of other end
    0.032            // Radius
    //open           // Remove end caps
    texture { pigment { color rgbf <0.992, 0.384, 0.09, 0.7> }
     finish  {
        ambient 0.5
        diffuse 0.1
        reflection 0.15
        refraction on
        ior 1.25
        specular 0.8
        roughness 0.0003
        phong 1
        phong_size 400
        caustics 2
     } }
    translate <0,1.17,0>
  }

box  // Eiswuerfel 1
{
  <0,0,0>  // one corner position <X1 Y1 Z1>
  <0.025,0.025,0.025>  // other corner position <X2 Y2 Z2>
  texture { Ice }
  rotate <10,5,0>
  translate <0, 1.26, -0.018> }

box  // Eiswuerfel 2
{
  <0,0,0>  // one corner position <X1 Y1 Z1>
  <0.025,0.025,0.025>  // other corner position <X2 Y2 Z2>
  texture { Ice }
  rotate <10,0,5>
  translate <0, 1.275, -0.018> }



  rotate <0,90,0>
  translate <0.15,0,-0.1>
  }


  //***********************  the ashtray

   union {
    cylinder {  // Bodenplatte
    <0,0,0>,     // Center of one end
    <0,0.007,0>,     // Center of other end
    0.075            // Radius
    //open           // Remove end caps
    texture { ashtray } }

    cylinder {  // Mitte innen
    <0,0.007,0>,     // Center of one end
    <0,0.022,0>,     // Center of other end
    0.06          // Radius
    open           // Remove end caps
    texture { ashtray } }

    cylinder {  // Mitte aussen
    <0,0.007,0>,     // Center of one end
    <0,0.022,0>,     // Center of other end
    0.075          // Radius
    open           // Remove end caps
    texture { ashtray } }

   difference {  // Deckel mit Einfraesungen
      cylinder {
    <0,0.022,0>,     // Center of one end
    <0,0.030,0>,     // Center of other end
    0.075            // Radius
    //open           // Remove end caps
    texture { ashtray } }

    cylinder {
    <0,0.020,0>,     // Center of one end
    <0,0.035,0>,     // Center of other end
    0.05          // Radius
    //open           // Remove end caps
    texture { ashtray } }

     cylinder {
    <-0.1,0.030,0>,     // Center of one end
    <0.1,0.030,0>,     // Center of other end
    0.005          // Radius
    //open           // Remove end caps
    texture { ashtray } }

     cylinder {
    <0,0.030,-0.1>,     // Center of one end
    <0,0.030,0.1>,     // Center of other end
    0.005          // Radius
    //open           // Remove end caps
    texture { ashtray } } }
    rotate <0,-40,0>
    translate <0.03,1.16,-0.18> }

  //********************** the cigarette

   union {
    cylinder {
    <-0.02,0.0295,0>,     // Center of one end
    <-0.077,0.0295,0>,     // Center of other end
    0.0045          // Radius
    open           // Remove end caps
    texture { pigment { White }
    finish { ambient 0 crand 0.01 }} }

    cylinder {
    <-0.077,0.0295,0>,     // Center of one end
    <-0.078,0.0295,0>,     // Center of other end
    0.0045          // Radius
    open           // Remove end caps
    texture { pigment { OldGold }
    finish { ambient 0.1 reflection 0.1 }} }

      cylinder {
    <-0.078,0.0295,0>,     // Center of one end
    <-0.08,0.0295,0>,     // Center of other end
    0.0045          // Radius
    open           // Remove end caps
    texture { pigment { White }
    finish { ambient 0 crand 0.01 }} }



    cylinder {  //Filter
    <-0.08,0.0295,0>,     // Center of one end
    <-0.102,0.0295,0>,     // Center of other end
    0.004500          // Radius
    open           // Remove end caps
    texture { Filter } }

     cylinder {  //Filter innen
    <-0.100,0.0295,0>,     // Center of one end
    <-0.102,0.0295,0>,     // Center of other end
    0.004400          // Radius
    //open           // Remove end caps
    texture { pigment {color rgb <1,0.94,0.902>} finish { ambient 0 crand 0.09 } } }
    rotate <0,-40,0>
    translate <0.03,1.16,-0.18> }

    //*** the embers is defined in the section below ***

//**************************************************************************************
// halos for smoke and glowing cigarette
//**************************************************************************************

//*********************** the smoke

   sphere { <0,0,0>, 1
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      attenuating
      spherical_mapping
      poly
      turbulence 3
      scale 0.7
      frequency 2
        color_map {
       [ 0 color rgbft <0.435,0.482,0.659, 0.6, 0.9> ]
       [ 1 color rgbft <0.435,0.482,0.659, 0.6, -0.1> ]

      }
      samples 40
      jitter 0.1
      }
    hollow
    scale <0.01,0.12,0.01>
    normal { bumps 5 scale 0.2 }
    translate <0.025,1.30,-0.185>
      }

//*************** the embers ******************

  cylinder {   
    <0,0,0>,     // Center of one end
    <1,0,0>,     // Center of other end
    1.0          // Radius
    //open       // Remove end caps
     texture {
     pigment {
      crackle
      turbulence 3
      colour_map {
         [ 0.05     color rgbt <0.14,0.14,0.14,0.45> ]
         [ 0.05     color rgbt <0.85,0.85,0.85,0.45> ]
      }
      scale 0.6
      }
      finish {crand 0.23 }
      normal { bumps 5 scale 0.05 }}
      normal { bumps 5 scale 0.05 }
      halo {
      emitting
      cylindrical_mapping
      linear
      color_map {
    [ 0 color rgbt <1, 0.22, 0,  0.8> ]
    [ 1 color rgbt <0.89, 0.18, 0, -0.65> ]
    }
    samples 20
    }
    scale <0.015,0.0045,0.0045>
    rotate <0,-40,0>
    translate <0.0145,1.1895,-0.193>
    hollow
     } } }


 object { Tisch }




#declare Barhocker = object {

union {

cylinder {  //Boden
    <0,0,0>,     // Center of one end
    <0,0.04,0>,     // Center of other end
    0.16            // Radius
    //open           // Remove end caps
    texture { Special } }


  cylinder {  //senkrecht
    <0,0.04,0>,     // Center of one end
    <0,0.69,0>,     // Center of other end
    0.04            // Radius
    //open           // Remove end caps
    texture { Special } }

 cylinder {  //Sitz
    <0,0.69,0>,     // Center of one end
    <0,0.79,0>,     // Center of other end
    0.15          // Radius
    //open           // Remove end caps
    texture { Special
    normal { ripples scale <5,0.002,5> frequency 0.1 } }}


    cylinder {  //Sitz
    <0,0.79,0>,     // Center of one end
    <0,0.83,0>,     // Center of other end
    0.15            // Radius
    //open           // Remove end caps
    texture { pigment { color rgb <0.004,0.361,0.051> } finish {
    reflection 0.15 diffuse 0.1 ambient 0.32 crand 0.1 phong 0.3 phong_size 65 } } }

torus { 0.16, 0.02      // major and minor radius
    translate <0,0.28,0>
    rotate <0,0,0>
    texture { Special }
    sturm
  }

  #declare Querstrebe1 = object {
  cylinder {
    <-0.08,0,0>,     // Center of one end
    <0.08,0,0>,     // Center of other end
    0.01            // Radius
    //open           // Remove end caps
    texture { Special } } }

    #declare Querstrebe2 = object {
  cylinder {
    <0,0,-0.08>,     // Center of one end
    <0,0,0.08>,     // Center of other end
    0.01            // Radius
    //open           // Remove end caps
    texture { Special } } }

    object { Querstrebe1 rotate <0,0,-30> translate <-0.08,0.24,0>  }
    object { Querstrebe1 rotate <0,0,30> translate <0.08,0.24,0>  }
    object { Querstrebe2 rotate <30,0,0> translate <0,0.24,-0.08>  }
    object { Querstrebe2 rotate <-30,0,0> translate <0,0.24,0.08>  }

    }}

    object { Barhocker translate <-0.45,0,0.45> }
    object { Barhocker translate <0.45,0,-0.45> }


  








