//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 1 lights, 14 textures and 234 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5b.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 08/30/1997    (30.08.1997)
//
//  (c) Ralph Gerhard
//  r.gerhard@iname.com
//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray V2.0 exports for POV-Ray.
//





global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <-4.000, -9.000, 3.000>
  direction <0.0,     0.0,  1.0071>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <-0.139, 0.252, 0.656>
}

// *******  L I G H T S *******
light_source {   // Light1
  <0.400, -4.000, 8.000>
  color rgb <1.000, 1.000, 1.000>
}


// ********  TEXTURES  *******
//

#include "meeting.inc"



// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******

#declare GelbWuerfelpunkt = difference {
  box { // Gelbwuerfd
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Gelbglas
    }
    translate  1.0*z
  }
  sphere { // Punkt001
    <0,0,0>,1
    texture {
      Black
    }
    scale 0.2
    translate  <1.0, 0.0, 1.0>
  }
  sphere { // Punkt002
    <0,0,0>,1
    texture {
      Black
    }
    scale 0.2
    rotate <-1.0, -1.0, -1.0>
    translate  <0.0, -1.0, 1.0>
  }
  sphere { // Punkt003
    <0,0,0>,1
    texture {
      Black
    }
    scale 0.2
    rotate <-2.0, -2.0, -2.0>
    translate  <-1.0, 0.0, 1.0>
  }
  sphere { // Punkt004
    <0,0,0>,1
    texture {
      Black
    }
    scale 0.2
    rotate <-3.0, -3.0, -3.0>
    translate  <0.0, 1.0, 1.0>
  }
  sphere { // Punkt005
    <0,0,0>,1
    texture {
      Black
    }
    scale 0.2
    rotate <-4.0, -4.0, -4.0>
  }
  sphere { // Punkt006
    <0,0,0>,1
    texture {
      Black
    }
    scale 0.2
    rotate <-5.0, -5.0, -5.0>
    translate  2.0*z
  }
  translate  -1.0*z
}
#declare GelbWuerfel = intersection {
  sphere { // GelbWuerfelINTRS
    <0,0,0>,1
    texture {
      Gelbglas
    }
    scale 1.5
  }
  object { GelbWuerfelpunkt }
  rotate <-1.0, -1.0, -1.0>
  translate  -4.0*x
}
#declare RotWuerfelpunkt = difference {
  box { // Rotwuerfd
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Rotglas
    }
    translate  1.0*z
  }
  sphere { // Punkt011
    <0,0,0>,1
    texture {
      Black
    }
    scale 0.2
    translate  <1.0, 0.0, 1.0>
  }
  sphere { // Punkt012
    <0,0,0>,1
    texture {
      Black
    }
    scale 0.2
    rotate <-1.0, -1.0, -1.0>
    translate  <0.0, -1.0, 1.0>
  }
  sphere { // Punkt013
    <0,0,0>,1
    texture {
      Black
    }
    scale 0.2
    rotate <-2.0, -2.0, -2.0>
    translate  <-1.0, 0.0, 1.0>
  }
  sphere { // Punkt014
    <0,0,0>,1
    texture {
      Black
    }
    scale 0.2
    rotate <-3.0, -3.0, -3.0>
    translate  <0.0, 1.0, 1.0>
  }
  sphere { // Punkt015
    <0,0,0>,1
    texture {
      Black
    }
    scale 0.2
    rotate <-4.0, -4.0, -4.0>
  }
  sphere { // Punkt016
    <0,0,0>,1
    texture {
      Black
    }
    scale 0.2
    rotate <-5.0, -5.0, -5.0>
    translate  2.0*z
  }
  translate  -1.0*z
}
#declare RotWuerfel = intersection {
  sphere { // RotWuerfelINTRS
    <0,0,0>,1
    texture {
      Rotglas
    }
    scale 1.5
  }
  object { RotWuerfelpunkt }
  rotate <-1.0, -1.0, -1.0>
  translate  -4.0*y
}
#declare BlauWuerfelPunkt = difference {
  box { // BlauWuerfd
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Blauglas
    }
    translate  1.0*z
  }
  sphere { // Punkt021
    <0,0,0>,1
    texture {
      Black
    }
    scale 0.2
    translate  <1.0, 0.0, 1.0>
  }
  sphere { // Punkt022
    <0,0,0>,1
    texture {
      Black
    }
    scale 0.2
    rotate <-1.0, -1.0, -1.0>
    translate  <0.0, -1.0, 1.0>
  }
  sphere { // Punkt023
    <0,0,0>,1
    texture {
      Black
    }
    scale 0.2
    rotate <-2.0, -2.0, -2.0>
    translate  <-1.0, 0.0, 1.0>
  }
  sphere { // Punkt024
    <0,0,0>,1
    texture {
      Black
    }
    scale 0.2
    rotate <-3.0, -3.0, -3.0>
    translate  <0.0, 1.0, 1.0>
  }
  sphere { // Punkt025
    <0,0,0>,1
    texture {
      Black
    }
    scale 0.2
    rotate <-4.0, -4.0, -4.0>
  }
  sphere { // Punkt026
    <0,0,0>,1
    texture {
      Black
    }
    scale 0.2
    rotate <-5.0, -5.0, -5.0>
    translate  2.0*z
  }
  translate  <0.0, 4.0, -1.0>
}
#declare BlauWuerfel = intersection {
  sphere { // BlauWuerfelINTRS
    <0,0,0>,1
    texture {
      Blauglas
    }
    scale 1.5
    translate  4.0*y
  }
  object { BlauWuerfelPunkt }
  rotate <-1.0, -1.0, -1.0>
}
#declare GruenWuerfePunkt = difference {
  box { // GruenWuerfd
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Gruenglas
    }
    translate  1.0*z
  }
  sphere { // Punkt031
    <0,0,0>,1
    texture {
      Black
    }
    scale 0.2
    translate  <1.0, 0.0, 1.0>
  }
  sphere { // Punkt032
    <0,0,0>,1
    texture {
      Black
    }
    scale 0.2
    rotate <-1.0, -1.0, -1.0>
    translate  <0.0, -1.0, 1.0>
  }
  sphere { // Punkt033
    <0,0,0>,1
    texture {
      Black
    }
    scale 0.2
    rotate <-2.0, -2.0, -2.0>
    translate  <-1.0, 0.0, 1.0>
  }
  sphere { // Punkt034
    <0,0,0>,1
    texture {
      Black
    }
    scale 0.2
    rotate <-3.0, -3.0, -3.0>
    translate  <0.0, 1.0, 1.0>
  }
  sphere { // Punkt035
    <0,0,0>,1
    texture {
      Black
    }
    scale 0.2
    rotate <-4.0, -4.0, -4.0>
  }
  sphere { // Punkt036
    <0,0,0>,1
    texture {
      Black
    }
    scale 0.2
    rotate <-5.0, -5.0, -5.0>
    translate  2.0*z
  }
  translate  -1.0*z
}
#declare GruenWuerfel = intersection {
  sphere { // GruenWuerfeINTRS
    <0,0,0>,1
    texture {
      Gruenglas
    }
    scale 1.5
  }
  object { GruenWuerfePunkt }
  rotate <-1.0, -1.0, -1.0>
  translate  4.0*x
}
#declare MagicWuerfel = union {
  object { GelbWuerfel }
  object { RotWuerfel }
  object { BlauWuerfel }
  object { GruenWuerfel }
}
#declare Zauberstabfarben = union {
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1
    texture {
      Black
    }
    scale <0.4, 0.4, 5.0>
    rotate 90.0*y
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    texture {
      White
    }
    scale <0.4, 0.4, 1.0>
    rotate -90.0*y
  }
}
#declare MM = union {
  sphere { // cmsph
    <0,0,0>,1
    scale 0.187
    translate  <0.0, 0.813, 2.438>
  }
  sphere { // cmsph1
    <0,0,0>,1
    scale 0.187
    translate  <0.0, -0.813, 2.438>
  }
  sphere { // cmsph2
    <0,0,0>,1
    scale 0.187
    translate  <0.0, 0.813, -0.813>
  }
  sphere { // cmsph3
    <0,0,0>,1
    scale 0.187
    translate  <0.0, -0.813, -0.813>
  }
  sphere { // cmsph4
    <0,0,0>,1
    scale 0.187
    translate  0.813*z
  }
  cylinder { // cmcyl1
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 3.251>
    translate  <0.0, 0.813, -0.813>
  }
  cylinder { // cmcyl2
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 3.251>
    translate  <0.0, -0.813, -0.813>
  }
  cylinder { // cmcyl3
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 1.817053>
    rotate -26.579*x
    translate  0.813*z
  }
  cylinder { // cmcyl4
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 1.817>
    rotate 26.579*x
    translate  0.813*z
  }
  bounded_by { // Bound00001
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <0.226993, 1.039993, 1.852493>
      translate  <0.0, 0.0, 0.8125>
    }
  }
  rotate -90.0*z
}
#declare diff_r = difference {
  torus { // rtor
    0.8125, 0.1875  rotate -x*90
    rotate -90.0*y
  }
  box { // rcub
    <-1, -1, -1>, <1, 1, 1>
    scale <0.248567, 1.05, 0.5>
    translate  -0.5*z
  }
}
#declare Mr = union {
  object { diff_r }
  cylinder { // rcyl
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 1.625>
    translate  <0.0, 0.813, -0.813>
  }
  sphere { // rsph
    <0,0,0>,1
    scale 0.187
    translate  <0.0, 0.813, 0.813>
  }
  sphere { // rsph1
    <0,0,0>,1
    scale 0.187
    translate  <0.0, 0.813, -0.813>
  }
  sphere { // rsph2
    <0,0,0>,1
    scale 0.187
    translate  -0.813*y
  }
  bounded_by { // Bound00003
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <0.279215, 1.080647, 1.030648>
    }
  }
  rotate 90.0*z
  translate  5.0*x
}
#declare Ma = union {
  torus { // ator
    0.8125, 0.1875  rotate -x*90
    rotate -90.0*y
  }
  sphere { // asph1
    <0,0,0>,1
    scale 0.187
    translate  <0.0, -0.813, 0.813>
  }
  sphere { // asph2
    <0,0,0>,1
    scale 0.187
    translate  <0.0, -0.813, -0.813>
  }
  cylinder { // acyl
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 1.625>
    translate  <0.0, -0.813, -0.813>
  }
  bounded_by { // Bound00004
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <0.216667, 1.029167, 1.029167>
      translate  <0.0, 0.0, 0.0>
    }
  }
  rotate 90.0*z
  translate  7.5*x
}
#declare My = union {
  sphere { // ysph
    <0,0,0>,1
    scale 0.187
    translate  <0.0, 0.813, 0.813>
  }
  sphere { // ysph1
    <0,0,0>,1
    scale 0.187
    translate  <0.0, -0.813, 0.813>
  }
  cylinder { // ycyl
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 1.986904>
    rotate -24.15*x
    translate  -1.0*z
  }
  sphere { // ysph2
    <0,0,0>,1
    scale 0.187
    translate  <0.0, 0.813, -2.813>
  }
  cylinder { // ycyl2
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 3.974>
    rotate 24.15*x
    translate  <0.0, 0.812795, -2.813026>
  }
  bounded_by { // Bound00005
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <0.229493, 1.042493, 2.042493>
      translate  <0.0, 0.0, -1.0>
    }
  }
  rotate 90.0*z
  translate  10.0*x
}
#declare Moray = merge {
  object { MM }
  torus { // Mo
    0.8125, 0.1875  rotate -x*90
    bounded_by { // Bound00002
      box {
        <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
        scale <1.029167, 1.029167, 0.216667>
        translate  0.0*z
      }
    }
    rotate <90.0, -90.0, 0.0>
    translate  2.5*x
  }
  object { Mr }
  object { Ma }
  object { My }
  texture {
    Gold
  }
  scale <0.12, 0.4, 0.11>
  translate  <0.5, -0.35, 0.0>
}
#declare ZauberstabMoray = difference {
  object { Zauberstabfarben }
  object { Moray }
  rotate -10.0*y
  translate  <1.5, 0.0, 3.0>
}
#declare Zauberstabfar1 = union {
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1
    texture {
      Black
    }
    scale <0.4, 0.4, 5.0>
    rotate 90.0*y
  }
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1
    texture {
      White
    }
    scale <0.4, 0.4, 1.0>
    rotate -90.0*y
  }
}
#declare cpcut = difference {
  torus { // cptor
    0.8125, 0.1875  rotate -x*90
    rotate -90.0*y
    translate  1.625*z
  }
  box { // cpcub
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.6, 1.1>
    translate  <0.0, 0.6, 1.625>
  }
}
#declare PP = union {
  sphere { // pcsph
    <0,0,0>,1
    scale 0.187
    translate  <0.0, 0.813, 2.438>
  }
  sphere { // pcsph1
    <0,0,0>,1
    scale 0.187
    translate  <0.0, 0.813, -0.813>
  }
  cylinder { // pccyl
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 3.25>
    translate  <0.0, 0.813, -0.813>
  }
  object { cpcut }
  cylinder { // cpcyl2
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 0.813>
    rotate -90.0*x
    translate  2.438*z
  }
  cylinder { // cpcyl3
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 0.813>
    rotate -90.0*x
    translate  0.813*z
  }
  bounded_by { // Bound00006
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <0.292833, 1.142833, 1.905333>
      translate  <0.0, 0.1, 0.8625>
    }
  }
  rotate 90.0*z
}
#declare Pv = union {
  cylinder { // vcyl
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 1.75>
    rotate -25.0*x
    translate  <0.0, 0.00004, -0.812976>
  }
  cylinder { // vcyl1
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 1.75>
    rotate 25.0*x
    translate  <0.0, -0.000034, -0.812983>
  }
  sphere { // vsph
    <0,0,0>,1
    scale 0.187
    translate  -0.813*z
  }
  sphere { // vsph1
    <0,0,0>,1
    scale 0.187
    translate  <0.0, 0.739598, 0.772971>
  }
  sphere { // vsph2
    <0,0,0>,1
    scale 0.187
    translate  <0.0, -0.739585, 0.772976>
  }
  bounded_by { // Bound00008
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <0.214914, 0.954506, 1.007903>
      translate  <0.0, 0.000007, -0.020012>
    }
  }
  rotate 90.0*z
  translate  5.0*x
}
#declare diff_r1 = difference {
  torus { // rtor1
    0.8125, 0.1875  rotate -x*90
    rotate -90.0*y
  }
  box { // rcub1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.248567, 1.05, 0.5>
    translate  -0.5*z
  }
}
#declare Pr = union {
  object { diff_r1 }
  cylinder { // rcyl1
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 1.625>
    translate  <0.0, 0.813, -0.813>
  }
  sphere { // rsph3
    <0,0,0>,1
    scale 0.187
    translate  <0.0, 0.813, 0.813>
  }
  sphere { // rsph4
    <0,0,0>,1
    scale 0.187
    translate  <0.0, 0.813, -0.813>
  }
  sphere { // rsph5
    <0,0,0>,1
    scale 0.187
    translate  -0.813*y
  }
  bounded_by { // Bound00009
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <0.279215, 1.080647, 1.030648>
    }
  }
  rotate 90.0*z
  translate  7.5*x
}
#declare Pa = union {
  torus { // ator1
    0.8125, 0.1875  rotate -x*90
    rotate -90.0*y
  }
  sphere { // asph3
    <0,0,0>,1
    scale 0.187
    translate  <0.0, -0.813, 0.813>
  }
  sphere { // asph4
    <0,0,0>,1
    scale 0.187
    translate  <0.0, -0.813, -0.813>
  }
  cylinder { // acyl1
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 1.625>
    translate  <0.0, -0.813, -0.813>
  }
  bounded_by { // Bound00010
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <0.216667, 1.029167, 1.029167>
      translate  <0.0, 0.0, 0.0>
    }
  }
  rotate 90.0*z
  translate  10.0*x
}
#declare Py = union {
  sphere { // ysph3
    <0,0,0>,1
    scale 0.187
    translate  <0.0, 0.813, 0.813>
  }
  sphere { // ysph4
    <0,0,0>,1
    scale 0.187
    translate  <0.0, -0.813, 0.813>
  }
  cylinder { // ycyl1
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 1.986904>
    rotate -24.15*x
    translate  -1.0*z
  }
  sphere { // ysph5
    <0,0,0>,1
    scale 0.187
    translate  <0.0, 0.813, -2.813>
  }
  cylinder { // ycyl3
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 3.974>
    rotate 24.15*x
    translate  <0.0, 0.812795, -2.813026>
  }
  bounded_by { // Bound00011
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <0.229493, 1.042493, 2.042493>
      translate  <0.0, 0.0, -1.0>
    }
  }
  rotate 90.0*z
  translate  12.5*x
}
#declare Povray = merge {
  object { PP }
  torus { // Po
    0.8125, 0.1875  rotate -x*90
    bounded_by { // Bound00007
      box {
        <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
        scale <1.029167, 1.029167, 0.216667>
        translate  0.0*z
      }
    }
    rotate <90.0, -90.0, 0.0>
    translate  2.5*x
  }
  object { Pv }
  object { Pr }
  object { Pa }
  object { Py }
  texture {
    Gold
  }
  scale <0.12, 0.4, 0.11>
  rotate <180.0, 0.0, 180.0>
  translate  <2.0, -0.35, 0.0>
}
#declare ZauberstabPovray = difference {
  object { Zauberstabfar1 }
  object { Povray }
  rotate <180.0, -10.0, 180.0>
  translate  <-1.5, 0.0, 3.0>
}
#declare MagicFire = union {
  sphere { // Sphere1
    <0,0,0>,1
    texture {
      Fire4
    }
    no_shadow
    translate  1.0*z
  }
  sphere { // Sphere2
    <0,0,0>,1
    texture {
      Fire3
    }
    no_shadow
    scale 2.0
    translate  2.0*z
  }
  sphere { // Sphere3
    <0,0,0>,1
    texture {
      Fire2
    }
    no_shadow
    scale 4.0
    translate  4.0*z
  }
  sphere { // Sphere4
    <0,0,0>,1
    texture {
      Fire1
    }
    no_shadow
    scale 6.0
    translate  6.0*z
  }
  sphere { // Sphere5
    <0,0,0>,1
    texture {
      Fire4
    }
    no_shadow
    scale 1.5
    translate  1.5*z
  }
  sphere { // Sphere6
    <0,0,0>,1
    texture {
      Fire2
    }
    no_shadow
    scale 3.0
    translate  3.0*z
  }
  no_shadow
  scale <0.3, 0.3, 0.5>
  rotate -60.0*z
  translate  2.2*z
}
#declare Perlenschale = difference {
  sphere { // Sphere01
    <0,0,0>,1
  }
  sphere { // Sphere02
    <0,0,0>,1
    scale 1.089109
    translate  0.09901*x
  }
  scale 1.01
  rotate <0.0, 0.0, 0.0>
  translate  <0.0, 0.0, 2.0>
}
#declare CSG001 = difference {
  cylinder { // Cylndr1
    <0,0,1>, <0,0,0>, 1
    scale <0.8, 0.8, 0.2>
    rotate -90.0*x
    translate  2.0*z
  }
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1
    scale <0.6, 0.6, 0.4>
    rotate -90.0*x
    translate  <0.0, -0.1, 2.0>
  }
}
#declare CSG002 = difference {
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 0.2>
    rotate -90.0*x
    translate  0.4*z
  }
  cylinder { // Cylndr6
    <0,0,1>, <0,0,0>, 1
    scale <0.8, 0.8, 0.4>
    rotate -90.0*x
    translate  <0.0, -0.1, 0.4>
  }
}
#declare CSG003 = union {
  object { CSG001 }
  object { CSG002 }
  translate  1.0*z
}
#declare G3_1 = difference {
  object { CSG003 }
  cylinder { // Cylndr7
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 0.4>
    rotate -90.0*x
    translate  <-1.0, -0.1, 2.25>
  }
  scale <0.02, 0.06, 0.02>
  translate  <-1.5, -0.045, -0.04>
}
#declare CSG6 = difference {
  cylinder { // Cylndr8
    <0,0,1>, <0,0,0>, 1
    scale <0.8, 0.8, 0.2>
    rotate -90.0*x
    translate  2.0*z
  }
  cylinder { // Cylndr9
    <0,0,1>, <0,0,0>, 1
    scale <0.6, 0.6, 0.4>
    rotate -90.0*x
    translate  <0.0, -0.1, 2.0>
  }
}
#declare CSG7 = difference {
  cylinder { // Cylndr10
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 0.2>
    rotate -90.0*x
    translate  0.4*z
  }
  cylinder { // Cylndr11
    <0,0,1>, <0,0,0>, 1
    scale <0.8, 0.8, 0.4>
    rotate -90.0*x
    translate  <0.0, -0.1, 0.4>
  }
}
#declare CSG12 = union {
  object { CSG6 }
  object { CSG7 }
  translate  1.0*z
}
#declare G3_2 = difference {
  object { CSG12 }
  cylinder { // Cylndr12
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 0.4>
    rotate -90.0*x
    translate  <-1.0, -0.1, 2.25>
  }
  scale <0.02, 0.06, 0.02>
  translate  <-1.45, -0.045, -0.04>
}
#declare CSG13 = difference {
  cylinder { // Cylndr13
    <0,0,1>, <0,0,0>, 1
    scale <0.8, 0.8, 0.2>
    rotate -90.0*x
    translate  2.0*z
  }
  cylinder { // Cylndr14
    <0,0,1>, <0,0,0>, 1
    scale <0.6, 0.6, 0.4>
    rotate -90.0*x
    translate  <0.0, -0.1, 2.0>
  }
}
#declare CSG14 = difference {
  cylinder { // Cylndr15
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 0.2>
    rotate -90.0*x
    translate  0.4*z
  }
  cylinder { // Cylndr16
    <0,0,1>, <0,0,0>, 1
    scale <0.8, 0.8, 0.4>
    rotate -90.0*x
    translate  <0.0, -0.1, 0.4>
  }
}
#declare CSG15 = union {
  object { CSG13 }
  object { CSG14 }
  translate  1.0*z
}
#declare G3_3 = difference {
  object { CSG15 }
  cylinder { // Cylndr17
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 0.4>
    rotate -90.0*x
    translate  <-1.0, -0.1, 2.25>
  }
  scale <0.02, 0.06, 0.02>
  translate  <-1.4, -0.045, -0.04>
}
#declare Gravur_333er = merge {
  object { G3_1 }
  object { G3_2 }
  object { G3_3 }
  scale <1.0, 2.0, 1.0>
  translate  <0.0, 0.038, 0.0>
}
#declare cgut1 = difference {
  torus { // cgtor1
    0.8125, 0.1875  rotate -x*90
    rotate -90.0*y
    translate  1.625*z
  }
  box { // cgcube1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.6, 1.1>
    rotate -90.0*x
    translate  1.025*z
  }
}
#declare cglt1 = difference {
  torus { // cgtor2
    0.8125, 0.1875  rotate -x*90
    rotate -90.0*y
  }
  box { // cgcube2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.6, 1.1>
    rotate -90.0*x
    translate  0.6*z
  }
}
#declare gc = union {
  object { cgut1 }
  object { cglt1 }
  sphere { // cgsph1
    <0,0,0>,1
    scale 0.187
    translate  <0.0, -0.813, 1.625>
  }
  cylinder { // cgcyl1
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 1.625>
    translate  0.813*y
  }
  sphere { // cgsph2
    <0,0,0>,1
    scale 0.187
    translate  0.625*z
  }
  sphere { // cgsph3
    <0,0,0>,1
    scale 0.187
    translate  <0.0, -0.813, 0.625>
  }
  cylinder { // cgcyl2
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 0.625>
    translate  -0.813*y
  }
  cylinder { // cgcyl3
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 0.813>
    rotate -90.0*x
    translate  <0.0, -0.813, 0.625>
  }
  rotate 90.0*z
}
#declare sube = difference {
  torus { // etor
    0.8125, 0.1875  rotate -x*90
    rotate -90.0*y
  }
  box { // ecub1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.331317, 0.147235>
    translate  <0.0, -0.746763, -0.147246>
  }
  box { // ecub2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.331317, 0.147235>
    rotate 45.0*x
    translate  <0.0, -0.63821, -0.429979>
  }
  box { // ecub3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.331317, 0.147235>
    rotate 22.5*x
    translate  <0.0, -0.758422, -0.34546>
  }
}
#declare e = union {
  object { sube }
  cylinder { // ecyl1
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 1.5>
    rotate -90.0*x
    translate  -0.813*y
  }
  sphere { // esph1
    <0,0,0>,1
    scale 0.187
    translate  <0.0, -0.813, 0.0>
  }
  sphere { // esph2
    <0,0,0>,1
    scale 0.187
    translate  <0.0, -0.574519, -0.574523>
  }
  rotate 90.0*z
  translate  2.5*x
}
#declare diff_r2 = difference {
  torus { // rtor2
    0.8125, 0.1875  rotate -x*90
    rotate -90.0*y
  }
  box { // rcub2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.248567, 1.05, 0.5>
    translate  -0.5*z
  }
}
#declare r = union {
  object { diff_r2 }
  cylinder { // rcyl2
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 1.625>
    translate  <0.0, 0.813, -0.813>
  }
  sphere { // rsph6
    <0,0,0>,1
    scale 0.187
    translate  <0.0, 0.813, 0.813>
  }
  sphere { // rsph7
    <0,0,0>,1
    scale 0.187
    translate  <0.0, 0.813, -0.813>
  }
  sphere { // rsph8
    <0,0,0>,1
    scale 0.187
    translate  -0.813*y
  }
  rotate 90.0*z
  translate  5.0*x
}
#declare diff_h = difference {
  torus { // htor
    0.8125, 0.1875  rotate -x*90
    rotate -90.0*y
  }
  box { // hcub1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 1.1, 0.55>
    translate  -0.55*z
  }
}
#declare h = union {
  sphere { // hsph1
    <0,0,0>,1
    scale 0.187
    translate  <0.0, 0.813, 2.438>
  }
  sphere { // hsph2
    <0,0,0>,1
    scale 0.187
    translate  <0.0, 0.813, -0.813>
  }
  cylinder { // hcyl1
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 3.25>
    translate  <0.0, 0.806748, -0.813>
  }
  object { diff_h }
  sphere { // hsph3
    <0,0,0>,1
    scale 0.187
    translate  <0.0, -0.813, -0.813>
  }
  cylinder { // hcylin
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 0.813>
    translate  <0.0, -0.813, -0.813>
  }
  rotate 90.0*z
  translate  7.5*x
}
#declare a = union {
  torus { // ator2
    0.8125, 0.1875  rotate -x*90
    rotate -90.0*y
  }
  sphere { // asph5
    <0,0,0>,1
    scale 0.187
    translate  <0.0, -0.813, 0.813>
  }
  sphere { // asph6
    <0,0,0>,1
    scale 0.187
    translate  <0.0, -0.813, -0.813>
  }
  cylinder { // acyl2
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 1.625>
    translate  <0.0, -0.813, -0.813>
  }
  rotate 90.0*z
  translate  10.0*x
}
#declare diff_r3 = difference {
  torus { // rtor3
    0.8125, 0.1875  rotate -x*90
    rotate -90.0*y
  }
  box { // rcub3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.248567, 1.05, 0.5>
    translate  -0.5*z
  }
}
#declare r1 = union {
  object { diff_r3 }
  cylinder { // rcyl3
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 1.625>
    translate  <0.0, 0.813, -0.813>
  }
  sphere { // rsph9
    <0,0,0>,1
    scale 0.187
    translate  <0.0, 0.813, 0.813>
  }
  sphere { // rsph10
    <0,0,0>,1
    scale 0.187
    translate  <0.0, 0.813, -0.813>
  }
  sphere { // rsph11
    <0,0,0>,1
    scale 0.187
    translate  -0.813*y
  }
  rotate 90.0*z
  translate  12.5*x
}
#declare d = union {
  sphere { // dsph1
    <0,0,0>,1
    scale 0.187
    translate  <0.0, -0.813, 2.438>
  }
  sphere { // dsph2
    <0,0,0>,1
    scale 0.187
    translate  <0.0, -0.813, -0.813>
  }
  cylinder { // dcyl1
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 3.25>
    translate  <0.0, -0.813, -0.813>
  }
  torus { // dtor
    0.8125, 0.1875  rotate -x*90
    rotate -90.0*y
  }
  rotate 90.0*z
  translate  15.0*x
}
#declare Gerhard = merge {
  object { gc }
  object { e }
  object { r }
  object { h }
  object { a }
  object { r1 }
  object { d }
  scale <0.01, 0.04, 0.01>
  rotate <0.0, 0.0, 0.0>
  translate  <-1.78, -0.045, 0.0>
}
#declare crcut = difference {
  torus { // crtor
    0.8125, 0.1875  rotate -x*90
    rotate -90.0*y
    translate  1.625*z
  }
  box { // crcub
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.6, 1.1>
    translate  <0.0, 0.6, 1.625>
  }
}
#declare rc = union {
  sphere { // crsph
    <0,0,0>,1
    scale 0.187
    translate  <0.0, 0.813, 2.438>
  }
  sphere { // crsph1
    <0,0,0>,1
    scale 0.187
    translate  <0.0, -0.813, -0.813>
  }
  cylinder { // crcyl
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 3.25>
    translate  <0.0, 0.813, -0.813>
  }
  object { crcut }
  cylinder { // crcyl2
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 0.813>
    rotate -90.0*x
    translate  2.438*z
  }
  cylinder { // crcyl3
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 0.813>
    rotate -90.0*x
    translate  0.813*z
  }
  sphere { // crsph2
    <0,0,0>,1
    scale 0.187
    translate  <0.0, 0.813, -0.813>
  }
  cylinder { // crcyl4
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 1.817599>
    rotate -26.579*x
    translate  <0.0, -0.813, -0.813>
  }
  rotate 90.0*z
}
#declare a1 = union {
  torus { // ator3
    0.8125, 0.1875  rotate -x*90
    rotate -90.0*y
  }
  sphere { // asph7
    <0,0,0>,1
    scale 0.187
    translate  <0.0, -0.813, 0.813>
  }
  sphere { // asph8
    <0,0,0>,1
    scale 0.187
    translate  <0.0, -0.813, -0.813>
  }
  cylinder { // acyl3
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 1.625>
    translate  <0.0, -0.813, -0.813>
  }
  rotate 90.0*z
  translate  2.5*x
}
#declare l = union {
  sphere { // lsph1
    <0,0,0>,1
    scale 0.187
    translate  2.438*z
  }
  sphere { // lsph2
    <0,0,0>,1
    scale 0.187
    translate  -0.813*z
  }
  cylinder { // lcyl1
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 3.25>
    translate  -0.813*z
  }
  rotate 90.0*z
  translate  4.25*x
}
#declare p = union {
  torus { // ptor
    0.8125, 0.1875  rotate -x*90
    rotate -90.0*y
  }
  cylinder { // pcyl
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 3.438001>
    translate  <0.0, 0.813, -2.625>
  }
  sphere { // psph
    <0,0,0>,1
    scale 0.187
    translate  <0.0, 0.813, 0.813>
  }
  sphere { // psph1
    <0,0,0>,1
    scale 0.187
    translate  <0.0, 0.813, -2.625>
  }
  rotate 90.0*z
  translate  6.0*x
}
#declare diff_h1 = difference {
  torus { // htor1
    0.8125, 0.1875  rotate -x*90
    rotate -90.0*y
  }
  box { // hcub2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 1.1, 0.55>
    translate  -0.55*z
  }
}
#declare h1 = union {
  sphere { // hsph4
    <0,0,0>,1
    scale 0.187
    translate  <0.0, 0.813, 2.438>
  }
  sphere { // hsph5
    <0,0,0>,1
    scale 0.187
    translate  <0.0, 0.813, -0.813>
  }
  cylinder { // hcyl2
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 3.25>
    translate  <0.0, 0.806748, -0.813>
  }
  object { diff_h1 }
  sphere { // hsph6
    <0,0,0>,1
    scale 0.187
    translate  <0.0, -0.813, -0.813>
  }
  cylinder { // hcylin1
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 0.813>
    translate  <0.0, -0.813, -0.813>
  }
  rotate 90.0*z
  translate  8.5*x
}
#declare Ralph = merge {
  object { rc }
  object { a1 }
  object { l }
  object { p }
  object { h1 }
  scale <0.01, 0.04, 0.01>
  rotate <0.0, 0.0, 0.0>
  translate  <-1.9, -0.045, 0.0>
}
#declare mc = union {
  sphere { // cmsph5
    <0,0,0>,1
    scale 0.187
    translate  <0.0, 0.813, 2.438>
  }
  sphere { // cmsph6
    <0,0,0>,1
    scale 0.187
    translate  <0.0, -0.813, 2.438>
  }
  sphere { // cmsph7
    <0,0,0>,1
    scale 0.187
    translate  <0.0, 0.813, -0.813>
  }
  sphere { // cmsph8
    <0,0,0>,1
    scale 0.187
    translate  <0.0, -0.813, -0.813>
  }
  sphere { // cmsph9
    <0,0,0>,1
    scale 0.187
    translate  0.813*z
  }
  cylinder { // cmcyl5
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 3.251>
    translate  <0.0, 0.813, -0.813>
  }
  cylinder { // cmcyl6
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 3.251>
    translate  <0.0, -0.813, -0.813>
  }
  cylinder { // cmcyl7
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 1.817053>
    rotate -26.579*x
    translate  0.813*z
  }
  cylinder { // cmcyl8
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 1.817>
    rotate 26.579*x
    translate  0.813*z
  }
  rotate -90.0*z
}
#declare diff_r4 = difference {
  torus { // rtor4
    0.8125, 0.1875  rotate -x*90
    rotate -90.0*y
  }
  box { // rcub4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.248567, 1.05, 0.5>
    translate  -0.5*z
  }
}
#declare r2 = union {
  object { diff_r4 }
  cylinder { // rcyl4
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 1.625>
    translate  <0.0, 0.813, -0.813>
  }
  sphere { // rsph12
    <0,0,0>,1
    scale 0.187
    translate  <0.0, 0.813, 0.813>
  }
  sphere { // rsph13
    <0,0,0>,1
    scale 0.187
    translate  <0.0, 0.813, -0.813>
  }
  sphere { // rsph14
    <0,0,0>,1
    scale 0.187
    translate  -0.813*y
  }
  rotate 90.0*z
  translate  5.0*x
}
#declare a2 = union {
  torus { // ator4
    0.8125, 0.1875  rotate -x*90
    rotate -90.0*y
  }
  sphere { // asph9
    <0,0,0>,1
    scale 0.187
    translate  <0.0, -0.813, 0.813>
  }
  sphere { // asph10
    <0,0,0>,1
    scale 0.187
    translate  <0.0, -0.813, -0.813>
  }
  cylinder { // acyl4
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 1.625>
    translate  <0.0, -0.813, -0.813>
  }
  rotate 90.0*z
  translate  7.5*x
}
#declare my = union {
  sphere { // ysph6
    <0,0,0>,1
    scale 0.187
    translate  <0.0, 0.813, 0.813>
  }
  sphere { // ysph7
    <0,0,0>,1
    scale 0.187
    translate  <0.0, -0.813, 0.813>
  }
  cylinder { // ycyl4
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 1.986904>
    rotate -24.15*x
    translate  -1.0*z
  }
  sphere { // ysph8
    <0,0,0>,1
    scale 0.187
    translate  <0.0, 0.813, -2.813>
  }
  cylinder { // ycyl5
    <0,0,1>, <0,0,0>, 1
    scale <0.187, 0.187, 3.974>
    rotate 24.15*x
    translate  <0.0, 0.812795, -2.813026>
  }
  rotate 90.0*z
  translate  10.0*x
}
#declare Gravur_Moray = merge {
  object { mc }
  torus { // otor
    0.8125, 0.1875  rotate -x*90
    rotate <90.0, -90.0, 0.0>
    translate  2.5*x
  }
  object { r2 }
  object { a2 }
  object { my }
  scale <0.01, 0.04, 0.01>
  rotate <0.0, 0.0, 0.0>
  translate  <-1.3, -0.045, 0.0>
}
#declare Gravur_der_Nadel = difference {
  cylinder { // Nadel
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 2.5>
    rotate <-90.0, 0.0, 90.0>
    translate  0.0*y
  }
  object { Gravur_333er }
  object { Gerhard }
  object { Ralph }
  object { Gravur_Moray }
  rotate <0.0, 0.0, 0.0>
  translate  <0.0, 0.0, 2.0>
}
#declare Stecker = union {
  object { Perlenschale }
  object { Gravur_der_Nadel }
  texture {
    Gold
  }
  rotate <-22.5, 0.0, 180.0>
  translate  <0.0, 0.765367, -1.847759>
}
#declare Federbuegel_1 = difference {
  cylinder { // Cylndr02
    <0,0,1>, <0,0,0>, 1
    scale 0.2
    rotate -90.0*x
    translate  <-0.2, -0.1, 0.26>
  }
  cylinder { // Cylndr03
    <0,0,1>, <0,0,0>, 1
    scale <0.19, 0.19, 0.22>
    rotate -90.0*x
    translate  <-0.2, -0.11, 0.26>
  }
}
#declare Federbuegel_2 = difference {
  cylinder { // Cylndr04
    <0,0,1>, <0,0,0>, 1
    scale 0.2
    rotate -90.0*x
    translate  <-0.2, -0.1, -0.26>
  }
  cylinder { // Cylndr05
    <0,0,1>, <0,0,0>, 1
    scale <0.19, 0.19, 0.22>
    rotate -90.0*x
    translate  <-0.2, -0.11, -0.26>
  }
}
#declare Teller = difference {
  cylinder { // Cylndr01
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 0.01>
  }
  cylinder { // Cylndr18
    <0,0,1>, <0,0,0>, 1
    scale <0.06, 0.06, 0.12>
    translate  <0.0, 0.0, -0.05>
  }
  rotate -90.0*y
}
#declare Verschlussteil = union {
  object { Federbuegel_1 }
  object { Federbuegel_2 }
  object { Teller }
}
#declare Verschluss = difference {
  object { Verschlussteil }
  box { // FederDIFFR
    <-1, -1, -1>, <1, 1, 1>
    scale <0.04, 0.1, 0.2>
    translate  -0.055*x
  }
  texture {
    Gold
  }
  rotate <-22.5, 0.0, -180.0>
  translate  <2.0, 0.0, 0.0>
}
#declare Ohrstecker = union {
  superellipsoid { // Diamant_01
    <2.0, 2.0>
    texture {
      Diamant
    }
    translate  1.0*z
  }
  superellipsoid { // Diamant_02
    <2.0, 2.0>
    texture {
      Diamant
    }
    translate  1.0*z
  }
  superellipsoid { // Diamant_03
    <2.0, 2.0>
    texture {
      Diamant
    }
    rotate -45.0*x
    translate  <0.0, 0.707107, 0.707107>
  }
  superellipsoid { // Diamant_04
    <2.0, 2.0>
    texture {
      Diamant
    }
    rotate -90.0*x
    translate  <0.0, 1.0, 0.0>
  }
  superellipsoid { // Diamant_05
    <2.0, 2.0>
    texture {
      Diamant
    }
    rotate -135.0*x
    translate  <0.0, 0.707107, -0.707107>
  }
  superellipsoid { // Diamant_06
    <2.0, 2.0>
    texture {
      Diamant
    }
    rotate 180.0*x
    translate  <0.0, 0.0, -1.0>
  }
  superellipsoid { // Diamant_07
    <2.0, 2.0>
    texture {
      Diamant
    }
    rotate 135.0*x
    translate  <0.0, -0.707107, -0.707107>
  }
  superellipsoid { // Diamant_08
    <2.0, 2.0>
    texture {
      Diamant
    }
    rotate 90.0*x
    translate  <0.0, -1.0, 0.0>
  }
  superellipsoid { // Diamant_09
    <2.0, 2.0>
    texture {
      Diamant
    }
    rotate 45.0*x
    translate  <0.0, -0.707107, 0.707107>
  }
  sphere { // Perle
    <0,0,0>,1
    texture {
      Perlmut
    }
    rotate 130.0*z
  }
  object { Stecker }
  object { Verschluss }
  rotate <-22.5, 0.0, -180.0>
}
#declare EastMSun = union {
  object { Ohrstecker }
  rotate <0.0, -90.0, -22.5>
}
#declare Laser = union {
  cylinder { // Laser1
    <0,0,1>, <0,0,0>, 1
    texture {
      Fire1
    }
    scale <0.02, 0.02, 2.5>
    rotate -14.0*y
  }
  cylinder { // Laser2
    <0,0,1>, <0,0,0>, 1
    texture {
      Fire1
    }
    scale <0.02, 0.02, 2.5>
    rotate 14.0*y
  }
  cylinder { // Laser3
    <0,0,1>, <0,0,0>, 1
    texture {
      Fire1
    }
    scale <0.02, 0.02, 4.0>
    rotate -90.0*y
  }
  cylinder { // Laser4
    <0,0,1>, <0,0,0>, 1
    texture {
      Fire1
    }
    scale <0.02, 0.02, 4.0>
    rotate 90.0*y
  }
  cylinder { // Laser5
    <0,0,1>, <0,0,0>, 1
    texture {
      Fire1
    }
    scale <0.02, 0.02, 4.0>
    rotate -90.0*x
  }
  cylinder { // Laser6
    <0,0,1>, <0,0,0>, 1
    texture {
      Fire1
    }
    scale <0.02, 0.02, 4.0>
    rotate 90.0*x
  }
}
union { // MagicMeeting
  sphere { // MagicSphere
    <0,0,0>,1
    texture {
      PinkAlabaster
    }
    scale 12.0
  }
  object { MagicWuerfel }
  object { ZauberstabMoray }
  object { ZauberstabPovray }
  object { MagicFire }
  object { EastMSun }
  object { Laser }
}




