#declare Ring = difference
{
    cylinder { <0,0,-0.05>, <0,0,0.05>, 0.55 }
    cylinder { <0,0,-1>, <0,0,1>, 0.45 }
    texture
    {
        T_Stone7
        finish
        {
            phong 0
            diffuse 0.7
            roughness 0.8
            specular 0
        }
    }
}

#declare Pedstal = union
{
    object
    {
        BigStone
        translate <0,-0.5,0.05>
        #declare TR = rand(R)
        translate x*+TR
        texture { MyStone_T pigment { turbulence 2.5 } scale <0.5, 0.5, 0.075> }
        translate x*-TR
        rotate x*90
        scale <1.5,4,1.5>
        translate y*-0.5
    }
    object
    {
        BigStone
        translate <0,-0.5,0.05>
        #declare TR = rand(R)
        translate x*+TR
        texture { MyStone_T pigment { turbulence 2.5 } scale <0.5, 0.5, 0.075> }
        translate x*-TR
        rotate x*90
        rotate y*180
        scale <2.5,4,2.5>
        translate y*-0.575
    }
}

#declare Lightning = difference
{
    torus
    {
        0.5, 0.15 //0.18
    }
    torus
    {
        0.5, 0.14999999
    }
    box
    {
        <-1,-1,-1>,<1,1,1>
        rotate z*45
        translate z*1.5
    }
    no_shadow
    rotate x*90
    texture { Lightning_T }
}

#declare Portal = union
{
    object { Pedstal }
    object { Ring }
    object { Stones }
}

#declare Destination = union
{
intersection
{
    height_field
    {
        gif "ripples2.gif"
        water_level 0.001
        scale <1,0.1,1>
        translate <-0.5, -0.5, -0.5>
        rotate x*90
    }
    texture
    {
        pigment
        {
            image_map { tga "temple.tga" }
            scale <4/3,1,1>
            scale 0.92
            translate <-0.65,-0.47,0> //-0.65
        }
        finish
        {
            ambient 0.9
            diffuse 0.0
        }
    }
    hollow
    no_shadow
}
translate z*0.6
}


#declare MMBox = difference
{
    difference
    {
        box
        {
            <-0.5,-0.5,-0.5>, <0.5,0.5,0.5>
            texture { T_Stone13 /*rotate <45,45,0>*/ scale 0.2 }
        }
        text
        {
            ttf "c:\windows\fonts\agincort.ttf"
            "M"
            1, 0
            translate <-0.55,-0.375,-1.5>
            scale <1,1,1>
            scale 0.75
            texture { BD_T scale 5 }
        }
        rotate y*90
    }
    text
    {
        ttf "c:\windows\fonts\agincort.ttf"
        "M"
        1, 0
        translate <-0.55,-0.375,-1.5>
        scale <1,1,1>
        scale 0.75
        texture { BD_T scale 5 }
    }
    rotate y*-35
    scale 0.125
    translate <0.5,-0.53,-0.25>
}
