//
// Kugel
//
#version 3
#include "colors.inc"
#include "glass.inc"
#include "woods.inc"
#include "metals.inc"
#include "stones.inc"
#include "skies.inc"

#include "Tools.inc"

#declare T_Wand = texture { T_Stone5 finish{ambient 0.1} }


//////////////////////////////////////////////////////////////////////
// Die Form eines Fensters in gotischem Stil
// Mae      : 1x1x1
// Nullpunkt : x und z mittig, y unten
#declare FensterlochGotisch = union
{
   box { <-4,0,-0.5>, <4,12,0.5>  } // gerader Teil
   intersection
   {
      cylinder { <-7,12,-0.501>, <-7,12,0.501>, 11 }  // linker Bogen
      cylinder { <7,12,-0.5>, <7,12,0.5>, 11 }    // rechter Bogen
   }
   scale <1/8,1/20.5,1>
} // FensterlochGotisch


//////////////////////////////////////////////////////////////////////
// Eine Fensterfllung mit Mittelsule frs gotische Fenster
// Mae      : 1x1x1
// Nullpunkt : x und z mittig, y unten
#declare FensterkreuzGotisch = union
{
   difference
   {
      object { FensterlochGotisch scale <1,1,0.6> }
      object { FensterlochGotisch scale <.95,.95,1> translate <0,0.025,0> }
   }
   cylinder { <0,0,0>, <0,1,0>, 0.04 }
}


//////////////////////////////////////////////////////////////////////
// Eine einfache, leicht bauchige Sule
// Mae      : 1x1x1
// Nullpunkt : x und z mittig, y unten
#declare SaeuleBauchig = union
{
   cylinder { <0,0,0>, <0,1.5,0>, 2 }  // unterer Sulenfuss
   cylinder { <0,18.5,0>, <0,20,0>, 2 }  // unterer Sulenfuss
   torus {  1.5, 0.5 translate <0,1.75,0> }  // unterer  Ring
   torus {  1.5, 0.5 translate <0,18.25,0> } // oberer Ring

   intersection  // bauchige Sule
   {
      sphere { <0,0,0>, 2 scale <1,6,1> translate <0,10,0>  }
      cylinder { <0,0,0>, <0,20,0>, 2.01 }
   }
   scale <1/4, 1/20, 1/4>
} // SaeuleBauchig


// Der Raum im Hintergrund
#declare Raum = union
{
 difference
 {
   box { <-620,-120,-620>, <620,220,620> }
   box { <-600,-100,-600>, <600,200,600> }
   object { FensterlochGotisch scale <120,220,50> translate <0,-40,600> }
   object { FensterlochGotisch scale <120,220,50> translate <-200,-40,600> }
   object { FensterlochGotisch scale <120,220,50> translate <200,-40,600> }
   object { FensterlochGotisch scale <120,220,50> translate <-400,-40,600> }
   object { FensterlochGotisch scale <120,220,50> translate <400,-40,600> }
   texture { T_Wand scale 50 }
 }
 union
 {
  object { SaeuleBauchig scale <60,300,60> translate <-500,-100,570> }
  object { SaeuleBauchig scale <60,300,60> translate <-300,-100,570> }
  object { SaeuleBauchig scale <60,300,60> translate <-100,-100,570> }
  object { SaeuleBauchig scale <60,300,60> translate <100,-100,570> }
  object { SaeuleBauchig scale <60,300,60> translate <300,-100,570> }
  object { SaeuleBauchig scale <60,300,60> translate <500,-100,570> }
  texture { T_Wand scale 50 }
 }

 // Fensterkreuze
 union
 {
   object { FensterkreuzGotisch scale <120,220,40> translate <0,-40,600> }
   object { FensterkreuzGotisch scale <120,220,40> translate <-200,-40,600> }
   object { FensterkreuzGotisch scale <120,220,40> translate <200,-40,600> }
   object { FensterkreuzGotisch scale <120,220,40> translate <-400,-40,600> }
   object { FensterkreuzGotisch scale <120,220,40> translate <400,-40,600> }
   texture { T_Wood35 scale 3 }
 }

union
 {
  object { FensterlochGotisch scale <120,220,0.1> translate <0,-40,615> }
  object { FensterlochGotisch scale <120,220,1> translate <-200,-40,615> }
  object { FensterlochGotisch scale <120,220,1> translate <200,-40,615> }
  object { FensterlochGotisch scale <120,220,1> translate <-400,-40,615> }
  object { FensterlochGotisch scale <120,220,1> translate <400,-40,615> }
  texture { T_GlasStarkGeriffelt scale 20 }
 }
}


// Die schwarze Glaskugel (der Bereich, in dem man in die Kugel blicken kann
// ist ausgespart; die restliche Kugel undurchsichtig
#declare Glaskugel = difference
{
   sphere { <0,0,0>, 10.5 }
   cylinder { <0,0,2.5>, <0,0,-15>, 7.5 }
   texture { T_GlasSchwarz }
}


// Der Sichtbereich, in dem man ins Kugelinnere blicken kann
#declare SchwarzeSchicht = intersection
{
   sphere { <0,0,0>, 1 }
   cylinder { <0,0,0.25>, <0,0,-1.5>, 0.75 }
   pigment { color rgbt <1, 1, 1, 1> }
   halo {
      emitting
      cylindrical_mapping
      linear
      color_map {
         [ 0.0  0.1 color rgbt <0, 0, 0, -1.0>  color rgbt <0, 0, 0, -1.0> ] // auen
         [ 0.1  0.8 color rgbt <0, 0, 0, -1.0>  color rgbt <0, 0, 0, 1.0> ]
         [ 0.8  1   color rgbt <0, 0, 0, 1.0>   color rgbt <0, 0, 0, 1.0>] //Innen
      } // color_map
      samples 2
      rotate <90,0,0>
    } // halo
  hollow
  scale 10
} // KugelEinblick


// Das Bild im Kugelinneren
#declare Bild = cylinder
{
   <0,0,2.4>, <0,0,2.5>, 7.5
      pigment { image_map
      {
         tga "Birgitt.tga"
         once
         }
         scale <15,15,1>
         translate <-7.5,-7.5,0>
      }
   finish { ambient 1 diffuse 0 }
} // Bild


// Die durchsichtige Glasverkleidung von dem Einblick-Bereich
#declare KugelAussen = intersection
{
   difference
   {
      sphere { <0,0,0>, 10.5 }
      sphere { <0,0,0>, 10.1 }
   }
   cylinder { <0,0,2.5>, <0,0,-15>, 7.5 }
   texture { T_GlasGeriffelt }
   hollow
}



#declare Tischplatte = box
{
   <-60,-20,-50>, <60,-16,60>
   texture { T_Wood24 scale 3 rotate <5,24,0> }
}


#declare EinKugelBein = union
{
   cone     { <0,0,0>,0, <-2.5,-1.5,0>, 0.3 }
   sphere   { <-2.5,-1.5,0>, 0.3 }
   cylinder { <-2.5,-1.5,0>, <-2.5,-5,0>, 0.3 }
   cylinder { <-2.5,-5,0>, <0,-8,0>, 0.3 }

   cylinder { <-2.5,-5,0>, <-5,-2,0>, 0.3 }
   sphere   { <-5,-2,0>, 0.35 }
   cylinder { <-5,-2,0>, <-4,2,0>, 0.3 }
   cone     { <-4,2,0>, 0.3, <-3.5,4,0>, 0 }

   sphere   { <-2.5,-5,0>, 0.6 }
   sphere   { <0,-8, 0>, 0.6 }
   cylinder { <0,-8,0>, <-5,-11,0>, 0.5 }
   sphere   { <-5,-11,0>, 0.6 }
   cone     { <-5,-11,0>, 0, <-5,-12,0>, 1 }
   translate <-9,-4,0>
}

#declare KugelFuss = union
{
   object { EinKugelBein }
   object { EinKugelBein rotate <0,60,0>}
   object { EinKugelBein rotate <0,120,0>}
   object { EinKugelBein rotate <0,180,0>}
   object { EinKugelBein rotate <0,240,0>}
   object { EinKugelBein rotate <0,300,0>}
   difference
   {
      cylinder { <0,-11.8,0>, <0,-12.2,0>, 9.3 }
      cylinder { <0,-11,0>, <0,-13,0>, 8.7 }
   }
    texture { T_Brass_1A }
}


#declare MagischeKugel = union
{
   object { Glaskugel }
   object { SchwarzeSchicht }
   object { Bild }
   object { KugelAussen }
}

#declare MagischeKugelSchnell =
   sphere { <0,0,0>, 10.5 pigment { color Black } }


#declare LampeStehend2 = union
{
   // unterer Teil
   difference
   {
      union
      {
         cylinder { <0,0,0>, <0,2,0>, 3 }
         cylinder { <2,-0.5,0>, <2,0.1,0>, 0.4 rotate <0,0,0> }
         cylinder { <2,-0.5,0>, <2,0.1,0>, 0.4 rotate <0,90,0> }
         cylinder { <2,-0.5,0>, <2,0.1,0>, 0.4 rotate <0,180,0> }
         cylinder { <2,-0.5,0>, <2,0.1,0>, 0.4 rotate <0,270,0> }
      }
      cylinder { <0,0.4,0>, <0,3,0>, 2.6 }
      #declare Winkel = 0;
      #while( Winkel <180 )
         cylinder { <0,1,-4>, <0,1,4>, 0.5 rotate <0,Winkel,0> }
         #declare Winkel = Winkel + 30
      #end
      texture { T_LampenFassung }
   }
   // oberer Teil
   difference
   {
      union
      {
         cylinder { <0,9,0>, <0,11,0>, 3 }
         cone { <0,11,0>, 3, <0,12.5,0>, 0 }
         sphere { <0,12.3,0>, 0.7 }
      }
      cylinder { <0,8,0>, <0,10.6,0>, 2.6 }
      #declare Winkel = 0;
      #while( Winkel <180 )
         cylinder { <0,10,-4>, <0,10,4>, 0.5 rotate <0,Winkel,0> }
         #declare Winkel = Winkel + 30
      #end
      texture { T_LampenFassung }
   }

   // Gestnge
   union
   {
      #declare Winkel = 0;
      #while( Winkel <360 )
         cylinder { <2.8,1.9,0>, <2.8,9.1,0>, 0.2 rotate <0,Winkel,0> }
         #declare Winkel = Winkel + 60
      #end
      texture { T_LampenFassung }
   }

   // Glaskrper
   difference
   {
      cylinder { <0,1.9,0>, <0,9.1,0>, 2.6 }
      cylinder { <0,1,0>, <0,10,0>, 2.3 }
      texture { T_LampenGlas }
   }

   // Leuchtsteine
   union
   {
      #declare Winkel = 0;
      #while( Winkel < 360 )
         sphere { <0,0,0>, 0.5 scale <1,1,0.3> translate <0,1,3> rotate <0,Winkel,0> }
         sphere { <0,0,0>, 0.5 scale <1,1,0.3> translate <0,10,3> rotate <0,Winkel,0> }
         #declare Winkel = Winkel + 30
      #end
      texture { T_LeuchtGlasRot }
   }
   light_source
   {
      <0,6,0>
      color White
      area_light <2,0,2>, <0,2,0>, 5, 5
      adaptive 1 jitter
      fade_power 2 fade_distance 20
      atmosphere off
   }
} // LampeStehend2



#declare LampeHaengend1 = union
{
   union  // Lampenfassung
   {
      difference    // Hauptkrper
      {
         cylinder { <0,-1,0>, <0,1,0>, 0.75 }
         cylinder { <0,-0.95,0>, <0,0.95,0>, 0.65 }  // Aushhlung
         box { <-0.25,-0.9,-1>, <0.25,0.9,1> }         // Schlitze
         box { <-0.25,-0.9,-1>, <0.25,0.9,1> rotate <0,60,0> }
         box { <-0.25,-0.9,-1>, <0.25,0.9,1> rotate <0,120,0> }
      }
      cone { <0,1,0>, 0.75, <0,1.5,0>, 0 }   // oberer Abschlu
      cone { <0,-1,0>, 0.75, <0,-1.5,0>, 0 }   //unterer Abschlu
      texture { T_LampenFassung }
   } // Lampenkrper
   difference  // Glaskrper
   {
      cylinder { <0,-0.95,0>, <0,0.95,0>, 0.65 }
      cylinder { <0,-0.9,0>, <0,0.9,0>, 0.6 }  // Aushhlung
      texture { T_LampenGlas }
   } // Glaskrper

   light_source
   {
      <0,0,0>
      color White
      area_light <2,0,2>, <0,2,0>, 5, 5
      adaptive 1 jitter
      fade_power 2 fade_distance 20
   }
   scale 0.5
} // LampeHaengend1


camera
{
  location <0, 5, -90>
  look_at <0, 5, 0>
  angle 55
}

//*************************************************************************
// Ein schwaches Hintergrundliccht
light_source { <100, 200, -200> color rgb <0.1,0.1,0.04> fade_power 2 fade_distance 600 }

//*************************************************************************
// Das Mondlicht auerhalb des Raumes
light_source { <1000,800,-500> color rgb <1,1,1> }

object { Raum }
object { MagischeKugel }
object { Tischplatte }
object { KugelFuss }
object { LampeStehend2 translate <-25,-15.5,-20> }
object { KomischesGeraet rotate <90,130,0> translate <3,-15.5,-27> texture { T_Brass_1A } }
object { Buch rotate <0,0,-11> scale <0.6,0.6,0.6> translate <22.2,-15,20.1> }
object { Buch rotate <0,0,-17> scale <0.6,0.6,0.6> translate <16,-15,19.7> }
object { Buch scale <0.6,0.6,0.6> translate <30,-15,20> }
object { Buch scale <0.6,0.6,0.6> translate <33.9,-15,20.5> }
object { Buch scale <0.6,0.6,0.6> translate <37.7,-15,19.7> }
object { Buch scale <0.6,0.6,0.6> translate <41.7,-15,20.6> }
object { Buch scale <0.6,0.6,0.6> translate <47.5,-15,19> }
object { LampeStehend2 scale 4 translate <300,120,500> }

fog { distance 2000 turbulence 2 turb_depth 10 color rgbt <0.06,0.06,.2,.1> }
sky_sphere { S_Cloud2 }

height_field
{
  gif
  "Mountain.gif"
  pigment { color Wheat }
  smooth
  scale <8000,700,6000>
  translate <-4000,0,-3000>
  rotate <0,181,0>
  translate <0,-200,5000>
  hollow
}


