
// Persistence of Vision Ray Tracer Scene Description File
// File: .inc
// Vers: 3
// Desc: HAND
// Date: v1 26.08.1997
// Auth: NB

// #declare SIDE = 1 // 1=left, -1=right, don't even try other values

#declare H_R01 = .65
#declare H_S01 = 3
#declare H_D01 = H_S01*pow((1-pow(H_R01,2)),2)

//palm, dimensions
#declare H_E00X = 1.7
#declare H_E00Y = 8/6
#declare H_E00Z = 3.5/6

//wrist
#declare W_E00X = 1
#declare W_E00Y = 1.1*2
#declare W_E00Z = .9*2
#declare W_E00DX = 1.5
#declare W_A00Y = 15*SIDE

//ball of the thumb/thumb, "internal"
#declare H_E01X = 5/2
#declare H_E01Y = 3/2
#declare H_E01Z = 2.1/2
// #declare H_A01X = 3*SIDE     //adjustable
// #declare H_A01Z = -40        //adjustable
#declare H_E01DX = 1.7
#declare H_E01DY = H_E01Y/1.8
#declare H_E01DZ = H_E01Z*SIDE*.05

//thumb, "internal" & "external"
#declare H_E11X = 1.5
#declare H_E11Y = 2.2/4.2
#declare H_E11Z = 2/4.2
// #declare H_A11Y = 10*SIDE    //"joint 1", adjustable
// #declare H_A11Z = 2

//forefinger, "internal" & "external"
#declare H_E02X = 2
#declare H_E02Y = 1.8/4.2
#declare H_E02Z = 1.5/4.2
// #declare H_A02Y = 10*SIDE    //"joint 1", adjustable
// #declare H_A02Z = 2
#declare H_E02DX = H_E00X*-3.5
#declare H_E02DY = 2.9
#declare H_E02DZ = -.2

//middle finger, "internal" & "external"
#declare H_E03X = 2.2
#declare H_E03Y = 1.85/4.2
#declare H_E03Z = 1.55/4.2
// #declare H_A03Y = 10*SIDE    //"joint 1", adjustable
// #declare H_A03Z = 0
#declare H_E03DX = H_E00X*-3.6
#declare H_E03DY = .8
#declare H_E03DZ = -.4

//4th finger, "internal" & "external"
#declare H_E04X = 2
#declare H_E04Y = 1.7/4.2
#declare H_E04Z = 1.45/4.2
// #declare H_A04Y = 10*SIDE    //"joint1", adjustable
// #declare H_A04Z = -2
#declare H_E04DX = H_E00X*-3.4
#declare H_E04DY = -1.2
#declare H_E04DZ = -.3

//little finger, "internal" & "external"
#declare H_E05X = 1.8
#declare H_E05Y = 1.5/4.2
#declare H_E05Z = 1.25/4.2
// #declare H_A05Y = 10*SIDE    //"joint1", adjustable
// #declare H_A05Z = -4
#declare H_E05DX = H_E00X*-3.3
#declare H_E05DY = -2.9
#declare H_E05DZ = -.2

//hand, "internal" part
#declare H01I=
blob{ threshold H_D01
   cylinder{<H_E00X*-1,0,0><0,0,0>1,H_S01
      scale <1,H_E00Y/H_R01,H_E00Z/H_R01>*3}

   cylinder{<W_E00X,0,0><0,0,0>1,H_S01
      scale <2,W_E00Y/H_R01,W_E00Z/H_R01>*1.3
      translate x*W_E00DX
      rotate y*W_A00Y*-1}

   sphere{0,1,-1 scale <2.5,3.5,1> rotate z*35 translate <H_E00X*3/-2,0,H_E00Z*3*SIDE>}

   sphere{0,1,H_S01
      scale <H_E01X/H_R01,H_E01Y/H_R01,H_E01Z/H_R01>
      translate <H_E01X*-1,0,0>
      rotate z*H_A01Z
      rotate x*H_A01X
      translate <0,H_E01DY,H_E01DZ>
      translate x*H_E01DX}

  cylinder{<H_E11X/-2,0,0><0,0,0>1,H_S01
      scale <1,H_E11Y/H_R01,H_E11Z/H_R01>*2
      translate <H_E01X*-1,0,0>*2
      rotate z*H_A01Z
      rotate x*H_A01X
      rotate y*H_A11Y
      translate <0,H_E01DY*1.2,H_E01DZ>
      translate x*H_E01DX}

   cylinder{<H_E02X/-2,0,0><0,0,0>1,H_S01
      scale <1,H_E02Y/H_R01,H_E02Z/H_R01>*2
      rotate <0,H_A02Y,H_A02Z>
      translate <H_E02DX,H_E02DY,H_E02DZ>}

   cylinder{<H_E03X/-2,0,0><0,0,0>1,H_S01
      scale <1,H_E03Y/H_R01,H_E03Z/H_R01>*2
      rotate <0,H_A03Y,H_A03Z>
      translate <H_E03DX,H_E03DY,H_E03DZ>}

   cylinder{<H_E04X/-2,0,0><0,0,0>1,H_S01
      scale <1,H_E04Y/H_R01,H_E04Z/H_R01>*2
      rotate <0,H_A04Y,H_A04Z>
      translate <H_E04DX,H_E04DY,H_E04DZ>}

   cylinder{<H_E05X/-2,0,0><0,0,0>1,H_S01
      scale <1,H_E05Y/H_R01,H_E05Z/H_R01>*2
      rotate <0,H_A05Y,H_A05Z>
      translate <H_E05DX,H_E05DY,H_E05DZ>}
   sturm
}

//hand "external"part:

//thumb "external"
#declare H_E21X = 1.1
#declare H_E21Y = 1.9/4.2
#declare H_E21Z = 1.6/4.2
// #declare H_A21Y = 10*SIDE    //"joint 2", adjustable
// #declare H_A21Z = 20         //"joint 2", adjustable
#declare H01E=
blob{ threshold H_D01
   cylinder{<H_E11X*-.8,0,0><0,0,0>1,H_S01
      scale <1,H_E11Y/H_R01,H_E11Z/H_R01>*2
      translate <H_E01X*-1,0,0>*2
      rotate z*H_A01Z
      rotate x*H_A01X
      rotate y*H_A11Y
      translate <0,H_E01DY*1.2,H_E01DZ>
      translate x*H_E01DX}

   cylinder{<H_E21X*-.8,0,0><0,0,0>1,H_S01
      scale <1,H_E21Y/H_R01,H_E21Z/H_R01>*2
      rotate y*H_A21Y
      rotate z*H_A21Z
      translate <(H_E01X+H_E21X*1.1)*-1,0,0>*2
      rotate z*H_A01Z
      rotate x*H_A01X
      rotate y*H_A11Y
      translate <0,H_E01DY*1.2,H_E01DZ>
      translate x*H_E01DX}

   sturm
}

//forefinger "external"
#declare H_E12X = 1.1
#declare H_E12Y = 1.65/4.2
#declare H_E12Z = 1.35/4.2
// #declare H_A12Y = 30*SIDE    //"joint 2", adjustable
#declare H_E22X = .7
#declare H_E22Y = 1.5/4.2
#declare H_E22Z = 1.2/4.2
// #declare H_A22Y = 45*SIDE    //"joint 3", adjustable
#declare H02E=
blob{ threshold H_D01
   cylinder{<H_E02X/-1.4,0,0><0,0,0>1,H_S01
      scale <1,H_E02Y/H_R01,H_E02Z/H_R01>*2
      rotate <0,H_A02Y,H_A02Z>
      translate <H_E02DX,H_E02DY,H_E02DZ>}

   cylinder{<H_E12X/-1.4,0,0><0,0,0>1,H_S01
      scale <1,H_E12Y/H_R01,H_E12Z/H_R01>*2
      rotate <0,H_A12Y,H_A02Z>
      translate <H_E02X*cos(radians(H_A02Z))*cos(radians(H_A02Y))*-2,
                 H_E02X*sin(radians(H_A02Z))*-2,
                 H_E02X*cos(radians(H_A02Z))*sin(radians(H_A02Y))*2>
      translate <H_E02DX,H_E02DY,H_E02DZ>}

    cylinder{<H_E22X/-1.4,0,0><0,0,0>1,H_S01
      scale <1,H_E22Y/H_R01,H_E22Z/H_R01>*2
      rotate <0,H_A22Y,H_A02Z>
      translate <H_E12X*cos(radians(H_A02Z))*cos(radians(H_A12Y))*-2,
                 H_E12X*sin(radians(H_A02Z))*-2,
                 H_E12X*cos(radians(H_A02Z))*sin(radians(H_A12Y))*2>
      translate <H_E02X*cos(radians(H_A02Z))*cos(radians(H_A02Y))*-2,
                 H_E02X*sin(radians(H_A02Z))*-2,
                 H_E02X*cos(radians(H_A02Z))*sin(radians(H_A02Y))*2>
      translate <H_E02DX,H_E02DY,H_E02DZ>
      }
   sturm
}

//middle finger, "external"
#declare H_E13X = 1.15
#declare H_E13Y = 1.67/4.2
#declare H_E13Z = 1.36/4.2
// #declare H_A13Y = 30*SIDE    //"joint 2", adjustable
#declare H_E23X = .7
#declare H_E23Y = 1.52/4.2
#declare H_E23Z = 1.21/4.2
// #declare H_A23Y = 45*SIDE    //"joint 3", adjustable
#declare H03E=
blob{ threshold H_D01
   cylinder{<H_E03X/-1.4,0,0><0,0,0>1,H_S01
      scale <1,H_E03Y/H_R01,H_E03Z/H_R01>*2
      rotate <0,H_A03Y,H_A03Z>
      translate <H_E03DX,H_E03DY,H_E03DZ>}

   cylinder{<H_E13X/-1.4,0,0><0,0,0>1,H_S01
      scale <1,H_E13Y/H_R01,H_E13Z/H_R01>*2
      rotate <0,H_A13Y,H_A03Z>
      translate <H_E03X*cos(radians(H_A03Z))*cos(radians(H_A03Y))*-2,
                 H_E03X*sin(radians(H_A03Z))*-2,
                 H_E03X*cos(radians(H_A03Z))*sin(radians(H_A03Y))*2>
      translate <H_E03DX,H_E03DY,H_E03DZ>}

    cylinder{<H_E23X/-1.4,0,0><0,0,0>1,H_S01
      scale <1,H_E23Y/H_R01,H_E23Z/H_R01>*2
      rotate <0,H_A23Y,H_A03Z>
      translate <H_E13X*cos(radians(H_A03Z))*cos(radians(H_A13Y))*-2,
                 H_E13X*sin(radians(H_A03Z))*-2,
                 H_E13X*cos(radians(H_A03Z))*sin(radians(H_A13Y))*2>
      translate <H_E03X*cos(radians(H_A03Z))*cos(radians(H_A03Y))*-2,
                 H_E03X*sin(radians(H_A03Z))*-2,
                 H_E03X*cos(radians(H_A03Z))*sin(radians(H_A03Y))*2>
      translate <H_E03DX,H_E03DY,H_E03DZ>
      }
   sturm
}

// 4th finger, "external"
#declare H_E14X = 1
#declare H_E14Y = 1.6/4.2
#declare H_E14Z = 1.3/4.2
// #declare H_A14Y = 30*SIDE    //"joint 2", adjustable
#declare H_E24X = .65
#declare H_E24Y = 1.45/4.2
#declare H_E24Z = 1.18/4.2
// #declare H_A24Y = 45*SIDE    //"joint 3", adjustable
#declare H04E=
blob{ threshold H_D01
   cylinder{<H_E04X/-1.4,0,0><0,0,0>1,H_S01
      scale <1,H_E04Y/H_R01,H_E04Z/H_R01>*2
      rotate <0,H_A04Y,H_A04Z>
      translate <H_E04DX,H_E04DY,H_E04DZ>}

   cylinder{<H_E14X/-1.4,0,0><0,0,0>1,H_S01
      scale <1,H_E14Y/H_R01,H_E14Z/H_R01>*2
      rotate <0,H_A14Y,H_A04Z>
      translate <H_E04X*cos(radians(H_A04Z))*cos(radians(H_A04Y))*-2,
                 H_E04X*sin(radians(H_A04Z))*-2,
                 H_E04X*cos(radians(H_A04Z))*sin(radians(H_A04Y))*2>
      translate <H_E04DX,H_E04DY,H_E04DZ>}

    cylinder{<H_E24X/-1.4,0,0><0,0,0>1,H_S01
      scale <1,H_E24Y/H_R01,H_E24Z/H_R01>*2
      rotate <0,H_A24Y,H_A04Z>
      translate <H_E14X*cos(radians(H_A04Z))*cos(radians(H_A14Y))*-2,
                 H_E14X*sin(radians(H_A04Z))*-2,
                 H_E14X*cos(radians(H_A04Z))*sin(radians(H_A14Y))*2>
      translate <H_E04X*cos(radians(H_A04Z))*cos(radians(H_A04Y))*-2,
                 H_E04X*sin(radians(H_A04Z))*-2,
                 H_E04X*cos(radians(H_A04Z))*sin(radians(H_A04Y))*2>
      translate <H_E04DX,H_E04DY,H_E04DZ>
      }
   sturm
}

//little finger, "external"
#declare H_E15X = .7
#declare H_E15Y = 1.43/4.2
#declare H_E15Z = 1.2/4.2
// #declare H_A15Y = 30*SIDE    //"joint 2", adjustable
#declare H_E25X = .7
#declare H_E25Y = 1.35/4.2
#declare H_E25Z = 1.1/4.2
// #declare H_A25Y = 45*SIDE    //"joint 3", adjustable
#declare H05E=
blob{ threshold H_D01
   cylinder{<H_E05X/-1.4,0,0><0,0,0>1,H_S01
      scale <1,H_E05Y/H_R01,H_E05Z/H_R01>*2
      rotate <0,H_A05Y,H_A05Z>
      translate <H_E05DX,H_E05DY,H_E05DZ>}

   cylinder{<H_E15X/-1.4,0,0><0,0,0>1,H_S01
      scale <1,H_E15Y/H_R01,H_E15Z/H_R01>*2
      rotate <0,H_A15Y,H_A05Z>
      translate <H_E05X*cos(radians(H_A05Z))*cos(radians(H_A05Y))*-2,
                 H_E05X*sin(radians(H_A05Z))*-2,
                 H_E05X*cos(radians(H_A05Z))*sin(radians(H_A05Y))*2>
      translate <H_E05DX,H_E05DY,H_E05DZ>}

    cylinder{<H_E25X/-1.4,0,0><0,0,0>1,H_S01
      scale <1,H_E25Y/H_R01,H_E25Z/H_R01>*2
      rotate <0,H_A25Y,H_A05Z>
      translate <H_E15X*cos(radians(H_A05Z))*cos(radians(H_A15Y))*-2,
                 H_E15X*sin(radians(H_A05Z))*-2,
                 H_E15X*cos(radians(H_A05Z))*sin(radians(H_A15Y))*2>
      translate <H_E05X*cos(radians(H_A05Z))*cos(radians(H_A05Y))*-2,
                 H_E05X*sin(radians(H_A05Z))*-2,
                 H_E05X*cos(radians(H_A05Z))*sin(radians(H_A05Y))*2>
      translate <H_E05DX,H_E05DY,H_E05DZ>
      }
   sturm
}
#declare HAND=
union{
   object{H01I}
   object{H01E}
   object{H02E}
   object{H03E}
   object{H04E}
   object{H05E}
rotate y*W_A00Y
// texture {TTEX}
}

// object{HAND scale 1/(2*1.3)}
