
// Persistence of Vision Ray Tracer Scene Description File
// File: .inc
// Vers: 3
// Desc: 1. Clock and 2. Lamp (c) N.B. 1997
// Date: 26.08.1997
// Auth: N.B.



#declare CLOCK_TEX01 =
texture{
   finish {
      ambient 0.25
      brilliance 4
      diffuse 0.5
      metallic
      specular 0.80
      roughness 1/60
      reflection 0.4
    }
   normal{wood .01 rotate y*-90 scale .1}
   pigment{color rgb <.9,.9,.9>}
}

#declare CLOCK_TEX02 =
texture{
   finish{
      diffuse .9
      ambient .4
      reflection .05
      phong 1
      phong_size 100
   }
   pigment{color rgb <1,1,1>}
}

#declare CLOCK_TEX03 =
texture{
   finish{
      diffuse .8
      ambient .2
      reflection .05
      phong .8
      phong_size 100
   }
   pigment{color rgb <.1,.1,.1>}
}

#declare O_CYL_R01=6
#declare O_CYL_T01=4
#declare I_CYL_R01=4
#declare I_CYL_D01=1.8
#declare C_CYL_R01=.4
#declare C_CYL_D01=.7
#declare T_CYL_D01=.2
#declare S_CYL_R01=20
#declare S_CYL_H01=1

#declare S_HND_R01=.05
#declare S_HND_L01=I_CYL_R01*2/3*1.8
#declare S_HND_D01=S_HND_L01*.25

#declare M_HND_R01=.2
#declare M_HND_R02=.07
#declare M_HND_L01=I_CYL_R01*2/3*1.8
#declare M_HND_D01=M_HND_L01*.1

#declare H_HND_R01=.3
#declare H_HND_R02=.07
#declare H_HND_L01=I_CYL_R01*2/3*1.3
#declare H_HND_D01=H_HND_L01*.1

#declare HOURS=2
#declare MINUTES=25
#declare SECONDS=42

//numbers
#declare NUMBERS=
union{
text{ttf "cyrvetic.ttf","1",-.1,0 scale 1.5 rotate y*90 translate<0,-1,.5>*1/1.5
   rotate x*30 translate y*I_CYL_R01 rotate x*-30}
text{ttf "cyrvetic.ttf","2",-.1,0 scale 1.5 rotate y*90 translate<0,-1,1>*1/1.5
   rotate x*60 translate y*I_CYL_R01 rotate x*-60}
text{ttf "cyrvetic.ttf","3",-.1,0 scale 1.5 rotate y*90 translate<0,-1,1>*1/1.5
   rotate x*90 translate y*I_CYL_R01 rotate x*-90}
text{ttf "cyrvetic.ttf","4",-.1,0 scale 1.5 rotate y*90 translate<0,-1,1>*1/1.5
   rotate x*120 translate y*I_CYL_R01 rotate x*-120}
text{ttf "cyrvetic.ttf","5",-.1,0 scale 1.5 rotate y*90 translate<0,-1,1>*1/1.5
   rotate x*150 translate y*I_CYL_R01 rotate x*-150}
text{ttf "cyrvetic.ttf","6",-.1,0 scale 1.5 rotate y*90 translate<0,-1,1>*1/1.5
   rotate x*180 translate y*I_CYL_R01 rotate x*-180}
text{ttf "cyrvetic.ttf","7",-.1,0 scale 1.5 rotate y*90 translate<0,-1,1>*1/1.5
   rotate x*210 translate y*I_CYL_R01 rotate x*-210}
text{ttf "cyrvetic.ttf","8",-.1,0 scale 1.5 rotate y*90 translate<0,-1,1>*1/1.5
   rotate x*240 translate y*I_CYL_R01 rotate x*-240}
text{ttf "cyrvetic.ttf","9",-.1,0 scale 1.5 rotate y*90 translate<0,-1,1>*1/1.5
   rotate x*270 translate y*I_CYL_R01 rotate x*-270}
text{ttf "cyrvetic.ttf","10",-.1,0 scale 1.5 rotate y*90 translate<0,-1,1.5>*1/1.5
   rotate x*300 translate y*I_CYL_R01 rotate x*-300}
text{ttf "cyrvetic.ttf","11",-.1,0 scale 1.5 rotate y*90 translate<0,-1,1.5>*1/1.5
   rotate x*330 translate y*I_CYL_R01 rotate x*-330}
text{ttf "cyrvetic.ttf","12",-.1,0 scale 1.5 rotate y*90 translate<0,-1,1.5>*1/1.5
   rotate x*0 translate y*I_CYL_R01 rotate x*0}
}
#declare CLOCK01=
union{
   difference{
      // superellipsoid{<.7,.2>... gives funny look; remove torus
      superellipsoid{<1,.2> rotate y*90 translate x*1 scale <O_CYL_T01,O_CYL_R01,O_CYL_R01>}
      superellipsoid{<1,.2>
         rotate y*90
         translate x*-1
         scale <I_CYL_R01*2/3,I_CYL_R01,I_CYL_R01>
         translate x*I_CYL_D01 texture{CLOCK_TEX02}
      }
     box{<O_CYL_T01*1.4,O_CYL_T01*-2,O_CYL_T01*-2><O_CYL_T01*2.2,O_CYL_T01*2,O_CYL_T01*2>}
   }
   cylinder{<C_CYL_D01,0,0><O_CYL_T01-.1,0,0>C_CYL_R01}
   sphere{<C_CYL_D01,0,0>C_CYL_R01}
   //torus{I_CYL_R01+T_CYL_D01,T_CYL_D01 rotate z*90}
   torus{I_CYL_R01,T_CYL_D01 rotate z*90 translate x*T_CYL_D01}

   //seconds
   cylinder{<0,0,0><0,S_HND_L01,0>S_HND_R01
      translate <I_CYL_D01*5/6,S_HND_D01*-1,0>
      rotate x*360/60*SECONDS*-1 texture{CLOCK_TEX03}}

   //minutes
   sphere{0,1 scale <M_HND_R02,M_HND_L01/2,M_HND_R01>
      translate y*M_HND_L01/4
      translate <I_CYL_D01*4/6,M_HND_D01/2*-1,0>
      rotate x*(360/60*MINUTES+360/(60*60)*SECONDS)*-1 texture{CLOCK_TEX03}}

   //hours
   sphere{0,1 scale <H_HND_R02,H_HND_L01/2,H_HND_R01>
      translate y*H_HND_L01/4
      translate <I_CYL_D01*3/6,H_HND_D01/2*-1,0>
      rotate x*(360/12*HOURS+360/(60*12)*MINUTES)*-1 texture{CLOCK_TEX03}}

   //numbers
   object{NUMBERS scale .65 translate x*(I_CYL_D01+.05) texture{CLOCK_TEX03}}

   difference{
      cylinder{<0,0,0><O_CYL_T01*1.4,0,0>S_CYL_R01 translate y*S_CYL_R01*-1}
      box{<-1,S_CYL_H01*-1,S_CYL_R01*-1.2><O_CYL_T01*1.5*1.2,S_CYL_R01*-2,S_CYL_R01*1.2>}
   scale <1,1,.85>
   translate y*O_CYL_R01*-1
   }
texture{CLOCK_TEX01}
translate y*(S_CYL_H01+O_CYL_R01)
}

//object{CLOCK01}

#declare L_COUNT = 140
#declare L_ANG00 = 92
#declare L_ANG0I = L_ANG00/(L_COUNT-1)
#declare L_ANG01 = 0
#declare LAMP_R00 = 48
#declare LAMP_R0Y = LAMP_R00
#declare LAMP_R0Z = LAMP_R00
#declare LAMP_R0K = .9985

#declare LAMP_R01 = 1.5
#declare LAMP_H01 = 7
#declare LAMP_R02 = .65
#declare LAMP_R03 = 3.5
#declare LAMP_T03 = .15
#declare LAMP_D03 = 1
#declare LAMP_AA3 = 35

#declare LAMP_XA3 = -20
#declare LAMP_YA3 = -5
#declare LAMP_ZA3 = 15

#declare LAMP01=
union{
    #while (L_COUNT>=0)
    sphere{0,LAMP_R02
       translate x*LAMP_R0Y
       rotate z*L_ANG01
       translate x*-LAMP_R00
       }
    #declare LAMP_R0Y = LAMP_R0Y*pow(LAMP_R0K,2)
    #declare L_ANG01 = L_ANG01 + L_ANG0I
    #declare L_COUNT=L_COUNT-1
    #end
    cylinder{<0,0,0><0,-LAMP_H01,0>LAMP_R01}
    sphere{0,LAMP_R01 scale <1,.7,1>}
    sphere{0,LAMP_R01 scale <1,.7,1> translate y*-LAMP_H01}
    sphere{0,LAMP_R01 translate x*LAMP_R0Y rotate z*L_ANG01 translate x*-LAMP_R00}
    union{
       difference{
           sphere{0,LAMP_R03 scale <1,2,1> translate y*LAMP_R03*2}
           sphere{0,(LAMP_R03-LAMP_T03) scale <1,2,1> translate y*LAMP_R03*2}
           box{<LAMP_R03*-2,0,LAMP_R03*-2><LAMP_R03*2,LAMP_R03*3,LAMP_R03*2>
                rotate z*LAMP_AA3
                translate y*(LAMP_R03+LAMP_D03)*2}
       }
       light_source{<0,0,0>
          color rgb <1,1,.9>
          fade_distance 30
          fade_power 2
          translate y*LAMP_R03*2
       }
    rotate <LAMP_XA3,LAMP_YA3, LAMP_ZA3>
    translate x*LAMP_R0Y rotate z*L_ANG01 translate x*-LAMP_R00}
texture{CLOCK_TEX01}
}

// object{LAMP01 rotate y*185}
