
// Persistence of Vision Ray Tracer Scene Description File
// File: .inc
// Vers: 3
// Desc: PC keyboard
// Date: 26.07.97
// Auth: N.B.
/*
background {color rgb <.9,.95,1>}
#include "metals.inc"
light_source{<90,140,110>*2.1
   color rgb <1,1,1>
   spotlight
   point_at <50,90,-90>
   radius 30
   falloff 60
   tightness 3

}

#declare PC_TEX01 =
texture{
   finish{
      ambient <1,0.97,.92>*.3
      diffuse .7
      phong .8
      phong_size 20
   }
   pigment{color rgb <1,1,1>}
}

#declare LED_TEX01 =
texture{
   pigment{color rgb <1.7,2,.1>}
}

#declare LED_TEX02 =
texture{
   pigment{color rgb <.8,.8,.8>}
}

#declare LED_TEX03 =
texture{
   pigment{color rgb <2,1.7,.1>}
}
camera{
location <60,70,120>*20
//location <0,150,0>*2
//location <0,0,-150>*3
   angle 10
   look_at <0,0,0>
}
*/
#declare KEY_L01=12
#declare KEY_L02=12
#declare KEY_L03=10
#declare KEY_L11=18
#declare KEY_L12=18
#declare KEY_D01=KEY_L11+1

#declare KEY01=
difference{
   superellipsoid {<0.2, 2.0> rotate x*90 scale <KEY_L11*.5,KEY_L03*3,KEY_L12*.5>}
   box{<KEY_L11*-.5,KEY_L03,KEY_L12*-.5><KEY_L11*.5,KEY_L03*4,KEY_L12*.5>}
   box{<KEY_L11*-.5,0,KEY_L12*-.5><KEY_L11*.5,KEY_L03*-4,KEY_L12*.5>}
texture{PC_TEX01}}

#declare KEYa1=
union{
   object {KEY01}
   object {KEY01 translate x*KEY_L11/2}
}

#declare KEYb1=
union{
   object {KEY01}
   object {KEY01 translate x*4}
}

#declare KEYc1=
union{
   object {KEYa1}
   difference{
      object {KEY01}
      box{<KEY_L11*-.5,KEY_L03-5,KEY_L12*-.5><KEY_L11*.5,KEY_L03*4,KEY_L12*.5>}
      translate x*(33-KEY_L11-1)

   }
   texture{PC_TEX01}
}

#declare KEYd1=
union{
   object {KEY01}
   object {KEY01 translate x*(KEY_L11+1)/2}
   object {KEY01 translate x*(KEY_L11+1)}
}

#declare KEYe1=
union{
   object {KEYa1}
   object {KEYb1 translate x*(KEY_L11*1.5+1)}
   object {KEY01 translate x*(KEY_L11+1)}
}

#declare KEYf1=
union{
   object {KEYa1}
   object {KEYb1 translate <(KEY_L11*1.5-KEY_L11-4),0,KEY_D01*-.5>}
   object {KEYb1 translate <(KEY_L11*1.5-KEY_L11-4),0,KEY_D01*-1>}
}

#declare KEY_N01=11
#declare KEYg1=
union{
#while (KEY_N01>=0)
   object {KEY01 translate x*(KEY_N01*108/11)}
   #declare KEY_N01=KEY_N01-1
#end
}


#declare KEY_N01=12
#declare KEYS13=
union{
#while (KEY_N01>=0)
   object {KEY01 translate x*(KEY_N01*KEY_D01)}
   #declare KEY_N01=KEY_N01-1
#end
}

#declare KEY_N01=11
#declare KEYS12=
union{
#while (KEY_N01>=0)
   object {KEY01 translate x*(KEY_N01*KEY_D01)}
   #declare KEY_N01=KEY_N01-1
#end
}

#declare KEY_N01=10
#declare KEYS11=
union{
#while (KEY_N01>=0)
   object {KEY01 translate x*(KEY_N01*KEY_D01)}
   #declare KEY_N01=KEY_N01-1
#end
}

#declare KEY_N01=3
#declare KEYS04=
union{
#while (KEY_N01>=0)
   object {KEY01 translate x*(KEY_N01*KEY_D01)}
   #declare KEY_N01=KEY_N01-1
#end
}

#declare KEY_N01=2
#declare KEYS03=
union{
#while (KEY_N01>=0)
   object {KEY01 translate x*(KEY_N01*KEY_D01)}
   #declare KEY_N01=KEY_N01-1
#end
}
#declare KEYB01=
union{
//row00
   object {KEY01 translate<0,0,30>}
   object {KEYS04 translate <KEY_D01*2,0,30>}
   object {KEYS04 translate <KEY_D01*6.5,0,30>}
   object {KEYS04 translate <KEY_D01*11,0,30>}
   object {KEYS03 translate <KEY_D01*15.5,0,30>}
//row01
   object {KEYS13}
   object {KEYd1 translate <KEY_D01*13,0,0>}
   object {KEYS03 translate <KEY_D01*15.5,0,0>}
   object {KEYS04 translate <KEY_D01*19,0,0>}
//row02
   object{KEYa1 translate <0,0,KEY_D01*-1>}
   object {KEYS12 translate <KEY_L11*1.5+1,0,KEY_D01*-1>}
   object{KEYf1 translate <KEY_D01*14-KEY_L11/2-1,0,KEY_D01*-1>}
   object {KEYS03 translate <KEY_D01*15.5,0,KEY_D01*-1>}
   object {KEYS03 translate <KEY_D01*19,0,KEY_D01*-1>}
   object {KEYd1 rotate y*90 translate <KEY_D01*22,0,KEY_D01*-1>}
//row03
   object {KEYc1 translate <0,0,KEY_D01*-2>}
   object {KEYS12 translate <33,0,KEY_D01*-2>}
   object {KEYS03 translate <KEY_D01*19,0,KEY_D01*-2>}
//row04
   object{KEYb1 translate <0,0,KEY_D01*-3>}
   object {KEYS11 translate <KEY_L11+5,0,KEY_D01*-3>}
   object {KEYe1 translate <KEY_L11+6+KEY_D01*11,0,KEY_D01*-3>}
   object {KEY01 translate <KEY_D01*16.5,0,KEY_D01*-3>}
   object {KEYS03 translate <KEY_D01*19,0,KEY_D01*-3>}
   object {KEYd1 rotate y*90 translate <KEY_D01*22,0,KEY_D01*-3>}
//row05
   object{KEYa1 translate <0,0,KEY_D01*-4>}
   object{KEYb1 translate <KEY_L11*1.5+1,0,KEY_D01*-4>}
   object{KEYb1 translate <KEY_L11*1.5+1+KEY_L11+5,0,KEY_D01*-4>}

   object{KEYg1 translate <KEY_L11*1.5+1+KEY_L11*2+10,0,KEY_D01*-4>}

   object{KEYa1 translate <KEY_D01*14-KEY_L11/2-1,0,KEY_D01*-4>}
   object{KEYb1 translate <KEY_D01*14-KEY_L11*1.5-6,0,KEY_D01*-4>}
   object{KEYb1 translate <KEY_D01*14-KEY_L11*1.5-KEY_L11-11,0,KEY_D01*-4>}
   object{KEYb1 translate <KEY_D01*14-KEY_L11*1.5-KEY_L11*2-16,0,KEY_D01*-4>}

   object {KEYS03 translate <KEY_D01*15.5,0,KEY_D01*-4>}
   object {KEYd1 translate <KEY_D01*19,0,KEY_D01*-4>}
   object {KEY01 translate <KEY_D01*21,0,KEY_D01*-4>}
//led
   box{<0,0,0><5,.5,-3> translate<357,0,25> texture{LED_TEX01}}
   box{<0,0,0><5,.5,-3> translate<357+24,0,25> texture{LED_TEX02}}
   box{<0,0,0><5,.5,-3> translate<357+48,0,25> texture{LED_TEX02}}
}

#declare KEYB02=
difference{
   union{
      cylinder{<0,0,0><457,0,0>10}
      cylinder{<0,0,-150><457,0,-150>10}
      sphere{0,10 scale <.4,1,1>}
      sphere{0,10 scale <.4,1,1> translate<457,0,0>}
      sphere{0,10 scale <.4,1,1> translate<0,0,-150>}
      sphere{0,10 scale <.4,1,1> translate<457,0,-150>}
      cylinder{<0,0,0><0,0,-150>10 scale <.4,1,1>}
      cylinder{<0,0,0><0,0,-150>10 scale <.4,1,1> translate<457,0,0>}
      box{<0,-10,0><457,10,-150>}
   }
box{<-10,-10,10>*1.2<457,0,-150>*1.2}
box{<-10,5,-10><10,15,10> translate<20,0,-30>}
box{<-10,5,-10><4*19+1-10,15,10> translate<2*19+20,0,-30>}
box{<-10,5,-10><4*19+1-10,15,10> translate<6.5*19+20,0,-30>}
box{<-10,5,-10><4*19+1-10,15,10> translate<11*19+20,0,-30>}
box{<-10,5,-10><3*19+1-10,15,10> translate<15.5*19+20,0,-30>}
box{<-10,5,(2*19+1-10)*-1><3*19+1-10,15,10> translate<15.5*19+20,0,-60>}
box{<-10,5,(5*19+1-10)*-1><4*19+1-10,15,10> translate<19*19+20,0,-60>}
box{<-10,5,-10><11,15,10> translate<16.5*19+20,0,-1*(60+3*19)>}
box{<-10,5,-10><3*19+1-10,15,10> translate<15.5*19+20,0,-1*(60+4*19)>}
box{<-10,5,(5*19+1-10)*-1><15*19+1-10,15,10> translate<20,0,-60>}
   translate <-20,-10,60>
   texture{PC_TEX01}
}

// keyboard wire

#declare XX1=0
#declare YY1=0
#declare ZZ1=0
#declare R01=.2
#declare NW01=2
#declare NS01=200
#declare TL01=10
#declare dX=2*pi/NS01
#declare MM0=0
#declare KOUNT0=NS01*NW01
#declare KOUNT1=KOUNT0

#declare KEYB_WIRE01=
union{
#while (KOUNT1>0)
   #declare YY1=sin(XX1)*MM0
   #declare ZZ1=cos(XX1)*MM0
   sphere{0,R01 translate <XX1*5,YY1,ZZ1>}
   #declare XX2=XX1+dX
   #declare MM0=sin(XX2/(NW01*2))*4
   #declare YY2=sin(XX2)*MM0
   #declare ZZ2=cos(XX2)*MM0
   sphere{0,R01 translate <XX2*5,YY2,ZZ2>}
   cylinder{<XX1*5,YY1,ZZ1><XX2*5,YY2,ZZ2>,R01}
   #declare XX1=XX2
   #declare KOUNT1=KOUNT1-1
#end
texture{PC_TEX01}
}

#declare KEYB00=
union{
    object {KEYB01 translate <(457/2-20)*-1,0,75-60> rotate x*-2}
    object {KEYB02 translate <(457/2-20)*-1,0,75-60> rotate x*-2}
    object{KEYB_WIRE01 scale 10 rotate y*-90 translate z*75}
}

//object {KEYB00}

//object{KEYB_WIRE01 scale 10 rotate y*-90 translate z*90}
