
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: A Kind of Magic
// Date: 26.08.1997
// Auth: N.B.

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "woods.inc"
#include "metals.inc"

global_settings { max_intersections 256 }

background {color rgb <.9,.95,1>*.1}

// foreground light source

light_source{<90,140,-110>*2.1
   color rgb <1,1,1>
   spotlight
   point_at <50,90,-90>
   radius 15
   falloff 40
   tightness 5
   fade_distance 300
   fade_power 1
}

// background light source

light_source{<120,300,700>
   color rgb <1,1,.9>
   spotlight
   point_at <245,0,700>
   radius 30
   falloff 120
   tightness 1
   fade_distance 300
   fade_power 1
}

camera{
location <60,70,-120>*2.5
   angle 45
   look_at <65,50,0>
}


// walls

#declare TEX =
texture{
   finish{
      diffuse .9
      ambient .2
      reflection .05
      phong .7
      phong_size 100
   }
   normal {bumps .05 }
   pigment{color rgb <.9,.95,1>}
}

// computer texture

#declare PC_TEX01 =
texture{
   finish{
      ambient <1,0.97,.92>*.3
      diffuse .7
      phong .8
      phong_size 20
   }
   pigment{color rgb <1,1,1>}
}

// led texture (emitting green light)

#declare LED_TEX01 =
texture{
   finish{
      ambient .9
      diffuse .9
      phong .8
      phong_size 40
   }
   pigment{color rgb <1.7,2,.1>}
}

// led texture (closed)

#declare LED_TEX02 =
texture{
   finish{
      ambient .2
      diffuse .9
      phong .8
      phong_size 40
   }
   pigment{color rgb <.7,.7,.7>}
}

// led texture (emitting yellow light)

#declare LED_TEX03 =
texture{LED_TEX01
   pigment{color rgb <2,1.7,.1>}
}

// wooden floor (pine) texture

#declare M_FLOOR_WOOD =
color_map {
    [0.00 color rgb <1.0, 0.60, 0.35>*.98]
    [0.40 color rgb <1.0, 0.7, 0.45> ]
    [0.60 color rgb <1.0, 0.7, 0.45> ]
    [1.00 color rgb <1.0, 0.60, 0.35>*.98]
}

#declare P_FLOOR_WOOD =
pigment {
    wood
    scale <0.075, 0.075, 1>
    turbulence 0.07
    omega 0.7
    lambda 2.5
    color_map { M_Wood19A }
    rotate x*4
}

#declare T_Wood19 =
    texture {pigment{ P_FLOOR_WOOD color_map {M_FLOOR_WOOD}}}

#declare FLOOR_TEX=
texture{T_Wood19 rotate <5,-5,0>
   finish{
      diffuse .7
      ambient <1.0, 0.7, 0.45>*.2
      reflection .05
      phong .7
      phong_size 100
      }
  normal {wrinkles .02  scale <1,1,3>*.05}
}

// room:

#declare MROOM=
union{

// walls

   box{<-30,-5,400><-10,320,-320>}
   difference{
      box{<-30,-5,400><500,320,380>}
      box{<50,-10,410><160,250,370>}
   }
   box{<480,-5,400><500,320,-320>}
   box{<-30,-5,-300><500,320,-320>}

// floor

   #declare FLNO=20
   #declare FLOOR01=
   union{
      box{<-7.2,0,2000><7.2,-10,-1000>}
      cylinder{<-7.2,-1,2000><-7.2,-1,-1000>1}
      cylinder{<7.2,-1,2000><7.2,-1,-1000>1}
      scale<2,1,1>
   }
   box{<-10,0,400><-8,6,-320> texture {FLOOR_TEX scale 120}}
   box{<-10,0,378><50,6,380> texture {FLOOR_TEX scale 120}}
   box{<160,0,378><480,6,380> texture {FLOOR_TEX scale 120}}
   union{
   #while (FLNO>-10)
      object{FLOOR01
         translate x*30*FLNO
         texture {FLOOR_TEX rotate x*(35*FLNO) scale <90,1,150> translate z*200*FLNO}}
   #declare FLNO=FLNO-1
   #end
   }
   box{<-1000,320,2000><1000,330,-1000>}
texture{TEX}}

// room (walls + floor)

object{MROOM}

#include "m_keyb01.inc"
#include "m_table.inc"

// desk

object{M_TABLE}

// keyboard + wire

object {KEYB00 rotate y*-90 scale .1 translate <70+16,T_HI01-13,-70>}

// chair

#include "m_cl001.inc"
object {CL001 scale 1.55
   /* rotate x*10
   rotate z*8 */
   rotate y*-22
   translate <142,0,-60>
   texture{CL_TEX} normal {bumps 0.03 scale 10}
}

// map

#include "m_map01.inc"
object{MAP01 translate <40,92,-110>}

// pen02 (red and blue)
union{
   #declare PEN_ERR01=0
   #declare PEN_PIG01= pigment{color rgb <.9,.2,.25>}
   #declare PEN_PIG02= pigment{color rgb <.9,.2,.25>}
   #declare PEN_RAD01=0.8/2
   #declare PEN_WID01=8
   #include "m_pen01.inc"
   object{PEN01}
   #declare PEN_ERR01=0
   #declare PEN_PIG01= pigment{color rgb <.25,.2,.7>}
   #declare PEN_PIG02= pigment{color rgb <.25,.2,.7>}
   #declare PEN_RAD01=0.8/2
   #declare PEN_WID01=6
   #include "m_pen01.inc"
   object{PEN01 rotate x*180 translate <0,PEN_RAD01*2,(8+6)>}
   rotate y*161 translate <28,92,-125>
}

//cabinet X 3

#declare L_DOOR01=52
#declare R_DOOR01=-13
#include"m_she01.inc"
object{SHE01 rotate y*-90 translate <32,0,60>}
#declare L_DOOR01=0
#declare R_DOOR01=0
#include"m_she01.inc"
object{SHE01 rotate y*-90 translate <32,0,60+81>}
#declare L_DOOR01=0
#declare R_DOOR01=0
#include"m_she01.inc"
object{SHE01 rotate y*-90 translate <32,0,60+81*2>}

// computer + monitor
// mouse + wire + mouse pad

#include "m_pomp01.inc"
object{POMP00 rotate y*-90 translate <20,92.5,-70>}
object{MOUSE00 rotate y*-90 translate <70,92.5,-30>}

// clock
// lamp

#include "m_kello01.inc"
object{CLOCK01 rotate y*210 translate <23,92,-129>}
object{LAMP01 rotate y*182 translate <-LAMP_R01,92.5,-91>}

//picture on the wall
//garbage basket

#include "m_misc.inc"
object{POV_ART rotate y*-90 translate <-9.5,140,-78>}
object{GARB translate <30,0,-10>}

// skin texture

#declare SK_TEX =
texture{
   finish{
   diffuse .9
      ambient <1,.8,.6>*.3
      phong 0.1
      phong_size 10
   }
   pigment{color rgb <1,.8,.6>}
}

// dress fabric texture

#declare DD_TEX =
texture{
   finish{
   diffuse .9
      ambient .3
      phong 0.01
      phong_size 2
   }
   //normal{bumps .1 scale <.5,1,.5>}
   pigment{color rgbt <1,1,1,.2>}
}

//female figure

                                       // legal values are:
#declare E_R00=2                       // 1: ear_ring
#declare W_R00=2                       // wrist_ring -1: right, 1: left
#declare W_RTEX=texture{T_Chrome_4D}
#declare E_RTEX=texture{T_Chrome_4D}
#declare HAIR=1                        // 1: object{HAIR01}, 2:object{HAIR02}
#include "fem01.pov"
object{FEM01 rotate y*-102 translate y*12.0 scale 4  translate <107,0,420>
}

//tentacles

#include "monster.inc"
object{MONSTER}


//chest of drawers

#declare lNRO01=6 //4=5; number of drawers, 5 in real life
#declare lAUK01=2 // open a drawer; all closed=-1
#include "latt01.inc"
object{LAT00 scale .1 rotate y*35 translate <185,0,230>}

//male figure

#declare SH_TEX=texture{DD_TEX pigment{color rgb <1,1,1>}}
#include "male01.pov"
object{MALE01
              //rotate y*(-102+60)
              rotate z*-25
              rotate y*-22
              translate y*6.0
              scale 3.9
              translate <142,-7,-60>}

// light source imitating light from the computer screen

light_source{<55+50,130,-70>
   color rgb <0.3,0.6,1>
   spotlight
   point_at <142,123,-60>
   radius 10
   falloff 30
   tightness 10
   fade_distance 150
   fade_power 2
}

// orange shoes

#declare SIDE=1
#include "xxx01.inc"
object {XXX01 scale .97
   rotate y*15
   translate <62,0,-60>
}

#declare SIDE=-1
#include "xxx01.inc"
object {XXX01 scale .97
   rotate y*35
   translate <59,0,-79>
}
