// Persistence of Vision Ray Tracer Scene Description File
// File: .inc
// Vers: 3
// Desc: SHIRT
// Date: 26.08.1997
// Auth: N.B.

#declare DS_TEX01 =
texture{
   finish{
      diffuse .9
      brilliance 0.5
      ambient .3
      phong 0.01
      phong_size 2
   }
   normal{bumps .2 scale <.7,1,.7>}
   //pigment{color rgbt <1,1,1,.2>}
   //pigment{color rgb <.3,.4,1>*.8}
   pigment{color rgb <.32,.45,.7>}
   //pigment{color rgbt <.1,.1,.15,.2>}
}

#declare DS_TEX02 =
texture{DS_TEX01
   pigment{image_map {
      gif "fract002.gif"
      //map_type 2
      once
      }
   translate<-.5,-.5,>
   scale <80,60,1>*.1
   rotate z*90
   translate <0,16,0>
   rotate y*-90
   //translate y*-5
   }
}


#declare SIDE = 1 // 1=left, -1=right, don't even try other values
#declare ZCENT = 3.05*SIDE

#declare HR_02 = .64
#declare HS_02 = 3
#declare HD_02 = HS_02*pow((1-pow(HR_02,2)),2)
#declare LB_01 = 11.2
#declare LAX_01 = 7
#declare LAX_02 = 2
#declare LAZ_01 = 2
#declare LB_02 = 11

#declare ZARM01 = -1.4
#declare YARM01 = 11.05
#declare XARM01 = 0
// #declare AAX_01 = 2
// #declare AAZ_01 = 5
#declare AB_01 = 7
#declare AB_02 = 6
// #declare AAZ_02 = 20
// #declare AAY_02 = 15



#declare SHIRT=
difference{
blob{ threshold HD_02

cylinder{<0,0,0><0,LB_01,0>,1,HS_02
     translate z*ZCENT
     rotate z*-5}

sphere{0,1,HS_02
     scale <1.3/HR_02,2.6/HR_02,1.5/HR_02>
     translate <-.5,.6,ZCENT>
     rotate z*10}

sphere{0,1,HS_02
     scale <1.5/HR_02,1.8/HR_02,1.4/HR_02>
     translate <-.8,.1,ZCENT>
     rotate z*10}
//
sphere{0,1,HS_02
     scale <2.4/HR_02,2.5/HR_02,3/HR_02>*1.05
     translate <-.28,1.4,ZCENT>
     rotate z*10}

cylinder{<0,0,0><0,10,0>,1,HS_02
     scale <1.5/HR_02,1,2.7/HR_02>*1.05
     translate <-.7,2,ZCENT>
     rotate z*-5}

cylinder{<0,0,0><0,.6,0>,1,HS_02
     scale <2.5/HR_02,3.2/HR_02,2.65/HR_02>*1.05
     rotate <-15*SIDE,0*SIDE,-12>
     translate <-.8,6.4,ZCENT/1.6>}

cylinder{<0,0,0><0,.4,0>,1,HS_02
     scale <1.3/HR_02,3.4/HR_02,2.45/HR_02>*1.05
     rotate <15*SIDE,0*SIDE,-12>
     translate <-.6,7.5,(3.05+(3.05-3.05/1.6))*SIDE>}

sphere{0,1,HS_02*.5
     scale <1.6/HR_02,1.55/HR_02,2/HR_02>*1.05
     rotate <-5*SIDE,-5*SIDE,-30>
     translate <-1.9,9,ZCENT/2.2>}


cylinder{<0,0,-1.25*SIDE><0,0,0>,1,HS_02
     scale <.65/HR_02,.5/HR_02,1/HR_02>*1.05
     rotate <5*SIDE,-15*SIDE,0>
     translate <-1.4,11.83,2.05*SIDE>}

sphere{0,1,HS_02
     scale <2/HR_02,2.8*1.2/HR_02,3.5/HR_02>*1.05
     rotate <0*SIDE,0*SIDE,-20>
     translate <-.6,10.3,ZCENT>}
//////
cylinder{<0,0,-.7*SIDE><0,0,0>,1,HS_02*.8
     scale <.55/HR_02,1.6/HR_02,.7/HR_02>*1.05
     rotate y*22*SIDE
     rotate x*-20*SIDE
     translate <1.65,9.5,.85*SIDE>}

sphere{0,1,HS_02*-.5
     scale <1/HR_02,1/HR_02,2.5/HR_02>*1.2
     rotate x*-5*SIDE
     translate <.4,12.5,ZCENT>}

sphere{0,1,HS_02
     scale <1.5/HR_02,1.4/HR_02,1.8/HR_02>*1.3*1.05
     rotate x*-10*SIDE
     translate <XARM01,YARM01,ZARM01*SIDE>}

cylinder{<5,0,0><-5,0,0>,1,-20
     scale <1,4.5/HR_02,2.2/HR_02>
     rotate x*-8
     translate <0,12,(ZCENT-8)>}


#declare SIDE=SIDE*-1

cylinder{<0,0,0><0,.6,0>,1,HS_02
     scale <2.5/HR_02,3.2/HR_02,2.65/HR_02>*1.05
     rotate <-15*SIDE,0*SIDE,-12>
     translate <-.8,6.4,ZCENT/1.6*-1>
     translate z*ZCENT*2}

cylinder{<0,0,0><0,.4,0>,1,HS_02
     scale <1.3/HR_02,3.4/HR_02,2.45/HR_02>*1.05
     rotate <15*SIDE,0*SIDE,-12>
     translate <-.6,7.5,(3.05+(3.05-3.05/1.6))*SIDE>
     translate z*ZCENT*2}

sphere{0,1,HS_02*.5
     scale <1.6/HR_02,1.55/HR_02,2/HR_02>*1.05
     rotate <-5*SIDE,-5*SIDE,-30>
     translate <-1.9,9,ZCENT/2.2*-1>
     translate z*ZCENT*2}

cylinder{<0,0,-1.25*SIDE><0,0,0>,1,HS_02
     scale <.65/HR_02,.5/HR_02,1/HR_02>*1.05
     rotate <5*SIDE,-15*SIDE,0>
     translate <-1.4,11.83,2.05*SIDE>
     translate z*ZCENT*2}

cylinder{<0,0,-.7*SIDE><0,0,0>,1,HS_02*.8
     scale <.55/HR_02,1.6/HR_02,.7/HR_02>*1.05
     rotate y*22*SIDE
     rotate x*-20*SIDE
     translate <1.65,9.5,.85*SIDE>
     translate z*ZCENT*2}

sphere{0,1,HS_02
     scale <1.5/HR_02,1.4/HR_02,1.8/HR_02>*1.3*1.05
     rotate x*-10*SIDE
     translate <XARM01,YARM01,ZARM01*SIDE>
     translate z*ZCENT*2}

sphere{0,1,-6
   scale <10,1,10>
   translate y*-3}

cylinder{<5,0,0><-5,0,0>,1,-20
     scale <1,1/HR_02,2/HR_02>
     translate <0,14,ZCENT>}

cylinder{<5,0,0><-5,0,0>,1,-20
     scale <1,4.5/HR_02,2.2/HR_02>
     rotate x*8
     translate <0,12,(ZCENT+8)>}

rotate z*BOW_ANG
sturm
translate z*ZCENT*-1
}
box{<-10,0,-10><10,-10,10>rotate z*BOW_ANG translate y*1.8}
translate y*10
texture{DS_TEX01}
texture{DS_TEX02}
}
