// Sample file:  A good starting point for images.

#declare tine =
difference {
    difference {
        sphere {
            <0, 0, 0>
            1.02
        }
        sphere {
            <0, 0, 0>
            1
        }
    }
    box {
        <0.05, -1.1, -1.1>
        <1.1, 1.1, 1.1>
    }
    box {
        <-0.05, -1.1, -1.1>
        <-1.1, 1.1, 1.1>
    }
    box {
        <-1.1, 0, -1.1>
        <1.1, 1.1, 1.1>
    }
    box {
        <-1.1, -1.1, 0>
        <1.1, 1.1, 1.1>
    }
}

#declare anchor =
difference {
    difference {
        intersection {
            cone {
              <0, -0.25, -1.02>
              0.2
              <0, 0.25, -1.02>
              0
            }
            sphere {
                <0, 0, 0>
                1.02
            }
        }
        sphere {
            <0, 0, 0>
            1
        }
    }
    box {
        <-0.3, -0.3, -1.05>
        <0.3, 0.3, -0.95>
        rotate<0, 0, 45>
        translate<0, -0.5, 0>
    }
}

#declare rightfork =
intersection {
    difference {
        difference {
            sphere {
                <0, 0, 0>
                1.02
            }
            sphere {
                <0, 0, 0>
                1
            }
        }
        box {
            <0, -1.1, -1.1>
            <-1.1, 1.1, 1.1>
        }
        box {
            <-1.1, -1.1, 0>
            <1.1, 1.1, 1.1>
        }
        box {
            <-1.1, 0, -1.1>
            <1.1, 1.1, 1.1>
        }
        box {
            <-1.1, -1.1, 0>
            <1.1, 1.1, 1.1>
            rotate <0, 45, 0>
        }
        cylinder {
            <0, 0, -1.1>
            <0, 0, 1.1>
            0.5
        }
    }
    cylinder {
        <0, 0, -1.1>
        <0, 0, 1.1>
        0.6
    }
}

#declare rightbar =
intersection {
    difference {
        difference {
            sphere {
                <0, 0, 0>
                1.02
            }
            sphere {
                <0, 0, 0>
                1
            }
        }
        box {
            <0, -1.1, -1.1>
            <-1.1, 1.1, 1.1>
        }
        box {
            <-1.1, -1.1, 0>
            <1.1, 1.1, 1.1>
        }
        box {
            <-1.1, 0, -1.1>
            <1.1, 1.1, 1.1>
        }
        box {
            <-1.1, -1.1, 0>
            <1.1, 1.1, 1.1>
            rotate <0, 45, 0>
        }
        cylinder {
            <0, 0, -1.1>
            <0, 0, 1.1>
            0.5
        }
    }
    cylinder {
        <0, 0.1, 0>
        <0, -0.1, 0>
        1.1
    }
}

#declare leftfork =
intersection {
    difference {
        difference {
            sphere {
                <0, 0, 0>
                1.02
            }
            sphere {
                <0, 0, 0>
                1
            }
        }
        box {
            <0, -1.1, -1.1>
            <1.1, 1.1, 1.1>
        }
        box {
            <-1.1, -1.1, 0>
            <1.1, 1.1, 1.1>
        }
        box {
            <-1.1, 0, -1.1>
            <1.1, 1.1, 1.1>
        }
        box {
            <-1.1, -1.1, 0>
            <1.1, 1.1, 1.1>
            rotate <0, -45, 0>
        }
        cylinder {
            <0, 0, -1.1>
            <0, 0, 1.1>
            0.5
        }
    }
    cylinder {
        <0, 0, -1.1>
        <0, 0, 1.1>
        0.6
    }
}

#declare leftbar =
intersection {
    difference {
        difference {
            sphere {
                <0, 0, 0>
                1.02
            }
            sphere {
                <0, 0, 0>
                1
            }
        }
        box {
            <0, -1.1, -1.1>
            <1.1, 1.1, 1.1>
        }
        box {
            <-1.1, -1.1, 0>
            <1.1, 1.1, 1.1>
        }
        box {
            <-1.1, 0, -1.1>
            <1.1, 1.1, 1.1>
        }
        box {
            <-1.1, -1.1, 0>
            <1.1, 1.1, 1.1>
            rotate <0, -45, 0>
        }
        cylinder {
            <0, 0, -1.1>
            <0, 0, 1.1>
            0.5
        }
    }
    cylinder {
        <0, 0.1, 0>
        <0, -0.1, 0>
        1.1
    }
}

#declare hook =
union {
    intersection {
        torus {
            0.1
            0.005
        }
        box {
            <0, -1, 0>
            <-1, 1, -1>
        }
        rotate <0, 0, 90>
        scale<3, 1, 1>
        translate <0, 0, -1.02>
    }
    torus {
        0.05
        0.013
        rotate<90 + (90 - 60.435), 0, 0>
        translate <0, -0.12, -1.08>
    }
}

#declare LaticeArm =
object {
    union {
        object {
            tine
        }
        object {
            anchor
        }
        object {
            rightfork
        }
        object {
            rightbar
        }
        object {
            leftfork
        }
        object {
            leftbar
        }
        object {
            hook
        }
    }
    texture {
        T_Gold_5A
        normal { bumps 0.5 scale 0.05 }
    }
}

#declare Latice =
union {
    object {
        LaticeArm
    }
    object {
        LaticeArm
        rotate <0, 90, 0>
    }
    object {
        LaticeArm
        rotate <0, 180, 0>
    }
    object {
        LaticeArm
        rotate <0, 270, 0>
    }
}
