//  Persistance of Vision Raytracer V2.2
//  World definition file.
//
//  Contains 4 lights, 20 textures and 51 primitives.
//
//  This file was generated for POV-Ray V2.2 by
//  MORAY.EXE V2.02.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 08/23/1997    (23.08.1997)
//

#max_trace_level 5

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray V2.0 exports for POV-Ray.
//





camera {  //  Camera StdCam
  location  <4.860, -9.680, 2.740>
  direction <0.0,     0.0,  2.1084>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <-0.869, -0.265, 2.947>
}


// My include for the flames of the torches

#include "feuer.inc"


// *******  L I G H T S *******
light_source {   // Light3
  <-2.300, -5.720, 3.230>
  color rgb <0.226, 0.226, 0.226>
}

light_source { // AreaL001
  <-2.590, 0.420, 14.460>
  color  rgb<0.735, 0.735, 0.735>
  area_light <2.580, 0.000, 0.000>, <0.000, 2.580, 0.000>, 3, 3
  adaptive 1
  jitter
}


light_source {   // Light2
  <-0.540, 9.560, 5.800>
  color rgb <0.508, 0.508, 0.508>
}

light_source {   // Light1
  <-9.500, 7.360, 5.790>
  color rgb <0.512, 0.512, 0.512>
}


// ********  TEXTURES  *******
//

#include "prophecy.inc"



// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******



#declare Rumpf = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.495146, 0.000000, 0.000000>, <-0.495146, -0.274092, 0.000000>, <-0.272330, -0.498350, 0.000000>, <0.000000, -0.498350, 0.000000>, 
      <-0.476549, 0.000000, 0.500000>, <-0.476549, -0.252165, 0.500000>, <-0.262102, -0.458482, 0.500000>, <0.000000, -0.458482, 0.500000>, 
      <-0.419133, 0.000000, 1.000000>, <-0.419133, -0.252165, 1.000000>, <-0.230523, -0.458482, 1.000000>, <0.000000, -0.458482, 1.000000>, 
      <-0.377071, 0.000000, 1.500000>, <-0.377071, -0.209492, 1.500000>, <-0.207389, -0.380894, 1.500000>, <0.000000, -0.380894, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.498350, 0.000000>, <0.272330, -0.498350, 0.000000>, <0.495146, -0.274092, 0.000000>, <0.495146, 0.000000, 0.000000>, 
      <0.000000, -0.458482, 0.500000>, <0.262102, -0.458482, 0.500000>, <0.476549, -0.252165, 0.500000>, <0.476549, 0.000000, 0.500000>, 
      <0.000000, -0.458482, 1.000000>, <0.230523, -0.458482, 1.000000>, <0.419133, -0.252165, 1.000000>, <0.419133, 0.000000, 1.000000>, 
      <0.000000, -0.380894, 1.500000>, <0.207389, -0.380894, 1.500000>, <0.377071, -0.209492, 1.500000>, <0.377071, 0.000000, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.495146, 0.000000, 0.000000>, <0.495146, 0.274092, 0.000000>, <0.272330, 0.498350, 0.000000>, <0.000000, 0.498350, 0.000000>, 
      <0.476549, 0.000000, 0.500000>, <0.476549, 0.252165, 0.500000>, <0.262102, 0.458482, 0.500000>, <0.000000, 0.458482, 0.500000>, 
      <0.419133, 0.000000, 1.000000>, <0.419133, 0.252165, 1.000000>, <0.230523, 0.458482, 1.000000>, <0.000000, 0.458482, 1.000000>, 
      <0.377071, 0.000000, 1.500000>, <0.377071, 0.209492, 1.500000>, <0.207389, 0.380894, 1.500000>, <0.000000, 0.380894, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.498350, 0.000000>, <-0.272330, 0.498350, 0.000000>, <-0.495146, 0.274092, 0.000000>, <-0.495146, 0.000000, 0.000000>, 
      <0.000000, 0.458482, 0.500000>, <-0.262102, 0.458482, 0.500000>, <-0.476549, 0.252165, 0.500000>, <-0.476549, 0.000000, 0.500000>, 
      <0.000000, 0.458482, 1.000000>, <-0.230523, 0.458482, 1.000000>, <-0.419133, 0.252165, 1.000000>, <-0.419133, 0.000000, 1.000000>, 
      <0.000000, 0.380894, 1.500000>, <-0.207389, 0.380894, 1.500000>, <-0.377071, 0.209492, 1.500000>, <-0.377071, 0.000000, 1.500000>
    }
  }
  scale 0.404931
  rotate <0.008507, 0.114738, 0.000686>
  translate  <-1.556578, 0.899764, 0.225275>
}
#declare Korken = union {
  object { Rumpf }
  disc { // KorkMGr
    <0,0,0>, <0,0,1>, 1.0
    scale 0.203239
    translate  <-1.560296, 0.900202, 0.232077>
  }
  disc { // KorkMKl
    <0,0,0>, <0,0,1>, 1.0
    scale 0.153871
    translate  <-1.557435, 0.900202, 0.83208>
  }
  texture {
    Cork2
  }
  scale 0.27
  rotate <180.0, 85.699875, -128.53334>
  translate  <-2.79, 2.61, 0.88>
}
#declare Weinglas = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, 0.000000, 0.000000>, <-1.000000, -0.550000, 0.000000>, <-0.550000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-0.130265, 0.000000, 0.253896>, <-0.130265, -0.113381, 0.253896>, <-0.071646, -0.206147, 0.253896>, <0.000000, -0.206147, 0.253896>, 
      <-0.209232, 0.000000, 1.267818>, <-0.209232, -0.115078, 1.267818>, <-0.115078, -0.209232, 1.267818>, <0.000000, -0.209232, 1.267818>, 
      <-0.168908, 0.000000, 1.581761>, <-0.168908, -0.092899, 1.581761>, <-0.092899, -0.168908, 1.581761>, <0.000000, -0.168908, 1.581761>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -1.000000, 0.000000>, <0.550000, -1.000000, 0.000000>, <1.000000, -0.550000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
      <0.000000, -0.206147, 0.253896>, <0.071646, -0.206147, 0.253896>, <0.130265, -0.113381, 0.253896>, <0.130265, 0.000000, 0.253896>, 
      <0.000000, -0.209232, 1.267818>, <0.115078, -0.209232, 1.267818>, <0.209232, -0.115078, 1.267818>, <0.209232, 0.000000, 1.267818>, 
      <0.000000, -0.168908, 1.581761>, <0.092899, -0.168908, 1.581761>, <0.168908, -0.092899, 1.581761>, <0.168908, 0.000000, 1.581761>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, 0.000000, 0.000000>, <1.000000, 0.550000, 0.000000>, <0.550000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, 
      <0.130265, 0.000000, 0.253896>, <0.130265, 0.113381, 0.253896>, <0.071646, 0.206147, 0.253896>, <0.000000, 0.206147, 0.253896>, 
      <0.209232, 0.000000, 1.267818>, <0.209232, 0.115078, 1.267818>, <0.115078, 0.209232, 1.267818>, <0.000000, 0.209232, 1.267818>, 
      <0.168908, 0.000000, 1.581761>, <0.168908, 0.092899, 1.581761>, <0.092899, 0.168908, 1.581761>, <0.000000, 0.168908, 1.581761>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 1.000000, 0.000000>, <-0.550000, 1.000000, 0.000000>, <-1.000000, 0.550000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
      <0.000000, 0.206147, 0.253896>, <-0.071646, 0.206147, 0.253896>, <-0.130265, 0.113381, 0.253896>, <-0.130265, 0.000000, 0.253896>, 
      <0.000000, 0.209232, 1.267818>, <-0.115078, 0.209232, 1.267818>, <-0.209232, 0.115078, 1.267818>, <-0.209232, 0.000000, 1.267818>, 
      <0.000000, 0.168908, 1.581761>, <-0.092899, 0.168908, 1.581761>, <-0.168908, 0.092899, 1.581761>, <-0.168908, 0.000000, 1.581761>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.168908, 0.000000, 1.581761>, <-0.168908, -0.092899, 1.581761>, <-0.092899, -0.168908, 1.581761>, <0.000000, -0.168908, 1.581761>, 
      <-0.128583, 0.000000, 1.895704>, <-0.128583, -0.070721, 1.895704>, <-0.070721, -0.128583, 1.895704>, <0.000000, -0.128583, 1.895704>, 
      <-0.977210, 0.000000, 2.336478>, <-0.977210, -0.537465, 2.336478>, <-0.537465, -0.977210, 2.336478>, <0.000000, -0.977210, 2.336478>, 
      <-0.988605, 0.000000, 2.918239>, <-0.988605, -0.543733, 2.918239>, <-0.543733, -0.988605, 2.918239>, <0.000000, -0.988605, 2.918239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.168908, 1.581761>, <0.092899, -0.168908, 1.581761>, <0.168908, -0.092899, 1.581761>, <0.168908, 0.000000, 1.581761>, 
      <0.000000, -0.128583, 1.895704>, <0.070721, -0.128583, 1.895704>, <0.128583, -0.070721, 1.895704>, <0.128583, 0.000000, 1.895704>, 
      <0.000000, -0.977210, 2.336478>, <0.537465, -0.977210, 2.336478>, <0.977210, -0.537465, 2.336478>, <0.977210, 0.000000, 2.336478>, 
      <0.000000, -0.988605, 2.918239>, <0.543733, -0.988605, 2.918239>, <0.988605, -0.543733, 2.918239>, <0.988605, 0.000000, 2.918239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.168908, 0.000000, 1.581761>, <0.168908, 0.092899, 1.581761>, <0.092899, 0.168908, 1.581761>, <0.000000, 0.168908, 1.581761>, 
      <0.128583, 0.000000, 1.895704>, <0.128583, 0.070721, 1.895704>, <0.070721, 0.128583, 1.895704>, <0.000000, 0.128583, 1.895704>, 
      <0.977210, 0.000000, 2.336478>, <0.977210, 0.537465, 2.336478>, <0.537465, 0.977210, 2.336478>, <0.000000, 0.977210, 2.336478>, 
      <0.988605, 0.000000, 2.918239>, <0.988605, 0.543733, 2.918239>, <0.543733, 0.988605, 2.918239>, <0.000000, 0.988605, 2.918239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.168908, 1.581761>, <-0.092899, 0.168908, 1.581761>, <-0.168908, 0.092899, 1.581761>, <-0.168908, 0.000000, 1.581761>, 
      <0.000000, 0.128583, 1.895704>, <-0.070721, 0.128583, 1.895704>, <-0.128583, 0.070721, 1.895704>, <-0.128583, 0.000000, 1.895704>, 
      <0.000000, 0.977210, 2.336478>, <-0.537465, 0.977210, 2.336478>, <-0.977210, 0.537465, 2.336478>, <-0.977210, 0.000000, 2.336478>, 
      <0.000000, 0.988605, 2.918239>, <-0.543733, 0.988605, 2.918239>, <-0.988605, 0.543733, 2.918239>, <-0.988605, 0.000000, 2.918239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.988605, 0.000000, 2.918239>, <-0.988605, -0.543733, 2.918239>, <-0.543733, -0.988605, 2.918239>, <0.000000, -0.988605, 2.918239>, 
      <-1.000000, 0.000000, 3.500000>, <-1.000000, -0.550000, 3.500000>, <-0.550000, -1.000000, 3.500000>, <0.000000, -1.000000, 3.500000>, 
      <-1.000000, 0.000000, 4.000000>, <-1.000000, -0.550000, 4.000000>, <-0.550000, -1.000000, 4.000000>, <0.000000, -1.000000, 4.000000>, 
      <-1.596998, 0.000000, 4.500000>, <-1.596998, -0.878349, 4.500000>, <-0.878349, -1.596998, 4.500000>, <0.000000, -1.596998, 4.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.988605, 2.918239>, <0.543733, -0.988605, 2.918239>, <0.988605, -0.543733, 2.918239>, <0.988605, 0.000000, 2.918239>, 
      <0.000000, -1.000000, 3.500000>, <0.550000, -1.000000, 3.500000>, <1.000000, -0.550000, 3.500000>, <1.000000, 0.000000, 3.500000>, 
      <0.000000, -1.000000, 4.000000>, <0.550000, -1.000000, 4.000000>, <1.000000, -0.550000, 4.000000>, <1.000000, 0.000000, 4.000000>, 
      <0.000000, -1.596998, 4.500000>, <0.878349, -1.596998, 4.500000>, <1.596998, -0.878349, 4.500000>, <1.596998, 0.000000, 4.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.988605, 0.000000, 2.918239>, <0.988605, 0.543733, 2.918239>, <0.543733, 0.988605, 2.918239>, <0.000000, 0.988605, 2.918239>, 
      <1.000000, 0.000000, 3.500000>, <1.000000, 0.550000, 3.500000>, <0.550000, 1.000000, 3.500000>, <0.000000, 1.000000, 3.500000>, 
      <1.000000, 0.000000, 4.000000>, <1.000000, 0.550000, 4.000000>, <0.550000, 1.000000, 4.000000>, <0.000000, 1.000000, 4.000000>, 
      <1.596998, 0.000000, 4.500000>, <1.596998, 0.878349, 4.500000>, <0.878349, 1.596998, 4.500000>, <0.000000, 1.596998, 4.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.988605, 2.918239>, <-0.543733, 0.988605, 2.918239>, <-0.988605, 0.543733, 2.918239>, <-0.988605, 0.000000, 2.918239>, 
      <0.000000, 1.000000, 3.500000>, <-0.550000, 1.000000, 3.500000>, <-1.000000, 0.550000, 3.500000>, <-1.000000, 0.000000, 3.500000>, 
      <0.000000, 1.000000, 4.000000>, <-0.550000, 1.000000, 4.000000>, <-1.000000, 0.550000, 4.000000>, <-1.000000, 0.000000, 4.000000>, 
      <0.000000, 1.596998, 4.500000>, <-0.878349, 1.596998, 4.500000>, <-1.596998, 0.878349, 4.500000>, <-1.596998, 0.000000, 4.500000>
    }
  }
  texture {
    Glass_Glas1
  }
  scale 0.1
  rotate <0.0, 80.0, 15.0>
  translate  <-4.65, 2.61, 1.33>
}
#declare Weinflasche = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.581395, 0.000000, 0.000000>, <-0.581395, -0.326048, 0.000000>, <-0.319767, -0.592814, 0.000000>, <0.000000, -0.592814, 0.000000>, 
      <-0.581395, 0.000000, 0.528382>, <-0.581395, -0.326048, 0.528382>, <-0.319767, -0.592814, 0.528382>, <0.000000, -0.592814, 0.528382>, 
      <-0.581395, 0.000000, 1.056763>, <-0.581395, -0.326048, 1.056763>, <-0.319767, -0.592814, 1.056763>, <0.000000, -0.592814, 1.056763>, 
      <-0.581395, 0.000000, 1.525079>, <-0.581395, -0.326048, 1.525079>, <-0.319767, -0.592814, 1.525079>, <0.000000, -0.592814, 1.525079>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.592814, 0.000000>, <0.319767, -0.592814, 0.000000>, <0.581395, -0.326048, 0.000000>, <0.581395, 0.000000, 0.000000>, 
      <0.000000, -0.592814, 0.528382>, <0.319767, -0.592814, 0.528382>, <0.581395, -0.326048, 0.528382>, <0.581395, 0.000000, 0.528382>, 
      <0.000000, -0.592814, 1.056763>, <0.319767, -0.592814, 1.056763>, <0.581395, -0.326048, 1.056763>, <0.581395, 0.000000, 1.056763>, 
      <0.000000, -0.592814, 1.525079>, <0.319767, -0.592814, 1.525079>, <0.581395, -0.326048, 1.525079>, <0.581395, 0.000000, 1.525079>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.581395, 0.000000, 0.000000>, <0.581395, 0.326048, 0.000000>, <0.319767, 0.592814, 0.000000>, <0.000000, 0.592814, 0.000000>, 
      <0.581395, 0.000000, 0.528382>, <0.581395, 0.326048, 0.528382>, <0.319767, 0.592814, 0.528382>, <0.000000, 0.592814, 0.528382>, 
      <0.581395, 0.000000, 1.056763>, <0.581395, 0.326048, 1.056763>, <0.319767, 0.592814, 1.056763>, <0.000000, 0.592814, 1.056763>, 
      <0.581395, 0.000000, 1.525079>, <0.581395, 0.326048, 1.525079>, <0.319767, 0.592814, 1.525079>, <0.000000, 0.592814, 1.525079>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.592814, 0.000000>, <-0.319767, 0.592814, 0.000000>, <-0.581395, 0.326048, 0.000000>, <-0.581395, 0.000000, 0.000000>, 
      <0.000000, 0.592814, 0.528382>, <-0.319767, 0.592814, 0.528382>, <-0.581395, 0.326048, 0.528382>, <-0.581395, 0.000000, 0.528382>, 
      <0.000000, 0.592814, 1.056763>, <-0.319767, 0.592814, 1.056763>, <-0.581395, 0.326048, 1.056763>, <-0.581395, 0.000000, 1.056763>, 
      <0.000000, 0.592814, 1.525079>, <-0.319767, 0.592814, 1.525079>, <-0.581395, 0.326048, 1.525079>, <-0.581395, 0.000000, 1.525079>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.581395, 0.000000, 1.525079>, <-0.581395, -0.326048, 1.525079>, <-0.319767, -0.592814, 1.525079>, <0.000000, -0.592814, 1.525079>, 
      <-0.581395, 0.000000, 1.993394>, <-0.581395, -0.326048, 1.993394>, <-0.319767, -0.592814, 1.993394>, <0.000000, -0.592814, 1.993394>, 
      <-0.581395, 0.000000, 2.521776>, <-0.581395, -0.326048, 2.521776>, <-0.319767, -0.592814, 2.521776>, <0.000000, -0.592814, 2.521776>, 
      <-0.385383, 0.000000, 2.707151>, <-0.385383, -0.218024, 2.707151>, <-0.211961, -0.396407, 2.707151>, <0.000000, -0.396407, 2.707151>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.592814, 1.525079>, <0.319767, -0.592814, 1.525079>, <0.581395, -0.326048, 1.525079>, <0.581395, 0.000000, 1.525079>, 
      <0.000000, -0.592814, 1.993394>, <0.319767, -0.592814, 1.993394>, <0.581395, -0.326048, 1.993394>, <0.581395, 0.000000, 1.993394>, 
      <0.000000, -0.592814, 2.521776>, <0.319767, -0.592814, 2.521776>, <0.581395, -0.326048, 2.521776>, <0.581395, 0.000000, 2.521776>, 
      <0.000000, -0.396407, 2.707151>, <0.211961, -0.396407, 2.707151>, <0.385383, -0.218024, 2.707151>, <0.385383, 0.000000, 2.707151>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.581395, 0.000000, 1.525079>, <0.581395, 0.326048, 1.525079>, <0.319767, 0.592814, 1.525079>, <0.000000, 0.592814, 1.525079>, 
      <0.581395, 0.000000, 1.993394>, <0.581395, 0.326048, 1.993394>, <0.319767, 0.592814, 1.993394>, <0.000000, 0.592814, 1.993394>, 
      <0.581395, 0.000000, 2.521776>, <0.581395, 0.326048, 2.521776>, <0.319767, 0.592814, 2.521776>, <0.000000, 0.592814, 2.521776>, 
      <0.385383, 0.000000, 2.707151>, <0.385383, 0.218024, 2.707151>, <0.211961, 0.396407, 2.707151>, <0.000000, 0.396407, 2.707151>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.592814, 1.525079>, <-0.319767, 0.592814, 1.525079>, <-0.581395, 0.326048, 1.525079>, <-0.581395, 0.000000, 1.525079>, 
      <0.000000, 0.592814, 1.993394>, <-0.319767, 0.592814, 1.993394>, <-0.581395, 0.326048, 1.993394>, <-0.581395, 0.000000, 1.993394>, 
      <0.000000, 0.592814, 2.521776>, <-0.319767, 0.592814, 2.521776>, <-0.581395, 0.326048, 2.521776>, <-0.581395, 0.000000, 2.521776>, 
      <0.000000, 0.396407, 2.707151>, <-0.211961, 0.396407, 2.707151>, <-0.385383, 0.218024, 2.707151>, <-0.385383, 0.000000, 2.707151>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.385383, 0.000000, 2.707151>, <-0.385383, -0.218024, 2.707151>, <-0.211961, -0.396407, 2.707151>, <0.000000, -0.396407, 2.707151>, 
      <-0.189370, 0.000000, 2.892526>, <-0.189370, -0.110000, 2.892526>, <-0.104154, -0.200000, 2.892526>, <0.000000, -0.200000, 2.892526>, 
      <-0.120331, 0.000000, 3.919598>, <-0.120331, -0.072286, 3.919598>, <-0.066182, -0.131429, 3.919598>, <0.000000, -0.131429, 3.919598>, 
      <-0.153237, 0.000000, 4.279715>, <-0.153237, -0.090900, 4.279715>, <-0.084280, -0.165273, 4.279715>, <0.000000, -0.165273, 4.279715>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.396407, 2.707151>, <0.211961, -0.396407, 2.707151>, <0.385383, -0.218024, 2.707151>, <0.385383, 0.000000, 2.707151>, 
      <0.000000, -0.200000, 2.892526>, <0.104154, -0.200000, 2.892526>, <0.189370, -0.110000, 2.892526>, <0.189370, 0.000000, 2.892526>, 
      <0.000000, -0.131429, 3.919598>, <0.066182, -0.131429, 3.919598>, <0.120331, -0.072286, 3.919598>, <0.120331, 0.000000, 3.919598>, 
      <0.000000, -0.165273, 4.279715>, <0.084280, -0.165273, 4.279715>, <0.153237, -0.090900, 4.279715>, <0.153237, 0.000000, 4.279715>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.385383, 0.000000, 2.707151>, <0.385383, 0.218024, 2.707151>, <0.211961, 0.396407, 2.707151>, <0.000000, 0.396407, 2.707151>, 
      <0.189370, 0.000000, 2.892526>, <0.189370, 0.110000, 2.892526>, <0.104154, 0.200000, 2.892526>, <0.000000, 0.200000, 2.892526>, 
      <0.120331, 0.000000, 3.919598>, <0.120331, 0.072286, 3.919598>, <0.066182, 0.131429, 3.919598>, <0.000000, 0.131429, 3.919598>, 
      <0.153237, 0.000000, 4.279715>, <0.153237, 0.090900, 4.279715>, <0.084280, 0.165273, 4.279715>, <0.000000, 0.165273, 4.279715>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.396407, 2.707151>, <-0.211961, 0.396407, 2.707151>, <-0.385383, 0.218024, 2.707151>, <-0.385383, 0.000000, 2.707151>, 
      <0.000000, 0.200000, 2.892526>, <-0.104154, 0.200000, 2.892526>, <-0.189370, 0.110000, 2.892526>, <-0.189370, 0.000000, 2.892526>, 
      <0.000000, 0.131429, 3.919598>, <-0.066182, 0.131429, 3.919598>, <-0.120331, 0.072286, 3.919598>, <-0.120331, 0.000000, 3.919598>, 
      <0.000000, 0.165273, 4.279715>, <-0.084280, 0.165273, 4.279715>, <-0.153237, 0.090900, 4.279715>, <-0.153237, 0.000000, 4.279715>
    }
  }
  texture {
    Glass_Gruen
  }
  scale 1.148767
  translate  <0.097294, 1.264828, 0.0>
}
#declare fd_Ettiket = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, 0.000000, 0.000000>, <-1.000000, -0.550000, 0.000000>, <-0.550000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-1.000000, 0.000000, 0.500000>, <-1.000000, -0.550000, 0.500000>, <-0.550000, -1.000000, 0.500000>, <0.000000, -1.000000, 0.500000>, 
      <-1.000000, 0.000000, 1.000000>, <-1.000000, -0.550000, 1.000000>, <-0.550000, -1.000000, 1.000000>, <0.000000, -1.000000, 1.000000>, 
      <-1.000000, 0.000000, 1.500000>, <-1.000000, -0.550000, 1.500000>, <-0.550000, -1.000000, 1.500000>, <0.000000, -1.000000, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -1.000000, 0.000000>, <0.550000, -1.000000, 0.000000>, <1.000000, -0.550000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
      <0.000000, -1.000000, 0.500000>, <0.550000, -1.000000, 0.500000>, <1.000000, -0.550000, 0.500000>, <1.000000, 0.000000, 0.500000>, 
      <0.000000, -1.000000, 1.000000>, <0.550000, -1.000000, 1.000000>, <1.000000, -0.550000, 1.000000>, <1.000000, 0.000000, 1.000000>, 
      <0.000000, -1.000000, 1.500000>, <0.550000, -1.000000, 1.500000>, <1.000000, -0.550000, 1.500000>, <1.000000, 0.000000, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, 0.000000, 0.000000>, <1.000000, 0.550000, 0.000000>, <0.550000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, 
      <1.000000, 0.000000, 0.500000>, <1.000000, 0.550000, 0.500000>, <0.550000, 1.000000, 0.500000>, <0.000000, 1.000000, 0.500000>, 
      <1.000000, 0.000000, 1.000000>, <1.000000, 0.550000, 1.000000>, <0.550000, 1.000000, 1.000000>, <0.000000, 1.000000, 1.000000>, 
      <1.000000, 0.000000, 1.500000>, <1.000000, 0.550000, 1.500000>, <0.550000, 1.000000, 1.500000>, <0.000000, 1.000000, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 1.000000, 0.000000>, <-0.550000, 1.000000, 0.000000>, <-1.000000, 0.550000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
      <0.000000, 1.000000, 0.500000>, <-0.550000, 1.000000, 0.500000>, <-1.000000, 0.550000, 0.500000>, <-1.000000, 0.000000, 0.500000>, 
      <0.000000, 1.000000, 1.000000>, <-0.550000, 1.000000, 1.000000>, <-1.000000, 0.550000, 1.000000>, <-1.000000, 0.000000, 1.000000>, 
      <0.000000, 1.000000, 1.500000>, <-0.550000, 1.000000, 1.500000>, <-1.000000, 0.550000, 1.500000>, <-1.000000, 0.000000, 1.500000>
    }
  }
  texture {
    Ettiket
    scale <1.881265, 1.306527, 0.999735>
    rotate -89.950554*x
  translate <-0.957897, 0.000000, 1.379372>
  }
  scale 0.705463
  rotate <0.0, 0.0, 10.551895>
  translate  <0.094476, 1.272096, 0.785626>
}
//
// Include file contains 'FlascheMoben'
//
#include "prophecy.in1"
#declare FlascheMoben = object {
  FlascheMoben_Raw
  texture {
    Glass_Gruen
  }
  scale <0.209254, 0.209254, 0.719411>
  translate  <0.096325, 1.264977, 4.813474>
}
#declare Flasche = union {
  object { Weinflasche }
  object { fd_Ettiket }
  object { FlascheMoben }
  no_shadow
  scale 0.26
  rotate -180.0*z
  translate  <-3.04, 4.32, 1.24>
}
#declare Kugelstaender = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.549128, 0.000000, 0.000000>, <-1.549128, -1.577302, 0.000000>, <1.549128, -1.577302, 0.000000>, <1.549128, 0.000000, 0.000000>, 
      <-1.000000, 0.000000, 2.000000>, <-1.000000, -1.000000, 2.000000>, <1.000000, -1.000000, 2.000000>, <1.000000, 0.000000, 2.000000>, 
      <-1.000000, 0.000000, 4.000000>, <-1.000000, -1.000000, 4.000000>, <1.000000, -1.000000, 4.000000>, <1.000000, 0.000000, 4.000000>, 
      <-1.000000, 0.000000, 6.000000>, <-1.000000, -1.000000, 6.000000>, <1.000000, -1.000000, 6.000000>, <1.000000, 0.000000, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.549128, 0.000000, 0.000000>, <1.549128, 1.577302, 0.000000>, <-1.549128, 1.577302, 0.000000>, <-1.549128, 0.000000, 0.000000>, 
      <1.000000, 0.000000, 2.000000>, <1.000000, 1.000000, 2.000000>, <-1.000000, 1.000000, 2.000000>, <-1.000000, 0.000000, 2.000000>, 
      <1.000000, 0.000000, 4.000000>, <1.000000, 1.000000, 4.000000>, <-1.000000, 1.000000, 4.000000>, <-1.000000, 0.000000, 4.000000>, 
      <1.000000, 0.000000, 6.000000>, <1.000000, 1.000000, 6.000000>, <-1.000000, 1.000000, 6.000000>, <-1.000000, 0.000000, 6.000000>
    }
  }
  texture {
    fuer_Rahmen
  }
  scale <0.18, 0.23, 0.05>
  translate  <-3.75, 3.35, 1.24>
}
union { // Tisch_ud_ad
  object { Korken }
  object { Weinglas }
  sphere { // Zauberkugel
    <0,0,0>,1
    texture {
      fuer_Kugel
    }
    scale 0.36
    rotate 90.0*x
    translate  <-3.75, 3.36, 1.72>
  }
  box { // Platte
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Holz_fuer_Pfosten
      scale <2.01, 2.02, 1.0>
  translate <-1.000000, -1.020000, 0.000000>
    }
    scale <1.29, 1.29, 0.86>
    translate  <-3.75, 3.33, 0.38>
  }
  box { // SeiteMvorn
    <-1, -1, -1>, <1, 1, 1>
    texture {
      fuer_Rahmen
      scale <0.82, 1.07, 1.0>
      rotate 90.0*x
  translate <-0.400000, 0.000000, -0.420000>
    }
    scale <1.3, 0.01, 0.87>
    translate  <-3.76, 2.01, 0.36>
  }
  object { Flasche }
  object { Kugelstaender }
  box { // SeiteMrechts
    <-1, -1, -1>, <1, 1, 1>
    texture {
      fuer_Rahmen
      scale <1.08, 0.82, 1.0>
      rotate <0.0, -90.0, -180.0>
  translate <0.000000, 0.430000, -0.420000>
    }
    scale <0.01, 1.31, 0.86>
    translate  <-2.45, 3.31, 0.36>
  }
  box { // ZeichenMlinks1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Pentagramm
      scale <2.0, 2.01, 1.0>
      rotate 90.0*x
  translate <-1.000000, 0.000000, -1.010000>
    }
    scale <0.41, 0.01, 0.36>
    rotate 90.0*z
    translate  <-2.44, 3.31, 0.6>
  }
  box { // ZeichenMlinks
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Pentagramm
      scale <2.0, 2.01, 1.0>
      rotate 90.0*x
  translate <-1.000000, 0.000000, -1.010000>
    }
    scale <0.41, 0.01, 0.36>
    translate  <-3.73, 2.0, 0.6>
  }
  translate  <1.11, -2.88, 0.24>
}




object {   // Zeichen
  height_field {
    gif "hf-sign.gif"
    water_level 0.0869
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    Fakelmettal
  }
  scale <1.45, 1.51, 0.31>
  rotate <-90.0, -90.0, 0.0>
  translate  <-6.85, 10.02, 5.11>
}


union { // Wandbild
  box { // Rahmen
    <-1, -1, -1>, <1, 1, 1>
    texture {
      fuer_Rahmen
    }
    scale <0.94, 0.04, 1.56>
    translate  <-2.52, 9.89, 5.01>
  }
  box { // Bild
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Bildinhalt
      scale <1.99, 2.01, 1.0>
      rotate 90.0*x
  translate <-1.000000, 0.000000, -1.000000>
    }
    scale <0.77, 0.02, 1.36>
    translate  <-2.52, 9.86, 5.01>
  }
  scale 1.05
  translate  <-0.34, -0.45, -0.25>
}




#declare Holz2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.125991, 0.000000, 0.000000>, <-0.125991, -0.124935, 0.000000>, <0.125991, -0.124935, 0.000000>, <0.125991, 0.000000, 0.000000>, 
      <-1.000000, 0.000000, 0.154123>, <-1.000000, -1.000000, 0.154123>, <1.000000, -1.000000, 0.154123>, <1.000000, 0.000000, 0.154123>, 
      <-1.000000, 0.000000, 4.000000>, <-1.000000, -1.000000, 4.000000>, <1.000000, -1.000000, 4.000000>, <1.000000, 0.000000, 4.000000>, 
      <-1.000000, 0.000000, 6.000000>, <-1.000000, -1.000000, 6.000000>, <1.000000, -1.000000, 6.000000>, <1.000000, 0.000000, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.125991, 0.000000, 0.000000>, <0.125991, 0.124935, 0.000000>, <-0.125991, 0.124935, 0.000000>, <-0.125991, 0.000000, 0.000000>, 
      <1.000000, 0.000000, 0.154123>, <1.000000, 1.000000, 0.154123>, <-1.000000, 1.000000, 0.154123>, <-1.000000, 0.000000, 0.154123>, 
      <1.000000, 0.000000, 4.000000>, <1.000000, 1.000000, 4.000000>, <-1.000000, 1.000000, 4.000000>, <-1.000000, 0.000000, 4.000000>, 
      <1.000000, 0.000000, 6.000000>, <1.000000, 1.000000, 6.000000>, <-1.000000, 1.000000, 6.000000>, <-1.000000, 0.000000, 6.000000>
    }
  }
  texture {
    fuer_Fakel
  }
  scale <0.16, 0.22, 0.28>
  translate  <0.0, -0.5, -0.33>
}
#declare Fakel1 = union {
  object { Holz2 }
  torus { // Fakelring1
    1.7, 0.05  rotate -x*90
    texture {
      Fakelmettal
    }
    scale <0.1, 0.1, 0.77>
    translate  <0.0, -0.5, 1.33>
  }
  rotate 15.0*x
  translate  <0.0, 0.34, 0.31>
}
union { // Fak_P_Halter2
  torus { // Ring1
    1.7, 0.15  rotate -x*90
    texture {
      Fakelmettal
    }
    scale <0.14, 0.13, 0.23>
    translate  <-0.01, -0.38, 1.07>
  }
  box { // Wandhalter1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Fakelmettal
    }
    scale <0.04, 0.09, 0.02>
    translate  <0.0, -0.08, 1.07>
  }
  object { Fakel1 }
  sphere { // Flamme2
    <0,0,0>,1
    texture {
      feuer
    }
    hollow
    scale <0.19, 0.18, 0.35>
    rotate 0.0*x
    translate  <0.0, -0.51, 1.78>
  }
  scale 0.87
  translate  <-0.54, 9.97, 4.14>
}


#declare Pfosten = union {
  box { // Pfeiler1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Holz_fuer_Pfosten
      rotate -90.0*x
    }
    scale <0.33, 0.13, 6.53>
    rotate -90.0*z
    translate  <-9.99, 9.71, 6.54>
  }
  box { // Pfeiler2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Holz_fuer_Pfosten
      rotate <-90.0, -90.0, 0.0>
    }
    scale <0.33, 0.13, 6.53>
    translate  <-9.65, 10.0, 6.54>
  }
}
#declare Fenster = union {
  box { // FensterMu
    <-1, -1, -1>, <1, 1, 1>
    texture {
      FensterMinnen
    }
    scale <0.73, 1.08, 1.05>
    translate  <-10.51, 3.44, 5.12>
  }
  cylinder { // FensterMo
    <0,0,1>, <0,0,0>, 1 
    texture {
      FensterMinnen
    }
    scale <0.94, 1.1, 1.33>
    rotate -90.0*y
    translate  <-9.87, 3.44, 6.15>
  }
  translate  <0.0, 1.06, -0.25>
}
#declare Wand_u_Fenster = difference {
  box { // WandMlinks
    <-1, -1, -1>, <1, 1, 1>
    texture {
      fuer_Waende
      scale <0.33, 0.38, 1.0>
      rotate -90.0*x
    }
    scale <9.969999, 0.53, 6.53>
    rotate -90.0*z
    translate  <-10.54, 0.01, 6.54>
  }
  object { Fenster }
}
#declare Staebe = union {
  cylinder { // StabMvMu
    <0,0,1>, <0,0,0>, 1 
    texture {
      fuer_Fendstaebe
    }
    scale <0.06, 0.05, 2.4>
    rotate -90.0*x
    translate  <-10.65, 2.25, 4.54>
  }
  cylinder { // StabMvMm
    <0,0,1>, <0,0,0>, 1 
    texture {
      fuer_Fendstaebe
    }
    scale <0.06, 0.05, 2.4>
    rotate -90.0*x
    translate  <-10.65, 2.25, 5.39>
  }
  cylinder { // StabMvMo
    <0,0,1>, <0,0,0>, 1 
    texture {
      fuer_Fendstaebe
    }
    scale <0.06, 0.05, 2.4>
    rotate -90.0*x
    translate  <-10.65, 2.25, 6.33>
  }
  cylinder { // StabMhMr
    <0,0,1>, <0,0,0>, 1 
    texture {
      fuer_Fendstaebe
    }
    scale <0.06, 0.05, 3.03>
    translate  <-10.65, 2.96, 4.04>
  }
  cylinder { // StabMhMl
    <0,0,1>, <0,0,0>, 1 
    texture {
      fuer_Fendstaebe
    }
    scale <0.06, 0.05, 3.03>
    translate  <-10.65, 3.94, 4.02>
  }
  translate  <0.0, 1.02, -0.29>
}
union { // Zimmer
  object { Pfosten }
  box { // WandMhinten
    <-1, -1, -1>, <1, 1, 1>
    texture {
      fuer_Waende
      scale <0.33, 0.37, 1.0>
      rotate -90.0*x
    }
    scale <9.969999, 0.18, 6.53>
    translate  <0.0, 10.15, 6.51>
  }
  object { Wand_u_Fenster }
  plane { // Grund
    z,0
    texture {
      Parkett
      scale <0.09, 0.08, 1.0>
      rotate 90.0*z
    }
    scale 10.01
  }
  object { Staebe }
}




#declare Holz1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.125991, 0.000000, 0.000000>, <-0.125991, -0.124935, 0.000000>, <0.125991, -0.124935, 0.000000>, <0.125991, 0.000000, 0.000000>, 
      <-1.000000, 0.000000, 0.154123>, <-1.000000, -1.000000, 0.154123>, <1.000000, -1.000000, 0.154123>, <1.000000, 0.000000, 0.154123>, 
      <-1.000000, 0.000000, 4.000000>, <-1.000000, -1.000000, 4.000000>, <1.000000, -1.000000, 4.000000>, <1.000000, 0.000000, 4.000000>, 
      <-1.000000, 0.000000, 6.000000>, <-1.000000, -1.000000, 6.000000>, <1.000000, -1.000000, 6.000000>, <1.000000, 0.000000, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.125991, 0.000000, 0.000000>, <0.125991, 0.124935, 0.000000>, <-0.125991, 0.124935, 0.000000>, <-0.125991, 0.000000, 0.000000>, 
      <1.000000, 0.000000, 0.154123>, <1.000000, 1.000000, 0.154123>, <-1.000000, 1.000000, 0.154123>, <-1.000000, 0.000000, 0.154123>, 
      <1.000000, 0.000000, 4.000000>, <1.000000, 1.000000, 4.000000>, <-1.000000, 1.000000, 4.000000>, <-1.000000, 0.000000, 4.000000>, 
      <1.000000, 0.000000, 6.000000>, <1.000000, 1.000000, 6.000000>, <-1.000000, 1.000000, 6.000000>, <-1.000000, 0.000000, 6.000000>
    }
  }
  texture {
    fuer_Fakel
  }
  scale <0.16, 0.22, 0.28>
  translate  <0.0, -0.5, -0.33>
}
#declare Fakel = union {
  object { Holz1 }
  torus { // Fakelring
    1.7, 0.05  rotate -x*90
    texture {
      Fakelmettal
    }
    scale <0.1, 0.1, 0.77>
    translate  <0.0, -0.5, 1.33>
  }
  rotate 15.0*x
  translate  <0.0, 0.34, 0.31>
}
union { // Fakel_P_Halter
  torus { // Ring
    1.7, 0.15  rotate -x*90
    texture {
      Fakelmettal
    }
    scale <0.14, 0.13, 0.23>
    translate  <-0.01, -0.38, 1.07>
  }
  box { // Wandhalter
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Fakelmettal
    }
    scale <0.04, 0.09, 0.02>
    translate  <0.0, -0.08, 1.07>
  }
  object { Fakel }
  sphere { // Flamme1
    <0,0,0>,1
    texture {
      feuer
    }
    hollow
    scale <0.17, 0.17, 0.34>
    rotate <0.0, 0.0, -90.0>
    translate  <0.0, -0.51, 1.76>
  }
  scale 0.87
  rotate 90.0*z
  translate  <-9.94, 7.36, 4.1>
}


#declare Seite1 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.149839>, <0.000000, -2.000000, 0.149839>, <1.000000, -2.000000, 0.000000>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.149839>, <0.000000, -1.000000, 0.149839>, <1.000000, -1.000000, 0.000000>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.149839>, <0.000000, 0.000000, 0.149839>, <1.000000, 0.000000, 0.000000>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.149839>, <0.000000, 1.000000, 0.149839>, <1.000000, 1.000000, 0.000000>
    }
  }
  texture {
    fuer_Buchtitel2
    scale <2.92, 3.01, 1.0>
  translate <-1.990000, -2.000000, 0.000000>
  }
  scale <0.2, 1.09, 0.95>
  rotate <-90.0, -90.0, 0.0>
  translate  <0.55, 1.03, 0.09>
}
#declare Buch = union {
  box { // Blaetter1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Grau_fuer_Buch
    }
    scale <1.58, 1.04, 0.26>
  }
  box { // Unten1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Gruen1
    }
    scale <1.64, 1.07, 0.01>
    translate  <0.01, -0.03, -0.28>
  }
  box { // Oben1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      fuer_Buchtitel
      scale <2.01, 2.0, 1.0>
      rotate -90.0*z
  translate <-1.000000, 1.010000, 0.000000>
    }
    scale <1.64, 1.07, 0.01>
    translate  <0.01, -0.04, 0.28>
  }
  object { Seite1 }
  scale 0.825
  rotate <0.0, -20.0, 90.0>
  translate  <0.05, -0.25, 3.85>
}
union { // Buchstaender
  box { // BSMBeinMr
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Sandalwood1
    }
    scale <0.12, 0.71, 1.82>
    translate  <0.78, 0.0, 1.48>
  }
  box { // BSMBeinMl
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Sandalwood1
    }
    scale <0.12, 0.74, 1.77>
    translate  <-0.87, 0.0, 1.52>
  }
  box { // BSMoben
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Sandalwood1
    }
    scale <2.16, 1.5, 0.1>
    rotate 20.0*x
    translate  <0.0, -0.06, 3.51>
  }
  box { // BSMFuss
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Sandalwood1
    }
    scale <1.56, 1.09, 0.13>
    translate  -0.27*z
  }
  object { Buch }
  texture {
    Sandalwood1
  }
  scale 0.4
  rotate 50.0*z
  translate  <-0.19, 2.81, 0.2>
}


