
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions


// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-20, 40, -20>
}

camera
{
  location  <0.0 , 2.0 ,-5.0>
  look_at   <0.0 , 0.0 , 0.0>
}

background { White }
// Create an infinite sphere around scene and allow any texture on it
sky_sphere
{
  pigment
  {
    marble
    turbulence 0.56
    octaves 8.0
    omega 0.53
    color_map
    {
      [0.00 color rgbf<0.000, 0.000, 0.000, 0.996>]
      [0.65 color rgbf<0.000, 0.000, 0.000, 0.996>]
      [0.85 color rgbf<0.000, 0.000, 0.196, 0.796>]
      [0.85 color rgbf<0.000, 0.000, 0.196, 0.796>]
      [0.92 color rgbf<0.086, 0.086, 0.400, 0.749>]
      [0.92 color rgbf<0.078, 0.078, 0.400, 0.737>]
      [0.99 color rgb<0.600, 0.600, 0.800>]
      [0.99 color rgb<0.600, 0.600, 0.800>]
      [1.00 color rgb<1.000, 1.000, 1.000>]
    }
  }
  rotate -15*y
  scale 2.0
  // end Lightning
}



/*

    pigment       //Lightnining
  {
    marble
    turbulence 0.3
    color_map
    {
      [0.00 color rgbf<0.000, 0.000, 0.000, 1.0>]
      [0.65 color rgbf<0.000, 0.000, 0.000, 0.996>]
      [0.85 color rgbf<0.000, 0.000, 0.196, 0.796>]
      [0.85 color rgbf<0.000, 0.000, 0.196, 0.796>]
      [0.92 color rgbf<0.086, 0.086, 0.400, 0.749>]
      [0.92 color rgbf<0.078, 0.078, 0.400, 0.737>]
      [0.99 color rgb<0.600, 0.600, 0.800>]
      [0.99 color rgb<0.600, 0.600, 0.800>]
      [1.00 color rgb<.99, .990, .990>]
    }
    rotate -25*y
  }
  // end Lightning
*/
