/*
EMAIL: pollux@worldaccess.nl
NAME:  Ron A.F. Greve
TOPIC: Magic
COPYRIGHT: I SUBMIT TO THE STANDARD RAYTRACING COMPETITION COPYRIGHT.
TITLE:
COUNTRY: The Netherlands
WEBPAGE: http://www.worldaccess.nl/~pollux
RENDERER USED: POV-Ray 3.02 for Windows 95
TOOLS USED: Temple on sprxtnqs
RENDER TIME: Forgot to check POV-ray's ouput but about 12 hours I believe.
HARDWARE USED: Pentium Pro 200 (64 MB) during creation, Pentium 150 for final rendering(s)
IMAGE DESCRIPTION:
  Actually this is not a pov-ray render at all. It is
  a photo taken by some aliens of the planet "sprxtnqs".
  Since communicating in sprxtnqsan is not easy I can only guess that
  this must be the ruins of an ancient temple.
  They seem to have worshipped the glowing ball. Some important
  things in their lifes are on the pedestals:
   stylized grain,
   a photo of someone (looks somewhat familiar to me),
   games,
   fire,
   and a butterfly?

   Well anyway I fed the photo into my POV compression algorithm
   ( which compresses any photo into a small POVray-textfile.)

   And here it is.
   
   ( don't ask me about the compression program I have lost both code
     and executable :-) ).
DESCRIPTION OF HOW THIS IMAGE WAS CREATED:
  I completely edited this scene by hand using the povray editor.
  No other tools were used. ( Except for a camera to take a picture of me :-) ).

  I used a lot of while loops to create for instance
    the floor,
    the wall,
    "Jack in the box" with a "real" spring.

  The preprocessor directives #if, #while are great to make some complex structures without
  the need for external tools.  
    
  The flame and the glowing gass of the ball are halos
  
  The green mountains are a julia fractal (three times).
  
  The shape of the halo and julia fractal is difficult to predict
  so I made them with a lot of trial and error. Usually I start with rendering an example from
  the povray help file then changing parameters until it suits what I had in mind.
  
  Note: There is some strange behaviour while rendereing the wall, sometimes it doesn't render completely.
   Then after only saving the text file without changing anything the wall IS rendered. Well.., if that
   ain't MAGIC!...
  
  
*/


#version 3

#include "colors.inc"
#include "consts.inc"
#include "textures.inc"
//#include "stones.inc"


#declare Fast = false

#declare ShowAll  = true // Final rendering
#declare Creating = false

#if ( ShowAll )
  //Everything that should be rendered in the final scene should be set to true here
  #declare ShowGlobe     = true
  #declare ShowPillars   = true
  #declare ShowSmokey    = true
  #declare ShowPenta     = true
  #declare ShowFloor     = true
  #declare ShowMoon      = true
  #declare ShowWall      = true   // damned! if this shows up the walls doesn't and vice versa
                                   // saving the source file swaps from wall to mountains????? Must be a povray bug
  #declare ShowGames     = true
  #declare ShowFog       = true
  #declare ShowMountains = false  // Now they are sometimes rendered both ( ShowMountains switch is obsolete now ).

#else
  // Use this during testing the various parts fo the scene

  #declare ShowGlobe     = false
  #declare ShowPillars   = false
  #declare ShowSmokey    = false
  #declare ShowPenta     = false
  #declare ShowFloor     = false
  #declare ShowMoon      = false
  #declare ShowWall      = false
  #declare ShowGames     = false
  #declare ShowFog       = false
  #declare ShowMountains = false
#end


global_settings
{
  assumed_gamma 1.4
}
#declare Seed0 = seed(0)
#declare Seed1 = seed(29)  // Used for the bugs
#declare Seed2 = seed(300)  // Used for the bugs
#declare Seed3 = seed(600)  // Used to cut the corners oft the stone wall

#if( Creating ) // Create an object at <0, 0, 0>
  camera
  {
    location  <0.0, 9.0, -50.0> // position of camera <X Y Z>

    direction 1.0*z            // which way are we looking <X Y Z> & zoom
    //  sky       y                // rarely used
    up        y                // which way is +up <X Y Z>
    right     4/3*x            // which way is +right <X Y Z> and aspect ratio
    look_at   <0.0, 10.0,  0.0> // point center of view at this point <X Y Z>
  }

  // create a regular point light source
  light_source
  {
    0*x // light's position (translated below)
    color red 1.0  green 1.0  blue 1.0  // light's color
    translate <20, 40, -20>
  }



#else  // Regular camere position
  camera
  {
    location  <0.0, 9.0, -35.0> // position of camera <X Y Z>
    direction 2.0*z            // which way are we looking <X Y Z> & zoom
    //  sky       y                // rarely used
    up        y                // which way is +up <X Y Z>
    right     4/3*x            // which way is +right <X Y Z> and aspect ratio
    look_at   <0.0, 4.0,  0.0> // point center of view at this point <X Y Z>
  }

#end

/*
// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <0, 40, 0>
}
*/


#declare Sky = sphere
{
  <0,0,0>
  1000
  pigment
  {
    gradient <1,1,1>
    turbulence 2
    color_map
    {
      [ 0.0 color rgb  <1, 0.5, 0.5> ]
      [ 0.65 color rgb <0.5, 0.1, 0.1 > ]
      [ 1.0 color rgb <0.0, 0.0, 0.00 > ]
    }
    scale <100, 100, 100>
  }
  hollow
}

#declare SandStone = texture
{

  pigment
  {
    gradient <1,1,1>
    turbulence 2
    color_map
    {
      [ 0.0 color rgb <255/256,215/256,135/256>]
      [ 0.8 color rgb <255/256,215/256,135/256>]
      [ 0.8 color rgb <255/256,188/256,54/256>]
      [ 1.0 color rgb <255/256,188/256,54/256>]
    }

  }
  finish
  {
    ambient 0.05
    brilliance 1
    phong 40
    diffuse 0.3
  }

}

// Use the "chisel" to cut debris the vase etc. Hey it's been here for ages so there
// must be some debris
#declare Chisel  = union
{
  cylinder
  {
    -10 * x,  10 * x,  1
    // open
  }
  cylinder
  {
    -10 * x + <0, -0.3, 0.6>,
     10 * x + <0, -0.3, 0.6>,
     0.5
    // open
  }
  cylinder
  {
    -10 * x + <0, -0.3, -0.4>,
     10 * x + <0, -0.3, -0.4>,
     0.6
    // open
  }

}


//------------------------------------------Grain---------------------------------
#declare grain = prism
{
  linear_sweep
  linear_spline
  -2, // sweep the following shape from here ...
  2, // ... up through here
  12, // the number of points making up the shape ...

  <-4   ,      3>
  < -3.7  ,      2.3 >
  < -3  ,      2>
  < -2  ,      1.95 >
  <-1.3,        1.7>
  <  -1  ,      1 >

  <  -1  ,      5 >
  <-1.3,        5.7>
  < -2  ,      5.95 >
  < -3  ,      6>
  < -3.7  ,      6.3 >
  <-4   ,      7>
  pigment { color rgb <1.0, 0.9, 0> }
  finish { ambient 0.6 }
  translate <1, -1, 0>
}

#declare topgrain = prism
{
  linear_sweep
  linear_spline
  -1, // sweep the following shape from here ...
  1, // ... up through here
  12, // the number of points making up the shape ...

  <-4   ,      3>
  < -3.7  ,      2.3 >
  < -3  ,      2>
  < -2  ,      1.95 >
  <-1.3,        1.7>
  <  -1  ,      1 >

  <  -1  ,      6.5 >
  <-1.3,        5.8>
  < -2  ,      5.55 >
  < -3  ,      5.5>
  < -3.7  ,     5.2 >
  <-4   ,      4.5>
  pigment { color rgb <1.0, 0.9, 0> }
  finish { ambient 0.6 }
  translate <1, -1, 0>
}


#declare HLeave = bicubic_patch
{
  type 1 // patch_type (0..1)
  // 0 = Bezier patch, just store the triangular vertices
  // 1 = Bezier patch, store all plane equations defined by
  //       the triangulation of the patch into sub patches
  //       (faster, uses more memory)
  flatness 0.1 // flatness value
  //       flatness_value = 0.0 to 1.0, with higher values
  //       giving flatter, less smooth results
  u_steps 3 // # of triangles to subdivide (1-5)
  v_steps 3 // # of triangles to subdivide (1-5)
  <5, 2, -1>   <2, 1, -0.3> <3, 2, -0.8>  <9, 0, -2>
  <0, 2, -0.4> <1, 1, -0.1> <3, 1, -0.4>  <6, 1, -1.1>
  <0, 3, -0.6> <5, 1, -0.9> <6, 1, -1>    <7, 1, -1.4>
  <0, 0, 0>    <6, 0, -0.9> <7, 0, -1.0>  <5, -0.3, -0.8>
  pigment
  {
    color rgb <0.3, 1, 0>
  }
  scale <3,5,4>
}

#declare Leave =union
{
  object
  {
    HLeave
    rotate <0,0,30>
  }
   object
  {
    HLeave
    rotate <0,0,-30>
    scale <1,-1,1>
  }
  finish{ ambient 0.8 }
  rotate <90,45,30>
  rotate<0,180,0>
}

#declare HalfGrain=  union
{
  object
  {
    topgrain

  }
  #declare Cnt = 1
  #while ( Cnt < 4 )
    object
    {
      grain
      translate <-0.3,0,-4.8*Cnt>
    }
  #declare Cnt = Cnt + 1
  #end

}

#declare Grain = union
{
  object
  {
    HalfGrain
  }
  object
  {
    HalfGrain
    scale <-1,1,1>
  }
}

#declare Stalk = cylinder
{
  <0,1,0>
  <0,-3*Cnt*4.8,0>,
  0.6
  pigment
  {
    color rgb <0.3, 1, 0>
  }
}

#declare Plant = union
{
  object
  {
    Grain

    rotate <-90,30,0>
    translate <0,14,0>
  }

  object
  {
    Stalk

  }

  object
  {
    Leave
    rotate< 0,0,-20>
    translate <-2,-10,0>

  }
  object
  {
    Leave
    rotate< 0,180,20>
    translate <2,-15,0>

   }
}
//---------------------------------------End Grain--------------------------
//---------------------------------------ButterFly------------------------------


#include "shapes.inc"    // pre-defined scene elements

#declare but_wingh =       intersection {
                                       plane  { <0, 0, -1>, 0}
                                       plane  { <0, 0, 1>, 0.1}
                                       union {
                                             cone { <0,10,0.05>,4 <0,0,0.05>, 2}
                                             object {
                                                    Cylinder_Z
                                                    scale <4, 4, 1>
                                                    translate <0, 11, 0.05>
                                                    }

                                             }
                                       }
#declare but_wing  = intersection {
                                  union {
                                        object {
                                               but_wingh
                                               rotate <0, 0, -44>
                                               }
                                        object {
                                               but_wingh
                                               scale <0.7, 0.7, 1>
                                               rotate <0, 0, -11>
                                               }
                                        scale <1.6, 1.6, 1>
                                        translate <0, -1.5, 0>

                                        pigment {

                                                gradient <1,1,1>
                                                turbulence 2
                                                color_map { [ 0.0  color rgb  <188/255, 252/255, 0>    ]
                                                            [ 0.25 color rgb <180/255, 252/255, 180/255 >  ]
                                                            [ 0.5  color rgb <252/255, 0.0, 252/255 > ]
                                                            [ 0.75 color rgb <252/255, 252/255, 124/255 > ]
                                                          }
                                                scale <40, 40, 40>


                                                }

                                        }
                                  plane { <0, -1, 0>, 0.6 }
                                  }
#declare but_wing2 = intersection {
                                  object {
                                         but_wing
                                         scale <0.6, 0.6, 1>
                                         rotate <0, 0, 65>
                                         translate <-4,0,0>
                                         pigment { color rgb <0.698039, 0.5, 0.2232529> }

                                        }
                                  plane { <0, -1, 0>, 0.6 }
                           }
#declare but_antleg_part = object {
                                  Disk_X
                                  scale     <0.5, 0.5, 0.5>
                                  translate <0.5, 0, 0>
                                  }
#declare but_antenna_leg = union {
                                 object {
                                        but_antleg_part
                                        scale  <4.14, 0.1, 0.1>
                                        rotate <0, 0, 15>

                                        }
                                 object {
                                        but_antleg_part
                                        scale  <4.6, 0.1, 0.1>
                                        rotate <0, 0, 30>
                                        translate <4, 1.07, 0>
                                        }
                                 object {
                                        but_antleg_part
                                        scale  <4.28, 0.1, 0.1>
                                        rotate <0, 0, 15>
                                        translate <7.15, 3.10, 0>
                                        }
                                 pigment { Red }
                                 scale <1.2, 1.2, 1.2>

                                 }
#declare but_eye  = sphere { <0, 0, 0> 0.5
                           scale <1, 1, 1.3>
                           pigment {
                                   color rgb < 0.2, 0.1, 0.1 >
                                   }
                           finish  {
                                   reflection 0.2
                                   }

                           }
#declare but_segments = union {
                              sphere { <3, 0, 0> 1 }
                              sphere { <2, 0, 0> 1.3 }
                              sphere { <1, 0, 0> 1.5 }
                              sphere { <0, 0, 0> 1.6 }
                              sphere { <-1, 0, 0> 1.5 }
                              sphere { <-2, 0, 0> 1.3 }
                              sphere { <-3, 0, 0> 1 }
                              sphere { <-4, 0, 0> 0.5 }
                              pigment { color rgb < 0.25, 0.145, 0.095 > }
                              finish {
                                     phong 0.3
                                     reflection 0.3
                                     }
                              }
#declare but_body = union  {
                                   object {
                                          but_segments
                                          scale <1, 0.5, 0.5>
                                          }
/* Two eyes */
                                   object {
                                          but_eye
                                          translate <3.3, 0.4,0.3>
                                          }
                                   object {
                                          but_eye
                                          translate <3.3, 0.4,-0.3>
                                          }

/* Two antenna's */
                                   object {
                                          but_antenna_leg
                                          rotate <0, 20, 0>
                                          translate <3, 0, 0>
                                          }
                                   object {
                                          but_antenna_leg
                                          rotate <0, -20, 0>
                                          translate <3, 0, 0>
                                          }
/* Two middle legs */
                                   object {
                                          but_antenna_leg
                                          scale <0.5, 0.5, 0.5>
                                          rotate <0, 30, 180>
                                          translate <2, 0, 0>

                                          }
                                   object {
                                          but_antenna_leg
                                          scale <0.5, 0.5, 0.5>
                                          rotate <0, -30, 180>
                                          translate <2, 0, 0>
                                          }
/* Two hindlegs */
                                   object {
                                          but_antenna_leg
                                          rotate <0, 20, 180>
                                          }
                                   object {
                                          but_antenna_leg
                                          rotate <0, -20, 180>
                                          }
/* Two front legs ( scale them otherwise they appear to be antenna's
   upside down )
*/
                                   object {
                                          but_antenna_leg
                                          scale <0.5, 1 ,1>
                                          rotate <180, 20, 0>
                                          translate <2,0,0>
                                          }
                                   object {
                                          but_antenna_leg
                                          scale <0.5, 1 , 1>
                                          rotate <180, -20, 0>
                                          translate <2, 0, 0>
                                          }



                            }


#declare butterfly = union {
                           /* Pair of wings on one side */
                           union {
                                 object {
                                        but_wing

                                        }
                                 object {
                                        but_wing2
                                        }
                                  rotate <-45, 0, 0>
                                  }

                           /* Pair of wings on the other side */
                           union {
                                 object {
                                        but_wing
                                        }
                                 object {
                                        but_wing2
                                        }
                                  rotate <45, 0, 0>
                                  }
                           object {
                                  but_body
                                  scale <1.9, 1.3, 1.3>
                                  translate <0,-1.5,0.05>
                                  }
                           bounded_by {sphere {<5,5,0>, 18 } }
                           }




//---------------------------------------End ButterFly------------------------------


//------------------------------------------JackInTheBox---------------------------------
#declare Resolution       = 45         // Part of the torus ( in degrees ) which is used as a segment for our spring
#declare NrOfCoils        = 20         // Number of coils are spring consist of
#declare HeightWidthRatio = 1          // The coils height divided by its radius
#declare HeadRadius       = 4 * HeightWidthRatio

#declare NrOfSegments     = 360 / Resolution

#declare CoilSegment = intersection
{
  torus
  {
    2,
    0.4
  }

  prism
  {
    linear_sweep // or conic_sweep for tapering to a point
    linear_spline
    -1,        // height 1
     1,        // height 2
    4,          // number of points
    // the <u,v> points
    < 0.0, 0.0>,
    < 2 *cos( pi * Resolution / 360 ) ,   2 *sin( pi * Resolution / 360  )>,
    < 2 *cos( pi * Resolution / 360 ) ,  -2 *sin( pi * Resolution / 360  )>,
    <0.0 , 0.0 >


  }
  translate < -1,0,0>
  scale < 1/cos( atan2( HeightWidthRatio , ( 2 * pi ) ) ), 1, 1/cos( atan2( HeightWidthRatio , ( 2 * pi ) ) ) >
  rotate < -360 * atan2( HeightWidthRatio , ( 2 * pi ) ) / ( 2 * pi ), 0, 0>
  translate < 1,0,0>

}

#declare Spring = union
{

  #declare CoilCnt = 0

  #while ( CoilCnt < NrOfCoils )

    #declare SegmentCnt = 0
    #while ( SegmentCnt < NrOfSegments )
      object
      {
        CoilSegment
        translate <0, ( SegmentCnt / NrOfSegments + CoilCnt ) * HeightWidthRatio, 0 >
        rotate    <0, -Resolution * SegmentCnt, 0 >

        translate < 20,0,0>
        rotate    <0, 0, ( SegmentCnt / NrOfSegments + CoilCnt )* ( SegmentCnt / NrOfSegments + CoilCnt )/10> // Bend it a little bit to make it more realistic
        translate < -20,0,0>

      }
      #declare SegmentCnt = SegmentCnt + 1
    #end

    #declare CoilCnt = CoilCnt + 1
  #end
}

#declare Hat = lathe {
  cubic_spline
  12, // number of points
  < 0    ,7.1       >,

  < 0.1    ,7       >,
  < 0.5  ,6.75    >,
  < 1    ,6       >,
  < 2    ,5.75    >,

  < 3    ,5       >,
  < 3.3  ,4       >,
  < 3.6  ,3       >,
  < 4    ,2       >,

  < 6    ,1       >,
  < 8    ,0       >,
  < 10   ,0       >

  scale <0.8, 0.8, 0.8>
  rotate <0,0,-NrOfCoils * NrOfCoils/10 -15>
  translate <1,  NrOfCoils * HeightWidthRatio + HeadRadius * 1.5, 0 >
  translate < 20,0,0>
  rotate    <0, 0, NrOfCoils * NrOfCoils/10 > // Bend it a little bit to make it more realistic
  translate < -20,0,0>
}

#declare Eye = union
{

  // create a sphere shape
  sphere
  {
    <0, 0, 0> // center of sphere <X Y Z>
    0.3 * HeadRadius       // radius of sphere
    texture
    {
      pigment { color rgb <0.8,0.8,1 > }
    }
  }
  sphere
  {
    <-0.2*HeadRadius, 0, 0> // center of sphere <X Y Z>
    0.2 * HeadRadius       // radius of sphere
        texture
    {
      pigment { color rgb <0.0,0.0,0.0 > }
    }

  }
  rotate< 0,0,40>


}

#declare Nose = cylinder
{
  0*x,  -1.75*HeadRadius*x,  0.25*HeadRadius
  rotate < 0,0,15>

  translate <0,  ( NrOfCoils ) * HeightWidthRatio + HeadRadius , 0 >
  translate < 20,0,0>
  rotate    <0, 0, NrOfCoils * NrOfCoils/10 > // Bend it a little bit to make it more realistic
  translate < -20,0,0>
}


#declare Head =union
{
  sphere
  {
    <0, 0, 0> // center of sphere <X Y Z>
    HeadRadius       // radius of sphere


  }
  object
  {
    Eye
    rotate<20,0,0>
    translate <-HeadRadius,0,0>
    rotate<0,-20,-8>
  }
  object
  {
    Eye
    rotate<-90,0,0>
    translate <-HeadRadius,0,0>
    rotate<0,20,-8>
  }

  translate <0,  ( NrOfCoils ) * HeightWidthRatio + HeadRadius , 0 >
  translate < 20,0,0>
  rotate    <0, 0, NrOfCoils * NrOfCoils/10 > // Bend it a little bit to make it more realistic
  translate < -20,0,0>

}

#declare BoxSide =
// create a box that extends between the 2 specified points
box
{
  <-1.1*HeadRadius, -1.1*HeadRadius, -0.01>  // one corner position <X1 Y1 Z1>
  < 1.1*HeadRadius, 1.1*HeadRadius,  0.01>  // other corner position <X2 Y2 Z2>
}

#declare Box = union
{
    //--------------------
    union
    {
      object
      {
        BoxSide
        texture
        {
          pigment { color rgb <1, 1, 0> }
        }
      }

      // create a TrueType text shape
      text
      {
        ttf          // font type (only TrueType format for now)
        "timrom.ttf",  // Microsoft Windows-format TrueType font file name
        "P",   // the string to create
        0.2,           // the extrusion depth
        0.1            // offset
        rotate    < 0,180,0>
        translate <0.25,-0.25,0.1>
        scale <1.4*HeadRadius, 1.4*HeadRadius, 1>
        texture
        {

          pigment { color rgb < 0,1,0> }
        }
      }
      translate <0,0,1.1*HeadRadius>


    }
    //--------------------
    union
    {
     object
      {
        BoxSide
        texture
        {
          pigment { color rgb <0, 1, 0> }
        }
      }

      // create a TrueType text shape
      text
      {
        ttf          // font type (only TrueType format for now)
        "timrom.ttf",  // Microsoft Windows-format TrueType font file name
        "O",   // the string to create
        0.2,           // the extrusion depth
        0.1            // offset
        rotate    < 0,180,0>
        translate <0.4,-0.25,0.1>
        scale <1.4*HeadRadius, 1.4*HeadRadius, 1>
        texture
        {

          pigment { color rgb < 1,1,0> }
        }
      }
      translate <0,0,-1.1*HeadRadius>
   }
    //--------------------
    union
    {
      object
      {
        BoxSide
        texture
        {
          pigment { color rgb <1, 1, 0> }
        }
      }

      // create a TrueType text shape
      text
      {
        ttf          // font type (only TrueType format for now)
        "timrom.ttf",  // Microsoft Windows-format TrueType font file name
        "L",   // the string to create
        0.2,           // the extrusion depth
        0.1            // offset
        rotate    < 0,180,0>
        translate <0.25,-0.25,0.1>
        scale <1.4*HeadRadius, 1.4*HeadRadius, 1>
        texture
        {

          pigment { color rgb < 0,1,0> }
        }
      }
      translate <0,0,1.1*HeadRadius>
      rotate <0,90,0>


    }
    //--------------------
    union
    {
     object
      {
        BoxSide
        texture
        {
          pigment { color rgb <0, 1, 0> }
        }
      }

      // create a TrueType text shape
      text
      {
        ttf          // font type (only TrueType format for now)
        "timrom.ttf",  // Microsoft Windows-format TrueType font file name
        "L",   // the string to create
        0.2,           // the extrusion depth
        0.1            // offset
        rotate    < 0,180,0>
        translate <0.4,-0.25,0.1>
        scale <1.4*HeadRadius, 1.4*HeadRadius, 1>
        texture
        {

          pigment { color rgb < 1,1,0> }
        }
      }
      translate <0,0,-1.1*HeadRadius>
      rotate <0,90,0>
   }
   object
   {
      BoxSide
      rotate <45,0,0>
      translate< 0,1.1 * HeadRadius/2, -2*1.1 * HeadRadius>

      texture
      {
        pigment { color rgb <1, 1, 0> }
      }
   }



}



#declare JackInTheBox = union
{

  object
  {
    Spring
    texture
    {
      pigment { color rgb < 1.0, 0, 0 > }
    }
  }
  object
  {
    Hat
    texture
    {
      pigment { color rgb < 0.0, 0, 1.0 > }
    }

  }

 object
  {
    Head
    texture
    {
      pigment { color rgb < 1.0, 0, 0 > }
    }

  }
  object
  {
    Nose
    pigment { color rgb < 1.0, 1.0,0  > }
  }
  object
  {
    Box
  }
  translate<0, 1.1*HeadRadius,0>
  scale <0.1,0.1,0.1>
}




//------------------------------------------End Games-----------------------------
//------------------------------------------Floor---------------------------------
#declare Tile = superellipsoid
{
  <0.2, 0.2>
  translate <0,-1.01,0>
  texture
  {
    SandStone
  }
  scale <2,1,4>

}

#declare TileOffset = 0.05
#declare TileWidth  = 4   + TileOffset
#declare TileLength = 8 + TileOffset
#declare nTiles = 11


#declare Floor1 = union
{

  #declare X = -nTiles
  #declare Y = -nTiles

  #while ( X < nTiles )
    #declare Y = -nTiles
    #while ( Y < nTiles )
      object
      {
        Tile
        translate < X * TileWidth + mod(Y,2)*TileWidth/2 , 0, Y * TileLength >
      }
      #declare Y = Y + 1
    #end
    #declare X = X + 1
  #end
}

#declare Floor =
// CSG intersection, the common space where all the shapes meet
intersection
{
  object
  {
    Floor1
  }


  cylinder
  {
    -1*y,  -0.01*y,
    nTiles*TileWidth

  }


  texture
  {
    SandStone
  }
}


//------------------------------------------End Floor---------------------------------
#if (ShowWall)

// --------------->> Strangely enough this wall isn't always drawn, sometimes I have to
//                   stop render, save my source file, and then render again??????

#declare MaxWallHeight = 4
#declare WallTileWidth  = 4.1
#declare WallTileHeight = 2.9
#declare WallDepth      = 2.1
#declare WallTile = superellipsoid
{
  <0.2, 0.2>
  translate <0,-1.01,0>
  scale <2,3/2,1>

}

#declare CorrosionSize    = 0.3
#declare MinCorrosionSize = 0.5
#declare CorrosionHeight  = WallTileHeight / 5



// In the following part I define a wall with at least one block high. Then add a few layers which are slightly rotated
// in comparisson with the first layer. The wall is amplitude modulated
//
// I start by taking a block randomly cutting out some corners (hey these blocks have been there for ages).
// After that I rotate the block around one of its corners a little bit ( we have to choose the right one otherwise
// stones will collide.
//
// Then finally I lay the stone into the right place IF it is smaller then are sine function.
#declare Wall = union
{
  #declare StoneAngle  = 0
  #declare WallHeight = 0
  #declare nStones = 2 * pi * nTiles*TileWidth / WallTileWidth
  #declare nStonesToLay = nStones/3               // We can only see 1/3 of the circle
  #declare RotAngle = 30

  #while ( WallHeight < MaxWallHeight )      // For WallHeight
    #declare Width = 0
    #while ( Width < nStonesToLay )       // For width
      #declare StoneAngle = 20 * pi *  Width / ( nStones )
      #declare StoneAngle =   ( ( StoneAngle / (2 * pi ) ) - int ( StoneAngle / ( 2* pi ) + 0.5 ) ) * 2 * pi
      #declare Value =   MaxWallHeight * sin ( StoneAngle            ) + MaxWallHeight
      #declare dValue =  MaxWallHeight * sin ( StoneAngle  + 0.001  ) + MaxWallHeight  - Value

      #declare Value = Value / 2
      #if ( Value < 1 )              // Wall is at least one stone heigh
        #declare Value = 1
      #end

      #if ( WallHeight < Value )         // Amplitude modulated wall

        object
        {

          // --------Corrosion Part
          difference  // Cut little pieces from the corners (due to corrosion)
          {

            object
            {
              WallTile
            }

            // Only do the front corners. The rear side of the stones is almost never vissible so its not worth the effort
            object   // Upper right corner
            {
              Chisel
              scale     < MinCorrosionSize + CorrosionSize * rand( Seed3 ), MinCorrosionSize + CorrosionSize * rand( Seed3 ), MinCorrosionSize + CorrosionSize * rand( Seed3 ) >
              rotate    < -30 - 30 * rand( Seed3 ), -25 - 40 * rand( Seed3 ), 0 >
              translate < WallTileWidth/2, 0 + CorrosionHeight * rand( Seed3 ), -WallDepth/2 >
            }
            object  // Lower right corner
            {
              Chisel
              scale     < MinCorrosionSize + CorrosionSize * rand( Seed3 ), MinCorrosionSize + CorrosionSize * rand( Seed3 ), MinCorrosionSize + CorrosionSize * rand( Seed3 ) >
              rotate    < -30 - 30 * rand( Seed3 ) - 90, -25 - 40 * rand( Seed3 ), 0 >
              translate < WallTileWidth/2, -WallTileHeight  - CorrosionHeight * rand( Seed3 ), -WallDepth/2 >


            }
            object  // Lower left corner
            {
              Chisel
              scale     < MinCorrosionSize + CorrosionSize * rand( Seed3 ), MinCorrosionSize + CorrosionSize * rand( Seed3 ), MinCorrosionSize + CorrosionSize * rand( Seed3 ) >
              rotate    < -30 - 30 * rand( Seed3 ) - 90, -25 - 40 * rand( Seed3 ) + 90, 0 >
              translate < -WallTileWidth/2, -WallTileHeight - CorrosionHeight * rand( Seed3 ), -WallDepth/2 >


            }
            object  // Upper left corner
            {
              Chisel
              scale     < MinCorrosionSize + CorrosionSize * rand( Seed3 ), MinCorrosionSize + CorrosionSize * rand( Seed3 ), MinCorrosionSize + CorrosionSize * rand( Seed3 ) >
              rotate    < -30 - 30 * rand( Seed3 ) , -25 - 40 * rand( Seed3 ) + 90, 0 >
              translate < -WallTileWidth/2, 0  + CorrosionHeight * rand( Seed3 ), -WallDepth/2 >


            }


        }


          // ---------Place the stones on our wall
          #if ( ( WallHeight > ( Value - WallTileHeight ) ) & ( WallHeight != 0 ) )      // Only randomly rotate stones that are at the top of the wall (not necessarily top of sine)
            #if ( dValue > 0 )                 // See if sine is increasing or decreasing (to rotate around the right corner)
              #if ( rand(Seed0)>0.5)           // Rotate around closest right corner or furthest right corner
                translate < -WallTileWidth/2, 0, -WallDepth/2>  // Furthest right corner
                rotate <0, rand(Seed0)*RotAngle, 0>
                translate < WallTileWidth/2,  0,  WallDepth/2>  // Furthest right corner
              #else
                translate < -WallTileWidth/2, 0, WallDepth/2>  // Closest right corner
                rotate <0, -rand(Seed0)*RotAngle, 0>
                translate < WallTileWidth/2, 0, -WallDepth/2>  // Closest right corner

              #end
            #else
              #if ( rand(Seed0)>0.5)           // Rotate around closest leftt corner or furthest right corner
                translate < WallTileWidth/2, 0, -WallDepth/2>  // Furthest left corner
                rotate <0, -rand(Seed0)*RotAngle, 0>
                translate < -WallTileWidth/2, 0, WallDepth/2>  // Furthest left corner
              #else
                translate < WallTileWidth/2, 0, WallDepth/2>  // Closest left corner
                rotate <0, rand(Seed0)*RotAngle, 0>
                translate < -WallTileWidth/2, 0, -WallDepth/2>  // Closest left corner

              #end

            #end
          #end

          translate<0, WallHeight * WallTileHeight, nTiles*TileWidth >
          rotate < 0, 360 * ( Width + mod( WallHeight, 2 ) / 2 ) / nStones, 0 > // Rotate every stone (Width) around Y-Axis and add a little rotation for every layer (mod() part)
        }
      #end
      #declare Width = Width + 1
    #end
    #declare WallHeight = WallHeight + 1
  #end

  texture
  {
    SandStone
    /*
    finish
    {
      ambient 0.1


    }
    */
    normal { bumps 0.2 scale 0.2 }
  }

 rotate <0,5,0>
 translate <0,WallTileHeight,0>
 rotate <0,300,0>
}


#end
//------------------------------------------End Wall---------------------------------











//------------------------------------------Magic Circle---------------------------------

#declare Bowl =lathe
{
  cubic_spline
  8, // number of points
  <0,0>,
  <0.1,0.1>,
  <0.2, 0.15>,
  <1,0.2>,
  <1.5,0.3>,
  <1.7,0.5>,
  <2,1>,
  <2.01,2>
}

#declare Table = lathe
{
  linear_spline
  8
  <0,0>,
  <0.1, 0.1>,
  <1,   0.2>,
  <2,   0.3>,
  <3,   1>,
  <2,   1>,
  <1,   1>,
  <0,   1>

  translate <0, -0.3, 0>
  scale <0.5, 1, 0.5>
}


#declare HaloContainer = object
{
  lathe
  {
    cubic_spline
    11, // number of points
    <0,  0>,
    <0.3,  0.1>,
    <2,  1>,
    <3.1,  2>,
    <3.1,  3>,
    <2.1,  4>,
    <1.1,  5>,
    <0.7,  6>,
    <0.2,  7>,
    <0.01,  8>,
    <0,  9>
  }
  hollow
  texture
  {
    pigment
    {
      color rgbt <0.7, 0.7, 1, 1>
    }
  }
}


#declare PillarSub =   cylinder
{
  0*y,  2*y,  0.3
  translate <1,0,0 >
}


#declare PillarCore = difference
{

  cylinder
  {
    0*y,  1*y,  1
  }
  #declare Cnt = 0
  #while ( Cnt < 360 )
  object
  {
    PillarSub
    rotate <0, Cnt, 0>
  }
  #declare Cnt = Cnt + 30
  #end

}

#declare Pillar     = PillarCore
#declare PillarBase = torus
{
  0.7,
  0.6
}


#declare nPillars = 5
#declare VectorPillar = <8,0,0>

#declare PillarCircle = union
{

  #declare Cnt = 0
  #while ( Cnt < nPillars )
  union
  {
    object
    {
      Pillar
      scale < 1, 2, 1 >
    }
    object
    {
      PillarBase
    }
    object
    {
      Table
      translate <0, 2,0>
    }
    texture
    {
      SandStone
    }

    translate VectorPillar
    rotate <0, Cnt*360/nPillars, 0>
  }
  #declare Cnt = Cnt + 1
  #end
}



#declare Pentagram = difference
{
  union
  {
    #declare Cnt = 0
    #while ( Cnt < nPillars )
    object
    {
      cylinder
      {
        vrotate( VectorPillar + <0, 0.1,0.2>, <0,Cnt*360/nPillars,0> ) ,
        vrotate( VectorPillar + <0, -0.1,-0.1>, <0,(Cnt+2)*360/nPillars,0> ),
        0.5
      }
    }
    #declare Cnt = Cnt + 1
    #end
  }

  plane
  {
    -y, // <X Y Z> unit surface normal, vector points "away from surface"
    0 // distance from the origin in the direction of the surface normal
  }

  texture
  {
    pigment { color rgb <1, 0, 0> }
    finish { ambient 0.5 }
  }

}

#declare Smokey = object
{
  HaloContainer
   pigment { color rgbt <1, 1, 1, 1> }
    halo
    {
      emitting
      spherical_mapping
      linear
      turbulence 1
      color_map
      {
        [ 0.0 color rgbt <0, 0, 1,  1> ]
        [ 0.5 color rgbt <1, 1, 1, -1> ]
        [ 1.0 color rgbt <0, 0, 1,  1> ]
      }
      frequency 2
      samples 20
      scale 0.5
    }
    hollow
    rotate <0,0,20>
    scale <4,7,4>
}

#declare PillarMiddle = union
{
  object
  {
    Pillar
    scale < 1, 2, 1 >
  }
  object
  {
    PillarBase
  }
  object
  {
    Bowl
    translate <0,1.9,0>
  }
  texture
  {
    SandStone
  }
}

// Define the glowing globe
#declare Globe = union
{
  light_source
  {
    <0,3.2,0> // light's position (translated below)
    color red 0.9  green 0.85  blue 1.0  // light's color
    fade_power 3
    fade_distance 20

    looks_like
    {

      // create a sphere shape
      sphere
      {
        <0, 0, 0> // center of sphere <X Y Z>
        1     // radius of sphere
        texture
        {

          pigment { color rgbf <1, 1, 1, 0.3> }

          finish { ambient 1 }
        }

      }
    }

  }

  light_source
  {
    <0,3.2,0> // light's position (translated below)
    color red 1.0  green 1.0  blue 1.0  // light's color
    fade_power 3
    fade_distance 10
    atmospheric_attenuation off

  }
}

#declare MagicCircle1 = union
{

  #if ( ShowPillars )
    object
    {
      PillarCircle
      texture
      {
        SandStone
      }
    }

    object
    {
      PillarMiddle
    }
  #end
  #if ( ShowGlobe )

    object
    {
      Globe
      translate <0,1,0>
    }
  #end
  #if ( ShowSmokey )
    object
    {
      Smokey
      translate <0,2,0>
    }
  #end
  #if ( ShowPenta )
    object
    {
      Pentagram
    }
  #end
}

// Create the larger (lowest circle)
#declare CutOutFloorLarge = intersection
{
  object
  {
    Floor
  }
  union
  {
    cylinder
    {
      -1*y,  2*y,  vlength( VectorPillar ) + 3
      // open
    }
    torus
    {
      vlength( VectorPillar ) + 3,
      1
      translate -y
    }

  }

}

// Create the smaller circle (The one with the pentagram on it)
#declare CutOutFloorSmall = intersection
{
  object
  {
    Floor
  }
  union
  {
    cylinder
    {
      -1*y,  2*y,  vlength( VectorPillar ) + 1
      // open
    }
    torus
    {
      vlength( VectorPillar ) + 1,
      1
      translate -y
    }


  }

}



#declare MagicCircle = union
{
  object
  {
    MagicCircle1
    translate <0, 2, 0>
  }

  union
  {
    object
    {
      CutOutFloorLarge
      rotate< 0, 30, 0>
      translate 1*y
    }
    object
    {
      CutOutFloorSmall
      rotate < 0, 60, 0 >
      translate 2*y

    }

    texture
    {
      SandStone
    }
  }


}



//--------------------------------------------Moon---------------------------------------

#declare MoonHaloContainer = object
{

  sphere
  {
    <0,0,0>
    1

    color rgbt <1, 1, 1, 1>
    hollow
    scale <4,1,1>

  }
}

#declare MoonItSelf = object
{

  // create a regular point light source
  light_source
  {
    0*x // light's position (translated below)
    color rgb <255/255,232/255,189/255>
    translate <0, 0, 0>

    fade_distance     100

    fade_power 3

    looks_like
    {
      object
      {
        // create a sphere shape
        sphere
        {
          <0, 0, 0> // center of sphere <X Y Z>
          1       // radius of sphere

          pigment { rgb <255/255,232/255,189/255> }
          texture
          {
             pigment
             {
               gradient <1,0.5,0.5>

               turbulence 2
               color_map
               {
                 [ 0     color rgbt  <255/255,232/255,189/255, 0>]
                 [ 0.295 color rgbt  <255/255,232/255,189/255, 0>]
                 [ 0.295 color rgbt <0.5, 0.5, 0.45, 0.2> ]
                 [ 0.4   color rgbt <0.35, 0.3, 0.4, 0.2> ]
                 [ 0.5   color rgbt <0.41, 0.4, 0.41, 0.2> ]
                 [ 0.6   color rgbt <0.35, 0.3, 0.4, 0.2> ]
                 [ 0.705 color rgbt <0.5, 0.5, 0.45, 0.2> ]
                 [ 0.705 color rgbt  <255/255,232/255,189/255, 0>]
                 [ 1     color rgbt  <255/255,232/255,189/255,0 >]
               }
               frequency 1

             }
             finish { ambient 0.8 }
          }
        }
      }
    }
  }
}

#declare MoonCloud = object
{
   MoonHaloContainer
   pigment { color rgbt <1, 1, 1, 1> }
    halo
    {
      dust
      spherical_mapping
      linear
      attenuating
      turbulence 2
      color_map
      {
        [ 0.0 color rgbt <0.35, 0.35, 0.5,  1> ]
        [ 0.05 color rgbt <0.175, 0.175, 0.25,  0> ]
        [ 0.5 color rgbt <1, 1, 1, -1> ]
        [ 0.95 color rgbt <0.175, 0.175, 0.25,  0> ]
        [ 1.0 color rgbt <0.35, 0.35, 0.5,  1> ]

      }
      frequency 2
      samples 20
      scale <0.7,0.2,0.2>
    }
    hollow
    scale <4,2,2>
    translate <0.8,-0.7,-2>
}



#declare MoonWithCloud = union
{
  object
  {
    MoonCloud

  }

  object
  {
    MoonItSelf

  }
}
//--------------------------------------------End Moon---------------------------------------

//-------------------------------------------Picture of me-------------------------------

#declare Painting1 = union

{
  box
  {
    <-2, 4, 0.1>  // one corner position <X1 Y1 Z1>
    < 2,  -4,  -0.1>  // other corner position <X2 Y2 Z2>
    pigment
    {
      image_map
      {
        tga "ronc.tga"
        interpolate 2
      }
      translate <-0.5,-0.5,0>
      scale <4, 8, 1>
    }

  }
}

#declare Frame = difference
{
  superellipsoid
  {
    <0.3,0.3>
    scale <4,8,0.3>
  }
  superellipsoid
  {
    <0.3,0.3>
    scale <4,8,0.3>
    scale <0.8,0.8,2>
  }
  texture
  {
    DMFWood6
  }
  scale <0.6,0.6,0.6>
}

#declare Painting = union
{
  object
  {
    Painting1
  }
  object
  {
    Frame
  }
}

//-------------------------------------------End Picture of me---------------------------

//--------------------------------------------Torch---------------------------------------
#declare TorchOffset = 2.8
#declare TorchHolder = lathe
{
  cubic_spline
  12,
  <0   ,0    >,
  <1   ,0.5  >,
  <2   ,3.6  >,
  <3   ,4    >,
  <4   ,4.8  >,
  <4.2 ,5.5  >,
  <4   ,6.3  >,
  <3   ,7    >,
  <4   ,10   >,
  <5   ,10.8 >,
  <6   ,11.4 >,
  <7   ,14   >
  scale <0.15, 8/14, 0.15>
  translate <0,   -5, 0>
  hollow
}




#declare TorchFlame = union
{
  light_source
  {
    0*x // light's position (translated below)
    color red 0.8  green 0.4  blue 0  // light's color
    fade_distance     16
    fade_power 3
    looks_like
    {

      sphere
      {
        0, 1
        pigment { color rgbt <1, 1, 1, 1> }
        halo
        {
          emitting
          spherical_mapping
          linear
          turbulence 1
          color_map
          {
            [ 0.0 color rgbt <1, 0, 0,  1> ]
            [ 0.5 color rgbt <1, 1, 0, -1> ]
            [ 1.0 color rgbt <1, 0, 0,  1> ]
          }
          frequency 1.2
          samples 20
          scale < 0.9,0.7, 0.9>
        }
        hollow
        scale <1, 4, 1>
      }
      scale<1.2,1.6,1.2>
    }
    translate <0, 3.6, 0>
  }
  object
  {
    TorchHolder
    texture
    {
      Bright_Bronze
    }
  }
  translate <0,4,0>
}



//--------------------------------------------End Torch---------------------------------------


union
{

  #if ( ShowFloor )
    object
    {
      Floor
    }
    object
    {
      MagicCircle

    }
  #end
  #if ( ShowMountains )
    object
    {
      Mountains
    }
  #end
  #if (ShowWall)
    object
    {
      Wall
    }
 #end







  #if ( ShowMoon )
    object
    {
      MoonWithCloud
      scale<500,500,500>
      translate <-200,200,10000>
      rotate <0,-53,0>
    }
  #end

  #if ( ShowGames )

   object
    {
      JackInTheBox
      rotate< 0, -90,0>
      translate VectorPillar
      translate 3 * y
      translate <0, 2, 0>
    }
    object
    {
      TorchFlame
      scale <0.5,0.5,0.5>
      rotate< 0, -90,0>
      translate VectorPillar

      translate 3 * y
      translate <0, 2, 0>
      rotate <0, 360/5,0>
    }

    object
    {
      butterfly
      scale <0.2,0.2,0.2>
      rotate< 0, 35+180,-30>
      translate VectorPillar

      translate 4.5 * y
      translate <0, 2, 0>
      rotate <0, 2*360/5,0>
      finish { ambient 0.8 }
    }
    object
    {
      Plant
      scale <0.2,0.2,0.2>
      rotate< 0, -40 - 3*360/5,0>
      translate VectorPillar

      translate 6 * y
      translate <0, 2, 0>
      rotate <0, 3*360/5,0>
      finish { ambient 0.8 }
    }

    object
    {
      Painting
      scale <0.7,0.7,0.7>
      rotate< 30, -40 - 4*360/5,0>
      translate VectorPillar

      translate 6 * y
      translate <0, 2, 0>
      rotate <0, 4*360/5,0>
      finish { ambient 0.8 }
    }

  #end



 rotate <0,40,0>



}

  sky_sphere {
    pigment {
      gradient x
      color_map {
        [0 color <0.1,0.0,0.0>]
        [1 color <0.0, 0.0, 0.1>]
      }
      scale 2

    }
  }

  sphere
  {
    <0,0,0>
    2000
    translate<0,-2000,0>
    texture
    {
      pigment { color rgb<0.10, 0.10, 0.12> }
    }
  }
  // create a point "spotlight" (conical directed) light source
  #declare LightHeight = 6000
  #declare Angle = atan2( 150 , LightHeight )

  light_source
  {
    0*x                     // light's position (translated below)
    color rgb <1,1,1>       // light's color
    spotlight               // this kind of light source

    translate <-50, LightHeight,  50  > // <x y z> position of light


    point_at <40, 800, 500>  // position of light
    radius 70                // hotspot (inner, in degrees)
    tightness 10            // tightness of falloff (1...100) lower is softer, higher is tighter
    falloff 5               // intensity falloff radius (outer, in degrees)
    atmospheric_attenuation off
    fade_distance     10000
    fade_power 3

    rotate <0,-45,0>
  }


#if (ShowFog)
    fog {
      fog_type Ground_Fog
      fog_offset 0.3
      fog_alt 2
      distance 1.75 * nTiles * TileWidth + 50  // Camera position + almost whole magic circle clear
      turbulence 6
      colour rgbt<0.3, 0.3, 0.35, 0.3>
    }

   fog
   {
     fog_type Ground_Fog
     fog_offset 8
     fog_alt 20
     distance 3*nTiles*TileWidth + 50
     turbulence 20
     colour rgbt<0.10, 0.17, 0.13, 0.02>

   }

#end

//------------------------------------------Mountains----------------------------

#declare Mountain = intersection
{
  julia_fractal
  {
    1 * y
    quaternion
    sqr
    max_iteration 10
    precision 80
    slice <0,0,0,2>,0
    rotate< 90,0,0>
    scale <10,12,10>


  }
  sphere { <0,0,0>,1000 }
  texture
  {
    pigment { color rgb <85/255, 194/255, 169/255> }
  }

}

#declare Mountains = union
{
  object
  {
    Mountain
    rotate <0,30,0>
    scale <10,5,10>
    translate <40,0,300>
  }

  object
  {
    Mountain
    scale <10,7,10>
    translate <200,0,400>
  }
  object
  {
    Mountain
    rotate <0, -90, 0>
    scale <40,1.5,20>
    translate <-120,-10,225>
    pigment { color rgb <85/255/2, 194/255/2, 169/255/2> }
  }
//  rotate <0,-40,0>
}

object
{
  Mountains
}

