// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "shapes.inc"
#include "shapesq.inc"
#include "golds.inc"
#include "flames.inc"

#declare cam_loc            = <-1.2, .4, -10.0>
#declare light_loc          = <0.8,-0.1,-4>
#declare lookat             = <0,0,0>
#declare sky_vect           = y
#declare flare_type         = "sparkle4"
#declare flare_scale_factor = .2
#declare flare_amount       = .4
#declare source_color       = Yellow
#declare show_flare_source  = no
#include "lnsflare.inc"

#declare True = 1
#declare False = 0

global_settings { assumed_gamma 1.0 }

camera
{
  location  cam_loc          // position of camera <X Y Z>
  direction 2.0*z            // which way are we looking <X Y Z> & zoom
  sky       sky_vect         // rarely used
  up        y                // which way is +up <X Y Z>
  right     4/3*x            // which way is +right <X Y Z> and aspect ratio
  look_at   <0.0, 0.0,  0.0> // point center of view at this point <X Y Z>
}

light_source{ <0.8,0,-4> color rgb<1,1,.6> }
light_source{ <0,1,0> color rgb<1,1,.6> shadowless }

#declare Witch_Wood =
      texture {
          pigment { wood
                  color_map { [ 0.30 color rgb<.4,.1,.01> ]
                              [ 0.99 color Brown ]
                              [ 1.00 color LimeGreen ] }
                  turbulence 2.3 }
          normal { wrinkles 1 scale .1 }
          finish { ambient .1
                   diffuse .3
                   crand .03
                   phong .2
                   phong_size 20 }
              }

#declare Normal_Wood =
      texture {
          pigment { wood
                  color_map { [ 0.20 color LightWood ]
                              [ 0.60 color DarkTan ]
                              [ 1.00 color CoolCopper ] }
                  turbulence .2 }
          normal { wrinkles 1 scale .1 }
          finish { ambient .1
                   diffuse .3 }
              }

#declare palo =
cylinder { 0*y, 2*y, .06                                // FIREWOOD
            texture{ Normal_Wood } }

#declare mirror =
union{                                                  // MIRROR (DOH!)
      disc{ <0,0,-.01>, z, 1
              pigment { color Black }
              normal { ripples 1 scale<30,30,.15> frequency .05 }
              finish { ambient 0 diffuse 0 reflection 1 }
            }

      torus{ 1.1 ,.1
             texture { T_Gold_1B }
             rotate 90*x }
}

#declare olla =
union{

       sphere { 0*x, 1.5                                // GREEN STEAM
           pigment { color rgbt <1, 1, 1, 1> }
           halo {
           emitting
           spherical_mapping
           linear
           turbulence 4
           color_map { [ 0.0 color rgbt <1, 1, 1,  1> ]
                       [ 0.9 color SpringGreen transmit -1 ]
                       [ 1.0 color rgbt <1, 1, 1,  1> ] }
           frequency 2
           samples 20
           scale 1.2
              }
           hollow
       }

       sphere{ 0*x, 1.5                             // FIRE
           pigment { color rgbt <1, 1, 1, 1> }
         halo {
           emitting
           spherical_mapping
           linear
           turbulence 1.5
           color_map { [ 0.0 color rgbt <1, 0, 0,  1> ]
                       [ 0.5 color rgbt <1, 1, 0, -1> ]
                       [ 1.0 color rgbt <1, 0, 0,  1> ] }
           frequency 2
           samples 20
           scale .6
              }
           hollow
           scale <2,.6,2>
           translate -2.5*y
       }

union{
object{ palo rotate <10,85,85> translate -2.9*y}                // FIREWOOD
object{ palo rotate <85,10,85> translate -2.9*y}
object{ palo rotate <85,85,10> translate -3.0*y}
rotate 90*y
}
union{
object{ palo rotate <10,85,85> translate -3.0*y}
object{ palo rotate <85,10,85> translate -3.1*y}
object{ palo rotate <85,85,10> translate -3.2*y}
rotate 120*y
}
union{
object{ palo rotate <10,85,85> translate -2.9*y}
object{ palo rotate <85,10,85> translate -3.0*y}
object{ palo rotate <85,85,10> translate -3.1*y}
rotate 150*y
}
union{
object{ palo rotate <10,85,85> translate -2.9*y}
object{ palo rotate <85,10,85> translate -3.0*y}
object{ palo rotate <85,85,10> translate -3.1*y}
rotate 180*y
}
union{
object{ palo rotate <10,85,85> translate -2.9*y}
object{ palo rotate <85,10,85> translate -3.0*y}
object{ palo rotate <85,85,10> translate -3.1*y}
rotate 210*y
}

       plane{ y, .75                                // GREEN MAGIC LIQUID
          pigment{ color SpringGreen }
          normal { ripples .7 scale .05 frequency .05 }
       clipped_by{
          cone{ <0,0.3,0>, 0.5, <0,.8,0>, .95 open } }
          translate -1*y
          scale 1.5
          }

       merge{
             cone{ <0,0.3,0>, 0.5, <0,.8,0>, .95 open }
             sphere{ <0,0,0>, 1 hollow
                     clipped_by{
                     plane{ y, .8 } } }
             texture {                              // POT
                pigment{ color rgb<.12,.18,.18> }
                normal { bumps 1 scale .2 }
                finish { ambient .4
                         diffuse .1
                         metallic 1
                         crand .15
                         reflection 0
                         phong .3
                         phong_size 20 }
                      }
                     translate <0,-1.0,0>
                     scale 1.5
              }

       cylinder { -1*y, 2*y, .1                 // POLE
                texture{ Witch_Wood }
                rotate -30*z
                translate 1*x }

}

#declare paredes =
union{
      box { <-4,-2,-10>, <4,2,7>                // WALLS
        texture {
         pigment{ brick
                  pigment{ bozo
                  color_map { [ 0.5 DimGray ]
                              [ 1.0 Gray ] }
                  turbulence .9 }
                  pigment{ bozo
                  color_map { [ 0.5 Firebrick ]
                              [ 1.0 Black ] }
                  turbulence .9 }
                  scale .1
                }
          normal { wrinkles 1 scale .01 }
          finish { ambient .1
                   diffuse .1
                   crand .09 }
              }
           hollow
        }

      plane{ y,  1.99                           // CEILING
        texture{
          pigment{ bozo
              color_map { [ 0.5 DimGray ]
                          [ 1.0 Gray ] }
              turbulence .9 }
          normal { wrinkles 1 scale .05 }
          finish { ambient .2
                   diffuse .3
                   crand .05 }
              }
              clipped_by{ plane{ z, 7 } }
         }

      plane{ y,  -1.97                          // FLOOR
        texture{
          pigment{ bozo
              color_map { [ 0.7 DimGray ]
                          [ 1.0 Gray ] }
              turbulence .9 }
          normal { bumps 1 scale .05 }
          finish { ambient .2
                   diffuse .3
                   crand .2 }
              }
              clipped_by{ plane{ z, 7 } }
         }
   hollow
}

#declare tabla =
box { <0,0,0>, <1,.1,1> }

#declare column =
 sor { 16,
     <0.750,-5.0>,
     <0.770,-4.0>,
     <0.800,-3.0>,
     <0.945,-2.2>,
     <0.950,-1.8>,
     <0.800,-1.0>,
     <0.900,-0.5>,
     <1.000, 0.0>,
     <0.900, 0.5>,
     <0.800, 1.0>,
     <0.950, 1.8>,
     <0.945, 2.2>,
     <0.800, 3.0>,
     <0.770, 4.0>,
     <0.750, 5.0>,
     <0.000, 5.5>
     sturm
     texture{ Normal_Wood }
}

#declare mesa =
union {
      object{ tabla scale <5,1,3> translate <-1.5,-.8,-1.5> }   // TABLE
      cylinder { -2*y, -.8*y, .1 translate < 3.2,0, 1.2> }
      cylinder { -2*y, -.8*y, .1 translate < 3.2,0,-1.2> }
      cylinder { -2*y, -.8*y, .1 translate <-1.2,0, 1.2> }
      cylinder { -2*y, -.8*y, .1 translate <-1.2,0,-1.2> }
      texture { Witch_Wood }
      translate -4.5*z
      }

#declare hoja =
object {                                                    // PIECE OF PAPER
#declare object_axis1 = 0
#declare object_axis2 = y*2
#declare bend_angle = -20
#declare bend_smoothness = 300
#declare bend_object =
     box{ <0,0,0> <.6,.8,.001>
          pigment {
              image_map { tga "spell.tga" }                 // I HAD to use an image
                    scale <.7,1.1,1>                        // map. Otherwise the "bend.inc"
                    translate <0,-.3,0> }                   // messed up the text...
              rotate 90*y
              scale 2.5
              translate lookat
              }
#include "bend.inc"
}

#declare tintero =
union{
merge{                                                  // INK WELL
  cone { <0,0,0>, 1.1, <0,1,0>, .5  }
  cone { <0,0,0>, 0, <0,1,0>, 1 open }
  texture { Soft_Silver }
  }
merge{
  cone { <0,0,0>, 0.99, <0,1,0>, .49  }
  cone { <0,0,0>, 0, <0,0.9,0>, .89 }
  pigment { Red }
   finish { ambient .5
            diffuse .2
            reflection .0001 }
  }
}

#declare ink_path_Texture =
texture{
   pigment{ Red filter .3 }
   normal { ripples 1 scale .05 }
   finish { ambient .5
            diffuse .2
            reflection .0001 }
       }
#declare Point_Texture = texture{ ink_path_Texture }

#declare Stack =
object { Piriform sturm hollow
texture {pigment {color Clear } finish  {ambient 1 diffuse 0} }
       }

#declare vela =
union{                                                  // CANDLE
      blob{ threshold .5
            cylinder{ 0*y, .7*y, .06, .9 }
            pigment{ Red } }
      cylinder{ 0*y, .8*y, .005 pigment{ gradient x+y } }
      light_source{
      0*x Yellow
      fade_distance 3
      fade_power    60
      looks_like {
      object { Stack halo{Flame_A1}
               scale <.1,.09,.1>
               rotate -90*z
               translate .86*y} }
      }}

#declare Libros1 =                              // ROWS OF BOOKS
union{                                          // I used "union" because with
  object {                                      // "difference" and "bounded_by"
      #declare RowLength=4.5                    // the text wasn't readable
      #declare VariThick=.5
      #declare NumBooks=45
      #declare StackStyle=0
      #include "books.inc"
      rotate 90*y
      }

  text{ ttf "c:\windows\fonts\blackadd.ttf",
        "Learning",
        5, 0
        pigment{ Red }
        scale <.14,.13,.13>
        translate <0.08,.5,-4.51>
        }
  text{ ttf "c:\windows\fonts\blackadd.ttf",
        " Magic",
        5, 0
        pigment{ Red }
        scale <.14,.13,.13>
        translate <0.08,.35,-4.51>
        }
  text{ ttf "c:\windows\fonts\blackadd.ttf",
        "in 21 days!",
        5, 0
        pigment{ Red }
        scale .14
        translate <0.01,.10,-4.51>
        }
scale 1.05
translate <3,.07,4.8>
}

#declare Libros2 =
union{
  object {
     #declare RowLength=4
     #declare VariThick=.1
     #declare NumBooks=40
     #declare StackStyle=0
     #include "books.inc"
     rotate 90*y
     }

  object
  {
      #declare fontMode = 3
      #declare Message = "Tricks of the"
      #declare Message2 = "Magic Gurus"
      #declare font_path = "c:\windows\fonts\garamond.ttf"
      #declare Rad = 10
      #declare Spacing = 2
      #declare SpaceWidth = 0.2
      #declare Thick = 5
      #declare Tilt = 0
      #declare Gap = 20
      #include "font.inc"
      pigment{ Black }
      scale .016
      translate <.22,.45,-4.08>
      }
scale 1.05
translate <2.85,1.07,4>
}

#declare sombrero =
union{
   object {
   #declare object_axis1 = 0
   #declare object_axis2 = y*2
   #declare bend_angle = -45
   #declare bend_smoothness = 0
   #declare bend_object =
      difference{
         object { Witch_Hat
                pigment{ color rgb<.12,.18,.18> }           // HAT
                normal { wrinkles 1 scale .02 }
                finish { ambient .7 diffuse .3 }
         scale <.5,1,.5> rotate 180*x translate lookat
         clipped_by { cylinder { -2*y, 2*y, .6 } } }

        cone{ <0,0,0>, .25 <0,.38,0>, .15
              open
              pigment { CornflowerBlue } }
        }
        #include "bend.inc"
        hollow
       }
   blob{ threshold .4
         cylinder{ <0,0,0> ,<1,0,0> , .1, 1 }
         cylinder{ <1,0,0> ,<1,-1,0>, .1, 1 }
         cylinder{ <1,-1,0>,<0,-1,0>, .1, 1 }
         cylinder{ <0,-1,0>,<0,0,0> , .1, 1 }
         texture{ Soft_Silver }
         scale .2
         rotate 85*y
         rotate 22*z
         translate <0.11,.42,0.1>
         }
}

#declare pata =
union{
   cylinder { 0*y, .15*y, .005 rotate -45*z translate  .05*x }
   cylinder { 0*y, .15*y, .005 rotate  45*z translate  .25*x }
   cylinder { 0*y, .15*y, .005 rotate  45*z translate -.05*x }
   cylinder { 0*y, .15*y, .005 rotate -45*z translate -.25*x }
   }

#declare sp =
union{
   union {
      sphere { 0*x, .1 scale<1,.3,1> }
      object { pata rotate  45*y }
      object { pata rotate  15*y }
      object { pata rotate -15*y }
      object { pata rotate -45*y }
      pigment{ DarkSlateGray }
      }
   union {
      sphere { 0*x, .02 translate<-.05,.03,-.08> }
      sphere { 0*x, .02 translate<0.05,.03,-.08> }
      pigment { Red }
      finish { ambient 1 diffuse 0 reflection 1 refraction 1 }
      }
      no_shadow
  }

#declare spider_web =
object{ #declare Arms   = 30
        #declare Rings  = 6
        #declare Spider = True
        #declare Centered = True
        #declare Extension = 5
        #include "web.inc"
        scale .5
        rotate<-45,-45,0>
        translate <-3.4,1.4,6.4>
         }

#declare varita_magica =
cylinder{ 0*x, 0.9*x, .015
   texture { Ruby_Glass }
   }

#declare frasco =
sor{ 10,
     <0.1, -1>,
     <1.1, 0>,
     <1.8, 1>,
     <2.0, 2>,
     <1.8, 3>,
     <1.1, 4>,
     <1.0, 5>,
     <.96, 6>,
     <.96, 7>,
     <2.0, 8>
     sturm
     }

#declare librero =
union{
   object { tabla scale <1.5,.8,5> translate <2.5,0,0> texture{ Normal_Wood } }
   object { tabla scale <1.5,.8,5> translate <2.5,1,0> texture{ Normal_Wood } }
   object { column scale .11 translate <2.6,0.5,.1> }
   object { column scale .11 translate <2.6,0.5,4.9> }
}

#declare especiero =
union{
   object { tabla scale <5,.8,1> translate <-4,1,6> texture{ DMFWood2 } }
   object { frasco scale <.04,.065,.04> translate <-3.8,1,6.5> texture{ Dark_Green_Glass } }
   object { frasco scale <.05,.08,.07>  translate <-3.4,1,6.6> texture{ Green_Glass } }
   object { frasco scale <.05,.1,.05>   translate <-3.2,1,6.4> texture{ Glass2 } }
   object { frasco scale <.06,.065,.06> translate <-3.0,1,6.3> texture{ Vicks_Bottle_Glass } }
   object { frasco scale <.05,.1,.05>   translate <-2.6,1,6.4> texture{ Glass } }
   object { frasco scale <.05,.08,.07>  translate <-2.4,1,6.6> texture{ Green_Glass } }
   object { frasco scale <.1,.05,.1>    translate <-2.0,1,6.5> texture{ Orange_Glass } }
   object { frasco scale <.1,.07,.1>    translate <-1.3,1,6.4> texture{ Ruby_Glass } }
   object { frasco scale <.08,.03,.1>   translate <-1.0,1,6.5> texture{ NBbeerbottle } }
   object { frasco scale <.1,.1,.1>     translate <-0.4,1,6.4> texture{ NBglass } }
   object { frasco scale <.05,.1,.05>   translate < 0.0,1,6.3> texture{ NBoldglass } }
   object { frasco scale <.05,.12,.05>  translate < 0.3,1,6.5> texture{ Glass3 } }
   object { frasco scale <.05,.05,.07>  translate < 0.7,1,6.4> texture{ Yellow_Glass } }
   object { frasco scale <.04,.08,.04>  translate < 0.9,1,6.6> texture{ NBwinebottle } }
scale <.65,.8,.8>
}

#declare cerradura =
difference{
    superellipsoid { <.7,.3> 
    pigment { agate
            color_map{ [0.1 Red ]
                       [0.4 Light_Purple ]
                       [1.0 Red ]} }
    finish { ambient 1 diffuse 0 metallic 1 ior 1.5 refraction 1 }
    }
    cylinder { -1*z, .5*z, .5
    pigment { agate
            color_map{ [0.1 Med_Purple ]
                       [0.4 Black ]
                       [1.0 Med_Purple ]} }
    finish { ambient 1 diffuse 0 metallic 1 ior 1.5 refraction 1 }
    } 
}

#declare jaula =
union{
  union{
   object { tabla scale <5,.8,1> translate <-4.1,0.0,6> }
   object { tabla scale <5,.8,1> translate <-4.1,0.8,6> }
   cylinder{ -4.0*x, 0.8*x , .03 translate < 0.0,0.05,6.1> }
   cylinder{ -4.0*x, 0.8*x , .03 translate < 0.0,0.40,6.1> }
   cylinder{ -4.0*x, 0.8*x , .03 translate < 0.0,0.77,6.1> }
   cylinder{  6.1*z, 7.0*z , .03 translate <-4.0,0.56,0.0> }
   cylinder{  6.1*z, 7.0*z , .03 translate <-4.0,0.28,0.0> }
   cylinder{  6.1*z, 7.0*z , .03 translate < 0.8,0.56,0.0> }
   cylinder{  6.1*z, 7.0*z , .03 translate < 0.8,0.28,0.0> }
   cylinder{ 0*y, .77*y , .03 translate <-4.0,0,6.8> }
   cylinder{ 0*y, .77*y , .03 translate <-4.0,0,6.4> }
   cylinder{ 0*y, .77*y , .03 translate <-4.0,0,6.1> }
   cylinder{ 0*y, .77*y , .03 translate <-3.6,0,6.1> }
   cylinder{ 0*y, .77*y , .03 translate <-3.2,0,6.1> }
   cylinder{ 0*y, .77*y , .03 translate <-2.8,0,6.1> }
   cylinder{ 0*y, .77*y , .03 translate <-2.4,0,6.1> }
   cylinder{ 0*y, .77*y , .03 translate <-2.0,0,6.1> }
   cylinder{ 0*y, .77*y , .03 translate <-1.6,0,6.1> }
   cylinder{ 0*y, .77*y , .03 translate <-1.2,0,6.1> }
   cylinder{ 0*y, .77*y , .03 translate <-0.8,0,6.1> }
   cylinder{ 0*y, .77*y , .03 translate <-0.4,0,6.1> }
   cylinder{ 0*y, .77*y , .03 translate < 0.0,0,6.1> }
   cylinder{ 0*y, .77*y , .03 translate < 0.4,0,6.1> }
   cylinder{ 0*y, .77*y , .03 translate < 0.8,0,6.1> }
   cylinder{ 0*y, .77*y , .03 translate < 0.8,0,6.4> }
   cylinder{ 0*y, .77*y , .03 translate < 0.8,0,6.8> }
   object{ cerradura scale .2 translate<-1.4,.8,6> }
   texture { Soft_Silver }
   }
   object { frasco scale <.07,.1,.1> translate <-3.8,0,6.5> texture{ Green_Glass } }
   object { frasco scale <.07,.1,.1> translate <-3.3,0,6.5> texture{ Green_Glass } }
   object { frasco scale <.07,.1,.1> translate <-2.8,0,6.5> texture{ Ruby_Glass } }
   object { frasco scale <.07,.1,.1> translate <-2.3,0,6.5> texture{ Ruby_Glass } }
   object { frasco scale <.07,.1,.1> translate <-1.8,0,6.5> texture{ Vicks_Bottle_Glass } }
   object { frasco scale <.07,.1,.1> translate <-1.3,0,6.5> texture{ Vicks_Bottle_Glass } }
   object { frasco scale <.07,.1,.1> translate <-0.8,0,6.5> texture{ NBglass } }
   object { frasco scale <.07,.1,.1> translate <-0.3,0,6.5> texture{ Yellow_Glass } }
   object { frasco scale <.07,.1,.1> translate < 0.2,0,6.5> texture{ Orange_Glass } }
   object { frasco scale <.07,.1,.1> translate < 0.7,0,6.5> texture{ Orange_Glass } }
scale <.65,.8,.8>
}

////////////////////////////////////////////////////////////////

#include "ink.inc"

object{ paredes }
object{ mirror scale<1,1.5,1> translate<2,0,6.99> }
object{ olla rotate 180*y translate <-4.5,-1,4.5> scale .5 }
object{ mesa }
object{ tintero
        scale <.1,.2,.1>
        translate <0.3,-0.7,-5>
        }
object{ hoja
        rotate -90*y
        rotate 96*x
        translate <-1.5,-0.82,-7>
        scale .8
        }
object { ink_path }
object { Points }
object { especiero }
object { jaula }
object{ vela
        translate <0.8,-0.9,-4>
        }
object { librero }
object { Libros1 }
object { Libros2 }
object { sombrero scale .9*y rotate 160*y translate <1.0,-0.71,-4.9> }
object { varita_magica rotate 55*y rotate -5*x translate <0.4,-0.63,-5> }
object { sp scale .5 translate<3,-0.69,-5.1> rotate 30*y }
cylinder { 0*y, 1*y, .005 pigment { White filter .9 } finish{ ambient 1 diffuse 1 }
           scale <.01,15,.01> translate <-1.19, .41, -9.8> }
object { sp scale .015 rotate 180*z rotate 90*y translate <-1.19, .41, -9.8> }
object { spider_web }
object { frasco scale <.1,.1,.1>    translate <2.4,-0.63,-3.0> texture{ Vicks_Bottle_Glass } }
object { frasco scale <.05,.1,.05>  translate <3.0,-0.63,-4.9> texture{ Glass } }
object { frasco scale <.05,.08,.07> translate <2.1,-0.63,-4.0> texture{ Green_Glass } }
object { frasco scale <.1,.05,.1>   translate <2.0,-0.63,-4.8> texture{ Orange_Glass } }
object { frasco scale <.1,.07,.1>   translate <2.8,-0.63,-4.6> texture{ Ruby_Glass } }
