#include "metals.inc"

//-----------------------------------------//
// Desk Nameplate: "Judge Harold T. Stone" //
//-----------------------------------------//
#declare nameplate_thickness = 0.2

#declare nameplate =
union {
    union {
        union {
            box {
                <-4, -0.95, 0>, <4, 0.95, 0.4*nameplate_thickness>
                pigment { color Gray10 }
            }
            union {
                text {
                    ttf "crystal.ttf", "JUDGE", 0.4*nameplate_thickness, 0
                    rotate 180*y
                    translate 1.4*x
                    scale <0.9, 1, 1>
                    translate <0, 0.1, 0.6*nameplate_thickness>
                }
                text {
                    ttf "crystal.ttf", "HAROLD T. STONE", 0.4*nameplate_thickness, 0
                    rotate 180*y
                    translate 3.75*x
                    scale <0.9, 1, 1>
                    translate <0, -0.75, 0.6*nameplate_thickness>
                }
                pigment { color White }
            }
        }
        union {
            intersection {
                cylinder { -3.95*x, 3.95*x, nameplate_thickness/2 }
                plane { -y, 0 }
                translate (1 - nameplate_thickness/2)*y
            }
            intersection {
                cylinder { -3.95*x, 3.95*x, nameplate_thickness/2 }
                plane { y, 0 }
                translate (nameplate_thickness/2 - 1)*y
            }
            box {
                <-3.95, 1 - nameplate_thickness/2, -nameplate_thickness/2>
                <3.95, nameplate_thickness/2 - 1, 0>
            }
            texture { T_Brass_4A }
        }
        translate y
        rotate -30*x
    }
    box {
        <-3.95, 0, 0> <3.95, nameplate_thickness/2, -1>
        texture { T_Brass_4A }
    }
}

//---------------------------//
// Desktop Pen in its holder //
//---------------------------//
#declare pen_shape =
lathe { quadratic_spline 5, <0, 6>, <0, 0>, <0.2, 1>, <0, 6>, <0, 0> sturm }

#declare pen_holder =
union {
    intersection {
        object { pen_shape scale <1.75, 1.5, 1.75> }
        plane { y, 0 rotate 45*z translate y }
    }
    sphere { 0, 0.15 translate -0.8*y }
    texture { T_Brass_4A }
}

#declare pen_and_holder =
union {
    object {
        pen_shape
        pigment { color Black }
        finish { phong 1 }
    }
    object { pen_holder }
    translate 0.8*y
    rotate 30*z
}

#declare desk_pen =
union {
    object { pen_and_holder translate 0.1*y }
    cylinder { -1*y, 0*y, 2 pigment { color Black } finish { phong 1 } }
    translate y
}

//---------------//
// Harry's Gavel //
//---------------//

#declare head_radius = 1
#declare head_bump_radius = 0.2
#declare handle_radius = 0.5
#declare handle_length = 8

#declare gavel_head_half =
intersection {
    lathe {
        quadratic_spline
        11,
        <0, 4>, <0, 0>, <1, 0>, <head_radius + head_bump_radius, head_bump_radius>,
        <head_radius, 2*head_bump_radius>, <head_radius + head_bump_radius, 2>
        <head_radius, 4 - 2*head_bump_radius>,
        <head_radius + head_bump_radius, head_radius - head_bump_radius>,
        <head_radius, 4>, <0, 4>, <0, 0>
        translate -2*y
        sturm
    }
    plane { -y, 0 }
}

#declare gavel_head =
union {
    object { gavel_head_half }
    object { gavel_head_half rotate 180*z }
    cylinder { -2*y, 2*y, head_radius scale <0.6, 1.3, 0.6> }
    rotate 90*z
    rotate 90*y
    texture { T_Wood8 rotate 3*x }
}

#declare gavel_handle =
lathe {
    quadratic_spline
    6,
    <0, handle_length>, <0, 0>, <0.25, 0>, <0.5, handle_length - 0.25>,
    <0, handle_length>, <0, 0>
    sturm
    texture { T_Wood11 rotate 3*x }
}

#declare gavel =
union {
    object { gavel_head }
    object { gavel_handle }
    rotate 90*y
    rotate 90*x
    rotate 5*x
    translate <0, head_radius + head_bump_radius, 0>
}

#declare molding_height = 2
#declare panel_thickness = 2

#declare desk_panel =
union {
    difference {
        box {
            <-desk_width/2, -desk_height, 0>,
            <desk_width/2, molding_height, panel_thickness>
        }
        box {
            <-20, -20, -panel_thickness/2>, <20, 20, panel_thickness/2>
            translate -desk_height*y/2
        }
    }
    box {
        <-15, -15, 0>, <15, 15, panel_thickness>
        translate -desk_height*y/2
    }
}

#declare desk =
union {
    object { desk_panel translate <-desk_width/2, 0, -desk_width/2> }
    object { desk_panel translate < desk_width/2, 0, -desk_width/2> }
    object { desk_panel rotate 90*y translate -desk_width*x }
    object { desk_panel rotate -90*y translate desk_width*x }
    difference {
        box {
            <-desk_width + panel_thickness, -desk_height, -desk_width/2 + panel_thickness>,
            < desk_width - panel_thickness, 0, desk_width/2>
        }
        box {
            <-desk_width + 2*panel_thickness, -desk_height,
                -desk_width/2 + 2*panel_thickness>,
            < desk_width - 2*panel_thickness, 0, desk_width>
        }
    }
    texture { T_Wood2 }
}

#declare cushion =
intersection {
    cylinder { -18*x, 18*x, 9 scale <1, 1, 0.5> }
    plane { z, 0 }
}

#declare chair =
union {
    object { cushion }
    object { cushion translate 18*y }
    object { cushion translate 36*y }
    box { <-18, -9, 0>, <18, 45, 5> }
    rotate 10*x
    translate -10*y
//    texture {
        pigment { color Brown*0.5 }
//        finish {specular 0.9  roughness 0.2}
//    }
}

