// Persistence of Vision Ray Tracer Scene Description File
// File: Clarence.pov
// Vers: 3
// Desc: Clarence, the Stuffed Armadillo (from "Night Court")
// Date: 8/7/1997
// Auth: Steve Sloan II

#version 3

#include "colors.inc"

global_settings {
    assumed_gamma 1.0
}

// ----------------------------------------
// 3/4 View
camera {
    location  <-1, 0.2, -1>
    direction 1.5*z
    right     4/3*x
    look_at   < 0, 0.2, 0>
}

// Side View
//camera {
//    location  <-2, 0.1, 0>
//    direction 1.5*z
//    right     4/3*x
//    look_at   < 0, 0.1, 0>
//}

// Side View (of the tail)
//camera {
//    location  <-1, 0.1, 0.4>
//    direction 1.5*z
//    right     4/3*x
//    look_at   < 0, 0.1, 0.4>
//}

// Side View (of the head)
//camera {
//    location  <-0.75, 0, -0.4>
//    direction 1.5*z
//    right     4/3*x
//    look_at   < 0, 0, -0.4>
//}

// Rear View (of the head)
//camera {
//    location  <0, 0, 1>
//    direction 1.5*z
//    right     4/3*x
//    look_at   < 0, 0, 0>
//}


// Rear View
//camera {
//    location  <0, 0, 1>
//    direction 1.5*z
//    right     4/3*x
//    look_at   <0, 0, 0>
//}

// Front View
//camera {
//    location  <0, 0, -0.7>
//    direction 1.5*z
//    right     4/3*x
//    look_at   <0, 0, 0>
//}
// ----------------------------------------

sky_sphere {
    pigment {
        gradient y
        color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
    }
}

light_source {
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-30, 30, -30>
}

// ----------------------------------------
plane {
    y, -0.2
    texture {
        pigment {checker color rgb 1 color blue 1 scale 0.5}
        finish {reflection 0.2}
    }
}

#include "recess/clarence.inc"

object { armadillo }

