// Persistence of Vision Ray Tracer Scene Description File
// File: Recess.pov
// Vers: 3
// Desc: Recess: A Scene from "Night Court"
//       Judge Harold T. Stone is on recess. He loves nothing better than wowing
//       his court with magic tricks, and during this recess, he's trying one of
//       his greatest. He left behind the book he read to prepare for his trick,
//       HOW TO ESCAPE FROM A SAFE, written by an expert, and one of Harry's
//       heroes, the legendary Harry Houdini. He also left the bill of sale from
//       Acme Safe Company. Note his stuffed armadillo, Clarence, who's had quite
//       a few adventures himself, during the series' run.
// Date: 8/13/1997
// Auth: Steve Sloan II

#version 3

#include "colors.inc"
#include "finish.inc"
#include "woods.inc"

// Constants
#declare desk_width = 56
#declare desk_height = 50

global_settings {
    assumed_gamma 1.0
}

camera {
    location  <0, 20, -50>
    direction 1.5*z
    right     4/3*x
    look_at   <0, 0, 0>
}

//camera {
//    location  <0, 100, -100>
//    direction 1.5*z
//    right     4/3*x
//    look_at   <0, 0, 0>
//}

sky_sphere {
    pigment {
        gradient y
        color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
    }
}

#declare wall_pos = 80

light_source { <-200, 90, wall_pos - 10> color White }
light_source { < 200, 90, wall_pos - 10> color White }

light_source { <-300, 90, wall_pos + 300> color White }
light_source { < 300, 90, wall_pos + 300> color White }

// ----------------------------------------
// Courtroom Floor
plane {
    y, -desk_height
    texture {
        pigment {checker color rgb 1 color blue 1 scale 0.5}
        finish {reflection 0.2}
    }
}

// Courtroom Walls and Ceiling
union {
    plane {
        -z, 0
        translate wall_pos*z
    }
    plane {
        z, 0
        translate -600*z
    }
    plane {
        -y, 0
        translate 240*y
    }
    plane {
        -x, 0
        translate 240*x
    }
    plane {
        x, 0
        translate -240*x
    }
    texture { pigment { color DarkGreen } finish {specular 0.9  roughness 0.2} }
}

#include "recess/Misc.inc"

// Harry's Desk
object { desk }

// Harry's Chair
object { chair translate 45*z }

union {
// Harry's Nameplate
object { nameplate rotate 210*y translate <10, 0, -60> }

// Harry's Pen
object { desk_pen translate <15, 0, -40> }

// Harry's Gavel
object { gavel rotate 45*y translate <3, 0, -52> }

// Houdini Book
#include "recess/book.inc"
object { book scale 1.25 rotate -30*y translate <-3, 0, -70> }

// Harry's Hat
#include "recess/hat.inc"
object { hat rotate 70*y translate <-12, 0, -65> }

// Clarence, the stuffed armadillo
#include "recess/clarence.inc"
object { armadillo rotate -30*y translate <-5, 0, -50> }
translate 50*z
}

