// amp.inc - amphitheater def. for romagic1.pov

// Note that we're not including the floor in the lathe.
#declare Amp = lathe
{
   linear_spline
   2*AmpStepCount+3,
   <AmpInnerRadius,0>,
   #declare I = 0
   #while (I < AmpStepCount)
      <AmpInnerRadius+AmpStepWidth*I,    AmpStepHeight*(I+1)>,
      <AmpInnerRadius+AmpStepWidth*(I+1),AmpStepHeight*(I+1)>,
      #declare I = I + 1
   #end
   <AmpInnerRadius+AmpStepWidth*AmpStepCount,0>,
   <AmpInnerRadius,0>
   texture { T_Stone9 }
   hollow
}

// Now we do the floor.  This way we get a true 3D base.
#declare SandFloor = object
{
   height_field {tga "sand.tga"}
   scale <250,1,250>
   translate <-125,0,-125>
   texture { T_Stone10 finish { ambient 0.4 } scale 0.01}
//   normal { wrinkles 1 scale 1 }
}
