// ball1.inc - Ball Lightning object for romagic1.

// We hope that the object transform vectors have already
// been defined.  If not, though, we need defaults.
#ifndef(Obj_Scale)
   #declare Obj_Scale = <1,1,1>
   #warning "Obj_Scale not defined, default used."
#end

#ifndef(Obj_Rot)
   #declare Obj_Rot = <0,0,0>
   #warning "Obj_Rot not defined, default used."
#end

#ifndef(Obj_Trans)
   #declare Obj_Trans = <0,0,0>
   #warning "Obj_Trans not defined, default used."
#end

// As with vectors, we need a texture file name.
#ifndef(Obj_Texture)
   #declare Obj_Texture = "electric.inc"
   #warning "Obj_Texture not defined, default used."
#end

// Normally, we'd just use a declare:
//   #declare BallLightning = object
// However, since we need to apply the texture after translation, we'll
// the 'preprocessor' (i.e. language directives) to fake a function.
object
{
   BallLightningForm
   rotate Obj_Rot
   scale Obj_Scale
   translate Obj_Trans
   texture
   {
      #include Obj_Texture
   }
}
