// romagic1.pov - Master's Match

// Stock elements:
#include "colors.inc"
#include "stones1.inc"
#include "woods.inc"
#include "metals.inc"
#include "glass.inc"
#include "textures.inc"

// Control variables:
#include "knobs.inc"

// Image specific elements:
#include "objects.inc"
#include "amp.inc"
#include "backgrnd.inc"
#include "player.inc"
#include "sig.inc"

#declare CameraNum = 2
#include "camera.inc"

global_settings
{
   assumed_gamma 1
   max_trace_level 15
}

// Note:  Scale in meters.

#declare Lights = union
{
   light_source { <50,2000,50> color White }
   light_source { < 5,50, 5> color White*0.5 }
   light_source { < 5,50,-5> color White*0.5 }
   light_source { <-5,50, 5> color White*0.5 }
   light_source { <-5,50,-5> color White*0.5 }
}

object { Lights rotate <30,-30,0> }

object
{
   Plaque
   rotate 7*z
   rotate 15*x
   translate <0,0.64,-8.0>
   rotate -86*y
}

object { EyeSpyCrowd }
object { Amp }
object { SandFloor }

object { Player1 translate  4*z }
object { Player2 translate -4*z }

object { GroundFire1 translate <4,0,-3> }
object { GroundFire2 translate <3,0.2,1> }
object { TarBlob translate <-3,0.2,0> }

#declare Obj_Scale=<1,1,1>/5
#declare Obj_Rot=<0,0,0>
#declare Obj_Trans=<0,1.65,-1.5>
#declare Obj_Texture="electric.inc"
#include "ball1.inc"

#declare Obj_Scale=<1,1,1>/4
#declare Obj_Rot=<0,0,0>
#declare Obj_Trans=<0,1.55,-0.8>
#declare Obj_Texture="electric.inc"
#include "ball1.inc"

#declare Obj_Scale=<1,1,1>/3
#declare Obj_Rot=<0,0,0>
#declare Obj_Trans=<0,1.45,0>
#declare Obj_Texture="electric.inc"
#include "ball1.inc"

