// #include "colors.inc"

global_settings
 {number_of_waves 1}

camera {  //  Camera Kamera_2
  location  <-8.720, -18.206, 4.8>//<-55,14,1>//<-24,-4,17>//<4,-9,10>//
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <-0.307, 0.326, 2.2>//<-5,14,1>//<0,0,0>//<-1,15,10>//3
}
/*camera {  //  Camera StdCam
  location  <-29.460, -31.080, 1.935>
  direction <0.0,     0.0,  4.2284>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <3.411, -0.504, 1.574>
}*/


light_source
 {<-900000,-50000000,60000000>/100
  color rgb 1}  // -900000
/*cylinder
 {<0,0,0>,<-50000,-900,60000>,.1
  //translate <-2,5,0>
  pigment{color Red} finish{ambient 1 diffuse 0}
 }*/

/*plane
 {z,-0.01
  pigment{ForestGreen/2}
  finish{ambient .7 diffuse .2}
 }*/







// ********  TEXTURES  *******
//

#include "\pov301\minapov\mc.inc"


union{

// ********  REFERENCED OBJECTS  *******

#declare SulaC1 = object {
  box { // SulaC1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.023799, 0.732436, 0.089347>
    rotate <2.416871, 20.16984, 18.102966>
    translate  <1.529141, -5.136115, -2.580488>
  }
}
#declare SulaC2 = object {
  object { // SulaC2->SulaC1
    SulaC1
    rotate <0.0, 0.0, 0.0>
    translate  <0.111409, 0.003048, -0.047443>
  }
}




// ********  OBJECTS  *******

torus { // SpikeHolder3
  1.5, 0.4  rotate -x*90
  texture {
    Chrome_Textur1
  }
  scale <0.08, 0.08, 0.15>
  rotate <2.578496, -57.327892, 0.5899>
  translate  <-6.889324, 2.245334, -1.38563>
}


torus { // SpikeHolder2
  1.5, 0.4  rotate -x*90
  texture {
    Chrome_Textur1
  }
  scale <0.08, 0.08, 0.15>
  rotate <2.479141, -46.650455, 0.854088>
  translate  <-6.130039, 2.290334, -0.485208>
}


union { // Axlar
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.954264, -3.498818, -8.532719>, <-4.723637, -3.292849, -8.528139>, <-3.762881, -3.133968, -8.528139>, <-2.905970, -3.436935, -8.472198>,
      <-6.311349, -3.897740, -1.908333>, <-4.782689, -3.574635, -3.049548>, <-3.813562, -3.414957, -3.049548>, <-2.931310, -4.137448, -2.568514>,
      <-5.090255, -3.468207, -2.794364>, <-4.848013, -2.938140, -1.328029>, <-3.869625, -2.777580, -1.328029>, <-2.959342, -3.078204, -1.272088>,
      <-5.024725, -3.270237, -1.508490>, <-5.980727, -2.937528, -0.217444>, <-3.820211, -2.876411, -0.513331>, <-2.929498, -2.938771, -0.364610>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.024725, -3.270237, -1.508490>, <-5.980727, -2.937528, -0.217444>, <-3.820211, -2.876411, -0.513331>, <-2.929498, -2.938771, -0.364610>,
      <-4.959195, -3.072268, -0.222617>, <-7.113440, -2.936916, 0.893141>, <-3.770796, -2.975241, 0.301367>, <-2.899654, -2.799339, 0.542868>,
      <-5.618119, -2.437538, 0.001279>, <-7.206847, -2.026786, 1.117037>, <-3.850961, -2.063849, 0.525263>, <-2.939737, -1.886187, 0.766764>,
      <-6.091424, -2.035689, 0.001279>, <-7.307695, -1.044157, 1.117037>, <-3.937513, -1.079859, 0.525263>, <-2.983013, -0.900297, 0.766764>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-6.091424, -2.035689, 0.001279>, <-7.307695, -1.044157, 1.117037>, <-3.937513, -1.079859, 0.525263>, <-2.983013, -0.900297, 0.766764>,
      <-6.564730, -1.633840, 0.001279>, <-7.408542, -0.061529, 1.117037>, <-4.024065, -0.095868, 0.525263>, <-3.026289, 0.085593, 0.766764>,
      <-6.944230, -1.459876, -0.222617>, <-7.516830, 0.993597, 0.893141>, <-4.117002, 0.960720, 0.301367>, <-3.072757, 1.144222, 0.542868>,
      <-7.524261, -1.437184, -1.485036>, <-6.437444, 1.512596, -0.217444>, <-4.212185, 1.579883, -0.513331>, <-3.125485, 1.763874, -0.392580>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-7.524261, -1.437184, -1.485036>, <-6.437444, 1.512596, -0.217444>, <-4.212185, 1.579883, -0.513331>, <-3.125485, 1.763874, -0.392580>,
      <-8.104293, -1.414492, -2.747456>, <-5.358058, 2.031596, -1.328029>, <-4.307368, 2.199046, -1.328029>, <-3.178214, 2.383526, -1.328029>,
      <-6.379751, -3.867552, -1.908333>, <-5.420246, 2.637535, -3.049548>, <-4.360740, 2.805825, -3.049548>, <-3.204900, 2.991476, -3.049548>,
      <-6.098083, -3.460845, -8.532719>, <-5.488705, 3.047295, -8.581799>, <-4.419495, 3.216510, -8.581799>, <-3.234277, 3.403451, -8.581799>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.905970, -3.436935, -8.472198>, <-2.049059, -3.739902, -8.416257>, <-1.024529, -3.739902, -8.416257>, <0.000000, -3.739902, -8.416257>,
      <-2.931310, -4.137448, -2.568514>, <-2.049059, -4.859939, -2.087480>, <-1.024529, -4.859939, -2.087480>, <0.000000, -4.859939, -2.087480>,
      <-2.959342, -3.078204, -1.272088>, <-2.049059, -3.378828, -1.216147>, <-1.024529, -3.378828, -1.216147>, <0.000000, -3.378828, -1.216147>,
      <-2.929498, -2.938771, -0.364610>, <-2.038786, -3.001132, -0.215889>, <-0.930605, -3.012859, -0.103951>, <0.080427, -2.914121, -0.103951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.929498, -2.938771, -0.364610>, <-2.038786, -3.001132, -0.215889>, <-0.930605, -3.012859, -0.103951>, <0.080427, -2.914121, -0.103951>,
      <-2.899654, -2.799339, 0.542868>, <-2.028513, -2.623436, 0.784370>, <-0.836680, -2.646890, 1.008245>, <0.160853, -2.449414, 1.008245>,
      <-2.939737, -1.886187, 0.766764>, <-2.028513, -1.708525, 1.008266>, <-0.836680, -1.731978, 1.232141>, <0.160853, -1.534503, 1.232141>,
      <-2.983013, -0.900297, 0.766764>, <-2.028513, -0.720735, 1.008266>, <-0.836680, -0.744189, 1.232141>, <0.160853, -0.546713, 1.232141>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.983013, -0.900297, 0.766764>, <-2.028513, -0.720735, 1.008266>, <-0.836680, -0.744189, 1.232141>, <0.160853, -0.546713, 1.232141>,
      <-3.026289, 0.085593, 0.766764>, <-2.028513, 0.267055, 1.008266>, <-0.836680, 0.243601, 1.232141>, <0.160853, 0.441076, 1.232141>,
      <-3.072757, 1.144222, 0.542868>, <-2.028513, 1.327723, 0.784370>, <-0.836680, 1.304269, 1.008245>, <0.160853, 1.501745, 1.008245>,
      <-3.125485, 1.763874, -0.392580>, <-2.038786, 1.947864, -0.271830>, <-0.930605, 1.936137, -0.159892>, <0.080427, 2.034875, -0.159892>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.125485, 1.763874, -0.392580>, <-2.038786, 1.947864, -0.271830>, <-0.930605, 1.936137, -0.159892>, <0.080427, 2.034875, -0.159892>,
      <-3.178214, 2.383526, -1.328029>, <-2.049059, 2.568006, -1.328029>, <-1.024529, 2.568006, -1.328029>, <0.000000, 2.568006, -1.328029>,
      <-3.204900, 2.991476, -3.049548>, <-2.049059, 3.177128, -3.049548>, <-1.024529, 3.177128, -3.049548>, <0.000000, 3.177128, -3.049548>,
      <-3.234277, 3.403451, -8.581799>, <-2.049059, 3.590392, -8.581799>, <-1.024529, 3.590392, -8.581799>, <0.000000, 3.590392, -8.581799>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -3.739902, -8.416257>, <1.024529, -3.739902, -8.416257>, <1.866953, -3.344951, -8.416257>, <2.625236, -3.480492, -8.416257>,
      <0.000000, -4.859939, -2.087480>, <1.024529, -4.859939, -2.087480>, <1.866953, -4.464988, -2.087480>, <2.641944, -4.601203, -2.087480>,
      <0.000000, -3.378828, -1.216147>, <1.024529, -3.378828, -1.216147>, <1.866953, -2.983877, -1.216147>, <2.660427, -3.120838, -1.216147>,
      <0.080427, -2.914121, -0.103951>, <1.091458, -2.815383, -0.103951>, <1.946496, -2.617908, -0.103951>, <2.712287, -2.749317, -0.159920>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.080427, -2.914121, -0.103951>, <1.091458, -2.815383, -0.103951>, <1.946496, -2.617908, -0.103951>, <2.712287, -2.749317, -0.159920>,
      <0.160853, -2.449414, 1.008245>, <1.158387, -2.251938, 1.008245>, <2.026038, -2.251938, 1.008245>, <2.764146, -2.377796, 0.896307>,
      <0.160853, -1.534503, 1.232141>, <1.158387, -1.337027, 1.232141>, <2.026038, -1.337027, 1.232141>, <2.790576, -1.463951, 1.120203>,
      <0.160853, -0.546713, 1.232141>, <1.158387, -0.349238, 1.232141>, <2.026038, -0.349238, 1.232141>, <2.841249, -0.477312, 0.932301>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.160853, -0.546713, 1.232141>, <1.158387, -0.349238, 1.232141>, <2.026038, -0.349238, 1.232141>, <2.841249, -0.477312, 0.932301>,
      <0.160853, 0.441076, 1.232141>, <1.158387, 0.638552, 1.232141>, <2.026038, 0.638552, 1.232141>, <2.891922, 0.509327, 0.744399>,
      <0.160853, 1.501745, 1.008245>, <1.158387, 1.699220, 1.008245>, <2.026038, 1.699220, 1.008245>, <2.922562, 1.568760, 0.520503>,
      <0.080427, 2.034875, -0.159892>, <1.091458, 2.133613, -0.159892>, <1.946496, 2.331089, -0.159892>, <2.863653, 2.194468, -0.403763>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.080427, 2.034875, -0.159892>, <1.091458, 2.133613, -0.159892>, <1.946496, 2.331089, -0.159892>, <2.863653, 2.194468, -0.403763>,
      <0.000000, 2.568006, -1.328029>, <1.024529, 2.568006, -1.328029>, <1.866953, 2.962957, -1.328029>, <2.804744, 2.820177, -1.328029>,
      <0.000000, 3.177128, -3.049548>, <1.024529, 3.177128, -3.049548>, <1.866953, 3.572079, -3.049548>, <2.822340, 3.428589, -3.049548>,
      <0.000000, 3.590392, -8.581799>, <1.024529, 3.590392, -8.581799>, <1.866953, 3.985343, -8.581799>, <2.841711, 3.841072, -8.581799>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.625236, -3.480492, -8.416257>, <3.383518, -3.616034, -8.416257>, <4.646784, -3.337582, -8.528139>, <6.751989, -1.143777, -8.529380>,
      <2.641944, -4.601203, -2.087480>, <3.416935, -4.737419, -2.087480>, <4.717045, -3.620629, -3.049548>, <7.566798, -0.759246, -3.049548>,
      <2.660427, -3.120838, -1.216147>, <3.453902, -3.257798, -1.216147>, <4.794767, -2.985530, -1.328029>, <4.515204, -3.249260, -1.328029>,
      <2.712287, -2.749317, -0.159920>, <3.478078, -2.880726, -0.215889>, <4.906968, -3.071800, -0.513331>, <5.014413, -3.298267, -0.678759>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.712287, -2.749317, -0.159920>, <3.478078, -2.880726, -0.215889>, <4.906968, -3.071800, -0.513331>, <5.014413, -3.298267, -0.678759>,
      <2.764146, -2.377796, 0.896307>, <3.502255, -2.503654, 0.784370>, <5.019170, -3.158071, 0.301367>, <5.513621, -3.347274, -0.029489>,
      <2.790576, -1.463951, 1.120203>, <3.555114, -1.590874, 1.008266>, <5.116754, -2.276962, 0.525263>, <6.485037, -3.143020, 0.108540>,
      <2.841249, -0.477312, 0.932301>, <3.656459, -0.605386, 0.632462>, <5.998943, -1.782832, 0.535255>, <7.175402, -2.595536, 0.017890>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.841249, -0.477312, 0.932301>, <3.656459, -0.605386, 0.632462>, <5.998943, -1.782832, 0.535255>, <7.175402, -2.595536, 0.017890>,
      <2.891922, 0.509327, 0.744399>, <3.757805, 0.380102, 0.256658>, <6.881131, -1.288702, 0.545247>, <7.865767, -2.048051, -0.072759>,
      <2.922562, 1.568760, 0.520503>, <3.819085, 1.438299, 0.032762>, <7.498695, -0.559448, 0.238339>, <7.805123, -1.694181, -0.338428>,
      <2.863653, 2.194468, -0.403763>, <3.780811, 2.057848, -0.647633>, <7.396625, 0.141240, -0.609297>, <7.846334, -1.087243, -0.936613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.863653, 2.194468, -0.403763>, <3.780811, 2.057848, -0.647633>, <7.396625, 0.141240, -0.609297>, <7.846334, -1.087243, -0.936613>,
      <2.804744, 2.820177, -1.328029>, <3.742536, 2.677396, -1.328029>, <7.294555, 0.841928, -1.456933>, <7.887544, -0.480305, -1.534797>,
      <2.822340, 3.428589, -3.049548>, <3.777728, 3.285099, -3.049548>, <7.813265, 1.260725, -3.049548>, <4.963516, -2.987343, -3.049548>,
      <2.841711, 3.841072, -8.581799>, <3.816469, 3.696802, -8.581799>, <8.086774, 1.523477, -8.581799>, <6.882381, -1.067895, -8.529380>
    }
  }
  texture {
    LegTex1
  }
  scale 0.2
  rotate -84.456856*z
  translate  <7.91024, -0.501694, 5.03509>
}


union { // SleeveLeft
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.990535, -0.366915, -0.159313>, <-0.990535, -1.031421, 0.102656>, <-0.540535, -1.481421, 0.102656>, <-0.042494, -1.481421, 0.115819>,
      <-0.981696, -0.366915, 0.395999>, <-0.939975, -1.031421, 0.457571>, <-0.489975, -1.481421, 0.457571>, <-0.017214, -1.481421, 0.543276>,
      <-0.825492, 0.000000, 1.000000>, <-0.825492, -0.491072, 1.000000>, <-0.454021, -0.892858, 1.000000>, <0.000000, -0.892858, 1.000000>,
      <-0.825492, 0.000000, 1.500000>, <-0.825492, -0.491072, 1.500000>, <-0.454021, -0.892858, 1.500000>, <-0.066922, -0.896723, 1.483872>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.042494, -1.481421, 0.115819>, <0.455548, -1.481421, 0.128982>, <1.141677, -1.031421, 0.270659>, <1.141677, -0.366915, 0.008690>,
      <-0.017214, -1.481421, 0.543276>, <0.455548, -1.481421, 0.628982>, <1.141677, -1.031421, 0.770659>, <1.141677, -0.366915, 0.508690>,
      <0.000000, -0.892858, 1.000000>, <0.454021, -0.892858, 1.000000>, <0.825492, -0.491072, 1.000000>, <0.825492, 0.000000, 1.000000>,
      <-0.066922, -0.896723, 1.483872>, <0.320176, -0.900588, 1.467744>, <0.801486, -0.491072, 2.320975>, <0.801486, 0.000000, 2.320975>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.141677, -0.366915, 0.008690>, <1.141677, 0.297591, -0.253279>, <0.455548, 0.747591, -0.394956>, <-0.042494, 0.747591, -0.408119>,
      <1.141677, -0.366915, 0.508690>, <1.141677, 0.297591, 0.246721>, <0.455548, 0.747591, 0.105044>, <-0.058934, 0.747591, 0.219736>,
      <0.825492, 0.000000, 1.000000>, <0.825492, 0.491072, 1.000000>, <0.454021, 0.892858, 1.000000>, <0.000000, 0.892858, 1.000000>,
      <0.801486, 0.000000, 2.320975>, <0.801486, 0.491072, 2.320975>, <0.320176, 0.901385, 1.788498>, <-0.066922, 0.897121, 1.644249>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.042494, 0.747591, -0.408119>, <-0.540535, 0.747591, -0.421282>, <-0.990535, 0.297591, -0.421282>, <-0.990535, -0.366915, -0.159313>,
      <-0.058934, 0.747591, 0.219736>, <-0.573417, 0.747591, 0.334428>, <-1.023417, 0.297591, 0.334428>, <-0.981696, -0.366915, 0.395999>,
      <0.000000, 0.892858, 1.000000>, <-0.454021, 0.892858, 1.000000>, <-0.825492, 0.491072, 1.000000>, <-0.825492, 0.000000, 1.000000>,
      <-0.066922, 0.897121, 1.644249>, <-0.454021, 0.892858, 1.500000>, <-0.825492, 0.491072, 1.500000>, <-0.825492, 0.000000, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.825492, 0.000000, 1.500000>, <-0.825492, -0.491072, 1.500000>, <-0.454021, -0.892858, 1.500000>, <-0.066922, -0.896723, 1.483872>,
      <-0.825492, 0.000000, 2.000000>, <-0.825492, -0.491072, 2.000000>, <-0.454021, -0.892858, 2.000000>, <-0.133845, -0.900588, 1.967744>,
      <-0.790827, -0.208604, 2.835454>, <-0.790827, -0.491072, 2.957835>, <-0.319951, -0.892858, 3.007538>, <-0.058656, -0.892858, 2.763920>,
      <-0.808160, -0.066664, 3.171240>, <-0.808160, -0.415795, 3.235943>, <-0.285922, -0.847635, 3.252813>, <0.021204, -0.832608, 3.134995>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.066922, -0.896723, 1.483872>, <0.320176, -0.900588, 1.467744>, <0.801486, -0.491072, 2.320975>, <0.801486, 0.000000, 2.320975>,
      <-0.133845, -0.900588, 1.967744>, <0.186332, -0.908318, 1.935488>, <0.777480, -0.491072, 3.641950>, <0.777480, 0.000000, 3.641950>,
      <-0.058656, -0.892858, 2.763920>, <0.202640, -0.892858, 2.520302>, <0.574111, -0.491072, 2.520302>, <0.574111, 0.000000, 2.520302>,
      <0.021204, -0.832608, 3.134995>, <0.328330, -0.817582, 3.017177>, <0.699802, -0.415795, 3.017177>, <0.699802, 0.037638, 3.013664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.801486, 0.000000, 2.320975>, <0.801486, 0.491072, 2.320975>, <0.320176, 0.901385, 1.788498>, <-0.066922, 0.897121, 1.644249>,
      <0.777480, 0.000000, 3.641950>, <0.777480, 0.491072, 3.641950>, <0.186332, 0.909912, 2.576996>, <-0.133845, 0.901385, 2.288498>,
      <0.574111, 0.000000, 2.520302>, <0.574111, 0.491072, 2.520302>, <0.202640, 0.892858, 2.520302>, <-0.058656, 0.684254, 2.641539>,
      <0.699802, 0.037638, 3.013664>, <0.699802, 0.491072, 3.010151>, <0.328330, 0.892858, 3.010151>, <0.021204, 0.725121, 3.038174>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.066922, 0.897121, 1.644249>, <-0.454021, 0.892858, 1.500000>, <-0.825492, 0.491072, 1.500000>, <-0.825492, 0.000000, 1.500000>,
      <-0.133845, 0.901385, 2.288498>, <-0.454021, 0.892858, 2.000000>, <-0.825492, 0.491072, 2.000000>, <-0.825492, 0.000000, 2.000000>,
      <-0.058656, 0.684254, 2.641539>, <-0.319951, 0.475650, 2.762776>, <-0.790827, 0.073864, 2.713074>, <-0.790827, -0.208604, 2.835454>,
      <0.021204, 0.725121, 3.038174>, <-0.285922, 0.557385, 3.066197>, <-0.808160, 0.282468, 3.106537>, <-0.808160, -0.066664, 3.171240>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.808160, -0.066664, 3.171240>, <-0.808160, -0.415795, 3.235943>, <-0.285922, -0.847635, 3.252813>, <0.021204, -0.832608, 3.134995>,
      <-0.825492, 0.075276, 3.507026>, <-0.825492, -0.340519, 3.514052>, <-0.251893, -0.802412, 3.498089>, <0.101064, -0.772358, 3.506070>,
      <-0.657684, 0.000000, 4.351125>, <-0.657684, -0.491072, 4.351125>, <-0.673376, -0.714632, 4.362663>, <-0.109677, -0.722195, 4.251589>,
      <-0.578120, 0.000000, 4.769398>, <-0.578120, -0.426350, 4.769398>, <-0.473791, -0.686069, 4.775167>, <-0.054839, -0.689851, 4.719630>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.021204, -0.832608, 3.134995>, <0.328330, -0.817582, 3.017177>, <0.699802, -0.415795, 3.017177>, <0.699802, 0.037638, 3.013664>,
      <0.101064, -0.772358, 3.506070>, <0.454021, -0.742305, 3.514052>, <0.825492, -0.340519, 3.514052>, <0.825492, 0.075276, 3.507026>,
      <-0.109677, -0.722195, 4.251589>, <0.454021, -0.729759, 4.140516>, <0.825492, -0.327973, 4.140516>, <0.825492, -0.006273, 4.245903>,
      <-0.054839, -0.689851, 4.719630>, <0.364113, -0.693632, 4.664094>, <0.662024, -0.344801, 4.664094>, <0.662024, -0.003137, 4.716787>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.699802, 0.037638, 3.013664>, <0.699802, 0.491072, 3.010151>, <0.328330, 0.892858, 3.010151>, <0.021204, 0.725121, 3.038174>,
      <0.825492, 0.075276, 3.507026>, <0.825492, 0.491072, 3.500000>, <0.454021, 0.892858, 3.500000>, <0.101064, 0.765989, 3.434809>,
      <0.825492, -0.006273, 4.245903>, <0.825492, 0.315427, 4.351290>, <0.454021, 0.717213, 4.351290>, <0.083904, 0.805035, 4.351208>,
      <0.662024, -0.003137, 4.716787>, <0.662024, 0.338527, 4.769480>, <0.364113, 0.687359, 4.769480>, <0.041952, 0.731271, 4.769439>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.021204, 0.725121, 3.038174>, <-0.285922, 0.557385, 3.066197>, <-0.808160, 0.282468, 3.106537>, <-0.808160, -0.066664, 3.171240>,
      <0.101064, 0.765989, 3.434809>, <-0.251893, 0.639119, 3.369618>, <-0.825492, 0.491072, 3.500000>, <-0.825492, 0.075276, 3.507026>,
      <0.083904, 0.805035, 4.351208>, <-0.286212, 0.892858, 4.351125>, <-0.657684, 0.491072, 4.351125>, <-0.657684, 0.000000, 4.351125>,
      <0.041952, 0.731271, 4.769439>, <-0.280209, 0.775182, 4.769398>, <-0.578120, 0.426350, 4.769398>, <-0.578120, 0.000000, 4.769398>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.578120, 0.000000, 4.769398>, <-0.578120, -0.426350, 4.769398>, <-0.473791, -0.686069, 4.775167>, <-0.054839, -0.689851, 4.719630>,
      <-0.498556, 0.000000, 5.187671>, <-0.498556, -0.361628, 5.187671>, <-0.274206, -0.657506, 5.187671>, <0.000000, -0.657506, 5.187671>,
      <-0.377694, 0.000000, 5.186121>, <-0.377694, -0.222763, 5.186121>, <-0.207732, -0.405024, 5.186121>, <0.000000, -0.405024, 5.186121>,
      <-0.133423, 0.000000, 5.258776>, <-0.133423, -0.092720, 5.258776>, <-0.073383, -0.168582, 5.258776>, <0.000000, -0.168582, 5.258776>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.054839, -0.689851, 4.719630>, <0.364113, -0.693632, 4.664094>, <0.662024, -0.344801, 4.664094>, <0.662024, -0.003137, 4.716787>,
      <0.000000, -0.657506, 5.187671>, <0.274206, -0.657506, 5.187671>, <0.498556, -0.361628, 5.187671>, <0.498556, 0.000000, 5.187671>,
      <0.000000, -0.405024, 5.186121>, <0.207732, -0.405024, 5.186121>, <0.377694, -0.222763, 5.186121>, <0.377694, 0.000000, 5.186121>,
      <0.000000, -0.168582, 5.258776>, <0.073383, -0.168582, 5.258776>, <0.133423, -0.092720, 5.258776>, <0.133423, 0.000000, 5.258776>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.662024, -0.003137, 4.716787>, <0.662024, 0.338527, 4.769480>, <0.364113, 0.687359, 4.769480>, <0.041952, 0.731271, 4.769439>,
      <0.498556, 0.000000, 5.187671>, <0.498556, 0.361628, 5.187671>, <0.274206, 0.657506, 5.187671>, <0.000000, 0.657506, 5.187671>,
      <0.377694, 0.000000, 5.186121>, <0.377694, 0.222763, 5.186121>, <0.207732, 0.405024, 5.186121>, <0.000000, 0.405024, 5.186121>,
      <0.133423, 0.000000, 5.258776>, <0.133423, 0.092720, 5.258776>, <0.073383, 0.168582, 5.258776>, <0.000000, 0.168582, 5.258776>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.041952, 0.731271, 4.769439>, <-0.280209, 0.775182, 4.769398>, <-0.578120, 0.426350, 4.769398>, <-0.578120, 0.000000, 4.769398>,
      <0.000000, 0.657506, 5.187671>, <-0.274206, 0.657506, 5.187671>, <-0.498556, 0.361628, 5.187671>, <-0.498556, 0.000000, 5.187671>,
      <0.000000, 0.405024, 5.186121>, <-0.207732, 0.405024, 5.186121>, <-0.377694, 0.222763, 5.186121>, <-0.377694, 0.000000, 5.186121>,
      <0.000000, 0.168582, 5.258776>, <-0.073383, 0.168582, 5.258776>, <-0.133423, 0.092720, 5.258776>, <-0.133423, 0.000000, 5.258776>
    }
  }
  texture {
    LegTex
  }
  scale 0.3
  rotate <-103.107849, -1.976489, 84.934448>
  translate  <6.578859, -3.001412, 3.541038>
}


union { // Sleeve2Left
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.039624, 0.140708, 0.007775>, <-1.039624, -0.675859, 0.154012>, <-0.589624, -1.228834, 0.154012>, <-0.091582, -1.228834, 0.168422>,
      <-1.039624, 0.140708, 0.555111>, <-1.039624, -0.675859, 0.701349>, <-0.589624, -1.228834, 0.701349>, <-0.091582, -1.228834, 0.715758>,
      <-1.000000, 0.127917, 1.094673>, <-1.000000, -0.675859, 1.094673>, <-0.550000, -1.228834, 1.094673>, <0.000000, -1.228834, 1.094673>,
      <-1.000000, 0.127917, 1.642010>, <-1.000000, -0.675859, 1.642010>, <-0.550000, -1.228834, 1.642010>, <-0.081070, -1.202432, 1.621240>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.091582, -1.228834, 0.168422>, <0.406460, -1.228834, 0.182831>, <1.092589, -0.675859, 0.337921>, <1.092589, 0.140708, 0.191684>,
      <-0.091582, -1.228834, 0.715758>, <0.406460, -1.228834, 0.730167>, <1.092589, -0.675859, 0.885258>, <1.092589, 0.140708, 0.739020>,
      <0.000000, -1.228834, 1.094673>, <0.550000, -1.228834, 1.094673>, <1.000000, -0.675859, 1.094673>, <1.000000, 0.127917, 1.094673>,
      <-0.081070, -1.202432, 1.621240>, <0.387861, -1.176031, 1.600470>, <1.000000, -0.675859, 1.642010>, <1.000000, 0.127917, 1.642010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.092589, 0.140708, 0.191684>, <1.092589, 0.957275, 0.045447>, <0.406460, 1.510251, -0.109644>, <-0.091582, 1.510251, -0.124053>,
      <1.092589, 0.140708, 0.739020>, <1.092589, 0.957275, 0.592783>, <0.406460, 1.510251, 0.437693>, <-0.091582, 1.510251, 0.423283>,
      <1.000000, 0.127917, 1.094673>, <1.000000, 0.931692, 1.094673>, <0.550000, 1.484667, 1.094673>, <0.000000, 1.484667, 1.094673>,
      <1.000000, 0.127917, 1.642010>, <1.000000, 0.931692, 1.642010>, <0.387861, 1.321280, 1.586451>, <-0.081070, 1.402973, 1.614230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.091582, 1.510251, -0.124053>, <-0.589624, 1.510251, -0.138462>, <-1.039624, 0.957275, -0.138462>, <-1.039624, 0.140708, 0.007775>,
      <-0.091582, 1.510251, 0.423283>, <-0.589624, 1.510251, 0.408874>, <-1.039624, 0.957275, 0.408874>, <-1.039624, 0.140708, 0.555111>,
      <0.000000, 1.484667, 1.094673>, <-0.550000, 1.484667, 1.094673>, <-1.000000, 0.931692, 1.094673>, <-1.000000, 0.127917, 1.094673>,
      <-0.081070, 1.402973, 1.614230>, <-0.550000, 1.484667, 1.642010>, <-1.000000, 0.931692, 1.642010>, <-1.000000, 0.127917, 1.642010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, 0.127917, 1.642010>, <-1.000000, -0.675859, 1.642010>, <-0.550000, -1.228834, 1.642010>, <-0.081070, -1.202432, 1.621240>,
      <-1.000000, 0.127917, 2.189346>, <-1.000000, -0.675859, 2.189346>, <-0.550000, -1.228834, 2.189346>, <-0.162139, -1.176031, 2.147807>,
      <-0.972065, 0.103925, 3.005897>, <-0.972065, -0.550000, 2.997932>, <-0.387588, -1.100266, 3.134541>, <0.049013, -1.010809, 2.996435>,
      <-0.986032, 0.146165, 3.256461>, <-0.986032, -0.465690, 3.255992>, <-0.346366, -1.107917, 3.259105>, <0.085721, -0.992142, 3.222648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.081070, -1.202432, 1.621240>, <0.387861, -1.176031, 1.600470>, <1.000000, -0.675859, 1.642010>, <1.000000, 0.127917, 1.642010>,
      <-0.162139, -1.176031, 2.147807>, <0.225722, -1.123229, 2.106268>, <1.000000, -0.675859, 2.189346>, <1.000000, 0.127917, 2.189346>,
      <0.049013, -1.010809, 2.996435>, <0.485615, -0.921352, 2.858330>, <0.935615, -0.675859, 2.778117>, <0.935615, 0.127917, 2.778117>,
      <0.085721, -0.992142, 3.222648>, <0.517807, -0.876367, 3.186191>, <0.967807, -0.528620, 3.146084>, <0.967807, 0.158161, 3.142571>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, 0.127917, 1.642010>, <1.000000, 0.931692, 1.642010>, <0.387861, 1.321280, 1.586451>, <-0.081070, 1.402973, 1.614230>,
      <1.000000, 0.127917, 2.189346>, <1.000000, 0.931692, 2.189346>, <0.225722, 1.157892, 2.078229>, <-0.162139, 1.321280, 2.133787>,
      <0.935615, 0.127917, 2.778117>, <0.935615, 0.931692, 2.778117>, <0.485615, 1.230661, 2.831592>, <0.049013, 1.350129, 2.911040>,
      <0.967807, 0.158161, 3.142571>, <0.967807, 0.844942, 3.139059>, <0.517807, 1.219427, 3.165796>, <0.085721, 1.321748, 3.239768>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.081070, 1.402973, 1.614230>, <-0.550000, 1.484667, 1.642010>, <-1.000000, 0.931692, 1.642010>, <-1.000000, 0.127917, 1.642010>,
      <-0.162139, 1.321280, 2.133787>, <-0.550000, 1.484667, 2.189346>, <-1.000000, 0.931692, 2.189346>, <-1.000000, 0.127917, 2.189346>,
      <0.049013, 1.350129, 2.911040>, <-0.387588, 1.469597, 2.990488>, <-0.972065, 0.757850, 3.013861>, <-0.972065, 0.103925, 3.005897>,
      <0.085721, 1.321748, 3.239768>, <-0.346366, 1.424070, 3.313740>, <-0.986032, 0.758021, 3.256930>, <-0.986032, 0.146165, 3.256461>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.986032, 0.146165, 3.256461>, <-0.986032, -0.465690, 3.255992>, <-0.346366, -1.107917, 3.259105>, <0.085721, -0.992142, 3.222648>,
      <-1.000000, 0.188406, 3.507026>, <-1.000000, -0.381381, 3.514052>, <-0.305143, -1.115568, 3.383670>, <0.122428, -0.973475, 3.448861>,
      <-0.940799, 0.104096, 4.370336>, <-0.940799, -0.550000, 4.370336>, <-0.346717, -0.713833, 4.189996>, <0.101642, -0.799349, 4.190077>,
      <-0.970400, 0.104096, 4.779004>, <-0.970400, -0.550000, 4.779004>, <-0.448358, -0.856917, 4.688833>, <0.050821, -0.899674, 4.688874>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.085721, -0.992142, 3.222648>, <0.517807, -0.876367, 3.186191>, <0.967807, -0.528620, 3.146084>, <0.967807, 0.158161, 3.142571>,
      <0.122428, -0.973475, 3.448861>, <0.550000, -0.831381, 3.514052>, <1.000000, -0.381381, 3.514052>, <1.000000, 0.188406, 3.507026>,
      <0.101642, -0.799349, 4.190077>, <0.550000, -0.884864, 4.190159>, <1.000000, -0.367329, 4.140516>, <1.000000, 0.097070, 4.245903>,
      <0.050821, -0.899674, 4.688874>, <0.550000, -0.942432, 4.688915>, <1.000000, -0.458665, 4.664094>, <1.000000, 0.100583, 4.716787>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.967807, 0.158161, 3.142571>, <0.967807, 0.844942, 3.139059>, <0.517807, 1.219427, 3.165796>, <0.085721, 1.321748, 3.239768>,
      <1.000000, 0.188406, 3.507026>, <1.000000, 0.758192, 3.500000>, <0.550000, 1.208192, 3.500000>, <0.122428, 1.293367, 3.568497>,
      <1.000000, 0.097070, 4.245903>, <1.000000, 0.561470, 4.351290>, <0.550000, 1.011470, 4.351290>, <0.101642, 1.109831, 4.351208>,
      <1.000000, 0.100583, 4.716787>, <1.000000, 0.659831, 4.769480>, <0.550000, 1.109831, 4.769480>, <0.050821, 1.159012, 4.769439>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.085721, 1.321748, 3.239768>, <-0.346366, 1.424070, 3.313740>, <-0.986032, 0.758021, 3.256930>, <-0.986032, 0.146165, 3.256461>,
      <0.122428, 1.293367, 3.568497>, <-0.305143, 1.378542, 3.636993>, <-1.000000, 0.758192, 3.500000>, <-1.000000, 0.188406, 3.507026>,
      <0.101642, 1.109831, 4.351208>, <-0.346717, 1.208192, 4.351125>, <-0.940799, 0.758192, 4.370336>, <-0.940799, 0.104096, 4.370336>,
      <0.050821, 1.159012, 4.769439>, <-0.448358, 1.208192, 4.769398>, <-0.970400, 0.758192, 4.779004>, <-0.970400, 0.104096, 4.779004>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.970400, 0.104096, 4.779004>, <-0.970400, -0.550000, 4.779004>, <-0.448358, -0.856917, 4.688833>, <0.050821, -0.899674, 4.688874>,
      <-1.000000, 0.104096, 5.187671>, <-1.000000, -0.550000, 5.187671>, <-0.550000, -1.000000, 5.187671>, <0.000000, -1.000000, 5.187671>,
      <-0.824197, 0.046675, 5.697148>, <-0.824197, -0.574484, 5.697148>, <-0.619528, -1.082705, 5.416516>, <0.043174, -1.082705, 5.848257>,
      <-0.824197, 0.046675, 6.189558>, <-0.824197, -0.574484, 6.189558>, <-0.785833, -1.082705, 6.483435>, <-0.123131, -1.012006, 6.884954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.050821, -0.899674, 4.688874>, <0.550000, -0.942432, 4.688915>, <1.000000, -0.458665, 4.664094>, <1.000000, 0.100583, 4.716787>,
      <0.000000, -1.000000, 5.187671>, <0.550000, -1.000000, 5.187671>, <1.000000, -0.550000, 5.187671>, <1.000000, 0.104096, 5.187671>,
      <0.043174, -1.082705, 5.848257>, <0.705877, -1.082705, 6.279998>, <1.730852, -0.574484, 7.165066>, <1.730852, 0.046675, 7.165066>,
      <-0.123131, -1.012006, 6.884954>, <0.539572, -0.941308, 7.286473>, <0.716262, -0.499458, 7.358974>, <0.716262, 0.040580, 7.358974>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, 0.100583, 4.716787>, <1.000000, 0.659831, 4.769480>, <0.550000, 1.109831, 4.769480>, <0.050821, 1.159012, 4.769439>,
      <1.000000, 0.104096, 5.187671>, <1.000000, 0.758192, 5.187671>, <0.550000, 1.208192, 5.187671>, <0.000000, 1.208192, 5.187671>,
      <1.730852, 0.046675, 7.165066>, <1.730852, 0.667834, 7.165066>, <0.705877, 1.176055, 6.279998>, <0.043174, 1.176055, 5.848257>,
      <0.716262, 0.040580, 7.358974>, <0.716262, 0.580618, 7.358974>, <0.539572, 1.022467, 7.286473>, <-0.123131, 1.099261, 6.884954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.050821, 1.159012, 4.769439>, <-0.448358, 1.208192, 4.769398>, <-0.970400, 0.758192, 4.779004>, <-0.970400, 0.104096, 4.779004>,
      <0.000000, 1.208192, 5.187671>, <-0.550000, 1.208192, 5.187671>, <-1.000000, 0.758192, 5.187671>, <-1.000000, 0.104096, 5.187671>,
      <0.043174, 1.176055, 5.848257>, <-0.619528, 1.176055, 5.416516>, <-0.824197, 0.667834, 5.697148>, <-0.824197, 0.046675, 5.697148>,
      <-0.123131, 1.099261, 6.884954>, <-0.785833, 1.176055, 6.483435>, <-0.824197, 0.667834, 6.189558>, <-0.824197, 0.046675, 6.189558>
    }
  }
  texture {
    LegTex
  }
  scale <0.3, -0.3, 0.3>
  rotate <-161.418503, 52.231911, 69.935326>
  translate  <7.635847, -1.870864, 4.729477>
}


#declare Hand = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.006510, -3.157813, -1.886608>, <-0.887651, -3.157813, -1.867769>, <-1.247921, -3.173034, -1.228095>, <-1.137391, -3.177115, -0.818104>,
      <-0.006796, -2.675679, -2.255481>, <-1.524680, -2.668815, -2.012925>, <-2.086382, -2.692137, -1.119639>, <-1.762727, -2.692137, -0.533442>,
      <-0.006938, -2.189627, -2.289692>, <-1.767622, -2.184009, -2.009477>, <-2.449537, -2.207331, -1.065986>, <-2.074697, -2.207331, -0.469398>,
      <-0.006938, -1.653108, -2.289692>, <-1.888101, -1.657832, -2.009477>, <-2.616495, -1.681342, -1.065986>, <-2.216105, -1.681342, -0.469398>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.006938, -1.653108, -2.289692>, <-1.888101, -1.657832, -2.009477>, <-2.616495, -1.681342, -1.065986>, <-2.216105, -1.681342, -0.469398>,
      <-0.006938, -1.116589, -2.289692>, <-2.008580, -1.131655, -2.009477>, <-2.783452, -1.155353, -1.065986>, <-2.357514, -1.155353, -0.469398>,
      <-0.006938, -0.580070, -2.289692>, <-2.099848, -0.580070, -2.009477>, <-2.909930, -0.603452, -1.065986>, <-2.464638, -0.603452, -0.469398>,
      <-0.006938, -0.017409, -2.299769>, <-2.101038, -0.021796, -2.020442>, <-2.915326, -0.222821, -1.115725>, <-2.468061, -0.324074, -0.500953>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.006938, -0.017409, -2.299769>, <-2.101038, -0.021796, -2.020442>, <-2.915326, -0.222821, -1.115725>, <-2.468061, -0.324074, -0.500953>,
      <-0.006938, 0.545253, -2.309846>, <-2.102227, 0.536479, -2.031407>, <-2.920722, 0.157811, -1.165463>, <-2.471484, -0.044696, -0.532507>,
      <-0.006938, 1.044874, -2.082121>, <-2.077693, 1.036100, -1.805254>, <-2.896188, 0.657432, -0.939310>, <-2.455707, 0.454245, -0.387070>,
      <-0.027956, 1.656916, -1.772559>, <-2.053159, 1.442191, -1.497263>, <-2.871654, 1.157052, -0.713158>, <-2.431173, 0.953866, -0.160917>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.027956, 1.656916, -1.772559>, <-2.053159, 1.442191, -1.497263>, <-2.871654, 1.157052, -0.713158>, <-2.431173, 0.953866, -0.160917>,
      <-0.048975, 2.268958, -1.462996>, <-2.028625, 1.848283, -1.189273>, <-2.847120, 1.656673, -0.487005>, <-2.406639, 1.453487, 0.065235>,
      <-0.048975, 2.721815, -0.978066>, <-2.004091, 2.301139, -0.752679>, <-2.822586, 2.156294, -0.260853>, <-2.382105, 1.953108, 0.291388>,
      <-0.050716, 2.724868, -0.621956>, <-1.363022, 2.175500, -0.342075>, <-1.929612, 2.235486, -0.571214>, <-1.646560, 2.145840, -0.301667>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.137391, -3.177115, -0.818104>, <-1.026860, -3.181196, -0.408113>, <-0.416718, -3.181196, -0.518989>, <-0.024246, -3.171960, -0.466419>,
      <-1.762727, -2.692137, -0.533442>, <-1.439073, -2.692137, 0.052755>, <-0.724817, -2.699062, -0.140686>, <-0.343696, -2.577428, 0.411127>,
      <-2.074697, -2.207331, -0.469398>, <-1.699856, -2.207331, 0.127191>, <-0.877259, -2.213009, -0.702434>, <-0.354416, -2.214682, 0.072101>,
      <-2.216105, -1.681342, -0.469398>, <-1.815716, -1.681342, 0.127191>, <-0.634372, -1.676490, -0.685839>, <-0.176274, -1.764715, 0.173319>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.216105, -1.681342, -0.469398>, <-1.815716, -1.681342, 0.127191>, <-0.634372, -1.676490, -0.685839>, <-0.176274, -1.764715, 0.173319>,
      <-2.357514, -1.155353, -0.469398>, <-1.931577, -1.155353, 0.127191>, <-0.391484, -1.139971, -0.669243>, <0.001867, -1.314748, 0.274537>,
      <-2.464638, -0.603452, -0.469398>, <-2.019346, -0.603452, 0.127191>, <-0.391484, -0.603452, -0.669243>, <-0.036768, -0.927065, 0.274537>,
      <-2.468061, -0.324074, -0.500953>, <-2.020796, -0.425328, 0.113820>, <-0.785229, -0.425328, -0.704266>, <-0.128536, -0.557236, 0.228427>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.468061, -0.324074, -0.500953>, <-2.020796, -0.425328, 0.113820>, <-0.785229, -0.425328, -0.704266>, <-0.128536, -0.557236, 0.228427>,
      <-2.471484, -0.044696, -0.532507>, <-2.022247, -0.247203, 0.100448>, <-1.178975, -0.247203, -0.739289>, <-0.220305, -0.187406, 0.182317>,
      <-2.455707, 0.454245, -0.387070>, <-2.015226, 0.251059, 0.165171>, <-1.179090, 0.143213, -0.690793>, <0.112299, 0.291494, -0.565055>,
      <-2.431173, 0.953866, -0.160917>, <-1.990692, 0.750680, 0.391323>, <-1.335638, 0.696757, -0.067131>, <0.000374, 0.770897, -0.001612>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.431173, 0.953866, -0.160917>, <-1.990692, 0.750680, 0.391323>, <-1.335638, 0.696757, -0.067131>, <0.000374, 0.770897, -0.001612>,
      <-2.406639, 1.453487, 0.065235>, <-1.966158, 1.250301, 0.617476>, <-1.492186, 1.250301, 0.556531>, <-0.111550, 1.250301, 0.561831>,
      <-2.382105, 1.953108, 0.291388>, <-1.941623, 1.749922, 0.843629>, <-1.011189, 1.749922, 0.723989>, <-0.105163, 1.955872, 0.726845>,
      <-1.646560, 2.145840, -0.301667>, <-1.363508, 2.056195, -0.032121>, <-0.725798, 2.050228, -0.208735>, <-0.065005, 2.256179, -0.159282>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.024246, -3.171960, -0.466419>, <0.368226, -3.162725, -0.413849>, <1.008664, -3.162725, -0.261969>, <1.254433, -3.171960, -0.723971>,
      <-0.343696, -2.577428, 0.411127>, <0.037426, -2.455795, 0.962940>, <1.243216, -2.455795, 1.156186>, <1.868178, -2.577428, 0.053960>,
      <-0.354416, -2.214682, 0.072101>, <0.168428, -2.216355, 0.846635>, <1.638938, -2.216355, 1.212735>, <2.280971, -2.214682, 0.115392>,
      <-0.176274, -1.764715, 0.173319>, <0.281823, -1.852940, 1.032476>, <1.638938, -1.852940, 1.398576>, <2.280971, -1.764715, 0.208312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.176274, -1.764715, 0.173319>, <0.281823, -1.852940, 1.032476>, <1.638938, -1.852940, 1.398576>, <2.280971, -1.764715, 0.208312>,
      <0.001867, -1.314748, 0.274537>, <0.395219, -1.489525, 1.218317>, <1.638938, -1.489525, 1.584417>, <2.280971, -1.314748, 0.301233>,
      <-0.036768, -0.927065, 0.274537>, <0.317948, -1.250678, 1.218317>, <1.694085, -1.250678, 1.584417>, <2.308544, -0.927065, 0.301233>,
      <-0.128536, -0.557236, 0.228427>, <0.528156, -0.689144, 1.161120>, <1.713788, -0.689144, 1.472385>, <2.321710, -0.455982, 0.220436>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.128536, -0.557236, 0.228427>, <0.528156, -0.689144, 1.161120>, <1.713788, -0.689144, 1.472385>, <2.321710, -0.455982, 0.220436>,
      <-0.220305, -0.187406, 0.182317>, <0.738365, -0.127610, 1.103922>, <1.733490, -0.127610, 1.360353>, <2.334875, 0.015100, 0.139639>,
      <0.112299, 0.291494, -0.565055>, <1.403687, 0.439775, -0.439318>, <1.542874, -0.038027, 0.470225>, <2.224498, 0.309702, -0.192750>,
      <0.000374, 0.770897, -0.001612>, <1.336387, 0.845038, 0.063907>, <1.740335, 0.606137, 0.571680>, <2.297650, 1.022335, -0.029349>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000374, 0.770897, -0.001612>, <1.336387, 0.845038, 0.063907>, <1.740335, 0.606137, 0.571680>, <2.297650, 1.022335, -0.029349>,
      <-0.111550, 1.250301, 0.561831>, <1.269086, 1.250301, 0.567132>, <1.937796, 1.250301, 0.673134>, <2.370803, 1.734968, 0.134052>,
      <-0.105163, 1.955872, 0.726845>, <0.800864, 2.161823, 0.729700>, <1.865620, 2.312883, 0.898482>, <2.319646, 2.516069, 0.359401>,
      <-0.065005, 2.256179, -0.159282>, <0.595787, 2.462130, -0.109829>, <1.305534, 2.619156, 0.005426>, <1.595173, 2.708802, -0.255696>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.254433, -3.171960, -0.723971>, <1.500201, -3.181196, -1.185973>, <1.191571, -3.157813, -1.701784>, <-0.005811, -3.157813, -1.886608>,
      <1.868178, -2.577428, 0.053960>, <2.493140, -2.699062, -1.048266>, <1.922290, -2.675679, -1.950207>, <-0.005573, -2.675679, -2.255481>,
      <2.280971, -2.214682, 0.115392>, <2.923004, -2.213009, -0.981952>, <2.223006, -2.189627, -1.936320>, <-0.005486, -2.189627, -2.289692>,
      <2.280971, -1.764715, 0.208312>, <2.923004, -1.676490, -0.981952>, <2.223006, -1.653108, -1.936320>, <-0.005486, -1.653108, -2.289692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.280971, -1.764715, 0.208312>, <2.923004, -1.676490, -0.981952>, <2.223006, -1.653108, -1.936320>, <-0.005486, -1.653108, -2.289692>,
      <2.280971, -1.314748, 0.301233>, <2.923004, -1.139971, -0.981952>, <2.223006, -1.116589, -1.936320>, <-0.005486, -1.116589, -2.289692>,
      <2.308544, -0.927065, 0.301233>, <2.923004, -0.603452, -0.981952>, <2.223006, -0.580070, -1.936320>, <-0.005486, -0.580070, -2.289692>,
      <2.321710, -0.455982, 0.220436>, <2.929632, -0.222821, -1.031513>, <2.224467, -0.021796, -1.947246>, <-0.005486, -0.017409, -2.299769>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.321710, -0.455982, 0.220436>, <2.929632, -0.222821, -1.031513>, <2.224467, -0.021796, -1.947246>, <-0.005486, -0.017409, -2.299769>,
      <2.334875, 0.015100, 0.139639>, <2.936260, 0.157811, -1.081074>, <2.225928, 0.536479, -1.958172>, <-0.005486, 0.545253, -2.309846>,
      <2.224498, 0.309702, -0.192750>, <2.906122, 0.657432, -0.855726>, <2.195790, 1.036100, -1.732824>, <-0.005486, 1.044874, -2.082121>,
      <2.297650, 1.022335, -0.029349>, <2.854966, 1.438533, -0.630378>, <2.144634, 1.700289, -1.378873>, <-0.026505, 1.656916, -1.772559>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.297650, 1.022335, -0.029349>, <2.854966, 1.438533, -0.630378>, <2.144634, 1.700289, -1.378873>, <-0.026505, 1.656916, -1.772559>,
      <2.370803, 1.734968, 0.134052>, <2.803809, 2.219635, -0.405029>, <2.093477, 2.364479, -1.024922>, <-0.047524, 2.268958, -1.462996>,
      <2.319646, 2.516069, 0.359401>, <2.773671, 2.719255, -0.179681>, <2.063340, 2.864100, -0.682662>, <-0.047524, 2.721815, -0.978066>,
      <1.595173, 2.708802, -0.255696>, <1.884811, 2.798447, -0.516817>, <1.385624, 2.738461, -0.295797>, <-0.049748, 2.724868, -0.621956>
    }
  }
  texture {
    Tan
  }
  scale 0.1
  rotate <94.162796, 0.489687, -89.964355>
  translate  <5.131826, 2.133102, 5.571817>
}
#declare Pekfinger = union {
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.000000, -0.250929, 0.000000>, <-1.000000, -0.774889, 0.000000>, <-0.550000, -1.203584, 0.000000>, <0.000000, -1.203584, 0.000000>,
      <-1.000000, -0.167286, 3.314606>, <-1.000000, -0.691246, 3.314606>, <-0.550000, -1.119941, 3.314606>, <0.000000, -1.119941, 3.314606>,
      <-1.000000, -0.071398, 3.336002>, <-1.000000, -0.499470, 3.336002>, <-0.550000, -0.841778, 3.342413>, <0.000000, -0.841778, 3.342413>,
      <-1.000000, -0.126066, 3.425059>, <-1.000000, -0.592945, 3.380326>, <-0.550000, -0.895779, 3.375881>, <0.000000, -0.895779, 3.375881>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.203584, 0.000000>, <0.550000, -1.203584, 0.000000>, <1.000000, -0.774889, 0.000000>, <1.000000, -0.250929, 0.000000>,
      <0.000000, -1.119941, 3.314606>, <0.550000, -1.119941, 3.314606>, <1.000000, -0.691246, 3.314606>, <1.000000, -0.167286, 3.314606>,
      <0.000000, -0.841778, 3.342413>, <0.550000, -0.841778, 3.342413>, <1.000000, -0.499470, 3.336002>, <1.000000, -0.071398, 3.336002>,
      <0.000000, -0.895779, 3.375881>, <0.550000, -0.895779, 3.375881>, <1.000000, -0.592945, 3.380326>, <1.000000, -0.126066, 3.425059>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.000000, -0.250929, 0.000000>, <1.000000, 0.273031, 0.000000>, <0.550000, 0.952655, 0.000000>, <0.000000, 0.952655, 0.000000>,
      <1.000000, -0.167286, 3.314606>, <1.000000, 0.356674, 3.314606>, <0.550000, 0.952655, 3.310557>, <0.000000, 0.952655, 3.310557>,
      <1.000000, -0.071398, 3.336002>, <1.000000, 0.356674, 3.336002>, <0.550000, 0.952655, 3.336002>, <0.000000, 0.952655, 3.336002>,
      <1.000000, -0.126066, 3.425059>, <1.000000, 0.340813, 3.469791>, <0.550000, 0.928262, 3.521001>, <0.000000, 0.928262, 3.521001>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.952655, 0.000000>, <-0.550000, 0.952655, 0.000000>, <-1.000000, 0.273031, 0.000000>, <-1.000000, -0.250929, 0.000000>,
      <0.000000, 0.952655, 3.310557>, <-0.550000, 0.952655, 3.310557>, <-1.000000, 0.356674, 3.314606>, <-1.000000, -0.167286, 3.314606>,
      <0.000000, 0.952655, 3.336002>, <-0.550000, 0.952655, 3.336002>, <-1.000000, 0.356674, 3.336002>, <-1.000000, -0.071398, 3.336002>,
      <0.000000, 0.928262, 3.521001>, <-0.550000, 0.928262, 3.521001>, <-1.000000, 0.340813, 3.469791>, <-1.000000, -0.126066, 3.425059>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.000000, -0.126066, 3.425059>, <-1.000000, -0.592945, 3.380326>, <-0.550000, -0.895779, 3.375881>, <0.000000, -0.895779, 3.375881>,
      <-1.000000, -0.180734, 3.514115>, <-1.000000, -0.686419, 3.424651>, <-0.550000, -0.949781, 3.409348>, <0.000000, -0.949781, 3.409348>,
      <-1.000000, -0.320560, 5.283212>, <-1.000000, -0.837907, 5.191685>, <-0.550000, -1.133248, 5.139434>, <0.000000, -1.133248, 5.139434>,
      <-0.963432, -0.351308, 6.051511>, <-0.963432, -0.828336, 5.948400>, <-0.529888, -1.200871, 5.893482>, <0.000000, -1.200010, 5.892621>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.895779, 3.375881>, <0.550000, -0.895779, 3.375881>, <1.000000, -0.592945, 3.380326>, <1.000000, -0.126066, 3.425059>,
      <0.000000, -0.949781, 3.409348>, <0.550000, -0.949781, 3.409348>, <1.000000, -0.686419, 3.424651>, <1.000000, -0.180734, 3.514115>,
      <0.000000, -1.133248, 5.139434>, <0.550000, -1.133248, 5.139434>, <1.000000, -0.837907, 5.191685>, <1.000000, -0.320560, 5.283212>,
      <0.000000, -1.200010, 5.892621>, <0.529888, -1.199149, 5.891760>, <0.963432, -0.828336, 5.948400>, <0.963432, -0.351308, 6.051511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.000000, -0.126066, 3.425059>, <1.000000, 0.340813, 3.469791>, <0.550000, 0.928262, 3.521001>, <0.000000, 0.928262, 3.521001>,
      <1.000000, -0.180734, 3.514115>, <1.000000, 0.324951, 3.603580>, <0.550000, 0.903868, 3.706000>, <0.000000, 0.903868, 3.706000>,
      <1.000000, -0.320560, 5.283212>, <1.000000, 0.196787, 5.374740>, <0.550000, 0.702658, 5.464237>, <0.000000, 0.702658, 5.464237>,
      <0.963432, -0.351308, 6.051511>, <0.963432, 0.125720, 6.154621>, <0.529888, 0.590297, 6.236813>, <0.000000, 0.590297, 6.236813>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.928262, 3.521001>, <-0.550000, 0.928262, 3.521001>, <-1.000000, 0.340813, 3.469791>, <-1.000000, -0.126066, 3.425059>,
      <0.000000, 0.903868, 3.706000>, <-0.550000, 0.903868, 3.706000>, <-1.000000, 0.324951, 3.603580>, <-1.000000, -0.180734, 3.514115>,
      <0.000000, 0.702658, 5.464237>, <-0.550000, 0.702658, 5.464237>, <-1.000000, 0.196787, 5.374740>, <-1.000000, -0.320560, 5.283212>,
      <0.000000, 0.590297, 6.236813>, <-0.529888, 0.590297, 6.236813>, <-0.963432, 0.125720, 6.154621>, <-0.963432, -0.351308, 6.051511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.963432, -0.351308, 6.051511>, <-0.963432, -0.828336, 5.948400>, <-0.529888, -1.200871, 5.893482>, <0.000000, -1.200010, 5.892621>,
      <-0.926865, -0.382057, 6.819809>, <-0.926865, -0.818766, 6.705116>, <-0.509776, -1.268495, 6.647530>, <0.000000, -1.266772, 6.645808>,
      <-0.873312, -0.359247, 6.859274>, <-0.873312, -0.772907, 6.762783>, <-0.480322, -1.029653, 6.698310>, <0.000000, -1.029653, 6.698310>,
      <-0.887773, -0.413322, 6.890989>, <-0.887773, -0.875835, 6.769851>, <-0.488275, -1.221352, 6.707729>, <0.000000, -1.221352, 6.707729>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.200010, 5.892621>, <0.529888, -1.199149, 5.891760>, <0.963432, -0.828336, 5.948400>, <0.963432, -0.351308, 6.051511>,
      <0.000000, -1.266772, 6.645808>, <0.509776, -1.265050, 6.644086>, <0.926865, -0.818766, 6.705116>, <0.926865, -0.382057, 6.819809>,
      <0.000000, -1.029653, 6.698310>, <0.480322, -1.029653, 6.698310>, <0.873312, -0.772907, 6.762783>, <0.873312, -0.359247, 6.859274>,
      <0.000000, -1.221352, 6.707729>, <0.488275, -1.221352, 6.707729>, <0.887773, -0.875835, 6.769851>, <0.887773, -0.413322, 6.890989>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.963432, -0.351308, 6.051511>, <0.963432, 0.125720, 6.154621>, <0.529888, 0.590297, 6.236813>, <0.000000, 0.590297, 6.236813>,
      <0.926865, -0.382057, 6.819809>, <0.926865, 0.054652, 6.934502>, <0.509776, 0.477936, 7.009388>, <0.000000, 0.477936, 7.009388>,
      <0.873312, -0.359247, 6.859274>, <0.873312, 0.054413, 6.955764>, <0.480322, 0.471954, 7.038307>, <0.000000, 0.471954, 7.038307>,
      <0.887773, -0.413322, 6.890989>, <0.887773, 0.049191, 7.012128>, <0.488275, 0.460310, 7.105839>, <0.000000, 0.460310, 7.105839>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.590297, 6.236813>, <-0.529888, 0.590297, 6.236813>, <-0.963432, 0.125720, 6.154621>, <-0.963432, -0.351308, 6.051511>,
      <0.000000, 0.477936, 7.009388>, <-0.509776, 0.477936, 7.009388>, <-0.926865, 0.054652, 6.934502>, <-0.926865, -0.382057, 6.819809>,
      <0.000000, 0.471954, 7.038307>, <-0.480322, 0.471954, 7.038307>, <-0.873312, 0.054413, 6.955764>, <-0.873312, -0.359247, 6.859274>,
      <0.000000, 0.460310, 7.105839>, <-0.488275, 0.460310, 7.105839>, <-0.887773, 0.049191, 7.012128>, <-0.887773, -0.413322, 6.890989>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.887773, -0.413322, 6.890989>, <-0.887773, -0.875835, 6.769851>, <-0.488275, -1.221352, 6.707729>, <0.000000, -1.221352, 6.707729>,
      <-0.902233, -0.467397, 6.922705>, <-0.902233, -0.978763, 6.776919>, <-0.496228, -1.413051, 6.717148>, <0.000000, -1.413051, 6.717148>,
      <-1.062390, -0.700845, 9.359888>, <-1.062390, -1.406578, 9.094939>, <-0.584314, -1.757671, 8.996404>, <0.000000, -1.757671, 8.996404>,
      <-0.165154, -0.591817, 9.383751>, <-0.165154, -0.589409, 9.384427>, <-0.104148, -0.587439, 9.384980>, <-0.029585, -0.587439, 9.384980>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.221352, 6.707729>, <0.488275, -1.221352, 6.707729>, <0.887773, -0.875835, 6.769851>, <0.887773, -0.413322, 6.890989>,
      <0.000000, -1.413051, 6.717148>, <0.496228, -1.413051, 6.717148>, <0.902233, -0.978763, 6.776919>, <0.902233, -0.467397, 6.922705>,
      <0.000000, -1.757671, 8.996404>, <0.584314, -1.757671, 8.996404>, <1.062390, -1.406578, 9.094939>, <1.062390, -0.700845, 9.359888>,
      <-0.029585, -0.587439, 9.384980>, <0.044978, -0.587439, 9.384980>, <0.105984, -0.589409, 9.384427>, <0.105984, -0.591817, 9.383751>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.887773, -0.413322, 6.890989>, <0.887773, 0.049191, 7.012128>, <0.488275, 0.460310, 7.105839>, <0.000000, 0.460310, 7.105839>,
      <0.902233, -0.467397, 6.922705>, <0.902233, 0.043969, 7.068491>, <0.496228, 0.448665, 7.173372>, <0.000000, 0.448665, 7.173372>,
      <1.062390, -0.700845, 9.359888>, <1.062390, 0.004888, 9.624837>, <0.584314, 0.068616, 9.308302>, <0.000000, 0.068616, 9.308302>,
      <0.105984, -0.591817, 9.383751>, <0.105984, -0.594225, 9.383075>, <0.044978, -0.596196, 9.382522>, <-0.029585, -0.596196, 9.382522>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.460310, 7.105839>, <-0.488275, 0.460310, 7.105839>, <-0.887773, 0.049191, 7.012128>, <-0.887773, -0.413322, 6.890989>,
      <0.000000, 0.448665, 7.173372>, <-0.496228, 0.448665, 7.173372>, <-0.902233, 0.043969, 7.068491>, <-0.902233, -0.467397, 6.922705>,
      <0.000000, 0.068616, 9.308302>, <-0.584314, 0.068616, 9.308302>, <-1.062390, 0.004888, 9.624837>, <-1.062390, -0.700845, 9.359888>,
      <-0.029585, -0.596196, 9.382522>, <-0.104148, -0.596196, 9.382522>, <-0.165154, -0.594225, 9.383075>, <-0.165154, -0.591817, 9.383751>
    }
  }
  texture {
    Tan
  }
  scale 0.057041
  rotate <36.018749, -3.577227, -72.951027>
  translate  <5.122972, 1.950087, 5.799259>
}
#declare Langfinger = union {
  object {
    bicubic_patch { type 1 flatness 0.0030 u_steps 3 v_steps 3,
      <-1.268156, -0.250929, -0.657366>, <-1.268156, -0.774889, 0.000000>, <-0.697486, -1.203584, 0.000000>, <0.000000, -1.203584, 0.000000>,
      <-1.268156, -0.217233, 3.346293>, <-1.268156, -0.691246, 2.794392>, <-0.697486, -1.805823, 2.939228>, <0.000000, -1.805823, 2.939228>,
      <-1.268156, -0.235159, 3.466028>, <-1.268156, -0.602479, 2.893012>, <-0.697486, -0.771257, 2.811353>, <0.000000, -0.771257, 2.811353>,
      <-1.256983, -0.521424, 3.422473>, <-1.268156, -0.830774, 2.849203>, <-0.697486, -0.983866, 2.747612>, <0.000000, -0.983866, 2.747612>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0030 u_steps 3 v_steps 3,
      <0.000000, -1.203584, 0.000000>, <0.697486, -1.203584, 0.000000>, <1.268156, -0.774889, 0.000000>, <1.268156, -0.250929, -0.657366>,
      <0.000000, -1.805823, 2.939228>, <0.697486, -1.805823, 2.939228>, <1.268156, -0.691246, 2.794392>, <1.268156, -0.217233, 3.346293>,
      <0.000000, -0.771257, 2.811353>, <0.697486, -0.771257, 2.811353>, <1.268156, -0.602479, 2.893012>, <1.268156, -0.183530, 3.396076>,
      <0.000000, -0.983866, 2.747612>, <0.697486, -0.983866, 2.747612>, <1.268156, -0.830774, 2.849203>, <1.256983, -0.495610, 3.387497>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0030 u_steps 3 v_steps 3,
      <1.268156, -0.250929, -0.657366>, <1.268156, 0.273031, -1.314733>, <0.697486, 0.952655, -1.314733>, <0.000000, 0.952655, -1.314733>,
      <1.268156, -0.217233, 3.346293>, <1.268156, 0.256781, 3.898195>, <0.697486, 0.894332, 3.873363>, <0.000000, 0.894332, 3.873363>,
      <1.268156, -0.183530, 3.396076>, <1.268156, 0.235418, 3.899139>, <0.697486, 0.872969, 3.874308>, <0.000000, 0.872969, 3.874308>,
      <1.256983, -0.495610, 3.387497>, <1.268156, -0.160446, 3.925791>, <0.697486, 0.456167, 4.189786>, <0.000000, 0.456167, 4.189786>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0030 u_steps 3 v_steps 3,
      <0.000000, 0.952655, -1.314733>, <-0.697486, 0.952655, -1.314733>, <-1.268156, 0.273031, -1.314733>, <-1.268156, -0.250929, -0.657366>,
      <0.000000, 0.894332, 3.873363>, <-0.697486, 0.894332, 3.873363>, <-1.268156, 0.256781, 3.898195>, <-1.268156, -0.217233, 3.346293>,
      <0.000000, 0.872969, 3.874308>, <-0.697486, 0.872969, 3.874308>, <-1.268156, 0.132160, 4.039043>, <-1.268156, -0.235159, 3.466028>,
      <0.000000, 0.456167, 4.189786>, <-0.697486, 0.456167, 4.189786>, <-1.268156, -0.212075, 3.995743>, <-1.256983, -0.521424, 3.422473>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0030 u_steps 3 v_steps 3,
      <-1.256983, -0.521424, 3.422473>, <-1.268156, -0.830774, 2.849203>, <-0.697486, -0.983866, 2.747612>, <0.000000, -0.983866, 2.747612>,
      <-1.268156, -0.807689, 3.378919>, <-1.268156, -1.059069, 2.805395>, <-0.697486, -1.196476, 2.683872>, <0.000000, -1.196476, 2.683872>,
      <-1.268156, -1.575182, 3.325402>, <-1.268156, -1.553286, 2.766834>, <-0.697486, -1.592710, 2.557967>, <0.000000, -1.592710, 2.557967>,
      <-1.211427, -2.220332, 3.408513>, <-1.221783, -2.139714, 2.925916>, <-0.671981, -1.816207, 2.589374>, <0.000000, -1.816207, 2.589374>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0030 u_steps 3 v_steps 3,
      <0.000000, -0.983866, 2.747612>, <0.697486, -0.983866, 2.747612>, <1.268156, -0.830774, 2.849203>, <1.256983, -0.495610, 3.387497>,
      <0.000000, -1.196476, 2.683872>, <0.697486, -1.196476, 2.683872>, <1.268156, -1.059069, 2.805395>, <1.268156, -0.807689, 3.378919>,
      <0.000000, -1.592710, 2.557967>, <0.697486, -1.592710, 2.557967>, <1.268156, -1.553286, 2.766834>, <1.268156, -1.575182, 3.325402>,
      <0.000000, -1.816207, 2.589374>, <0.671981, -1.816207, 2.589374>, <1.221783, -2.139714, 2.925916>, <1.211427, -2.220332, 3.408513>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0030 u_steps 3 v_steps 3,
      <1.256983, -0.495610, 3.387497>, <1.268156, -0.160446, 3.925791>, <0.697486, 0.456167, 4.189786>, <0.000000, 0.456167, 4.189786>,
      <1.268156, -0.807689, 3.378919>, <1.268156, -0.556310, 3.952443>, <0.697486, 0.039365, 4.505265>, <0.000000, 0.039365, 4.505265>,
      <1.268156, -1.575182, 3.325402>, <1.268156, -1.597078, 3.883970>, <0.697486, -1.618489, 4.430148>, <0.000000, -1.618489, 4.430148>,
      <1.211427, -2.220332, 3.408513>, <1.221783, -2.300950, 3.891111>, <0.671981, -2.332436, 4.328856>, <0.000000, -2.332436, 4.328856>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0030 u_steps 3 v_steps 3,
      <0.000000, 0.456167, 4.189786>, <-0.697486, 0.456167, 4.189786>, <-1.268156, -0.212075, 3.995743>, <-1.256983, -0.521424, 3.422473>,
      <0.000000, 0.039365, 4.505265>, <-0.697486, 0.039365, 4.505265>, <-1.268156, -0.556310, 3.952443>, <-1.268156, -0.807689, 3.378919>,
      <0.000000, -1.618489, 4.430148>, <-0.697486, -1.618489, 4.430148>, <-1.268156, -1.597078, 3.883970>, <-1.268156, -1.575182, 3.325402>,
      <0.000000, -2.332436, 4.328856>, <-0.671981, -2.332436, 4.328856>, <-1.221783, -2.300950, 3.891111>, <-1.211427, -2.220332, 3.408513>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0030 u_steps 3 v_steps 3,
      <-1.211427, -2.220332, 3.408513>, <-1.221783, -2.139714, 2.925916>, <-0.671981, -1.816207, 2.589374>, <0.000000, -1.816207, 2.589374>,
      <-1.175410, -2.865482, 3.491624>, <-1.175410, -2.726141, 3.084997>, <-0.646475, -2.039704, 2.620782>, <0.000000, -2.039704, 2.620782>,
      <-1.107496, -2.970877, 3.554779>, <-1.107496, -2.920610, 3.222605>, <-0.609123, -2.592996, 2.615528>, <0.000000, -2.592996, 2.615528>,
      <-1.115754, -3.067477, 3.459111>, <-1.125835, -2.918671, 3.117677>, <-0.619209, -2.259979, 2.622476>, <0.000000, -2.259979, 2.622476>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0030 u_steps 3 v_steps 3,
      <0.000000, -1.816207, 2.589374>, <0.671981, -1.816207, 2.589374>, <1.221783, -2.139714, 2.925916>, <1.211427, -2.220332, 3.408513>,
      <0.000000, -2.039704, 2.620782>, <0.646475, -2.039704, 2.620782>, <1.175410, -2.726141, 3.084997>, <1.175410, -2.865482, 3.491624>,
      <0.000000, -2.592996, 2.615528>, <0.609123, -2.592996, 2.615528>, <1.107496, -2.920610, 3.222605>, <1.107496, -2.970877, 3.554779>,
      <0.000000, -2.259979, 2.622476>, <0.619209, -2.259979, 2.622476>, <1.125835, -2.918671, 3.117677>, <1.115754, -3.067477, 3.459111>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0030 u_steps 3 v_steps 3,
      <1.211427, -2.220332, 3.408513>, <1.221783, -2.300950, 3.891111>, <0.671981, -2.332436, 4.328856>, <0.000000, -2.332436, 4.328856>,
      <1.175410, -2.865482, 3.491624>, <1.175410, -3.004822, 3.898252>, <0.646475, -3.046383, 4.227564>, <0.000000, -3.046383, 4.227564>,
      <1.107496, -2.970877, 3.554779>, <1.107496, -3.021144, 3.886952>, <0.609123, -3.072343, 4.225288>, <0.000000, -3.072343, 4.225288>,
      <1.115754, -3.067477, 3.459111>, <1.125835, -3.216283, 3.800545>, <0.619209, -3.376323, 4.108703>, <0.000000, -3.376323, 4.108703>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0030 u_steps 3 v_steps 3,
      <0.000000, -2.332436, 4.328856>, <-0.671981, -2.332436, 4.328856>, <-1.221783, -2.300950, 3.891111>, <-1.211427, -2.220332, 3.408513>,
      <0.000000, -3.046383, 4.227564>, <-0.646475, -3.046383, 4.227564>, <-1.175410, -3.004822, 3.898252>, <-1.175410, -2.865482, 3.491624>,
      <0.000000, -3.072343, 4.225288>, <-0.609123, -3.072343, 4.225288>, <-1.107496, -3.021144, 3.886952>, <-1.107496, -2.970877, 3.554779>,
      <0.000000, -3.376323, 4.108703>, <-0.619209, -3.376323, 4.108703>, <-1.125835, -3.216283, 3.800545>, <-1.115754, -3.067477, 3.459111>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0030 u_steps 3 v_steps 3,
      <-1.115754, -3.067477, 3.459111>, <-1.125835, -2.918671, 3.117677>, <-0.619209, -2.259979, 2.622476>, <0.000000, -2.259979, 2.622476>,
      <-1.144173, -3.164077, 3.363443>, <-1.144173, -2.916732, 3.012748>, <-0.629295, -1.926962, 2.629424>, <0.000000, -1.926962, 2.629424>,
      <-1.347276, -3.140510, 0.149600>, <-1.347276, -1.949005, 0.172719>, <-0.741002, -1.921895, 0.432279>, <0.000000, -1.921895, 0.432279>,
      <-0.209441, -3.699812, 0.221941>, <-0.209441, -3.702306, 0.221787>, <-0.132076, -3.704346, 0.221661>, <-0.037518, -3.704346, 0.221661>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0030 u_steps 3 v_steps 3,
      <0.000000, -2.259979, 2.622476>, <0.619209, -2.259979, 2.622476>, <1.125835, -2.918671, 3.117677>, <1.115754, -3.067477, 3.459111>,
      <0.000000, -1.926962, 2.629424>, <0.629295, -1.926962, 2.629424>, <1.144173, -2.916732, 3.012748>, <1.144173, -3.164077, 3.363443>,
      <0.000000, -1.921895, 0.432279>, <0.741002, -1.921895, 0.432279>, <1.347276, -1.949005, 0.172719>, <1.347276, -3.140510, 0.149600>,
      <-0.037518, -3.704346, 0.221661>, <0.057039, -3.704346, 0.221661>, <0.134404, -3.702306, 0.221787>, <0.134404, -3.699812, 0.221941>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0030 u_steps 3 v_steps 3,
      <1.115754, -3.067477, 3.459111>, <1.125835, -3.216283, 3.800545>, <0.619209, -3.376323, 4.108703>, <0.000000, -3.376323, 4.108703>,
      <1.144173, -3.164077, 3.363443>, <1.144173, -3.411423, 3.714138>, <0.629295, -3.680303, 3.992117>, <0.000000, -3.680303, 3.992117>,
      <1.347276, -3.140510, 0.149600>, <1.347276, -4.332014, 0.126480>, <0.741002, -4.332958, 0.382442>, <0.000000, -4.332958, 0.382442>,
      <0.134404, -3.699812, 0.221941>, <0.134404, -3.697319, 0.222095>, <0.057039, -3.695279, 0.222221>, <-0.037518, -3.695279, 0.222221>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0030 u_steps 3 v_steps 3,
      <0.000000, -3.376323, 4.108703>, <-0.619209, -3.376323, 4.108703>, <-1.125835, -3.216283, 3.800545>, <-1.115754, -3.067477, 3.459111>,
      <0.000000, -3.680303, 3.992117>, <-0.629295, -3.680303, 3.992117>, <-1.144173, -3.411423, 3.714138>, <-1.144173, -3.164077, 3.363443>,
      <0.000000, -4.332958, 0.382442>, <-0.741002, -4.332958, 0.382442>, <-1.347276, -4.332014, 0.126480>, <-1.347276, -3.140510, 0.149600>,
      <-0.037518, -3.695279, 0.222221>, <-0.132076, -3.695279, 0.222221>, <-0.209441, -3.697319, 0.222095>, <-0.209441, -3.699812, 0.221941>
    }
  }
  texture {
    Tan
  }
  scale 0.057041
  rotate <92.840363, -0.266868, -89.677483>
  translate  <5.156987, 2.075758, 5.804138>
}
#declare Ringfinger = union {
  object {
    bicubic_patch { type 1 flatness 0.0030 u_steps 3 v_steps 3,
      <-1.208531, -0.250929, -0.630251>, <-1.208531, -0.774889, 0.000000>, <-0.664692, -1.203584, 0.000000>, <0.000000, -1.203584, 0.000000>,
      <-1.208531, -0.217233, 3.208263>, <-1.208531, -0.691246, 2.679127>, <-0.664692, -1.805823, 2.817989>, <0.000000, -1.805823, 2.817989>,
      <-1.208531, -0.235159, 3.323059>, <-1.208531, -0.602479, 2.773679>, <-0.664692, -0.771257, 2.695389>, <0.000000, -0.771257, 2.695389>,
      <-1.208531, -0.521424, 3.238497>, <-1.208531, -0.830774, 2.731678>, <-0.664692, -0.983866, 2.634277>, <0.000000, -0.983866, 2.600278>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0030 u_steps 3 v_steps 3,
      <0.000000, -1.203584, 0.000000>, <0.664692, -1.203584, 0.000000>, <1.208531, -0.774889, 0.000000>, <1.208531, -0.250929, -0.630251>,
      <0.000000, -1.805823, 2.817989>, <0.664692, -1.805823, 2.817989>, <1.208531, -0.691246, 2.679127>, <1.208531, -0.217233, 3.208263>,
      <0.000000, -0.771257, 2.695389>, <0.664692, -0.771257, 2.695389>, <1.208531, -0.602479, 2.773679>, <1.208531, -0.183530, 3.255992>,
      <0.000000, -0.983866, 2.600278>, <0.664692, -0.983866, 2.634277>, <1.208531, -0.830774, 2.731678>, <1.208531, -0.495610, 3.204964>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0030 u_steps 3 v_steps 3,
      <1.208531, -0.250929, -0.630251>, <1.208531, 0.273031, -1.260502>, <0.664692, 0.952655, -1.260502>, <0.000000, 0.952655, -1.260502>,
      <1.208531, -0.217233, 3.208263>, <1.208531, 0.256781, 3.737400>, <0.664692, 0.894332, 3.713592>, <0.000000, 0.894332, 3.713592>,
      <1.208531, -0.183530, 3.255992>, <1.208531, 0.235418, 3.738305>, <0.664692, 0.872969, 3.714498>, <0.000000, 0.872969, 3.714498>,
      <1.208531, -0.495610, 3.204964>, <1.208531, -0.160446, 3.763858>, <0.664692, 0.456167, 4.016963>, <0.000000, 0.456167, 3.959891>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0030 u_steps 3 v_steps 3,
      <0.000000, 0.952655, -1.260502>, <-0.664692, 0.952655, -1.260502>, <-1.208531, 0.273031, -1.260502>, <-1.208531, -0.250929, -0.630251>,
      <0.000000, 0.894332, 3.713592>, <-0.664692, 0.894332, 3.713592>, <-1.208531, 0.256781, 3.737400>, <-1.208531, -0.217233, 3.208263>,
      <0.000000, 0.872969, 3.714498>, <-0.664692, 0.872969, 3.714498>, <-1.208531, 0.132160, 3.872438>, <-1.208531, -0.235159, 3.323059>,
      <0.000000, 0.456167, 3.959891>, <-0.664692, 0.456167, 4.016963>, <-1.208531, -0.212075, 3.830924>, <-1.208531, -0.521424, 3.238497>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0030 u_steps 3 v_steps 3,
      <-1.208531, -0.521424, 3.238497>, <-1.208531, -0.830774, 2.731678>, <-0.664692, -0.983866, 2.634277>, <0.000000, -0.983866, 2.600278>,
      <-1.208531, -0.807689, 3.239543>, <-1.208531, -1.059069, 2.689676>, <-0.664692, -1.196476, 2.573165>, <0.000000, -1.196476, 2.573165>,
      <-1.208531, -1.575182, 3.188234>, <-1.208531, -1.553286, 2.652706>, <-0.664692, -1.592710, 2.452454>, <0.000000, -1.592710, 2.452454>,
      <-1.164338, -2.220332, 3.223685>, <-1.164338, -2.139714, 2.805226>, <-0.640386, -1.816207, 2.482566>, <0.000000, -1.816207, 2.449367>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0030 u_steps 3 v_steps 3,
      <0.000000, -0.983866, 2.600278>, <0.664692, -0.983866, 2.634277>, <1.208531, -0.830774, 2.731678>, <1.208531, -0.495610, 3.204964>,
      <0.000000, -1.196476, 2.573165>, <0.664692, -1.196476, 2.573165>, <1.208531, -1.059069, 2.689676>, <1.208531, -0.807689, 3.239543>,
      <0.000000, -1.592710, 2.452454>, <0.664692, -1.592710, 2.452454>, <1.208531, -1.553286, 2.652706>, <1.208531, -1.575182, 3.188234>,
      <0.000000, -1.816207, 2.449367>, <0.640386, -1.816207, 2.482566>, <1.164338, -2.139714, 2.805226>, <1.164338, -2.220332, 3.223685>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0030 u_steps 3 v_steps 3,
      <1.208531, -0.495610, 3.204964>, <1.208531, -0.160446, 3.763858>, <0.664692, 0.456167, 4.016963>, <0.000000, 0.456167, 3.959891>,
      <1.208531, -0.807689, 3.239543>, <1.208531, -0.556310, 3.789410>, <0.664692, 0.039365, 4.319428>, <0.000000, 0.039365, 4.319428>,
      <1.208531, -1.575182, 3.188234>, <1.208531, -1.597078, 3.723762>, <0.664692, -1.618489, 4.247410>, <0.000000, -1.618489, 4.247410>,
      <1.164338, -2.220332, 3.223685>, <1.164338, -2.300950, 3.730608>, <0.640386, -2.332436, 4.150296>, <0.000000, -2.332436, 4.096742>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0030 u_steps 3 v_steps 3,
      <0.000000, 0.456167, 3.959891>, <-0.664692, 0.456167, 4.016963>, <-1.208531, -0.212075, 3.830924>, <-1.208531, -0.521424, 3.238497>,
      <0.000000, 0.039365, 4.319428>, <-0.664692, 0.039365, 4.319428>, <-1.208531, -0.556310, 3.789410>, <-1.208531, -0.807689, 3.239543>,
      <0.000000, -1.618489, 4.247410>, <-0.664692, -1.618489, 4.247410>, <-1.208531, -1.597078, 3.723762>, <-1.208531, -1.575182, 3.188234>,
      <0.000000, -2.332436, 4.096742>, <-0.640386, -2.332436, 4.150296>, <-1.164338, -2.300950, 3.730608>, <-1.164338, -2.220332, 3.223685>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0030 u_steps 3 v_steps 3,
      <-1.164338, -2.220332, 3.223685>, <-1.164338, -2.139714, 2.805226>, <-0.640386, -1.816207, 2.482566>, <0.000000, -1.816207, 2.449367>,
      <-1.120145, -2.865482, 3.347600>, <-1.120145, -2.726141, 2.957745>, <-0.616080, -2.039704, 2.512678>, <0.000000, -2.039704, 2.512678>,
      <-1.055425, -2.970877, 3.408149>, <-1.055425, -2.920610, 3.089677>, <-0.580484, -2.592996, 2.507641>, <0.000000, -2.592996, 2.507641>,
      <-1.072901, -3.067477, 3.273820>, <-1.072901, -2.918671, 2.989077>, <-0.590095, -2.259979, 2.514302>, <0.000000, -2.259979, 2.480993>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0030 u_steps 3 v_steps 3,
      <0.000000, -1.816207, 2.449367>, <0.640386, -1.816207, 2.482566>, <1.164338, -2.139714, 2.805226>, <1.164338, -2.220332, 3.223685>,
      <0.000000, -2.039704, 2.512678>, <0.616080, -2.039704, 2.512678>, <1.120145, -2.726141, 2.957745>, <1.120145, -2.865482, 3.347600>,
      <0.000000, -2.592996, 2.507641>, <0.580484, -2.592996, 2.507641>, <1.055425, -2.920610, 3.089677>, <1.055425, -2.970877, 3.408149>,
      <0.000000, -2.259979, 2.480993>, <0.590095, -2.259979, 2.514302>, <1.072901, -2.918671, 2.989077>, <1.072901, -3.067477, 3.273820>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0030 u_steps 3 v_steps 3,
      <1.164338, -2.220332, 3.223685>, <1.164338, -2.300950, 3.730608>, <0.640386, -2.332436, 4.150296>, <0.000000, -2.332436, 4.096742>,
      <1.120145, -2.865482, 3.347600>, <1.120145, -3.004822, 3.737454>, <0.616080, -3.046383, 4.053182>, <0.000000, -3.046383, 4.053182>,
      <1.055425, -2.970877, 3.408149>, <1.055425, -3.021144, 3.726620>, <0.580484, -3.072343, 4.051001>, <0.000000, -3.072343, 4.051001>,
      <1.072901, -3.067477, 3.273820>, <1.072901, -3.216283, 3.643778>, <0.590095, -3.376323, 3.939224>, <0.000000, -3.376323, 3.888653>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0030 u_steps 3 v_steps 3,
      <0.000000, -2.332436, 4.096742>, <-0.640386, -2.332436, 4.150296>, <-1.164338, -2.300950, 3.730608>, <-1.164338, -2.220332, 3.223685>,
      <0.000000, -3.046383, 4.053182>, <-0.616080, -3.046383, 4.053182>, <-1.120145, -3.004822, 3.737454>, <-1.120145, -2.865482, 3.347600>,
      <0.000000, -3.072343, 4.051001>, <-0.580484, -3.072343, 4.051001>, <-1.055425, -3.021144, 3.726620>, <-1.055425, -2.970877, 3.408149>,
      <0.000000, -3.376323, 3.888653>, <-0.590095, -3.376323, 3.939224>, <-1.072901, -3.216283, 3.643778>, <-1.072901, -3.067477, 3.273820>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0030 u_steps 3 v_steps 3,
      <-1.072901, -3.067477, 3.273820>, <-1.072901, -2.918671, 2.989077>, <-0.590095, -2.259979, 2.514302>, <0.000000, -2.259979, 2.480993>,
      <-1.090377, -3.164077, 3.224706>, <-1.090377, -2.916732, 2.888476>, <-0.599707, -1.926962, 2.520963>, <0.000000, -1.926962, 2.520963>,
      <-1.283931, -3.140510, 0.143429>, <-1.283931, -1.949005, 0.165594>, <-0.706162, -1.921895, 0.414448>, <0.000000, -1.921895, 0.414448>,
      <-0.199593, -3.699812, 0.212786>, <-0.199593, -3.702306, 0.212638>, <-0.125866, -3.704346, 0.212517>, <-0.035754, -3.704346, 0.212517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0030 u_steps 3 v_steps 3,
      <0.000000, -2.259979, 2.480993>, <0.590095, -2.259979, 2.514302>, <1.072901, -2.918671, 2.989077>, <1.072901, -3.067477, 3.273820>,
      <0.000000, -1.926962, 2.520963>, <0.599707, -1.926962, 2.520963>, <1.090377, -2.916732, 2.888476>, <1.090377, -3.164077, 3.224706>,
      <0.000000, -1.921895, 0.414448>, <0.706162, -1.921895, 0.414448>, <1.283931, -1.949005, 0.165594>, <1.283931, -3.140510, 0.143429>,
      <-0.035754, -3.704346, 0.212517>, <0.054357, -3.704346, 0.212517>, <0.128085, -3.702306, 0.212638>, <0.128085, -3.699812, 0.212786>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0030 u_steps 3 v_steps 3,
      <1.072901, -3.067477, 3.273820>, <1.072901, -3.216283, 3.643778>, <0.590095, -3.376323, 3.939224>, <0.000000, -3.376323, 3.888653>,
      <1.090377, -3.164077, 3.224706>, <1.090377, -3.411423, 3.560935>, <0.599707, -3.680303, 3.827448>, <0.000000, -3.680303, 3.827448>,
      <1.283931, -3.140510, 0.143429>, <1.283931, -4.332014, 0.121263>, <0.706162, -4.332958, 0.366667>, <0.000000, -4.332958, 0.366667>,
      <0.128085, -3.699812, 0.212786>, <0.128085, -3.697319, 0.212934>, <0.054357, -3.695279, 0.213055>, <-0.035754, -3.695279, 0.213055>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0030 u_steps 3 v_steps 3,
      <0.000000, -3.376323, 3.888653>, <-0.590095, -3.376323, 3.939224>, <-1.072901, -3.216283, 3.643778>, <-1.072901, -3.067477, 3.273820>,
      <0.000000, -3.680303, 3.827448>, <-0.599707, -3.680303, 3.827448>, <-1.090377, -3.411423, 3.560935>, <-1.090377, -3.164077, 3.224706>,
      <0.000000, -4.332958, 0.366667>, <-0.706162, -4.332958, 0.366667>, <-1.283931, -4.332014, 0.121263>, <-1.283931, -3.140510, 0.143429>,
      <-0.035754, -3.695279, 0.213055>, <-0.125866, -3.695279, 0.213055>, <-0.199593, -3.697319, 0.212934>, <-0.199593, -3.699812, 0.212786>
    }
  }
  texture {
    Tan
  }
  scale 0.053
  rotate <94.471832, -13.20839, -97.247772>
  translate  <5.137565, 2.217742, 5.766797>
}
#declare Lillfinger = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.250929, 0.000000>, <-1.000000, -0.774889, 0.000000>, <-0.550000, -1.203584, 0.000000>, <0.000000, -1.203584, 0.000000>,
      <-1.000000, -0.167286, 3.314606>, <-1.000000, -0.691246, 3.314606>, <-0.550000, -1.119941, 3.314606>, <0.000000, -1.119941, 3.314606>,
      <-1.000000, -0.071398, 3.336002>, <-1.000000, -0.499470, 3.336002>, <-0.550000, -0.771257, 3.336002>, <0.000000, -0.771257, 3.336002>,
      <-1.000000, -0.126066, 3.425059>, <-1.000000, -0.592945, 3.380326>, <-0.550000, -0.871738, 3.355045>, <0.000000, -0.871738, 3.355045>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -1.203584, 0.000000>, <0.550000, -1.203584, 0.000000>, <1.000000, -0.774889, 0.000000>, <1.000000, -0.250929, 0.000000>,
      <0.000000, -1.119941, 3.314606>, <0.550000, -1.119941, 3.314606>, <1.000000, -0.691246, 3.314606>, <1.000000, -0.167286, 3.314606>,
      <0.000000, -0.771257, 3.336002>, <0.550000, -0.771257, 3.336002>, <1.000000, -0.499470, 3.336002>, <1.000000, -0.071398, 3.336002>,
      <0.000000, -0.871738, 3.355045>, <0.550000, -0.871738, 3.355045>, <1.000000, -0.592945, 3.380326>, <1.000000, -0.126066, 3.425059>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.250929, 0.000000>, <1.000000, 0.273031, 0.000000>, <0.550000, 0.952655, 0.000000>, <0.000000, 0.952655, 0.000000>,
      <1.000000, -0.167286, 3.314606>, <1.000000, 0.356674, 3.314606>, <0.550000, 0.952655, 3.314606>, <0.000000, 0.952655, 3.314606>,
      <1.000000, -0.071398, 3.336002>, <1.000000, 0.356674, 3.336002>, <0.550000, 0.952655, 3.336002>, <0.000000, 0.952655, 3.336002>,
      <1.000000, -0.126066, 3.425059>, <1.000000, 0.340813, 3.469791>, <0.550000, 0.928262, 3.521001>, <0.000000, 0.928262, 3.521001>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.952655, 0.000000>, <-0.550000, 0.952655, 0.000000>, <-1.000000, 0.273031, 0.000000>, <-1.000000, -0.250929, 0.000000>,
      <0.000000, 0.952655, 3.314606>, <-0.550000, 0.952655, 3.314606>, <-1.000000, 0.356674, 3.314606>, <-1.000000, -0.167286, 3.314606>,
      <0.000000, 0.952655, 3.336002>, <-0.550000, 0.952655, 3.336002>, <-1.000000, 0.356674, 3.336002>, <-1.000000, -0.071398, 3.336002>,
      <0.000000, 0.928262, 3.521001>, <-0.550000, 0.928262, 3.521001>, <-1.000000, 0.340813, 3.469791>, <-1.000000, -0.126066, 3.425059>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.126066, 3.425059>, <-1.000000, -0.592945, 3.380326>, <-0.550000, -0.871738, 3.355045>, <0.000000, -0.871738, 3.355045>,
      <-1.000000, -0.180734, 3.514115>, <-1.000000, -0.686419, 3.424651>, <-0.550000, -0.972219, 3.374088>, <0.000000, -0.972219, 3.374088>,
      <-1.000000, -0.320560, 5.283212>, <-1.000000, -0.837907, 5.191685>, <-0.550000, -1.133248, 5.139434>, <0.000000, -1.133248, 5.139434>,
      <-0.963432, -0.391627, 6.063093>, <-0.963432, -0.908974, 5.971566>, <-0.529888, -1.204316, 5.919315>, <0.000000, -1.204316, 5.919315>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.871738, 3.355045>, <0.550000, -0.871738, 3.355045>, <1.000000, -0.592945, 3.380326>, <1.000000, -0.126066, 3.425059>,
      <0.000000, -0.972219, 3.374088>, <0.550000, -0.972219, 3.374088>, <1.000000, -0.686419, 3.424651>, <1.000000, -0.180734, 3.514115>,
      <0.000000, -1.133248, 5.139434>, <0.550000, -1.133248, 5.139434>, <1.000000, -0.837907, 5.191685>, <1.000000, -0.320560, 5.283212>,
      <0.000000, -1.204316, 5.919315>, <0.529888, -1.204316, 5.919315>, <0.963432, -0.908974, 5.971566>, <0.963432, -0.391627, 6.063093>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.126066, 3.425059>, <1.000000, 0.340813, 3.469791>, <0.550000, 0.928262, 3.521001>, <0.000000, 0.928262, 3.521001>,
      <1.000000, -0.180734, 3.514115>, <1.000000, 0.324951, 3.603580>, <0.550000, 0.903868, 3.706000>, <0.000000, 0.903868, 3.706000>,
      <1.000000, -0.320560, 5.283212>, <1.000000, 0.196787, 5.374740>, <0.550000, 0.702658, 5.464237>, <0.000000, 0.702658, 5.464237>,
      <0.963432, -0.391627, 6.063093>, <0.963432, 0.125720, 6.154621>, <0.529888, 0.590297, 6.236813>, <0.000000, 0.590297, 6.236813>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.928262, 3.521001>, <-0.550000, 0.928262, 3.521001>, <-1.000000, 0.340813, 3.469791>, <-1.000000, -0.126066, 3.425059>,
      <0.000000, 0.903868, 3.706000>, <-0.550000, 0.903868, 3.706000>, <-1.000000, 0.324951, 3.603580>, <-1.000000, -0.180734, 3.514115>,
      <0.000000, 0.702658, 5.464237>, <-0.550000, 0.702658, 5.464237>, <-1.000000, 0.196787, 5.374740>, <-1.000000, -0.320560, 5.283212>,
      <0.000000, 0.590297, 6.236813>, <-0.529888, 0.590297, 6.236813>, <-0.963432, 0.125720, 6.154621>, <-0.963432, -0.391627, 6.063093>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.963432, -0.391627, 6.063093>, <-0.963432, -0.908974, 5.971566>, <-0.529888, -1.204316, 5.919315>, <0.000000, -1.204316, 5.919315>,
      <-0.926865, -0.462695, 6.842974>, <-0.926865, -0.980042, 6.751447>, <-0.509776, -1.275383, 6.699196>, <0.000000, -1.275383, 6.699196>,
      <-0.873312, -0.357333, 6.836305>, <-0.873312, -0.772907, 6.762783>, <-0.480322, -1.029653, 6.717360>, <0.000000, -1.029653, 6.717360>,
      <-0.887773, -0.417637, 6.868228>, <-0.887773, -0.884063, 6.758880>, <-0.488275, -1.224050, 6.676779>, <0.000000, -1.224050, 6.676779>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -1.204316, 5.919315>, <0.529888, -1.204316, 5.919315>, <0.963432, -0.908974, 5.971566>, <0.963432, -0.391627, 6.063093>,
      <0.000000, -1.275383, 6.699196>, <0.509776, -1.275383, 6.699196>, <0.926865, -0.980042, 6.751447>, <0.926865, -0.462695, 6.842974>,
      <0.000000, -1.029653, 6.717360>, <0.480322, -1.029653, 6.717360>, <0.873312, -0.772907, 6.762783>, <0.873312, -0.357333, 6.836305>,
      <0.000000, -1.224050, 6.676779>, <0.488275, -1.224050, 6.676779>, <0.887773, -0.884063, 6.758880>, <0.887773, -0.417637, 6.868228>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.963432, -0.391627, 6.063093>, <0.963432, 0.125720, 6.154621>, <0.529888, 0.590297, 6.236813>, <0.000000, 0.590297, 6.236813>,
      <0.926865, -0.462695, 6.842974>, <0.926865, 0.054652, 6.934502>, <0.509776, 0.477936, 7.009388>, <0.000000, 0.477936, 7.009388>,
      <0.873312, -0.357333, 6.836305>, <0.873312, 0.058241, 6.909827>, <0.480322, 0.481525, 6.984714>, <0.000000, 0.481525, 6.984714>,
      <0.887773, -0.417637, 6.868228>, <0.887773, 0.048789, 6.977577>, <0.488275, 0.472044, 7.074410>, <0.000000, 0.472044, 7.074410>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.590297, 6.236813>, <-0.529888, 0.590297, 6.236813>, <-0.963432, 0.125720, 6.154621>, <-0.963432, -0.391627, 6.063093>,
      <0.000000, 0.477936, 7.009388>, <-0.509776, 0.477936, 7.009388>, <-0.926865, 0.054652, 6.934502>, <-0.926865, -0.462695, 6.842974>,
      <0.000000, 0.481525, 6.984714>, <-0.480322, 0.481525, 6.984714>, <-0.873312, 0.058241, 6.909827>, <-0.873312, -0.357333, 6.836305>,
      <0.000000, 0.472044, 7.074410>, <-0.488275, 0.472044, 7.074410>, <-0.887773, 0.048789, 6.977577>, <-0.887773, -0.417637, 6.868228>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.887773, -0.417637, 6.868228>, <-0.887773, -0.884063, 6.758880>, <-0.488275, -1.224050, 6.676779>, <0.000000, -1.224050, 6.676779>,
      <-0.902233, -0.477942, 6.900152>, <-0.902233, -0.995220, 6.754977>, <-0.496228, -1.418448, 6.636198>, <0.000000, -1.418448, 6.636198>,
      <-1.062390, -0.700845, 9.359888>, <-1.062390, -1.406578, 9.094939>, <-0.584314, -1.757671, 8.996404>, <0.000000, -1.757671, 8.996404>,
      <-0.165154, -0.591817, 9.383751>, <-0.165154, -0.589409, 9.384427>, <-0.104148, -0.587439, 9.384980>, <-0.029585, -0.587439, 9.384980>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -1.224050, 6.676779>, <0.488275, -1.224050, 6.676779>, <0.887773, -0.884063, 6.758880>, <0.887773, -0.417637, 6.868228>,
      <0.000000, -1.418448, 6.636198>, <0.496228, -1.418448, 6.636198>, <0.902233, -0.995220, 6.754977>, <0.902233, -0.477942, 6.900152>,
      <0.000000, -1.757671, 8.996404>, <0.584314, -1.757671, 8.996404>, <1.062390, -1.406578, 9.094939>, <1.062390, -0.700845, 9.359888>,
      <-0.029585, -0.587439, 9.384980>, <0.044978, -0.587439, 9.384980>, <0.105984, -0.589409, 9.384427>, <0.105984, -0.591817, 9.383751>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.887773, -0.417637, 6.868228>, <0.887773, 0.048789, 6.977577>, <0.488275, 0.472044, 7.074410>, <0.000000, 0.472044, 7.074410>,
      <0.902233, -0.477942, 6.900152>, <0.902233, 0.039336, 7.045327>, <0.496228, 0.462564, 7.164106>, <0.000000, 0.462564, 7.164106>,
      <1.062390, -0.700845, 9.359888>, <1.062390, 0.004888, 9.624837>, <0.584314, 0.068616, 9.308302>, <0.000000, 0.068616, 9.308302>,
      <0.105984, -0.591817, 9.383751>, <0.105984, -0.594225, 9.383075>, <0.044978, -0.596196, 9.382522>, <-0.029585, -0.596196, 9.382522>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.472044, 7.074410>, <-0.488275, 0.472044, 7.074410>, <-0.887773, 0.048789, 6.977577>, <-0.887773, -0.417637, 6.868228>,
      <0.000000, 0.462564, 7.164106>, <-0.496228, 0.462564, 7.164106>, <-0.902233, 0.039336, 7.045327>, <-0.902233, -0.477942, 6.900152>,
      <0.000000, 0.068616, 9.308302>, <-0.584314, 0.068616, 9.308302>, <-1.062390, 0.004888, 9.624837>, <-1.062390, -0.700845, 9.359888>,
      <-0.029585, -0.596196, 9.382522>, <-0.104148, -0.596196, 9.382522>, <-0.165154, -0.594225, 9.383075>, <-0.165154, -0.591817, 9.383751>
    }
  }
  texture {
    Tan
  }
  scale 0.05
  rotate <34.779694, -17.504042, -87.079086>
  translate  <5.146006, 2.335102, 5.757412>
}
#declare Tumme = union {
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.755559, -0.731895, 1.643687>, <-1.554298, -0.702577, 2.082020>, <-0.854864, -1.091266, 3.293359>, <0.000000, -1.091266, 3.293359>,
      <-1.554298, -0.266503, 2.553872>, <-1.554298, -0.903901, 3.428182>, <-0.854864, -1.274865, 3.583482>, <0.000000, -1.274865, 3.583482>,
      <-1.554298, -0.236658, 3.809265>, <-1.554298, -0.859393, 3.912157>, <-0.854864, -1.352231, 4.279691>, <0.000000, -1.352231, 4.279691>,
      <-1.554298, -0.282723, 4.337769>, <-1.554298, -0.859330, 4.346165>, <-0.854864, -1.248649, 4.506551>, <0.000000, -1.248649, 4.519408>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.091266, 3.293359>, <0.854864, -1.091266, 3.293359>, <1.554298, -0.702577, 2.082020>, <1.755559, -0.731895, 1.643687>,
      <0.000000, -1.274865, 3.583482>, <0.854864, -1.274865, 3.583482>, <1.554298, -0.903901, 3.428182>, <1.554298, -0.266503, 2.553872>,
      <0.000000, -1.352231, 4.279691>, <0.854864, -1.352231, 4.279691>, <1.554298, -0.859393, 3.912157>, <1.554298, -0.236658, 3.809265>,
      <0.000000, -1.248649, 4.519408>, <0.854864, -1.248649, 4.506551>, <1.554298, -0.859330, 4.346165>, <1.554298, -0.282723, 4.337769>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.755559, -0.731895, 1.643687>, <1.956820, -0.761212, 1.205354>, <1.076251, 0.462323, 0.429498>, <0.000000, 0.462323, 0.429498>,
      <1.554298, -0.266503, 2.553872>, <1.554298, 0.370894, 1.679562>, <0.854864, 0.966875, 1.679562>, <0.000000, 0.966875, 1.679562>,
      <1.554298, -0.236658, 3.809265>, <1.554298, 0.386078, 3.706372>, <0.854864, 1.010037, 3.745184>, <0.000000, 1.010037, 3.745184>,
      <1.554298, -0.282723, 4.337769>, <1.554298, 0.293883, 4.303080>, <0.854864, 0.985238, 4.370012>, <0.000000, 0.985238, 4.383580>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.462323, 0.429498>, <-1.076251, 0.462323, 0.429498>, <-1.956820, -0.761212, 1.205354>, <-1.755559, -0.731895, 1.643687>,
      <0.000000, 0.966875, 1.679562>, <-0.854864, 0.966875, 1.679562>, <-1.554298, 0.370894, 1.679562>, <-1.554298, -0.266503, 2.553872>,
      <0.000000, 1.010037, 3.745184>, <-0.854864, 1.010037, 3.745184>, <-1.554298, 0.386078, 3.706372>, <-1.554298, -0.236658, 3.809265>,
      <0.000000, 0.985238, 4.383580>, <-0.854864, 0.985238, 4.370012>, <-1.554298, 0.293883, 4.303080>, <-1.554298, -0.282723, 4.337769>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.554298, -0.282723, 4.337769>, <-1.554298, -0.859330, 4.346165>, <-0.854864, -1.248649, 4.506551>, <0.000000, -1.248649, 4.519408>,
      <-1.554298, -0.328789, 4.839980>, <-1.554298, -0.859268, 4.780172>, <-0.854864, -1.145068, 4.733411>, <0.000000, -1.145068, 4.733411>,
      <-1.554298, -0.103394, 4.926102>, <-1.554298, -0.403574, 4.881624>, <-0.854864, -0.698916, 4.833302>, <0.000000, -0.698916, 4.833302>,
      <-1.497462, -0.160591, 4.974157>, <-1.497462, -0.563083, 4.868606>, <-0.823604, -0.977284, 4.806999>, <0.000000, -0.977284, 4.819985>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.248649, 4.519408>, <0.854864, -1.248649, 4.506551>, <1.554298, -0.859330, 4.346165>, <1.554298, -0.282723, 4.337769>,
      <0.000000, -1.145068, 4.733411>, <0.854864, -1.145068, 4.733411>, <1.554298, -0.859268, 4.780172>, <1.554298, -0.328789, 4.839980>,
      <0.000000, -0.698916, 4.833302>, <0.854864, -0.698916, 4.833302>, <1.554298, -0.403574, 4.881624>, <1.554298, -0.103394, 4.926102>,
      <0.000000, -0.977284, 4.819985>, <0.823604, -0.977284, 4.806999>, <1.497462, -0.563083, 4.868606>, <1.497462, -0.160591, 4.974157>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.554298, -0.282723, 4.337769>, <1.554298, 0.293883, 4.303080>, <0.854864, 0.985238, 4.370012>, <0.000000, 0.985238, 4.383580>,
      <1.554298, -0.328789, 4.839980>, <1.554298, 0.201689, 4.899789>, <0.854864, 0.960440, 4.994841>, <0.000000, 0.960440, 4.994841>,
      <1.554298, -0.103394, 4.926102>, <1.554298, 0.196787, 4.970579>, <0.854864, 0.971748, 5.117881>, <0.000000, 0.971748, 5.117881>,
      <1.497462, -0.160591, 4.974157>, <1.497462, 0.241902, 5.052573>, <0.784716, 0.950774, 5.189798>, <0.000000, 0.950774, 5.204091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.985238, 4.383580>, <-0.854864, 0.985238, 4.370012>, <-1.554298, 0.293883, 4.303080>, <-1.554298, -0.282723, 4.337769>,
      <0.000000, 0.960440, 4.994841>, <-0.854864, 0.960440, 4.994841>, <-1.554298, 0.201689, 4.899789>, <-1.554298, -0.328789, 4.839980>,
      <0.000000, 0.971748, 5.117881>, <-0.854864, 0.971748, 5.117881>, <-1.554298, 0.196787, 4.970579>, <-1.554298, -0.103394, 4.926102>,
      <0.000000, 0.950774, 5.204091>, <-0.784716, 0.950774, 5.189798>, <-1.497462, 0.241902, 5.052573>, <-1.497462, -0.160591, 4.974157>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.497462, -0.160591, 4.974157>, <-1.497462, -0.563083, 4.868606>, <-0.823604, -0.977284, 4.806999>, <0.000000, -0.977284, 4.819985>,
      <-1.440625, -0.217788, 4.995077>, <-1.440625, -0.722592, 4.855588>, <-0.792344, -1.255651, 4.780697>, <0.000000, -1.255651, 4.780697>,
      <-1.526834, -0.347302, 5.510192>, <-1.526834, -0.921086, 5.447490>, <-0.839759, -1.559256, 5.262427>, <0.000000, -1.559256, 5.262427>,
      <-1.562575, -0.455039, 6.328256>, <-1.562575, -1.008000, 6.218143>, <-0.859416, -1.618488, 6.043195>, <0.000000, -1.618488, 6.061731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.977284, 4.819985>, <0.823604, -0.977284, 4.806999>, <1.497462, -0.563083, 4.868606>, <1.497462, -0.160591, 4.974157>,
      <0.000000, -1.255651, 4.780697>, <0.792344, -1.255651, 4.780697>, <1.440625, -0.722592, 4.855588>, <1.440625, -0.217788, 4.995077>,
      <0.000000, -1.559256, 5.262427>, <0.839759, -1.559256, 5.262427>, <1.526834, -0.921086, 5.447490>, <1.526834, -0.347302, 5.510192>,
      <0.000000, -1.618488, 6.061731>, <0.859416, -1.618488, 6.043195>, <1.562575, -1.010389, 6.216998>, <1.562575, -0.455342, 6.327216>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.497462, -0.160591, 4.974157>, <1.497462, 0.241902, 5.052573>, <0.784716, 0.950774, 5.189798>, <0.000000, 0.950774, 5.204091>,
      <1.440625, -0.217788, 4.995077>, <1.440625, 0.287017, 5.134567>, <0.714568, 0.929801, 5.261715>, <0.000000, 0.929801, 5.261715>,
      <1.526834, -0.347302, 5.510192>, <1.526834, 0.226481, 5.572894>, <0.839759, 0.935543, 5.702919>, <0.000000, 0.935543, 5.702919>,
      <1.562575, -0.455342, 6.327216>, <1.562575, 0.099705, 6.398833>, <0.859416, 0.711705, 6.532089>, <0.000000, 0.711705, 6.552084>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.950774, 5.204091>, <-0.784716, 0.950774, 5.189798>, <-1.497462, 0.241902, 5.052573>, <-1.497462, -0.160591, 4.974157>,
      <0.000000, 0.929801, 5.261715>, <-0.714568, 0.929801, 5.261715>, <-1.440625, 0.287017, 5.134567>, <-1.440625, -0.217788, 4.995077>,
      <0.000000, 0.935543, 5.702919>, <-0.839759, 0.935543, 5.702919>, <-1.526834, 0.226481, 5.572894>, <-1.526834, -0.347302, 5.510192>,
      <0.000000, 0.711705, 6.552084>, <-0.859416, 0.711705, 6.532089>, <-1.562575, 0.097923, 6.399757>, <-1.562575, -0.455039, 6.328256>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.562575, -0.455039, 6.328256>, <-1.562575, -1.008000, 6.218143>, <-0.859416, -1.618488, 6.043195>, <0.000000, -1.618488, 6.061731>,
      <-1.598317, -0.562775, 7.107708>, <-1.598317, -1.094915, 6.988796>, <-0.879074, -1.677719, 6.823964>, <0.000000, -1.677719, 6.823964>,
      <-1.489182, -0.830413, 9.175299>, <-1.489182, -1.773687, 9.090040>, <-0.819050, -2.124779, 9.018885>, <0.000000, -2.124779, 9.018885>,
      <-0.231501, -0.289493, 9.137456>, <-0.231501, -0.287085, 9.138081>, <-0.145987, -0.285115, 9.138592>, <-0.041470, -0.285115, 9.138592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.618488, 6.061731>, <0.859416, -1.618488, 6.043195>, <1.562575, -1.010389, 6.216998>, <1.562575, -0.455342, 6.327216>,
      <0.000000, -1.677719, 6.823964>, <0.879074, -1.677719, 6.823964>, <1.598317, -1.099692, 6.986506>, <1.598317, -0.563381, 7.105639>,
      <0.000000, -2.124779, 9.018885>, <0.819050, -2.124779, 9.018885>, <1.489182, -1.773687, 9.090040>, <1.489182, -0.830413, 9.175299>,
      <-0.041470, -0.285115, 9.138592>, <0.063047, -0.285115, 9.138592>, <0.148561, -0.287085, 9.138081>, <0.148561, -0.289493, 9.137456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.562575, -0.455342, 6.327216>, <1.562575, 0.099705, 6.398833>, <0.859416, 0.711705, 6.532089>, <0.000000, 0.711705, 6.552084>,
      <1.598317, -0.563381, 7.105639>, <1.598317, -0.027071, 7.224771>, <0.879074, 0.487866, 7.361259>, <0.000000, 0.487866, 7.361259>,
      <1.489182, -0.830413, 9.175299>, <1.489182, 0.112861, 9.260559>, <0.819050, 0.176590, 8.967827>, <0.000000, 0.176590, 8.967827>,
      <0.148561, -0.289493, 9.137456>, <0.148561, -0.291901, 9.136831>, <0.063047, -0.293871, 9.136319>, <-0.041470, -0.293871, 9.136319>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.711705, 6.552084>, <-0.859416, 0.711705, 6.532089>, <-1.562575, 0.097923, 6.399757>, <-1.562575, -0.455039, 6.328256>,
      <0.000000, 0.487866, 7.361259>, <-0.879074, 0.487866, 7.361259>, <-1.598317, -0.030635, 7.226619>, <-1.598317, -0.562775, 7.107708>,
      <0.000000, 0.176590, 8.967827>, <-0.819050, 0.176590, 8.967827>, <-1.489182, 0.112861, 9.260559>, <-1.489182, -0.830413, 9.175299>,
      <-0.041470, -0.293871, 9.136319>, <-0.145987, -0.293871, 9.136319>, <-0.231501, -0.291901, 9.136831>, <-0.231501, -0.289493, 9.137456>
    }
  }
  texture {
    Tan
  }
  scale 0.057041
  rotate <-30.890394, 40.312, 96.695847>
  translate  <5.102671, 1.935067, 5.375881>
}
#declare Tumnagel = intersection {
  cylinder { // Nagelbas
    <0,0,1>, <0,0,0>, 1
    scale <0.056057, 0.066714, 0.145376>
    rotate <-38.591118, -22.193951, 8.533239>
    translate  <4.890576, 2.12894, 5.630774>
  }
  cylinder { // NagelCut
    <0,0,1>, <0,0,0>, 1
    scale <0.08927, 0.083434, 0.121005>
    rotate -88.818512*y
    translate  <4.822354, 2.165923, 5.672104>
  }
  texture {
    NagelTex
  }
  translate  <0.0, -0.014002, -0.010771>
}
#declare Handen = union {
  object { Hand }
  object { Pekfinger }
  object { Langfinger }
  object { Ringfinger }
  object { Lillfinger }
  object { Tumme }
  object { Tumnagel }
  cylinder { // Arm
    <0,0,1>, <0,0,0>, 1
    texture {
      Tan
    }
    scale <0.10114, 0.169689, 0.690029>
    rotate <-0.908969, -39.903587, 7.00766>
    translate  <5.740454, 2.155437, 4.791585>
  }
  rotate <0.002453, -26.750834, -10.533682>
  translate  <2.581873, 0.0, -0.968202>
}
#declare Sleeve = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.990535, 0.114506, -0.480261>, <-0.990535, -0.550000, -0.346671>, <-0.540535, -1.000000, -0.346671>, <-0.042494, -1.000000, -0.333507>,
      <-0.981696, 0.114506, 0.075052>, <-0.939975, -0.550000, 0.008244>, <-0.489975, -1.000000, 0.008244>, <-0.017214, -1.000000, 0.093950>,
      <-0.825492, 0.000000, 1.000000>, <-0.825492, -0.491072, 1.000000>, <-0.454021, -0.892858, 1.000000>, <0.000000, -0.892858, 1.000000>,
      <-0.825492, 0.000000, 1.500000>, <-0.825492, -0.491072, 1.500000>, <-0.454021, -0.892858, 1.500000>, <-0.066922, -0.896723, 1.483872>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.042494, -1.000000, -0.333507>, <0.455548, -1.000000, -0.320344>, <1.141677, -0.550000, -0.178667>, <1.141677, 0.114506, -0.312257>,
      <-0.017214, -1.000000, 0.093950>, <0.455548, -1.000000, 0.179656>, <1.141677, -0.550000, 0.321333>, <1.141677, 0.114506, 0.187743>,
      <0.000000, -0.892858, 1.000000>, <0.454021, -0.892858, 1.000000>, <0.825492, -0.491072, 1.000000>, <0.825492, 0.000000, 1.000000>,
      <-0.066922, -0.896723, 1.483872>, <0.320176, -0.900588, 1.467744>, <0.801486, -0.491072, 2.320975>, <0.801486, 0.000000, 2.320975>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.141677, 0.114506, -0.312257>, <1.141677, 0.779011, -0.445847>, <0.455548, 1.229011, -0.587524>, <-0.042494, 1.229011, -0.600687>,
      <1.141677, 0.114506, 0.187743>, <1.141677, 0.779011, 0.054153>, <0.455548, 1.229011, -0.087524>, <-0.058934, 1.229011, 0.027168>,
      <0.825492, 0.000000, 1.000000>, <0.825492, 0.491072, 1.000000>, <0.454021, 0.892858, 1.000000>, <0.000000, 0.892858, 1.000000>,
      <0.801486, 0.000000, 2.320975>, <0.801486, 0.491072, 2.320975>, <0.320176, 0.885338, 1.724309>, <-0.066922, 0.889098, 1.612154>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.042494, 1.229011, -0.600687>, <-0.540535, 1.229011, -0.613851>, <-0.990535, 0.779011, -0.613851>, <-0.990535, 0.114506, -0.480261>,
      <-0.058934, 1.229011, 0.027168>, <-0.573417, 1.229011, 0.141860>, <-1.023417, 0.779011, 0.141860>, <-0.981696, 0.114506, 0.075052>,
      <0.000000, 0.892858, 1.000000>, <-0.454021, 0.892858, 1.000000>, <-0.825492, 0.491072, 1.000000>, <-0.825492, 0.000000, 1.000000>,
      <-0.066922, 0.889098, 1.612154>, <-0.454021, 0.892858, 1.500000>, <-0.825492, 0.491072, 1.500000>, <-0.825492, 0.000000, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.825492, 0.000000, 1.500000>, <-0.825492, -0.491072, 1.500000>, <-0.454021, -0.892858, 1.500000>, <-0.066922, -0.896723, 1.483872>,
      <-0.825492, 0.000000, 2.000000>, <-0.825492, -0.491072, 2.000000>, <-0.454021, -0.892858, 2.000000>, <-0.133845, -0.900588, 1.967744>,
      <-0.790827, -0.208604, 2.835454>, <-0.790827, -0.491072, 2.957835>, <-0.319951, -0.892858, 3.007538>, <-0.058656, -0.892858, 2.763920>,
      <-0.808160, -0.066664, 3.171240>, <-0.808160, -0.415795, 3.235943>, <-0.285922, -0.847635, 3.252813>, <0.021204, -0.832608, 3.134995>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.066922, -0.896723, 1.483872>, <0.320176, -0.900588, 1.467744>, <0.801486, -0.491072, 2.320975>, <0.801486, 0.000000, 2.320975>,
      <-0.133845, -0.900588, 1.967744>, <0.186332, -0.908318, 1.935488>, <0.777480, -0.491072, 3.641950>, <0.777480, 0.000000, 3.641950>,
      <-0.058656, -0.892858, 2.763920>, <0.202640, -0.892858, 2.520302>, <0.574111, -0.491072, 2.520302>, <0.574111, 0.000000, 2.520302>,
      <0.021204, -0.832608, 3.134995>, <0.328330, -0.817582, 3.017177>, <0.699802, -0.415795, 3.017177>, <0.699802, 0.037638, 3.013664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.801486, 0.000000, 2.320975>, <0.801486, 0.491072, 2.320975>, <0.320176, 0.885338, 1.724309>, <-0.066922, 0.889098, 1.612154>,
      <0.777480, 0.000000, 3.641950>, <0.777480, 0.491072, 3.641950>, <0.186332, 0.877817, 2.448617>, <-0.133845, 0.885338, 2.224309>,
      <0.574111, 0.000000, 2.520302>, <0.574111, 0.491072, 2.520302>, <0.202640, 0.892858, 2.520302>, <-0.058656, 0.684254, 2.641539>,
      <0.699802, 0.037638, 3.013664>, <0.699802, 0.491072, 3.010151>, <0.328330, 0.892858, 3.010151>, <0.021204, 0.725121, 3.038174>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.066922, 0.889098, 1.612154>, <-0.454021, 0.892858, 1.500000>, <-0.825492, 0.491072, 1.500000>, <-0.825492, 0.000000, 1.500000>,
      <-0.133845, 0.885338, 2.224309>, <-0.454021, 0.892858, 2.000000>, <-0.825492, 0.491072, 2.000000>, <-0.825492, 0.000000, 2.000000>,
      <-0.058656, 0.684254, 2.641539>, <-0.319951, 0.475650, 2.762776>, <-0.790827, 0.073864, 2.713074>, <-0.790827, -0.208604, 2.835454>,
      <0.021204, 0.725121, 3.038174>, <-0.285922, 0.557385, 3.066197>, <-0.808160, 0.282468, 3.106537>, <-0.808160, -0.066664, 3.171240>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.808160, -0.066664, 3.171240>, <-0.808160, -0.415795, 3.235943>, <-0.285922, -0.847635, 3.252813>, <0.021204, -0.832608, 3.134995>,
      <-0.825492, 0.075276, 3.507026>, <-0.825492, -0.340519, 3.514052>, <-0.251893, -0.802412, 3.498089>, <0.101064, -0.772358, 3.506070>,
      <-0.657684, 0.000000, 4.351125>, <-0.657684, -0.491072, 4.351125>, <-0.673376, -0.714632, 4.362663>, <-0.109677, -0.722195, 4.251589>,
      <-0.604182, 0.000000, 4.760593>, <-0.630243, -0.395397, 4.760593>, <-0.502459, -0.574419, 4.757705>, <-0.054839, -0.578201, 4.702168>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.021204, -0.832608, 3.134995>, <0.328330, -0.817582, 3.017177>, <0.699802, -0.415795, 3.017177>, <0.699802, 0.037638, 3.013664>,
      <0.101064, -0.772358, 3.506070>, <0.454021, -0.742305, 3.514052>, <0.825492, -0.340519, 3.514052>, <0.825492, 0.075276, 3.507026>,
      <-0.109677, -0.722195, 4.251589>, <0.454021, -0.729759, 4.140516>, <0.825492, -0.327973, 4.140516>, <0.825492, -0.006273, 4.245903>,
      <-0.054839, -0.578201, 4.702168>, <0.392781, -0.581982, 4.646631>, <0.714148, -0.313848, 4.655289>, <0.688086, -0.003137, 4.707982>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.699802, 0.037638, 3.013664>, <0.699802, 0.491072, 3.010151>, <0.328330, 0.892858, 3.010151>, <0.021204, 0.725121, 3.038174>,
      <0.825492, 0.075276, 3.507026>, <0.825492, 0.491072, 3.500000>, <0.454021, 0.892858, 3.500000>, <0.101064, 0.765989, 3.434809>,
      <0.825492, -0.006273, 4.245903>, <0.825492, 0.315427, 4.351290>, <0.454021, 0.717213, 4.351290>, <0.083904, 0.805035, 4.351208>,
      <0.688086, -0.003137, 4.707982>, <0.714148, 0.307575, 4.760676>, <0.392781, 0.575709, 4.752018>, <0.041952, 0.619621, 4.751977>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.021204, 0.725121, 3.038174>, <-0.285922, 0.557385, 3.066197>, <-0.808160, 0.282468, 3.106537>, <-0.808160, -0.066664, 3.171240>,
      <0.101064, 0.765989, 3.434809>, <-0.251893, 0.639119, 3.369618>, <-0.825492, 0.491072, 3.500000>, <-0.825492, 0.075276, 3.507026>,
      <0.083904, 0.805035, 4.351208>, <-0.286212, 0.892858, 4.351125>, <-0.657684, 0.491072, 4.351125>, <-0.657684, 0.000000, 4.351125>,
      <0.041952, 0.619621, 4.751977>, <-0.308877, 0.663532, 4.751936>, <-0.630243, 0.395397, 4.760593>, <-0.604182, 0.000000, 4.760593>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.604182, 0.000000, 4.760593>, <-0.630243, -0.395397, 4.760593>, <-0.502459, -0.574419, 4.757705>, <-0.054839, -0.578201, 4.702168>,
      <-0.602803, 0.000000, 5.170061>, <-0.602803, -0.299722, 5.170061>, <-0.331542, -0.434206, 5.152746>, <0.000000, -0.434206, 5.152746>,
      <-0.456669, 0.000000, 5.168517>, <-0.456669, -0.184629, 5.168517>, <-0.251168, -0.335689, 5.168517>, <0.000000, -0.335689, 5.168517>,
      <-0.133423, 0.000000, 5.258776>, <-0.133423, -0.092720, 5.258776>, <-0.073383, -0.168582, 5.258776>, <0.000000, -0.168582, 5.258776>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.054839, -0.578201, 4.702168>, <0.392781, -0.581982, 4.646631>, <0.714148, -0.313848, 4.655289>, <0.688086, -0.003137, 4.707982>,
      <0.000000, -0.434206, 5.152746>, <0.331542, -0.434206, 5.152746>, <0.602803, -0.299722, 5.170061>, <0.602803, 0.000000, 5.170061>,
      <0.000000, -0.335689, 5.168517>, <0.251168, -0.335689, 5.168517>, <0.456669, -0.184629, 5.168517>, <0.456669, 0.000000, 5.168517>,
      <0.000000, -0.168582, 5.258776>, <0.073383, -0.168582, 5.258776>, <0.133423, -0.092720, 5.258776>, <0.133423, 0.000000, 5.258776>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.688086, -0.003137, 4.707982>, <0.714148, 0.307575, 4.760676>, <0.392781, 0.575709, 4.752018>, <0.041952, 0.619621, 4.751977>,
      <0.602803, 0.000000, 5.170061>, <0.602803, 0.299722, 5.170061>, <0.331542, 0.434206, 5.152746>, <0.000000, 0.434206, 5.152746>,
      <0.456669, 0.000000, 5.168517>, <0.456669, 0.184629, 5.168517>, <0.251168, 0.335689, 5.168517>, <0.000000, 0.335689, 5.168517>,
      <0.133423, 0.000000, 5.258776>, <0.133423, 0.092720, 5.258776>, <0.073383, 0.168582, 5.258776>, <0.000000, 0.168582, 5.258776>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.041952, 0.619621, 4.751977>, <-0.308877, 0.663532, 4.751936>, <-0.630243, 0.395397, 4.760593>, <-0.604182, 0.000000, 4.760593>,
      <0.000000, 0.434206, 5.152746>, <-0.331542, 0.434206, 5.152746>, <-0.602803, 0.299722, 5.170061>, <-0.602803, 0.000000, 5.170061>,
      <0.000000, 0.335689, 5.168517>, <-0.251168, 0.335689, 5.168517>, <-0.456669, 0.184629, 5.168517>, <-0.456669, 0.000000, 5.168517>,
      <0.000000, 0.168582, 5.258776>, <-0.073383, 0.168582, 5.258776>, <-0.133423, 0.092720, 5.258776>, <-0.133423, 0.000000, 5.258776>
    }
  }
  texture {
    LegTex
  }
  scale 0.3
  rotate <-72.163506, 0.917181, 84.641129>
  translate  <7.036417, 1.468379, 5.576794>
}
#declare Sleeve2 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.039624, 0.140708, 0.007775>, <-1.039624, -0.675859, 0.154012>, <-0.589624, -1.228834, 0.154012>, <-0.091582, -1.228834, 0.168422>,
      <-1.039624, 0.140708, 0.555111>, <-1.039624, -0.675859, 0.701349>, <-0.589624, -1.863939, 0.373553>, <-0.091582, -1.863939, 0.387962>,
      <-1.000000, 0.127917, 1.094673>, <-1.000000, -0.675859, 1.094673>, <-0.550000, -1.228834, 1.094673>, <0.000000, -1.228834, 1.094673>,
      <-1.000000, 0.127917, 1.642010>, <-1.000000, -0.675859, 1.642010>, <-0.550000, -1.228834, 1.642010>, <-0.081070, -1.202432, 1.621240>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.091582, -1.228834, 0.168422>, <0.406460, -1.228834, 0.182831>, <1.092589, -0.675859, 0.337921>, <1.092589, 0.140708, 0.191684>,
      <-0.091582, -1.863939, 0.387962>, <0.406460, -1.863939, 0.402371>, <1.092589, -0.675859, 0.885258>, <1.092589, 0.140708, 0.739020>,
      <0.000000, -1.228834, 1.094673>, <0.550000, -1.228834, 1.094673>, <1.000000, -0.675859, 1.094673>, <1.000000, 0.127917, 1.094673>,
      <-0.081070, -1.202432, 1.621240>, <0.387861, -1.176031, 1.600470>, <1.000000, -0.675859, 1.642010>, <1.000000, 0.127917, 1.642010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.092589, 0.140708, 0.191684>, <1.092589, 0.957275, 0.045447>, <0.406460, 1.633174, -0.027695>, <-0.091582, 1.633174, -0.042104>,
      <1.092589, 0.140708, 0.739020>, <1.092589, 0.957275, 0.592783>, <0.406460, 1.530738, 0.376231>, <-0.091582, 1.530738, 0.361822>,
      <1.000000, 0.127917, 1.094673>, <1.000000, 0.931692, 1.094673>, <0.550000, 1.484667, 1.094673>, <0.000000, 1.484667, 1.094673>,
      <1.000000, 0.127917, 1.642010>, <1.000000, 0.931692, 1.642010>, <0.387861, 1.321280, 1.586451>, <-0.081070, 1.402973, 1.614230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.091582, 1.633174, -0.042104>, <-0.589624, 1.633174, -0.056513>, <-1.039624, 0.957275, -0.138462>, <-1.039624, 0.140708, 0.007775>,
      <-0.091582, 1.530738, 0.361822>, <-0.589624, 1.530738, 0.347412>, <-1.039624, 0.957275, 0.408874>, <-1.039624, 0.140708, 0.555111>,
      <0.000000, 1.484667, 1.094673>, <-0.550000, 1.484667, 1.094673>, <-1.000000, 0.931692, 1.094673>, <-1.000000, 0.127917, 1.094673>,
      <-0.081070, 1.402973, 1.614230>, <-0.550000, 1.484667, 1.642010>, <-1.000000, 0.931692, 1.642010>, <-1.000000, 0.127917, 1.642010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, 0.127917, 1.642010>, <-1.000000, -0.675859, 1.642010>, <-0.550000, -1.228834, 1.642010>, <-0.081070, -1.202432, 1.621240>,
      <-1.000000, 0.127917, 2.189346>, <-1.000000, -0.675859, 2.189346>, <-0.550000, -1.228834, 2.189346>, <-0.162139, -1.176031, 2.147807>,
      <-0.972065, 0.103925, 3.005897>, <-0.972065, -0.550000, 2.997932>, <-0.387588, -1.100266, 3.134541>, <0.049013, -1.010809, 2.996435>,
      <-0.986032, 0.146165, 3.256461>, <-0.986032, -0.465690, 3.255992>, <-0.346366, -1.107917, 3.259105>, <0.085721, -0.992142, 3.222648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.081070, -1.202432, 1.621240>, <0.387861, -1.176031, 1.600470>, <1.000000, -0.675859, 1.642010>, <1.000000, 0.127917, 1.642010>,
      <-0.162139, -1.176031, 2.147807>, <0.225722, -1.123229, 2.106268>, <1.000000, -0.675859, 2.189346>, <1.000000, 0.127917, 2.189346>,
      <0.049013, -1.010809, 2.996435>, <0.485615, -0.921352, 2.858330>, <0.935615, -0.675859, 2.778117>, <0.935615, 0.127917, 2.778117>,
      <0.085721, -0.992142, 3.222648>, <0.517807, -0.876367, 3.186191>, <0.967807, -0.528620, 3.146084>, <0.967807, 0.158161, 3.142571>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, 0.127917, 1.642010>, <1.000000, 0.931692, 1.642010>, <0.387861, 1.321280, 1.586451>, <-0.081070, 1.402973, 1.614230>,
      <1.000000, 0.127917, 2.189346>, <1.000000, 0.931692, 2.189346>, <0.225722, 1.157892, 2.078229>, <-0.162139, 1.321280, 2.133787>,
      <0.935615, 0.127917, 2.778117>, <0.935615, 0.931692, 2.778117>, <0.485615, 1.230661, 2.831592>, <0.049013, 1.350129, 2.911040>,
      <0.967807, 0.158161, 3.142571>, <0.967807, 0.844942, 3.139059>, <0.517807, 1.219427, 3.165796>, <0.085721, 1.321748, 3.239768>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.081070, 1.402973, 1.614230>, <-0.550000, 1.484667, 1.642010>, <-1.000000, 0.931692, 1.642010>, <-1.000000, 0.127917, 1.642010>,
      <-0.162139, 1.321280, 2.133787>, <-0.550000, 1.484667, 2.189346>, <-1.000000, 0.931692, 2.189346>, <-1.000000, 0.127917, 2.189346>,
      <0.049013, 1.350129, 2.911040>, <-0.387588, 1.469597, 2.990488>, <-0.972065, 0.757850, 3.013861>, <-0.972065, 0.103925, 3.005897>,
      <0.085721, 1.321748, 3.239768>, <-0.346366, 1.424070, 3.313740>, <-0.986032, 0.758021, 3.256930>, <-0.986032, 0.146165, 3.256461>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.986032, 0.146165, 3.256461>, <-0.986032, -0.465690, 3.255992>, <-0.346366, -1.107917, 3.259105>, <0.085721, -0.992142, 3.222648>,
      <-1.000000, 0.188406, 3.507026>, <-1.000000, -0.381381, 3.514052>, <-0.305143, -1.115568, 3.383670>, <0.122428, -0.973475, 3.448861>,
      <-0.940799, 0.104096, 4.370336>, <-0.940799, -0.550000, 4.370336>, <-0.346717, -0.713833, 4.189996>, <0.101642, -0.799349, 4.190077>,
      <-0.970400, 0.104096, 4.779004>, <-0.970400, -0.550000, 4.779004>, <-0.448358, -0.856917, 4.688833>, <0.050821, -0.899674, 4.688874>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.085721, -0.992142, 3.222648>, <0.517807, -0.876367, 3.186191>, <0.967807, -0.528620, 3.146084>, <0.967807, 0.158161, 3.142571>,
      <0.122428, -0.973475, 3.448861>, <0.550000, -0.831381, 3.514052>, <1.000000, -0.381381, 3.514052>, <1.000000, 0.188406, 3.507026>,
      <0.101642, -0.799349, 4.190077>, <0.550000, -0.884864, 4.190159>, <1.000000, -0.367329, 4.140516>, <1.000000, 0.097070, 4.245903>,
      <0.050821, -0.899674, 4.688874>, <0.550000, -0.942432, 4.688915>, <1.000000, -0.458665, 4.664094>, <1.000000, 0.100583, 4.716787>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.967807, 0.158161, 3.142571>, <0.967807, 0.844942, 3.139059>, <0.517807, 1.219427, 3.165796>, <0.085721, 1.321748, 3.239768>,
      <1.000000, 0.188406, 3.507026>, <1.000000, 0.758192, 3.500000>, <0.550000, 1.208192, 3.500000>, <0.122428, 1.293367, 3.568497>,
      <1.000000, 0.097070, 4.245903>, <1.000000, 0.561470, 4.351290>, <0.550000, 1.011470, 4.351290>, <0.101642, 1.109831, 4.351208>,
      <1.000000, 0.100583, 4.716787>, <1.000000, 0.659831, 4.769480>, <0.550000, 1.109831, 4.769480>, <0.050821, 1.159012, 4.769439>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.085721, 1.321748, 3.239768>, <-0.346366, 1.424070, 3.313740>, <-0.986032, 0.758021, 3.256930>, <-0.986032, 0.146165, 3.256461>,
      <0.122428, 1.293367, 3.568497>, <-0.305143, 1.378542, 3.636993>, <-1.000000, 0.758192, 3.500000>, <-1.000000, 0.188406, 3.507026>,
      <0.101642, 1.109831, 4.351208>, <-0.346717, 1.208192, 4.351125>, <-0.940799, 0.758192, 4.370336>, <-0.940799, 0.104096, 4.370336>,
      <0.050821, 1.159012, 4.769439>, <-0.448358, 1.208192, 4.769398>, <-0.970400, 0.758192, 4.779004>, <-0.970400, 0.104096, 4.779004>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.970400, 0.104096, 4.779004>, <-0.970400, -0.550000, 4.779004>, <-0.448358, -0.856917, 4.688833>, <0.050821, -0.899674, 4.688874>,
      <-1.000000, 0.104096, 5.187671>, <-1.000000, -0.550000, 5.187671>, <-0.550000, -1.000000, 5.187671>, <0.000000, -1.000000, 5.187671>,
      <-0.824197, 0.046675, 5.697148>, <-0.824197, -0.574484, 5.697148>, <-0.619528, -1.082705, 5.416516>, <0.043174, -1.082705, 5.848257>,
      <-0.824197, 0.046675, 6.189558>, <-0.824197, -0.574484, 6.189558>, <-0.785833, -1.082705, 6.483435>, <-0.123131, -1.012006, 6.884954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.050821, -0.899674, 4.688874>, <0.550000, -0.942432, 4.688915>, <1.000000, -0.458665, 4.664094>, <1.000000, 0.100583, 4.716787>,
      <0.000000, -1.000000, 5.187671>, <0.550000, -1.000000, 5.187671>, <1.000000, -0.550000, 5.187671>, <1.000000, 0.104096, 5.187671>,
      <0.043174, -1.082705, 5.848257>, <0.705877, -1.082705, 6.279998>, <1.730852, -0.574484, 7.165066>, <1.730852, 0.046675, 7.165066>,
      <-0.123131, -1.012006, 6.884954>, <0.539572, -0.941308, 7.286473>, <0.716262, -0.499458, 7.358974>, <0.716262, 0.040580, 7.358974>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, 0.100583, 4.716787>, <1.000000, 0.659831, 4.769480>, <0.550000, 1.109831, 4.769480>, <0.050821, 1.159012, 4.769439>,
      <1.000000, 0.104096, 5.187671>, <1.000000, 0.758192, 5.187671>, <0.550000, 1.208192, 5.187671>, <0.000000, 1.208192, 5.187671>,
      <1.730852, 0.046675, 7.165066>, <1.730852, 0.667834, 7.165066>, <0.705877, 1.176055, 6.279998>, <0.043174, 1.176055, 5.848257>,
      <0.716262, 0.040580, 7.358974>, <0.716262, 0.580618, 7.358974>, <0.539572, 1.022467, 7.286473>, <-0.123131, 1.099261, 6.884954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.050821, 1.159012, 4.769439>, <-0.448358, 1.208192, 4.769398>, <-0.970400, 0.758192, 4.779004>, <-0.970400, 0.104096, 4.779004>,
      <0.000000, 1.208192, 5.187671>, <-0.550000, 1.208192, 5.187671>, <-1.000000, 0.758192, 5.187671>, <-1.000000, 0.104096, 5.187671>,
      <0.043174, 1.176055, 5.848257>, <-0.619528, 1.176055, 5.416516>, <-0.824197, 0.667834, 5.697148>, <-0.824197, 0.046675, 5.697148>,
      <-0.123131, 1.099261, 6.884954>, <-0.785833, 1.176055, 6.483435>, <-0.824197, 0.667834, 6.189558>, <-0.824197, 0.046675, 6.189558>
    }
  }
  texture {
    LegTex
  }
  scale 0.3
  rotate <-65.01664, 10.388494, 60.577682>
  translate  <8.646911, 0.42713, 4.695654>
}
union { // Armen
  object { Handen }
  cylinder { // Muff
    <0,0,1>, <0,0,0>, 1
    texture {
      LegTex
    }
    scale <0.138939, 0.205234, 0.359366>
    rotate <-16.207598, -68.086014, 12.594233>
    translate  <5.760425, 1.597897, 5.966849>
  }
  object { Sleeve }
  object { Sleeve2 }
  translate  <-1.323698, 0.28365, 0.0>
}


#declare Hakrpylddd = intersection {
  sphere { // Hakpryl
    <0,0,0>,1
    scale <0.33478, 0.537583, 0.404668>
    rotate 34.86763*y
    translate  <6.245754, 0.0, 5.406808>
  }
  box { // HakprylCut
    <-1, -1, -1>, <1, 1, 1>
    scale <0.694165, 1.0, 0.101368>
    translate  <6.274511, 0.0, 5.296512>
  }
}
#declare Hakprylen = difference {
  object { Hakrpylddd }
  box { // HakprylCut1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.112361, 0.368776, 0.013163>
    translate  <5.84087, 0.0, 5.349484>
  }
  box { // HakprylCut2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.112361, 0.368776, 0.013163>
    translate  <5.846561, 0.0, 5.292468>
  }
  texture {
    SulaTex
  }
}
#declare Visir2ddd = intersection {
  cylinder { // Visir2
    <0,0,1>, <0,0,0>, 1
    scale <0.147919, 0.164879, 2.284976>
    rotate -90.0*x
    translate  <6.707129, -1.134667, 5.945075>
  }
  cone { // Visir1
    <0,0,0>, 1.0, <0,0,1>, 1.0
    scale <0.828825, 0.841511, 1.016538>
    rotate 10.90006*y
    translate  <6.770905, -0.005473, 5.244659>
  }
  texture {
    VisirTex
  }
}
#declare Visiret = intersection {
  cone { // Visir
    <0,0,0>, 1.0, <0,0,1>, 1.0
    scale <0.82495, 0.841511, 1.016538>
    rotate 10.90006*y
    translate  <6.756317, -0.006835, 5.250733>
  }
  box { // VisirCut1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.766567, 1.0, 0.349518>
    translate  <6.07799, 0.0, 5.767488>
  }
}
#declare VisireT = intersection {
  object { Visiret }
  superellipsoid { // VisirCut
    <0.7, 0.01>
    scale <1.170176, 1.012606, 1.0>
    rotate <-90.0, 0.0, 0.0>
    translate  <5.71725, -0.002794, 6.405884>
  }
  texture {
    VisirTex
  }
  translate  <0.012371, 0.0, -0.007692>
}
#declare HelmTopp = intersection {
  sphere { // HelmTop
    <0,0,0>,1
    scale <0.85, 0.85, 0.968084>
    rotate 34.86763*y
    translate  <6.806688, 0.0, 5.643324>
  }
  box { // HelmCut
    <-1, -1, -1>, <1, 1, 1>
    translate  <6.769663, 0.0, 6.074655>
  }
  translate  <1.033978, -0.640784, 0.064328>
}
#declare cUTT = intersection {
  box { // HelmTopVCut
    <-1, -1, -1>, <1, 1, 1>
    scale <0.766567, 1.0, 0.349518>
    translate  <7.125744, -0.670537, 5.819074>
  }
  superellipsoid { // VisirCut2
    <0.7, 0.01>
    scale <1.170176, 1.012606, 1.0>
    rotate <-90.0, 0.0, 0.0>
    translate  <6.763313, -0.654512, 6.460326>
  }
}
#declare HelmTop2 = difference {
  object { HelmTopp }
  object { cUTT }
  texture {
    PlastTex
  }
  translate  <-1.033978, 0.640784, -0.064328>
}
union { // Helmet
  object { Hakprylen }
  sphere { // HelmSkruv
    <0,0,0>,1
    texture {
      Chrome_Textur1
    }
    scale 0.055
    translate  <6.707204, -0.801151, 5.952997>
  }
  object { Visir2ddd }
  object { VisireT }
  object { HelmTop2 }
  sphere { // HelmSkruv1
    <0,0,0>,1
    texture {
      Chrome_Textur1
    }
    scale <0.02715, 0.027722, 0.025121>
    translate  <6.658874, -0.801151, 5.822878>
  }
  sphere { // HelmSkruv2
    <0,0,0>,1
    texture {
      Chrome_Textur1
    }
    scale <0.030244, 0.034799, 0.029299>
    translate  <6.748614, -0.801151, 6.054963>
  }
  scale <1.0, 0.9, 1.0>
  rotate <-3.330632, -23.020288, 30.958078>
  translate  <4.075432, -2.922243, -2.232643>
}


cylinder { // Antennbas
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Textur1
  }
  scale <0.12, 0.12, 0.243862>
  rotate -43.630539*y
  translate  <-5.398057, 2.534462, -0.092759>
}


torus { // SpikeHolder1
  1.5, 0.4  rotate -x*90
  texture {
    Chrome_Textur1
  }
  scale <0.08, 0.08, 0.15>
  rotate <2.479141, -46.650455, 0.854088>
  translate  <-6.116299, -2.227788, -0.500637>
}


torus { // SpikeHolder
  1.5, 0.4  rotate -x*90
  texture {
    Chrome_Textur1
  }
  scale <0.08, 0.08, 0.15>
  rotate <2.643925, -58.394089, 0.552684>
  translate  <-6.824578, -2.209344, -1.419518>
}


cylinder { // Cylndr12
  <0,0,1>, <0,0,0>, 1
  texture {
    SulaTex
  }
  scale <0.02, 0.02, 1.5>
  rotate -90.0*x
  translate  <2.576651, -4.979393, -2.958522>
}


cylinder { // Cylndr11
  <0,0,1>, <0,0,0>, 1
  texture {
    SulaTex
  }
  scale <0.02, 0.02, 1.5>
  rotate -90.0*x
  translate  <2.55171, -4.979393, -3.04744>
}


cylinder { // Cylndr10
  <0,0,1>, <0,0,0>, 1
  texture {
    SulaTex
  }
  scale <0.02, 0.02, 1.5>
  rotate -90.0*x
  translate  <2.574751, -4.979393, -3.131884>
}


cylinder { // Cylndr9
  <0,0,1>, <0,0,0>, 1
  texture {
    SulaTex
  }
  scale <0.02, 0.02, 1.5>
  rotate -90.0*x
  translate  <2.634254, -4.979393, -3.198098>
}


cylinder { // Cylndr8
  <0,0,1>, <0,0,0>, 1
  texture {
    SulaTex
  }
  scale <0.02, 0.02, 1.5>
  rotate -90.0*x
  translate  <2.72524, -4.979393, -3.222702>
}


cylinder { // Cylndr7
  <0,0,1>, <0,0,0>, 1
  texture {
    SulaTex
  }
  scale <0.02, 0.02, 1.5>
  rotate -90.0*x
  translate  <2.80538, -4.979393, -3.197761>
}


cylinder { // Cylndr6
  <0,0,1>, <0,0,0>, 1
  texture {
    SulaTex
  }
  scale <0.02, 0.02, 1.5>
  rotate -90.0*x
  translate  <2.869525, -4.979393, -3.131884>
}


cylinder { // Cylndr5
  <0,0,1>, <0,0,0>, 1
  texture {
    SulaTex
  }
  scale <0.02, 0.02, 1.5>
  rotate -90.0*x
  translate  <2.894466, -4.979393, -3.045203>
}


cylinder { // Cylndr4
  <0,0,1>, <0,0,0>, 1
  texture {
    SulaTex
  }
  scale <0.02, 0.02, 1.5>
  rotate -90.0*x
  translate  <2.871593, -4.979393, -2.960422>
}


cylinder { // Cylndr3
  <0,0,1>, <0,0,0>, 1
  texture {
    SulaTex
  }
  scale <0.02, 0.02, 1.5>
  rotate -90.0*x
  translate  <2.809685, -4.979393, -2.894545>
}


cylinder { // Cylndr2
  <0,0,1>, <0,0,0>, 1
  texture {
    SulaTex
  }
  scale <0.02, 0.02, 1.5>
  rotate -90.0*x
  translate  <2.640628, -4.979393, -2.898682>
}


cylinder { // Cylndr001
  <0,0,1>, <0,0,0>, 1
  texture {
    SulaTex
  }
  scale <0.02, 0.02, 1.5>
  rotate -90.0*x
  translate  <2.72524, -4.979393, -2.873741>
}


cone { // BaltesPigg
  <0,0,0>, 0.5, <0,0,1>, 1.0
  texture {
    Copper_Textur1
  }
  scale <0.020266, 0.023054, 0.136707>
  rotate <143.758118, 83.518906, 132.691132>
  translate  <3.483028, -3.96765, -1.621355>
}


#declare Balte2ddd = difference {
  cylinder { // Balte2bas
    <0,0,1>, <0,0,0>, 1
    scale <0.438567, 0.353501, 0.19>
    rotate <2.163553, 14.379745, 68.727234>
    translate  <3.210914, -4.199021, -1.607803>
  }
  cylinder { // Balte2bas1
    <0,0,1>, <0,0,0>, 1
    scale <0.412349, 0.324921, 0.25>
    rotate <2.163553, 14.379745, 68.727234>
    translate  <3.213347, -4.206604, -1.638925>
  }
  cylinder { // Hole1
    <0,0,1>, <0,0,0>, 1
    scale <0.02, 0.02, 0.2>
    rotate <85.486946, 11.467979, 94.074509>
    translate  <3.480061, -4.086827, -1.595824>
  }
  cylinder { // Hole2
    <0,0,1>, <0,0,0>, 1
    scale <0.02, 0.02, 0.2>
    rotate <85.767715, 10.070533, 73.540825>
    translate  <3.457463, -4.220617, -1.520393>
  }
  translate  <0.019278, 0.01377, 0.0>
}
intersection { // Balte2
  object { Balte2ddd }
  box { // Balte2cut
    <-1, -1, -1>, <1, 1, 1>
    rotate <-180.0, 35.169891, -110.772301>
    translate  <4.753192, -3.398857, -1.722914>
  }
  texture {
    BootTex
  }
  translate  <0.0, -0.001675, -0.006702>
}


intersection { // Balte1
  cylinder { // Balte1bas
    <0,0,1>, <0,0,0>, 1
    texture {
      BootTex
    }
    scale <0.440969, 0.456783, 0.193935>
    rotate <-11.670157, 15.157732, -9.575735>
    translate  <3.790946, -3.650636, -1.846925>
  }
  box { // Balte1cut
    <-1, -1, -1>, <1, 1, 1>
    scale 0.618297
    rotate 43.159389*z
    translate  <3.433948, -3.22797, -1.624195>
  }
  texture {
    BootTex
  }
}


difference { // Spannet
  superellipsoid { // SpanneBas
    <0.4, 0.1>
    texture {
      Copper_Textur1
    }
    scale <0.147921, 0.050029, 0.119722>
    rotate <-19.48134, 5.734753, -30.967539>
    translate  <3.641252, -3.974932, -1.646739>
  }
  box { // SpanneCut
    <-1, -1, -1>, <1, 1, 1>
    scale <0.092802, 0.108389, 0.094039>
    rotate <-4.7617, 7.467549, -31.187204>
    translate  <3.642585, -3.973999, -1.640113>
  }
  texture {
    Copper_Textur1
  }
}


union { // Smalben
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.704672, 0.000000, -0.341636>, <-1.704672, -1.983813, -0.341636>, <1.735235, -1.983813, -1.083172>, <1.735235, 0.000000, -1.083172>,
      <-2.454480, 0.000000, -0.118853>, <-2.454480, -2.663578, -0.118853>, <2.191009, -2.663578, -1.041309>, <2.191009, 0.000000, -1.041309>,
      <-1.384634, 0.109754, 0.113584>, <-1.384634, -1.827950, 0.113584>, <1.407928, -1.827950, 0.016300>, <1.350251, 0.109754, 0.153124>,
      <-1.742523, 0.209166, 0.291171>, <-1.695694, -2.026914, 0.520368>, <1.777543, -2.239044, -0.031395>, <1.641637, 0.003689, 0.294878>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.735235, 0.000000, -1.083172>, <1.735235, 1.983813, -1.083172>, <-1.704672, 1.983813, -0.341636>, <-1.704672, 0.000000, -0.341636>,
      <2.191009, 0.000000, -1.041309>, <2.191009, 2.663578, -1.041309>, <-2.454480, 2.663578, -0.118853>, <-2.454480, 0.000000, -0.118853>,
      <1.350251, 0.109754, 0.153124>, <1.292575, 2.047458, 0.289948>, <-1.384634, 2.047458, 0.113584>, <-1.384634, 0.109754, 0.113584>,
      <1.641637, 0.003689, 0.294878>, <1.505731, 2.246422, 0.621151>, <-1.789351, 2.445245, 0.061973>, <-1.742523, 0.209166, 0.291171>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.742523, 0.209166, 0.291171>, <-1.695694, -2.026914, 0.520368>, <1.777543, -2.239044, -0.031395>, <1.641637, 0.003689, 0.294878>,
      <-2.100412, 0.308578, 0.468758>, <-2.006755, -2.225878, 0.927153>, <2.147158, -2.650138, -0.079090>, <1.933023, -0.102376, 0.436632>,
      <-1.660938, 0.109754, 0.650576>, <-1.660938, -1.894401, 0.650576>, <1.594846, -1.894401, 2.138773>, <1.594846, 0.246947, 2.138773>,
      <-1.596134, 0.109754, 1.118986>, <-1.596134, -1.971375, 1.118986>, <1.710862, -1.971375, 2.294929>, <1.710862, 0.260666, 2.294929>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.641637, 0.003689, 0.294878>, <1.505731, 2.246422, 0.621151>, <-1.789351, 2.445245, 0.061973>, <-1.742523, 0.209166, 0.291171>,
      <1.933023, -0.102376, 0.436632>, <1.718888, 2.445386, 0.952354>, <-2.194069, 2.843033, 0.010363>, <-2.100412, 0.308578, 0.468758>,
      <1.594846, 0.246947, 2.138773>, <1.594846, 2.388294, 2.138773>, <-1.660938, 2.113909, 0.650576>, <-1.660938, 0.109754, 0.650576>,
      <1.710862, 0.260666, 2.294929>, <1.710862, 2.465268, 2.294929>, <-1.596134, 2.190883, 1.118986>, <-1.596134, 0.109754, 1.118986>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.596134, 0.109754, 1.118986>, <-1.596134, -1.971375, 1.118986>, <1.710862, -1.971375, 2.294929>, <1.710862, 0.260666, 2.294929>,
      <-1.531330, 0.109754, 1.587396>, <-1.531330, -2.048348, 1.587396>, <1.826878, -2.048348, 2.451086>, <1.826878, 0.246947, 2.451086>,
      <-1.765621, -0.152733, 2.774073>, <-1.765621, -2.448028, 2.774073>, <1.652440, -2.048348, 3.261589>, <1.652440, 0.246947, 3.261589>,
      <-1.684410, -0.076367, 3.425530>, <-1.684410, -2.248188, 3.425530>, <1.652440, -2.048348, 3.669287>, <1.652440, 0.123473, 3.669287>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.710862, 0.260666, 2.294929>, <1.710862, 2.465268, 2.294929>, <-1.596134, 2.190883, 1.118986>, <-1.596134, 0.109754, 1.118986>,
      <1.826878, 0.246947, 2.451086>, <1.826878, 2.542241, 2.451086>, <-1.531330, 2.267856, 1.587396>, <-1.531330, 0.109754, 1.587396>,
      <1.652440, 0.246947, 3.261589>, <1.652440, 2.542241, 3.261589>, <-1.765621, 2.142562, 2.774073>, <-1.765621, -0.152733, 2.774073>,
      <1.652440, 0.123473, 3.669287>, <1.652440, 2.295295, 3.669287>, <-1.684410, 2.095455, 3.425530>, <-1.684410, -0.076367, 3.425530>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.684410, -0.076367, 3.425530>, <-1.684410, -2.248188, 3.425530>, <1.652440, -2.048348, 3.669287>, <1.652440, 0.123473, 3.669287>,
      <-1.603199, 0.000000, 4.076986>, <-1.603199, -2.048348, 4.076986>, <1.652440, -2.048348, 4.076986>, <1.652440, 0.000000, 4.076986>,
      <-1.603199, 0.000000, 4.484685>, <-1.603199, -2.048348, 4.484685>, <1.652440, -2.048348, 4.484685>, <1.652440, 0.000000, 4.484685>,
      <-1.603199, 0.000000, 4.949585>, <-1.603199, -2.096687, 4.949585>, <1.710035, -2.096687, 4.949585>, <1.710035, 0.000000, 4.949585>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.652440, 0.123473, 3.669287>, <1.652440, 2.295295, 3.669287>, <-1.684410, 2.095455, 3.425530>, <-1.684410, -0.076367, 3.425530>,
      <1.652440, 0.000000, 4.076986>, <1.652440, 2.048348, 4.076986>, <-1.603199, 2.048348, 4.076986>, <-1.603199, 0.000000, 4.076986>,
      <1.652440, 0.000000, 4.484685>, <1.652440, 2.048348, 4.484685>, <-1.603199, 2.048348, 4.484685>, <-1.603199, 0.000000, 4.484685>,
      <1.710035, 0.000000, 4.949585>, <1.710035, 2.096687, 4.949585>, <-1.603199, 2.096687, 4.949585>, <-1.603199, 0.000000, 4.949585>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.603199, 0.000000, 4.949585>, <-1.603199, -2.096687, 4.949585>, <1.710035, -2.096687, 4.949585>, <1.710035, 0.000000, 4.949585>,
      <-1.603199, 0.000000, 5.414485>, <-1.603199, -2.145025, 5.414485>, <1.767629, -2.145025, 5.414485>, <1.767629, 0.000000, 5.414485>,
      <-1.603199, 0.000000, 5.830984>, <-1.603199, -2.145025, 5.830984>, <1.799864, -2.145025, 5.830984>, <1.799864, 0.000000, 5.830984>,
      <-1.603199, 0.000000, 6.328106>, <-1.603199, -2.203793, 6.328106>, <1.848218, -2.203793, 6.328106>, <1.848218, 0.000000, 6.328106>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.710035, 0.000000, 4.949585>, <1.710035, 2.096687, 4.949585>, <-1.603199, 2.096687, 4.949585>, <-1.603199, 0.000000, 4.949585>,
      <1.767629, 0.000000, 5.414485>, <1.767629, 2.145025, 5.414485>, <-1.603199, 2.145025, 5.414485>, <-1.603199, 0.000000, 5.414485>,
      <1.799864, 0.000000, 5.830984>, <1.799864, 2.145025, 5.830984>, <-1.603199, 2.145025, 5.830984>, <-1.603199, 0.000000, 5.830984>,
      <1.848218, 0.000000, 6.328106>, <1.848218, 2.203793, 6.328106>, <-1.603199, 2.203793, 6.328106>, <-1.603199, 0.000000, 6.328106>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.603199, 0.000000, 6.328106>, <-1.603199, -2.203793, 6.328106>, <1.848218, -2.203793, 6.328106>, <1.848218, 0.000000, 6.328106>,
      <-1.603199, 0.000000, 6.825227>, <-1.603199, -2.262561, 6.825227>, <1.896571, -2.262561, 6.825227>, <1.896571, 0.000000, 6.825227>,
      <-1.603199, 0.000000, 7.251804>, <-1.603199, -2.262561, 7.251804>, <1.998005, -2.262561, 7.251804>, <1.998005, 0.000000, 7.251804>,
      <-1.603199, 0.000000, 7.678381>, <-1.603199, -2.262561, 7.678381>, <1.998005, -2.262561, 7.678381>, <1.998005, 0.000000, 7.678381>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.848218, 0.000000, 6.328106>, <1.848218, 2.203793, 6.328106>, <-1.603199, 2.203793, 6.328106>, <-1.603199, 0.000000, 6.328106>,
      <1.896571, 0.000000, 6.825227>, <1.896571, 2.262561, 6.825227>, <-1.603199, 2.262561, 6.825227>, <-1.603199, 0.000000, 6.825227>,
      <1.998005, 0.000000, 7.251804>, <1.998005, 2.262561, 7.251804>, <-1.603199, 2.262561, 7.251804>, <-1.603199, 0.000000, 7.251804>,
      <1.998005, 0.000000, 7.678381>, <1.998005, 2.262561, 7.678381>, <-1.603199, 2.262561, 7.678381>, <-1.603199, 0.000000, 7.678381>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.603199, 0.000000, 7.678381>, <-1.603199, -2.262561, 7.678381>, <1.998005, -2.262561, 7.678381>, <1.998005, 0.000000, 7.678381>,
      <-1.603199, 0.000000, 8.104958>, <-1.603199, -2.262561, 8.104958>, <1.998005, -2.262561, 8.104958>, <1.998005, 0.000000, 8.104958>,
      <-1.603199, 0.000000, 8.531534>, <-1.603199, -2.262561, 8.531534>, <1.998005, -2.262561, 8.531534>, <1.998005, 0.000000, 8.531534>,
      <-1.603199, 0.000000, 8.958111>, <-1.603199, -2.262561, 8.958111>, <1.998005, -2.262561, 8.958111>, <1.998005, 0.000000, 8.958111>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.998005, 0.000000, 7.678381>, <1.998005, 2.262561, 7.678381>, <-1.603199, 2.262561, 7.678381>, <-1.603199, 0.000000, 7.678381>,
      <1.998005, 0.000000, 8.104958>, <1.998005, 2.262561, 8.104958>, <-1.603199, 2.262561, 8.104958>, <-1.603199, 0.000000, 8.104958>,
      <1.998005, 0.000000, 8.531534>, <1.998005, 2.262561, 8.531534>, <-1.603199, 2.262561, 8.531534>, <-1.603199, 0.000000, 8.531534>,
      <1.998005, 0.000000, 8.958111>, <1.998005, 2.262561, 8.958111>, <-1.603199, 2.262561, 8.958111>, <-1.603199, 0.000000, 8.958111>
    }
  }
  texture {
    LegTex
  }
  scale 0.25784
  rotate <0.0, 21.360336, 25.742023>
  translate  <4.189344, -3.477472, -1.00094>
}


#declare Ecke1 = intersection {
  torus { // EckeT1
    0.1, 0.06  rotate -x*90
    rotate -83.0*y
    translate  <-7.366899, -1.795066, -2.50417>
  }
  box { // EckeB1
    <-1, -1, -1>, <1, 1, 1>
    scale 0.15
    rotate 7.0*y
    translate  <-7.344872, -1.943937, -2.356462>
  }
}
#declare Ecke2 = intersection {
  torus { // EckeT2
    0.1, 0.06  rotate -x*90
    rotate -83.0*y
    translate  <-7.366899, -1.795066, -2.50417>
  }
  box { // EckeB2
    <-1, -1, -1>, <1, 1, 1>
    scale 0.15
    rotate 7.0*y
    translate  <-7.344872, -1.943937, -2.356462>
  }
  rotate <89.738564, 7.0, -6.980227>
  translate  <-0.414555, -5.190804, -3.399014>
}
#declare Ecke3 = intersection {
  torus { // EckeT3
    0.1, 0.06  rotate -x*90
    rotate <-97.0, 0.0, -90.0>
    translate  <-7.368111, 1.804739, -2.506004>
  }
  box { // Ecke3B
    <-1, -1, -1>, <1, 1, 1>
    scale 0.15
    rotate 7.0*y
    translate  <-7.358923, 1.955026, -2.354464>
  }
}
#declare Ecke4 = intersection {
  torus { // EckeT4
    0.1, 0.06  rotate -x*90
    rotate <-97.0, 0.0, -90.0>
    translate  <-7.368111, 1.804739, -2.506004>
  }
  box { // Ecke3B1
    <-1, -1, -1>, <1, 1, 1>
    scale 0.15
    rotate 7.0*y
    translate  <-7.358923, 1.955026, -2.354464>
  }
  rotate <-89.313225, 6.090629, 6.445459>
  translate  <-0.393437, 5.118209, -3.251197>
}
#declare BzPtch001 = union {
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-4.790636, -3.548483, -4.762580>, <-3.654293, -4.505365, -4.336462>, <-3.285903, -4.615934, -4.200146>, <-2.131853, -4.498593, -3.910054>,
      <-5.510399, -3.261973, -4.916986>, <-4.401939, -4.248265, -4.518374>, <-3.935241, -4.490446, -3.805774>, <-3.795904, -4.745223, -3.013831>,
      <-5.970228, -2.977441, -4.916986>, <-6.839412, -3.345520, -3.614636>, <-6.805537, -3.345520, -2.055006>, <-6.471015, -3.345520, -1.431441>,
      <-6.358490, -2.233081, -5.007598>, <-7.140894, -2.672760, -3.518019>, <-7.075876, -2.672760, -2.133115>, <-6.768358, -2.672760, -1.486530>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-6.358490, -2.233081, -5.007598>, <-7.140894, -2.672760, -3.518019>, <-7.075876, -2.672760, -2.133115>, <-6.768358, -2.672760, -1.486530>,
      <-6.746751, -1.488721, -5.098210>, <-7.442377, -2.000000, -3.421403>, <-7.346215, -2.000000, -2.211224>, <-7.065702, -2.000000, -1.541619>,
      <-6.746751, -0.744360, -5.098210>, <-7.321126, -1.000000, -3.356045>, <-7.326603, -1.000000, -2.231566>, <-7.155330, -1.000000, -1.633683>,
      <-6.746751, 0.000000, -5.098210>, <-7.321126, 0.000000, -3.356045>, <-7.325986, 0.000000, -2.231732>, <-7.155021, 0.000000, -1.633766>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-6.746751, 0.000000, -5.098210>, <-7.321126, 0.000000, -3.356045>, <-7.325986, 0.000000, -2.231732>, <-7.155021, 0.000000, -1.633766>,
      <-6.746751, 0.744360, -5.098210>, <-7.321126, 1.000000, -3.356045>, <-7.325368, 1.000000, -2.231897>, <-7.154713, 1.000000, -1.633848>,
      <-6.746751, 1.488721, -5.098210>, <-7.442377, 2.000000, -3.421403>, <-7.346215, 2.000000, -2.211224>, <-7.065702, 2.000000, -1.541619>,
      <-6.358490, 2.233081, -5.007598>, <-7.330543, 2.903792, -3.634974>, <-7.287210, 2.874930, -2.345874>, <-6.981298, 2.894172, -1.664789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-6.358490, 2.233081, -5.007598>, <-7.330543, 2.903792, -3.634974>, <-7.287210, 2.874930, -2.345874>, <-6.981298, 2.894172, -1.664789>,
      <-5.970228, 2.977441, -4.916986>, <-7.218708, 3.807585, -3.848546>, <-7.228204, 3.749860, -2.480524>, <-6.896894, 3.788343, -1.787959>,
      <-5.970228, 3.721801, -4.916986>, <-4.401939, 4.248265, -4.518374>, <-3.935241, 4.490446, -3.805774>, <-3.795904, 4.745223, -3.013831>,
      <-4.996267, 4.202963, -4.680007>, <-3.654293, 4.505365, -4.336462>, <-3.285903, 4.615934, -4.200146>, <-2.131853, 4.498593, -3.910054>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-2.131853, -4.498593, -3.910054>, <-0.977803, -4.381253, -3.619962>, <0.911057, -4.462103, -3.181165>, <2.284691, -3.341427, -2.858910>,
      <-3.795904, -4.745223, -3.013831>, <-3.656567, -5.000000, -2.221887>, <-2.257063, -5.000000, -0.933521>, <-1.166785, -5.000000, -0.035585>,
      <-6.471015, -3.345520, -1.431441>, <-6.136492, -3.345520, -0.807876>, <-4.577955, -3.709887, 0.292129>, <-2.738343, -3.854944, 1.143448>,
      <-6.768358, -2.672760, -1.486530>, <-6.460840, -2.672760, -0.839945>, <-5.055338, -2.854944, 0.352487>, <-3.507720, -2.927472, 1.206360>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-6.768358, -2.672760, -1.486530>, <-6.460840, -2.672760, -0.839945>, <-5.055338, -2.854944, 0.352487>, <-3.507720, -2.927472, 1.206360>,
      <-7.065702, -2.000000, -1.541619>, <-6.785189, -2.000000, -0.872015>, <-5.532720, -2.000000, 0.412845>, <-4.277097, -2.000000, 1.269272>,
      <-7.155330, -1.000000, -1.633683>, <-6.984057, -1.000000, -1.035800>, <-5.622416, -1.000000, 0.338973>, <-4.315212, -1.000000, 1.237881>,
      <-7.155021, 0.000000, -1.633766>, <-6.984057, 0.000000, -1.035800>, <-5.622416, 0.000000, 0.338973>, <-4.315212, 0.000000, 1.237881>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-7.155021, 0.000000, -1.633766>, <-6.984057, 0.000000, -1.035800>, <-5.622416, 0.000000, 0.338973>, <-4.315212, 0.000000, 1.237881>,
      <-7.154713, 1.000000, -1.633848>, <-6.984057, 1.000000, -1.035800>, <-5.622416, 1.000000, 0.338973>, <-4.315212, 1.000000, 1.237881>,
      <-7.065702, 2.000000, -1.541619>, <-6.785189, 2.000000, -0.872015>, <-5.532720, 2.000000, 0.412845>, <-4.277097, 2.000000, 1.269272>,
      <-6.981298, 2.894172, -1.664789>, <-6.675386, 2.913413, -0.983704>, <-5.069495, 2.854944, 0.366281>, <-3.987943, 2.927472, 1.216091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-6.981298, 2.894172, -1.664789>, <-6.675386, 2.913413, -0.983704>, <-5.069495, 2.854944, 0.366281>, <-3.987943, 2.927472, 1.216091>,
      <-6.896894, 3.788343, -1.787959>, <-6.565583, 3.826826, -1.095394>, <-4.606270, 3.709887, 0.319716>, <-3.698789, 3.854944, 1.162910>,
      <-3.795904, 4.745223, -3.013831>, <-3.656567, 5.000000, -2.221887>, <-2.257063, 5.000000, -0.933521>, <-1.166785, 5.000000, -0.035585>,
      <-2.131853, 4.498593, -3.910054>, <-0.977803, 4.381253, -3.619962>, <0.911057, 4.462103, -3.181165>, <2.284691, 3.341427, -2.858910>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <2.284691, -3.341427, -2.858910>, <3.658325, -2.220751, -2.536655>, <2.042317, -4.139488, 1.525479>, <3.391696, -5.069744, -0.440519>,
      <-1.166785, -5.000000, -0.035585>, <-0.076507, -5.000000, 0.862351>, <0.927162, -5.000000, 1.688957>, <2.315826, -5.000000, 2.369958>,
      <-2.738343, -3.854944, 1.143448>, <-0.898731, -4.000000, 1.994768>, <0.769552, -4.000000, 2.438257>, <1.944733, -4.000000, 2.836314>,
      <-3.507720, -2.927472, 1.206360>, <-1.960102, -3.000000, 2.060233>, <-0.222487, -3.000000, 2.594568>, <1.315918, -3.000000, 2.953148>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-3.507720, -2.927472, 1.206360>, <-1.960102, -3.000000, 2.060233>, <-0.222487, -3.000000, 2.594568>, <1.315918, -3.000000, 2.953148>,
      <-4.277097, -2.000000, 1.269272>, <-3.021474, -2.000000, 2.125699>, <-1.214525, -2.000000, 2.750879>, <0.687104, -2.000000, 3.069982>,
      <-4.315212, -1.000000, 1.237881>, <-3.008008, -1.000000, 2.136789>, <-1.338316, -1.000000, 2.676288>, <0.384809, -1.000000, 3.098272>,
      <-4.315212, 0.000000, 1.237881>, <-3.008008, 0.000000, 2.136789>, <-1.338316, 0.000000, 2.676288>, <0.384809, 0.000000, 3.098272>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-4.315212, 0.000000, 1.237881>, <-3.008008, 0.000000, 2.136789>, <-1.338316, 0.000000, 2.676288>, <0.384809, 0.000000, 3.098272>,
      <-4.315212, 1.000000, 1.237881>, <-3.008008, 1.000000, 2.136789>, <-1.338316, 1.000000, 2.676288>, <0.384809, 1.000000, 3.098272>,
      <-4.277097, 2.000000, 1.269272>, <-3.021474, 2.000000, 2.125699>, <-1.214525, 2.000000, 2.750879>, <0.708707, 2.000000, 3.047225>,
      <-3.987943, 2.927472, 1.216091>, <-2.906391, 3.000000, 2.065902>, <-1.174118, 3.000000, 2.622196>, <0.997048, 3.000000, 2.909731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-3.987943, 2.927472, 1.216091>, <-2.906391, 3.000000, 2.065902>, <-1.174118, 3.000000, 2.622196>, <0.997048, 3.000000, 2.909731>,
      <-3.698789, 3.854944, 1.162910>, <-2.791308, 4.000000, 2.006104>, <-1.133711, 4.000000, 2.493514>, <1.285389, 4.000000, 2.772236>,
      <-1.166785, 5.000000, -0.035585>, <-0.076507, 5.000000, 0.862351>, <0.927162, 5.000000, 1.688957>, <2.315826, 5.000000, 2.369958>,
      <2.284691, 3.341427, -2.858910>, <3.658325, 2.220751, -2.536655>, <2.042317, 4.139488, 1.525479>, <3.391696, 5.069744, -0.440519>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <3.391696, -5.069744, -0.440519>, <4.741075, -6.000000, -2.406517>, <6.337422, -7.367348, -2.492544>, <6.656932, -6.419064, -2.358458>,
      <2.315826, -5.000000, 2.369958>, <3.704489, -5.000000, 3.050959>, <5.010852, -5.000000, 4.053404>, <6.608785, -6.139457, -1.876217>,
      <1.944733, -4.000000, 2.836314>, <3.119914, -4.000000, 3.234372>, <4.532104, -4.000000, 3.773119>, <6.121003, -2.718169, 4.229565>,
      <1.315918, -3.000000, 2.953148>, <2.854323, -3.000000, 3.311729>, <4.196132, -3.000000, 3.881642>, <5.567822, -2.315819, 4.163928>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <1.315918, -3.000000, 2.953148>, <2.854323, -3.000000, 3.311729>, <4.196132, -3.000000, 3.881642>, <5.567822, -2.315819, 4.163928>,
      <0.687104, -2.000000, 3.069982>, <2.588733, -2.000000, 3.389086>, <3.860161, -2.000000, 3.990165>, <5.014641, -1.913469, 4.098292>,
      <0.384809, -1.000000, 3.098272>, <2.107935, -1.000000, 3.520257>, <3.835269, -1.000000, 4.131865>, <5.014641, -0.913469, 4.098292>,
      <0.384809, 0.000000, 3.098272>, <2.107935, 0.000000, 3.520257>, <3.835269, 0.000000, 4.131865>, <5.014641, 0.086531, 4.098292>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <0.384809, 0.000000, 3.098272>, <2.107935, 0.000000, 3.520257>, <3.835269, 0.000000, 4.131865>, <5.014641, 0.086531, 4.098292>,
      <0.384809, 1.000000, 3.098272>, <2.107935, 1.000000, 3.520257>, <3.835269, 1.000000, 4.131865>, <5.014641, 1.086531, 4.098292>,
      <0.708707, 2.000000, 3.047225>, <2.631940, 2.000000, 3.343571>, <3.903368, 2.000000, 3.944650>, <5.014641, 2.086531, 4.098292>,
      <0.997048, 3.000000, 2.909731>, <3.168215, 3.000000, 3.197265>, <4.217736, 3.000000, 3.858885>, <5.567822, 2.402350, 4.163928>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <0.997048, 3.000000, 2.909731>, <3.168215, 3.000000, 3.197265>, <4.217736, 3.000000, 3.858885>, <5.567822, 2.402350, 4.163928>,
      <1.285389, 4.000000, 2.772236>, <3.704489, 4.000000, 3.050959>, <4.532104, 4.000000, 3.773119>, <6.121003, 2.718169, 4.229565>,
      <2.315826, 5.000000, 2.369958>, <3.704489, 5.000000, 3.050959>, <5.010852, 5.000000, 4.053404>, <6.608785, 6.139457, -1.876217>,
      <3.391696, 5.069744, -0.440519>, <4.741075, 6.000000, -2.406517>, <6.337422, 7.367348, -2.492544>, <6.656932, 6.527268, -2.325824>
    }
  }
}
union { // GradMColoured
  cylinder { // RuntLampaCyl1
    <0,0,1>, <0,0,0>, 1
    scale <0.06, 0.06, 3.6>
    rotate -90.0*x
    translate  <-7.356251, -1.793865, -2.40658>
  }
  cylinder { // RuntLampaCyl2
    <0,0,1>, <0,0,0>, 1
    scale <0.06, 0.06, 3.6>
    rotate -90.0*x
    translate  <-7.601359, -1.796919, -4.392762>
  }
  cylinder { // RuntLampaCyl3
    <0,0,1>, <0,0,0>, 1
    scale <0.06, 0.06, 1.803274>
    rotate <0.0, 7.0, 0.0>
    translate  <-7.587337, -1.897396, -4.295258>
  }
  cylinder { // RuntLampaCyl4
    <0,0,1>, <0,0,0>, 1
    scale <0.06, 0.06, 1.803274>
    rotate <0.0, 7.0, 0.0>
    translate  <-7.587169, 1.905997, -4.295445>
  }
  object { Ecke1 }
  object { Ecke2 }
  object { Ecke3 }
  object { Ecke4 }
  box { // LampKant1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.8, 0.05>
    translate  <-6.627047, 0.0, -4.395113>
  }
  cone { // LampKant2
    <0,0,0>, 0.5, <0,0,1>, 1.0
    scale <0.562901, 0.035765, 1.977949>
    rotate <-180.0, 0.380227, -180.0>
    translate  <-7.047181, -1.871927, -2.411959>
  }
  cone { // LampKant3
    <0,0,0>, 0.5, <0,0,1>, 1.0
    scale <0.562901, 0.035765, 1.977949>
    rotate <-180.0, 0.380227, -180.0>
    translate  <-7.052185, 1.88618, -2.411959>
  }
  cylinder { // FotPinne
    <0,0,1>, <0,0,0>, 1
    scale <0.15, 0.15, 4.0>
    rotate -90.0*x
    translate  <2.724395, -5.012312, -3.047621>
  }
  torus { // FlashyThing
    1.5, 0.5  rotate -x*90
    scale <1.813238, 0.891568, 0.298794>
    rotate <-90.0, -31.56197, 0.0>
    translate  <-3.578246, -1.555907, -0.37595>
  }
  torus { // FlashyThing1
    1.5, 0.5  rotate -x*90
    scale <1.813238, 0.891568, 0.298794>
    rotate <-90.0, -31.56197, 0.0>
    translate  <-3.578246, 1.522766, -0.37595>
  }
  object { BzPtch001 }
  torus { // FlashyThing2
    1.5, 0.5  rotate -x*90
    scale <1.813238, 0.891568, 0.298794>
    rotate <-90.0, -31.56197, 0.0>
    translate  <-3.958467, 0.0, -0.72553>
  }
  texture {
    Chrome_Metal1
    scale <16.042542, 7.145297, 24.941441>
    rotate -10.616621*y
  translate <5.547200, 0.000000, 3.676730>
  }
}


union { // Sits
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.601896, 0.000000, 0.000000>, <-0.601896, -0.409883, 0.000000>, <-0.828847, -0.765368, 0.000000>, <0.000000, -0.765368, 0.000000>,
      <-0.800948, 0.166763, 0.253947>, <-1.000000, -0.550000, 0.500000>, <-1.377061, -1.027007, 0.500000>, <0.000000, -1.027007, 0.500000>,
      <-1.000000, 0.000000, 1.000000>, <-1.000000, -0.550000, 1.000000>, <-1.377061, -1.027007, 1.000000>, <0.000000, -1.027007, 1.000000>,
      <-1.000000, 0.000000, 1.500000>, <-1.000000, -0.550000, 1.500000>, <-1.377061, -1.027007, 1.500000>, <0.000000, -1.027007, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.765368, 0.000000>, <0.828847, -0.765368, 0.000000>, <0.601896, -0.409883, 0.000000>, <0.601896, 0.000000, 0.000000>,
      <0.000000, -1.027007, 0.500000>, <1.377061, -1.027007, 0.500000>, <1.000000, -0.550000, 0.500000>, <0.800948, 0.166763, 0.253947>,
      <0.000000, -1.027007, 1.000000>, <1.377061, -1.027007, 1.000000>, <1.000000, -0.550000, 1.000000>, <1.000000, 0.000000, 1.000000>,
      <0.000000, -1.027007, 1.500000>, <1.377061, -1.027007, 1.500000>, <1.000000, -0.550000, 1.500000>, <1.000000, 0.000000, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.601896, 0.000000, 0.000000>, <0.601896, 0.409883, 0.000000>, <0.841477, 0.813535, 0.000000>, <0.000000, 0.813535, 0.000000>,
      <0.800948, 0.166763, 0.253947>, <0.601896, 0.883525, 0.007895>, <0.841477, 1.753619, 0.007895>, <0.000000, 1.753619, 0.007895>,
      <1.000000, 0.000000, 1.000000>, <1.000000, 0.550000, 1.000000>, <1.398045, 1.091638, 1.000000>, <0.000000, 1.091638, 1.000000>,
      <1.000000, 0.000000, 1.500000>, <1.000000, 0.550000, 1.500000>, <0.978955, 1.091638, 1.496336>, <0.000000, 1.091638, 1.496336>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.813535, 0.000000>, <-0.841477, 0.813535, 0.000000>, <-0.601896, 0.409883, 0.000000>, <-0.601896, 0.000000, 0.000000>,
      <0.000000, 1.753619, 0.007895>, <-0.841477, 1.753619, 0.007895>, <-0.601896, 0.883525, 0.007895>, <-0.800948, 0.166763, 0.253947>,
      <0.000000, 1.091638, 1.000000>, <-1.398045, 1.091638, 1.000000>, <-1.000000, 0.550000, 1.000000>, <-1.000000, 0.000000, 1.000000>,
      <0.000000, 1.091638, 1.496336>, <-0.978955, 1.091638, 1.496336>, <-1.000000, 0.550000, 1.500000>, <-1.000000, 0.000000, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, 0.000000, 1.500000>, <-1.000000, -0.550000, 1.500000>, <-1.377061, -1.027007, 1.500000>, <0.000000, -1.027007, 1.500000>,
      <-1.000000, 0.000000, 2.000000>, <-1.000000, -0.550000, 2.000000>, <-1.377061, -1.027007, 2.000000>, <0.000000, -1.027007, 2.000000>,
      <-1.000000, 0.000000, 2.500000>, <-1.000000, -0.550000, 2.500000>, <-1.377061, -1.027007, 2.500000>, <0.000000, -1.027007, 2.500000>,
      <-1.000000, 0.000000, 3.000000>, <-1.000000, -0.550000, 3.000000>, <-1.377061, -1.027007, 3.000000>, <0.000000, -1.027007, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -1.027007, 1.500000>, <1.377061, -1.027007, 1.500000>, <1.000000, -0.550000, 1.500000>, <1.000000, 0.000000, 1.500000>,
      <0.000000, -1.027007, 2.000000>, <1.377061, -1.027007, 2.000000>, <1.000000, -0.550000, 2.000000>, <1.000000, 0.000000, 2.000000>,
      <0.000000, -1.027007, 2.500000>, <1.377061, -1.027007, 2.500000>, <1.000000, -0.550000, 2.500000>, <1.000000, 0.000000, 2.500000>,
      <0.000000, -1.027007, 3.000000>, <1.377061, -1.027007, 3.000000>, <1.000000, -0.550000, 3.000000>, <1.000000, 0.000000, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, 0.000000, 1.500000>, <1.000000, 0.550000, 1.500000>, <0.978955, 1.091638, 1.496336>, <0.000000, 1.091638, 1.496336>,
      <1.000000, 0.000000, 2.000000>, <1.000000, 0.550000, 2.000000>, <0.559865, 1.091638, 1.992672>, <0.000000, 1.091638, 1.992672>,
      <1.000000, 0.000000, 2.500000>, <1.000000, 0.550000, 2.500000>, <0.559865, 1.091638, 2.490840>, <0.000000, 1.091638, 2.490840>,
      <1.000000, 0.000000, 3.000000>, <1.000000, 0.550000, 3.000000>, <0.559865, 1.091638, 2.989009>, <0.000000, 1.091638, 2.989009>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 1.091638, 1.496336>, <-0.978955, 1.091638, 1.496336>, <-1.000000, 0.550000, 1.500000>, <-1.000000, 0.000000, 1.500000>,
      <0.000000, 1.091638, 1.992672>, <-0.559865, 1.091638, 1.992672>, <-1.000000, 0.550000, 2.000000>, <-1.000000, 0.000000, 2.000000>,
      <0.000000, 1.091638, 2.490840>, <-0.559865, 1.091638, 2.490840>, <-1.000000, 0.550000, 2.500000>, <-1.000000, 0.000000, 2.500000>,
      <0.000000, 1.091638, 2.989009>, <-0.559865, 1.091638, 2.989009>, <-1.000000, 0.550000, 3.000000>, <-1.000000, 0.000000, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, 0.000000, 3.000000>, <-1.000000, -0.550000, 3.000000>, <-1.377061, -1.027007, 3.000000>, <0.000000, -1.027007, 3.000000>,
      <-1.000000, 0.000000, 3.500000>, <-1.000000, -0.550000, 3.500000>, <-1.377061, -1.027007, 3.500000>, <0.000000, -1.027007, 3.500000>,
      <-1.000000, 0.000000, 4.000000>, <-1.000000, -0.550000, 4.000000>, <-1.377061, -1.027007, 4.000000>, <0.000000, -1.027007, 4.000000>,
      <-1.000000, 0.000000, 4.500000>, <-1.000000, -0.550000, 4.500000>, <-1.377061, -1.027007, 4.500000>, <0.000000, -1.027007, 4.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -1.027007, 3.000000>, <1.377061, -1.027007, 3.000000>, <1.000000, -0.550000, 3.000000>, <1.000000, 0.000000, 3.000000>,
      <0.000000, -1.027007, 3.500000>, <1.377061, -1.027007, 3.500000>, <1.000000, -0.550000, 3.500000>, <1.000000, 0.000000, 3.500000>,
      <0.000000, -1.027007, 4.000000>, <1.377061, -1.027007, 4.000000>, <1.000000, -0.550000, 4.000000>, <1.000000, 0.000000, 4.000000>,
      <0.000000, -1.027007, 4.500000>, <1.377061, -1.027007, 4.500000>, <1.000000, -0.550000, 4.500000>, <1.000000, 0.000000, 4.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, 0.000000, 3.000000>, <1.000000, 0.550000, 3.000000>, <0.559865, 1.091638, 2.989009>, <0.000000, 1.091638, 2.989009>,
      <1.000000, 0.000000, 3.500000>, <1.000000, 0.550000, 3.500000>, <0.559865, 1.091638, 3.487177>, <0.000000, 1.091638, 3.487177>,
      <1.000000, 0.000000, 4.000000>, <1.000000, 0.550000, 4.000000>, <0.559865, 1.091638, 3.985345>, <0.000000, 1.091638, 3.985345>,
      <1.000000, 0.000000, 4.500000>, <1.000000, 0.550000, 4.500000>, <0.978955, 1.091638, 4.492672>, <0.000000, 1.091638, 4.492672>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 1.091638, 2.989009>, <-0.559865, 1.091638, 2.989009>, <-1.000000, 0.550000, 3.000000>, <-1.000000, 0.000000, 3.000000>,
      <0.000000, 1.091638, 3.487177>, <-0.559865, 1.091638, 3.487177>, <-1.000000, 0.550000, 3.500000>, <-1.000000, 0.000000, 3.500000>,
      <0.000000, 1.091638, 3.985345>, <-0.559865, 1.091638, 3.985345>, <-1.000000, 0.550000, 4.000000>, <-1.000000, 0.000000, 4.000000>,
      <0.000000, 1.091638, 4.492672>, <-0.978955, 1.091638, 4.492672>, <-1.000000, 0.550000, 4.500000>, <-1.000000, 0.000000, 4.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, 0.000000, 4.500000>, <-1.000000, -0.550000, 4.500000>, <-1.377061, -1.027007, 4.500000>, <0.000000, -1.027007, 4.500000>,
      <-1.000000, 0.000000, 5.000000>, <-1.000000, -0.550000, 5.000000>, <-1.377061, -1.027007, 5.000000>, <0.000000, -1.027007, 5.000000>,
      <-1.000000, 0.129475, 5.615841>, <-1.000000, -0.731050, 5.500000>, <-1.377061, -1.365079, 5.500000>, <0.000000, -1.365079, 5.500000>,
      <-0.430199, -0.018249, 6.000000>, <-0.430199, -0.344188, 6.000000>, <-0.592411, -0.642698, 6.000000>, <0.000000, -0.642698, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -1.027007, 4.500000>, <1.377061, -1.027007, 4.500000>, <1.000000, -0.550000, 4.500000>, <1.000000, 0.000000, 4.500000>,
      <0.000000, -1.027007, 5.000000>, <1.377061, -1.027007, 5.000000>, <1.000000, -0.550000, 5.000000>, <1.000000, 0.000000, 5.000000>,
      <0.000000, -1.365079, 5.500000>, <1.377061, -1.365079, 5.500000>, <1.000000, -0.731050, 5.500000>, <1.000000, 0.129475, 5.615841>,
      <0.000000, -0.642698, 6.000000>, <0.592411, -0.642698, 6.000000>, <0.430199, -0.344188, 6.000000>, <0.430199, -0.018249, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, 0.000000, 4.500000>, <1.000000, 0.550000, 4.500000>, <0.978955, 1.091638, 4.492672>, <0.000000, 1.091638, 4.492672>,
      <1.000000, 0.000000, 5.000000>, <1.000000, 0.550000, 5.000000>, <1.398045, 1.091638, 5.000000>, <0.000000, 1.091638, 5.000000>,
      <1.000000, 0.129475, 5.615841>, <1.000000, 0.990000, 5.731681>, <1.398045, 1.964949, 5.731681>, <0.000000, 1.964949, 5.731681>,
      <0.430199, -0.018249, 6.000000>, <0.430199, 0.307691, 6.000000>, <0.601438, 0.610703, 6.000000>, <0.000000, 0.610703, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 1.091638, 4.492672>, <-0.978955, 1.091638, 4.492672>, <-1.000000, 0.550000, 4.500000>, <-1.000000, 0.000000, 4.500000>,
      <0.000000, 1.091638, 5.000000>, <-1.398045, 1.091638, 5.000000>, <-1.000000, 0.550000, 5.000000>, <-1.000000, 0.000000, 5.000000>,
      <0.000000, 1.964949, 5.731681>, <-1.398045, 1.964949, 5.731681>, <-1.000000, 0.990000, 5.731681>, <-1.000000, 0.129475, 5.615841>,
      <0.000000, 0.610703, 6.000000>, <-0.601438, 0.610703, 6.000000>, <-0.430199, 0.307691, 6.000000>, <-0.430199, -0.018249, 6.000000>
    }
  }
  texture {
    SulaTex
  }
  rotate <90.0, 0.0, -90.0>
  translate  <11.29168, 0.0, -1.187415>
}


intersection { // BigThing
  torus { // BigTorus
    1.5, 0.3  rotate -x*90
    scale <3.572453, 2.73805, 2.207911>
    rotate -90.0*x
    translate  <2.413979, 0.0, -4.35438>
  }
  box { // BigTorusCut
    <-1, -1, -1>, <1, 1, 1>
    scale <7.023375, 2.524025, 2.496396>
    translate  <-1.129383, 0.0, -0.376461>
  }
  texture {
    Chrome_Textur1
  }
}


#declare Sko = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.543944, -0.366943, 0.804816>, <-3.973399, -0.366824, 0.799998>, <-3.093279, -0.366786, 0.622797>, <-2.195758, -0.366772, 0.456761>,
      <-4.645563, -0.366980, 0.809116>, <-4.428870, -3.122898, 0.176561>, <-3.332994, -3.466988, -0.001426>, <-2.209926, -4.266078, -0.173673>,
      <-4.486597, -0.407006, 0.808847>, <-5.048388, -1.078221, 1.109148>, <-3.945328, -1.192871, 1.132053>, <-2.472472, -1.465935, 1.615833>,
      <-4.541338, -0.407042, 0.808714>, <-5.046327, -0.832868, 1.550621>, <-3.943231, -0.916653, 1.578384>, <-2.439536, -1.062929, 1.897264>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.541338, -0.407042, 0.808714>, <-5.046327, -0.832868, 1.550621>, <-3.943231, -0.916653, 1.578384>, <-2.439536, -1.062929, 1.897264>,
      <-4.596080, -0.407078, 0.808582>, <-5.044266, -0.587515, 1.992093>, <-3.941134, -0.640435, 2.024714>, <-2.406601, -0.659923, 2.178695>,
      <-4.596080, -0.407115, 0.808582>, <-5.044266, -0.096868, 2.013602>, <-3.941134, -0.096868, 2.046223>, <-2.406601, -0.116386, 2.189449>,
      <-4.626335, -0.387165, 0.808714>, <-5.046327, 0.205794, 1.572129>, <-3.943231, 0.241260, 1.599892>, <-2.439536, 0.385146, 1.900324>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.626335, -0.387165, 0.808714>, <-5.046327, 0.205794, 1.572129>, <-3.943231, 0.241260, 1.599892>, <-2.439536, 0.385146, 1.900324>,
      <-4.656590, -0.367216, 0.808847>, <-5.048388, 0.508457, 1.130657>, <-3.945328, 0.579389, 1.153561>, <-2.472472, 0.871291, 1.611199>,
      <-4.537859, -0.367235, 0.809116>, <-4.428870, 1.792448, 0.175266>, <-3.332994, 2.022121, -0.002721>, <-2.209926, 1.805321, -0.158932>,
      <-4.371140, -0.367254, 0.833023>, <-3.973399, -0.367305, 0.828205>, <-3.093279, -0.367322, 0.651003>, <-2.244677, -0.367303, 0.508926>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.195758, -0.366772, 0.456761>, <-1.298236, -0.366758, 0.290725>, <-0.259269, -0.366758, 0.544050>, <0.740542, -0.387728, 0.618864>,
      <-2.209926, -4.266078, -0.173673>, <-1.086858, -5.065168, -0.345919>, <0.195970, -5.065168, -0.092594>, <1.439642, -4.537485, -0.017780>,
      <-2.472472, -1.465935, 1.615833>, <-0.999616, -1.739000, 2.099613>, <0.144272, -1.739000, 2.120452>, <0.337384, -1.599727, 2.134507>,
      <-2.439536, -1.062929, 1.897264>, <-0.935842, -1.209205, 2.216144>, <0.155300, -1.209205, 2.230664>, <0.348412, -1.131799, 2.244718>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.439536, -1.062929, 1.897264>, <-0.935842, -1.209205, 2.216144>, <0.155300, -1.209205, 2.230664>, <0.348412, -1.131799, 2.244718>,
      <-2.406601, -0.659923, 2.178695>, <-0.872067, -0.679410, 2.332676>, <0.166328, -0.679410, 2.340875>, <0.359441, -0.663871, 2.354929>,
      <-2.406601, -0.116386, 2.189449>, <-0.872067, -0.135904, 2.332676>, <0.166328, -0.135904, 2.340875>, <0.359441, -0.183832, 2.354929>,
      <-2.439536, 0.385146, 1.900324>, <-0.935842, 0.513644, 2.200756>, <0.155300, 0.513644, 2.215275>, <0.348412, 0.362177, 2.237024>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.439536, 0.385146, 1.900324>, <-0.935842, 0.513644, 2.200756>, <0.155300, 0.513644, 2.215275>, <0.348412, 0.362177, 2.237024>,
      <-2.472472, 0.871291, 1.611199>, <-0.999616, 1.163192, 2.068836>, <0.144272, 1.163192, 2.089676>, <0.337384, 0.892797, 2.119119>,
      <-2.209926, 1.805321, -0.158932>, <-1.086858, 1.588521, -0.315143>, <0.195970, 1.588521, -0.061817>, <1.439642, 1.598703, -0.002392>,
      <-2.244677, -0.367303, 0.508926>, <-1.396074, -0.367284, 0.366849>, <-0.389855, -0.367284, 0.544050>, <0.653332, -0.388193, 0.618864>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.740542, -0.387728, 0.618864>, <1.740352, -0.408698, 0.693677>, <2.740162, -0.408698, 0.693677>, <3.849910, -0.408757, 0.855179>,
      <1.439642, -4.537485, -0.017780>, <2.683313, -4.009803, 0.057033>, <3.705179, -4.009803, 0.198794>, <4.198960, -3.300121, 0.220088>,
      <0.337384, -1.599727, 2.134507>, <0.530496, -1.460455, 2.148562>, <0.657020, -1.460455, 2.148562>, <1.805218, -1.234642, 1.898808>,
      <0.348412, -1.131799, 2.244718>, <0.541525, -1.054393, 2.258773>, <0.664201, -1.054393, 2.253756>, <1.511025, -0.916611, 2.106337>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.348412, -1.131799, 2.244718>, <0.541525, -1.054393, 2.258773>, <0.664201, -1.054393, 2.253756>, <1.511025, -0.916611, 2.106337>,
      <0.359441, -0.663871, 2.354929>, <0.552553, -0.648331, 2.368984>, <0.671383, -0.648331, 2.358950>, <1.216832, -0.598580, 2.313865>,
      <0.359441, -0.183832, 2.354929>, <0.552553, -0.231760, 2.368984>, <0.671383, -0.231760, 2.358950>, <1.216832, -0.272318, 2.313865>,
      <0.348412, 0.362177, 2.237024>, <0.541525, 0.195321, 2.258773>, <0.664201, 0.195321, 2.253756>, <1.511025, 0.062175, 2.106337>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.348412, 0.362177, 2.237024>, <0.541525, 0.195321, 2.258773>, <0.664201, 0.195321, 2.253756>, <1.511025, 0.062175, 2.106337>,
      <0.337384, 0.892797, 2.119119>, <0.530496, 0.622401, 2.148562>, <0.657020, 0.622401, 2.148562>, <1.805218, 0.396667, 1.898808>,
      <1.439642, 1.598703, -0.002392>, <2.683313, 1.608886, 0.057033>, <3.705179, 2.443473, 0.198794>, <4.198960, 1.754135, 0.220088>,
      <0.653332, -0.388193, 0.618864>, <1.696519, -0.409101, 0.693677>, <2.740162, -0.409235, 0.693677>, <3.849910, -0.409178, 0.855179>
    }
  }
  texture {
    BootTex
  }
  scale 0.240978
  rotate <3.269616, 15.558021, 19.97859>
  translate  <2.48593, -4.742274, -2.857389>
}
#declare Stovelskaft = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.197926, -0.000066, 0.015264>, <-1.197926, -0.215464, 0.015264>, <0.364427, -0.784787, 0.228804>, <0.364427, -0.001576, 0.228804>,
      <-0.349683, -0.000066, 0.645370>, <-0.349683, -0.541081, 0.645370>, <0.358402, -0.541081, 0.367858>, <0.358402, -0.000066, 0.367858>,
      <-0.534457, -0.000066, 0.780520>, <-0.534457, -0.541081, 0.780520>, <0.358402, -0.541081, 0.641808>, <0.358402, -0.000066, 0.641808>,
      <-0.500402, -0.000066, 0.965965>, <-0.500402, -0.541081, 0.965965>, <0.349933, -0.541081, 0.874375>, <0.349933, -0.000066, 0.878973>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.364427, -0.001576, 0.228804>, <0.364427, 0.781635, 0.228804>, <-1.197926, 0.215332, 0.015264>, <-1.197926, -0.000066, 0.015264>,
      <0.358402, -0.000066, 0.367858>, <0.358402, 0.540950, 0.367858>, <-0.349683, 0.540950, 0.645370>, <-0.349683, -0.000066, 0.645370>,
      <0.358402, -0.000066, 0.641808>, <0.358402, 0.540950, 0.641808>, <-0.534457, 0.540950, 0.780520>, <-0.534457, -0.000066, 0.780520>,
      <0.349933, -0.000066, 0.878973>, <0.349933, 0.540950, 0.874375>, <-0.500402, 0.540950, 0.965965>, <-0.500402, -0.000066, 0.965965>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.500402, -0.000066, 0.965965>, <-0.500402, -0.541081, 0.965965>, <0.349933, -0.541081, 0.874375>, <0.349933, -0.000066, 0.878973>,
      <-0.466348, -0.000066, 1.151409>, <-0.466348, -0.541081, 1.151409>, <0.341465, -0.541081, 1.106941>, <0.341465, -0.000066, 1.106941>,
      <-0.479160, -0.000066, 1.438172>, <-0.479160, -0.541081, 1.438172>, <0.341465, -0.541081, 1.361833>, <0.341465, -0.000066, 1.361833>,
      <-0.479160, -0.000066, 1.712122>, <-0.479160, -0.541081, 1.712122>, <0.341465, -0.541081, 1.616724>, <0.341465, -0.000066, 1.624499>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.349933, -0.000066, 0.878973>, <0.349933, 0.540950, 0.874375>, <-0.500402, 0.540950, 0.965965>, <-0.500402, -0.000066, 0.965965>,
      <0.341465, -0.000066, 1.106941>, <0.341465, 0.540950, 1.106941>, <-0.466348, 0.540950, 1.151409>, <-0.466348, -0.000066, 1.151409>,
      <0.341465, -0.000066, 1.361833>, <0.341465, 0.540950, 1.361833>, <-0.479160, 0.540950, 1.438172>, <-0.479160, -0.000066, 1.438172>,
      <0.341465, -0.000066, 1.624499>, <0.341465, 0.540950, 1.616724>, <-0.479160, 0.540950, 1.712122>, <-0.479160, -0.000066, 1.712122>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.479160, -0.000066, 1.712122>, <-0.479160, -0.541081, 1.712122>, <0.341465, -0.541081, 1.616724>, <0.341465, -0.000066, 1.624499>,
      <-0.479160, -0.000066, 1.986072>, <-0.479160, -0.541081, 1.986072>, <0.341465, -0.541081, 1.871616>, <0.341465, -0.000066, 1.871616>,
      <-0.496349, -0.000076, 2.321398>, <-0.496349, -0.701896, 2.321398>, <0.505164, -0.701896, 2.183613>, <0.505164, -0.000076, 2.183613>,
      <-0.444106, -0.000066, 2.113938>, <-0.444106, -0.477852, 2.113938>, <0.313357, -0.477852, 1.966873>, <0.313357, -0.000066, 1.966873>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.341465, -0.000066, 1.624499>, <0.341465, 0.540950, 1.616724>, <-0.479160, 0.540950, 1.712122>, <-0.479160, -0.000066, 1.712122>,
      <0.341465, -0.000066, 1.871616>, <0.341465, 0.540950, 1.871616>, <-0.479160, 0.540950, 1.986072>, <-0.479160, -0.000066, 1.986072>,
      <0.505164, -0.000076, 2.183613>, <0.505164, 0.701743, 2.183613>, <-0.496349, 0.701743, 2.321398>, <-0.496349, -0.000076, 2.321398>,
      <0.313357, -0.000066, 1.966873>, <0.313357, 0.477721, 1.966873>, <-0.444106, 0.477721, 2.113938>, <-0.444106, -0.000066, 2.113938>
    }
  }
  texture {
    BootTex
  }
  rotate <0.0, 27.420906, 22.19311>
  translate  <3.042819, -4.729988, -2.979871>
}
#declare SulaFram = difference {
  cylinder { // Sula1
    <0,0,1>, <0,0,0>, 1
    scale <1.140386, 0.531674, 0.1043>
    rotate <3.37027, 18.328152, 19.019392>
    translate  <2.46007, -4.882964, -2.856786>
  }
  box { // Sula1Cut
    <-1, -1, -1>, <1, 1, 1>
    scale <0.752682, 1.0, 0.554828>
    translate  <2.975752, -4.74206, -3.367237>
  }
  object { SulaC1 }
  object { SulaC2 }
  object { // SulaC3->SulaC2
    SulaC2
    rotate 0.0*z
    translate  <0.097274, 0.002661, -0.03699>
  }
  object { // SulaC4->SulaC2
    SulaC2
    rotate 0.0*z
    translate  <0.220489, 0.006032, -0.077685>
  }
  object { // SulaC5->SulaC2
    SulaC2
    rotate 0.0*z
    translate  <0.335216, 0.009171, -0.11889>
  }
  object { // SulaC6->SulaC2
    SulaC2
    rotate 0.0*z
    translate  <0.452219, 0.012372, -0.164933>
  }
  texture {
    SulaTex
  }
  rotate -1.567129*z
  translate  <0.153746, 0.008861, -0.012366>
}
#declare SulaBak = intersection {
  cylinder { // Sula2
    <0,0,1>, <0,0,0>, 1
    scale <0.714611, 0.466372, 0.250109>
    rotate <2.601937, 9.829716, 20.397869>
    translate  <2.803618, -4.759575, -3.086941>
  }
  box { // Sula2Cut
    <-1, -1, -1>, <1, 1, 1>
    scale <0.620702, 0.677952, 0.482471>
    rotate <0.927577, 14.938337, 16.239573>
    translate  <3.33809, -4.710145, -2.623745>
  }
  texture {
    SulaTex
  }
}
union { // Boot
  object { Sko }
  object { Stovelskaft }
  object { SulaFram }
  object { SulaBak }
  torus { // SulaMellan
    1.5, 0.15  rotate -x*90
    texture {
      SulaTex
    }
    scale <0.385922, 0.243389, 0.164314>
    rotate <-0.030233, 18.004723, 3.198943>
    translate  <2.111912, -5.116051, -2.600135>
  }
  translate  <0.269563, 0.898543, 0.0>
}


cylinder { // Antennknopp
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Textur1
  }
  scale <0.05, 0.05, 0.197029>
  rotate <-14.308112, 39.356396, 10.335978>
  translate  <-5.803847, 3.246126, 2.586405>
}


intersection { // Antenn
  torus { // AntennT
    1.5, 0.01  rotate -x*90
    texture {
      Chrome_Textur1
    }
    scale <1.326079, 1.626593, 0.92921>
    rotate <-108.288513, -28.872107, 22.189232>
    translate  <-3.973846, 3.184519, 1.050865>
  }
  box { // AntennCut
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Chrome_Metal1
    }
    scale <1.208316, 1.0, 3.812264>
    rotate -24.406471*y
    translate  <-5.939347, 2.76083, 0.052079>
  }
}


cylinder { // PinnMuff
  <0,0,1>, <0,0,0>, 1
  texture {
    SulaTex
  }
  scale <0.175078, 0.17772, 1.63175>
  rotate -90.0*x
  translate  <2.72269, -5.035065, -3.048131>
}


cone { // PinnSpike
  <0,0,0>, 0.0, <0,0,1>, 1.0
  texture {
    Chrome_Textur1
  }
  scale <0.101256, 0.104123, 0.7>
  rotate -90.0*x
  translate  <2.722846, -5.690254, -3.047358>
}




box { // LampaBas
  <-1, -1, -1>, <1, 1, 1>
  texture {
    LampTex
  }
  scale <1.0, 1.8, 1.0>
  translate  <-6.357726, 0.0, -3.403328>
}

/*
box { // Bakgrund
  <-1, -1, -1>, <1, 1, 1>
  hollow
  texture {
    Schack
    scale <0.951478, 0.975838, 1.998933>
  translate <0.000000, 0.000000, -0.998736>
  }
  scale 100.0
}
*/

union { // SpikesLeft1
  cone { // Spike5
    <0,0,0>, 1.0, <0,0,1>, 0.0
    texture {
      Chrome_Textur1
    }
    scale <0.1, 0.1, 1.0>
    rotate <-3.912363, 58.04248, 178.114319>
    translate  <-6.852135, -3.284806, -1.51373>
  }
  cone { // Spike6
    <0,0,0>, 1.0, <0,0,1>, 0.0
    texture {
      Chrome_Textur1
    }
    scale <0.1, 0.1, 1.0>
    rotate <-4.590007, 47.109261, 178.756775>
    translate  <-6.099921, -3.352979, -0.625046>
  }
  rotate -7.355598*x
  translate  <0.0, 5.697806, -0.32771>
}


union { // SpikesLeft
  cone { // Spike1
    <0,0,0>, 1.0, <0,0,1>, 0.0
    texture {
      Chrome_Textur1
    }
    scale <0.1, 0.1, 1.0>
    rotate <-3.912363, 58.04248, 178.114319>
    translate  <-6.775412, -2.196441, -1.45175>
  }
  cone { // Spike2
    <0,0,0>, 1.0, <0,0,1>, 0.0
    texture {
      Chrome_Textur1
    }
    scale <0.1, 0.1, 1.0>
    rotate <-4.012837, 46.962029, 178.644501>
    translate  <-6.084603, -2.217281, -0.535206>
  }
}

cylinder
 {<0,0,0>,<0,0,1>,1
  scale <4.7679, 4.10677, 2.6876>
  rotate <0, -13.713, 0>
  translate <-1.22, 0, -6.338>
  pigment{color rgbt 1}
  hollow
  //pigment{color rgb<1,.7,0>}
  halo
   {emitting
    linear
    planar_mapping
    samples 10
    color_map
     {
      [0 color rgbt <1,.7,0,.91>]
      [1 color rgbt<1,.7,0,-1>]
     }
    rotate x*90
   }
 }





merge
{
#declare varv=0
#declare R=seed(6666)
#declare N=60
#while (varv<N)
 #declare A1=2*pi*rand(R)
 sphere
  {<0,0,0>,1
   //pigment{color rgb<.8,.8,1>*rand(R)*1.2}
   pigment{color rgbt<1,1,1,1>}
   halo
    {emitting
     spherical_mapping
     linear
     samples 10
     color_map
      {[0 color rgbt<0,1,0,1>]
       //[0.9 color rgbt<0,1,0,0>]
       [1 color rgbt<0,1,0, varv/50-1 >]
      }
     turbulence .8
     scale .5
    }
   scale .1
   translate<2.0+varv/(N/3),1.2+((sqrt(.25-pow(varv/(N*1.5)-.5,2)))*cos(A1)),6.5+((sqrt(.25-pow(varv/(N*1.5)-.5,2)))*sin(A1))>
   hollow
  }
 #declare varv=varv+1
#end

}


rotate<10,2,25>
scale .5
translate <0,0,2.8>
}




box
 {<-1000,-5.5,-1>,<1000,5.5,.01>
  texture
  {
  pigment
   {color rgb<.87,.75,.55>} //ganska bra: rgb<.92,.75,.5>
  normal
   //{crackle .8 scale .1}
   {granite 1.1 scale .6}
  }
  texture
  {
  //pigment {color rgbt<1,.7,.4,.5>}
  pigment{color rgbt<.87,.75,.55,0.5>}
  normal {dents 1.65 scale 1.75}
  }
 }

/*height_field
 {tga "road22.tga"
  //smooth
  scale <10,-.8,25>
  rotate <-90,0,-90>
  translate<-10,5,-0.1>
 texture
  {
  pigment
   {color rgb<.92,.75,.5>}
  normal
   {crackle .4 scale .07}
  }
  texture
  {
  //pigment {color rgbt<1,.7,.4,.5>}
  pigment{color rgbt<.92,.75,.5,0.5>}
  normal {dents 1.65 scale 1.75}
 }
 //pigment{color White}
 //finish{ambient .7 diffuse .2}
}
*/

//  /*GRUS
#declare Q=seed(5)
#declare QQ=seed(515)
#declare varv1=1
#declare varv2=1

#while (varv2<65)
 #while (varv1<30) //15

   sphere
   {0,.03+rand(Q)*0.1
    scale<rand(Q)+.5,rand(Q)+.5,.5>*.8
    //rotate<rand(Q)*360,rand(Q)*360,rand(Q)*360>
    rotate z*360*rand(Q)
    pigment{color rgb<.9,.8,.55>*(.8+rand(Q)*.4)}
    //pigment{color rgb<.7+rand(Q)*.2,.7+rand(Q)*.1,.5+rand(Q)*.1>} // <- ANDERS
    //scale <1,1,.5>
    translate<-8.2+varv2*.3+rand(Q),10*(-.5+rand(Q))/(varv1),0>
    //normal{bumps scale .05}
    normal{granite 1}
   }

  sphere
   {0,.02+rand(Q)*0.1
    scale<rand(Q)+.5,rand(Q)+.5,rand(Q)*.5+.5>*.8
    //rotate<rand(Q)*360,rand(Q)*360,rand(Q)*360>
    rotate z*360*rand(Q)
    pigment{color rgb<.9,.85,.6>*(.8+rand(Q)*.4)}
    //pigment{color rgb<.7+rand(Q)*.2,.7,.5>*(1+rand(Q)*.3)}
    //pigment{color Green}
    //scale <1,1,.5>
    translate<-8.2,-6,0>
    translate<varv2*.3+rand(Q),10/(varv1)+rand(QQ)*.5,0>
    normal{bumps scale .05}
   }

  sphere
   {0,.02+rand(Q)*0.1
    scale<rand(Q)+.5,rand(Q)+.5,rand(Q)*.5+.5>*.8
    //rotate<rand(Q)*360,rand(Q)*360,rand(Q)*360>
    rotate z*360*rand(Q)
    //pigment{color rgb<.9,.75,.5>*(.8+rand(Q)*.4)}
    pigment{color rgb<.7+rand(Q)*.2,.7,.5>*(1+rand(Q)*.3)}
    //scale <1,1,.5>
    translate<-8.2,5.5,0>
    translate<varv2*.3+rand(Q),-10/(varv1)+rand(QQ)*.5,0>
    normal{bumps scale .05}
   }

  sphere
   {0,.01+rand(Q)*0.07
    scale<rand(Q)+.5,rand(Q)+.5,rand(Q)+.5>
    //rotate<rand(Q)*360,rand(Q)*360,rand(Q)*360>
    rotate z*360*rand(Q)
//    pigment{color rgb<.9,.75,.5>*(.8+rand(Q)*.4)}
    pigment{color rgb<.7+rand(Q)*.2,.7,.5>*(1+rand(Q)*.3)}
    //pigment{color Red}
    translate<-8.2,-5,0>
    translate<varv2*.3+rand(Q),rand(QQ)*10,0>
    normal{bumps scale .05}
   }
  sphere
   {0,.01+rand(Q)*0.07
    scale<rand(Q)+.5,rand(Q)+.5,rand(Q)+.5>
    //rotate<rand(Q)*360,rand(Q)*360,rand(Q)*360>
    rotate z*360*rand(Q)
//    pigment{color rgb<.9,.75,.5>*(.8+rand(Q)*.4)}
    pigment{color rgb<.7+rand(Q)*.2,.7,.5>*(1+rand(Q)*.3)}
    //pigment{color Red}
    translate<-8.2,-5,0>
    translate<varv2*.3+rand(Q),rand(QQ)*10,0>
    normal{bumps scale .05}
   }
  #declare varv1=varv1+1
 #end
 #declare varv1=1
 #declare varv2=varv2+1
#end
//  GRUS */

#include "agr.pov"

/*#declare varv1=0
#while (varv1<15)
object
 {Long
  rotate rand(Q)*360*z
  scale .4+rand(QQ)*.4
  translate <-10+rand(Q)*20,-7+rand(Q)*14,0>}
#declare varv1=varv1+1
#end
*/


// GRS
#declare R=seed(666)
#declare RR=seed(47)
#declare varv1=0
#declare varv2=0
#declare M1=150 //90
#declare M2=150
#while (varv2<M2)
 #while (varv1<M1)
   #declare S=int(rand(RR)*300)
   #if (S=0)
     /*torus                   //Lnga strn
     {25,.025
      pigment{color rgb<.85,1,0>}
      translate -25*x
      rotate <rand(RR)*10, rand(RR)*10, rand(R)*360>
      translate <rand(R)*.15+.15*varv1,rand(R)*.15+.15*varv2,0>
     }*/

     //union
     //{
     object
      {Long
       scale 0.4
     // }
     //sphere
     // {0,0.4
     //  pigment{ForestGreen/2}
     //  finish{ambient .7 diffuse .2}
     // }
     rotate <rand(RR)*10, rand(RR)*10, rand(R)*360>
     translate <-2.8+rand(R)*.15+.15*varv1, 5+rand(R)*.8+.1*varv2, sin(-2*pi*varv2/M2)*4*varv2/M2>
     //y: 5+rand(R)*.15+.15*varv2
     }
   #else
    //union
    //{
     cone
     {<0,0,0>,.025,<0,0,1+rand(R)*7>,0
      rotate <rand(RR)*10, rand(RR)*10, rand(R)*360>
      scale <1,1,0.4>
      scale .8
    // }
    // sphere
    // {0,0.4
      /*pigment{ForestGreen/2}
      finish{ambient .7 diffuse .2} */
    // }
     pigment{color rgb<.6+rand(RR)*.1,.8+rand(RR)*.1,0>/1.1}
     //finish{ambient .2 diffuse .5}
     //pigment{color rgb<0,sin(2*pi*varv2/(M2*10))*5,0>}
     rotate <rand(RR)*10, rand(RR)*10, rand(R)*10>
     translate <-2.8+rand(R)*.25+.25*varv1, 5+rand(R)*.8+.1*varv2, sin(-1.6*pi*varv2/M2)*4*varv2/M2>
     //rtt bra: translate <-2+rand(R)*.25+.25*varv1, 5+rand(R)*.3+.1*varv2, sin(-2*pi*varv2/M2)*4*varv2/M2>
    }
    /*box                     //Korta strn
    {<0,0,0>,<.05,.01,.4+rand(R)*.8>
     pigment{color rgb<rand(R)*.5,rand(R)*.5+.5,.25>}
     rotate <rand(RR)*10, rand(RR)*10, rand(R)*10>
     translate <rand(R)*.15+.15*varv1, rand(R)*.15+.15*varv2, 0>
    }*/
   #end
   #declare varv1=varv1+1
 #end
 #declare varv1=0
 #declare varv2=varv2+1
#end


#declare R=seed(666)
#declare RR=seed(47)
#declare varv1=0
#declare varv2=0
#declare M1=20
#declare M2=50
#while (varv2<M2)
 #while (varv1<M1)
   #declare S=int(rand(RR)*300)
   #if (S=0)
     /*torus                   //Lnga strn
     {25,.025
      pigment{color rgb<.85,1,0>}
      translate -25*x
      rotate <rand(RR)*10, rand(RR)*10, rand(R)*360>
      translate <rand(R)*.15+.15*varv1,rand(R)*.15+.15*varv2,0>
     }*/

     //union
     //{
     object
      {Long
       scale 0.4
     // }
     //sphere
     // {0,0.4
     //  pigment{ForestGreen/2}
     //  finish{ambient .7 diffuse .2}
     // }
     rotate <rand(RR)*10, rand(RR)*10, rand(R)*360>
     translate <-2.5+rand(R)*.15+.15*varv1,-5-rand(R)*.8-.1*varv2, 0>
     //y: 5+rand(R)*.15+.15*varv2
     }
   #else
    //union
    //{
     cone
     {<0,0,0>,.015,<0,0,1+rand(R)*7>,0
      rotate <rand(RR)*10, rand(RR)*10, rand(R)*360>
      scale <1,1,0.4>
      scale .8
    // }
    // sphere
    // {0,0.4
      /*pigment{ForestGreen/2}
      finish{ambient .7 diffuse .2} */
    // }
     pigment{color rgb<.6+rand(RR)*.1,.8+rand(RR)*.1,0>/1.1}
     //finish{ambient .2 diffuse .5}
     //pigment{color rgb<0,sin(2*pi*varv2/(M2*10))*5,0>}
     rotate <rand(RR)*10, rand(RR)*10, rand(R)*10>
     translate <-2.5+rand(R)*.25+.25*varv1, -5-rand(R)*.8-.1*varv2, 0>
     //rtt bra: translate <-2+rand(R)*.25+.25*varv1, 5+rand(R)*.3+.1*varv2, sin(-2*pi*varv2/M2)*4*varv2/M2>
    }
    /*box                     //Korta strn
    {<0,0,0>,<.05,.01,.4+rand(R)*.8>
     pigment{color rgb<rand(R)*.5,rand(R)*.5+.5,.25>}
     rotate <rand(RR)*10, rand(RR)*10, rand(R)*10>
     translate <rand(R)*.15+.15*varv1, rand(R)*.15+.15*varv2, 0>
    }*/
   #end
   #declare varv1=varv1+1
 #end
 #declare varv1=0
 #declare varv2=varv2+1
#end

// GRS */

cylinder
 {<-200,0,0>,<3000,0,0>,4
  scale <1,0.005,1>
  translate y*20
  pigment{color rgb<.6,.8,0>}   // ForestGreen/2}
  finish{ambient .25 diffuse .5}
  //finish{ambient 1 diffuse 0}
 }

sphere
 {0,1
  pigment
   {gradient z
    color_map
     {[0 color rgb<.6,.6,1>]
      [.3 color rgb<.1,.1,.7>]
      [1 color rgb<.1,.1,.7>]
     }
   }
  finish{ambient 1 diffuse 0}
  hollow
  scale 1000005
 }

disc
 {<0,0,0>,x,10
 /* pigment
   {onion
    color_map
     {[0 color rgbt <1,0,1,0>]
      [1 color rgbt<0,1,0,0>]
     }
    scale 10
   }*/
  pigment {color rgbt 1}
  finish
   {refraction 1
    ior 1.2
   }
  normal
   {onion
    normal_map
     {[0 ripples .5 scale .05]
      [1 bumps 0 scale 100]
     }
    scale 10
   }
  translate <4,0,4>
 }

/*
plane
 {x,5
  pigment
   {color rgbt 1}
  normal
   {onion
    normal_map
     {[0 ripples]
      [1 bumps 0 scale 100]
     }
    scale 10
   }
  hollow
 }*/
