
// Persistence of Vision Ray Tracer Scene Description File
// File: magic.pov
// Vers: 3
// Desc: "Transmutracing"--The genesis of a ray-traced image, from graph-paper
//			sketches to final rendered image
// Date: 1 July 1997
// Auth: William Bobzien


// >>>> INCLUDES <<<<
#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "magtexts.inc"
#include "column.inc"
#include "crystal.inc"
#include "frntr.inc"
#include "code.inc"
#include "cauldron.inc"
#include "diagram.inc"

// >>>> LIGHTS <<<<
light_source
{
	<0,80,0>
	color White * .5
	shadowless
}

light_source
{
	<-48,30,58>
	color Orange
	spotlight
	point_at <-48,0,58>
	radius 60
	falloff 65
	tightness 2
}

light_source
{
	<-48,20,53>
	color Orange
	spotlight
	point_at <-78,40,88>
	radius 80
	falloff 90
	tightness 2
}

light_source
{
	<48,30,58>
	color Orange
	spotlight
	point_at <48,0,58>
	radius 60
	falloff 65
	tightness 2
}

light_source
{
	<48,20,53>
	color Orange
	spotlight
	point_at <78,40,88>
	radius 80
	falloff 90
	tightness 2
}

// >>>> CAMERA <<<<
/*
camera
{
	location  <40.0 , 25 , 40.0>
	look_at   <0 , 0 , 35.0>
}
*/
camera
{
	location  <50 , 80.0 , -120.0>
	look_at   <0.0 , 0 , 0.0>
}

// >>>> OBJECTS <<<<

// Graph Paper/Screen/Floor
box
{
	<-60.5,-.0001,-73>,<60.5,0,73>

	texture
    {
    	gradient z
		texture_map
		{
			[ 0.00 Graph             ]
			[ 0.20 Graph             ]
			[ 0.30 Screen            ]
			[ 0.55 Screen            ]
			[ 0.65 Stones            ]
			[ 1.00 Stones            ]
		}
		scale 146
		translate z*-70
   	}
/*
// Test-Render texture
	texture
    {
    	gradient z
		texture_map
		{
			[ 0.00 Graph             ]
			[ 0.20 Graph             ]
			[ 0.30 Screen            ]
			[ 0.55 Screen            ]
			[ 0.65 pigment { Gray }  ]
			[ 1.00 pigment { Gray }  ]
		}
		scale 146
		translate z*-70
   	}
*/
}

object { Column translate <-54,0,64> }
object { Column translate <54,0,64> }

object { Crystal_Ball translate z*64 }

#declare Tilt = 20
#declare Spin = 157
#declare Sign = -1
#include "torch.inc"

#declare Tilt = 20
#declare Spin = -157
#declare Sign = 1
#include "torch.inc"

#declare star_count = 5000
#declare min_distance = 2500
#declare max_distance = 7000
object {#include "starfld.inc"}

object { Bookcase translate <-50.5,0,39> }

object { Worktable translate <-20,0,25> }

object { Code translate <-50,0.125,-20> }

object { Cauldron translate <50,0,40>}

object { Diagram }
